## 3D GIA model using ABAQUS2019: developed at the Technical University of Delft, Astrodynamics and Space Missions. 
## Author: Haiyang Hu

## "Model_data" contains all constants and model data required to build the model. Used both by the generator and iterator.
## Created in 2014 by Haiyang Hu

import numpy as np
import os


## Working directory
Dir=r"/home/username/HetGroteKoppelScript/GIA_Model/"
os.chdir(Dir)
CPUs = 12  #Number of CPU's allocated

## Constants
G=6.6732e-11
pi=np.pi
ka=1000*365.25*24*3600
Deg2Rad = pi/180
## Layer data are defined in file: Layer data.txt in the working directory
flag_lc=1  # Indicator for liquid core, 1 for liquid (core not in the simulation), 0 for solid. 
### fix centre of the model
fixed_point =1

## Model name
Model_name='Earth'
CETOL=1e-5
    
## Time step 
# For coupled model: 5000 years timestep between -120,000 and -20,000, 1000 years timestep between -20,000 and -18,000 years, and 500 years timestep between -18,000 and 0 years
Time = np.array([5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 60.0, 65.0, 70.0, 75.0, 80.0, 85.0, 90.0, 95.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 105.5, 106.0, 106.5, 107.0, 107.5, 108.0, 108.5, 109.0, 109.5, 110.0, 110.5, 111.0, 111.5, 112.0, 112.5, 113.0, 113.5, 114.0, 114.5, 115.0, 116.0, 117.0, 118.0, 119.0, 119.5, 120.0])*ka

##Time[0]=0.001*ka
N_step=Time.shape[0]

## Rampload
Rampload_enabled=1

## Spherical harmonics degree limit, seeds of FEM nodes distance
Degree=90
Degree_initial=5
DisableSH_0_1 = 1 #(1 = yes| 0 = no)
Seeds=200e3
PolarCirkelRadiusDeg = 28.0  #Use doubles!
R_Target_seed = 70E3#70E3 #resolutie in meters
Plane_Target_seed = 30E3#55E3 #resolutie in meters
LM_res = 2 #resolutie factor for earth low
Coarse_Layers = 2 # aantal lagen in earth low
Poi=0.28 #compressibel
alpha = PolarCirkelRadiusDeg*Deg2Rad

Data=np.loadtxt(Dir+'Layer data.txt')  
if Data.size==4:
    N_layer=1  # Number of layers
    Radius=np.array([Data[0]])
    Density=np.array([Data[1]])
    Density=np.hstack([Density,0,0])
    Y_mod=np.array([Data[2]])*(1+Poi)*2
    Vis=np.array([Data[3]])    
else:    
    N_layer=Data.shape[0]  # Number of layers
    Radius=Data[:,0]
    Density=Data[:,1]
    Density=np.hstack([Density,0])
    if Poi >=0.495:
        Y_mod=Data[:,2]*3
    else:
        Y_mod=Data[:,2]*(1+Poi)*2
    Vis=Data[:,3]

Gacc=np.zeros(N_layer) # Gravitational acceleration
for i in range(N_layer):
    Gacc[i]=(4.0/3*G*pi*Radius[0]**3*Density[0]+np.sum([4.0/3*G*pi*Density[j+1]*(Radius[j+1]**3-Radius[j]**3) for j in range(i) ]))/Radius[i]**2
   
### Keep grid consistent
DataIce=np.loadtxt('DataIce_in.dat')
grid1=DataIce.shape[1]/2

### Radius of polar cirkel
R_PolCir = PolarCirkelRadiusDeg * Radius[N_layer-1]