! File name: configuration_module.f90
!
! Copyright (C) 2016 Thomas Reerink.
!
! This file is part of the ICEDYN-package
!
! IMAU, Utrecht University, The Netherlands
!

MODULE configuration_module
      IMPLICIT NONE

      ! PRECISION
      ! =========
      ! The kind of real numbers used by default throughout the program.
      ! Reals should be declared as:
      !
      ! REAL(dp) :: example
      !  or
      ! REAL(KIND=dp) :: example
      !
      ! dp must be a PARAMETER
      INTEGER, PARAMETER :: dp        = KIND(1.0D0)     ! Kind of double precision numbers.

      INTEGER, PARAMETER :: N_ignore  = 2 * 100         ! The size of the array containing the ignored ranges
      INTEGER, PARAMETER :: MNF       = 100             ! The Maximum Number of Fields which can be mapped simultaneously
      INTEGER, PARAMETER :: MND       =  -7             ! The Maximum Number of Dimensions of the simultaneously mapped fields times minus one
      INTEGER, PARAMETER :: N_curves  = 100             ! The maximum Number of detected course grid point contribututions for the flow line curve profile


   ! CONFIG VARIABLES:
   !==================
   ! Variables which are set eventually by the read_config_file subroutine:

      ! GRID SIZES AND GRID SPACING
      !============================
      ! Number of grid points NX and NY and the spacing dx and dy (in m) in x and y-direction, number of grid points for the
      ! linear vertical axis NZL (in the positive direction) and the stepsize z_step (in m) for making a cross section:
      INTEGER                                    :: NX_config     =    100                                                                                   ! config variable
      INTEGER                                    :: NY_config     =      1                                                                                 ! config variable
      REAL(dp)                                   :: dx_config     = 20000.0_dp                                                                              ! config variable
      REAL(dp)                                   :: dy_config     = 20000.0_dp                                                                              ! config variable
      INTEGER                                    :: NZL_config    =    55                                                                                   ! config variable
      REAL(dp)                                   :: z_step_config =   150.0_dp                                                                              ! config variable
      ! Number of grid points in vertical direction for thermodynamics within bedrock, if k is a counter
      ! through the vertical layers, k=1 at the bottom of the bedrock and k=NZR at the ice-bedrock inteface:
      INTEGER                                    :: NZR_config    =     6                                                                                   ! config variable
      ! Grid spacing in meters for vertical direction in underlying bedrock:
      REAL(dp)                                   :: dzr_config    =   300.0_dp                                                                              ! config variable

      ! Number of grid points in vertical direction for thermodynamics in ice sheet, if k is a counter
      ! through the vertical layers, k=1 at the surface and k=NZ at the bottom of the ice sheet:
      INTEGER                                    :: NZ_config     =    15                                                                                   ! config variable
      ! Relative grid spacing in vertical direction in ice sheet. If k is a counter through the vertical layers, k=1
      ! at the surface corresponding with zeta=0, and k=NZ at the bottom of the ice sheet corresponding with zeta=1:
      ! This config variable zeta_config is declared as a large array, because fortran does not allow a CONFIG/NAMELIST
      ! variable to be ALLOCATABLE, only the C%NZ first elements of this array will be used and have to be specified
      ! in the config file.
      REAL(dp), DIMENSION(210), SAVE             :: zeta_config = &                                                                                         ! config variable
       (/0.00_dp, 0.10_dp, 0.20_dp, 0.30_dp, 0.40_dp, 0.50_dp, 0.60_dp, 0.70_dp, 0.80_dp, 0.90_dp, 0.925_dp, 0.95_dp, 0.975_dp, 0.99_dp, 1.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp  /)


      ! GCM grid sizes:
      INTEGER                                    :: NLON_config = 128                                                                                       ! config variable
      INTEGER                                    :: NLAT_config = 64                                                                                        ! config variable


      ! TIME
      ! ====
      ! Length of time integration: from start time to end time:
      REAL(dp)                                   :: start_time_of_run_config = 0.0_dp                                                                       ! config variable
      REAL(dp)                                   :: end_time_of_run_config   = 0.0_dp                                                                       ! config variable

      ! The variables below are related to the dynamic time stepping:
      LOGICAL                                    :: dynamic_time_step_addaption_config     = .FALSE.                                                        ! config variable
      LOGICAL                                    :: dynamic_time_step_sheet_based_config   = .FALSE.                                                        ! config variable
      REAL(dp)                                   :: likely_mean_dynamic_time_step_config   = 1.0_dp                                                         ! config variable
      REAL(dp)                                   :: minimal_critical_time_step_config      = 0.0001_dp                                                      ! config variable
      REAL(dp)                                   :: maximal_critical_time_step_config      = 100.0_dp                                                       ! config variable
      REAL(dp)                                   :: time_step_scaler_config                = 1.0_dp                                                         ! config variable

      ! Basic time step (in years) of the model:
      REAL(dp)                                   :: dt_config                              = 1.0_dp                                                         ! config variable

      ! Time step (in years) used for thermodynamics:
      REAL(dp)                                   :: dt_thermo_config                       = 6.0_dp                                                         ! config variable

      ! Time step (in years) used for velocity:
      REAL(dp)                                   :: dt_shelf_velocity_config               = 6.0_dp                                                         ! config variable

      ! Time step (in years) for bedrock adjustment:
      REAL(dp)                                   :: dt_bedrock_config                      = 100.0_dp                                                       ! config variable

      ! Time step (in years) for writing restart files:
      REAL(dp)                                   :: dt_restart_config                      = 100.0_dp                                                       ! config variable

      ! Time step (in years) for writing time recording variables:
      REAL(dp)                                   :: dt_recording_config                    = 10.0_dp                                                        ! config variable

      ! Time step (in years) for calculation of topographic properties:
      REAL(dp)                                   :: dt_sort_Hs_config                      = 100.0_dp                                                       ! config variable

      ! Time step (in years) for surface mass balance calculation:
      REAL(dp)                                   :: dt_smb_config                          = 1.0_dp                                                         ! config variable

      ! Time step (in days) for gravitational snow transport:
      REAL(dp)                                   :: dt_gravitational_snow_transport_config = 30.0_dp                                                        ! config variable

      ! Time step (in years) for iterative reconstruction of glacier bed:
      REAL(dp)                                   :: dt_glacier_bed_iteration_config        = 100.0_dp                                                       ! config variable


      ! OUTPUT/RESTART FILES
      ! ====================
      ! The record number for which the fields are taken as the initial fields:
      INTEGER                                    :: starting_record_number_config = 1                                                                       ! config variable

      ! Name of the netcdf initial input restart file:
      CHARACTER(LEN=256)                         :: initial_restart_filename_config = 'initial-restart-no-name.nc'                                          ! config variable

      ! Name of the netcdf initial input key_fields file:
      CHARACTER(LEN=256)                         :: initial_key_fields_filename_config = 'initial-key-fields-no-name.nc'                                    ! config variable

      ! Name of the netcdf smb gradients input restart file:
      CHARACTER(LEN=256)                         :: smb_gradients_filename_config = 'smb-gradients-no-name.nc'                                              ! config variable

      ! Name of the netcdf refreezing gradients input restart file:
      CHARACTER(LEN=256)                         :: rfr_gradients_filename_config = 'rfr-gradients-no-name.nc'                                              ! config variable

      ! Name of the netcdf runoff gradients input restart file:
      CHARACTER(LEN=256)                         :: runoff_gradients_filename_config = 'runoff-gradient-no-name.nc'                                         ! config variable

      ! Name of the forcing file (ascii), containing a time-record of sealevels and the temperature deviation:
      CHARACTER(LEN=256)                         :: forcing_filename_config = 'forcing-file-no-name.txt'                                                    ! config variable

      ! Name of the latitude-longitude file (ascii), containing the latitudes and longitudes of each grid point:
      CHARACTER(LEN=256)                         :: latitude_longitude_filename_config = 'latitude-longitude-file-no-name.nc'                               ! config variable

      ! Name of the insolation file (ascii), containing a time-record of monthly insolation as function of latitude (1 degree resolution):
      CHARACTER(LEN=256)                         :: insolation_filename_config = 'insolation-file-no-name.txt'                                              ! config variable

      ! Name of the insolation file (ascii), containing a time-record of monthly insolation as function of latitude (1 degree resolution):
      CHARACTER(LEN=256)                         :: ascii_input_data_filename_config = 'ascii-input-data-file-no-name.txt'                                  ! config variable

      ! Name of the forcing_fields netcdf file which is read during running:
      CHARACTER(LEN=256)                         :: forcing_fields_filename_config = 'forcing-fields-file-no-name.nc'                                       ! config variable

      ! Name of the gia netcdf file which is read during running:
      CHARACTER(LEN=256)                         :: gia_filename_config = 'gia-file-no-name.nc'                                                             ! config variable

      ! Name of the isostatic equilibrium netcdf file which is read during running: 
      CHARACTER(LEN=256)                         :: isostatic_equilibrium_filename_config  = 'isostatic-equilibrium-no-name.nc'                             ! config variable

      ! Name of the sst_fields netcdf file which is read during running:
      CHARACTER(LEN=256)                         :: sst_fields_filename_config = 'sst-fields-file-no-name.nc'                                               ! config variable

      ! Name of the forcing_fields netcdf file which is read during running:
      CHARACTER(LEN=256)                         :: reference_surface_height_filename_config = 'reference_surface_height-file-no-name.nc'                   ! config variable

      ! Name of the key_fields netcdf file which is written during running:
      CHARACTER(LEN=256)                         :: key_fields_filename_config = 'key_fields-no-name.nc'                                                    ! config variable

      ! Name of the restart netcdf file which is written during running:
      CHARACTER(LEN=256)                         :: restart_filename_config = 'restart-no-name.nc'                                                          ! config variable

      ! Name of netcdf file which contains the time recorded variables:
      CHARACTER(LEN=256)                         :: recording_filename_config = 'recording-no-name.nc'                                                      ! config variable

      ! Name of the help_fields netcdf file which is written during running:
      CHARACTER(LEN=256)                         :: help_fields_filename_config = 'help_fields-no-name.nc'                                                  ! config variable

      ! Name of the extra_fields netcdf file which is written during running:
      CHARACTER(LEN=256)                         :: extra_fields_filename_config = 'extra_fields-no-name.nc'                                                ! config variable

      ! Name of the DEM file which is read during bed reconstruction initialisation 
      CHARACTER(LEN=256)                         :: filename_DEM_config  = 'input_DEM.txt'                                                                         ! config variable

      ! Name of the MASK file which is read during bed reconstruction initialisation 
      CHARACTER(LEN=256)                         :: filename_MASK_config  = 'input_MASK.txt'                                                                       ! config variable
      
      ! Name of the SMB file which is read during bed reconstruction initialisation 
      CHARACTER(LEN=256)                         :: filename_SMB_config  = 'input_SMB.txt'
      
      ! Name of the VEL file which is read during bed reconstruction initialisation 
      CHARACTER(LEN=256)                         :: filename_VEL_config  = 'input_VEL.txt'                                                                            ! config variable
      
      ! Name of the BED file which is read during bed reconstruction initialisation 
      CHARACTER(LEN=256)                         :: filename_BED_config  = 'input_BED.txt' 
      
      ! Name of the Relaxationparameter file which is read during bed reconstruction initialisation 
      CHARACTER(LEN=256)                         :: filename_K_config  = 'input_K.txt' 

      ! Choices about which netcdf files will be created during the run:
      LOGICAL                                    :: enable_restart_file_config                       = .TRUE.                                               ! config variable
      LOGICAL                                    :: enable_recording_file_config                     = .TRUE.                                               ! config variable
      LOGICAL                                    :: enable_help_fields_file_config                   = .FALSE.                                              ! config variable
      LOGICAL                                    :: enable_extra_netcdf_file_config                  = .FALSE.                                              ! config variable
      LOGICAL                                    :: synchronize_netcdf_writing_config                = .TRUE.                                               ! config variable
      LOGICAL                                    :: protect_file_overwriting_config                  = .TRUE.                                               ! config variable
      LOGICAL                                    :: enable_color_messaging_in_terminal_config        = .TRUE.                                               ! config variable

      INTEGER                                    :: which_recording_fields_config                    = 40                                                   ! config variable
      INTEGER                                    :: which_help_fields_config                         = 38                                                   ! config variable
      INTEGER, DIMENSION(N_ignore)               :: ignore_some_recording_fields_config              = 0                                                    ! config variable
      INTEGER, DIMENSION(N_ignore)               :: ignore_some_help_fields_config                   = 0                                                    ! config variable
      LOGICAL                                    :: use_grid_units_in_dimension_config               = .FALSE.                                              ! config variable
      LOGICAL                                    :: label_netcdf_fields_with_number_config           = .TRUE.                                               ! config variable
      LOGICAL                                    :: use_double_instead_of_float_in_netcdf_config     = .FALSE.                                              ! config variable

      ! GEOTHERMAL HEAT FLUX
      ! ====================
      LOGICAL                                    :: monotonic_geothermal_heat_flux_config            = .TRUE.                                               ! config variable   ! Geothermal Heat flux [J m^-2 s^-1] Sclater et al. (1980), see Huybrechts p. 106
      CHARACTER(LEN=256)                         :: geothermal_heat_flux_file_name_config            = 'geothermal-heat-flux-no-name.nc'                    ! config variable
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: geothermal_heat_flux_field_name_config                                                                  ! config variable

      ! MEAN CLIMATE FORCING
      ! ====================
      ! Total length of the climate record (cotaining sealevel and surface temperature):
      INTEGER                                    :: size_climate_record_config                       = 2201                                                 ! config variable
      INTEGER                                    :: choice_forcing_config                            = 1                                                    ! config variable
      REAL(dp)                                   :: constant_sealevel_deviation_config               = 0.0_dp                                               ! config variable
      REAL(dp)                                   :: constant_temperature_deviation_config            = 0.0_dp                                               ! config variable
      INTEGER                                    :: choice_insolation_forcing_config                 = 1                                                    ! config variable
      INTEGER                                    :: size_insolation_record_config                    = 1                                                    ! config variable
      INTEGER                                    :: constant_insolation_month_config                 = 6                                                    ! config variable   ! Months: 1 = January
      INTEGER                                    :: constant_insolation_latitude_config              = 65                                                   ! config variable   ! Degrees North


      ! MINIMUM ICE THICKNESS AND MAXIMUM CHANGE PER TIME STEP
      ! ======================================================
      REAL(dp)                                   :: Hi_min_config                                    = 0.1_dp                                               ! config variable
      REAL(dp)                                   :: maximum_dHi_change_per_year_config               = 100.0_dp                                             ! config variable


      REAL(dp)                                   :: D_uv_3D_cutoff_config                            = -1.0E5_dp                                            ! config variable


      ! ADHOC AREA MASKING FOR THE TOTAL ICE VOLUME
      ! ===========================================
      CHARACTER(LEN=256)                         :: area_mask_for_total_ice_volume_config            = 'include-entire-grid'                                ! config variable

      ! SPIN UP
      ! =======
      LOGICAL                                    :: do_temperature_spin_up_config   = .FALSE.                                                               ! config variable
      LOGICAL                                    :: determine_MB_equilibrium_config = .FALSE.                                                               ! config variable


      ! SHELF MUMPS USE
      ! ===============
      LOGICAL                                    :: choice_use_mumps_config = .FALSE.                                                                       ! config variable
      INTEGER                                    :: number_of_explicit_shelf_iterations_config = 6                                                          ! config variable
      INTEGER, DIMENSION(5)                      :: mumps_message_level_config = (/ 6, 2, 2, 3, 0 /)                                                        ! config variable


      ! SHELF
      ! =====
      LOGICAL                                    :: shelf_surface_gradient_one_sided_discretized_config = .TRUE.                                            ! config variable   ! If TRUE the shelf routines use the one sided discretized surface gradient for the shelf routines
      LOGICAL                                    :: include_shelf_dynamics_config = .FALSE.                                                                 ! config variable
      INTEGER                                    :: maximum_number_gauss_seidel_iterations_config = 833                                                     ! config variable
      REAL(dp)                                   :: gauss_seidel_over_relaxation_parameter_config = 1.6_dp                                                  ! config variable
      REAL(dp)                                   :: residual_in_gauss_seidel_convergence_criterion_config = 0.5_dp                                          ! config variable

      LOGICAL                                    :: initial_velocity_spin_up_config = .FALSE.                                                               ! config variable

      ! BEDROCK
      ! =======
      LOGICAL                                    :: adjusting_bedrock_config = .TRUE.                                                                       ! config variable
      LOGICAL                                    :: assume_isostatic_equilibrium_at_start_config = .TRUE.                                           ! config variable

      LOGICAL                                    :: glacier_bed_iteration_run_config = .FALSE.                                                              ! config variable
      INTEGER                                    :: maximum_number_of_bed_iterations_config = 30                                                            ! config variable
      REAL(dp)                                   :: minimal_value_mean_residual_bed_iteration_config = 4.0_dp                                               ! config variable
      REAL(dp)                                   :: sealevel_for_reference_load_bedrock_config = 0.0_dp                                                     ! config variable


      ! FLUX SCHEME
      ! ===========
      INTEGER                                    :: choice_flux_scheme_config = 1                                                                           ! config variable
      REAL(dp)                                   :: ice_flux_intervention_allowed_period_config = 1.E9_dp                                                   ! config variable
      INTEGER                                    :: choice_surface_derivatives_scheme_config = 1                                                            ! config variable
      INTEGER                                    :: choice_bottom_derivatives_scheme_config = 1                                                             ! config variable


      ! SLIDING
      ! =======
      REAL(dp)                                   :: reduced_Ti_pmp_threshold_for_sliding_config = 0.1_dp                                                    ! config variable
     !CHARACTER(LEN=256)                         :: choice_sliding_method_config = 'no-sliding-method-specified'                                            ! config variable
      CHARACTER(LEN=256)                         :: choice_sliding_method_config = 'no-sliding'                                                             ! config variable
      LOGICAL                                    :: include_sliding_heatflux_config = .FALSE.                                                               ! config variable
      REAL(dp)                                   :: factor_mininimum_sliding_load_config = 0.1_dp                                                           ! config variable


      ! PARAMETERS IN SSA APROACH
      ! =========================
      REAL(dp)                                   :: dummy_delta_v_config                             =       0.01_dp                                        ! config variable   ! to prevent a zero basal drag (beta_base), same as Bueler & Brown, 2009 (the PISM model)
      REAL(dp)                                   :: q_plastic_config                                 =       0.30_dp                                        ! config variable   ! Parameter used for basal stress (inverse of m_flow)
      REAL(dp)                                   :: u_threshold_yield_stress_scaling_config          =   100.0_dp                                           ! config variable   ! Scaling of the yield stress to get the correct unit (function of q_plastic) (m/s)
      REAL(dp)                                   :: scaling_Hb_minimal_friction_angle_config         = -1000.0_dp                                           ! config variable   ! maximum scale height for the friction angle (m)
      REAL(dp)                                   :: scaling_Hb_maximal_friction_angle_config         =     0.0_dp                                           ! config variable   ! minimum scale height for the friction angle (m)
      REAL(dp)                                   :: minimal_friction_angle_config                    =     5.0_dp                                           ! config variable   ! minimum value of the friction angle for calculating the basal yield stress
      REAL(dp)                                   :: maximal_friction_angle_config                    =    20.0_dp                                           ! config variable   ! maximum value of the friction angle for calculating the basal yield stress


      ! MASS BALANCE
      ! ============
      CHARACTER(LEN=256)                         :: choice_smb_method_config                             = 'no-smb-method-specified'                        ! config variable
      INTEGER                                    :: choice_bmb_model_config                              = 3                                                ! config variable
      REAL(dp), DIMENSION(4)                     :: gauge_points_basal_melt_config                       = (/ 400.0_dp, 0.1_dp,  1000.0_dp, 4.0_dp /)       ! config variable
      REAL(dp)                                   :: basal_sheet_melt_config                              = 0.0_dp                                           ! config variable
      REAL(dp)                                   :: basal_shelf_melt_config                              = 2.0_dp                                           ! config variable
      REAL(dp)                                   :: grounding_line_melt_config                           = 0.0_dp                                           ! config variable
      LOGICAL                                    :: apply_remaining_mass_balance_config                  = .FALSE.                                          ! config variable
      LOGICAL                                    :: energetic_bottom_melt_config                         = .FALSE.                                          ! config variable
      INTEGER                                    :: number_of_potential_bottom_melt_layers_config                                                           ! config variable
      REAL(dp)                                   :: maximum_bottom_melt_config                           = 1.0_dp                                           ! config variable
      REAL(dp)                                   :: calve_thickness_sheet_config                         = 20.0_dp                                          ! config variable
      REAL(dp)                                   :: calve_thickness_shelf_config                         = 20.0_dp                                          ! config variable
      REAL(dp)                                   :: initial_time_minimal_calving_config                  = 0.0_dp                                           ! config variable
      LOGICAL                                    :: apply_calving_config                                 = .FALSE.                                          ! config variable
      LOGICAL                                    :: choice_smooth_MB_config                              = .FALSE.                                          ! config variable

      REAL(dp), DIMENSION(14)                    :: gaussian_profile_massbalance_config =    &                                                              ! config variable
                                                  (/1.0_dp, -2.0_dp, 2.5_dp, 0.5_dp, 3.0_dp, &
                                                                     0.0_dp, 1.0_dp, 1.0_dp, &
                                                                     0.0_dp, 1.0_dp, 1.0_dp, &
                                                                     0.0_dp, 1.0_dp, 1.0_dp/)
      LOGICAL                                    :: include_gravitational_snow_transport_config          = .FALSE.                                          ! config variable   ! include gravitational snow transport (avalanches) routine
      LOGICAL                                    :: only_calculate_smb_config                            = .FALSE.                                          ! config variable   ! option to exclude ice dynamics from the model calculation, if only mass balance has to be tested
      LOGICAL                                    :: use_mask_glacier_smb_when_calculate_smb_config       = .FALSE.                                          ! config variable   ! calculate the mass balance only on grid points with ice thickness larger than minimal ice thickness, including a buffer of 5 grid points.
      REAL(dp)                                   :: south_angle_grid_config                              = ACOS(0.0_dp)                                     ! config variable   ! orientation of grid, default is x-axis towards EAST and y-axis towards NORTH
      INTEGER                                    :: N_horizon_angles_config                              = 64                                               ! config variable   ! number of angles used in calculation of horizon angles
      INTEGER                                    :: start_day_smb_config                                 = 274                                              ! config variable   ! day of the year on which the annual smb calculations start
      INTEGER                                    :: number_of_time_steps_per_day_config                  = 24                                               ! config variable   ! number of time steps per day used in calculation of smb in  glacier_smb_simple_EB routine
      REAL(dp)                                   :: temperature_dependent_flux_parameter_c0_config       = -30.0_dp                                         ! config variable   ! intercept parameter in temperature dependent energy flux parameterization in calculation of smb in  glacier_smb_simple_EB routine
      REAL(dp)                                   :: temperature_dependent_flux_parameter_c1_config       =  30.0_dp                                         ! config variable   ! slope parameter in temperature dependent energy flux parameterization in calculation of smb in  glacier_smb_simple_EB routine
      REAL(dp)                                   :: temperature_dependent_flux_parameter_Tfluxmin_config = -25.0_dp                                         ! config variable   ! minimum flux parameter in temperature dependent energy flux parameterization in calculation of smb in  glacier_smb_simple_EB routine
      LOGICAL                                    :: write_smb_fields_to_extra_help_fields_config         = .FALSE.                                          ! config variable   ! write additional smb-model output fields to netcdf file in glacier_smb_simple_EB routine
      INTEGER                                    :: number_of_time_steps_per_write_interval_config       = 24                                               ! config variable   ! number of time steps until additional smb-model output is written to netcdf file in glacier_smb_simple_EB routine
      CHARACTER(LEN=256)                         :: meteo_input_file_smb_model_config                    = 'meteo-input-file-no-name.txt'                   ! config variable   ! name of the input file used in the glacier_smb_simple_EB routine
      CHARACTER(LEN=256)                         :: precipitation_index_map_input_file_config            = 'precipitation-index-map-input-file-no-name.txt' ! config variable   ! name of the input file used in the glacier_smb_simple_EB routine for a spatially distributed precipitation index map.
      INTEGER                                    :: N_lines_meteo_input_file_smb_config                  = 0                                                ! config variable   ! number of lines in the meteo input file (standard format, without first additional info lines!!) of the smb model
      REAL(dp)                                   :: spinup_time_config                                   = 0.0_dp 

      ! INSOLATION-TEMPERATURE MELT MODEL
      ! =================================
      REAL(dp)                                   :: albedo_water_config                                  = 0.10_dp                                          ! config variable   ! Albedo of ocean water
      REAL(dp)                                   :: albedo_soil_config                                   = 0.20_dp                                          ! config variable   ! Albedo of bare rock
      REAL(dp)                                   :: albedo_ice_config                                    = 0.50_dp                                          ! config variable   ! Albedo of (glacier) ice (changed from 0.45 to 0.50) (55?)
      REAL(dp)                                   :: albedo_snow_config                                   = 0.85_dp                                          ! config variable   ! Albedo of snow (changed from 0.80 to 0.85)

      REAL(dp)                                   :: ablation_constant_insolation_config                  = 0.513_dp                                         ! config variable
      REAL(dp)                                   :: ablation_constant_temperature_config                 = 10._dp                                           ! config variable
      REAL(dp)                                   :: ablation_constant_config                             = 32._dp                                           ! config variable

      ! SUB SHELF OCEANIC MELT PARAMETERS
      !==================================
      REAL(dp)                                   :: c_0_specific_heat_ocean_config                       = 3974._dp                                         ! config variable   ! Specific heat capacity of the ocean mixed layer [J kg-1 K-1]
      REAL(dp)                                   :: mean_ocean_surface_temperature_config                = 271.46_dp                                        ! config variable   ! Thermal exchange velocity [m s-1]
      REAL(dp)                                   :: thermal_exchange_velocity_config                     = 1.0E-4_dp                                        ! config variable   ! Thermal exchange velocity [m s-1]
      REAL(dp)                                   :: subshelf_melt_factor_for_protected_shelves_config    = 5E-3_dp                                          ! config variable   ! Scaling factor for submarine melting of protected shelves [-]
      REAL(dp)                                   :: subshelf_melt_factor_for_exposed_shelves_config      = 5E-2_dp                                          ! config variable   ! Scaling factor for submarine melting of exposed shelves [-]
      REAL(dp)                                   :: subshelf_melt_factor_for_deep_ocean_config           = 5E-1_dp                                          ! config variable   ! Scaling factor for submarine melting of deep ocean [-]

      ! CONVERT GIA ASCII FILES
      !========================
      REAL(dp)                                   :: time_of_gia_ascii_record_config                        = 0._dp                                          ! config variable


      ! Concentration calculation, the default 1 performs no calculation:
      INTEGER                                    :: choice_concentration_config = 1                                                                         ! config variable


      ! TEMPERATURE
      ! ===========
      CHARACTER(LEN=256)                         :: choice_Ts_method_config = 'no-Ts-method-specified'                                                      ! config variable
      REAL(dp)                                   :: mean_Ts_forcing_at_sealevel_config = 270.0_dp                                                           ! config variable
      INTEGER                                    :: choice_temperature_model_config = 1                                                                     ! config variable
      REAL(dp)                                   :: frictional_heating_scale_factor_config = 1.0_dp                                                         ! config variable
      LOGICAL                                    :: include_horizontal_diffusion_config = .FALSE.                                                           ! config variable
      INTEGER                                    :: choice_temperature_derivatives_scheme_config = 2                                                        ! config variable
      INTEGER                                    :: choice_thermodynamics_scheme_config = 1                                                                 ! config variable
      INTEGER                                    :: choice_3D_velocity_scheme_config = 2                                                                    ! config variable
      LOGICAL                                    :: fixed_Ti_at_shelf_bottom_config = .TRUE.                                                                ! config variable
      LOGICAL                                    :: linear_temperature_at_shelf_config = .TRUE.                                                             ! config variable
      LOGICAL                                    :: include_refreezing_term_via_Ts_config = .FALSE.                                                         ! config variable
      REAL(dp)                                   :: Ti_fixed_config = 253.15_dp                                                                             ! config variable
      REAL(dp)                                   :: delta_Ti_below_T_pmp_config = 0.0_dp                                                                    ! config variable
      REAL(dp)                                   :: registration_limit_low_Ti_config = 0.0_dp                                                               ! config variable


      ! EISMINT benchmark
      !==================
      LOGICAL                                    :: eismint_case_config = .FALSE.                                                                           ! config variable
      CHARACTER                                  :: choice_eismint_expt_config = 'A'                                                                        ! config variable
      REAL(dp), DIMENSION(6)                     :: eismint_parameters_config =  (/ 238.15_dp, 450.0_dp, 0.01_dp, 0.5_dp, 750.0_dp, 750.0_dp /)             ! config variable

      ! MISMIP benchmark
      !==================
      LOGICAL                                    :: mismip_case_config = .FALSE.                                                                            ! config variable
      LOGICAL                                    :: mismip_no_shelf_config = .FALSE.                                                                        ! config variable
      LOGICAL                                    :: schoof_flux_config = .FALSE.                                                                            ! config variable

      ! CROSS SECTION
      ! =============
      CHARACTER(LEN=128)                         :: one_dimensional_experiment_config                = 'no'                                                 ! config variable
      INTEGER                                    :: x_fixed_config                                   = 140                                                  ! config variable
      INTEGER                                    :: y_fixed_config                                   = 140                                                  ! config variable
      REAL(dp)                                   :: lowest_z_of_cross_section_config                 = 0.0_dp                                               ! config variable
      REAL(dp), DIMENSION(5)                     :: fake_value_for_bedrock_config                    = (/ 3.0_dp, 3.0_dp, 3.0_dp, 200.0_dp , 0.0_dp/)       ! config variable
      REAL(dp), DIMENSION(5)                     :: fake_value_for_atmosphere_config                 = (/ 2.0_dp, 2.0_dp, 2.0_dp, 275.0_dp , 0.0_dp/)       ! config variable
      REAL(dp), DIMENSION(5)                     :: fake_value_for_ocean_config                      = (/ 1.0_dp, 1.0_dp, 1.0_dp, 271.15_dp, 0.0_dp/)       ! config variable

      INTEGER                                    :: synthetic_experiment_number_config               = 220                                                  ! config variable
      CHARACTER(LEN=256)                         :: experiment_label_config                          = 'no-label'                                           ! config variable


      ! FULL STOKES
      ! ===========
      INTEGER                                    :: choice_surface_bc_config                         = 1                                                    ! config variable
      INTEGER                                    :: choice_shelf_bottom_bc_config                    = 2                                                    ! config variable
      LOGICAL                                    :: physic_boundary_conditions_config                = .FALSE.                                              ! config variable
      LOGICAL                                    :: physic_bc_for_calving_config                     = .FALSE.                                              ! config variable
      LOGICAL                                    :: lateral_friction_config                          = .FALSE.                                              ! config variable
      LOGICAL                                    :: write_matrix_rhs_format_config                   = .FALSE.                                              ! config variable
      INTEGER                                    :: choice_velocity_derivatives_scheme_config        = 2                                                    ! config variable  ! The choice concerning the scheme with which dU_dx, dU_dy, ..., dW_dzeta are calculated
      LOGICAL                                    :: take_dEta_terms_implicit_config                  = .FALSE.                                              ! config variable
      INTEGER                                    :: choice_Eta_derivatives_config                    = 1                                                    ! config variable
      INTEGER                                    :: number_of_Eta_iterations_config                  = 1                                                    ! config variable
      LOGICAL                                    :: differentiate_stress_regime_config               = .FALSE.                                              ! config variable  ! Differentiate in stress regimes by taking different simplification factors for sheet and shelf

      REAL(dp), DIMENSION(0:6)                   :: simplification_coefficients_config               = (/ 1._dp, 1._dp, 1._dp, 1._dp, 1._dp, 1._dp, 1._dp/) ! config variable
      REAL(dp), DIMENSION(0:6)                   :: simplification_coeffi_sheet_config               = (/ 1._dp, 0._dp, 0._dp, 1._dp, 1._dp, 0._dp, 0._dp/) ! config variable
      REAL(dp), DIMENSION(0:6)                   :: simplification_coeffi_shelf_config               = (/ 1._dp, 1._dp, 1._dp, 0._dp, 0._dp, 1._dp, 1._dp/) ! config variable

      REAL(dp), DIMENSION(5)                     :: bottom_sliding_parameters_config                 = (/ 0._dp, 80.0_dp, 0.666_dp, 160.0_dp, 0.666_dp /)   ! config variable
      !                                                                                                (  y/n=0  i_down  rate_down  i_up    rate_up   )     ! config variable


      ! SHELF PARAMETERIZATION
      ! ======================
      LOGICAL                                    :: parameterized_shelf_config                       = .FALSE.                                              ! config variable
      REAL(dp)                                   :: p_config                                         = 1.5_dp                                               ! config variable
      REAL(dp)                                   :: R_influence_config                               = 400000.0_dp                                          ! config variable
      INTEGER                                    :: Nslices_config                                   = 36                                                   ! config variable


      ! OUTPUT MESSAGES
      ! ===============
      LOGICAL                                    :: choice_write_message_config                      = .TRUE.                                               ! config variable
      LOGICAL                                    :: launch_ncview_config                             = .FALSE.                                              ! config variable


      ! TEST/DEBUG VARIABLES
      ! ====================
      INTEGER                                    :: testing_integer_config                           = 0                                                    ! config variable
      REAL(dp)                                   :: testing_real_dp_config                           = 0.0_dp                                               ! config variable


      ! FORCING FIELDS
      ! ==============
      INTEGER                                    :: forcing_record_config                            = 1                                                    ! config variable
      INTEGER           , DIMENSION(3)           :: forcing_record_range_config                      = (/ 1, 1, 1 /)                                        ! config variable
      INTEGER                                    :: number_of_forcing_fields_config                  = 2                                                    ! config variable
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: forcing_field_name_config                                                                               ! config variable
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: forcing_field_unit_config                                                                               ! config variable
      CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: forcing_field_longname_config                                                                           ! config variable


      ! LATITUDE LONGITUE FIELDS
      ! ========================
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: latitude_longitude_field_name_config                                                                    ! config variable
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: latitude_longitude_field_unit_config                                                                    ! config variable
      CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: latitude_longitude_field_longname_config                                                                ! config variable


      ! SMB GRADIENTS VARIABLES
      ! =======================
      INTEGER                                    :: number_of_input_fields_config                    = 3                                                    ! config variable
      INTEGER                                    :: number_of_smb_gradients_fields_config            = 20                                                   ! config variable
      INTEGER                                    :: n_pos_min_config                                 = 100                                                  ! config variable
      INTEGER                                    :: n_neg_min_config                                 = 100                                                  ! config variable
      INTEGER                                    :: n_runoff_min_config                              = 100                                                  ! config variable
      REAL(dp)                                   :: initial_search_radius_config                     = 150000.0_dp                                          ! config variable
      REAL(dp)                                   :: search_radius_interval_config                    =   5000.0_dp                                          ! config variable
      LOGICAL                                    :: choice_use_location_list_config                  = .FALSE.                                              ! config variable
      LOGICAL                                    :: choice_compute_refreezing_gradients_config       = .FALSE.                                              ! config variable
      LOGICAL                                    :: choice_smb_output_mieq_config                    = .FALSE.                                              ! config variable
      LOGICAL                                    :: choice_distinction_ablation_accumulation_config  = .TRUE.                                               ! config variable
      LOGICAL                                    :: choice_compute_runoff_gradients_config           = .FALSE.                                              ! config variable
      LOGICAL                                    :: choice_compute_smb_timeseries_config             = .FALSE.                                              ! config variable
      CHARACTER(LEN=256)                         :: smb_gradients_location_list_file_config          = 'smb-gradients-no-name.nc'                           ! config variable


      ! GIA FIELDS
      ! ==========
      LOGICAL                                    :: include_gia_config = .FALSE.                                                                            ! config variable
      INTEGER           , DIMENSION(3)           :: gia_record_range_config                          = (/ 1, 1, 1 /)                                        ! config variable
      INTEGER                                    :: gia_record_config                                = 1                                                    ! config variable
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: gia_field_name_config                                                                                   ! config variable
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: gia_field_unit_config                                                                                   ! config variable
      CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: gia_field_longname_config                                                                               ! config variable


      ! SST FIELDS
      ! ==========
      LOGICAL                                    :: include_sst_fields_config = .FALSE.                                                                     ! config variable
      INTEGER           , DIMENSION(3)           :: sst_record_range_config                          = (/ 1, 1, 1 /)                                        ! config variable
      INTEGER                                    :: sst_record_config                                = 1                                                    ! config variable
      INTEGER                                    :: number_of_sst_fields_config                      = 1                                                    ! config variable
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: sst_field_name_config                                                                                   ! config variable
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: sst_field_unit_config                                                                                   ! config variable
      CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: sst_field_longname_config                                                                               ! config variable


      ! OBLIMAP
      ! =======
      INTEGER                                    :: oblimap_message_level_config                     = 0                                                    ! config variable
      LOGICAL                                    :: suppress_check_on_scan_parameters_config         = .FALSE.                                              ! config variable
      REAL(dp)                                   :: oblimap_allocate_factor_config                   = 2.0_dp                                               ! config variable
      CHARACTER(LEN=256)                         :: choice_projection_method_config                  = 'oblique_stereographic_projection'                   ! config variable
      REAL(dp)                                   :: lambda_M_config                                  = 320.0_dp                                             ! config variable
      REAL(dp)                                   :: phi_M_config                                     = 72.0_dp                                              ! config variable
      REAL(dp)                                   :: alpha_stereographic_config                       = 7.5_dp                                               ! config variable
      REAL(dp)                                   :: theta_rotation_projection_config                 = 0.0_dp                                               ! config variable
      REAL(dp)                                   :: shift_x_coordinate_rotation_projection_config    = 0.0_dp                                               ! config variable
      REAL(dp)                                   :: shift_y_coordinate_rotation_projection_config    = 0.0_dp                                               ! config variable
      REAL(dp)                                   :: shepard_exponent_config                          = 2.0_dp                                               ! config variable
      CHARACTER(LEN=256)                         :: gcm_input_filename_config                        = 'gcm-input-no-name.nc'                               ! config variable
      LOGICAL                                    :: enable_shift_im_grid_config                      = .FALSE.                                              ! config variable
      REAL(dp)                                   :: shift_x_coordinate_im_grid_config                = 0.0_dp                                               ! config variable
      REAL(dp)                                   :: shift_y_coordinate_im_grid_config                = 0.0_dp                                               ! config variable
      REAL(dp)                                   :: alternative_lambda_for_center_im_grid_config     = 0.0_dp                                               ! config variable
      REAL(dp)                                   :: alternative_phi_for_center_im_grid_config        = 0.0_dp                                               ! config variable
      INTEGER           , DIMENSION(2)           :: gcm_record_range_config                          = (/ 1, 1 /)                                           ! config variable
      INTEGER           , DIMENSION(2)           :: im_record_range_config                           = (/ 1, 1 /)                                           ! config variable
      INTEGER                                    :: number_of_vertical_layers_config                 = 0                                                    ! config variable
      INTEGER                                    :: number_of_mapped_fields_config                   = 3                                                    ! config variable
      LOGICAL           , DIMENSION(MND:MNF)     :: ignore_reading_pre_mapped_fields_config          = .FALSE.                                              ! config variable
      INTEGER           , DIMENSION(  1:MNF)     :: field_which_determines_invalid_value_mask_config = -1                                                   ! config variable
      INTEGER           , DIMENSION(  1:MNF)     :: invalid_value_mask_criterion_config              =  1                                                   ! config variable
      REAL(dp)          , DIMENSION(  1:MNF)     :: invalid_input_value_config                       = -9999._dp                                            ! config variable
      REAL(dp)          , DIMENSION(  1:MNF)     :: invalid_output_value_config                      = -9999._dp                                            ! config variable
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: gcm_field_name_config                                                                                   ! config variable
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: gcm_field_unit_config                                                                                   ! config variable
      CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: gcm_field_longname_config                                                                               ! config variable
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: im_field_name_config                                                                                    ! config variable
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: im_field_unit_config                                                                                    ! config variable
      CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: im_field_longname_config                                                                                ! config variable
      CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: prefabricated_im_grid_field_name_config                                                                 ! config variable
      REAL(dp)          , DIMENSION(  0:MNF)     :: field_factor_config                              = 1.0_dp                                               ! config variable
      REAL(dp)          , DIMENSION(  0:MNF)     :: field_shift_config                               = 0.0_dp                                               ! config variable
      CHARACTER(LEN=256)                         :: im_created_filename_config                       = 'im-created-no-name.nc'                              ! config variable
      LOGICAL                                    :: scanning_mode_config                             = .TRUE.                                               ! config variable
      LOGICAL                                    :: data_set_is_cyclic_in_longitude_config           = .FALSE.                                              ! config variable
      INTEGER                                    :: level_of_automatic_oblimap_scanning_config       = 3                                                    ! config variable
      LOGICAL                                    :: choice_quadrant_method_config                    = .TRUE.                                               ! config variable
      REAL(dp)                                   :: R_search_interpolation_config                    = 16000.0_dp                                           ! config variable
      INTEGER                                    :: scan_search_block_size_config                    = -3                                                   ! config variable
      INTEGER                                    :: scan_search_block_size_step_config               =  2                                                   ! config variable
      CHARACTER(LEN=256)                         :: sid_filename_config                              = 'sid-no-name.txt'                                    ! config variable 
      CHARACTER(LEN=256)                         :: backward_sid_filename_config                     = 'backward-sid-no-name.txt'                           ! config variable 
      CHARACTER(LEN=256)                         :: im_input_filename_config                         = 'im-input-no-name.nc'                                ! config variable
      LOGICAL                                    :: use_prefabricated_im_grid_coordinates_config     = .FALSE.                                              ! config variable
      CHARACTER(LEN=256)                         :: prefabricated_im_grid_filename_config            = 'prefabricated-im-grid-coordinates-no-name.nc'       ! config variable
      CHARACTER(LEN=256)                         :: gcm_created_filename_config                      = 'to_and_fro_mapped_GCM.nc'                           ! config variable
      LOGICAL                                    :: nearest_point_assignment_config                  = .FALSE.                                              ! config variable
      LOGICAL                                    :: vincenty_method_for_ellipsoid_config             = .FALSE.                                              ! config variable
      LOGICAL                                    :: reduce_dummy_dimensions_config                   = .FALSE.                                              ! config variable
      LOGICAL                                    :: do_oblimap_post_processing_config                = .FALSE.                                              ! config variable

      LOGICAL                                    :: extrapolate_field_on_mask_edge_config            = .FALSE.                                              ! config variable
      LOGICAL                                    :: extrapolate_ocean_temperature_config             = .FALSE.                                              ! config variable

      ! OBLIMAP FLOW LINE PROFILE
      ! =========================
      CHARACTER(LEN=256)                         :: filename_flow_line_profile_config                = 'flow-line-profile-no-name.txt'                      ! config variable
      INTEGER,  DIMENSION(2)                     :: flow_line_profile_flux_criterion_config          = 1                                                    ! config variable
      INTEGER                                    :: N_profile_config                                 = 1000                                                 ! config variable
      INTEGER                                    :: amount_of_flow_line_curves_config                = 1                                                    ! config variable
      INTEGER,  DIMENSION(N_curves)              :: starting_grid_number_in_x_direction_config       = 1                                                    ! config variable
      INTEGER,  DIMENSION(N_curves)              :: starting_grid_number_in_y_direction_config       = 1                                                    ! config variable
      INTEGER,  DIMENSION(N_curves)              :: maximum_number_of_flow_line_points_config        = 1                                                    ! config variable
      INTEGER,  DIMENSION(N_curves)              :: number_of_preceding_flow_line_points_config      = 0                                                    ! config variable
      INTEGER,  DIMENSION(N_curves)              :: coarse_grid_number_to_switch_criterion_config    = 1000                                                 ! config variable
      REAL(dp), DIMENSION(N_curves)              :: high_resolution_of_flow_line_profiles_config     = 500.0_dp                                             ! config variable
      LOGICAL                                    :: follow_close_coarse_flow_line_points_config      = .FALSE.                                              ! config variable
      REAL(dp), DIMENSION(N_curves,20)           :: preceding_longitude_latitude_coordinates_config  = 0.0_dp                                               ! config variable

      ! ONLINE COUPLED OBLIMAP
      ! ======================
      LOGICAL                                    :: online_coupled_oblimap_config                    = .FALSE.                                              ! config variable
      INTEGER                                    :: embedded_model_iterations_config                 = 1                                                    ! config variable

      ! OBLIMAP TESTING
      ! ===============
      REAL(dp)                                   :: latitude_optc_config                             = -75.0_dp                                             ! config variable
      REAL(dp)                                   :: longitude_optc_config                            =  30.0_dp                                             ! config variable

      ! UNIT CONVERSION
      ! ===============
      REAL(dp)                                   :: unit_conversion_x_ax_config                      = 1.0_dp                                               ! config variable
      REAL(dp)                                   :: unit_conversion_y_ax_config                      = 1.0_dp                                               ! config variable


      ! CREATE INPUT FIELDS
      ! ===================
      INTEGER                                    :: smooth_radius_config                             = 0                                                    ! config variable
      INTEGER                                    :: replace_invalid_values_smooth_radius_config      = 0                                                    ! config variable
      LOGICAL                                    :: replace_invalid_values_by_smooting_config        = .FALSE.                                              ! config variable
      LOGICAL                                    :: adjust_single_gap_points_config                  = .FALSE.                                              ! config variable
      REAL(dp)                                   :: single_gap_threshold_config                      = 0.01                                                 ! config variable


      ! REBIN
      ! =====
      INTEGER                                    :: rebin_radius_config                              = 7                                                    ! config variable
      REAL(dp)                                   :: x_rebin_factor_config                            = 2.0_dp                                               ! config variable
      REAL(dp)                                   :: y_rebin_factor_config                            = 2.0_dp                                               ! config variable
      CHARACTER(LEN=256)                         :: rebin_input_filename_config                      = 'rebin_input_filename.nc'                            ! config variable
      CHARACTER(LEN=256)                         :: rebin_output_filename_config                     = 'rebin_output_filename.nc'                           ! config variable


      ! MODIFY
      ! ======
      INTEGER                                    :: NX_modified_config                               = 2501                                                 ! config variable
      INTEGER                                    :: NY_modified_config                               = 3001                                                 ! config variable
      INTEGER                                    :: start_index_left_for_modified_config             = 1                                                    ! config variable
      INTEGER                                    :: start_index_bottom_for_modified_config           = 1                                                    ! config variable
      REAL(dp)                                   :: dx_modified_config                               = 1000.0_dp                                            ! config variable
      REAL(dp)                                   :: dy_modified_config                               = 1000.0_dp                                            ! config variable
      CHARACTER(LEN=256)                         :: modify_input_filename_config                     = 'modify_input_filename.nc'                           ! config variable
      CHARACTER(LEN=256)                         :: modify_output_filename_config                    = 'modify_output_filename.nc'                          ! config variable

      ! CLIMBER INPUT FIELDS
      ! ====================
      LOGICAL                                    :: climber_stand_alone_config                       = .TRUE.                                               ! config variable
      REAL(dp)                                   :: dt_coupling_config                               = 1000.0_dp                                            ! config variable
      CHARACTER(LEN=256)                         :: gcm_co2_input_filename_config                    = 'gcm_co2_input_filename_config_no_name.txt'          ! config variable
      CHARACTER(LEN=256)                         :: gcm_solar_input_filename_config                  = 'gcm_solar_input_filename_config_no_name.txt'        ! config variable
      CHARACTER(LEN=256)                         :: path_to_climber_geo_config                       = 'no-geo-path'                                        ! config variable
      CHARACTER(LEN=256)                         :: path_to_climber_inp_config                       = 'no-inp-path'                                        ! config variable
      CHARACTER(LEN=256)                         :: path_to_climber_out_config                       = 'no-out-path'                                        ! config variable
      CHARACTER(LEN=256)                         :: path_to_climber_main_config                      = 'no-main-path'                                       ! config variable
      CHARACTER(LEN=256)                         :: climber_run_filename_config                      = 'no-climber-run-filename-path'                       ! config variable

      ! PHYSICAL PARAMETERS
      ! ===================
      REAL(dp)                                   :: seconds_per_year_config                          = 31556926.0_dp                                        ! config variable   ! Seconds per year: 3600 * 24 * 365.2421991 = 31556926 [s], Pattyn et al. 2008, Table 1, ISMIP
      REAL(dp)                                   :: earth_radius_config                              = 6.371221E6_dp                                        ! config variable   ! Earth Radius [m], earth_radius mean IUGG (2a +b ) / 3 = 6.371009E6_dp
      REAL(dp)                                   :: ellipsoid_semi_major_axis_config                 = 6.378137E6_dp                                        ! config variable   ! The semi-major axis of the Earth Ellipsoid [m], a in Snyder (1987) at p. 160; default WGS84 value for a = 6378137.0           meter
      REAL(dp)                                   :: ellipsoid_eccentricity_config                    = 0.08181919084262149_dp                               ! config variable   ! The exentricity     of the Earth Ellipsoid [m], e in Snyder (1987) at p. 160, default WGS84 value for e = 0.08181919084262149 meter
      REAL(dp)                                   :: seawater_temperature_config                      = 271.15_dp                                            ! config variable   ! Seawater temperature [K]
      REAL(dp)                                   :: triple_point_of_water_config                     = 273.16_dp                                            ! config variable   ! Triple point of water [K]
      REAL(dp)                                   :: gravity_constant_config                          = 9.81_dp                                              ! config variable   ! Acceleration of gravity [m s^-2]
      REAL(dp)                                   :: ice_density_config                               = 910.0_dp                                             ! config variable   ! Ice density [kg m^-3]
      REAL(dp)                                   :: seawater_density_config                          = 1028.0_dp                                            ! config variable   ! Seawater density [kg m^-3]
      REAL(dp)                                   :: fresh_water_density_config                       = 1000.0_dp                                            ! config variable   ! Fresh water density [kg m^-3]
      REAL(dp)                                   :: rock_density_config                              = 3000.0_dp                                            ! config variable   ! Rock density [kg m^-3]
      REAL(dp)                                   :: mantle_density_config                            = 3300.0_dp                                            ! config variable   ! Mantle density [kg m^-3]
      REAL(dp)                                   :: lithosphere_flexural_rigidity_config             = 4.0E+22_dp                                           ! config variable   ! Lithospheric flexural rigidity [kg m^2 s^-2]
      REAL(dp)                                   :: relaxation_time_bedrock_config                   = 3000.0_dp                                            ! config variable   ! Relaxation time for bedrock adjustment [y], Non SI Unit
      REAL(dp)                                   :: rock_heat_capacity_config                        = 1000.0_dp                                            ! config variable   ! Heat capacity of rock [J kg^-1 K^-1]
      REAL(dp)                                   :: rock_conductivity_config                         = 1.041E+08_dp                                         ! config variable   ! Conductivity of rock [J m^-1 K^-1 y^-1], Non SI Unit, mean of Turcotte and Schubert (1982), see Huybrechts (4.44)
      REAL(dp)                                   :: geothermal_heat_flux_config                      = 0.0546_dp                                            ! config variable   ! Geothermal Heat flux [J m^-2 s^-1] Sclater et al. (1980), see Huybrechts p. 106
      REAL(dp)                                   :: Claus_Clap_gradient_config                       = 8.7E-04_dp                                           ! config variable   ! Clausius Clapeyron gradient [K m^-1]
      REAL(dp)                                   :: A_sliding_config                                 = 1.8E-10_dp                                           ! config variable   ! Sliding coefficient inversely proportional to the bed roughness [m^8 N^-3 y^-1], Non SI Unit
      REAL(dp)                                   :: n_flow_config                                    = 3.0_dp                                               ! config variable   ! Flow law exponent [-]
      REAL(dp)                                   :: m_enhance_sheet_sia_config                       = 4.0_dp                                               ! config variable   ! Flow enhancement parameter for the sheet [-]
      REAL(dp)                                   :: m_enhance_sheet_ssa_config                       = 4.0_dp                                               ! config variable   ! Flow enhancement parameter for the sheet [-]
      REAL(dp)                                   :: m_enhance_shelf_config                           = 1.0_dp                                               ! config variable   ! Flow enhancement parameter for the shelf [-]
      REAL(dp)                                   :: A_turnover_temperature_config                    = 263.16_dp                                            ! config variable   ! The turnover temperature in the Arrhenius relationship [K]
      REAL(dp)                                   :: A_low_temp_config                                = 3.985E-13_dp                                         ! config variable   ! The constant a in the Arrhenius relationship [Pa^-n s^-1]
      REAL(dp)                                   :: A_high_temp_config                               = 1.916E+3_dp                                          ! config variable   ! The constant a in the Arrhenius relationship [Pa^-n s^-1]
      REAL(dp)                                   :: Q_low_temp_config                                = 6.0E+04_dp                                           ! config variable   ! Activation energy for creep in the Arrhenius relationship [J mol^-1]
      REAL(dp)                                   :: Q_high_temp_config                               = 1.39E+05_dp                                          ! config variable   ! Activation energy for creep in the Arrhenius relationship [J mol^-1]
      REAL(dp)                                   :: R_gas_config                                     = 8.314_dp                                             ! config variable   ! Gas constant [J mol^-1 K^-1]
      REAL(dp)                                   :: wet_adiabatic_config                             = 0.00546_dp                                           ! config variable   ! The air is supposed to be dry/wet adiabatic above/below this altitude [m]
      REAL(dp)                                   :: dry_adiabatic_config                             = 0.01003_dp                                           ! config variable   ! Temperture decrease per meter altitude [K m^-1]
      REAL(dp)                                   :: adiabatic_turnover_height_config                 = 2000.0_dp                                            ! config variable   ! Temperture decrease per meter altitude [K m^-1]
      REAL(dp)                                   :: kappa_0_ice_conductivity_config                  = 9.828_dp                                             ! config variable   ! The linear constant in the thermal conductivity of ice [J m^-1 K^-1 s^-1], see equation (12.6), Ritz (1987), Cuffey & Paterson (2010, p. 400), Zwinger (2007)
      REAL(dp)                                   :: kappa_e_ice_conductivity_config                  = 0.0057_dp                                            ! config variable   ! The exponent constant in the thermal conductivity of ice [K^-1], see equation (12.6), Ritz (1987), Cuffey & Paterson (2010, p. 400), Zwinger (2007)
      REAL(dp)                                   :: c_0_specific_heat_config                         = 2127.5_dp                                            ! config variable   ! The constant in the specific heat capacity of ice [J kg^-1 K^-1], see equation (12.5), Zwinger (2007), Cuffey & Paterson (2010, p. 400)
      REAL(dp)                                   :: c_Delta_specific_heat_config                     = 7.253_dp                                             ! config variable   ! The linear difference constant in the specific heat capacity of ice [J kg^-1 K^-2], see equation (12.5), Zwinger (2007), Cuffey & Paterson (2010, p. 400)
      REAL(dp)                                   :: latent_heat_config                               = 3.335E05_dp                                          ! config variable   ! The latent heat of ice [J kg^-1], 3.335E05 (Zwinger 2007)
      REAL(dp)                                   :: Stefan_Bolzmann_constant_config                  = 5.67037321E-08_dp                                    ! config variable   ! The Stefan Bolzmann constant [W m-2 K-4]
      REAL(dp)                                   :: solar_constant_config                            = 1367.0_dp                                            ! config variable   ! Solar constant [W m-2]
      REAL(dp)                                   :: earth_angular_velocity_config                    = ACOS(0.0) / 6.0_dp                                   ! config variable   ! Earth rotation velocity [radians/hour]



    ! TYPE DEFENITIONS
    !=================

      ! This TYPE contains a few global variables, treat them with highest care!
      TYPE global_type
        REAL(dp) :: dt                        ! Time step (in years) during the run. It can change when the time stepping is dynamical.
        REAL(dp) :: time                      ! Time (in years) of run, increasing each time step.
        REAL(dp) :: maximum_dHi_change_per_dt ! The maximum allowed change in ice thickness per time step, in case of a variable time step this amount changes.
        REAL(dp) :: b_t                       ! Implict time discretization coefficient. It can change when the time stepping is dynamical.
        REAL(dp) :: dt_bedrock                ! Time step (in years) between the bedrock calculations.
      END TYPE global_type

      ! G is the 'struct' containing a few global variables
      TYPE(global_type), SAVE :: G

      ! This TYPE contains all the information once the config file is read never will change during the run of the program
      TYPE constants_type
                                                 ! NAME OF THE CONFIG FILE
                                                 !========================
        CHARACTER(LEN=256)                         :: config_filename

        INTEGER                                    :: MND      = MND
        INTEGER                                    :: N_ignore = N_ignore

                                                 ! GRID SIZES AND GRID SPACING
                                                 !============================
        INTEGER                                    :: NX                                  ! Number of grid points in x-direction
        INTEGER                                    :: NY                                  ! Number of grid points in y-direction
        INTEGER                                    :: NZ                                  ! Number of grid points in vertical direction for thermodynamics in ice sheet
        INTEGER                                    :: NZR                                 ! Number of grid points in vertical direction for thermodynamics within bedrock
        INTEGER                                    :: NZL                                 ! Number of grid points in the Linear vertical direction
        REAL(dp)                                   :: dx                                  ! Grid spacing in x-direction [meter]
        REAL(dp)                                   :: dy                                  ! Grid spacing in y-direction [meter]
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: zeta                                ! Grid spacing in zeta-direction (zeta is the vertical scaled coordinate)
        REAL(dp)                                   :: dzr                                 ! Grid spacing in z-direction in the bedrock [meter]
        REAL(dp)                                   :: z_step                              ! Linear vertical grid size [meter]
        INTEGER                                    :: i_center                            ! Grid point (j_center,i_center) corresponds to the center of the ice model grid
        INTEGER                                    :: j_center                            ! Grid point (j_center,i_center) corresponds to the center of the ice model grid
        INTEGER                                    :: NLON                                ! Number of GCM grid points in the longitudinal-direction
        INTEGER                                    :: NLAT                                ! Number of GCM grid points in the latitudinal-direction

                                                 ! GRID DIFFERENCES IN DISCRETIZATION
                                                 ! ==================================
        REAL(dp)                                   :: a_x
        REAL(dp)                                   :: c_x
        REAL(dp)                                   :: a_y
        REAL(dp)                                   :: c_y
        REAL(dp)                                   :: a_xx
        REAL(dp)                                   :: b_xx
        REAL(dp)                                   :: c_xx
        REAL(dp)                                   :: a_yy
        REAL(dp)                                   :: b_yy
        REAL(dp)                                   :: c_yy

        REAL(dp), DIMENSION(:), ALLOCATABLE        :: a_k
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: b_k
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: c_k
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: d_k
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: a_zeta
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: b_zeta
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: c_zeta
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: a_zetazeta
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: b_zetazeta
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: c_zetazeta

        REAL(dp)                                   :: z_x_minus
        REAL(dp)                                   :: a_x_minus
        REAL(dp)                                   :: b_x_minus

        REAL(dp)                                   :: b_x_plus
        REAL(dp)                                   :: c_x_plus
        REAL(dp)                                   :: d_x_plus

        REAL(dp)                                   :: z_y_minus
        REAL(dp)                                   :: a_y_minus
        REAL(dp)                                   :: b_y_minus

        REAL(dp)                                   :: b_y_plus
        REAL(dp)                                   :: c_y_plus
        REAL(dp)                                   :: d_y_plus

        REAL(dp), DIMENSION(:), ALLOCATABLE        :: z_zeta_minus
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: a_zeta_minus
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: b_zeta_minus

        REAL(dp), DIMENSION(:), ALLOCATABLE        :: b_zeta_plus
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: c_zeta_plus
        REAL(dp), DIMENSION(:), ALLOCATABLE        :: d_zeta_plus

        REAL(dp)                                   :: a_zrzr
        REAL(dp)                                   :: b_zrzr
        REAL(dp)                                   :: c_zrzr

        REAL(dp)                                   :: b_zr_plus
        REAL(dp)                                   :: c_zr_plus
        REAL(dp)                                   :: d_zr_plus

        REAL(dp)                                   :: z_zr_minus
        REAL(dp)                                   :: a_zr_minus
        REAL(dp)                                   :: b_zr_minus

                                                 ! TIME CONDITIONS
                                                 !================
        REAL(dp)                                   :: start_time_of_run                   ! Start time of run
        REAL(dp)                                   :: end_time_of_run                     ! End time of run
        INTEGER                                    :: starting_record_number              ! The number of the netcdf record which is used as the start record
        REAL(dp)                                   :: dt                                  ! Time step (in years) of run
        REAL(dp)                                   :: dt_thermo                           ! Time step (in years) used for the thermodynamics
        REAL(dp)                                   :: dt_shelf_velocity                   ! Time step (in years) used for the shelf velocity
        REAL(dp)                                   :: dt_bedrock                          ! Time step (in years) for bedrock adjustment
        REAL(dp)                                   :: dt_restart                          ! Time step (in years) for writing restart files
        REAL(dp)                                   :: dt_recording                        ! Time step (in years) for writing recording files
        REAL(dp)                                   :: dt_sort_Hs                          ! Time step (in years) for sorting the surface elevation array Hs
        REAL(dp)                                   :: dt_smb                              ! Time step (in years) for calculating surface mass balance
        REAL(dp)                                   :: dt_gravitational_snow_transport     ! Time step (in days) for calculating gravitational snow transport
        REAL(dp)                                   :: dt_glacier_bed_iteration            ! Time step (in years) for iterative reconstruction of glacier bed

        LOGICAL                                    :: dynamic_time_step_addaption         ! Choice between dynamic addaption of the time step [TRUE], or the default fixed time step [FALSE]
        LOGICAL                                    :: dynamic_time_step_sheet_based       ! If TRUE the dynamic time step is based on the CFL criterion at sheet points only
        REAL(dp)                                   :: likely_mean_dynamic_time_step       ! A likely mean time step which will be used if the maximal_critical_time_step is exceeded in case the dynamical time stepping is used
        REAL(dp)                                   :: minimal_critical_time_step          ! The minimal critical time step, in case of dynamical time stepping
        REAL(dp)                                   :: maximal_critical_time_step          ! The maximal critical time step, in case of dynamical time stepping
        REAL(dp)                                   :: time_step_scaler                    ! Time step scaler, which addapts e.g. the time step up to 300% of the critical time step if it is 3

                                                 ! GEOTHERMAL HEAT FLUX
                                                 ! ====================
        LOGICAL                                    :: monotonic_geothermal_heat_flux
        CHARACTER(LEN=256)                         :: geothermal_heat_flux_file_name
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: geothermal_heat_flux_field_name

                                                 ! MEAN CLIMATE FORCING
                                                 !=====================
        INTEGER                                    :: size_climate_record                 ! The number of climate records
        INTEGER                                    :: choice_forcing
        REAL(dp)                                   :: constant_sealevel_deviation
        REAL(dp)                                   :: constant_temperature_deviation
        INTEGER                                    :: choice_insolation_forcing
        INTEGER                                    :: size_insolation_record
        INTEGER                                    :: constant_insolation_month
        INTEGER                                    :: constant_insolation_latitude

                                                 ! RUN MODES
                                                 !==========
        INTEGER                                    :: choice_flux_scheme
        REAL(dp)                                   :: ice_flux_intervention_allowed_period
        INTEGER                                    :: choice_surface_derivatives_scheme
        INTEGER                                    :: choice_bottom_derivatives_scheme

                                                 ! TYPES OF LAND
                                                 !==============
        INTEGER                                    :: type_sheet
        INTEGER                                    :: type_groundline
        INTEGER                                    :: type_shelf
        INTEGER                                    :: type_calveline
        INTEGER                                    :: type_ocean

                                                 ! DISCRETIZATION MASK TYPES
                                                 !==========================
        INTEGER                                    ::  mask_inactive
        INTEGER                                    ::  mask_unknown
        INTEGER                                    ::  mask_single_point
        INTEGER                                    ::  mask_central_point
        INTEGER                                    ::  mask_left_edge_point
        INTEGER                                    ::  mask_left_edge_only_two_points
        INTEGER                                    ::  mask_left_edge_single_point
        INTEGER                                    ::  mask_right_edge_point
        INTEGER                                    ::  mask_right_edge_only_two_points
        INTEGER                                    ::  mask_right_edge_single_point

                                                 ! FILE NAMES:
                                                 !============
        CHARACTER(LEN=256)                         :: initial_restart_filename
        CHARACTER(LEN=256)                         :: initial_key_fields_filename
        CHARACTER(LEN=256)                         :: smb_gradients_filename
        CHARACTER(LEN=256)                         :: rfr_gradients_filename
        CHARACTER(LEN=256)                         :: runoff_gradients_filename
        CHARACTER(LEN=256)                         :: forcing_filename
        CHARACTER(LEN=256)                         :: latitude_longitude_filename
        CHARACTER(LEN=256)                         :: insolation_filename
        CHARACTER(LEN=256)                         :: ascii_input_data_filename
        CHARACTER(LEN=256)                         :: forcing_fields_filename
        CHARACTER(LEN=256)                         :: gia_filename
        CHARACTER(LEN=256)                         :: isostatic_equilibrium_filename
        CHARACTER(LEN=256)                         :: sst_fields_filename
        CHARACTER(LEN=256)                         :: reference_surface_height_filename
        CHARACTER(LEN=256)                         :: key_fields_filename
        CHARACTER(LEN=256)                         :: restart_filename
        CHARACTER(LEN=256)                         :: recording_filename
        CHARACTER(LEN=256)                         :: help_fields_filename
        CHARACTER(LEN=256)                         :: extra_fields_filename
        CHARACTER(LEN=256)                         :: filename_DEM
        CHARACTER(LEN=256)                         :: filename_MASK
        CHARACTER(LEN=256)                         :: filename_SMB
        CHARACTER(LEN=256)                         :: filename_VEL
        CHARACTER(LEN=256)                         :: filename_BED
        CHARACTER(LEN=256)                         :: filename_K

        INTEGER                                    :: recnr_to_start_from_restart
        LOGICAL                                    :: enable_restart_file
        LOGICAL                                    :: enable_recording_file
        LOGICAL                                    :: enable_help_fields_file
        LOGICAL                                    :: enable_extra_netcdf_file
        LOGICAL                                    :: synchronize_netcdf_writing
        LOGICAL                                    :: protect_file_overwriting
        LOGICAL                                    :: enable_color_messaging_in_terminal

        INTEGER                                    :: which_recording_fields
        INTEGER                                    :: which_help_fields
        INTEGER, DIMENSION(N_ignore)               :: ignore_some_recording_fields
        INTEGER, DIMENSION(N_ignore)               :: ignore_some_help_fields
        LOGICAL                                    :: use_grid_units_in_dimension
        LOGICAL                                    :: label_netcdf_fields_with_number
        LOGICAL                                    :: use_double_instead_of_float_in_netcdf

                                                 ! INPUT/OUTPUT MESSAGES
                                                 !======================
        INTEGER                                    :: stderr                              ! unit to which errors should be written.
        INTEGER                                    :: stdlog                              ! unit to which log messages should be written.
        LOGICAL                                    :: choice_write_message
        LOGICAL                                    :: launch_ncview

                                                 ! MINIMUM ICE THICKNESS AND MAXIMUM CHANGE PER TIME STEP
                                                 !=======================================================
        REAL(dp)                                   :: Hi_min                              ! Minimal ice_thickness (it cannot be zero because of the scaled coordinate zeta)
        REAL(dp)                                   :: maximum_dHi_change_per_year         ! Maximum addaption per time step, in an attempt to get a stable behavior, e.g. at the
                                                                                          ! start of a run. This intervention should disappear after a few hundred of time steps.

        REAL(dp)                                   :: D_uv_3D_cutoff                      ! Cutoff to avoid too large velocities.


                                                 ! ADHOC AREA MASKING FOR THE TOTAL ICE VOLUME
                                                 ! ===========================================
        CHARACTER(LEN=256)                         :: area_mask_for_total_ice_volume

                                                 ! SPIN UP
                                                 ! =======
        LOGICAL                                    :: do_temperature_spin_up
        LOGICAL                                    :: determine_MB_equilibrium

                                                 ! SHELF MUMPS USE
                                                 !================
        LOGICAL                                    :: choice_use_mumps                    ! If TRUE the parameterization is used for the shelf
        INTEGER                                    :: number_of_explicit_shelf_iterations ! Number of iterations for which the explicit shelf parts are updated
        INTEGER, DIMENSION(5)                      :: mumps_message_level                 ! The first four values are the mumps ICNTL values determing the mumps message level,
                                                                                          ! the last message level concerns the mumps_module messages themselves

                                                 ! SHELF
                                                 ! =====
        LOGICAL                                    :: shelf_surface_gradient_one_sided_discretized
        LOGICAL                                    :: include_shelf_dynamics
        INTEGER                                    :: maximum_number_gauss_seidel_iterations
        REAL(dp)                                   :: gauss_seidel_over_relaxation_parameter
        REAL(dp)                                   :: residual_in_gauss_seidel_convergence_criterion

        LOGICAL                                    :: initial_velocity_spin_up

                                                 ! BEDROCK
                                                 ! =======
        LOGICAL                                    :: adjusting_bedrock
        LOGICAL                                    :: assume_isostatic_equilibrium_at_start

        REAL(dp)                                   :: epsilon_sq_0

        LOGICAL                                    :: glacier_bed_iteration_run
        INTEGER                                    :: maximum_number_of_bed_iterations
        REAL(dp)                                   :: minimal_value_mean_residual_bed_iteration
        REAL(dp)                                   :: sealevel_for_reference_load_bedrock

                                                 ! SLIDING
                                                 ! =======
        REAL(dp)                                   :: reduced_Ti_pmp_threshold_for_sliding   ! In Kelvin
        CHARACTER(LEN=256)                         :: choice_sliding_method
        LOGICAL                                    :: include_weertman_sliding
        LOGICAL                                    :: include_eismint_sliding
        LOGICAL                                    :: do_sliding_at_all_grounded_points
        LOGICAL                                    :: include_sliding_with_ice_stream_by_ssa_approach
        LOGICAL                                    :: include_sliding_heatflux
        REAL(dp)                                   :: factor_mininimum_sliding_load


                                                 ! PARAMETERS IN SSA APROACH
                                                 ! =========================
        REAL(dp)                                   :: dummy_delta_v
        REAL(dp)                                   :: q_plastic
        REAL(dp)                                   :: u_threshold_yield_stress_scaling
        REAL(dp)                                   :: scaling_Hb_minimal_friction_angle
        REAL(dp)                                   :: scaling_Hb_maximal_friction_angle
        REAL(dp)                                   :: minimal_friction_angle
        REAL(dp)                                   :: maximal_friction_angle

                                                 ! MASS BALANCE
                                                 ! =============
        CHARACTER(LEN=256)                         :: choice_smb_method
        INTEGER                                    :: choice_bmb_model
        REAL(dp), DIMENSION(4)                     :: gauge_points_basal_melt
        REAL(dp)                                   :: basal_sheet_melt
        REAL(dp)                                   :: basal_shelf_melt
        REAL(dp)                                   :: grounding_line_melt
        LOGICAL                                    :: apply_remaining_mass_balance
        LOGICAL                                    :: energetic_bottom_melt
        INTEGER                                    :: number_of_potential_bottom_melt_layers
        REAL(dp)                                   :: maximum_bottom_melt
        REAL(dp)                                   :: calve_thickness_sheet
        REAL(dp)                                   :: calve_thickness_shelf
        REAL(dp)                                   :: initial_time_minimal_calving
        LOGICAL                                    :: apply_calving
        LOGICAL                                    :: choice_smooth_MB
        REAL(dp), DIMENSION(14)                    :: gaussian_profile_massbalance
        LOGICAL                                    :: include_gravitational_snow_transport
        LOGICAL                                    :: only_calculate_smb
        LOGICAL                                    :: use_mask_glacier_smb_when_calculate_smb
        REAL(dp)                                   :: south_angle_grid
        INTEGER                                    :: N_horizon_angles
        INTEGER                                    :: start_day_smb
        INTEGER                                    :: number_of_time_steps_per_day
        REAL(dp)                                   :: temperature_dependent_flux_parameter_c0
        REAL(dp)                                   :: temperature_dependent_flux_parameter_c1
        REAL(dp)                                   :: temperature_dependent_flux_parameter_Tfluxmin
        LOGICAL                                    :: write_smb_fields_to_extra_help_fields
        INTEGER                                    :: number_of_time_steps_per_write_interval
        CHARACTER(LEN=256)                         :: meteo_input_file_smb_model
        CHARACTER(LEN=256)                         :: precipitation_index_map_input_file
        INTEGER                                    :: N_lines_meteo_input_file_smb
        REAL(dp)                                   :: spinup_time

                                                 ! INSOLATION-TEMPERATURE MELT MODEL
                                                 !==================================
        REAL(dp)                                   :: albedo_water                     ! Albedo of ocean water
        REAL(dp)                                   :: albedo_soil                      ! Albedo of bare rock
        REAL(dp)                                   :: albedo_ice                       ! Albedo of (glacier) ice
        REAL(dp)                                   :: albedo_snow                      ! Albedo of (fresh) snow

        REAL(dp)                                   :: ablation_constant_insolation     ! Melt parameter for insolation (transmissivity of the atmosphere)
        REAL(dp)                                   :: ablation_constant_temperature    ! Melt paramter for temperature - LW+LH+SH
        REAL(dp)                                   :: ablation_constant                ! Constant melt parameter - LW+LH+SH

                                                 ! SUB SHELF OCEANIC MELT PARAMETERS
                                                 !==================================
        REAL(dp)                                   :: c_0_specific_heat_ocean
        REAL(dp)                                   :: mean_ocean_surface_temperature
        REAL(dp)                                   :: thermal_exchange_velocity
        REAL(dp)                                   :: subshelf_melt_factor_for_protected_shelves
        REAL(dp)                                   :: subshelf_melt_factor_for_exposed_shelves
        REAL(dp)                                   :: subshelf_melt_factor_for_deep_ocean

                                                 ! CONVERT GIA ASCII FILES
                                                 !========================
        REAL(dp)                                   :: time_of_gia_ascii_record

        INTEGER                                    :: choice_concentration

                                                 ! TEMPERATURE
                                                 ! ===========
        CHARACTER(LEN=256)                         :: choice_Ts_method
        REAL(dp)                                   :: mean_Ts_forcing_at_sealevel
        INTEGER                                    :: choice_temperature_model
        REAL(dp)                                   :: frictional_heating_scale_factor
        LOGICAL                                    :: include_horizontal_diffusion
        INTEGER                                    :: choice_temperature_derivatives_scheme
        INTEGER                                    :: choice_thermodynamics_scheme
        INTEGER                                    :: choice_3D_velocity_scheme
        LOGICAL                                    :: fixed_Ti_at_shelf_bottom
        LOGICAL                                    :: linear_temperature_at_shelf
        LOGICAL                                    :: include_refreezing_term_via_Ts
        REAL(dp)                                   :: Ti_fixed                             ! The mean surface temperture at sealevel [Kelvin]
        REAL(dp)                                   :: delta_Ti_below_T_pmp
        REAL(dp)                                   :: registration_limit_low_Ti

                                                 ! EISMINT benchmark
                                                 !==================
        LOGICAL                                    :: eismint_case
        CHARACTER                                  :: choice_eismint_experiment            ! Sets experiment: A, B, ..., H
        REAL(dp), DIMENSION(6)                     :: eismint_parameters                   ! Default: 238.15  450.0  0.01  0.5    750.0 750.0
                                                                                           !           T_min   E     S_b   M_max   xp    yp
                                                 ! MISMIP benchmark
                                                 !==================
        LOGICAL                                    :: mismip_case
        LOGICAL                                    :: mismip_no_shelf
        LOGICAL                                    :: schoof_flux

                                                 ! CROSS SECTION
                                                 ! =============
        CHARACTER(LEN=128)                         :: one_dimensional_experiment
        INTEGER                                    :: x_fixed
        INTEGER                                    :: y_fixed
        REAL(dp)                                   :: lowest_z_of_cross_section
        REAL(dp), DIMENSION(5)                     :: fake_value_for_bedrock
        REAL(dp), DIMENSION(5)                     :: fake_value_for_atmosphere
        REAL(dp), DIMENSION(5)                     :: fake_value_for_ocean

        INTEGER                                    :: synthetic_experiment_number
        CHARACTER(LEN=256)                         :: experiment_label

                                                 ! FULL STOKES
                                                 !========================
        INTEGER                                    :: choice_surface_bc                   ! If '1': momentum only, if '2': neumann condition, if '3': dirichlet condition, if '4': continuity
        INTEGER                                    :: choice_shelf_bottom_bc              ! If '1': momentum only, if '2': neumann condition, if '3': dirichlet condition, if '4': continuity
        LOGICAL                                    :: physic_boundary_conditions          ! If TRUE the 'new' boundary conditions are used
        LOGICAL                                    :: physic_bc_for_calving               ! If TRUE the calving boundary conditions are used
        LOGICAL                                    :: lateral_friction                    ! If TRUE lateral friction is simulated at the back and front sides of the shelf
        LOGICAL                                    :: write_matrix_rhs_format             ! If TRUE the Matrix Market and RHS are written
        INTEGER                                    :: choice_velocity_derivatives_scheme  ! The choice concerning the scheme with which dU_dx, dU_dy, ..., dW_dzeta are calculated
        LOGICAL                                    :: take_dEta_terms_implicit
        INTEGER                                    :: choice_Eta_derivatives
        INTEGER                                    :: number_of_Eta_iterations            ! Differentiate in stress regimes by taking different simplification factors for sheet and shelf
        LOGICAL                                    :: differentiate_stress_regime
        REAL(dp), DIMENSION(0:6)                   :: simplification_coefficients
        REAL(dp), DIMENSION(0:6)                   :: simplification_coeffi_sheet
        REAL(dp), DIMENSION(0:6)                   :: simplification_coeffi_shelf
        REAL(dp), DIMENSION(5)                     :: bottom_sliding_parameters

                                                 ! SHELF PARAMETERIZATION
                                                 !=======================
        LOGICAL                                    :: parameterized_shelf                 ! If TRUE the parameterization is used for the shelf
        REAL(dp)                                   :: gd                                  ! gd: grid distance (equidistant grid in x and y-direction)
        REAL(dp)                                   :: n_scale                             ! the factor: 20000/C%gd; used to make the program gd independent
        REAL(dp)                                   :: R_influence                         ! R_influence is the influence-radius
        REAL(dp)                                   :: p                                   ! p is the exponent which determines the weighting of the distance between I and P
        REAL(dp)                                   :: Q0                                  ! scaling constant
        REAL(dp)                                   :: Q                                   !
        INTEGER                                    :: Ngd                                 ! N times gd = R_influence

        INTEGER                                    :: Nslices                             ! Number of slices in the shelf_parameterizing_by_slices routine
        INTEGER                                    :: Fsi                                 ! Furthest slice involved

                                                 ! MATHEMATICAL CONSTANTS
                                                 !=======================
        REAL(dp)                                   :: pi
        REAL(dp)                                   :: degrees_to_radians                  ! Conversion factor between radians and degrees
        REAL(dp)                                   :: radians_to_degrees                  ! Conversion factor between degrees and radians

                                                 ! ADDITIONAL VARIABLES WHICH CAN BE USED FOR TESTING AND DEBUGGING
                                                 !=================================================================
        INTEGER                                    :: testing_integer                     ! For temporary testing with a integer, avoiding compiling between
        REAL(dp)                                   :: testing_real_dp                     ! For temporary testing with a real(dp), avoiding compiling between


                                                 ! EXTRA FIELDS
                                                 ! ============
        CHARACTER(LEN=128), DIMENSION(MNF)         :: extra_field_choice_1_name           ! This array contains for each extra field_choice_1 the name of the field
        CHARACTER(LEN=128), DIMENSION(MNF)         :: extra_field_choice_1_unit           ! This array contains for each extra field_choice_1 the unit of the field
        CHARACTER(LEN=256), DIMENSION(MNF)         :: extra_field_choice_1_longname       ! This array contains for each extra field_choice_1 the longname of the field
        CHARACTER(LEN=256), DIMENSION(MNF)         :: extra_field_choice_1_description    ! This array contains for each extra field_choice_1 the description of the field
        CHARACTER(LEN=128), DIMENSION(MNF)         :: extra_field_choice_2_name           ! This array contains for each extra field_choice_2 the name of the field
        CHARACTER(LEN=128), DIMENSION(MNF)         :: extra_field_choice_2_unit           ! This array contains for each extra field_choice_2 the unit of the field
        CHARACTER(LEN=256), DIMENSION(MNF)         :: extra_field_choice_2_longname       ! This array contains for each extra field_choice_2 the longname of the field
        CHARACTER(LEN=256), DIMENSION(MNF)         :: extra_field_choice_2_description    ! This array contains for each extra field_choice_2 the description of the field
        CHARACTER(LEN=128), DIMENSION(MNF)         :: extra_field_choice_3_name           ! This array contains for each extra field_choice_3 the name of the field
        CHARACTER(LEN=128), DIMENSION(MNF)         :: extra_field_choice_3_unit           ! This array contains for each extra field_choice_3 the unit of the field
        CHARACTER(LEN=256), DIMENSION(MNF)         :: extra_field_choice_3_longname       ! This array contains for each extra field_choice_3 the longname of the field
        CHARACTER(LEN=256), DIMENSION(MNF)         :: extra_field_choice_3_description    ! This array contains for each extra field_choice_3 the description of the field
        CHARACTER(LEN=128), DIMENSION(MNF)         :: extra_field_choice_4_name           ! This array contains for each extra field_choice_4 the name of the field
        CHARACTER(LEN=128), DIMENSION(MNF)         :: extra_field_choice_4_unit           ! This array contains for each extra field_choice_4 the unit of the field
        CHARACTER(LEN=256), DIMENSION(MNF)         :: extra_field_choice_4_longname       ! This array contains for each extra field_choice_4 the longname of the field
        CHARACTER(LEN=256), DIMENSION(MNF)         :: extra_field_choice_4_description    ! This array contains for each extra field_choice_4 the description of the field
        CHARACTER(LEN=128), DIMENSION(MNF)         :: extra_field_choice_5_name           ! This array contains for each extra field_choice_5 the name of the field
        CHARACTER(LEN=128), DIMENSION(MNF)         :: extra_field_choice_5_unit           ! This array contains for each extra field_choice_5 the unit of the field
        CHARACTER(LEN=256), DIMENSION(MNF)         :: extra_field_choice_5_longname       ! This array contains for each extra field_choice_5 the longname of the field
        CHARACTER(LEN=256), DIMENSION(MNF)         :: extra_field_choice_5_description    ! This array contains for each extra field_choice_5 the description of the field


                                                 ! FORCING FIELDS
                                                 ! ==============
        INTEGER                                    :: forcing_record
        INTEGER           , DIMENSION(3)           :: forcing_record_range
        INTEGER                                    :: number_of_forcing_fields
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: forcing_field_name
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: forcing_field_unit
        CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: forcing_field_longname

                                                 ! LATITUDE LONGITUE FIELDS
                                                 ! ========================
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: latitude_longitude_field_name
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: latitude_longitude_field_unit
        CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: latitude_longitude_field_longname


                                                 ! SMB GRADIENTS VARIABLES
                                                 ! =======================
        INTEGER                                    :: number_of_input_fields
        INTEGER                                    :: number_of_smb_gradients_fields
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: smb_gradients_field_name
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: smb_gradients_field_unit
        CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: smb_gradients_field_longname
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: rfr_gradients_field_name
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: rfr_gradients_field_unit
        CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: rfr_gradients_field_longname
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: runoff_gradients_field_name
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: runoff_gradients_field_unit
        CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: runoff_gradients_field_longname
        INTEGER                                    :: n_pos_min
        INTEGER                                    :: n_neg_min
        INTEGER                                    :: n_runoff_min
        REAL(dp)                                   :: initial_search_radius
        REAL(dp)                                   :: search_radius_interval
        LOGICAL                                    :: choice_use_location_list
        LOGICAL                                    :: choice_compute_refreezing_gradients
        LOGICAL                                    :: choice_smb_output_mieq
        LOGICAL                                    :: choice_distinction_ablation_accumulation
        LOGICAL                                    :: choice_compute_runoff_gradients
        LOGICAL                                    :: choice_compute_smb_timeseries
        CHARACTER(LEN=256)                         :: smb_gradients_location_list_file


                                                 ! GIA FIELDS
                                                 ! ==========
        LOGICAL                                    :: include_gia
        INTEGER           , DIMENSION(3)           :: gia_record_range
        INTEGER                                    :: gia_record
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: gia_field_name
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: gia_field_unit
        CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: gia_field_longname


                                                 ! SST FIELDS
                                                 ! ==========
        LOGICAL                                    :: include_sst_fields
        INTEGER           , DIMENSION(3)           :: sst_record_range
        INTEGER                                    :: sst_record
        INTEGER                                    :: number_of_sst_fields
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: sst_field_name
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: sst_field_unit
        CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: sst_field_longname


                                                 ! REFERENCE SURFACE HEIGHT
                                                 ! ========================
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: reference_surface_height_field_name
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: reference_surface_height_field_unit
        CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: reference_surface_height_field_longname


                                                 ! OBLIMAP
                                                 !========
        INTEGER                                    :: oblimap_message_level
        LOGICAL                                    :: suppress_check_on_scan_parameters
        REAL(dp)                                   :: oblimap_allocate_factor
        CHARACTER(LEN=256)                         :: choice_projection_method
        REAL(dp)                                   :: lambda_M
        REAL(dp)                                   :: phi_M
        LOGICAL                                    :: polar_projection
        REAL(dp)                                   :: alpha_stereographic
        REAL(dp)                                   :: theta_rotation_projection
        REAL(dp)                                   :: shift_x_coordinate_rotation_projection
        REAL(dp)                                   :: shift_y_coordinate_rotation_projection
        REAL(dp)                                   :: shepard_exponent
        CHARACTER(LEN=256)                         :: gcm_input_filename
        LOGICAL                                    :: enable_shift_im_grid
        REAL(dp)                                   :: shift_x_coordinate_im_grid
        REAL(dp)                                   :: shift_y_coordinate_im_grid
        REAL(dp)                                   :: alternative_lambda_for_center_im_grid
        REAL(dp)                                   :: alternative_phi_for_center_im_grid
        INTEGER           , DIMENSION(2)           :: gcm_record_range
        INTEGER           , DIMENSION(2)           :: im_record_range
        LOGICAL                                    :: include_vertical_dimension
        INTEGER                                    :: number_of_vertical_layers
        INTEGER                                    :: number_of_mapped_fields
        LOGICAL           , DIMENSION(MND:MNF)     :: ignore_reading_pre_mapped_fields           ! This array contains for each field the choice if the pre-mapped field should be read or not
        LOGICAL           , DIMENSION(  1:MNF)     :: masked_fields                              ! This array contains for each field the choice if it should be treated masked or not
        INTEGER           , DIMENSION(  1:MNF)     :: field_which_determines_invalid_value_mask  ! This array contains for each field the number of the field which determines the invalid value mask. Default this will equal the field number of the considered field itself
        INTEGER           , DIMENSION(  1:MNF)     :: invalid_value_mask_criterion               ! This array contains for each field the masking criterion. If 1: the destination point gets an invalid value in case the nearest projected departure point has an invalid value (default). If 2: as long there is any valid contribution available they will be used, if no valid contribution is detected then the point gets an invalid value
        REAL(dp)          , DIMENSION(  1:MNF)     :: invalid_input_value                        ! This array contains for each field the invalid value where the invalid value mask is based on for that field
        REAL(dp)          , DIMENSION(  1:MNF)     :: invalid_output_value                       ! This array contains for each field the invalid value as written to the output file. Default this equals the input invalid value
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: gcm_field_name                             ! This array contains for each gcm field the name of the field
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: gcm_field_unit                             ! This array contains for each gcm field the unit of the field
        CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: gcm_field_longname                         ! This array contains for each gcm field the longname of the field
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: im_field_name                              ! This array contains for each im  field the name of the field
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: im_field_unit                              ! This array contains for each im  field the unit of the field
        CHARACTER(LEN=256), DIMENSION(MND:MNF)     :: im_field_longname                          ! This array contains for each im  field the longname of the field
        CHARACTER(LEN=128), DIMENSION(MND:MNF)     :: prefabricated_im_grid_field_name           ! This array contains for each im  field the name of the field, actually the x and y coordinate names are used only by reading the prefabricated im grid coordinates
        REAL(dp)          , DIMENSION(  0:MNF)     :: field_factor                               ! This array contains for each field the conversion factor
        REAL(dp)          , DIMENSION(  0:MNF)     :: field_shift                                ! This array contains for each field the conversion shift
        CHARACTER(LEN=256)                         :: im_created_filename
        LOGICAL                                    :: scanning_mode
        LOGICAL                                    :: data_set_is_cyclic_in_longitude
        INTEGER                                    :: level_of_automatic_oblimap_scanning
        INTEGER                                    :: scan_search_block_size
        INTEGER                                    :: scan_search_block_size_step
        LOGICAL                                    :: choice_quadrant_method
        REAL(dp)                                   :: R_search_interpolation
        CHARACTER(LEN=256)                         :: sid_filename
        CHARACTER(LEN=256)                         :: backward_sid_filename
        CHARACTER(LEN=256)                         :: im_input_filename
        LOGICAL                                    :: use_prefabricated_im_grid_coordinates
        CHARACTER(LEN=256)                         :: prefabricated_im_grid_filename
        CHARACTER(LEN=256)                         :: gcm_created_filename
        LOGICAL                                    :: nearest_point_assignment
        LOGICAL                                    :: vincenty_method_for_ellipsoid
        LOGICAL                                    :: reduce_dummy_dimensions
        LOGICAL                                    :: do_oblimap_post_processing
        CHARACTER(LEN=256)                         :: filename_flow_line_profile
        INTEGER,  DIMENSION(2)                     :: flow_line_profile_flux_criterion
        INTEGER                                    :: amount_of_flow_line_curves
        INTEGER,  DIMENSION(N_curves)              :: starting_grid_number_in_x_direction
        INTEGER,  DIMENSION(N_curves)              :: starting_grid_number_in_y_direction
        INTEGER,  DIMENSION(N_curves)              :: maximum_number_of_flow_line_points
        INTEGER,  DIMENSION(N_curves)              :: number_of_preceding_flow_line_points
        INTEGER,  DIMENSION(N_curves)              :: coarse_grid_number_to_switch_criterion
        REAL(dp), DIMENSION(N_curves)              :: high_resolution_of_flow_line_profiles
        LOGICAL                                    :: follow_close_coarse_flow_line_points
        REAL(dp), DIMENSION(N_curves,20)           :: preceding_longitude_latitude_coordinates
        INTEGER                                    :: N_profile
        LOGICAL                                    :: online_coupled_oblimap
        INTEGER                                    :: embedded_model_iterations
        LOGICAL                                    :: full_scanning_mode
        INTEGER                                    :: unit_scanning_file_content
        CHARACTER(LEN=256)                         :: filename_sid_content
        REAL(dp)                                   :: large_distance
        REAL(dp)                                   :: fls_latitude_border   = 85._dp  ! full longitude scan for high latitude grid rows near the pole
        INTEGER                                    :: fls_grid_range        =  2
        INTEGER                                    :: fls_limited_lat_range = 21


                                                 ! OBLIMAP ELLIPSOID
                                                 !==================
        REAL(dp)                                   :: a
        REAL(dp)                                   :: e
        REAL(dp)                                   :: ellipsoid_flattening
        REAL(dp)                                   :: ellipsoid_semi_minor_axis
        REAL(dp)                                   :: am
        REAL(dp)                                   :: akm
        REAL(dp)                                   :: chi_M

        REAL(dp)                                   :: q_M
        REAL(dp)                                   :: q_polar
        REAL(dp)                                   :: beta_M
        REAL(dp)                                   :: R_q_polar
        REAL(dp)                                   :: D

        LOGICAL                                    :: extrapolate_field_on_mask_edge
        LOGICAL                                    :: extrapolate_ocean_temperature

                                                  ! OBLIMAP TESTING
                                                  ! ===============
        REAL(dp)                                   :: latitude_optc
        REAL(dp)                                   :: longitude_optc

                                                 ! UNIT CONVERSION
                                                 ! ===============
        REAL(dp)                                   :: unit_conversion_x_ax
        REAL(dp)                                   :: unit_conversion_y_ax

                                                 ! CREATE INPUT FIELDS
                                                 ! ===================
        INTEGER                                    :: smooth_radius
        INTEGER                                    :: replace_invalid_values_smooth_radius
        LOGICAL                                    :: replace_invalid_values_by_smooting
        LOGICAL                                    :: adjust_single_gap_points
        REAL(dp)                                   :: single_gap_threshold

                                                 ! REBIN
                                                 ! =====
        INTEGER                                    :: rebin_radius
        REAL(dp)                                   :: x_rebin_factor
        REAL(dp)                                   :: y_rebin_factor
        CHARACTER(LEN=256)                         :: rebin_input_filename
        CHARACTER(LEN=256)                         :: rebin_output_filename

                                                 ! MODIFY
                                                 ! ======
        INTEGER                                    :: NX_modified
        INTEGER                                    :: NY_modified
        INTEGER                                    :: start_index_left_for_modified
        INTEGER                                    :: start_index_bottom_for_modified
        REAL(dp)                                   :: dx_modified
        REAL(dp)                                   :: dy_modified
        CHARACTER(LEN=256)                         :: modify_input_filename
        CHARACTER(LEN=256)                         :: modify_output_filename

                                                 ! CLIMBER INPUT FIELDS
                                                 ! ====================
        LOGICAL                                    :: climber_stand_alone
        REAL(dp)                                   :: dt_coupling
        CHARACTER(LEN=256)                         :: gcm_co2_input_filename
        CHARACTER(LEN=256)                         :: gcm_solar_input_filename
        CHARACTER(LEN=256)                         :: path_to_climber_geo
        CHARACTER(LEN=256)                         :: path_to_climber_inp
        CHARACTER(LEN=256)                         :: path_to_climber_out
        CHARACTER(LEN=256)                         :: path_to_climber_main
        CHARACTER(LEN=256)                         :: climber_run_filename

                                                 ! PHYSICAL PARAMETERS
                                                 ! ===================
        REAL(dp)                                   :: seconds_per_year
        REAL(dp)                                   :: earth_radius
        REAL(dp)                                   :: seawater_temperature
        REAL(dp)                                   :: triple_point_of_water
        REAL(dp)                                   :: gravity_constant
        REAL(dp)                                   :: ice_density
        REAL(dp)                                   :: seawater_density
        REAL(dp)                                   :: fresh_water_density
        REAL(dp)                                   :: rock_density
        REAL(dp)                                   :: mantle_density
        REAL(dp)                                   :: lithosphere_flexural_rigidity
        REAL(dp)                                   :: relaxation_time_bedrock
        REAL(dp)                                   :: rock_heat_capacity
        REAL(dp)                                   :: rock_conductivity
        REAL(dp)                                   :: geothermal_heat_flux
        REAL(dp)                                   :: Claus_Clap_gradient
        REAL(dp)                                   :: A_sliding
        REAL(dp)                                   :: n_flow
        REAL(dp)                                   :: m_enhance_sheet_sia
        REAL(dp)                                   :: m_enhance_sheet_ssa
        REAL(dp)                                   :: m_enhance_shelf
        REAL(dp)                                   :: A_turnover_temperature
        REAL(dp)                                   :: A_low_temp
        REAL(dp)                                   :: A_high_temp
        REAL(dp)                                   :: Q_low_temp
        REAL(dp)                                   :: Q_high_temp
        REAL(dp)                                   :: R_gas
        REAL(dp)                                   :: wet_adiabatic
        REAL(dp)                                   :: dry_adiabatic
        REAL(dp)                                   :: adiabatic_turnover_height
        REAL(dp)                                   :: kappa_0_ice_conductivity
        REAL(dp)                                   :: kappa_e_ice_conductivity
        REAL(dp)                                   :: c_0_specific_heat
        REAL(dp)                                   :: c_Delta_specific_heat
        REAL(dp)                                   :: latent_heat
        REAL(dp)                                   :: Stefan_Bolzmann_constant
        REAL(dp)                                   :: solar_constant
        REAL(dp)                                   :: earth_angular_velocity

                                                 ! SOME CONSTANTS IN ROBIN SOLUTION
                                                 ! ================================
        REAL(dp)                                   :: thermal_conductivity_robin
        REAL(dp)                                   :: thermal_diffusivity_robin
        REAL(dp)                                   :: bottom_temperature_gradient_robin
        REAL(dp)                                   :: delta_Ti_pmp_bottom

        CHARACTER(LEN=16)                          :: ERROR                               ! The allocation is exactly, so it is possible to omit a TRIM on this string
        CHARACTER(LEN=18)                          :: WARNING                             ! The allocation is exactly, so it is possible to omit a TRIM on this string
        CHARACTER(LEN=24)                          :: OBLIMAP_ERROR                       ! The allocation is exactly, so it is possible to omit a TRIM on this string
        CHARACTER(LEN=26)                          :: OBLIMAP_WARNING                     ! The allocation is exactly, so it is possible to omit a TRIM on this string
        CHARACTER(LEN=25)                          :: OBLIMAP_ADVICE                      ! The allocation is exactly, so it is possible to omit a TRIM on this string
      END TYPE constants_type

      ! C is the 'struct' containing all the Constants from the config file and/or the defaults
      TYPE(constants_type), SAVE :: C


      ! This TYPE contains variables which are related to the parallel OBLIMAP implementation using MPI.
      TYPE parallel_type
        INTEGER :: processor_id_process_dependent
        INTEGER :: number_of_processors
        INTEGER :: max_nr_of_lines_per_partition_block ! The maximum numberr of lines per partition block
        INTEGER :: psi_process_dependent               ! Partition starting index
      END TYPE parallel_type

      ! PAR is the 'struct' containing the parallel OBLIMAP implementation using MPI.
      TYPE(parallel_type), SAVE :: PAR


      ! This TYPE contains the derivatives of zeta, which are used in the coordinate transformations
      ! (see Table 3). The components of this type are allocated in the main program
      TYPE zeta_derivatives_type
        REAL(dp), DIMENSION(:,:,:), ALLOCATABLE :: t  ! zeta_t   or  dzeta_dt
        REAL(dp), DIMENSION(:,:,:), ALLOCATABLE :: x  ! zeta_x   or  dzeta_dx
        REAL(dp), DIMENSION(:,:,:), ALLOCATABLE :: y  ! zeta_y   or  dzeta_dy
        REAL(dp), DIMENSION(  :,:), ALLOCATABLE :: z  ! zeta_z   or  dzeta_dz
        REAL(dp), DIMENSION(:,:,:), ALLOCATABLE :: xx ! zeta_xx  or  dzeta_dxx
        REAL(dp), DIMENSION(:,:,:), ALLOCATABLE :: xy ! zeta_xy  or  dzeta_dxy
        REAL(dp), DIMENSION(  :,:), ALLOCATABLE :: xz ! zeta_xz  or  dzeta_dxz
        REAL(dp), DIMENSION(:,:,:), ALLOCATABLE :: yy ! zeta_yy  or  dzeta_dyy
        REAL(dp), DIMENSION(  :,:), ALLOCATABLE :: yz ! zeta_yz  or  dzeta_dyz
      END TYPE zeta_derivatives_type


      ! smb gradients parameter type
      TYPE smb_gradients_type
        REAL(dp) :: a_coef_neg                      ! The coefficient a for the ablation regime in the Helsen et al (2012) smb gradients method [m ice equivalent y^-1]
        REAL(dp) :: a_coef_pos                      ! The coefficient a for the accumulation regime in the Helsen et al (2012) smb gradients method [m ice equivalent y^-1]
        REAL(dp) :: b_coef_neg                      ! The coefficient b for the ablation regime in the Helsen et al (2012) smb gradients method [m ice equivalent y^-1 m^-1]
        REAL(dp) :: b_coef_pos                      ! The coefficient b for the accumulation regime in the Helsen et al (2012) smb gradients method [m ice equivalent y^-1 m^-1]
        REAL(dp) :: smb_pos_min                     ! The minimum value for smb in the accumulation regime (used in the Helsen et al, 2012 smb gradients method) [m ice equivalent y^-1]
        REAL(dp) :: smb_pos_max                     ! The maximum value for smb in the accumulation regime (used in the Helsen et al, 2012 smb gradients method) [m ice equivalent y^-1]
        REAL(dp) :: Hc                              ! The elevation which separates the ablation regime from the accumulation regime (used in the Helsen et al, 2012 smb gradients method) [m ice equivalent y^-1]
        REAL(dp) :: Hs                              ! The elevation used in the climate model to generate the climatology [meter a.s.l.]
        REAL(dp) :: ice_mask                        ! The ice mask used in the climate model to generate the climatology [0-1]
      END TYPE smb_gradients_type


      ! refreezing gradients parameter type
      TYPE refreezing_gradients_type
        REAL(dp) :: a_coef_neg                      ! The coefficient a for the ablation regime in the Helsen et al (2012) refreezing gradients method [m ice equivalent y^-1]
        REAL(dp) :: a_coef_pos                      ! The coefficient a for the accumulation regime in the Helsen et al (2012) refreezing gradients method [m ice equivalent y^-1]
        REAL(dp) :: b_coef_neg                      ! The coefficient b for the ablation regime in the Helsen et al (2012) refreezing gradients method [m ice equivalent y^-1 m^-1]
        REAL(dp) :: b_coef_pos                      ! The coefficient b for the accumulation regime in the Helsen et al (2012) refreezing gradients method [m ice equivalent y^-1 m^-1]
        REAL(dp) :: max                             ! The maximum value for refreezing [m ice equivalent y^-1 m^-1]
      END TYPE refreezing_gradients_type


      ! runoff gradients parameter type
      TYPE runoff_gradients_type
        REAL(dp) :: a_coef                          ! The coefficient a for in runpoff gradients method [m ice equivalent y^-1]:      runoff = a + b * Hs
        REAL(dp) :: b_coef                          ! The coefficient b for the runoff gradients method [m ice equivalent y^-1 m^-1]: runoff = a + b * Hs
        REAL(dp) :: accumulation_ref                ! The reference accumulation [m ice equivalent y^-1 m^-1]
      END TYPE runoff_gradients_type


      TYPE oblimap_scan_parameter_type
        ! This struct contains some crucial scan parameters.
        LOGICAL  :: data_set_is_cyclic_in_longitude ! This should be TRUE for GCM to IM mapping if the gcm data set is cyclic in longitude, i.e. the gcm grid covers the entire 0-360 degrees longitude range
        INTEGER  :: search_block_size               ! The optimal search_block_size which is used in the fast scanning mode to find the nearest projected points of a point close to the previous handled point
        REAL(dp) :: alpha_stereographic             ! The optimal alpha based on the entire grid area, alpha determines the standard paralel in the stereographic projection
        LOGICAL  :: choice_quadrant_method          ! The best interpolation method is selected: a choice between the "quadrant method" (TRUE) or the  "radius method" (FALSE)
        REAL(dp) :: R_search_interpolation          ! The optimal size of the search radius in case the "radius onterpolation method" is used
      END TYPE oblimap_scan_parameter_type


CONTAINS
  SUBROUTINE default_pre_initialization_of_constants()
    ! This routine sets defaults to the gcm_field_name_config and im_field_name_config arrays.
    ! These defaults are set before reading the config file, and will be overwritten if they
    ! appear in the config file.
    IMPLICIT NONE

    gcm_field_name_config(MND:0)   = 'gcm-field-dimension-no-name'
    gcm_field_name_config(  1:MNF) = 'gcm-field-no-name'
    gcm_field_name_config(-7)      = 'NVL'
    gcm_field_name_config(-6)      = 'vertical-coordinate'
    gcm_field_name_config(-5)      = 'NLAT'
    gcm_field_name_config(-4)      = 'latitude'
    gcm_field_name_config(-3)      = 'NLON'
    gcm_field_name_config(-2)      = 'longitude'
    gcm_field_name_config(-1)      = 'NTIME'
    gcm_field_name_config( 0)      = 'time'
    gcm_field_name_config( 1)      = 'gcm-field-1-no-name'
    gcm_field_name_config( 2)      = 'gcm-field-2-no-name'
    gcm_field_name_config( 3)      = 'gcm-field-3-no-name'
    gcm_field_name_config( 4)      = 'gcm-field-4-no-name'
    gcm_field_name_config( 5)      = 'gcm-field-5-no-name'
    gcm_field_name_config( 6)      = 'gcm-field-6-no-name'
    gcm_field_name_config( 7)      = 'gcm-field-7-no-name'
    gcm_field_name_config( 8)      = 'gcm-field-8-no-name'
    gcm_field_name_config( 9)      = 'gcm-field-9-no-name'

    gcm_field_unit_config(:) = 'unit: ?'
    gcm_field_longname_config(:) = 'longname: ?'


    im_field_name_config(MND:0)   = 'im-field-dimension-no-name'
    im_field_name_config(  1:MNF) = 'im-field-no-name'
    im_field_name_config(-7)      = 'NVL'
    im_field_name_config(-6)      = 'vertical-coordinate'
    im_field_name_config(-5)      = 'NY'
    im_field_name_config(-4)      = 'y'
    im_field_name_config(-3)      = 'NX'
    im_field_name_config(-2)      = 'x'
    im_field_name_config(-1)      = 'NTIME'
    im_field_name_config( 0)      = 'time'
    im_field_name_config( 1)      = 'im-field-1-no-name'
    im_field_name_config( 2)      = 'im-field-2-no-name'
    im_field_name_config( 3)      = 'im-field-3-no-name'
    im_field_name_config( 4)      = 'im-field-4-no-name'
    im_field_name_config( 5)      = 'im-field-5-no-name'
    im_field_name_config( 6)      = 'im-field-6-no-name'
    im_field_name_config( 7)      = 'im-field-7-no-name'
    im_field_name_config( 8)      = 'im-field-8-no-name'
    im_field_name_config( 9)      = 'im-field-9-no-name'

    im_field_unit_config(:) = 'unit: ?'
    im_field_longname_config(:) = 'longname: ?'


    prefabricated_im_grid_field_name_config(MND:0)   = 'prefabricated-im-grid-field-dimension-no-name'
    prefabricated_im_grid_field_name_config(  1:MNF) = 'prefabricated-im-grid-field-no-name'
    prefabricated_im_grid_field_name_config(-7)      = 'NVL'
    prefabricated_im_grid_field_name_config(-6)      = 'vertical-coordinate'
    prefabricated_im_grid_field_name_config(-5)      = 'NY'
    prefabricated_im_grid_field_name_config(-4)      = 'y'
    prefabricated_im_grid_field_name_config(-3)      = 'NX'
    prefabricated_im_grid_field_name_config(-2)      = 'x'
    prefabricated_im_grid_field_name_config(-1)      = 'NTIME'
    prefabricated_im_grid_field_name_config( 0)      = 'time'


    forcing_field_name_config(MND:0)   = 'forcing-field-dimension-no-name'
    forcing_field_name_config(  1:MNF) = 'forcing-field-no-name'
    forcing_field_name_config(-7)      = 'NVL'
    forcing_field_name_config(-6)      = 'vertical-coordinate'
    forcing_field_name_config(-5)      = 'NY'
    forcing_field_name_config(-4)      = 'y'
    forcing_field_name_config(-3)      = 'NX'
    forcing_field_name_config(-2)      = 'x'
    forcing_field_name_config(-1)      = 'NTIME'
    forcing_field_name_config( 0)      = 'time'
    forcing_field_name_config( 1)      = 'forcing-field-1-no-name'
    forcing_field_name_config( 2)      = 'forcing-field-2-no-name'
    forcing_field_name_config( 3)      = 'forcing-field-3-no-name'
    forcing_field_name_config( 4)      = 'forcing-field-4-no-name'
    forcing_field_name_config( 5)      = 'forcing-field-5-no-name'
    forcing_field_name_config( 6)      = 'forcing-field-6-no-name'
    forcing_field_name_config( 7)      = 'forcing-field-7-no-name'
    forcing_field_name_config( 8)      = 'forcing-field-8-no-name'
    forcing_field_name_config( 9)      = 'forcing-field-9-no-name'

    forcing_field_unit_config(:) = 'unit: ?'
    forcing_field_longname_config(:) = 'longname: ?'


    latitude_longitude_field_name_config(MND:0)   = 'latitude_longitude-field-dimension-no-name'
    latitude_longitude_field_name_config(  1:MNF) = 'latitude_longitude-field-no-name'
    latitude_longitude_field_name_config(-7)      = 'NVL'
    latitude_longitude_field_name_config(-6)      = 'vertical-coordinate'
    latitude_longitude_field_name_config(-5)      = 'NY'
    latitude_longitude_field_name_config(-4)      = 'y'
    latitude_longitude_field_name_config(-3)      = 'NX'
    latitude_longitude_field_name_config(-2)      = 'x'
    latitude_longitude_field_name_config(-1)      = 'NTIME'
    latitude_longitude_field_name_config( 0)      = 'time'
    latitude_longitude_field_name_config( 1)      = 'latitude_longitude-field-1-no-name'
    latitude_longitude_field_name_config( 2)      = 'latitude_longitude-field-2-no-name'

    forcing_field_unit_config(:) = 'unit: ?'
    forcing_field_longname_config(:) = 'longname: ?'


    geothermal_heat_flux_field_name_config(1) = 'geothermal_heatflux'

    number_of_potential_bottom_melt_layers_config = NZ_config - 1

    C%enable_color_messaging_in_terminal = .TRUE.
    C%ERROR                              = coloring(' ERROR:', 'red')
    C%WARNING                            = coloring(' WARNING:', 'red')
    C%OBLIMAP_ERROR                      = coloring(' OBLIMAP ERROR:', 'red')
    C%OBLIMAP_WARNING                    = coloring(' OBLIMAP WARNING:', 'red')
    C%OBLIMAP_ADVICE                     = coloring(' OBLIMAP ADVICE:', 'yellow')
  END SUBROUTINE default_pre_initialization_of_constants



  SUBROUTINE read_config_file(config_file_number, config_filename)
    ! This subroutine reads the config variables from a configuration file. These config variables
    ! are defined in this module. The name of the configuration file should be specified on the
    ! command line. If no name is specified on the command line, then the default values are used.
    IMPLICIT NONE

    ! Input variables:
    INTEGER           , INTENT(IN) :: config_file_number
    CHARACTER(LEN=256), INTENT(IN) :: config_filename

    ! Local variables:
    INTEGER, PARAMETER             :: config_unit = 28              ! Unit number which is used for the configuration file.
    INTEGER                        :: ios
    CHARACTER(LEN=256)             :: filename_config_variable_list

    ! List of items in the configuration file:
    NAMELIST /CONFIG/NX_config                                                 , &
                     NY_config                                                 , &
                     NZ_config                                                 , &
                     dx_config                                                 , &
                     dy_config                                                 , &
                     zeta_config                                               , &
                     NZL_config                                                , &
                     z_step_config                                             , &
                     NZR_config                                                , &
                     dzr_config                                                , &
                     NLON_config                                               , &
                     NLAT_config                                               , &
                     start_time_of_run_config                                  , &
                     end_time_of_run_config                                    , &
                     dynamic_time_step_addaption_config                        , &
                     dynamic_time_step_sheet_based_config                      , &
                     likely_mean_dynamic_time_step_config                      , &
                     minimal_critical_time_step_config                         , &
                     maximal_critical_time_step_config                         , &
                     time_step_scaler_config                                   , &
                     dt_config                                                 , &
                     dt_thermo_config                                          , &
                     dt_shelf_velocity_config                                  , &
                     dt_bedrock_config                                         , &
                     dt_restart_config                                         , &
                     dt_recording_config                                       , &
                     dt_sort_Hs_config                                         , &
                     dt_smb_config                                             , &
                     dt_gravitational_snow_transport_config                    , &
                     dt_glacier_bed_iteration_config                           , &
                     starting_record_number_config                             , &
                     initial_restart_filename_config                           , &
                     initial_key_fields_filename_config                        , &
                     smb_gradients_filename_config                             , &
                     rfr_gradients_filename_config                             , &
                     runoff_gradients_filename_config                          , &
                     forcing_filename_config                                   , &
                     latitude_longitude_filename_config                        , &
                     insolation_filename_config                                , &
                     ascii_input_data_filename_config                          , &
                     forcing_fields_filename_config                            , &
                     gia_filename_config                                       , &
                     isostatic_equilibrium_filename_config                     , &
                     sst_fields_filename_config                                , &
                     reference_surface_height_filename_config                  , &
                     monotonic_geothermal_heat_flux_config                     , &
                     geothermal_heat_flux_file_name_config                     , &
                     geothermal_heat_flux_field_name_config                    , &
                     size_climate_record_config                                , &
                     Hi_min_config                                             , &
                     maximum_dHi_change_per_year_config                        , &
                     D_uv_3D_cutoff_config                                     , &
                     area_mask_for_total_ice_volume_config                     , &
                     do_temperature_spin_up_config                             , &
                     determine_MB_equilibrium_config                           , &
                     key_fields_filename_config                                , &
                     restart_filename_config                                   , &
                     help_fields_filename_config                               , &
                     extra_fields_filename_config                              , &
                     recording_filename_config                                 , &
                     enable_restart_file_config                                , &
                     enable_recording_file_config                              , &
                     enable_help_fields_file_config                            , &
                     enable_extra_netcdf_file_config                           , &
                     synchronize_netcdf_writing_config                         , &
                     protect_file_overwriting_config                           , &
                     enable_color_messaging_in_terminal_config                 , &
                     which_recording_fields_config                             , &
                     which_help_fields_config                                  , &
                     ignore_some_recording_fields_config                       , &
                     ignore_some_help_fields_config                            , &
                     use_grid_units_in_dimension_config                        , &
                     label_netcdf_fields_with_number_config                    , &
                     use_double_instead_of_float_in_netcdf_config              , &
                     choice_use_mumps_config                                   , &
                     number_of_explicit_shelf_iterations_config                , &
                     mumps_message_level_config                                , &
                     shelf_surface_gradient_one_sided_discretized_config       , &
                     include_shelf_dynamics_config                             , &
                     maximum_number_gauss_seidel_iterations_config             , &
                     gauss_seidel_over_relaxation_parameter_config             , &
                     residual_in_gauss_seidel_convergence_criterion_config     , &
                     initial_velocity_spin_up_config                           , &
                     adjusting_bedrock_config                                  , &
                     assume_isostatic_equilibrium_at_start_config              , &
                     glacier_bed_iteration_run_config                          , &
                     maximum_number_of_bed_iterations_config                   , &
                     minimal_value_mean_residual_bed_iteration_config          , &
                     sealevel_for_reference_load_bedrock_config                , &
                     choice_flux_scheme_config                                 , &
                     ice_flux_intervention_allowed_period_config               , &
                     choice_surface_derivatives_scheme_config                  , &
                     choice_bottom_derivatives_scheme_config                   , &
                     choice_forcing_config                                     , &
                     constant_sealevel_deviation_config                        , &
                     constant_temperature_deviation_config                     , &
                     choice_insolation_forcing_config                          , &
                     size_insolation_record_config                             , &
                     constant_insolation_month_config                          , &
                     constant_insolation_latitude_config                       , &
                     one_dimensional_experiment_config                         , &
                     x_fixed_config                                            , &
                     y_fixed_config                                            , &
                     lowest_z_of_cross_section_config                          , &
                     fake_value_for_bedrock_config                             , &
                     fake_value_for_atmosphere_config                          , &
                     fake_value_for_ocean_config                               , &
                     synthetic_experiment_number_config                        , &
                     experiment_label_config                                   , &
                     reduced_Ti_pmp_threshold_for_sliding_config               , &
                     choice_sliding_method_config                              , &
                     include_sliding_heatflux_config                           , &
                     factor_mininimum_sliding_load_config                      , &
                     dummy_delta_v_config                                      , &
                     q_plastic_config                                          , &
                     u_threshold_yield_stress_scaling_config                   , &
                     scaling_Hb_minimal_friction_angle_config                  , &
                     scaling_Hb_maximal_friction_angle_config                  , &
                     minimal_friction_angle_config                             , &
                     maximal_friction_angle_config                             , &
                     choice_smb_method_config                                  , &
                     choice_concentration_config                               , &
                     choice_Ts_method_config                                   , &
                     mean_Ts_forcing_at_sealevel_config                        , &
                     choice_temperature_model_config                           , &
                     frictional_heating_scale_factor_config                    , &
                     include_horizontal_diffusion_config                       , &
                     choice_temperature_derivatives_scheme_config              , &
                     choice_thermodynamics_scheme_config                       , &
                     choice_3D_velocity_scheme_config                          , &
                     fixed_Ti_at_shelf_bottom_config                           , &
                     linear_temperature_at_shelf_config                        , &
                     include_refreezing_term_via_Ts_config                     , &
                     Ti_fixed_config                                           , &
                     delta_Ti_below_T_pmp_config                               , &
                     registration_limit_low_Ti_config                          , &
                     choice_bmb_model_config                                   , &
                     gauge_points_basal_melt_config                            , &
                     basal_sheet_melt_config                                   , &
                     basal_shelf_melt_config                                   , &
                     grounding_line_melt_config                                , &
                     apply_remaining_mass_balance_config                       , &
                     energetic_bottom_melt_config                              , &
                     number_of_potential_bottom_melt_layers_config             , &
                     maximum_bottom_melt_config                                , &
                     calve_thickness_sheet_config                              , &
                     calve_thickness_shelf_config                              , &
                     initial_time_minimal_calving_config                       , &
                     apply_calving_config                                      , &
                     choice_smooth_MB_config                                   , &
                     gaussian_profile_massbalance_config                       , &
                     include_gravitational_snow_transport_config               , &
                     only_calculate_smb_config                                 , &
                     use_mask_glacier_smb_when_calculate_smb_config            , &
                     south_angle_grid_config                                   , &
                     N_horizon_angles_config                                   , &
                     start_day_smb_config                                      , &
                     number_of_time_steps_per_day_config                       , &
                     temperature_dependent_flux_parameter_c0_config            , &
                     temperature_dependent_flux_parameter_c1_config            , &
                     temperature_dependent_flux_parameter_Tfluxmin_config      , &
                     write_smb_fields_to_extra_help_fields_config              , &
                     number_of_time_steps_per_write_interval_config            , &
                     meteo_input_file_smb_model_config                         , &
                     precipitation_index_map_input_file_config                 , &
                     N_lines_meteo_input_file_smb_config                       , &
                     albedo_water_config                                       , &
                     albedo_soil_config                                        , &
                     albedo_ice_config                                         , &
                     albedo_snow_config                                        , &
                     ablation_constant_insolation_config                       , &
                     ablation_constant_temperature_config                      , &
                     ablation_constant_config                                  , &
                     c_0_specific_heat_ocean_config                            , &
                     mean_ocean_surface_temperature_config                     , &
                     thermal_exchange_velocity_config                          , &
                     subshelf_melt_factor_for_protected_shelves_config         , &
                     subshelf_melt_factor_for_exposed_shelves_config           , &
                     subshelf_melt_factor_for_deep_ocean_config                , &
                     time_of_gia_ascii_record_config                           , &
                     choice_surface_bc_config                                  , &
                     choice_shelf_bottom_bc_config                             , &
                     physic_boundary_conditions_config                         , &
                     physic_bc_for_calving_config                              , &
                     lateral_friction_config                                   , &
                     write_matrix_rhs_format_config                            , &
                     choice_velocity_derivatives_scheme_config                 , &
                     take_dEta_terms_implicit_config                           , &
                     choice_Eta_derivatives_config                             , &
                     number_of_Eta_iterations_config                           , &
                     differentiate_stress_regime_config                        , &
                     simplification_coefficients_config                        , &
                     simplification_coeffi_sheet_config                        , &
                     simplification_coeffi_shelf_config                        , &
                     bottom_sliding_parameters_config                          , &
                     parameterized_shelf_config                                , &
                     R_influence_config                                        , &
                     p_config                                                  , &
                     Nslices_config                                            , &
                     choice_write_message_config                               , &
                     launch_ncview_config                                      , &
                     testing_integer_config                                    , &
                     testing_real_dp_config                                    , &
                     eismint_case_config                                       , &
                     choice_eismint_expt_config                                , &
                     eismint_parameters_config                                 , &
                     mismip_case_config                                        , &
                     mismip_no_shelf_config                                    , &
                     schoof_flux_config                                        , &
                     forcing_record_config                                     , &
                     forcing_record_range_config                               , &
                     number_of_forcing_fields_config                           , &
                     forcing_field_name_config                                 , &
                     forcing_field_unit_config                                 , &
                     forcing_field_longname_config                             , &
                     latitude_longitude_field_name_config                      , &
                     latitude_longitude_field_unit_config                      , &
                     latitude_longitude_field_longname_config                  , &
                     include_gia_config                                        , &
                     gia_record_config                                         , &
                     gia_record_range_config                                   , &
                     gia_field_name_config                                     , &
                     gia_field_unit_config                                     , &
                     gia_field_longname_config                                 , &
                     include_sst_fields_config                                 , &
                     sst_record_config                                         , &
                     sst_record_range_config                                   , &
                     number_of_sst_fields_config                               , &
                     sst_field_name_config                                     , &
                     sst_field_unit_config                                     , &
                     sst_field_longname_config                                 , &
                     number_of_input_fields_config                             , &
                     number_of_smb_gradients_fields_config                     , &
                     n_pos_min_config                                          , &
                     n_neg_min_config                                          , &
                     n_runoff_min_config                                       , &
                     initial_search_radius_config                              , &
                     search_radius_interval_config                             , &
                     choice_use_location_list_config                           , &
                     choice_compute_refreezing_gradients_config                , &
                     choice_smb_output_mieq_config                             , &
                     choice_compute_runoff_gradients_config                    , &
                     choice_compute_smb_timeseries_config                      , &
                     choice_distinction_ablation_accumulation_config           , &
                     smb_gradients_location_list_file_config                   , &
                     oblimap_message_level_config                              , &
                     suppress_check_on_scan_parameters_config                  , &
                     oblimap_allocate_factor_config                            , &
                     choice_projection_method_config                           , &
                     lambda_M_config                                           , &
                     phi_M_config                                              , &
                     alpha_stereographic_config                                , &
                     theta_rotation_projection_config                          , &
                     shift_x_coordinate_rotation_projection_config             , &
                     shift_y_coordinate_rotation_projection_config             , &
                     shepard_exponent_config                                   , &
                     gcm_input_filename_config                                 , &
                     enable_shift_im_grid_config                               , &
                     shift_x_coordinate_im_grid_config                         , &
                     shift_y_coordinate_im_grid_config                         , &
                     alternative_lambda_for_center_im_grid_config              , &
                     alternative_phi_for_center_im_grid_config                 , &
                     gcm_record_range_config                                   , &
                     im_record_range_config                                    , &
                     number_of_vertical_layers_config                          , &
                     number_of_mapped_fields_config                            , &
                     ignore_reading_pre_mapped_fields_config                   , &
                     field_which_determines_invalid_value_mask_config          , &
                     invalid_value_mask_criterion_config                       , &
                     invalid_input_value_config                                , &
                     invalid_output_value_config                               , &
                     gcm_field_name_config                                     , &
                     gcm_field_unit_config                                     , &
                     gcm_field_longname_config                                 , &
                     im_field_name_config                                      , &
                     im_field_unit_config                                      , &
                     im_field_longname_config                                  , &
                     prefabricated_im_grid_field_name_config                   , &
                     field_factor_config                                       , &
                     field_shift_config                                        , &
                     im_created_filename_config                                , &
                     scanning_mode_config                                      , &
                     data_set_is_cyclic_in_longitude_config                    , &
                     level_of_automatic_oblimap_scanning_config                , &
                     scan_search_block_size_config                             , &
                     scan_search_block_size_step_config                        , &
                     choice_quadrant_method_config                             , &
                     R_search_interpolation_config                             , &
                     sid_filename_config                                       , &
                     backward_sid_filename_config                              , &
                     im_input_filename_config                                  , &
                     use_prefabricated_im_grid_coordinates_config              , &
                     prefabricated_im_grid_filename_config                     , &
                     gcm_created_filename_config                               , &
                     nearest_point_assignment_config                           , &
                     vincenty_method_for_ellipsoid_config                      , &
                     reduce_dummy_dimensions_config                            , &
                     do_oblimap_post_processing_config                         , &
                     extrapolate_field_on_mask_edge_config                     , &
                     extrapolate_ocean_temperature_config                      , &
                     filename_flow_line_profile_config                         , &
                     flow_line_profile_flux_criterion_config                   , &
                     amount_of_flow_line_curves_config                         , &
                     starting_grid_number_in_x_direction_config                , &
                     starting_grid_number_in_y_direction_config                , &
                     maximum_number_of_flow_line_points_config                 , &
                     number_of_preceding_flow_line_points_config               , &
                     coarse_grid_number_to_switch_criterion_config             , &
                     high_resolution_of_flow_line_profiles_config              , &
                     follow_close_coarse_flow_line_points_config               , &
                     preceding_longitude_latitude_coordinates_config           , &
                     N_profile_config                                          , &
                     online_coupled_oblimap_config                             , &
                     embedded_model_iterations_config                          , &
                     unit_conversion_x_ax_config                               , &
                     unit_conversion_y_ax_config                               , &
                     latitude_optc_config                                      , &
                     longitude_optc_config                                     , &
                     smooth_radius_config                                      , &
                     replace_invalid_values_smooth_radius_config               , &
                     replace_invalid_values_by_smooting_config                 , &
                     adjust_single_gap_points_config                           , &
                     single_gap_threshold_config                               , &
                     rebin_radius_config                                       , &
                     x_rebin_factor_config                                     , &
                     y_rebin_factor_config                                     , &
                     rebin_input_filename_config                               , &
                     rebin_output_filename_config                              , &
                     NX_modified_config                                        , &
                     NY_modified_config                                        , &
                     start_index_left_for_modified_config                      , &
                     start_index_bottom_for_modified_config                    , &
                     dx_modified_config                                        , &
                     dy_modified_config                                        , &
                     modify_input_filename_config                              , &
                     modify_output_filename_config                             , &
                     climber_stand_alone_config                                , &
                     dt_coupling_config                                        , &
                     gcm_co2_input_filename_config                             , &
                     gcm_solar_input_filename_config                           , &
                     path_to_climber_geo_config                                , &
                     path_to_climber_inp_config                                , &
                     path_to_climber_out_config                                , &
                     path_to_climber_main_config                               , &
                     climber_run_filename_config                               , &
                     seconds_per_year_config                                   , &
                     earth_radius_config                                       , &
                     ellipsoid_semi_major_axis_config                          , &
                     ellipsoid_eccentricity_config                             , &
                     seawater_temperature_config                               , &
                     triple_point_of_water_config                              , &
                     gravity_constant_config                                   , &
                     ice_density_config                                        , &
                     seawater_density_config                                   , &
                     fresh_water_density_config                                , &
                     rock_density_config                                       , &
                     mantle_density_config                                     , &
                     lithosphere_flexural_rigidity_config                      , &
                     relaxation_time_bedrock_config                            , &
                     rock_heat_capacity_config                                 , &
                     rock_conductivity_config                                  , &
                     geothermal_heat_flux_config                               , &
                     Claus_Clap_gradient_config                                , &
                     A_sliding_config                                          , &
                     n_flow_config                                             , &
                     m_enhance_sheet_sia_config                                , &
                     m_enhance_sheet_ssa_config                                , &
                     m_enhance_shelf_config                                    , &
                     A_turnover_temperature_config                             , &
                     A_low_temp_config                                         , &
                     A_high_temp_config                                        , &
                     Q_low_temp_config                                         , &
                     Q_high_temp_config                                        , &
                     R_gas_config                                              , &
                     wet_adiabatic_config                                      , &
                     dry_adiabatic_config                                      , &
                     adiabatic_turnover_height_config                          , &
                     kappa_0_ice_conductivity_config                           , &
                     kappa_e_ice_conductivity_config                           , &
                     c_0_specific_heat_config                                  , &
                     c_Delta_specific_heat_config                              , &
                     latent_heat_config                                        , &
                     Stefan_Bolzmann_constant_config                           , &
                     solar_constant_config                                     , &
                     earth_angular_velocity_config                             , &
                     filename_DEM_config                                       , &
                     filename_MASK_config                                      , &
                     filename_SMB_config                                       , &
                     filename_VEL_config                                       , &
                     filename_BED_config                                       , &
                     filename_K_config                                       , &
                     spinup_time_config

    ! Open the configuration file and read it:
    OPEN(UNIT=config_unit, FILE=TRIM(config_filename), STATUS='OLD', ACTION='READ', IOSTAT=ios)
    IF(ios /= 0) THEN
     WRITE(UNIT=*, FMT='(/3A/)') C%ERROR, ' Could not open the configuration file: ', TRIM(config_filename)
     IF(config_file_number > 1) WRITE(UNIT=*, FMT='(2A/)') C%WARNING, ' Be aware that you are trying to read more than one configuration file.'
     STOP
    END IF

    ! In the following statement the entire configuration file is read, using the namelist (NML=CONFIG)
    READ(UNIT=config_unit, NML=CONFIG, IOSTAT=ios)
    CLOSE(UNIT=config_unit)

    ! Compose the filename of the file which contains the log of the config variable list:
    IF(config_file_number < 10) THEN
     WRITE(filename_config_variable_list, FMT='(A, I1, A)') 'log-config-variable-list-0', config_file_number, '.txt'
    ELSE IF(config_file_number < 100) THEN
     WRITE(filename_config_variable_list, FMT='(A, I2, A)') 'log-config-variable-list-' , config_file_number, '.txt'
    ELSE
     WRITE(UNIT=*, FMT='(/2A/)') C%ERROR, ' The number of config files is currently limited to 100, this can be extended easily in the code.'
     STOP
    END IF

    ! Writing the log of all (initialized) config variables:
    OPEN( UNIT=31082015, FILE=filename_config_variable_list)
    WRITE(UNIT=31082015, NML=CONFIG)
    CLOSE(UNIT=31082015)

    IF(ios /= 0) THEN
     WRITE(UNIT=*, FMT='(/3A)') C%ERROR, ' while reading configuration file: ', TRIM(config_filename)
     CALL checking_the_config_variable_names(config_filename, filename_config_variable_list)
     WRITE(UNIT=*, FMT='(A)') ''
     STOP
    END IF
  END SUBROUTINE read_config_file



  SUBROUTINE checking_the_config_variable_names(config_filename, namelist_filename)
    ! This routine reads one by one the config variable names from the config file and compares
    ! them with the CONFIG NAMELIST. In case a config variable name is not present in the
    ! NAMELIST list this config variable name will be messaged and the program will be stopped.
    ! A few other syntax errors are detected and messaged as well. However, not all errors are
    ! fully explained, like e.g. a wrong array index of a config variable or syntax errors at
    ! the right side of the '=' sign.
    IMPLICIT NONE

    ! Input variables:
    CHARACTER(LEN=*), INTENT(IN) :: config_filename      ! The name of the config file which is given as an argument to the program
    CHARACTER(LEN=*), INTENT(IN) :: namelist_filename    ! The name of the file which contains the printed NAMELIST variables

    ! Local variables:
    CHARACTER(256) :: text_per_line
    INTEGER        :: line_counter
    CHARACTER(256) :: config_variable_name               ! The name of the config variable in the config file which is given as an argument to the program
    CHARACTER(256) :: namelist_variable_name             ! The name of the namelist varibale in the file which contains the printed NAMELIST variables
    INTEGER        :: status
    LOGICAL        :: config_variable_has_been_found
    INTEGER        :: string_index_1
    INTEGER        :: string_index_2
    INTEGER        :: string_index_3

    ! Opening the config file:
    OPEN(UNIT=1188, FILE=config_filename)

    line_counter = 1
    DO
     READ(UNIT=1188, FMT='(A)', IOSTAT=status) text_per_line
     IF (status < 0) exit
     ! Copying the first string of each text line (thus the name of namelist variable), the left part of the string is selected until a '(', 'space' or an 'equal sign' is encountered:
     config_variable_name = capitalize_string(text_per_line(1:SCAN(text_per_line, '( =')-1))

     IF(config_variable_name == '/') THEN
      ! No message for the part of the config file which is not considered
      exit
     ELSE IF(config_variable_name == '' .OR. config_variable_name == '&CONFIG' .OR. config_variable_name(1:1) == '!') THEN
      ! Deselect all lines without config variables.
      ! WRITE(UNIT=*, FMT='(2A)') ' deselected line: ', TRIM(config_variable_name)
     ELSE
        ! Scanning until a ')', 'space' or an 'equal sign' is encountered:
        string_index_1 = SCAN(text_per_line(2:), ') =') + 1

        ! Messaging about other invalid config syntax:
        string_index_2 = SCAN(text_per_line(string_index_1+1:), '=') + string_index_1
        string_index_3 = LEN(TRIM(text_per_line(string_index_1+1:string_index_2-1))) + string_index_1
        IF((text_per_line(string_index_3:string_index_3) /= ' ' .AND. string_index_1 /= string_index_3) .OR. &
           (SCAN(text_per_line(string_index_2 + 1:), '=') > 0) .OR. (SCAN(text_per_line(string_index_1 + 1:), '=') == 0)) THEN
         WRITE(UNIT=*, FMT='(A, I5, 4A)') ' The invalid config syntax at line ', line_counter, ' is: "', TRIM(coloring(text_per_line(string_index_1+1:string_index_3), 'red')), '", the whole line is cited below: '
         WRITE(UNIT=*, FMT='(2A)') ' ', TRIM(coloring(TRIM(text_per_line), 'red'))
        END IF

        ! Opening the config file:
        OPEN(UNIT=1088, FILE=namelist_filename)

        config_variable_has_been_found = .FALSE.
        DO
         READ(UNIT=1088, FMT='(A)', IOSTAT=status) text_per_line
         IF (status < 0) exit
         ! Copy left part of the string (thus the name of namelist variable), the left part of the string is selected until a 'space' or an 'equal sign' is encountered:
         namelist_variable_name = text_per_line(2:SCAN(text_per_line(2:), ' ='))
         IF(namelist_variable_name == '' .OR. namelist_variable_name == 'CONFIG' .OR. namelist_variable_name == '/' .OR. namelist_variable_name(1:1) == '!') THEN
          ! Deselect all lines without namelist variables.
          ! WRITE(UNIT=*, FMT='(2A)') ' deselected line: ', TRIM(namelist_variable_name)
         ELSE IF(namelist_variable_name == config_variable_name) THEN
          config_variable_has_been_found = .TRUE.
          exit
         ELSE
         END IF
        END DO
        IF(.NOT. config_variable_has_been_found) THEN
         WRITE(UNIT=*, FMT='(3A, I5, A)') ' The variable:  ', TRIM(coloring(TRIM(config_variable_name), 'red')), '  at line ', line_counter, ' is not a valid config variable.'
        END IF

        ! Closing the config file:
        CLOSE(UNIT=1088)

     END IF
     line_counter = line_counter + 1
    END DO

    ! Closing the config file:
    CLOSE(UNIT=1188)
  END SUBROUTINE checking_the_config_variable_names



  PURE FUNCTION capitalize_string(string_with_lower_cases) RESULT (string_with_upper_cases)
    ! Changes a string which contains lower case letters to a string with upper case letters
    IMPLICIT NONE

    ! Input variables:
    CHARACTER(LEN=*)                       , INTENT(IN) :: string_with_lower_cases

    ! Result variables:
    CHARACTER(LEN(string_with_lower_cases))             :: string_with_upper_cases

    ! Local variables:
    INTEGER                                             :: i
    INTEGER                                             :: index_cap

    CHARACTER(26), PARAMETER                            :: cap = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
    CHARACTER(26), PARAMETER                            :: low = 'abcdefghijklmnopqrstuvwxyz'

    ! Capitalize each letter if it is lowecase
    string_with_upper_cases = string_with_lower_cases
    DO i = 1, LEN_TRIM(string_with_lower_cases)
     index_cap = INDEX(low, string_with_lower_cases(i:i))
    IF(index_cap > 0) string_with_upper_cases(i:i) = cap(index_cap:index_cap)
    END DO
  END FUNCTION capitalize_string



  FUNCTION coloring(string, color_choice) RESULT(color_string)
    ! This function will create a red color on terminal output for the string argument.
    IMPLICIT NONE

    ! Input variables:
    CHARACTER(LEN=*), INTENT(IN)           :: string
    CHARACTER(LEN=*), INTENT(IN), OPTIONAL :: color_choice

    ! Result variables:
    CHARACTER(LEN=:), ALLOCATABLE          :: color_string

    ALLOCATE(CHARACTER(LEN(string)+9)      :: color_string)       ! The +9 is just enough to store the color characters

    IF(C%enable_color_messaging_in_terminal) THEN
     ! The 91m gives red, 0m sets the default back [Available colors: 90:gray, 91:red, 92:green, 93:yellow, 94:blue, 95:pink, 96:light blue]
     IF(PRESENT(color_choice)) THEN
      SELECT CASE(color_choice)
      CASE('default')
       DEALLOCATE(color_string)
       ALLOCATE(CHARACTER(LEN(string)) :: color_string)
       color_string = string
      CASE('gray')
       color_string = achar(27)//'[90m'//string//achar(27)//'[0m'
      CASE('red')
       color_string = achar(27)//'[91m'//string//achar(27)//'[0m'
      CASE('green')
       color_string = achar(27)//'[92m'//string//achar(27)//'[0m'
      CASE('yellow')
       color_string = achar(27)//'[93m'//string//achar(27)//'[0m'
      CASE('blue')
       color_string = achar(27)//'[94m'//string//achar(27)//'[0m'
      CASE('pink')
       color_string = achar(27)//'[95m'//string//achar(27)//'[0m'
      CASE('light blue')
       color_string = achar(27)//'[96m'//string//achar(27)//'[0m'
      CASE DEFAULT
       WRITE(UNIT=*, FMT='(3A)') ' The function "coloring" needs one of the following keywords: "default", "gray", "red", ', &
                                 ' "green", "yellow", "blue", "pink", "light blue" instead of: ', TRIM(color_choice)
       STOP
      END SELECT
     ELSE
      color_string = achar(27)//'[91m'//string//achar(27)//'[0m'
     END IF
    ELSE
     DEALLOCATE(color_string)
     ALLOCATE(CHARACTER(LEN(string)) :: color_string)
     color_string = string
    END IF

    RETURN

    DEALLOCATE(color_string)
  END FUNCTION coloring



  SUBROUTINE initialize_constants(config_filename)
    ! This routine puts all the constants which will never change during the run after the config file
    ! has been read, into a special constant 'struct'
    IMPLICIT NONE

    ! Input variables:
    CHARACTER(LEN=256), INTENT(IN) :: config_filename

    C%config_filename                                = TRIM(config_filename)                                 ! The name of the config file, for error messaging

    C%enable_color_messaging_in_terminal             = enable_color_messaging_in_terminal_config
    C%ERROR                                          = coloring(' ERROR:', 'red')
    C%WARNING                                        = coloring(' WARNING:', 'red')
    C%OBLIMAP_ERROR                                  = coloring(' OBLIMAP ERROR:', 'red')
    C%OBLIMAP_WARNING                                = coloring(' OBLIMAP WARNING:', 'red')
    C%OBLIMAP_ADVICE                                 = coloring(' OBLIMAP ADVICE:', 'yellow')

    ! IM grid sizes:
    C%NX                                             = NX_config                                             ! Number of IM grid points in the x-direction
    C%NY                                             = NY_config                                             ! Number of IM grid points in the y-direction
    C%dx                                             = dx_config                                             ! IM grid spacing in x-direction [meter]
    C%dy                                             = dy_config                                             ! IM grid spacing in y-direction [meter]

    ! Number of grid points in vertical direction for thermodynamics in ice sheet, if k is a counter
    ! through the vertical layers, k=1 at the surface and k=NZ at the bottom of the ice sheet:
    IF(NZ_config > 210) THEN
     STOP ' The program is STOPPED, because NZ_config in the used config file is too large (little addaption in the configuration_module is required)'
    END IF
    C%NZ                                             = NZ_config
    ALLOCATE(C%zeta(C%NZ))
    C%zeta                                           = zeta_config(1:C%NZ)                                   ! Fortran does not allow a CONFIG/NAMELIST variable to be ALLOCATABLE, therefore this way

    ! Number of grid points in vertical direction for thermodynamics within bedrock, if k is a counter
    ! through the vertical layers, k=1 at the bottom of the bedrock and k=NZR at the ice-bedrock boundary:
    C%NZR                                            = NZR_config
    C%dzr                                            = dzr_config

    ! Number of grid points in the linear vertical direction and the grid spacing:
    C%NZL                                            = NZL_config
    C%z_step                                         = z_step_config
    IF(C%NZL * C%NX * C%NY > 69 * 281 * 281 .AND. C%enable_help_fields_file) THEN
     WRITE(UNIT=*,FMT='(/2A, I5, A/)') C%WARNING, ' The large size of C%NZL = ', C%NZL, ' might lead to allocation problems, at:'
     CALL SYSTEM("grep -iHn ':: var_data_3D_b' ../src/restart_file_module.f90")
     WRITE(UNIT=*,FMT='(/A/)') ''
    END IF

    ! Grid point (j_centerij_center) corresponds to the south pole:
    C%i_center                                       = (C%NX + 1) / 2
    C%j_center                                       = (C%NY + 1) / 2

    ! GCM grid sizes:
    C%NLON                                           = NLON_config                                           ! Number of GCM grid points in the longitudinal-direction
    C%NLAT                                           = NLAT_config                                           ! Number of GCM grid points in the latitudinal-direction

    C%dynamic_time_step_addaption                    = dynamic_time_step_addaption_config                    ! Choice between dynamic addaption of the time step [TRUE], or the default fixed time step [FALSE]
    C%dynamic_time_step_sheet_based                  = dynamic_time_step_sheet_based_config                  ! If TRUE the dynamic time step is based on the CFL criterion at sheet points only
    C%likely_mean_dynamic_time_step                  = likely_mean_dynamic_time_step_config                  ! A likely mean time step which will be used if the maximal_critical_time_step is exceeded in case the dynamical time stepping is used
    C%minimal_critical_time_step                     = minimal_critical_time_step_config                     ! The minimal critical time step, in case of dynamical time stepping
    C%maximal_critical_time_step                     = maximal_critical_time_step_config                     ! The maximal critical time step, in case of dynamical time stepping
    C%time_step_scaler                               = time_step_scaler_config                               ! Time step scaler, which addapts e.g. the time step up to 300% of the critical time step if it is 3
    C%start_time_of_run                              = start_time_of_run_config                              ! Start time of run
    C%end_time_of_run                                = end_time_of_run_config                                ! End time of run
    C%dt                                             = dt_config                                             ! Time step (in years) of run
    C%dt_thermo                                      = dt_thermo_config                                      ! Time step (in years) used for the thermodynamics
    C%dt_shelf_velocity                              = dt_shelf_velocity_config                              ! Time step (in years) used for the shelf velocity
    C%dt_bedrock                                     = dt_bedrock_config                                     ! Time step (in years) for bedrock adjustment
    C%dt_restart                                     = dt_restart_config                                     ! Time step (in years) for writing restart files
    C%dt_recording                                   = dt_recording_config                                   ! Time step (in years) for writing recording files
    C%dt_sort_Hs                                     = dt_sort_Hs_config                                     ! Time step (in years) for sorting the surface elevation array Hs
    C%dt_smb                                         = dt_smb_config                                         ! Time step (in years) for calculation of srface mass balance
    C%dt_gravitational_snow_transport                = dt_gravitational_snow_transport_config                ! Time step (in days)  for calculation gravitational snow transport
    C%dt_glacier_bed_iteration                       = dt_glacier_bed_iteration_config                       ! Time step (in years) for iterative reconstruction of the glacier bed
    C%starting_record_number                         = starting_record_number_config                         ! The number of the netcdf record which is used as the start record

    ! Initialization of the bedrock calculation time interval:
    IF(C%dt_bedrock == 0.0_dp .OR. C%dynamic_time_step_addaption) THEN
     G%dt_bedrock = C%dt
    ElSE
     G%dt_bedrock = C%dt_bedrock
    END IF

    C%monotonic_geothermal_heat_flux                 = monotonic_geothermal_heat_flux_config
    C%geothermal_heat_flux_file_name                 = geothermal_heat_flux_file_name_config
    C%geothermal_heat_flux_field_name                = geothermal_heat_flux_field_name_config

    ! Total length of climate records (i.e. number of times on which climate
    ! records (sealevel and surface temperature are available):
    C%size_climate_record                            = size_climate_record_config


    ! The minimum ice thickness, preventing zero deviding with the scaled coordinate
    C%Hi_min                                         = Hi_min_config
    ! Maximum addaption per time step, in an attempt to get a stable behavior, e.g. at the start of a run. This intervention should disappear after a few hundred of time steps.
    C%maximum_dHi_change_per_year                    = maximum_dHi_change_per_year_config
    G%maximum_dHi_change_per_dt                      = C%maximum_dHi_change_per_year * C%dt

    C%D_uv_3D_cutoff = D_uv_3D_cutoff_config

    C%area_mask_for_total_ice_volume                 = area_mask_for_total_ice_volume_config

    C%do_temperature_spin_up                         = do_temperature_spin_up_config
    C%determine_MB_equilibrium                       = determine_MB_equilibrium_config

    ! The surface mass balance can be handled in several ways:
    !  inverse-smb-determination'                              --> Supposing that the ice cap or glacier is in equilibrium, the smb can be determined inversely
    !  smb-based-on-multiple-forcing-records'                  --> Based on a record of 2D forcing fields, the smb is taken from the last passed record
    !  smb-gradients-method-based-on-multiple-forcing-records' -->
    !  regional-Hs-runoff-relation'                            -->
    !  fixed-x-cross-over-gaussian-smb-parameterization'       -->
    !  eismint-smb-parameterization'                           --> The Eismint massbalance, given by A.J. Payne et al (J. of Glaciology, Vol. 46, No. 153,  2000, pp. 227-238)
    !  oerlemans-smb-parameterization'                         --> A simple massbalance, developed by Oerlemans 1982 (Nature Vol. 297)
    !  antarctic-smb-based-on-Lorius-Jouzel'                   --> Method of Jouzel and Merlivat (1984) for parameterizing inversion temperature Tinv
    !  hardangerjokulen-smb-parameterization'                  -->
    !  smb-based-on-itm-model-climber'                         -->
    C%choice_smb_method                              = choice_smb_method_config
    C%choice_bmb_model                               = choice_bmb_model_config
    C%gauge_points_basal_melt                        = gauge_points_basal_melt_config
    C%basal_sheet_melt                               = basal_sheet_melt_config
    C%basal_shelf_melt                               = basal_shelf_melt_config
    C%grounding_line_melt                            = grounding_line_melt_config
    C%apply_remaining_mass_balance                   = apply_remaining_mass_balance_config                   ! If True the remaining mass balance which could not be applied due to a lack of available ice will be applied to the renewed available ice after the ice flux redistribution
    C%energetic_bottom_melt                          = energetic_bottom_melt_config
    C%number_of_potential_bottom_melt_layers         = number_of_potential_bottom_melt_layers_config         ! The number of potential bottom melt layers, default equal to all layers: C%NZ-1, starting at the bottom layer, so if 1 then only the bottom layer is taken into account and eventual dtected melt in higher layers is ignored
    C%maximum_bottom_melt                            = maximum_bottom_melt_config                            ! Maximum bottom melt [meter per year, a positive maximum value should be specified]
    C%calve_thickness_sheet                          = calve_thickness_sheet_config
    C%calve_thickness_shelf                          = calve_thickness_shelf_config
    C%initial_time_minimal_calving                   = initial_time_minimal_calving_config
    C%apply_calving                                  = apply_calving_config
    C%choice_smooth_MB                               = choice_smooth_MB_config
    C%gaussian_profile_massbalance                   = gaussian_profile_massbalance_config
    C%include_gravitational_snow_transport           = include_gravitational_snow_transport_config
    C%only_calculate_smb                             = only_calculate_smb_config
    C%use_mask_glacier_smb_when_calculate_smb        = use_mask_glacier_smb_when_calculate_smb_config
    C%south_angle_grid                               = south_angle_grid_config
    C%N_horizon_angles                               = N_horizon_angles_config
    C%start_day_smb                                  = start_day_smb_config
    C%number_of_time_steps_per_day                   = number_of_time_steps_per_day_config
    C%temperature_dependent_flux_parameter_c0        = temperature_dependent_flux_parameter_c0_config
    C%temperature_dependent_flux_parameter_c1        = temperature_dependent_flux_parameter_c1_config
    C%temperature_dependent_flux_parameter_Tfluxmin  = temperature_dependent_flux_parameter_Tfluxmin_config
    C%write_smb_fields_to_extra_help_fields          = write_smb_fields_to_extra_help_fields_config
    C%number_of_time_steps_per_write_interval        = number_of_time_steps_per_write_interval_config
    C%meteo_input_file_smb_model                     = meteo_input_file_smb_model_config
    C%precipitation_index_map_input_file             = precipitation_index_map_input_file_config
    C%N_lines_meteo_input_file_smb                   = N_lines_meteo_input_file_smb_config
    C%spinup_time                                    = spinup_time_config 

    ! Insolation-Temperature Melt model parameters:
    C%albedo_water                                   = albedo_water_config                                   ! Albedo of ocean water
    C%albedo_soil                                    = albedo_soil_config                                    ! Albedo of bare rock
    C%albedo_ice                                     = albedo_ice_config                                     ! Albedo of (glacier) ice
    C%albedo_snow                                    = albedo_snow_config                                    ! Albedo of (fresh) snow
    C%ablation_constant_insolation                   = ablation_constant_insolation_config                   ! Melt parameter for insolation (transmissivity of the atmosphere)
    C%ablation_constant_temperature                  = ablation_constant_temperature_config                  ! Melt paramter for temperature - LW+LH+SH
    C%ablation_constant                              = ablation_constant_config                              ! Constant melt parameter - LW+LH+SH

    ! Sub shelf oceanic melt parameters:
    C%c_0_specific_heat_ocean                        = c_0_specific_heat_ocean_config                        ! Specific heat capacity of the ocean mixed layer [J kg-1 K-1]
    C%mean_ocean_surface_temperature                 = mean_ocean_surface_temperature_config                 ! The mean ocean surface temperature [K]
    C%thermal_exchange_velocity                      = thermal_exchange_velocity_config                      ! Thermal exchange velocity [m s-1]
    C%subshelf_melt_factor_for_protected_shelves     = subshelf_melt_factor_for_protected_shelves_config     ! Scaling factor for submarine melting of protected shelves [-]
    C%subshelf_melt_factor_for_exposed_shelves       = subshelf_melt_factor_for_exposed_shelves_config       ! Scaling factor for submarine melting of exposed shelves [-]
    C%subshelf_melt_factor_for_deep_ocean            = subshelf_melt_factor_for_deep_ocean_config            ! Scaling factor for submarine melting of deep ocean [-]

    C%time_of_gia_ascii_record                       = time_of_gia_ascii_record_config                       ! The time of the GIA relative sealevel of each record [years]

    C%choice_concentration                           = choice_concentration_config

    C%choice_Ts_method                               = choice_Ts_method_config
    C%mean_Ts_forcing_at_sealevel                    = mean_Ts_forcing_at_sealevel_config                    ! The mean surface temperture at sealevel [Kelvin]
    C%choice_temperature_model                       = choice_temperature_model_config
    C%frictional_heating_scale_factor                = frictional_heating_scale_factor_config                ! Option to scale the frictional heating contribution in the thermodynamical equation
    C%include_horizontal_diffusion                   = include_horizontal_diffusion_config                   ! Option to include the horizontal temperature diffusion
    C%choice_temperature_derivatives_scheme          = choice_temperature_derivatives_scheme_config
    C%choice_thermodynamics_scheme                   = choice_thermodynamics_scheme_config
    C%choice_3D_velocity_scheme                      = choice_3D_velocity_scheme_config
    C%fixed_Ti_at_shelf_bottom                       = fixed_Ti_at_shelf_bottom_config
    C%linear_temperature_at_shelf                    = linear_temperature_at_shelf_config
    C%include_refreezing_term_via_Ts                 = include_refreezing_term_via_Ts_config
    C%Ti_fixed                                       = Ti_fixed_config
    C%delta_Ti_below_T_pmp                           = delta_Ti_below_T_pmp_config
    C%registration_limit_low_Ti                      = registration_limit_low_Ti_config

    ! Eismint experiments:
    C%eismint_case                                   = eismint_case_config
    C%choice_eismint_experiment                      = choice_eismint_expt_config
    C%eismint_parameters                             = eismint_parameters_config

    ! MISMIP experiments:
    C%mismip_case                                    = mismip_case_config
    C%mismip_no_shelf                                = mismip_no_shelf_config
    C%schoof_flux                                    = schoof_flux_config

    C%adjusting_bedrock                              = adjusting_bedrock_config
    C%assume_isostatic_equilibrium_at_start          = assume_isostatic_equilibrium_at_start_config

    C%glacier_bed_iteration_run                      = glacier_bed_iteration_run_config
    C%maximum_number_of_bed_iterations               = maximum_number_of_bed_iterations_config
    C%minimal_value_mean_residual_bed_iteration      = minimal_value_mean_residual_bed_iteration_config
    C%sealevel_for_reference_load_bedrock            = sealevel_for_reference_load_bedrock_config            ! The sealevel corresponding with the reference load for the the bedrock adjustment [m], relative to pd_sealevel

    ! Choice of flux scheme in the ice thickness calculation:
    C%choice_flux_scheme                             = choice_flux_scheme_config
    C%ice_flux_intervention_allowed_period           = ice_flux_intervention_allowed_period_config
    C%choice_surface_derivatives_scheme              = choice_surface_derivatives_scheme_config
    C%choice_bottom_derivatives_scheme               = choice_bottom_derivatives_scheme_config

    ! We use a mask array to store the type of land in each grid point. The following types of land are allowed:
    C%type_sheet                                     = 1
    C%type_groundline                                = 2
    C%type_shelf                                     = 3
    C%type_calveline                                 = 4
    C%type_ocean                                     = 5

    C%mask_inactive                                  =   -5
    C%mask_unknown                                   = -100
    C%mask_single_point                              =    4
    C%mask_central_point                             =    0
    C%mask_left_edge_point                           =   -1
    C%mask_left_edge_only_two_points                 =   -2
    C%mask_left_edge_single_point                    =   -3
    C%mask_right_edge_point                          =    1
    C%mask_right_edge_only_two_points                =    2
    C%mask_right_edge_single_point                   =    3

    ! The sealevel & temperature difference (per year) forcing, can be determined in different ways:
    C%choice_forcing                                 = choice_forcing_config
    C%constant_sealevel_deviation                    = constant_sealevel_deviation_config
    C%constant_temperature_deviation                 = constant_temperature_deviation_config
    C%choice_insolation_forcing                      = choice_insolation_forcing_config
    C%size_insolation_record                         = size_insolation_record_config
    C%constant_insolation_month                      = constant_insolation_month_config                      ! Months: 1 = January
    C%constant_insolation_latitude                   = constant_insolation_latitude_config                   ! Degrees North

    ! Sliding choices:
    C%reduced_Ti_pmp_threshold_for_sliding           = reduced_Ti_pmp_threshold_for_sliding_config
    C%choice_sliding_method                          = choice_sliding_method_config
    C%include_sliding_heatflux                       = include_sliding_heatflux_config
    C%factor_mininimum_sliding_load                  = factor_mininimum_sliding_load_config


    C%include_weertman_sliding                         = .FALSE.
    C%include_eismint_sliding                          = .FALSE.
    C%do_sliding_at_all_grounded_points                = .FALSE.
    C%include_sliding_with_ice_stream_by_ssa_approach  = .FALSE.
    SELECT CASE(C%choice_sliding_method)
    CASE('no-sliding')
     ! All sliding options remain FALSE
    CASE('weertman-sliding-for-points-near-ti-pmp')
     C%include_weertman_sliding                        = .TRUE.
    CASE('weertman-sliding-at-all-grounded-points')
     C%include_weertman_sliding                        = .TRUE.
     C%do_sliding_at_all_grounded_points               = .TRUE.
    CASE('eismint-sliding-for-points-near-ti-pmp')
    !C%include_eismint_sliding                         = .TRUE.
     C%include_weertman_sliding                        = .TRUE.
    CASE('eismint-sliding-at-all-grounded-points')
    !C%include_eismint_sliding                         = .TRUE.
     C%include_weertman_sliding                        = .TRUE.
     C%do_sliding_at_all_grounded_points               = .TRUE.
    CASE('sliding-with-ice-stream-by-ssa-approach')
     C%include_sliding_with_ice_stream_by_ssa_approach = .TRUE.
    CASE DEFAULT
     WRITE(UNIT=*, FMT= '(/3A/, A)') C%ERROR, ' Invalid value for:  choice_sliding_method_config = ', TRIM(C%choice_sliding_method), '        The used config file is: '//TRIM(C%config_filename)
     STOP
    END SELECT

    C%dummy_delta_v                                  = dummy_delta_v_config                                  ! To prevent a zero basal drag (beta_base), same as Bueler & Brown, 2009 (PISM)
    C%q_plastic                                      = q_plastic_config                                      ! Parameter used for basal stress (inverse of m_flow)
    C%u_threshold_yield_stress_scaling               = u_threshold_yield_stress_scaling_config               ! Scaling of the yield stress to get the correct unit (function of q_plastic) (m/s)
    C%scaling_Hb_minimal_friction_angle              = scaling_Hb_minimal_friction_angle_config              ! Scale height for the minimum friction angle (m)
    C%scaling_Hb_maximal_friction_angle              = scaling_Hb_maximal_friction_angle_config              ! Scale height for the maximum friction angle (m)
    C%minimal_friction_angle                         = minimal_friction_angle_config                         ! Minimum value of the friction angle for calculating the basal yield stress
    C%maximal_friction_angle                         = maximal_friction_angle_config                         ! Maximum value of the friction angle for calculating the basal yield stress

    ! Using the MUMPS routines to solve the eliptical shelf equations:
    C%choice_use_mumps                               = choice_use_mumps_config
    C%number_of_explicit_shelf_iterations            = number_of_explicit_shelf_iterations_config
    C%mumps_message_level                            = mumps_message_level_config

    ! Choosing between using the dHi and the dHs in the shelf scheme:
    C%shelf_surface_gradient_one_sided_discretized   = shelf_surface_gradient_one_sided_discretized_config   ! If TRUE the shelf routines use the one sided discretized surface gradient for the shelf routines
    C%include_shelf_dynamics                         = include_shelf_dynamics_config
    C%include_gia                                    = include_gia_config
    C%include_sst_fields                             = include_sst_fields_config
    C%maximum_number_gauss_seidel_iterations         = maximum_number_gauss_seidel_iterations_config         ! Maximum number of iterations, determines the behaviour of the solver
    C%gauss_seidel_over_relaxation_parameter         = gauss_seidel_over_relaxation_parameter_config         ! Relaxation parameter (omega), determines the behaviour of the solver
    C%residual_in_gauss_seidel_convergence_criterion = residual_in_gauss_seidel_convergence_criterion_config ! Stop criterion (epsilon). The residual should drop below this value everywhere, determines the behaviour of the solver
    C%initial_velocity_spin_up                       = initial_velocity_spin_up_config
    C%epsilon_sq_0                                   = 1.0E-30_dp

    ! Cross section experiments:
    C%one_dimensional_experiment                     = one_dimensional_experiment_config                     ! Possible values: 'no' (default) or 'in-x-direction' or 'in-y-direction'
    C%x_fixed                                        = x_fixed_config                                        ! The fixed i value for which two vertical cross section in the y-direction is made
    C%y_fixed                                        = y_fixed_config                                        ! The fixed j value for which two vertical cross section in the x-direction is made
    C%lowest_z_of_cross_section                      = lowest_z_of_cross_section_config
    ! The fake values enable to set the values of the surrounding bedrock, atmosphere and ocean fields, to optimalize the color scaling of the displayed field:
    C%fake_value_for_bedrock                         = fake_value_for_bedrock_config                         ! C%fake_value_for_bedrock    = (U_in_netcdf, V_in_netcdf, W_in_netcdf, Ti_in_netcdf, default_in_netcdf)
    C%fake_value_for_atmosphere                      = fake_value_for_atmosphere_config                      ! C%fake_value_for_atmosphere = (U_in_netcdf, V_in_netcdf, W_in_netcdf, Ti_in_netcdf, default_in_netcdf)
    C%fake_value_for_ocean                           = fake_value_for_ocean_config                           ! C%fake_value_for_ocean      = (U_in_netcdf, V_in_netcdf, W_in_netcdf, Ti_in_netcdf, default_in_netcdf)
    C%synthetic_experiment_number                    = synthetic_experiment_number_config
    C%experiment_label                               = experiment_label_config

    ! Full stokes:
    C%choice_surface_bc                              = choice_surface_bc_config                              ! If '1': momentum only, if '2': neumann condition, if '3': dirichlet condition, if '4': continuity
    C%choice_shelf_bottom_bc                         = choice_shelf_bottom_bc_config                         ! If '1': momentum only, if '2': neumann condition, if '3': dirichlet condition, if '4': continuity
    C%physic_boundary_conditions                     = physic_boundary_conditions_config                     ! If TRUE the 'new' boundary conditions are used
    C%physic_bc_for_calving                          = physic_bc_for_calving_config                          ! If TRUE the calving boundary conditions are used
    C%lateral_friction                               = lateral_friction_config                               ! If TRUE lateral friction is simulated at the back and front sides of the shelf
    C%write_matrix_rhs_format                        = write_matrix_rhs_format_config                        ! If TRUE the matrix and rhs format are written
    C%choice_velocity_derivatives_scheme             = choice_velocity_derivatives_scheme_config             ! The choice concerning the scheme with which dU_dx, dU_dy, ..., dW_dzeta are calculated
    C%take_dEta_terms_implicit                       = take_dEta_terms_implicit_config
    C%choice_Eta_derivatives                         = choice_Eta_derivatives_config
    C%number_of_Eta_iterations                       = number_of_Eta_iterations_config
    C%differentiate_stress_regime                    = differentiate_stress_regime_config                    ! Differentiate in stress regimes by taking different simplification factors for sheet and shelf
    C%simplification_coefficients                    = simplification_coefficients_config
    C%simplification_coeffi_sheet                    = simplification_coeffi_sheet_config
    C%simplification_coeffi_shelf                    = simplification_coeffi_shelf_config
    C%bottom_sliding_parameters                      = bottom_sliding_parameters_config

    ! Parameters and values used for the parameterization of the shelf:
    C%parameterized_shelf                            = parameterized_shelf_config                            ! If TRUE the parameterization is used for the shelf
    C%gd                                             = C%dx                                                  ! gd: grid distance (equidistant grid in x and y-direction)
    C%n_scale                                        = 20000_dp/C%gd
    C%R_influence                                    = R_influence_config                                    ! R_influence is the influence-radius (400km)
    C%p                                              = p_config                                              ! p is the exponent which determines the weighting of the distance between I and P
    C%Q0                                             = 2.6756e-06_dp                                         ! (maxima) scaled for a R_influence=400km
    C%Q                                              = C%Q0*((C%n_scale)**(C%p+1.0_dp))*(C%gd**(C%p))        ! Precise scaled on R_influence = 400 km
    ! If gd does not match exactly Ngd times in R_influence, we choose to round upwards;
    C%Ngd                                            = INT(ceiling(C%R_influence/C%gd))                      ! N times gd = R_influence
    ! Number of rows will be much less than (2(N+1))^2, 3 collumns: phi, phiA and phiB:
    C%Nslices                                        = Nslices_config                                        ! Number of slices in the shelf_parameterizing_by_slices routine
    C%Fsi                                            = INT(22.5_dp * REAL(C%Nslices,dp) / 360.0_dp + 1.0_dp) ! Furthest slice involved

    C%pi                                             = 2.0_dp * ACOS(0.0_dp)                                 ! Just pi=3.14159... exactly
    C%degrees_to_radians                             = C%pi / 180.0_dp                                       ! Conversion factor between radians and degrees
    C%radians_to_degrees                             = 180.0_dp / C%pi                                       ! Conversion factor between degrees and radians

    ! Testing variables: these variables should only be used for testing and debugging new features:
    C%testing_integer                                = testing_integer_config                                ! For temporary testing with an integer, avoiding compiling between
    C%testing_real_dp                                = testing_real_dp_config                                ! For temporary testing with a real(dp), avoiding compiling between

    ! File names:
    C%initial_restart_filename                       = initial_restart_filename_config
    C%initial_key_fields_filename                    = initial_key_fields_filename_config
    C%smb_gradients_filename                         = smb_gradients_filename_config
    C%rfr_gradients_filename                         = rfr_gradients_filename_config
    C%runoff_gradients_filename                      = runoff_gradients_filename_config
    C%forcing_filename                               = forcing_filename_config
    C%latitude_longitude_filename                    = latitude_longitude_filename_config
    C%insolation_filename                            = insolation_filename_config
    C%ascii_input_data_filename                      = ascii_input_data_filename_config
    C%forcing_fields_filename                        = forcing_fields_filename_config
    C%gia_filename                                   = gia_filename_config                                   ! The name of the Glacial isostatic adjustment (GIA) file
    C%isostatic_equilibrium_filename                 = isostatic_equilibrium_filename_config                 ! The name of the file that contains the fields of bedrock and ice thickness in isostatic equilibrium
    C%sst_fields_filename                            = sst_fields_filename_config                            ! The name of the sea surface temperature file
    C%reference_surface_height_filename              = reference_surface_height_filename_config
    C%key_fields_filename                            = TRIM(key_fields_filename_config)
    C%restart_filename                               = TRIM(restart_filename_config)
    C%recording_filename                             = TRIM(recording_filename_config)
    C%help_fields_filename                           = TRIM(help_fields_filename_config)
    C%extra_fields_filename                          = TRIM(extra_fields_filename_config)
    C%enable_restart_file                            = enable_restart_file_config
    C%enable_recording_file                          = enable_recording_file_config
    C%enable_help_fields_file                        = enable_help_fields_file_config
    C%enable_extra_netcdf_file                       = enable_extra_netcdf_file_config
    C%synchronize_netcdf_writing                     = synchronize_netcdf_writing_config                     ! If True the netcdf writing will be synchronized after each record which is an advantage in case the program is aborted or crashed because all fields up to then are written. But it can be signifcantly slower.
    C%protect_file_overwriting                       = protect_file_overwriting_config
    C%climber_stand_alone                            = climber_stand_alone_config                            ! For running CLIMBER uncoupled stand alone the climber_stand_alone_config should be set to TRUE
    C%dt_coupling                                    = dt_coupling_config                                    ! The time step of the coupling, i.e. every dt_coupling_config the IM fields are mapped by OBLIMAP to the GCM, the GCM runs, and the GCM fields are mapped backwards with OBLIMAP.
    C%gcm_co2_input_filename                         = gcm_co2_input_filename_config
    C%gcm_solar_input_filename                       = gcm_solar_input_filename_config
    C%path_to_climber_geo                            = path_to_climber_geo_config
    C%path_to_climber_inp                            = path_to_climber_inp_config
    C%path_to_climber_out                            = path_to_climber_out_config
    C%path_to_climber_main                           = path_to_climber_main_config
    C%climber_run_filename                           = climber_run_filename_config
    C%filename_DEM                                   = TRIM(filename_DEM_config)
    C%filename_MASK                                  = TRIM(filename_MASK_config)
    C%filename_SMB                                   = TRIM(filename_SMB_config)
    C%filename_VEL                                   = TRIM(filename_VEL_config)
    C%filename_BED                                   = TRIM(filename_BED_config)
    C%filename_K                                     = TRIM(filename_K_config)

    ! This number decides which help_fields fields will be printed to the netcdf file help_fields.nc:
    C%which_recording_fields                         = which_recording_fields_config
    C%which_help_fields                              = which_help_fields_config
    C%ignore_some_recording_fields                   = ignore_some_recording_fields_config
    C%ignore_some_help_fields                        = ignore_some_help_fields_config
    C%use_grid_units_in_dimension                    = use_grid_units_in_dimension_config
    C%label_netcdf_fields_with_number                = label_netcdf_fields_with_number_config
    C%use_double_instead_of_float_in_netcdf          = use_double_instead_of_float_in_netcdf_config

    ! Units used for log and error messages:
    C%stdlog                                         = 800
    C%stderr                                         = 801
    ! A lot of messages are only written to the screen if the variable below is TRUE:
    C%choice_write_message                           = choice_write_message_config
    C%launch_ncview                                  = launch_ncview_config


    ! Default pre initialization of the extra field field names and units etc:
    C%extra_field_choice_1_name(:)                   = 'extra-field-no-name'
    C%extra_field_choice_1_unit(:)                   = 'unit: ?'
    C%extra_field_choice_1_longname(:)               = 'longname: ?'
    C%extra_field_choice_1_description(:)            = 'description: ?'

    C%extra_field_choice_2_name(:)                   = 'extra-field-no-name'
    C%extra_field_choice_2_unit(:)                   = 'unit: ?'
    C%extra_field_choice_2_longname(:)               = 'longname: ?'
    C%extra_field_choice_2_description(:)            = 'description: ?'

    C%extra_field_choice_3_name(:)                   = 'extra-field-no-name'
    C%extra_field_choice_3_unit(:)                   = 'unit: ?'
    C%extra_field_choice_3_longname(:)               = 'longname: ?'
    C%extra_field_choice_3_description(:)            = 'description: ?'

    C%extra_field_choice_4_name(:)                   = 'extra-field-no-name'
    C%extra_field_choice_4_unit(:)                   = 'unit: ?'
    C%extra_field_choice_4_longname(:)               = 'longname: ?'
    C%extra_field_choice_4_description(:)            = 'description: ?'

    C%extra_field_choice_5_name(:)                   = 'extra-field-no-name'
    C%extra_field_choice_5_unit(:)                   = 'unit: ?'
    C%extra_field_choice_5_longname(:)               = 'longname: ?'
    C%extra_field_choice_5_description(:)            = 'description: ?'

    ! Initialization of the extra field field names and units etc:
    C%extra_field_choice_1_name( 1)                  = 'Bn              '
    C%extra_field_choice_1_name( 2)                  = 'Bw              '
    C%extra_field_choice_1_name( 3)                  = 'liq_water_day   '
    C%extra_field_choice_1_name( 4)                  = 'SWin_day        '
    C%extra_field_choice_1_name( 5)                  = 'SWnet_day       '
    C%extra_field_choice_1_name( 6)                  = 'alb_day         '
    C%extra_field_choice_1_name( 7)                  = 'precip_day      '
    C%extra_field_choice_1_name( 8)                  = 'Tair_day        '
    C%extra_field_choice_1_name( 9)                  = 'T_flux_day      '
    C%extra_field_choice_1_name(10)                  = 'Eflux_day       '
    C%extra_field_choice_1_name(11)                  = 'snowdep         '

    C%extra_field_choice_1_unit( 1)                  = 'm.w.e.'
    C%extra_field_choice_1_unit( 2)                  = 'm.w.e.'
    C%extra_field_choice_1_unit( 3)                  = 'm w.e.'
    C%extra_field_choice_1_unit( 4)                  = 'W m^-2'
    C%extra_field_choice_1_unit( 5)                  = 'W m^-2'
    C%extra_field_choice_1_unit( 6)                  = '-'
    C%extra_field_choice_1_unit( 7)                  = 'm.w.e.'
    C%extra_field_choice_1_unit( 8)                  = 'degr C'
    C%extra_field_choice_1_unit( 9)                  = 'W m^-2'
    C%extra_field_choice_1_unit(10)                  = 'W m^-2'
    C%extra_field_choice_1_unit(11)                  = 'm.w.e.'

    C%extra_field_choice_2_name( 1)                  = 'Bn              '
    C%extra_field_choice_2_name( 2)                  = 'liq_water_day   '
    C%extra_field_choice_2_name( 3)                  = 'snowdep         '

    C%extra_field_choice_2_unit( 1)                  = 'm.w.e.'
    C%extra_field_choice_2_unit( 2)                  = 'm.w.e.'
    C%extra_field_choice_2_unit( 3)                  = 'm w.e.'

    C%extra_field_choice_3_name( 1)                  = 'mask_reference_glacier        '
    C%extra_field_choice_3_name( 2)                  = 'diff_Hs_mod_minus_Hs_ref      '
    C%extra_field_choice_3_name( 3)                  = 'bed_adjustment                '
    C%extra_field_choice_3_name( 4)                  = 'ice_thickness_adjustment      '
    C%extra_field_choice_3_name( 5)                  = 'diff_Hb_adjustment_average_ice_free_over_3x3_gridpoints'
    C%extra_field_choice_3_name( 6)                  = 'Hb_with_margin_best_value     '
    C%extra_field_choice_3_name( 7)                  = 'margin_reset_Hb               '
    C%extra_field_choice_3_name( 8)                  = 'Hb_margin_reset_range         '
    C%extra_field_choice_3_name( 9)                  = 'diff_Hb_margin_minus_Hb_adj   '
    C%extra_field_choice_3_name( 10)                 = 'Abs_vel_deformation           '
    C%extra_field_choice_3_name( 11)                 = 'Abs_vel_sliding               '
    C%extra_field_choice_3_name( 12)                 = 'Abs_vel_mod                   '
    C%extra_field_choice_3_name( 13)                 = 'Abs_vel_obs                   '
    C%extra_field_choice_3_name( 14)                 = 'Abs_vel_diff_mod_minus_obs    '

    C%extra_field_choice_3_unit( 1)                  = 'logical'
    C%extra_field_choice_3_unit( 2)                  = 'm'
    C%extra_field_choice_3_unit( 3)                  = 'm'
    C%extra_field_choice_3_unit( 4)                  = 'm'
    C%extra_field_choice_3_unit( 5)                  = 'm'
    C%extra_field_choice_3_unit( 6)                  = 'm'
    C%extra_field_choice_3_unit( 7)                  = 'm'
    C%extra_field_choice_3_unit( 8)                  = 'm'
    C%extra_field_choice_3_unit( 9)                  = 'm'
    C%extra_field_choice_3_unit( 10)                 = 'm yr-1'
    C%extra_field_choice_3_unit( 11)                 = 'm yr-1'
    C%extra_field_choice_3_unit( 12)                 = 'm yr-1'
    C%extra_field_choice_3_unit( 13)                 = 'm yr-1'
    C%extra_field_choice_3_unit( 14)                 = 'm yr-1'
 
    C%forcing_record                                 = forcing_record_config
    C%forcing_record_range                           = forcing_record_range_config
    C%number_of_forcing_fields                       = number_of_forcing_fields_config
    C%forcing_field_name                             = forcing_field_name_config
    C%forcing_field_unit                             = forcing_field_unit_config
    C%forcing_field_longname                         = forcing_field_longname_config

    C%latitude_longitude_field_name                  = latitude_longitude_field_name_config
    C%latitude_longitude_field_unit                  = latitude_longitude_field_unit_config
    C%latitude_longitude_field_longname              = latitude_longitude_field_longname_config

    C%number_of_input_fields                         = number_of_input_fields_config
    C%number_of_smb_gradients_fields                 = number_of_smb_gradients_fields_config

    C%smb_gradients_field_name(MND:0)                = 'smb_gradients-field-dimension-no-name'
    C%smb_gradients_field_name(  1:MNF)              = 'smb_gradients-field-no-name'
    C%smb_gradients_field_name(-7)                   = 'NVL'
    C%smb_gradients_field_name(-6)                   = 'vertical-coordinate'
    C%smb_gradients_field_name(-5)                   = 'NLAT'
    C%smb_gradients_field_name(-4)                   = 'latitude'
    C%smb_gradients_field_name(-3)                   = 'NLON'
    C%smb_gradients_field_name(-2)                   = 'longitude'
    C%smb_gradients_field_name(-1)                   = 'NTIME'
    C%smb_gradients_field_name( 0)                   = 'time'
    C%smb_gradients_field_name( 1)                   = 'a_coef_neg'
    C%smb_gradients_field_name( 2)                   = 'a_coef_neg_se'
    C%smb_gradients_field_name( 3)                   = 'a_coef_pos'
    C%smb_gradients_field_name( 4)                   = 'a_coef_pos_se'
    C%smb_gradients_field_name( 5)                   = 'b_coef_neg'
    C%smb_gradients_field_name( 6)                   = 'b_coef_neg_se'
    C%smb_gradients_field_name( 7)                   = 'b_coef_pos'
    C%smb_gradients_field_name( 8)                   = 'b_coef_pos_se'
    C%smb_gradients_field_name( 9)                   = 'smb_pos_mean'
    C%smb_gradients_field_name(10)                   = 'R_coef_neg'
    C%smb_gradients_field_name(11)                   = 'R_coef_pos'
    C%smb_gradients_field_name(12)                   = 'n_coef_neg'
    C%smb_gradients_field_name(13)                   = 'n_coef_pos'
    C%smb_gradients_field_name(14)                   = 'smb_pos_min'
    C%smb_gradients_field_name(15)                   = 'smb_pos_max'
    C%smb_gradients_field_name(16)                   = 'Hs'
    C%smb_gradients_field_name(17)                   = 'smb'
    C%smb_gradients_field_name(18)                   = 'Hc'
    C%smb_gradients_field_name(19)                   = 'ELA'
    C%smb_gradients_field_name(20)                   = 'glacier_mask'
    C%smb_gradients_field_name(21)                   = 'a_coef_neg_refreezing'
    C%smb_gradients_field_name(22)                   = 'a_coef_neg_refreezing_se'
    C%smb_gradients_field_name(23)                   = 'a_coef_pos_refreezing'
    C%smb_gradients_field_name(24)                   = 'a_coef_pos_refreezing_se'
    C%smb_gradients_field_name(25)                   = 'b_coef_neg_refreezing'
    C%smb_gradients_field_name(26)                   = 'b_coef_neg_refreezing_se'
    C%smb_gradients_field_name(27)                   = 'b_coef_pos_refreezing'
    C%smb_gradients_field_name(28)                   = 'b_coef_pos_refreezing_se'
    C%smb_gradients_field_name(29)                   = 'refreezing_max'
    C%smb_gradients_field_name(30)                   = 'a_coef_runoff'
    C%smb_gradients_field_name(31)                   = 'a_coef_runoff_se'
    C%smb_gradients_field_name(32)                   = 'b_coef_runoff'
    C%smb_gradients_field_name(33)                   = 'b_coef_runoff_se'
    C%smb_gradients_field_name(34)                   = 'R_coef_runoff'
    C%smb_gradients_field_name(35)                   = 'n_coef_runoff'

    C%smb_gradients_field_unit( :)                   = 'unit: ?'
    C%smb_gradients_field_unit(-4)                   = 'degrees'
    C%smb_gradients_field_unit(-2)                   = 'degrees'
    C%smb_gradients_field_unit( 0)                   = 'year'
    C%smb_gradients_field_unit( 1)                   = 'mieq/y'
    C%smb_gradients_field_unit( 2)                   = 'mieq/y'
    C%smb_gradients_field_unit( 3)                   = 'mieq/y'
    C%smb_gradients_field_unit( 4)                   = 'mieq/y'
    C%smb_gradients_field_unit( 5)                   = 'mieq/(ym)'
    C%smb_gradients_field_unit( 6)                   = 'mieq/(ym)'
    C%smb_gradients_field_unit( 7)                   = 'mieq/(ym)'
    C%smb_gradients_field_unit( 8)                   = 'mieq/(ym)'
    C%smb_gradients_field_unit( 9)                   = 'mieq/y'
    C%smb_gradients_field_unit(10)                   = 'm'
    C%smb_gradients_field_unit(11)                   = 'm'
    C%smb_gradients_field_unit(12)                   = '-'
    C%smb_gradients_field_unit(13)                   = '-'
    C%smb_gradients_field_unit(14)                   = 'mieq/y'
    C%smb_gradients_field_unit(15)                   = 'mieq/y'
    C%smb_gradients_field_unit(16)                   = 'm'
    C%smb_gradients_field_unit(17)                   = 'mieq/y'
    C%smb_gradients_field_unit(18)                   = 'm'
    C%smb_gradients_field_unit(19)                   = 'm'
    C%smb_gradients_field_unit(20)                   = '-'
    C%smb_gradients_field_unit(21)                   = 'mieq/y'
    C%smb_gradients_field_unit(22)                   = 'mieq/y'
    C%smb_gradients_field_unit(23)                   = 'mieq/y'
    C%smb_gradients_field_unit(24)                   = 'mieq/y'
    C%smb_gradients_field_unit(25)                   = 'mieq/(ym)'
    C%smb_gradients_field_unit(26)                   = 'mieq/(ym)'
    C%smb_gradients_field_unit(27)                   = 'mieq/(ym)'
    C%smb_gradients_field_unit(28)                   = 'mieq/(ym)'
    C%smb_gradients_field_unit(29)                   = 'mieq/y'
    C%smb_gradients_field_unit(30)                   = 'mieq/y'
    C%smb_gradients_field_unit(31)                   = 'mieq/y'
    C%smb_gradients_field_unit(32)                   = 'mieq/(ym)'
    C%smb_gradients_field_unit(33)                   = 'mieq/(ym)'
    C%smb_gradients_field_unit(34)                   = 'm'
    C%smb_gradients_field_unit(35)                   = '-'

    C%smb_gradients_field_longname(:)                = 'longname: ?'
    C%smb_gradients_field_longname(-4)               = 'latitude (degrees)'
    C%smb_gradients_field_longname(-2)               = 'longitude (degrees)'
    C%smb_gradients_field_longname( 0)               = 'time (year)'
    C%smb_gradients_field_longname( 1)               = 'a_coef_neg (meter ice equivalent per year)'
    C%smb_gradients_field_longname( 2)               = 'standard error in a_coef_neg (meter ice equivalent per year)'
    C%smb_gradients_field_longname( 3)               = 'a_coef_pos (meter ice equivalent per year)'
    C%smb_gradients_field_longname( 4)               = 'standard error in a_coef_pos (meter ice equivalent per year)'
    C%smb_gradients_field_longname( 5)               = 'b_coef_neg (meter ice equivalent per year per meter)'
    C%smb_gradients_field_longname( 6)               = 'standard error in b_coef_neg (meter ice equivalent per year per meter)'
    C%smb_gradients_field_longname( 7)               = 'b_coef_pos (meter ice equivalent per year per meter)'
    C%smb_gradients_field_longname( 8)               = 'standard error in b_coef_pos (meter ice equivalent per year per meter)'
    C%smb_gradients_field_longname( 9)               = 'smb_pos_mean (meter ice equivalent per year)'
    C%smb_gradients_field_longname(10)               = 'R_coef_neg (m)'
    C%smb_gradients_field_longname(11)               = 'R_coef_pos (m)'
    C%smb_gradients_field_longname(12)               = 'n_coef_neg (-)'
    C%smb_gradients_field_longname(13)               = 'n_coef_pos (-)'
    C%smb_gradients_field_longname(14)               = 'smb_pos_min (meter ice equivalent per year)'
    C%smb_gradients_field_longname(15)               = 'smb_pos_max (meter ice equivalent per year)'
    C%smb_gradients_field_longname(16)               = 'Hs (m)'
    C%smb_gradients_field_longname(17)               = 'smb (meter ice equivalent per year)'
    C%smb_gradients_field_longname(18)               = 'Hc (m)'
    C%smb_gradients_field_longname(19)               = 'ELA (m)'
    C%smb_gradients_field_longname(20)               = 'glacier_mask (-)'
    C%smb_gradients_field_longname(21)               = 'a_coef_neg_refreezing (meter ice equivalent per year)'
    C%smb_gradients_field_longname(22)               = 'standard error in a_coef_neg_refreezing (meter ice equivalent per year)'
    C%smb_gradients_field_longname(23)               = 'a_coef_pos_refreezing (meter ice equivalent per year)'
    C%smb_gradients_field_longname(24)               = 'standard error in a_coef_pos_refreezing (meter ice equivalent per year)'
    C%smb_gradients_field_longname(25)               = 'b_coef_neg_refreezing (meter ice equivalent per year per meter)'
    C%smb_gradients_field_longname(26)               = 'standard error in b_coef_neg_refreezing (meter ice equivalent per year per meter)'
    C%smb_gradients_field_longname(27)               = 'b_coef_pos_refreezing (meter ice equivalent per year per meter)'
    C%smb_gradients_field_longname(28)               = 'standard error in b_coef_pos_refreezing (meter ice equivalent per year per meter)'
    C%smb_gradients_field_longname(29)               = 'refreezing_max (meter ice equivalent per year)'
    C%smb_gradients_field_longname(30)               = 'a_coef_runoff (meter ice equivalent per year)'
    C%smb_gradients_field_longname(31)               = 'standard error in a_coef_runoff (meter ice equivalent per year)'
    C%smb_gradients_field_longname(32)               = 'b_coef_runoff (meter ice equivalent per year per meter)'
    C%smb_gradients_field_longname(33)               = 'standard error in b_coef_runoff (meter ice equivalent per year per meter)'
    C%smb_gradients_field_longname(34)               = 'R_coef_runoff (m)'
    C%smb_gradients_field_longname(35)               = 'n_coef_runoff (-)'


    C%rfr_gradients_field_name(MND:0)                = 'rfr_gradients-field-dimension-no-name'
    C%rfr_gradients_field_name(  1:MNF)              = 'rfr_gradients-field-no-name'
    C%rfr_gradients_field_name(-7)                   = 'NVL'
    C%rfr_gradients_field_name(-6)                   = 'vertical-coordinate'
    C%rfr_gradients_field_name(-5)                   = 'NLAT'
    C%rfr_gradients_field_name(-4)                   = 'latitude'
    C%rfr_gradients_field_name(-3)                   = 'NLON'
    C%rfr_gradients_field_name(-2)                   = 'longitude'
    C%rfr_gradients_field_name(-1)                   = 'NTIME'
    C%rfr_gradients_field_name( 0)                   = 'time'
    C%rfr_gradients_field_name( 1)                   = 'a_coef_neg_refreezing'
    C%rfr_gradients_field_name( 2)                   = 'a_coef_pos_refreezing'
    C%rfr_gradients_field_name( 3)                   = 'b_coef_neg_refreezing'
    C%rfr_gradients_field_name( 4)                   = 'b_coef_pos_refreezing'
    C%rfr_gradients_field_name( 5)                   = 'refreezing_max'

    C%rfr_gradients_field_unit( :)                   = 'unit: ?'
    C%rfr_gradients_field_longname(:)                = 'longname: ?'


    C%runoff_gradients_field_name(MND:0)             = 'runoff_gradients-field-dimension-no-name'
    C%runoff_gradients_field_name(  1:MNF)           = 'runoff_gradients-field-no-name'
    C%runoff_gradients_field_name(-7)                = 'NVL'
    C%runoff_gradients_field_name(-6)                = 'vertical-coordinate'
    C%runoff_gradients_field_name(-5)                = 'NLAT'
    C%runoff_gradients_field_name(-4)                = 'latitude'
    C%runoff_gradients_field_name(-3)                = 'NLON'
    C%runoff_gradients_field_name(-2)                = 'longitude'
    C%runoff_gradients_field_name(-1)                = 'NTIME'
    C%runoff_gradients_field_name( 0)                = 'time'
    C%runoff_gradients_field_name( 1)                = 'a_coef_runoff'
    C%runoff_gradients_field_name( 2)                = 'b_coef_runoff'
    C%runoff_gradients_field_name( 3)                = 'accumulation_ec_earth'

    C%runoff_gradients_field_unit( :)                = 'unit: ?'
    C%runoff_gradients_field_longname(:)             = 'longname: ?'


    C%n_pos_min                                      = n_pos_min_config
    C%n_neg_min                                      = n_neg_min_config
    C%n_runoff_min                                   = n_runoff_min_config
    C%initial_search_radius                          = initial_search_radius_config
    C%search_radius_interval                         = search_radius_interval_config
    C%choice_use_location_list                       = choice_use_location_list_config
    C%choice_compute_refreezing_gradients            = choice_compute_refreezing_gradients_config
    C%choice_smb_output_mieq                         = choice_smb_output_mieq_config
    C%choice_distinction_ablation_accumulation       = choice_distinction_ablation_accumulation_config
    C%choice_compute_runoff_gradients                = choice_compute_runoff_gradients_config
    C%choice_compute_smb_timeseries                  = choice_compute_smb_timeseries_config
    C%smb_gradients_location_list_file               = smb_gradients_location_list_file_config


    C%gia_record                                     = gia_record_config
    C%gia_record_range                               = gia_record_range_config
    C%gia_field_name                                 = gia_field_name_config
    C%gia_field_unit                                 = gia_field_unit_config
    C%gia_field_longname                             = gia_field_longname_config


    C%sst_record                                     = sst_record_config
    C%sst_record_range                               = sst_record_range_config
    C%number_of_sst_fields                           = number_of_sst_fields_config
    C%sst_field_name                                 = sst_field_name_config
    C%sst_field_unit                                 = sst_field_unit_config
    C%sst_field_longname                             = sst_field_longname_config


    C%reference_surface_height_field_name(MND:0)     = 'reference_surface_height_field-dimension-no-name'
    C%reference_surface_height_field_name(  1:MNF)   = 'reference_surface_height_field-no-name'
    C%reference_surface_height_field_name(-7)        = 'NVL'
    C%reference_surface_height_field_name(-6)        = 'vertical-coordinate'
    C%reference_surface_height_field_name(-5)        = 'NY'
    C%reference_surface_height_field_name(-4)        = 'y'
    C%reference_surface_height_field_name(-3)        = 'NX'
    C%reference_surface_height_field_name(-2)        = 'x'
    C%reference_surface_height_field_name(-1)        = 'NTIME'
    C%reference_surface_height_field_name( 0)        = 'time'
    C%reference_surface_height_field_name( 1)        = 'Lon'
    C%reference_surface_height_field_name( 2)        = 'Lat'
    C%reference_surface_height_field_name( 3)        = 'Hs'

    C%reference_surface_height_field_unit( :)        = 'unit: ?'
    C%reference_surface_height_field_longname(:)     = 'longname: ?'


    ! OBLIMAP:
    C%oblimap_message_level                          = oblimap_message_level_config
    C%suppress_check_on_scan_parameters              = suppress_check_on_scan_parameters_config
    C%oblimap_allocate_factor                        = oblimap_allocate_factor_config
    C%choice_projection_method                       = choice_projection_method_config

    SELECT CASE(C%choice_projection_method)
    CASE('oblique_stereographic_projection','oblique_stereographic_projection_snyder','oblique_stereographic_projection_ellipsoid_snyder', &
    'oblique_lambert_equal-area_projection_snyder','oblique_lambert_equal-area_projection_ellipsoid_snyder','rotation_projection')
    CASE DEFAULT
     WRITE(UNIT=*, FMT='(/3A )') C%OBLIMAP_ERROR, ' In the config file: ', TRIM(C%config_filename)
     WRITE(UNIT=*, FMT='( 2A/)') '                Invalid value for:  choice_projection_method_config = ', TRIM(C%choice_projection_method)
     STOP
    END SELECT

    ! Assign a C%lambda_M value for North and South Pole which generate the correct IM coordinate system,
    ! see Reerink et al. (2010) equation (2.3) or equation (A.53):
   !IF(phi_M_config == -90.0_dp .OR. phi_M_config == 90.0_dp) lambda_M_config = 0.0_dp                       ! This gives the default polar stereographic projection.
    C%lambda_M                                       = C%degrees_to_radians * lambda_M_config                ! Coordinate (C%lamda_M, C%phi_M) is the middle of the GCM's longitude-latitude region
    C%phi_M                                          = C%degrees_to_radians * phi_M_config                   ! of interest that will be projected to the IM, convert the degrees to radians

   !IF(ABS(phi_M_config) == 90.0_dp) THEN
   ! SELECT CASE(C%choice_projection_method)
   ! ! A work around to avoid the polar equations: in this way the oblique ones are used instead of the
   ! ! polar ones by a tiny adjustment of C%phi_M. Mind that closer to 1 the results become worse again.
   ! CASE('oblique_lambert_equal-area_projection_ellipsoid_snyder','oblique_stereographic_projection_ellipsoid_snyder')
   !  C%phi_M = 0.999999_dp * C%phi_M
   ! END SELECT
   !END IF

    IF(ABS(phi_M_config) == 90.0_dp) THEN
     C%polar_projection = .TRUE.
    ELSE
     C%polar_projection = .FALSE.
    END IF

    ! The exact projection plane can be adjusted by specifying a certain angle alpha_stereographic
    ! This projection plane below and parallel to the tangent plane in (C%lamda_M, C%phi_M).
    C%alpha_stereographic                            = C%degrees_to_radians * alpha_stereographic_config

    ! The 2D rotation projection is defined by the angle below:
    C%theta_rotation_projection                      = C%degrees_to_radians * theta_rotation_projection_config
    C%shift_x_coordinate_rotation_projection         = shift_x_coordinate_rotation_projection_config
    C%shift_y_coordinate_rotation_projection         = shift_y_coordinate_rotation_projection_config

    C%shepard_exponent                               = shepard_exponent_config
    C%gcm_input_filename                             = gcm_input_filename_config
    C%enable_shift_im_grid                           = enable_shift_im_grid_config
    C%shift_x_coordinate_im_grid                     = shift_x_coordinate_im_grid_config
    C%shift_y_coordinate_im_grid                     = shift_y_coordinate_im_grid_config
    C%alternative_lambda_for_center_im_grid          = alternative_lambda_for_center_im_grid_config
    C%alternative_phi_for_center_im_grid             = alternative_phi_for_center_im_grid_config
    IF(choice_projection_method_config /= 'rotation_projection') THEN
     IF(C%alternative_lambda_for_center_im_grid      == 0.0_dp) C%alternative_lambda_for_center_im_grid = C%radians_to_degrees * C%lambda_M
     IF(C%alternative_phi_for_center_im_grid         == 0.0_dp) C%alternative_phi_for_center_im_grid    = C%radians_to_degrees * C%phi_M
    ELSE
     IF(C%enable_shift_im_grid) THEN
      WRITE(UNIT=*, FMT='(/2A, /2A/)') C%OBLIMAP_WARNING, '  In case "choice_projection_method_config = rotation_projection" the option "enable_shift_im_grid_config" has to be FALSE.', &
      ' OBLIMAP continues with  "enable_shift_im_grid_config = .FALSE." ignoring thus its setting in the config file: ', TRIM(C%config_filename)
      C%enable_shift_im_grid = .FALSE.
      C%shift_x_coordinate_im_grid                   = 0.0_dp
      C%shift_y_coordinate_im_grid                   = 0.0_dp
      C%alternative_lambda_for_center_im_grid        = 0.0_dp
      C%alternative_phi_for_center_im_grid           = 0.0_dp
     END IF
    END IF
    C%gcm_record_range                               = gcm_record_range_config
    C%im_record_range                                = im_record_range_config
    IF(C%gcm_record_range(2) < C%gcm_record_range(1)) THEN
     C%gcm_record_range(2)                           = C%gcm_record_range(1)
     WRITE(UNIT=*, FMT='(/2A, I3, A, I3/)') C%WARNING, ' The GCM record range is adjusted to:', C%gcm_record_range(1), '  --', C%gcm_record_range(2)
    END IF
    IF(C%im_record_range(2)  < C%im_record_range(1))  THEN
     C%im_record_range(2)                            = C%im_record_range(1)
     WRITE(UNIT=*, FMT='(/2A, I3, A, I3/)') C%WARNING, ' The IM record range is adjusted to:' , C%im_record_range(1),  '  --', C%im_record_range(2)
    END IF
    IF(C%forcing_record_range(2)  < C%forcing_record_range(1))  THEN
     C%forcing_record_range(2)                       = C%forcing_record_range(1)
     WRITE(UNIT=*, FMT='(/2A, I3, A, I3/)') C%WARNING, ' The forcing record range is adjusted to:' , C%forcing_record_range(1),  '  --', C%forcing_record_range(2)
    END IF
    ! The 3rd element of this array obtains the required record dimension of a variable for this record range:
    C%forcing_record_range(3)                        = 1 + C%forcing_record_range(2) - C%forcing_record_range(1)
    C%gia_record_range    (3)                        = 1 + C%gia_record_range    (2) - C%gia_record_range    (1)
    C%sst_record_range    (3)                        = 1 + C%sst_record_range    (2) - C%sst_record_range    (1)

    C%number_of_vertical_layers                      = number_of_vertical_layers_config                      ! Number of vertcal layers, i.e. number of grid points of the vertical coordinate
    IF(C%number_of_vertical_layers < 1) C%number_of_vertical_layers = 1
    C%number_of_mapped_fields                        = number_of_mapped_fields_config
    IF(C%number_of_mapped_fields < 1 .OR. C%number_of_mapped_fields > MNF) THEN
     WRITE(UNIT=*, FMT='(/A, I5, 2A)') '  The "number_of_mapped_fields" should be between 1 and ', MNF, ', adapt this in your: ', TRIM(C%config_filename)
     WRITE(UNIT=*, FMT='(A)')          '  Or you have to higher the Maximum Number of Fields (MNF) in the configuration_module, followed by:'
     WRITE(UNIT=*, FMT='(A)')          '   make clean'
     WRITE(UNIT=*, FMT='(A/)')         '   make all'
     C%number_of_mapped_fields = 1
    END IF

    C%ignore_reading_pre_mapped_fields               = ignore_reading_pre_mapped_fields_config

    C%field_which_determines_invalid_value_mask      = field_which_determines_invalid_value_mask_config
    IF(ANY(C%field_which_determines_invalid_value_mask(1:C%number_of_mapped_fields) > C%number_of_mapped_fields)) THEN
     WRITE(UNIT=*, FMT='(/2A, I5, /2A/)') C%OBLIMAP_ERROR, ' One or more values of the "field_which_determines_invalid_value_mask_config" exceed the number_of_mapped_fields_config = ', C%number_of_mapped_fields, ' Adjust this in your config file: ', TRIM(C%config_filename)
     STOP
    END IF
    WHERE(C%field_which_determines_invalid_value_mask <= 0)
     C%masked_fields = .FALSE.   ! Default situation
    ELSEWHERE
     C%masked_fields = .TRUE.
    END WHERE

    C%invalid_value_mask_criterion                   = invalid_value_mask_criterion_config
    IF(ANY(C%invalid_value_mask_criterion(1:C%number_of_mapped_fields) < 1) .OR. ANY(C%invalid_value_mask_criterion(1:C%number_of_mapped_fields) > 2)) THEN
     WRITE(UNIT=*, FMT='(/3A/)') C%OBLIMAP_ERROR, ' The "invalid_value_mask_criterion" should be between 1 and 2. Adjust this in your config file: ', TRIM(C%config_filename)
     STOP
    END IF

    C%invalid_input_value                            = invalid_input_value_config
    C%invalid_output_value                           = invalid_output_value_config
   !WHERE(invalid_output_value_config /= -9999._dp)
   ! C%invalid_output_value                          = invalid_output_value_config  ! If specified in config file, take that value
   !ELSE WHERE
   ! C%invalid_output_value                          = C%invalid_input_value        ! Otherwise take the same value as the C%invalid_input_value
   !END WHERE

    C%gcm_field_name                                 = gcm_field_name_config
    C%gcm_field_unit                                 = gcm_field_unit_config
    C%gcm_field_longname                             = gcm_field_longname_config
    C%im_field_name                                  = im_field_name_config
    C%im_field_unit                                  = im_field_unit_config
    C%im_field_longname                              = im_field_longname_config
    C%prefabricated_im_grid_field_name               = prefabricated_im_grid_field_name_config
    C%field_factor                                   = field_factor_config
    C%field_shift                                    = field_shift_config

    C%im_created_filename                            = im_created_filename_config
    C%scanning_mode                                  = scanning_mode_config
    C%data_set_is_cyclic_in_longitude                = data_set_is_cyclic_in_longitude_config
    C%level_of_automatic_oblimap_scanning            = level_of_automatic_oblimap_scanning_config
    C%scan_search_block_size                         = scan_search_block_size_config
    C%scan_search_block_size_step                    = scan_search_block_size_step_config
    C%choice_quadrant_method                         = choice_quadrant_method_config
    C%R_search_interpolation                         = R_search_interpolation_config
    C%sid_filename                                   = sid_filename_config
    C%backward_sid_filename                          = backward_sid_filename_config
    C%im_input_filename                              = im_input_filename_config
    C%use_prefabricated_im_grid_coordinates          = use_prefabricated_im_grid_coordinates_config
    C%prefabricated_im_grid_filename                 = prefabricated_im_grid_filename_config

    C%gcm_created_filename                           = gcm_created_filename_config
    C%nearest_point_assignment                       = nearest_point_assignment_config
    C%vincenty_method_for_ellipsoid                  = vincenty_method_for_ellipsoid_config
    C%reduce_dummy_dimensions                        = reduce_dummy_dimensions_config
    C%do_oblimap_post_processing                     = do_oblimap_post_processing_config

    C%filename_flow_line_profile                     = filename_flow_line_profile_config
    C%flow_line_profile_flux_criterion               = flow_line_profile_flux_criterion_config
    C%amount_of_flow_line_curves                     = amount_of_flow_line_curves_config
    C%starting_grid_number_in_x_direction            = starting_grid_number_in_x_direction_config
    C%starting_grid_number_in_y_direction            = starting_grid_number_in_y_direction_config
    C%maximum_number_of_flow_line_points             = maximum_number_of_flow_line_points_config
    C%number_of_preceding_flow_line_points           = number_of_preceding_flow_line_points_config
    C%coarse_grid_number_to_switch_criterion         = coarse_grid_number_to_switch_criterion_config
    C%high_resolution_of_flow_line_profiles          = high_resolution_of_flow_line_profiles_config
    C%follow_close_coarse_flow_line_points           = follow_close_coarse_flow_line_points_config
    C%preceding_longitude_latitude_coordinates       = preceding_longitude_latitude_coordinates_config
    C%N_profile                                      = N_profile_config

    C%online_coupled_oblimap                         = online_coupled_oblimap_config
    C%embedded_model_iterations                      = embedded_model_iterations_config

    ! With scan_search_block_size_config = -1 the much slower full scanning mode is available for testing and benchmarking:
    IF(C%scan_search_block_size == -1) THEN
     C%full_scanning_mode                            = .TRUE.
    ELSE
     C%full_scanning_mode                            = .FALSE.
    END IF

    ! Unit used for the temporal file containing the fast input file content:
    C%unit_scanning_file_content                     = 14111984
    C%filename_sid_content                           = 'content_sid_file.txt'

    ! A predefined large distance (more then the earth circumference) used to initialize distances when searching the nearest projected points:
    C%large_distance                                 = 1.0E8_dp

    ! Description of the numbers which are used for the WGS84 ellipsoid:
    ! The relation between the flattening f and the eccentricity is given in Snyder (1987) p. 13:
    !  e^2 = 2f - f^2  or  f = 1 - (1 - e^2)^(0.5)
    ! The relation between the flattening f and the equatorial axis a and the polar axis b is
    ! given in Snyder (1987) p. 12 in the table description:
    !  b = a(1 - f)  or  f = 1 - b/a
    ! Where a and b repectively might have alternative names: semi-major axis a and semi-minor
    ! axis b, below given in meters.
    ! Litteral numbers taken from:                           Ellipsoid reference  Semi-major axis a  Semi-minor axis b  Inverse flattening (1/f)
    !  http://en.wikipedia.org/wiki/Earth_ellipsoid        :      WGS 1984          6378137          6356752.314245179    298.257223563
    !  https://en.wikipedia.org/wiki/World_Geodetic_System :      WGS 1984          6378137          6356752.314245       298.257223563
    ! Note that:
    !  the eccentricity C%e below is calculted with python by e = (2*f - f**2)**0.5 = 0.08181919084262149 with f = 1 / 298.257223563
    !  the semi-minor axis b      is calculted with python by b = a*(1 - f)         = 6356752.314245179   with f = 1 / 298.257223563 and a = 6378137

    C%a                                              = ellipsoid_semi_major_axis_config       ! The semi-major axis or the equatorial radius of the ellipsoid (in case of the Earth), a in Snyder (1987) at p. 160; default WGS84 value for a = 6.378137E6
    C%e                                              = ellipsoid_eccentricity_config          ! The eccentricity of the ellipsoid, e in Snyder (1987) at p. 160, WGS84, see Snyder (1987) p. 13, default WGS84 value for e = 0.08181919084262149
    C%ellipsoid_flattening                           = 1._dp - (1._dp - C%e**2)**0.5_dp       ! Flattening of the ellipsoid, f = 1 - (1 - e**2)**0.5 in Snyder (1987) at p. 13, WGS84 value for f = 0.0033528106647474805
    C%ellipsoid_semi_minor_axis                      = C%a * (1._dp - C%ellipsoid_flattening) ! The semi-minor axis or the polar radius of the ellipsoid (in case of the Earth) b in Snyder (1987) at p. 160, b = a(1-f) given in Snyder (1987) p. 12 in the table description; WGS84 value for b = 6356752.314245179 meter

    ! See equations (14-15) and (21-27) on page 160 in Snyder (1987), am corresponds with a*m_1 and akm corresponds with 2a*k0*m_1 in Snyder (1987):
    C%am                                             = C%a * (COS(C%phi_M) / SQRT(1.0_dp - (C%e * SIN(C%phi_M))**2))
    C%akm                                            = (1.0_dp + COS(C%alpha_stereographic)) * C%am
    ! See equations (3-1a) on page 160 in Snyder (1987),  chi_M corresponds with chi_1 in Snyder (1987):
    C%chi_M                                          = 2.0_dp * ATAN(SQRT(((1.0_dp + SIN(C%phi_M)) / (1.0_dp - SIN(C%phi_M))) * &
                                                         ((1.0_dp - C%e * SIN(C%phi_M)) / (1.0_dp + C%e * SIN(C%phi_M)))**(C%e))) - 0.5_dp * C%pi

    ! See equation (3-12) on page 187 in Snyder (1987):
    C%q_M                                            = (1.0_dp - C%e**2) * ((SIN(C%phi_M) / (1.0_dp - (C%e * SIN(C%phi_M))**2)) - (1.0_dp / (2.0_dp * C%e)) * LOG((1.0_dp - C%e * SIN(C%phi_M)) / (1.0_dp + C%e * SIN(C%phi_M))))
    ! See equation (3-12) on page 187 in Snyder (1987):
    C%q_polar                                        = (1.0_dp - C%e**2) * ((1.0_dp / (1.0_dp - C%e**2)) - (1.0_dp / (2.0_dp * C%e)) * LOG((1.0_dp - C%e) / (1.0_dp + C%e)))
    ! See equation (3-11) on page 187 in Snyder (1987):
    C%beta_M                                         = ASIN(C%q_M / C%q_polar)
    ! See equation (3-13) on page 187 in Snyder (1987):
    C%R_q_polar                                      = C%a * SQRT(0.5_dp * C%q_polar)
    ! See equation (24-20) on page 187 in Snyder (1987):
    C%D                                              = C%am / (C%R_q_polar * COS(C%beta_M))

    C%extrapolate_field_on_mask_edge                 = extrapolate_field_on_mask_edge_config
    C%extrapolate_ocean_temperature                  = extrapolate_ocean_temperature_config

    C%latitude_optc                                  = latitude_optc_config                      ! latitude  of an oblimap projection test coordinate (degrees)
    C%longitude_optc                                 = longitude_optc_config                     ! longitude of an oblimap projection test coordinate (degrees)

    C%unit_conversion_x_ax                           = unit_conversion_x_ax_config
    C%unit_conversion_y_ax                           = unit_conversion_y_ax_config


    C%smooth_radius                                  = smooth_radius_config
    C%replace_invalid_values_smooth_radius           = replace_invalid_values_smooth_radius_config
    C%replace_invalid_values_by_smooting             = replace_invalid_values_by_smooting_config
    C%adjust_single_gap_points                       = adjust_single_gap_points_config
    C%single_gap_threshold                           = single_gap_threshold_config

    C%rebin_radius                                   = rebin_radius_config
    C%x_rebin_factor                                 = x_rebin_factor_config
    C%y_rebin_factor                                 = y_rebin_factor_config
    C%rebin_input_filename                           = rebin_input_filename_config
    C%rebin_output_filename                          = rebin_output_filename_config

    C%NX_modified                                    =  NX_modified_config
    C%NY_modified                                    =  NY_modified_config
    C%start_index_left_for_modified                  =  start_index_left_for_modified_config
    C%start_index_bottom_for_modified                =  start_index_bottom_for_modified_config
    C%dx_modified                                    =  dx_modified_config
    C%dy_modified                                    =  dy_modified_config
    C%modify_input_filename                          =  modify_input_filename_config
    C%modify_output_filename                         =  modify_output_filename_config

    ! Physical parameters:
    C%seconds_per_year                               = seconds_per_year_config                               ! Seconds per year [s]
    C%earth_radius                                   = earth_radius_config                                   ! Earth Radius [m]
    C%seawater_temperature                           = seawater_temperature_config                           ! Seawater temperature [K]
    C%triple_point_of_water                          = triple_point_of_water_config                          ! Triple point of water [K]
    C%gravity_constant                               = gravity_constant_config                               ! Acceleration of gravity [m s^-2]
    C%ice_density                                    = ice_density_config                                    ! Ice density [kg m^-3]
    C%seawater_density                               = seawater_density_config                               ! Seawater density [kg m^-3]
    C%fresh_water_density                            = fresh_water_density_config                            ! Fresh water density [kg m^-3]
    C%rock_density                                   = rock_density_config                                   ! Rock density [kg m^-3]
    C%mantle_density                                 = mantle_density_config                                 ! Mantle density [kg m^-3]
    C%lithosphere_flexural_rigidity                  = lithosphere_flexural_rigidity_config                  ! Lithospheric flexural rigidity [kg m^2 s^-2]
    C%relaxation_time_bedrock                        = relaxation_time_bedrock_config                        ! Relaxation time for bedrock adjustment [y]
    C%rock_heat_capacity                             = rock_heat_capacity_config                             ! Heat capacity of rock [J kg^-1 K^-1]
    C%rock_conductivity                              = rock_conductivity_config                              ! Conductivity of rock [J m^-1 K^-1 y^-1]
    C%geothermal_heat_flux                           = C%seconds_per_year * geothermal_heat_flux_config      ! Geothermal Heat flux [J m^-2 y^-1]
    C%Claus_Clap_gradient                            = Claus_Clap_gradient_config                            ! Clausius Clapeyron gradient [K m^-1]
    C%A_sliding                                      = A_sliding_config                                      ! Sliding coefficient inversely proportional to the bed roughness [m^8 N^-3 y^-1]
    C%n_flow                                         = n_flow_config                                         ! Flow law exponent [-]
    C%m_enhance_sheet_sia                            = m_enhance_sheet_sia_config                            ! Flow enhancement parameter for the sia treated sheet [-]
    C%m_enhance_sheet_ssa                            = m_enhance_sheet_ssa_config                            ! Flow enhancement parameter for the ssa treated sheet [-]
    C%m_enhance_shelf                                = m_enhance_shelf_config                                ! Flow enhancement parameter for the shelf [-]
    C%A_turnover_temperature                         = A_turnover_temperature_config                         ! The turnover temperature in the Arrhenius relationship [K]
    C%A_low_temp                                     = C%seconds_per_year * A_low_temp_config                ! The constant a in the Arrhenius relationship [Pa^-3 y^-1]
    C%A_high_temp                                    = C%seconds_per_year * A_high_temp_config               ! The constant a in the Arrhenius relationship [Pa^-3 y^-1]
    C%Q_low_temp                                     = Q_low_temp_config                                     ! Activation energy for creep in the Arrhenius relationship [J mol^-1]
    C%Q_high_temp                                    = Q_high_temp_config                                    ! Activation energy for creep in the Arrhenius relationship [J mol^-1]
    C%R_gas                                          = R_gas_config                                          ! Gas constant [J mol^-1 K^-1]
    C%wet_adiabatic                                  = wet_adiabatic_config                                  ! The air is supposed to be dry/wet adiabatic above/below this altitude [m]
    C%dry_adiabatic                                  = dry_adiabatic_config                                  ! Temperture decrease per meter altitude [K m^-1]
    C%adiabatic_turnover_height                      = adiabatic_turnover_height_config                      ! Temperture decrease per meter altitude [K m^-1]
    C%kappa_0_ice_conductivity                       = C%seconds_per_year * kappa_0_ice_conductivity_config  ! The linear constant in the thermal conductivity of ice [J m^-1 K^-1 y^-1]
    C%kappa_e_ice_conductivity                       = kappa_e_ice_conductivity_config                       ! The exponent constant in the thermal conductivity of ice [K^-1]
    C%c_0_specific_heat                              = c_0_specific_heat_config                              ! The constant in the specific heat capacity of ice [J kg^-1 K^-1]
    C%c_Delta_specific_heat                          = c_Delta_specific_heat_config                          ! The linear difference constant in the specific heat capacity of ice [J kg^-1 K^-2]
    C%latent_heat                                    = latent_heat_config                                    ! The latent heat of ice [J kg^-1]
    C%Stefan_Bolzmann_constant                       = Stefan_Bolzmann_constant_config                       ! The Stefan Bolzmann constant  [W m-2 K-4]
    C%solar_constant                                 = solar_constant_config                                 ! Solar constant [W m-2]: amount of solar radiation at the location of the earth
    C%earth_angular_velocity                         = earth_angular_velocity_config                         ! Earth rotation velocity [radians / hour]


    ! Setting some parameter values for the Robin solution:
    C%thermal_conductivity_robin                     = C%kappa_0_ice_conductivity * EXP(-C%kappa_e_ice_conductivity * C%triple_point_of_water) ! thermal conductivity            [J m^-1 K^-1 y^-1]
    C%thermal_diffusivity_robin                      = C%thermal_conductivity_robin / (C%ice_density * C%c_0_specific_heat)                    ! thermal diffusivity             [m^2 y^-1]
    C%bottom_temperature_gradient_robin              = - C%geothermal_heat_flux / C%thermal_conductivity_robin                                 ! temperature gradient at bedrock [K m^-1] Note that the time-step dependency cancels
    ! With this delta temperature, the pressure melting point is lowered, so melting starts at lower temperature already:
    C%delta_Ti_pmp_bottom                            = 0.0_dp                                                                                  ! temperature difference [K]


    ! Initialization of the discretization coefficients (note that this routine
    ! uses C%NZ, C%dx, C%dy, C%zeta, C%dzr, C%dt_thermo):
    CALL initialize_discretization()
  END SUBROUTINE initialize_constants



  SUBROUTINE initialize_config_variables_for_one_config_file(config_file_number, config_filename)
    IMPLICIT NONE

    ! Input variables:
    INTEGER           , INTENT(IN) :: config_file_number
    CHARACTER(LEN=256), INTENT(IN) :: config_filename

    ! Pre initialization of *_field_*_config arrays like e.g.: gcm_field_name_config:
    CALL default_pre_initialization_of_constants()

    ! Read the configuration file:
    CALL read_config_file(config_file_number, config_filename)

    ! Initialization of the struckt  C% :
    CALL initialize_constants(config_filename)
  END SUBROUTINE initialize_config_variables_for_one_config_file



  SUBROUTINE initialize_config_variables
    IMPLICIT NONE

    ! Local variables:
    CHARACTER(LEN=256) :: config_filename
    INTEGER            :: total_number_of_config_files

    total_number_of_config_files = COMMAND_ARGUMENT_COUNT()

    SELECT CASE(total_number_of_config_files)
    CASE(0)
     ! In this case no configuration file is read, instead the default defined values in the configuration module are used.
    CASE DEFAULT
     ! Get the name of the configuration file:
     CALL getarg(1, config_filename)

     ! Initialize the C% struct for each config file:
     CALL initialize_config_variables_for_one_config_file(1, config_filename)
    END SELECT
  END SUBROUTINE initialize_config_variables



  SUBROUTINE initialize_config_variables_of_multiple_config_files(total_number_of_config_files, C_struct_array)
    ! This routine is able to read in zero, one or more configuration files and to store for each config file
    ! the entire config variable list in the C% struct. A array of this C% structs is made to store all config
    ! variable lists simultaneously.
    IMPLICIT NONE

    ! Input variables:
    INTEGER                                                      , INTENT(IN)  :: total_number_of_config_files

    ! Output variables:
    TYPE(constants_type), DIMENSION(total_number_of_config_files), INTENT(OUT) :: C_struct_array

    ! Local variables:
    INTEGER                                                                    :: config_file_number
    CHARACTER(LEN=256)                                                         :: config_filename

    SELECT CASE(total_number_of_config_files)
    CASE(0)
     ! In this case no configuration file is read, instead the default defined values in the configuration module are used.
    CASE DEFAULT
     DO config_file_number = 1, total_number_of_config_files
      ! Get the name of the configuration file:
      CALL getarg(config_file_number, config_filename)

      ! If the C% struct will be initialized more than once, its allocatable variables have to be deallocated in advance:
      IF(config_file_number > 1) CALL finalize_constants()

      ! Initialize the C% struct for each config file:
      CALL initialize_config_variables_for_one_config_file(config_file_number, config_filename)

      C_struct_array(config_file_number) = C
     END DO
    END SELECT
  END SUBROUTINE initialize_config_variables_of_multiple_config_files



  SUBROUTINE oblimap_licence(program_name)
    IMPLICIT NONE

    ! Input variables:
    CHARACTER(LEN=*), INTENT(IN) :: program_name

    WRITE(UNIT=*, FMT='(/A/, A/, A/)') ' OBLIMAP 2.0', ' Copyright (C) 2016 Thomas Reerink', ' Free under GNU GPL version 3'
    WRITE(UNIT=*, FMT='( A/, 4A/)') ' The following run is executed by OBLIMAP:', '  ', './src/'//TRIM(program_name), ' ', TRIM(C%config_filename)
  END SUBROUTINE oblimap_licence



  SUBROUTINE rename_the_fort_files()
    IMPLICIT NONE

    ! Local variables:
    LOGICAL            :: file_exists
    CHARACTER(LEN=256) :: fort_file_name

    ! Renaming some standard fort.* files:
    WRITE(fort_file_name, FMT='(A, I3)') 'fort.', C%stdlog
    INQUIRE(FILE=fort_file_name, EXIST=file_exists)
    IF(file_exists) CALL SYSTEM('mv '//TRIM(fort_file_name)//' log-file.txt')
    WRITE(fort_file_name, FMT='(A, I3)') 'fort.', C%stderr
    INQUIRE(FILE=fort_file_name, EXIST=file_exists)
    IF(file_exists) CALL SYSTEM('mv '//TRIM(fort_file_name)//' error-file.txt')
  END SUBROUTINE rename_the_fort_files



  SUBROUTINE finalize_constants()
    IMPLICIT NONE

    DEALLOCATE(C%zeta)

    DEALLOCATE(C%a_k)
    DEALLOCATE(C%b_k)
    DEALLOCATE(C%c_k)
    DEALLOCATE(C%d_k)
    DEALLOCATE(C%a_zeta)
    DEALLOCATE(C%b_zeta)
    DEALLOCATE(C%c_zeta)
    DEALLOCATE(C%a_zetazeta)
    DEALLOCATE(C%b_zetazeta)
    DEALLOCATE(C%c_zetazeta)

    DEALLOCATE(C%z_zeta_minus)
    DEALLOCATE(C%a_zeta_minus)
    DEALLOCATE(C%b_zeta_minus)
    DEALLOCATE(C%b_zeta_plus)
    DEALLOCATE(C%c_zeta_plus)
    DEALLOCATE(C%d_zeta_plus)
  END SUBROUTINE finalize_constants



  SUBROUTINE initialize_discretization()
    ! Calculation of the discretization coefficients (on an Arakawa A-grid) which are used in the
    ! thermodynamics_module and in the velocity_full_stokes_module. See table 4.
    IMPLICIT NONE

    ! Local variables:
    INTEGER :: k

    ALLOCATE(C%a_k(2:C%NZ  ))
    ALLOCATE(C%b_k(1:C%NZ-1))
    ALLOCATE(C%c_k(3:C%NZ  ))
    ALLOCATE(C%d_k(1:C%NZ-2))
    ALLOCATE(C%a_zeta(2:C%NZ-1))
    ALLOCATE(C%b_zeta(2:C%NZ-1))
    ALLOCATE(C%c_zeta(2:C%NZ-1))
    ALLOCATE(C%a_zetazeta(2:C%NZ-1))
    ALLOCATE(C%b_zetazeta(2:C%NZ-1))
    ALLOCATE(C%c_zetazeta(2:C%NZ-1))

    ALLOCATE(C%z_zeta_minus(3:C%NZ))
    ALLOCATE(C%a_zeta_minus(3:C%NZ))
    ALLOCATE(C%b_zeta_minus(3:C%NZ))
    ALLOCATE(C%b_zeta_plus(1:C%NZ-2))
    ALLOCATE(C%c_zeta_plus(1:C%NZ-2))
    ALLOCATE(C%d_zeta_plus(1:C%NZ-2))

    C%a_x  = -1.0_dp / (2.0_dp * C%dx)
    C%c_x  =  1.0_dp / (2.0_dp * C%dx)
    C%a_y  = -1.0_dp / (2.0_dp * C%dy)
    C%c_y  =  1.0_dp / (2.0_dp * C%dy)
    C%a_xx =  1.0_dp / C%dx**2
    C%b_xx = -2.0_dp / C%dx**2
    C%c_xx =  1.0_dp / C%dx**2
    C%a_yy =  1.0_dp / C%dy**2
    C%b_yy = -2.0_dp / C%dy**2
    C%c_yy =  1.0_dp / C%dy**2

    DO k = 2, C%NZ
     C%a_k(k) = C%zeta(k)   - C%zeta(k-1)
    END DO
    DO k = 1, C%NZ-1
     C%b_k(k) = C%zeta(k+1) - C%zeta(k)
    END DO
    DO k = 3, C%NZ
     C%c_k(k) = C%zeta(k)   - C%zeta(k-2)
    END DO
    DO k = 1, C%NZ-2
     C%d_k(k) = C%zeta(k+2) - C%zeta(k)
    END DO

    DO k = 2, C%NZ-1
     C%a_zeta(k)     =           - C%b_k(k)  / (C%a_k(k) * (C%a_k(k) + C%b_k(k)))
     C%b_zeta(k)     = (C%b_k(k) - C%a_k(k)) / (C%a_k(k) *  C%b_k(k)            )
     C%c_zeta(k)     =             C%a_k(k)  / (C%b_k(k) * (C%a_k(k) + C%b_k(k)))
     C%a_zetazeta(k) =             2.0_dp    / (C%a_k(k) * (C%a_k(k) + C%b_k(k)))
     C%b_zetazeta(k) =           - 2.0_dp    / (C%a_k(k) *  C%b_k(k)            )
     C%c_zetazeta(k) =             2.0_dp    / (C%b_k(k) * (C%a_k(k) + C%b_k(k)))
    END DO

    ! Not all of these are in use:
    DO k = 1, C%NZ-2
      C%b_zeta_plus(k) = -(C%b_k(k) + C%d_k(k)) / (C%b_k(k) *  C%d_k(k)            )
      C%c_zeta_plus(k) =              C%d_k(k)  / (C%b_k(k) * (C%d_k(k) - C%b_k(k)))
      C%d_zeta_plus(k) =              C%b_k(k)  / (C%d_k(k) * (C%b_k(k) - C%d_k(k)))
    END DO

    ! Not all of these are in use:
    DO k = 3, C%NZ
      C%z_zeta_minus(k) =             C%a_k(k)  / (C%c_k(k) * (C%c_k(k) - C%a_k(k)))
      C%a_zeta_minus(k) =             C%c_k(k)  / (C%a_k(k) * (C%a_k(k) - C%c_k(k)))
      C%b_zeta_minus(k) = (C%a_k(k) + C%c_k(k)) / (C%a_k(k) *  C%c_k(k)            )
    END DO

    C%b_x_plus  = -3.0_dp / (2.0_dp * C%dx)
    C%c_x_plus  =  2.0_dp / (         C%dx)
    C%d_x_plus  = -1.0_dp / (2.0_dp * C%dx)

    C%b_y_plus  = -3.0_dp / (2.0_dp * C%dy)
    C%c_y_plus  =  2.0_dp / (         C%dy)
    C%d_y_plus  = -1.0_dp / (2.0_dp * C%dy)

    C%z_x_minus =  1.0_dp / (2.0_dp * C%dx)
    C%a_x_minus = -2.0_dp / (         C%dx)
    C%b_x_minus =  3.0_dp / (2.0_dp * C%dx)

    C%z_y_minus =  1.0_dp / (2.0_dp * C%dy)
    C%a_y_minus = -2.0_dp / (         C%dy)
    C%b_y_minus =  3.0_dp / (2.0_dp * C%dy)

    ! See table 4, central discretization coefficients in bedrock:
    C%a_zrzr =  1.0_dp / (C%dzr**2)                    ! a z-rock z-rock
    C%b_zrzr = -2.0_dp / (C%dzr**2)                    ! a z-rock z-rock
    C%c_zrzr =  1.0_dp / (C%dzr**2)                    ! a z-rock z-rock

    ! See table 4, one sided (+ direction) discretization coefficients in bedrock:
    C%b_zr_plus  = -3.0_dp / (2.0_dp * C%dzr)          ! b z-rock plus
    C%c_zr_plus  =  2.0_dp /           C%dzr           ! c z-rock plus
    C%d_zr_plus  = -1.0_dp / (2.0_dp * C%dzr)          ! d z-rock plus

    ! See table 4, one sided (- direction) discretization coefficients in bedrock:
    C%z_zr_minus  =  1.0_dp / (2.0_dp * C%dzr)         ! z z-rock minus
    C%a_zr_minus  = -2.0_dp /           C%dzr          ! a z-rock minus
    C%b_zr_minus  =  3.0_dp / (2.0_dp * C%dzr)         ! b z-rock minus

    ! Initilization of the implicit time discretization coefficient (see equation E.38):
    IF(C%dt_thermo == 0.0_dp .OR. C%dynamic_time_step_addaption) THEN
     G%b_t = 1.0_dp / C%dt
    ELSE
     G%b_t = 1.0_dp / C%dt_thermo
    END IF
  END SUBROUTINE initialize_discretization



  SUBROUTINE checking_specified_im_field_name(number_of_specified_field, checked_field_name)
    IMPLICIT NONE

    ! Input variables:
    INTEGER         , INTENT(IN) :: number_of_specified_field
    CHARACTER(LEN=*), INTENT(IN) :: checked_field_name

    ! A fixed order of the im_fields is required, this order in the config file is checked here:
    IF(C%im_field_name(number_of_specified_field) /= checked_field_name) THEN
     WRITE(UNIT=*, FMT='(/A, I2, 6A/)') ' STOP: The im_field_name_config(', number_of_specified_field, ') = ', TRIM(C%im_field_name(number_of_specified_field)), ', but should be: ', TRIM(checked_field_name), ' in the file: ', TRIM(C%config_filename)
     STOP
    END IF
  END SUBROUTINE checking_specified_im_field_name



  SUBROUTINE checking_specified_gcm_field_name(number_of_specified_field, checked_field_name)
    IMPLICIT NONE

    ! Input variables:
    INTEGER         , INTENT(IN) :: number_of_specified_field
    CHARACTER(LEN=*), INTENT(IN) :: checked_field_name

    ! A fixed order of the gcm_fields is required, this order in the config file is checked here:
    IF(C%gcm_field_name(number_of_specified_field) /= checked_field_name) THEN
     WRITE(UNIT=*, FMT='(/A, I2, 6A/)') ' STOP: The gcm_field_name_config(', number_of_specified_field, ') = ', TRIM(C%gcm_field_name(number_of_specified_field)), ', but should be: ', TRIM(checked_field_name), ' in the file: ', TRIM(C%config_filename)
     STOP
    END IF
  END SUBROUTINE checking_specified_gcm_field_name



  SUBROUTINE checking_specified_forcing_field_name(number_of_specified_field, checked_field_name)
    IMPLICIT NONE

    ! Input variables:
    INTEGER         , INTENT(IN) :: number_of_specified_field
    CHARACTER(LEN=*), INTENT(IN) :: checked_field_name

    ! A fixed order of the forcing_fields is required, this order in the config file is checked here:
    IF(C%forcing_field_name(number_of_specified_field) /= checked_field_name) THEN
     WRITE(UNIT=*, FMT='(/A, I2, 6A/)') ' STOP: The forcing_field_name_config(', number_of_specified_field, ') = ', TRIM(C%forcing_field_name(number_of_specified_field)), ', but should be: ', TRIM(checked_field_name), ' in the file: ', TRIM(C%config_filename)
     STOP
    END IF
  END SUBROUTINE checking_specified_forcing_field_name




  SUBROUTINE checking_specified_gia_field_name(number_of_specified_field, checked_field_name)
    IMPLICIT NONE

    ! Input variables:
    INTEGER         , INTENT(IN) :: number_of_specified_field
    CHARACTER(LEN=*), INTENT(IN) :: checked_field_name

    ! A fixed order of the gia_fields is required, this order in the config file is checked here:
    IF(C%gia_field_name(number_of_specified_field) /= checked_field_name) THEN
     WRITE(UNIT=*, FMT='(/A, I2, 6A/)') ' STOP: The gia_field_name_config(', number_of_specified_field, ') = ', TRIM(C%gia_field_name(number_of_specified_field)), ', but should be: ', TRIM(checked_field_name), ' in the file: ', TRIM(C%config_filename)
     STOP
    END IF
  END SUBROUTINE checking_specified_gia_field_name



  PURE FUNCTION rounding(x, n) RESULT (x_rounded)
    ! This routine simply rounds a real(dp) value x at the n-th decimal.
    IMPLICIT NONE

    ! Input variables:
    REAL(dp), INTENT(IN) :: x          ! x is the value which has to be rounded
    INTEGER , INTENT(IN) :: n          ! x will be rounded at the n-th decimal

    ! Result variables:
    REAL(dp)             :: x_rounded

    x_rounded = NINT(x * 10.0_dp ** n, dp) / 10.0_dp ** n
  END FUNCTION rounding



  LOGICAL FUNCTION detect_NaN(number)
   ! This function returns a .TRUE. in case the number is a NaN
   IMPLICIT NONE

   ! Input variables:
   REAL(dp) :: number

   IF(number /= number) THEN
    detect_NaN = .TRUE.
   ELSE
    detect_NaN = .FALSE.
   END IF

   RETURN
  END FUNCTION detect_NaN



  SUBROUTINE detect_NaN_in_2D_array(array_2D, variable_name)
    ! Detect the NaN's in a two dimensional array, write a message and stop the program.
    IMPLICIT NONE

    ! Input variables:
    REAL(dp), DIMENSION(C%NY,C%NX), INTENT(IN) :: array_2D
    CHARACTER(LEN=*),               INTENT(IN) :: variable_name

    ! Local variables:
    INTEGER                                    :: i, j
    LOGICAL                                    :: stop_program = .FALSE.

    DO i = 1, C%NX
    DO j = 1, C%NY
      IF(detect_NaN(array_2D(j,i))) THEN
       WRITE(UNIT=*, FMT='(4A, I3, A, I3, A)') TRIM(C%WARNING), ' NaN detected for: ', TRIM(variable_name), '(j=', j, ',i=', i, ')'
       stop_program = .TRUE.
      END IF
    END DO
    END DO
    IF(stop_program) STOP ' At least one NaN has been detected, program has been stopped'
  END SUBROUTINE detect_NaN_in_2D_array



  SUBROUTINE detect_NaN_in_3D_array(array_3D, variable_name, NZ)
    ! Detect the NaN's in a two dimensional array, write a message and stop the program.
    IMPLICIT NONE

    ! Input variables:
    REAL(dp), DIMENSION(NZ, C%NY,C%NX), INTENT(IN) :: array_3D
    CHARACTER(LEN=*),                   INTENT(IN) :: variable_name
    INTEGER,                            INTENT(IN) :: NZ

    ! Local variables:
    INTEGER                                        :: i, j, k
    LOGICAL                                        :: stop_program = .FALSE.

    DO i = 1, C%NX
    DO j = 1, C%NY
    DO k = 1,   NZ
      IF(detect_NaN(array_3D(k,j,i))) THEN
       WRITE(UNIT=*, FMT='(4A, I3, A, I3, A, I3, A)') TRIM(C%WARNING), ' NaN detected for: ', TRIM(variable_name), '(k=', k, 'j=', j, ',i=', i, ')'
       stop_program = .TRUE.
      END IF
    END DO
    END DO
    END DO
    IF(stop_program) STOP ' At least one NaN has been detected, program has been stopped'
  END SUBROUTINE detect_NaN_in_3D_array

END MODULE configuration_module
