MODULE tridiagonal_solve_ant_module

CONTAINS
    FUNCTION tridiagonal_solve(ldiag, diag, udiag, rhs, string_error_message) RESULT(x)
      ! Lapack tridiagnal solver (in double precision):
      ! Matrix system solver for tridiagonal matrices. 
      ! Used e.g. in solving the ADI scheme. 
      ! ldiag = lower diagonal elements (j,j-1) of the matrix
      ! diag  = diagonal elements (j,j) of the matrix
      ! udiag = upper diagonal elements (j,j+1) of the matrix
      ! rhs   = right hand side of the matrix equation in the ADI scheme
      USE configuration_main_module, ONLY: dp
      IMPLICIT NONE

      ! Input variables:
      REAL(dp), DIMENSION(:),            INTENT(IN) :: diag
      REAL(dp), DIMENSION(SIZE(diag)-1), INTENT(IN) :: udiag, ldiag
      REAL(dp), DIMENSION(SIZE(diag)),   INTENT(IN) :: rhs
      CHARACTER(LEN=*),                  INTENT(IN) :: string_error_message

      ! Result variable:
      REAL(dp), DIMENSION(SIZE(diag))               :: x
      
      ! Local variables:     
      INTEGER                                       :: info
      REAL(dp), DIMENSION(SIZE(diag))               :: diag_copy
      REAL(dp), DIMENSION(SIZE(udiag))              :: udiag_copy, ldiag_copy

      ! External subroutines:      
      EXTERNAL DGTSV ! Lapack routine that solves tridiagonal systems (in double precision).

      ! The LAPACK solver will overwrite the rhs with the solution x. Therefore we 
      ! first copy the rhs in the solution vector x:
      x = rhs

      ! The LAPACK solver will change the elements in the matrix, therefore we copy them:
      diag_copy  =  diag
      udiag_copy = udiag
      ldiag_copy = ldiag

      CALL DGTSV(SIZE(diag), 1, ldiag_copy, diag_copy, udiag_copy, x, SIZE(diag), info)
      ! Check if solver was successfull:
      IF(info /= 0) THEN
       WRITE(*, FMT='(3a, i5)') ' In the module ', string_error_message, ' in the function tridiagonal_solve_ant: info=', info
       !WRITE(UNIT=*, FMT='(4E30.12)') ((ldiag_copy(i), diag_copy(i), udiag_copy(i), x(i)), i=1, NZ) ! test print
       STOP ' DGTSV problem with tridiagonal system, --STOPPED'
      END IF
    END FUNCTION tridiagonal_solve
END MODULE tridiagonal_solve_ant_module
