MODULE surface_height_ant_module
  USE configuration_main_module , ONLY: dp, C
  IMPLICIT NONE

CONTAINS
  SUBROUTINE surface_height(sealevel, Hi, Hb, Hs)
    ! Compute surface height Hs from sealevel, Hi and Hb.
    USE parameters_main_module, ONLY: ice_density, seawater_density 
    IMPLICIT NONE

    ! Input variables:
    REAL(dp), DIMENSION(C%NX_ant,C%NY_ant), INTENT(IN)  :: sealevel  ! Relative to pd_sealevel [m]
    REAL(dp), DIMENSION(C%NX_ant,C%NY_ant), INTENT(IN)  :: Hb        ! Relative to pd_sealevel [m]
    REAL(dp), DIMENSION(C%NX_ant,C%NY_ant), INTENT(IN)  :: Hi        ! [m]

    ! Output variables:
    REAL(dp), DIMENSION(C%NX_ant,C%NY_ant), INTENT(OUT) :: Hs        ! Relative to pd_sealevel [m]

    Hs = Hi + Max(sealevel - ice_density / seawater_density * Hi, Hb)
    
  END SUBROUTINE surface_height
 

  SUBROUTINE adapt_Hi_and_Hs_for_no_shelf(mask, sealevel, Hi, Hs, dHi_dt, Us, Vs)
    ! In case of no shelf, the Hs and the Hi are resetted at shelf points
    USE parameters_main_module, ONLY: ice_density, seawater_density 
    IMPLICIT NONE

    ! Input variable:
    INTEGER,  DIMENSION(C%NX_ant,C%NY_ant), INTENT(IN)    :: mask
    REAL(dp), DIMENSION(C%NX_ant,C%NY_ant), INTENT(IN)    :: sealevel  ! Relative to pd_sealevel [m]

    ! In/Output variables:
    REAL(dp), DIMENSION(C%NX_ant,C%NY_ant), INTENT(INOUT) :: Hi        ! [m]
    REAL(dp), DIMENSION(C%NX_ant,C%NY_ant), INTENT(INOUT) :: Hs        ! Relative to pd_sealevel [m]
    REAL(dp), DIMENSION(C%NX_ant,C%NY_ant), INTENT(INOUT) :: dHi_dt    ! [m yr^-1]
    REAL(dp), DIMENSION(C%NX_ant,C%NY_ant), INTENT(INOUT) :: Us        ! [m yr^-1]
    REAL(dp), DIMENSION(C%NX_ant,C%NY_ant), INTENT(INOUT) :: Vs        ! [m yr^-1]

    ! Local variable:
    REAL(dp), DIMENSION(C%NX_ant,C%NY_ant)                :: Hs_shelf   

    ! The surface heigth of the very thin floating ice layer with thickness C%Hi_min:
    Hs_shelf = sealevel + (1._dp - ice_density / seawater_density) * C%Hi_min
    WHERE(mask == C%type_shelf)
     Hs     = Hs_shelf
     Hi     = C%Hi_min
     dHi_dt = 0._dp
     Us     = 0._dp
     Vs     = 0._dp
    END WHERE
  END SUBROUTINE adapt_Hi_and_Hs_for_no_shelf

END MODULE surface_height_ant_module
