MODULE mask_ant_module
  USE configuration_main_module, ONLY: dp, C
  IMPLICIT NONE

CONTAINS
  SUBROUTINE determine_mask(Hi, Hb, sealevel, mask, calve_mask)
    ! This routine calculates a new mask for ALL points:
    ! A shelf/ocean point and a sheet/rock point can NEVER be neighbours, since a
    ! grounded point that has a shelf/ocean point as neighbour is by definition a
    ! groundline point.
    USE parameters_main_module, ONLY: ice_density, seawater_density

    ! Input variables: 
    REAL(dp), DIMENSION(C%NX_ant,C%NY_ant), INTENT(IN)            :: Hi, Hb
    REAL(dp), DIMENSION(C%NX_ant,C%NY_ant), INTENT(IN)            :: sealevel
     
    ! Output variables:  
    INTEGER,  DIMENSION(C%NX_ant,C%NY_ant), INTENT(OUT)           :: mask
    INTEGER,  DIMENSION(C%NX_ant,C%NY_ant), INTENT(OUT)           :: calve_mask
    
    ! Local variables:
    INTEGER                                               :: i, j 
    
    ! Distinguish between shelf/ocean and sheet/rock points (by the combined
    ! ice floating condition and the sealevel-bedrock level comparison):
    WHERE((ice_density / seawater_density) * Hi <= (sealevel - Hb))
     mask = C%type_shelf
    ELSEWHERE
     mask = C%type_sheet
    END WHERE
            
    ! Mark sheet points at the domain boundary always as groundline:
    WHERE(mask(       1,       :) == C%type_sheet) mask(       1,       :) = C%type_groundline
    WHERE(mask(C%NX_ant,       :) == C%type_sheet) mask(C%NX_ant,       :) = C%type_groundline
    WHERE(mask(       :,       1) == C%type_sheet) mask(       :,       1) = C%type_groundline
    WHERE(mask(       :,C%NY_ant) == C%type_sheet) mask(       :,C%NY_ant) = C%type_groundline
    
    ! Marking the rest of the sheet points that border to shelf points
    ! as groundline points:
    DO j = 2, C%NY_ant - 1
    DO i = 2, C%NX_ant - 1
     IF(mask(i,j) == C%type_sheet) THEN
      IF(mask(i+1,j  ) == C%type_shelf .OR. mask(i-1,j  ) == C%type_shelf .OR. &
         mask(i  ,j+1) == C%type_shelf .OR. mask(i  ,j-1) == C%type_shelf) THEN
!         mask(i+1,j+1) == C%type_shelf .OR. mask(i-1,j-1) == C%type_shelf .OR. &
!         mask(i-1,j+1) == C%type_shelf .OR. mask(i+1,j-1) == C%type_shelf .OR. &
       mask(i,j) = C%type_groundline
      END IF
     END IF 
    END DO
    END DO
    
    ! Shelf points with a thickness less then the calve thickness becomes ocean, and a
    ! calveline is made between shelf and ocean points:

     calve_mask = mask
     WHERE((calve_mask == C%type_shelf) .AND. (Hi < C%calve_thickness)) calve_mask = C%type_ocean
     DO j = 2, C%NY_ant - 1
     DO i = 2, C%NX_ant - 1
      IF(calve_mask(i,j) == C%type_shelf) THEN
       IF(calve_mask(i+1,j  ) == C%type_ocean .OR. calve_mask(i-1,j  ) == C%type_ocean .OR. &
          calve_mask(i  ,j+1) == C%type_ocean .OR. calve_mask(i  ,j-1) == C%type_ocean) THEN
!          calve_mask(i+1,j+1) == C%type_ocean .OR. calve_mask(i-1,j-1) == C%type_ocean .OR. &
!          calve_mask(i-1,j+1) == C%type_ocean .OR. calve_mask(i+1,j-1) == C%type_ocean .OR. &
        calve_mask(i,j) = C%type_calveline
       END IF
      END IF 
     END DO
     END DO

  END SUBROUTINE determine_mask
END MODULE mask_ant_module
