MODULE configuration_main_module
      IMPLICIT NONE
      
      ! Changed/Added BdB 01/2010: module read/open in inverse_coupling_module
      ! most parameters are the same for the different ice-sheets

      ! PRECISION
      ! =========
      ! The kind of real numbers used by default throughout the program.
      ! Reals should be declared as:
      !
      ! REAL(dp) :: example
      !  or
      ! REAL(KIND=dp) :: example
      !
      ! dp must be a PARAMETER:
      INTEGER, PARAMETER                :: dp  = KIND(1.0D0)  ! Kind of double precision numbers.
     
      ! Each time step the time is copied into this variable, which can be used with writing messages:
      REAL(dp),                    SAVE :: Model_Time
      LOGICAL,                     SAVE :: Called_Selen
      LOGICAL,                     SAVE :: Insolation_Adjusted
      REAL(dp),                    SAVE :: Ocean_Area_Earth
      REAL(dp),                    SAVE :: Ocean_Depth_Earth

   ! CONFIG VARIABLES:
   !==================
   ! Variables which are eventually set by the read_main_config_file subroutine (if in the CONFIG file):
      
      ! GRID SIZE AND SPACING (same for all models)
      ! ===========================================
      ! Number of grid points
      INTEGER  :: NX_eas_config =   171                                      ! CONFIG variable
      INTEGER  :: NY_eas_config =   105                                      ! CONFIG variable

      INTEGER  :: NX_nam_config =   181                                      ! CONFIG variable
      INTEGER  :: NY_nam_config =   121                                      ! CONFIG variable

      INTEGER  :: NX_ant_config =   141                                      ! CONFIG variable
      INTEGER  :: NY_ant_config =   141                                      ! CONFIG variable

      INTEGER  :: NX_grl_config =    77                                      ! CONFIG variable
      INTEGER  :: NY_grl_config =   141                                      ! CONFIG variable

      ! Grid spacing in meters for the four ice sheets
      REAL(dp) :: dx_eas_config = 40000._dp
      REAL(dp) :: dy_eas_config = 40000._dp      

      REAL(dp) :: dx_nam_config = 40000._dp
      REAL(dp) :: dy_nam_config = 40000._dp      

      REAL(dp) :: dx_ant_config = 40000._dp
      REAL(dp) :: dy_ant_config = 40000._dp      

      REAL(dp) :: dx_grl_config = 20000._dp
      REAL(dp) :: dy_grl_config = 20000._dp      

      INTEGER  :: NZL_config    =   251                                      ! CONFIG variable
      INTEGER  :: z_step_config =    40                                      ! CONFIG variable

      ! Number of grid points in vertical direction for thermodynamics in ice sheet, if k is a counter
      ! through the vertical layers, k=1 at the surface and k=NZ at the bottom of the ice sheet:
      INTEGER  :: NZ_config     =    15                                      ! CONFIG variable
      ! Relative grid spacing in vertical direction in ice sheet. If k is a counter through the vertical layers, k=1 
      ! at the surface corresponding with zeta=0, and k=NZ at the bottom of the ice sheet corresponding with zeta=1:
      ! This CONFIG variable zeta_config is declared as a large array, because fortran does not allow a CONFIG/NAMELIST
      ! variable which is ALLOCATABLE, only the C%NZ first elements of this array will be used and have to be specified
      ! in the CONFIG file. 
      REAL(dp), DIMENSION(210), SAVE :: zeta_config = &
       (/0.00_dp, 0.10_dp, 0.20_dp, 0.30_dp, 0.40_dp, 0.50_dp, 0.60_dp, 0.70_dp, 0.80_dp, 0.90_dp, 0.925_dp, 0.95_dp, 0.975_dp, 0.99_dp, 1.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp, &
         0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp,  0.00_dp, 0.00_dp  /)

      ! INVERSE ROUTINE PARAMETERS (INVERSE COUPLING: MAIN PROGRAM)
      ! ===========================================================

      ! use all four ice-sheets or only two (EAS and NAM):
      CHARACTER(LEN=4)    :: which_icesheets_config            = 'NEGA'
      REAL(dp)            :: PD_benthic_isotope_config         = 3.228_dp
      REAL(dp)            :: tuner_one_config                  = 20._dp
      INTEGER             :: averaging_time_climate_config     = 20
      INTEGER             :: averaging_time_deepwater_config   = 30
      REAL(dp)            :: scale_dw_config                   = 0.2_dp
      
      LOGICAL             :: paleo_reference_noice_config      = .FALSE.
      
      ! TIME 
      ! ====
      ! Basic time step (in years) of the model:
      REAL(dp) :: dt_config = 1.0_dp                                         ! CONFIG variable

      ! Length of time integration: from start time to end time:
      REAL(dp) :: start_time_of_run_config   =         0.0_dp                ! CONFIG variable
      REAL(dp) :: end_time_of_run_config     =      2000.0_dp                ! CONFIG variable

     ! With this variable all time steps (below) can be multiplied:
      REAL(dp) :: time_step_multiplier_config = 1.0_dp                       ! CONFIG variable
      
      ! Time step (in years) used for thermodynamics:
      REAL(dp) :: dt_thermo_config = 6.0_dp                                  ! CONFIG variable

      ! Time step (in years) used for velocity:
      REAL(dp) :: dt_shelf_velocity_config = 6.0_dp                          ! CONFIG variable

      ! Time step (in years) for bedrock adjustment:
      REAL(dp) :: dt_bedrock_config = 100.0_dp                               ! CONFIG variable
     
      ! Time step (in years) for writing restart files:
      REAL(dp) :: dt_restart_config = 100.0_dp                               ! CONFIG variable
 
      ! Time step (in years) for writing time recording variables:
      REAL(dp) :: dt_recording_config = 20.0_dp                              ! CONFIG variable

      ! OUTPUT/RESTART/ FILE (defined in grid_module of ice sheet)
      ! ============================
      ! record number used for initialization in case of restarting
      ! from a restart file
      INTEGER            :: starting_recordnr_config = 1                     ! CONFIG variable

      ! Name of an ascii forcing file (containing a sealevel and a delta 
      ! temperature time record, also used to scale the MB and Ts forcing):
      CHARACTER(LEN=256) :: forcing_filename_config = '../branches/icedyn/data/forcing/LR04_time_d18O_5Ma.dat'

      ! Name of the insolation file (if varying), PD forcing is default for 
      ! choice 1 (steady state)
      CHARACTER(LEN=256) :: insolation_filename_config = '../branches/icedyn/data/forcing/time_latitude_insolation_Laskar_6Myr.dat'

      ! Add extension to file names which marks the location of the run and run number
      CHARACTER(LEN=256) :: filename_extension_config = ''
      
      INTEGER            :: climate_fields_length_config = 12                ! CONFIG variable

      ! Choices about which netcdf files will be created during the run: 
      LOGICAL            :: enable_restart_file_config     = .TRUE.          ! CONFIG variable
      LOGICAL            :: enable_recording_file_config   = .TRUE.          ! CONFIG variable
      LOGICAL            :: enable_help_fields_file_config = .TRUE.          ! CONFIG variable

      INTEGER            :: which_help_fields_config       = 32              ! CONFIG variable
      INTEGER            :: which_recording_fields_config  = 24              ! CONFIG variable


! Added DoE 09/10/2017
        LOGICAL            :: use_geoid_forcing_config = .FALSE.          ! CONFIG variable
        LOGICAL            :: use_pippa_model_config = .FALSE.


      ! Name of the netcdf files containg the initial fields
      CHARACTER(LEN=256) :: initial_ant_filename_config = '/Users/boer/ANICE4/trunk/Initial_anice/Antarctica/initial_antartica_cism.nc'
      CHARACTER(LEN=256) :: initial_grl_filename_config = '/Users/boer/ANICE4/trunk/Initial_anice/Greenland/initial_greenland_cism.nc' 
      CHARACTER(LEN=256) :: initial_eas_filename_config = '/Users/boer/ANICE4/trunk/Initial_anice/Eurasia/initial_eurasia_nogrl.nc' 
      CHARACTER(LEN=256) :: initial_nam_filename_config = '/Users/boer/ANICE4/trunk/Initial_anice/North_America/initial_north_america_nogrl.nc' 

      ! Name of the netcdf files containg the monthly fields of the reference climate of T2m and Precipitation
      CHARACTER(LEN=256) :: monthly_ant_filename_config = '/input_fields/antarctica/eraint_monthly_T2m_Precip_antarctica_40x40km.nc'
      CHARACTER(LEN=256) :: monthly_grl_filename_config = '/input_fields/greenland/eraint_monthly_T2m_Precip_greenland_20x20km.nc'
      CHARACTER(LEN=256) :: monthly_eas_filename_config = '/input_fields/eurasia/eraint_monthly_T2m_Precip_eurasia_40x40km.nc'
      CHARACTER(LEN=256) :: monthly_nam_filename_config = '/input_fields/north_america/eraint_monthly_T2m_Precip_northamerica_40x40km.nc'

      ! Name of the netcdf files containing the extra fields: Longitude, Latitude, Heatflux and reference surface height
      CHARACTER(LEN=256) :: extra_fields_ant_filename_config = '/input_fields/antarctica/eraint_Lon_Lat_Hflux_Hs_antarctica_40x40km.nc'
      CHARACTER(LEN=256) :: extra_fields_grl_filename_config = '/input_fields/greenland/eraint_Lon_Lat_Hflux_Hs_greenland_20x20km.nc'
      CHARACTER(LEN=256) :: extra_fields_eas_filename_config = '/input_fields/eurasia/eraint_Lon_Lat_Hflux_Hs_eurasia_40x40km.nc'
      CHARACTER(LEN=256) :: extra_fields_nam_filename_config = '/input_fields/north_america/eraint_Lon_Lat_Hflux_Hs_northamerica_40x40km.nc'

      CHARACTER(LEN=256) :: wind_fields_nam_filename_config  = '/input_fields/northamerica/mmm_winds_700hPa_lgm_extrapolated.nc'

      ! Name of the initialised SELEN topography file with ANICE elements:
      CHARACTER(LEN=256) :: pixels_with_anice_filename_config  = 'ice_loaded_pixels_anice_res60'
      CHARACTER(LEN=256) :: topo_anice_res60_filename_config   = 'selen-px-topo-res60.pixelized'

      CHARACTER(LEN=256) :: restart_selen_ice_filename_config  = 'restart_ice_loaded_pixels'
      CHARACTER(LEN=256) :: restart_selen_mems_filename_config = 'restart_mem_s_selen'

      CHARACTER(LEN=256) :: initial_selen_ice_filename_config  = 'restart_ice_loaded_pixels'
      CHARACTER(LEN=256) :: initial_selen_mems_filename_config = 'restart_mem_s_selen'

      CHARACTER(LEN=256) :: restart_selen_nam_filename_config  = 'restart_nam_selen'
      CHARACTER(LEN=256) :: restart_selen_eas_filename_config  = 'restart_eas_selen'
      CHARACTER(LEN=256) :: restart_selen_grl_filename_config  = 'restart_grl_selen'
      CHARACTER(LEN=256) :: restart_selen_ant_filename_config  = 'restart_ant_selen'

      CHARACTER(LEN=256) :: initial_selen_nam_filename_config  = 'restart_nam_selen'
      CHARACTER(LEN=256) :: initial_selen_eas_filename_config  = 'restart_eas_selen'
      CHARACTER(LEN=256) :: initial_selen_grl_filename_config  = 'restart_grl_selen'
      CHARACTER(LEN=256) :: initial_selen_ant_filename_config  = 'restart_ant_selen'

      ! Name of the netcdf files containg the monthly fields from the climate model
      CHARACTER(LEN=256) :: climate_fields_ant_filename_config = '/input_fields/fields_from_famous/famous_monthly_T2m_Precip_antarctica_40x40km.nc'
      CHARACTER(LEN=256) :: climate_fields_grl_filename_config = '/input_fields/fields_from_famous/famous_monthly_T2m_Precip_greenland_20x20km.nc'
      CHARACTER(LEN=256) :: climate_fields_eas_filename_config = '/input_fields/fields_from_famous/famous_monthly_T2m_Precip_eurasia_40x40km.nc'
      CHARACTER(LEN=256) :: climate_fields_nam_filename_config = '/input_fields/fields_from_famous/famous_monthly_T2m_Precip_northamerica_40x40km.nc'

      ! Name of netcdf file with ocean temperatures from the climate model
      CHARACTER(LEN=256) :: ocean_temp_ant_filename_config     = '/input_fields/pliotrans/hadcm3_pliocene_temperature_ocean_antarctica_40x40km.nc'

      ! Name of files for the schematic experiment, located over the South pole, so longitude and latitude adopted from Antarctica
      CHARACTER(LEN=256) :: initial_sch_filename_config        = '/input_fields/schematic/initial_schematic_noice_30x30km.nc' 
      CHARACTER(LEN=256) :: initial_sch2_filename_config       = '/input_fields/schematic/initial_schematic_nh_40x40km.nc' 

      CHARACTER(LEN=256) :: extra_fields_sch_filename_config   = '/input_fields/schematic/schematic_longitude_latitude_30x30km.nc'
      CHARACTER(LEN=256) :: extra_fields_sch2_filename_config  = '/input_fields/schematic/schematic_longitude_latitude_nh_40x40km.nc'



        ! Name of viscosity fiels (Added by DoE, 25/04/2017)
        CHARACTER(LEN=256) :: viscosity_ant_filename_config  = '/Users/Dirk/Study/MSc/Final Thesis/Models/anice_coupled_model_antarctica-bvdb/input_fields/antarctica/viscosity_field_file.nc'

        CHARACTER(LEN=256) :: geoid_ant_filename_config  = '/Users/Dirk/Study/MSc/Final Thesis/Models/anice_coupled_model_antarctica-bvdb/input_fields/antarctica/geoid_ant.nc'
        CHARACTER(LEN=256) :: pippa_rt_filename_config  = '/Users/Dirk/Study/MSc/Final Thesis/Models/anice_coupled_model_antarctica-bvdb/input_fields/antarctica/viscosity_files/pippa_model/SL_4mm_dry.nc'
       CHARACTER(LEN=256) :: ant_mask_filename_config  = '/Users/Dirk/Study/MSc/Final Thesis/Models/anice_coupled_model_antarctica-bvdb/input_fields/antarctica/viscosity_files/pippa_model/SL_4mm_dry.nc'





      ! PATH FOR OUTPUT DATA
      ! ==========================
      ! Name of directory to which the output data is written:
      CHARACTER(LEN=256) :: output_dir_config = 'Results_ICE4/'


      ! PATH OF SELEN INPUT DATA
      ! ==========================
      ! Name of the directory with the initial data for SELEN:
      CHARACTER(LEN=256) :: selen_dir_config = '/Users/boer/ANICE4/trunk/data/selen'

      ! FORCING
      ! =======
      ! The d18O records that are available are (all at 100 year resolution):
      ! ================================================================
      ! Lisiecki and Raymo (2005) stacked record:
      ! filename = LR04_time_d18O_5Ma.dat
      ! size = 53201, start_time = -5320000, PD value = 3.23
      ! ================================================================
      ! Zachos (2008) stacked record:
      ! filename = Zachos_2008_d18O_60Ma.dat
      ! size = 600000, start_time = -60000000, PD value = 3.23
      ! filename = Zachos_2008_d18O_40Ma.dat
      ! size = 400000, start_time = -40000000, PD value = 3.23
      ! ================================================================
      ! Coxall (2005) data from site 1218 (Eocene, Oligocene)
      ! filename = Coxall_time_d18O_site1218.dat
      ! size = 43415, start_time = -35257000, PD value = 3.23
      ! ================================================================
      ! Liebrands (2010) data from site 1264 (Miocene)
      ! filename = Liebr_time_d18O_site1264.dat
      ! size = 49558, start_time = -23797500, PD value = 3.23
      ! ================================================================
      ! Cramer (2009) stacked record - using all data, adjusted Cib and Nut species
      ! filename = Cramer_2009_d18O_40Ma.dat
      ! size = 400001, start_time = -40000000, PD value = 3.15
      ! ================================================================
      ! Lourens (2013) Nediteranean d18O record - no adjustments
      ! filename = Lourens_Med_d18O_5to1Ma.dat
      ! size = 41122, start_time = -5324600, PD value = 1.4

      ! The temp and sealevel records that are available are (all at 100 year resolution):
      ! ================================================================
      ! Bintanja and Van de Wal, 2008 modelling results
      ! filename = BW08_relativePD_hsl_temp_4Ma.dat
      ! size = 40001, start_time = -4000000, PD values are zero
      
      ! Testing the model with Cramer data from different regions, over the past 5 Myr
      ! ================================================================
      ! Cramer et al data (2009): all regions
      ! filename = Cramer_time_all_d18O_5Ma.dat
      ! size = 55653, start_time = -5565200, PD values = 3.15
      ! ================================================================
      ! Cramer et al data (2009): North Atlantic ocean
      ! filename = Cramer_time_AtlN_d18O_5Ma.dat
      ! size = 55653, start_time = -5565200, PD values = 3.162
      ! ================================================================
      ! Cramer et al data (2009): Atlantic and Southern ocean
      ! filename = Cramer_time_AtlS_d18O_5Ma.dat
      ! size = 55595, start_time = -5559400, PD values = 3.15
      ! ================================================================
      ! Cramer et al data (2009): Pacific ocean
      ! filename = Cramer_time_all_d18O_5Ma.dat
      ! size = 55652, start_time = -5565100, PD values = 3.157
      
      INTEGER            :: size_climate_record_config = 53201               ! CONFIG variable

      ! Time step between time climate records in years:
      REAL(dp)           :: dt_climate_record_config = 100.0_dp              ! CONFIG variable

      ! Time of first climate record:
      REAL(dp)           :: start_time_climate_record_config = -5320000.0_dp ! CONFIG variable

      INTEGER            :: choice_forcing_config = 2                        ! CONFIG variable

      REAL(dp)           :: constant_forcing_sealevel_config = 0._dp         ! CONFIG variable
      REAL(dp)           :: constant_forcing_gT_offset_config = 0._dp        ! CONFIG variable
      REAL(dp)           :: constant_forcing_d18O_config = 3.23_dp           ! CONFIG variable
      
      INTEGER            :: choice_insolation_config = 1                     ! CONFIG variable
      LOGICAL            :: monotonic_geothermal_heat_flux_config = .TRUE.   ! CONFIG variable
    
      REAL(dp)           :: plot_unit_total_ice_volume_config  = 1.0E16_dp   ! CONFIG variable
      REAL(dp)           :: plot_unit_total_ice_area_config    = 1.0_dp      ! CONFIG variable
      REAL(dp)           :: plot_unit_total_MB_surface_config  = 1.0E13_dp   ! CONFIG variable

      ! MINIMUM ICE THICKNESS AND MAXIMUM CHANGE PER TIME STEP
      ! ======================================================
      REAL(dp)           :: Hi_min_config                      = 0.1_dp      ! CONFIG variable
      REAL(dp)           :: maximum_dHi_change_per_year_config = 100._dp     ! CONFIG variable

      ! SELEN
      ! ===
      LOGICAL            :: use_selen_config                   = .FALSE.     ! CONFIG variable
      LOGICAL            :: init_selen_config                  = .FALSE.     ! CONFIG variable
      LOGICAL            :: use_selen_with_eustatic_config     = .FALSE.     ! CONFIG variable 
      LOGICAL            :: use_anice_with_eustatic_config     = .FALSE.     ! CONFIG variable 
      CHARACTER(LEN=6)   :: choice_selen_interpolate_config    = 'linear'    ! CONFIG variable
      INTEGER            :: end_tdof_iteration_config          = 1
      INTEGER            :: selen_max_iteration_config         = 1           ! CONFIG variable
      
      LOGICAL            :: use_rotational_feedback_config     = .TRUE.      ! CONFIG variable
      INTEGER            :: time_window_length_config          = 15          ! CONFIG variable

      ! The time convolution within SELEN uses a moving time window of time_window_length. This defines the lengh of the 
      ! time_window_steps array that contains the time steps. time_window_steps_config is declared as a large array, same as zeta_config, 
      ! only the C%time_window_length elements of this array will be used and have to be specified in the CONFIG file. 
      REAL(dp), DIMENSION(50), SAVE :: time_window_steps_config = &
       (/20._dp, 20._dp, 20._dp, 5._dp, 5._dp, 1._dp, 1._dp, 1._dp, 1._dp, 1._dp, 1._dp, 1._dp, 1._dp, 1._dp, 1._dp, &
          0._dp,  0._dp,  0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, &
          0._dp,  0._dp,  0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, 0._dp, &
          0._dp,  0._dp,  0._dp, 0._dp, 0._dp  /)

      LOGICAL            :: restart_model_config                = .FALSE.     ! CONFIG variable
      LOGICAL            :: skip_last_sle_iter_config           = .FALSE.     ! CONFIG variable

      ! TABOO
      ! ===
      REAL(dp)           :: earth_lithosphere_thick_config            = 100._dp
      INTEGER            :: earth_number_of_layers_config             = 3
      REAL(dp), DIMENSION(3), SAVE :: earth_viscosity_profile_config  = (/ 3._dp, 0.6_dp, 0.3_dp /)

      ! SLIDING
      ! =======
      REAL(dp)           :: melt_range_config                  = 1._dp       ! CONFIG variable
      LOGICAL            :: include_sliding_heatflux_config    = .FALSE.     ! CONFIG variable
      LOGICAL            :: always_sliding_config              = .FALSE.     ! CONFIG variable
      
      REAL(dp)            :: m_enh_sia_config                  = 4._dp
      REAL(dp)            :: m_enh_ssa_config                  = 1._dp

      REAL(dp)           :: pf1_config                         = -1000._dp
      REAL(dp)           :: pf2_config                         =     0._dp
      REAL(dp)           :: p_min_config                       =     5._dp
      REAL(dp)           :: p_max_config                       =    20._dp

      REAL(dp)           :: wat_level_min_config               =     0._dp
      REAL(dp)           :: wat_level_max_config               =  1000._dp

      ! Variables for solving SSA - for the moment only for antarctica, rest is kept at default (being the config variables shown here)
      INTEGER            :: max_iter_gauss_seidel_config       = 833               ! Maximum number of iterations
      REAL(dp)           :: gauss_seidel_relaxation_config     =   1.6_dp          ! Relaxation parameter
      REAL(dp)           :: residual_epsilon_config            =   0.1_dp          ! Stop criterium. The residual should drop below this value everywhere

      REAL(dp)           :: d_uv_3d_cutoff_config              = -1E5_dp

      LOGICAL            :: use_grounding_line_param_config    = .FALSE.     ! CONFIG variable
      INTEGER            :: interpol_grline_power_config       = 6           ! CONFIG variable

      ! MASS BALANCE
      ! ============
      REAL(dp)           :: calve_thickness_config             = 200._dp     ! CONFIG variable
      INTEGER            :: choice_MB_surface_model_config     = 10          ! CONFIG variable
      
      REAL(dp)           :: C_abl_constant_config              = 32._dp
      REAL(dp)           :: C_abl_grl_constant_config          = 40._dp
      REAL(dp)           :: C_abl_nh_constant_config           = 32._dp
      REAL(dp)           :: C_abl_Ts_config                    = 10._dp
      REAL(dp)           :: C_abl_Q_config                     = 0.513_dp
      REAL(dp)           :: C_abl_grl_Q_config                 = 0.513_dp
     
      LOGICAL            :: use_sw_down_flux_at_surface_config = .FALSE.

      ! Daily cycle parameters
      LOGICAL            :: use_melt_daily_cycle_config        = .FALSE.
      INTEGER            :: N_day_int_config                   = 1

      ! TEMPERATURE
      ! ===========
      INTEGER            :: x_fixed_config                     = 10          ! CONFIG variable
      INTEGER            :: y_fixed_config                     = 10          ! CONFIG variable
      INTEGER            :: choice_temperature_model_config    = 1           ! CONFIG variable
      REAL(dp)           :: dTi_below_T_pmp_config             = 0._dp       ! CONFIG variable
      REAL(dp)           :: Ti_fixed_config                    = 253.15_dp   ! CONFIG variable
      REAL(dp)           :: subshelf_melt_factor_config        = 0.005_dp    ! CONFIG variable
      LOGICAL            :: do_temperature_spin_up_config      = .FALSE.

      LOGICAL            :: use_3D_ocean_temperature_config    = .FALSE.
      INTEGER            :: number_of_ocean_layers_config      = 19
      
      LOGICAL            :: use_lgm_winds_scaling_config       = .FALSE.

      ! CROSS SECTION
      ! =============
      REAL(dp)               :: glacier_altitude_shift_config    = 0._dp     ! CONFIG variable
      REAL(dp), DIMENSION(4) :: fake_value_for_bedrock_config    = (/ 200._dp,   3._dp, 3._dp, 3._dp /) ! CONFIG variable
      REAL(dp), DIMENSION(4) :: fake_value_for_atmosphere_config = (/ 275._dp,   2._dp, 2._dp, 2._dp /) ! CONFIG variable
      REAL(dp), DIMENSION(4) :: fake_value_for_ocean_config      = (/ 271.15_dp, 1._dp, 1._dp, 1._dp /) ! CONFIG variable

      ! OUTPUT MESSAGES
      ! ===============
      LOGICAL            :: choice_write_message_config = .FALSE.             ! CONFIG variable


      ! TEST/DEBUG VARIABLES
      ! ====================
      INTEGER            :: testing_integer_config = 0                       ! CONFIG variable   
      REAL(dp)           :: testing_real_dp_config = 0._dp                   ! CONFIG variable  

      ! TIME ADJUSTMENT
      ! ====================
      LOGICAL            :: dynamic_time_step_adaption_config = .FALSE.      ! CONFIG variable
      REAL(dp)           :: dt_max_config                     = 6._dp
      REAL(dp)           :: time_step_scaling_config          = 1._dp

      ! PHYSICAL PARAMETERS
      ! ===================
      REAL(dp)           :: geothermal_heat_flux_config       = 1.72E06_dp    ! Geothermal Heat flux [J m^-2 yr^-1] Sclater et al. (1980)

      ! SCHEMATIC EXPERIMENT PARAMETERS
      ! ===================
      REAL(dp)           :: basal_shelf_melt_config           = 2._dp
      REAL(dp)           :: constant_SMB_schematic_config     = 0.3_dp
      REAL(dp)           :: A_flow_schematic_config           = 1.0E-24_dp    ! in Pa-3 s-1
      REAL(dp)           :: max_ice_thickness_nh_config       = 4400._dp

    ! TYPE DEFENITIONS
    !=================

      ! This TYPE contains all the information once the CONFIG file is read never will change during the run of the program 
      TYPE constants_type                
                                          ! GRID SIZES AND GRID SPACING
                                          !===============================
        INTEGER                             :: NX_eas   ! Number of X grid points for the EuIS
        INTEGER                             :: NY_eas   ! Number of Y grid points for the EuIS
        INTEGER                             :: NX_nam   ! Number of X grid points for the NaIS
        INTEGER                             :: NY_nam   ! Number of Y grid points for the NaIS
        INTEGER                             :: NX_ant   ! Number of X grid points for the AIS
        INTEGER                             :: NY_ant   ! Number of Y grid points for the AIS
        INTEGER                             :: NX_grl   ! Number of X grid points for the GrIS
        INTEGER                             :: NY_grl   ! Number of Y grid points for the GrIS
        INTEGER                             :: NZ       ! Number of grid points in vertical direction for thermodynamics in ice sheet
        REAL(dp), DIMENSION(:), ALLOCATABLE :: zeta    

        REAL(dp)                            :: dx_eas
        REAL(dp)                            :: dy_eas
        REAL(dp)                            :: dx_nam
        REAL(dp)                            :: dy_nam
        REAL(dp)                            :: dx_ant
        REAL(dp)                            :: dy_ant
        REAL(dp)                            :: dx_grl
        REAL(dp)                            :: dy_grl

        INTEGER                             :: NZL      ! Number of grid points in the Linear vertical direction
        REAL(dp)                            :: z_step   ! Linear vertical grid size     

                                ! Main model parameters (BdB added 03/2010)
                                !================================
        CHARACTER(LEN=4)         :: which_icesheets
        REAL(dp)                 :: PD_benthic_isotope
        REAL(dp)                 :: tuner_one
        INTEGER                  :: averaging_time_climate
        INTEGER                  :: averaging_time_deepwater
        REAL(dp)                 :: scale_dw
        LOGICAL                  :: paleo_reference_noice
      
                                ! TIME CONDITIONS    
                                !===============================
        REAL(dp)                 :: start_time_of_run  ! Start time of run; see the CONFIG file or the default
        REAL(dp)                 :: end_time_of_run    ! End time of run; see the CONFIG file or the default
        INTEGER                  :: starting_recordnr  ! The number of the netcdf record which is used as the start record; see the CONFIG file or the default
        REAL(dp)                 :: dt                 ! Time step (in years) of run; see the CONFIG file or the default
        REAL(dp)                 :: dt_thermo          ! Time step (in years) used for the thermodynamics        
        REAL(dp)                 :: dt_shelf_velocity  ! Time step (in years) used for the shelf velocity       
        REAL(dp)                 :: dt_bedrock         ! Time step (in years) for bedrock adjustment        
        REAL(dp)                 :: dt_restart         ! Time step (in years) for writing restart files   
        REAL(dp)                 :: dt_recording       ! Time step (in years) for writing recording files       

        REAL(dp)                 :: time_step_multiplier ! With this variable all time steps can be multiplied

                                ! FORCING RECORD
                                !===============================
        INTEGER                  :: size_climate_record         ! The number of climate records
        REAL(dp)                 :: start_time_climate_record   ! oldest time of records; see the CONFIG file or the default
        REAL(dp)                 :: dt_climate_record           ! time steps between the records; see the CONFIG file or the default
        LOGICAL                  :: use_geoid_forcing           ! doe 09/10
        LOGICAL                  :: use_pippa_model           ! doe 20/10

                                ! RUN MODES
                                !===============================
        LOGICAL                  :: monotonic_geothermal_heat_flux

                                ! SELEN 
                                !===============================
        LOGICAL                             :: use_selen
        LOGICAL                             :: init_selen
        LOGICAL                             :: use_selen_with_eustatic
        LOGICAL                             :: use_anice_with_eustatic
        CHARACTER(LEN=6)                    :: choice_selen_interpolate
        INTEGER                             :: end_tdof_iteration
        INTEGER                             :: selen_max_iteration
        LOGICAL                             :: use_rotational_feedback
        INTEGER                             :: steps_per_selen
        INTEGER                             :: time_window_length
        REAL(dp), DIMENSION(:), ALLOCATABLE :: time_window_steps

        LOGICAL                             :: restart_model
        LOGICAL                             :: skip_last_sle_iter

                                ! TABOO 
                                !===============================

        REAL(dp)                            :: earth_lithosphere_thick
        INTEGER                             :: earth_number_of_layers
        REAL(dp), DIMENSION(:), ALLOCATABLE :: earth_viscosity_profile
        
                                ! TYPES OF LAND
                                !===============================
        INTEGER                  :: type_sheet        
        INTEGER                  :: type_groundline       
        INTEGER                  :: type_shelf       
        INTEGER                  :: type_calveline       
        INTEGER                  :: type_ocean       
        INTEGER                  :: type_outofbound               ! out of boundary, used for Eurasia and North America (added BdB 10/2009) 
        
                                ! FILE NAMES:
                                !============
        CHARACTER(LEN=256)       :: filename_extension
        
        INTEGER                  :: climate_fields_length

        CHARACTER(LEN=256)       :: forcing_filename
        CHARACTER(LEN=256)       :: insolation_filename

        CHARACTER(LEN=256)       :: restart_ant_filename
        CHARACTER(LEN=256)       :: restart_grl_filename
        CHARACTER(LEN=256)       :: restart_eas_filename
        CHARACTER(LEN=256)       :: restart_nam_filename

        CHARACTER(LEN=256)       :: recording_ant_filename
        CHARACTER(LEN=256)       :: recording_grl_filename
        CHARACTER(LEN=256)       :: recording_eas_filename
        CHARACTER(LEN=256)       :: recording_nam_filename

        CHARACTER(LEN=256)       :: help_fields_ant_filename
        CHARACTER(LEN=256)       :: help_fields_grl_filename
        CHARACTER(LEN=256)       :: help_fields_eas_filename
        CHARACTER(LEN=256)       :: help_fields_nam_filename

        CHARACTER(LEN=256)       :: initial_ant_filename
        CHARACTER(LEN=256)       :: initial_grl_filename
        CHARACTER(LEN=256)       :: initial_eas_filename
        CHARACTER(LEN=256)       :: initial_nam_filename

        CHARACTER(LEN=256)       :: monthly_ant_filename
        CHARACTER(LEN=256)       :: monthly_grl_filename
        CHARACTER(LEN=256)       :: monthly_eas_filename
        CHARACTER(LEN=256)       :: monthly_nam_filename

        CHARACTER(LEN=256)       :: extra_fields_ant_filename
        CHARACTER(LEN=256)       :: extra_fields_grl_filename
        CHARACTER(LEN=256)       :: extra_fields_eas_filename
        CHARACTER(LEN=256)       :: extra_fields_nam_filename

        CHARACTER(LEN=256)       :: wind_fields_nam_filename

        CHARACTER(LEN=256)       :: pixels_with_anice_filename
        CHARACTER(len=256)       :: topo_anice_res60_filename

        CHARACTER(LEN=256)       :: restart_selen_ice_filename
        CHARACTER(LEN=256)       :: restart_selen_mems_filename

        CHARACTER(LEN=256)       :: initial_selen_ice_filename
        CHARACTER(LEN=256)       :: initial_selen_mems_filename

        CHARACTER(LEN=256)       :: restart_selen_nam_filename
        CHARACTER(LEN=256)       :: restart_selen_eas_filename
        CHARACTER(LEN=256)       :: restart_selen_grl_filename
        CHARACTER(LEN=256)       :: restart_selen_ant_filename

        CHARACTER(LEN=256)       :: initial_selen_nam_filename
        CHARACTER(LEN=256)       :: initial_selen_eas_filename
        CHARACTER(LEN=256)       :: initial_selen_grl_filename
        CHARACTER(LEN=256)       :: initial_selen_ant_filename

        CHARACTER(LEN=256)       :: climate_fields_ant_filename
        CHARACTER(LEN=256)       :: climate_fields_grl_filename
        CHARACTER(LEN=256)       :: climate_fields_eas_filename
        CHARACTER(LEN=256)       :: climate_fields_nam_filename
        
        CHARACTER(LEN=256)       :: ocean_temp_ant_filename

        ! Schematic filenames
        CHARACTER(LEN=256)       :: restart_sch_filename
        CHARACTER(LEN=256)       :: restart_sch2_filename

        CHARACTER(LEN=256)       :: recording_sch_filename
        CHARACTER(LEN=256)       :: recording_sch2_filename

        CHARACTER(LEN=256)       :: help_fields_sch_filename

        CHARACTER(LEN=256)       :: initial_sch_filename
        CHARACTER(LEN=256)       :: initial_sch2_filename
        CHARACTER(LEN=256)       :: extra_fields_sch_filename
        CHARACTER(LEN=256)       :: extra_fields_sch2_filename

!added by DoE (25/04/2017)
        CHARACTER(LEN=256)       :: viscosity_ant_filename
!added by DoE (22/06/2017)
        CHARACTER(LEN=256)       :: geoid_ant_filename
        CHARACTER(LEN=256)       :: pippa_rt_filename
        CHARACTER(LEN=256)       :: ant_mask_filename



                                ! FILE NAMES for ascii output:
                                !============
        CHARACTER(LEN=256)       :: main_standard_filename
        CHARACTER(LEN=256)       :: main_isotope_filename
        CHARACTER(LEN=256)       :: main_selen_filename

        INTEGER                  :: recnr_to_start_from_restart
        LOGICAL                  :: enable_restart_file
        LOGICAL                  :: enable_recording_file
        LOGICAL                  :: enable_help_fields_file
        
        INTEGER                  :: which_help_fields
        INTEGER                  :: which_recording_fields

        CHARACTER(LEN=256)       :: output_dir       ! Name of directory to which the output is written
        CHARACTER(LEN=256)       :: selen_dir        ! Name of the directory for selen input data
        
                                ! INPUT/OUTPUT MESSAGES
                                !======================
        INTEGER                  :: stderr           ! unit to which errors should be written.
        INTEGER                  :: stdlog           ! unit to which log messages should be written.
        LOGICAL                  :: choice_write_message
        
                                ! PLOTTING UNITS OF RECORDED VARIABLES:
                                !======================================
        REAL(dp)                 :: plot_unit_total_ice_volume
        REAL(dp)                 :: plot_unit_total_ice_area
        REAL(dp)                 :: plot_unit_total_MB_surface
        
                                ! MINIMUM ICE THICKNESS AND MAXIMUM CHANGE PER TIME STEP
                                !=======================================================
        REAL(dp)                 :: Hi_min                       ! Minimal ice_thickness (it cannot be zero because of the scaled coordinate zeta)
        REAL(dp)                 :: maximum_dHi_change_per_year  ! Maximum change per yrear, in an attempt to get a stable behavior, e.g. at the
                                                                 ! start of a run. This intervention should disappear after a few hundred of time steps.                                                                                   !!
        
                                ! Forcing
                                !===============================
        INTEGER                  :: choice_forcing 

        INTEGER                  :: relative_slev_temp_forcing
        INTEGER                  :: constant_d18O_forcing        
        INTEGER                  :: d18O_forcing
        INTEGER                  :: climate_model_forcing
        
        REAL(dp)                 :: constant_forcing_sealevel 
        REAL(dp)                 :: constant_forcing_gT_offset
        REAL(dp)                 :: constant_forcing_d18O

                                ! Insolation forcing (used in Mass Balance for ablation), added BdB (10/2009)
                                !===============================
        INTEGER                  :: choice_insolation
        INTEGER                  :: presentday_insolation
        INTEGER                  :: varying_insolation
      
                                ! SLIDING
                                ! =======
        REAL(dp)                 :: melt_range                   ! In Kelvin
        LOGICAL                  :: include_sliding_heatflux
        LOGICAL                  :: always_sliding
        
        REAL(dp)                 :: m_enh_sia
        REAL(dp)                 :: m_enh_ssa
        
        REAL(dp)                 :: pf1
        REAL(dp)                 :: pf2
        REAL(dp)                 :: p_min
        REAL(dp)                 :: p_max

        REAL(dp)                 :: wat_level_min
        REAL(dp)                 :: wat_level_max

        INTEGER                  :: max_iter_gauss_seidel
        REAL(dp)                 :: gauss_seidel_relaxation
        REAL(dp)                 :: residual_epsilon

        REAL(dp)                 :: d_uv_3d_cutoff

        LOGICAL                  :: use_grounding_line_param
        INTEGER                  :: interpol_grline_power
        INTEGER                  :: interpol_grline_nmax

                                ! Mass Balance (added westerly slope: Bdb 10/2009)
                                !===============================
        INTEGER                  :: choice_MB_surface_model
        REAL(dp)                 :: calve_thickness 

        REAL(dp)                 :: C_abl_constant             ! Constant in the ablation parameterisation
        REAL(dp)                 :: C_abl_grl_constant         ! Constant in the ablation parameterisation for Greenland
        REAL(dp)                 :: C_abl_nh_constant          ! Constant in the ablation parameterisation for NH ice sheet, EuIS and NaIS
        REAL(dp)                 :: C_abl_Ts                   ! Temperature dependence of surface ablation
        REAL(dp)                 :: C_abl_Q                    ! Transmissivity of atmosphere for net Solar insolation 
        REAL(dp)                 :: C_abl_grl_Q                ! Transmissivity of atmosphere for net Solar insolation over greenland
        
        LOGICAL                  :: use_sw_down_flux_at_surface ! to use the SW downward flux (after reflection/absorption by the atmosphere) at the surface from the climate

        LOGICAL                  :: use_melt_daily_cycle       ! use daily cycle of temperature and solar insolation to determine surface melt
        INTEGER                  :: N_day_int                  ! number of hours per day, default is 1 (so no interval), could also be 2,3,6,12,24,48..

                                ! TEMPERATURE
                                ! ===========
        INTEGER                  :: choice_temperature_model
        REAL(dp)                 :: dTi_below_T_pmp 
        REAL(dp)                 :: Ti_fixed
        REAL(dp)                 :: subshelf_melt_factor
        LOGICAL                  :: do_temperature_spin_up      ! For GrIS and/or AIS spin up thermodynamics with constant Hi
        
        LOGICAL                  :: use_3D_ocean_temperature    ! for including 3D ocean temperatures from a climate model
        INTEGER                  :: number_of_ocean_layers      ! the number of layers in the ocean model
        
        LOGICAL                  :: use_lgm_winds_scaling       ! for scaling with LGM winds over NH ice sheets
        
        
                                
                                ! CROSS SECTION
                                ! ===============================
        INTEGER                  :: x_fixed
        INTEGER                  :: y_fixed
        REAL(dp)                 :: glacier_altitude_shift   
        REAL(dp), DIMENSION(4)   :: fake_value_for_bedrock   
        REAL(dp), DIMENSION(4)   :: fake_value_for_atmosphere
        REAL(dp), DIMENSION(4)   :: fake_value_for_ocean

                                ! MATHEMATICAL CONSTANTS
                                !===============================
        REAL(dp)                 :: pi
        REAL(dp)                 :: deg2rad             ! Conversion factor between radians and degrees
        REAL(dp)                 :: rad2deg             ! Conversion factor between degrees and radians
        REAL(dp)                 :: sec_per_year        ! seconds per year

                                ! ADDITIONAL VARIABLES WHICH CAN BE USED FOR TESTING AND DEBUGGING
                                !=================================================================
        INTEGER                  :: testing_integer     ! For temporary testing with a integer, avoiding compiling between
        REAL(dp)                 :: testing_real_dp     ! For temporary testing with a real(dp), avoiding compiling between

                                ! TIME ADJUSTMENT
                                ! ====================
        LOGICAL                  :: dynamic_time_step_adaption   ! for adjusting the time step (separate per model)
        REAL(dp)                 :: dt_max
        REAL(dp)                 :: time_step_scaling

                                ! PHYSICAL PARAMETERS
                                ! ===================
        REAL(dp)                 :: geothermal_heat_flux

                               ! SCHEMATIC EXPERIMENT
                                ! ===========
        REAL(dp)                 :: basal_shelf_melt
        REAL(dp)                 :: constant_SMB_schematic
        REAL(dp)                 :: A_flow_schematic
        REAL(dp)                 :: max_ice_thickness_nh

      END TYPE constants_type
      
      ! C is the 'struct' containing all the Constants from the CONFIG file and/or the defaults
      TYPE(constants_type), SAVE :: C



CONTAINS
  SUBROUTINE read_main_config_file()
    ! This subroutine reads some of the variables defined in the grid subroutine
    ! from a configuration file. The name of the configuration file should be specified
    ! on the command line. If no name is specified on the command line, then the default
    ! values are used.
    IMPLICIT NONE
    
    ! Local variables:
    CHARACTER(LEN=256) :: config_filename
    INTEGER, PARAMETER :: config_unit = 28 ! Unit number which is used for the configuration file.
    INTEGER            :: ios
    INTEGER            :: iargc

     ! List of items in the configuration file:
     NAMELIST /CONFIG/NX_eas_config                             , &
                      NY_eas_config                             , &
                      NX_nam_config                             , &
                      NY_nam_config                             , &
                      NX_ant_config                             , &
                      NY_ant_config                             , &
                      NX_grl_config                             , &
                      NY_grl_config                             , &
                      NZ_config                                 , &
                      zeta_config                               , &
                      dx_eas_config                             , &
                      dy_eas_config                             , &
                      dx_nam_config                             , &
                      dy_nam_config                             , &
                      dx_ant_config                             , &
                      dy_ant_config                             , &
                      dx_grl_config                             , &
                      dy_grl_config                             , &
                      NZL_config                                , &
                      z_step_config                             , &
                      start_time_of_run_config                  , &
                      end_time_of_run_config                    , &
                      start_time_climate_record_config          , &
                      size_climate_record_config                , &
                      time_step_multiplier_config               , &
                      dt_config                                 , &
                      dt_thermo_config                          , &
                      dt_shelf_velocity_config                  , &
                      dt_bedrock_config                         , &
                      dt_restart_config                         , &
                      dt_recording_config                       , &
                      dt_climate_record_config                  , &
                      starting_recordnr_config                  , &
                      filename_extension_config                 , &
                      climate_fields_length_config              , &
                      forcing_filename_config                   , &
                      insolation_filename_config                , &
                      initial_ant_filename_config               , &
                      initial_grl_filename_config               , &
                      initial_eas_filename_config               , &
                      initial_nam_filename_config               , &
                      monthly_ant_filename_config               , &
                      monthly_grl_filename_config               , &
                      monthly_eas_filename_config               , &
                      monthly_nam_filename_config               , &
                      extra_fields_ant_filename_config          , &
                      extra_fields_grl_filename_config          , &
                      extra_fields_eas_filename_config          , &
                      extra_fields_nam_filename_config          , &
                      wind_fields_nam_filename_config           , &
                      pixels_with_anice_filename_config         , &
                      topo_anice_res60_filename_config          , &
                      restart_selen_ice_filename_config         , &
                      restart_selen_mems_filename_config        , &
                      initial_selen_ice_filename_config         , &
                      initial_selen_mems_filename_config        , &
                      restart_selen_nam_filename_config         , &
                      restart_selen_eas_filename_config         , &
                      restart_selen_grl_filename_config         , &
                      restart_selen_ant_filename_config         , &
                      initial_selen_nam_filename_config         , &
                      initial_selen_eas_filename_config         , &
                      initial_selen_grl_filename_config         , &
                      initial_selen_ant_filename_config         , &
                      climate_fields_ant_filename_config        , &
                      climate_fields_grl_filename_config        , &
                      climate_fields_eas_filename_config        , &
                      climate_fields_nam_filename_config        , &
                      ocean_temp_ant_filename_config            , &
                      initial_sch_filename_config               , &
                      initial_sch2_filename_config              , &
                      extra_fields_sch_filename_config          , &
                      extra_fields_sch2_filename_config         , &
                      which_icesheets_config                    , &
                      PD_benthic_isotope_config                 , &
                      tuner_one_config                          , &
                      averaging_time_climate_config             , &
                      averaging_time_deepwater_config           , &
                      scale_dw_config                           , &
                      paleo_reference_noice_config              , &
                      Hi_min_config                             , &
                      maximum_dHi_change_per_year_config        , &
                      enable_restart_file_config                , &
                      use_geoid_forcing_config                  , &
                      use_pippa_model_config                    , &
                      enable_help_fields_file_config            , &
                      enable_recording_file_config              , &
                      which_help_fields_config                  , &
                      which_recording_fields_config             , &
                      selen_dir_config                          , &
                      output_dir_config                         , &
                      choice_forcing_config                     , &
                      constant_forcing_sealevel_config          , &
                      constant_forcing_gT_offset_config         , &
                      constant_forcing_d18O_config              , &
                      choice_insolation_config                  , &
                      monotonic_geothermal_heat_flux_config     , &
                      x_fixed_config                            , &
                      y_fixed_config                            , &
                      glacier_altitude_shift_config             , &
                      fake_value_for_bedrock_config             , &
                      fake_value_for_atmosphere_config          , &
                      fake_value_for_ocean_config               , &
                      plot_unit_total_ice_volume_config         , &
                      plot_unit_total_ice_area_config           , &
                      plot_unit_total_MB_surface_config         , &
                      melt_range_config                         , &
                      include_sliding_heatflux_config           , &
                      always_sliding_config                     , &
                      pf1_config                                , &
                      pf2_config                                , &
                      p_min_config                              , &
                      p_max_config                              , &
                      wat_level_min_config                      , &
                      wat_level_max_config                      , &
                      max_iter_gauss_seidel_config              , &
                      gauss_seidel_relaxation_config            , &
                      residual_epsilon_config                   , &
                      d_uv_3d_cutoff_config                     , &
                      use_grounding_line_param_config           , &
                      interpol_grline_power_config              , &
                      m_enh_sia_config                          , &
                      m_enh_ssa_config                          , &
                      calve_thickness_config                    , &
                      choice_MB_surface_model_config            , &
                      C_abl_constant_config                     , &
                      C_abl_grl_constant_config                 , &
                      C_abl_nh_constant_config                  , &
                      C_abl_Ts_config                           , &
                      C_abl_Q_config                            , &
                      C_abl_grl_Q_config                        , &
                      use_sw_down_flux_at_surface_config        , &
                      use_melt_daily_cycle_config               , &
                      N_day_int_config                          , &
                      dTi_below_T_pmp_config                    , &
                      Ti_fixed_config                           , &
                      subshelf_melt_factor_config               , &
                      do_temperature_spin_up_config             , &
                      use_3D_ocean_temperature_config           , &
                      number_of_ocean_layers_config             , &
                      use_lgm_winds_scaling_config              , &
                      choice_temperature_model_config           , &
                      choice_write_message_config               , &
                      testing_integer_config                    , &
                      testing_real_dp_config                    , &
                      dynamic_time_step_adaption_config         , &
                      dt_max_config                             , &
                      time_step_scaling_config                  , &
                      use_selen_config                          , &
                      init_selen_config                         , &
                      use_selen_with_eustatic_config            , &
                      use_anice_with_eustatic_config            , &
                      choice_selen_interpolate_config           , &
                      end_tdof_iteration_config                 , &
                      selen_max_iteration_config                , &
                      time_window_length_config                 , &
                      time_window_steps_config                  , &
                      use_rotational_feedback_config            , &
                      restart_model_config                      , &
                      skip_last_sle_iter_config                 , &
                      earth_lithosphere_thick_config            , &
                      earth_number_of_layers_config             , &
                      earth_viscosity_profile_config            , &
                      geothermal_heat_flux_config               , &
                      basal_shelf_melt_config                   , &
                      constant_SMB_schematic_config             , &
                      A_flow_schematic_config                   , &
                      max_ice_thickness_nh_config               , &
                      viscosity_ant_filename_config             , &
                      geoid_ant_filename_config                 , &
                      pippa_rt_filename_config                  , &
                      ant_mask_filename_config
!added by DoE visc;25/04/2017, geoid;22/06/2017

    SELECT CASE(iargc())
    CASE(0)
     ! Don't read the configuration file in this case, just use the default values.
    CASE(1)
     ! Get the name of the configuration file, open this file and read it:
     CALL getarg(1, config_filename)
     OPEN(UNIT=config_unit, FILE=TRIM(config_filename), STATUS='OLD', ACTION='READ', IOSTAT=ios)
     IF(ios /= 0) THEN
      WRITE(UNIT=*, FMT='(/3A/)') coloring(' ERROR:', 'red'), ' Could not open the configuration file: ', TRIM(config_filename)
      STOP
     END IF

     ! In the following statement the entire configuration file is read, using the namelist (NML=CONFIG)
     READ(UNIT=config_unit, NML=CONFIG, IOSTAT=ios)
     CLOSE(UNIT=config_unit)

     ! Writing the log of all (initialized) config variables:
     OPEN( UNIT=10072014, FILE='log-config-variable-list.txt')
     WRITE(UNIT=10072014, NML=CONFIG)
     CLOSE(UNIT=10072014)

     IF(ios /= 0) THEN
      WRITE(UNIT=*, FMT='(/3A)') coloring(' ERROR:', 'red'), ' while reading configuration file: ', TRIM(config_filename)
      CALL checking_the_config_variable_names(config_filename, 'log-config-variable-list.txt')
      WRITE(UNIT=*, FMT='(A)') ''
      STOP
     END IF
    CASE DEFAULT
     WRITE(UNIT=*, FMT='(/2A/)') coloring(' ERROR:', 'red'), ' Too many command line arguments!'
     STOP
    END SELECT
  END SUBROUTINE read_main_config_file


  SUBROUTINE checking_the_config_variable_names(config_filename, namelist_filename)
    ! This routine reads one by one the config variable names from the config file and compares
    ! them with the CONFIG NAMELIST. In case a config variable name is not present in the
    ! NAMELIST list this config variable name will be messaged and the program will be stopped.
    ! A few other syntax errors are detected and messaged as well. However, not all errors are
    ! fully explained, like e.g. a wrong array index of a config variable or syntax errors at
    ! the right side of the '=' sign.
    IMPLICIT NONE

    CHARACTER(LEN=*), INTENT(IN) :: config_filename      ! The name of the config file which is given as an argument to the program
    CHARACTER(LEN=*), INTENT(IN) :: namelist_filename    ! The name of the file which contains the printed NAMELIST variables

    ! Local variables:
    CHARACTER(256) :: text_per_line
    INTEGER        :: line_counter
    CHARACTER(256) :: config_variable_name               ! The name of the config variable in the config file which is given as an argument to the program
    CHARACTER(256) :: namelist_variable_name             ! The name of the namelist varibale in the file which contains the printed NAMELIST variables
    INTEGER        :: status
    LOGICAL        :: config_variable_has_been_found
    INTEGER        :: string_index_1
    INTEGER        :: string_index_2
    INTEGER        :: string_index_3

    ! Opening the config file:
    OPEN(UNIT=1188, FILE=config_filename)

    line_counter = 1
    DO
     READ(UNIT=1188, FMT='(A)', IOSTAT=status) text_per_line
     IF (status < 0) exit
     ! Copying the first string of each text line (thus the name of namelist variable), the left part of the string is selected until a '(', 'space' or an 'equal sign' is encountered:
     config_variable_name = capitalize_string(text_per_line(1:SCAN(text_per_line, '( =')-1))

     IF(config_variable_name == '/') THEN
      ! No message for the part of the config file which is not considered
      exit
     ELSE IF(config_variable_name == '' .OR. config_variable_name == '&CONFIG' .OR. config_variable_name(1:1) == '!') THEN
      ! Deselect all lines without config variables.
      ! WRITE(UNIT=*, FMT='(2A)') ' deselected line: ', TRIM(config_variable_name)
     ELSE
        ! Scanning until a ')', 'space' or an 'equal sign' is encountered:
        string_index_1 = SCAN(text_per_line(2:), ') =') + 1

        ! Messaging about other invalid config syntax:
        string_index_2 = SCAN(text_per_line(string_index_1+1:), '=') + string_index_1
        string_index_3 = LEN(TRIM(text_per_line(string_index_1+1:string_index_2-1))) + string_index_1
        IF((text_per_line(string_index_3:string_index_3) /= ' ' .AND. string_index_1 /= string_index_3) .OR. &
           (SCAN(text_per_line(string_index_2 + 1:), '=') > 0) .OR. (SCAN(text_per_line(string_index_1 + 1:), '=') == 0)) THEN
         WRITE(UNIT=*, FMT='(A, I5, 4A)') ' The invalid config syntax at line ', line_counter, ' is: "', TRIM(coloring(text_per_line(string_index_1+1:string_index_3), 'red')), '", the whole line is cited below: '
         WRITE(UNIT=*, FMT='(2A)') ' ', TRIM(coloring(TRIM(text_per_line), 'red'))
        END IF

        ! Opening the config file:
        OPEN(UNIT=1088, FILE=namelist_filename)

        config_variable_has_been_found = .FALSE.
        DO
         READ(UNIT=1088, FMT='(A)', IOSTAT=status) text_per_line
         IF (status < 0) exit
         ! Copy left part of the string (thus the name of namelist variable), the left part of the string is selected until a 'space' or an 'equal sign' is encountered:
         namelist_variable_name = text_per_line(2:SCAN(text_per_line(2:), ' ='))
         IF(namelist_variable_name == '' .OR. namelist_variable_name == 'CONFIG' .OR. namelist_variable_name == '/' .OR. namelist_variable_name(1:1) == '!') THEN
          ! Deselect all lines without namelist variables.
          ! WRITE(UNIT=*, FMT='(2A)') ' deselected line: ', TRIM(namelist_variable_name)
         ELSE IF(namelist_variable_name == config_variable_name) THEN
          config_variable_has_been_found = .TRUE.
          exit
         ELSE
         END IF
        END DO
        IF(.NOT. config_variable_has_been_found) THEN
         WRITE(UNIT=*, FMT='(3A, I5, A)') ' The variable:  ', TRIM(coloring(TRIM(config_variable_name), 'red')), '  at line ', line_counter, ' is not a valid config variable.'
        END IF

        ! Closing the config file:
        CLOSE(UNIT=1088)

     END IF
     line_counter = line_counter + 1
    END DO

    ! Closing the config file:
    CLOSE(UNIT=1188)
  END SUBROUTINE checking_the_config_variable_names

  PURE FUNCTION capitalize_string(string_with_lower_cases) RESULT (string_with_upper_cases)
    ! Changes a string which contains lower case letters to a string with upper case letters
    IMPLICIT NONE

    ! Input variables:
    CHARACTER(LEN=*)                       , INTENT(IN) :: string_with_lower_cases

    ! Result variables:
    CHARACTER(LEN(string_with_lower_cases))             :: string_with_upper_cases

    ! Local variables:
    INTEGER                                             :: i
    INTEGER                                             :: index_cap

    CHARACTER(26), PARAMETER                            :: cap = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
    CHARACTER(26), PARAMETER                            :: low = 'abcdefghijklmnopqrstuvwxyz'

    ! Capitalize each letter if it is lowecase
    string_with_upper_cases = string_with_lower_cases
    DO i = 1, LEN_TRIM(string_with_lower_cases)
     index_cap = INDEX(low, string_with_lower_cases(i:i))
    IF(index_cap > 0) string_with_upper_cases(i:i) = cap(index_cap:index_cap)
    END DO
  END FUNCTION capitalize_string



  FUNCTION coloring(string, color_choice) RESULT(color_string)
    ! This function will create a red color on terminal output for the string argument.
    IMPLICIT NONE

    ! Input variables:
    CHARACTER(LEN=*), INTENT(IN)           :: string
    CHARACTER(LEN=*), INTENT(IN), OPTIONAL :: color_choice

    ! Result variables:
    CHARACTER(LEN=:), ALLOCATABLE          :: color_string

    ALLOCATE(CHARACTER(LEN(string)+9)      :: color_string)       ! The +9 is just enough to store the color characters

!    IF(C%enable_color_messaging_in_terminal) THEN
     ! The 91m gives red, 0m sets the default back [Available colors: 90:gray, 91:red, 92:green, 93:yellow, 94:blue, 95:pink, 96:light blue]
     IF(PRESENT(color_choice)) THEN
      SELECT CASE(color_choice)
      CASE('default')
       DEALLOCATE(color_string)
       ALLOCATE(CHARACTER(LEN(string)) :: color_string)
       color_string = string
      CASE('gray')
       color_string = achar(27)//'[90m'//string//achar(27)//'[0m'
      CASE('red')
       color_string = achar(27)//'[91m'//string//achar(27)//'[0m'
      CASE('green')
       color_string = achar(27)//'[92m'//string//achar(27)//'[0m'
      CASE('yellow')
       color_string = achar(27)//'[93m'//string//achar(27)//'[0m'
      CASE('blue')
       color_string = achar(27)//'[94m'//string//achar(27)//'[0m'
      CASE('pink')
       color_string = achar(27)//'[95m'//string//achar(27)//'[0m'
      CASE('light blue')
       color_string = achar(27)//'[96m'//string//achar(27)//'[0m'
      CASE DEFAULT
       WRITE(UNIT=*, FMT='(3A)') ' The function "coloring" needs one of the following keywords: "default", "gray", "red", ', &
                                 ' "green", "yellow", "blue", "pink", "light blue" instead of: ', TRIM(color_choice)
       STOP
      END SELECT
     ELSE
      color_string = achar(27)//'[91m'//string//achar(27)//'[0m'
     END IF

!    ELSE
!     DEALLOCATE(color_string)
!     ALLOCATE(CHARACTER(LEN(string)) :: color_string)
!     color_string = string
!    END IF
  END FUNCTION coloring



  SUBROUTINE initialize_main_constants()
    ! This routine puts all the constants which will never change during the run after the CONFIG file
    ! has been read, into a special constant 'struct' 
    IMPLICIT NONE

    ! Number of grid points in vertical direction for thermodynamics in ice sheet, if k is a counter
    ! through the vertical layers, k=1 at the surface and k=NZ at the bottom of the ice sheet:
    C%NZ     = NZ_config
    ALLOCATE(C%zeta(C%NZ))                 
    C%zeta   = zeta_config(1:C%NZ) ! Fortran does not allow a CONFIG/NAMELIST variable to be ALLOCATABLE, therefore this way

    ! Number of grid points in the linear vertical direction and the grid spacing:
    C%NX_eas = NX_eas_config
    C%NY_eas = NY_eas_config
    C%NX_nam = NX_nam_config
    C%NY_nam = NY_nam_config
    C%NX_ant = NX_ant_config
    C%NY_ant = NY_ant_config
    C%NX_grl = NX_grl_config
    C%NY_grl = NY_grl_config

    ! grid distance for each ice sheet
    C%dx_eas = dx_eas_config
    C%dy_eas = dy_eas_config
    C%dx_nam = dx_nam_config
    C%dy_nam = dy_nam_config
    C%dx_ant = dx_ant_config
    C%dy_ant = dy_ant_config
    C%dx_grl = dx_grl_config
    C%dy_grl = dy_grl_config

    C%NZL    = NZL_config
    C%z_step = z_step_config 

    ! Parameters for inverse routine
    C%PD_benthic_isotope       = PD_benthic_isotope_config
    C%tuner_one                = tuner_one_config
    C%averaging_time_climate   = averaging_time_climate_config
    C%averaging_time_deepwater = averaging_time_deepwater_config
    C%scale_dw                 = scale_dw_config

    ! Choose which ice-sheets to use in the model: or it is a character*4, with each value the ice sheet: T(rue) or F(alse)
    ! 1 - all ice sheets: NAM+EAS+GRL+ANT       - TTTT
    ! 2 - only NAM+EAS ice sheets (BW08 set up) - TTFF
    ! 3 - pre NH run, only including GRL+ANT    - FFTT
    ! 4 - only the NaIS    - TFFF
    ! 5 - only the EuIS    - FTFF
    ! 6 - only the GrIS    - FFTF
    ! 7 - only the AIS     - FFFT
    C%which_icesheets      = which_icesheets_config
    
    ! Set to TRUE if the run reference is no ice:
    C%paleo_reference_noice = paleo_reference_noice_config
    
    ! With this variable all time steps (below) can be multiplied, which makes different dt experiments easy:
    C%time_step_multiplier  = time_step_multiplier_config
    
    C%start_time_of_run  = start_time_of_run_config                          ! Start time of run; see the CONFIG file or the default
    C%end_time_of_run    = end_time_of_run_config                            ! End time of run; see the CONFIG file or the default
    C%dt                 = dt_config                * C%time_step_multiplier ! Time step (in years) of run; see the CONFIG file or the default
    C%dt_thermo          = dt_thermo_config         * C%time_step_multiplier ! Time step (in years) used for the thermodynamics        
    C%dt_shelf_velocity  = dt_shelf_velocity_config * C%time_step_multiplier ! Time step (in years) used for the shelf velocity       
    C%dt_bedrock         = dt_bedrock_config        * C%time_step_multiplier ! Time step (in years) for bedrock adjustment        
    C%dt_restart         = dt_restart_config        * C%time_step_multiplier ! Time step (in years) for writing restart files   
    C%dt_recording       = dt_recording_config      * C%time_step_multiplier ! Time step (in years) for writing recording files       

    C%starting_recordnr = starting_recordnr_config                          ! The number of the netcdf record which is used as the start record; see the CONFIG file or the default


    ! Total length of climate records (i.e. number of times on which climate
    ! records (sealevel and surface temperature are available):
    C%size_climate_record = size_climate_record_config
    
    ! Time of first climate record:
    C%start_time_climate_record = start_time_climate_record_config
    
    ! Time step between time climate records in years:
    C%dt_climate_record = dt_climate_record_config
    

    ! The minimum ice thickness, preventing zero deviding with the scaled coordinate
    C%Hi_min = Hi_min_config
    ! Maximum addaption per time step, in an attempt to get a stable behavior, e.g. at the start of a run. This intervention should disappear after a few hundred of time steps.                                                                                   !!
    C%maximum_dHi_change_per_year = maximum_dHi_change_per_year_config

    C%monotonic_geothermal_heat_flux  =  monotonic_geothermal_heat_flux_config
    IF(      C%monotonic_geothermal_heat_flux) WRITE (0,'(A)') 'Using a constant Heatflux: Fghf'
    IF(.NOT. C%monotonic_geothermal_heat_flux) WRITE (0,'(A)') 'Using a Heatflux field from input'

    ! The surface mass balance can be handled in several ways:
    ! 10 --> Mass balance parametrisation as used in BW08 (Bintanja and Van der Wal 2005/2008), added BdB 10/2009
    !       Added westerly slope choice for Bintanja Mass Balance (BdB 10/2009)
    
    C%choice_MB_surface_model  = choice_MB_surface_model_config
    C%calve_thickness          = calve_thickness_config
 
    C%C_abl_constant           = C_abl_constant_config
    C%C_abl_grl_constant       = C_abl_grl_constant_config
    C%C_abl_nh_constant        = C_abl_nh_constant_config
    C%C_abl_Ts                 = C_abl_Ts_config
    C%C_abl_Q                  = C_abl_Q_config
    C%C_abl_grl_Q              = C_abl_grl_Q_config

    C%use_sw_down_flux_at_surface = use_sw_down_flux_at_surface_config

    C%use_melt_daily_cycle     = use_melt_daily_cycle_config
    C%N_day_int                = N_day_int_config
    ! If no daily cycle is used, N_day_int should be 1
    IF(.NOT. C%use_melt_daily_cycle) C%N_day_int = 1
   
    C%choice_temperature_model = choice_temperature_model_config
    C%dTi_below_T_pmp          = dTi_below_T_pmp_config
    C%Ti_fixed                 = Ti_fixed_config
    C%subshelf_melt_factor     = subshelf_melt_factor_config
    C%do_temperature_spin_up   = do_temperature_spin_up_config
    C%use_3D_ocean_temperature = use_3D_ocean_temperature_config
    C%number_of_ocean_layers   = number_of_ocean_layers_config
    
    C%use_lgm_winds_scaling    = use_lgm_winds_scaling_config

    ! BdB 03/2012: Choice for using the SELEN sea level equation model 
    !              to solve bedrock change (with TABOO) and the sea-level geoid
    C%use_selen                = use_selen_config                  ! use SELEN or not
    C%init_selen               = init_selen_config                 ! create initial files for SELEN (Only initialize!!)
    C%use_selen_with_eustatic  = use_selen_with_eustatic_config    ! use SELEN but with eustatic sea level instead of RSL
    C%use_anice_with_eustatic  = use_anice_with_eustatic_config    ! use SELEN but with eustatic sea level in ANICE

    C%choice_selen_interpolate = choice_selen_interpolate_config   ! choose the method of interpolation, linear or spline
    C%end_tdof_iteration       = end_tdof_iteration_config         ! maximum number of iteration for the tdof
    C%selen_max_iteration      = selen_max_iteration_config        ! maximum number of iteration of the SLE
    C%use_rotational_feedback  = use_rotational_feedback_config    ! Include rotation feedback in sle calculation

    ! Lenght of moving time window and time increments
    C%time_window_length       = time_window_length_config
    ! time increment in kyrs for the Green's function   
    ALLOCATE(C%time_window_steps(C%time_window_length))                 
    C%time_window_steps        = time_window_steps_config(1:C%time_window_length)

    ! time increment between CALL to selen and CALL to ANICE models    
    C%steps_per_selen = INT(C%dt_bedrock) / INT(C%dt_climate_record)

    ! If restart is required for SELEN and/or ANICE
    C%restart_model            = restart_model_config              ! read in restart files for SELEN and ANICE of previous segment of run
    C%skip_last_sle_iter       = skip_last_sle_iter_config         ! When a restart is needed skip the last iternation of the SLE
    
    ! Setting of Earth Rheology in TABOO
    C%earth_lithosphere_thick  = earth_lithosphere_thick_config    ! Thickness of the Lithosphere (km)
    C%earth_number_of_layers   = earth_number_of_layers_config     ! Number of viscous Earth layers
    ! Viscocity of the Earth layers
    ALLOCATE(C%earth_viscosity_profile(C%earth_number_of_layers))                 
    C%earth_viscosity_profile     = earth_viscosity_profile_config(1:C%earth_number_of_layers)

    ! We use a mask array to store the type of land in each grid point. The following types of land are allowed:
    C%type_sheet      = 1 
    C%type_groundline = 2!2
    C%type_shelf      = 3!3
    C%type_calveline  = 4!4
    C%type_ocean      = 5!5
    C%type_outofbound = 6!6   
    
    ! The forcing per year with the sealevel difference and the temperature difference can be choosen: 
    ! A constant forcing means a constant benthic d18O value (option 1), default = 2, with a varying 
    ! benthic d18O record. For a consant sealevel or temperature, use this as a data record and choose 
    ! option 3.
    
    C%choice_forcing = choice_forcing_config
    C%constant_d18O_forcing      = 1
    C%d18O_forcing               = 2
    C%relative_slev_temp_forcing = 3
    C%climate_model_forcing      = 4

    C%constant_forcing_sealevel  = constant_forcing_sealevel_config 
    C%constant_forcing_gT_offset = constant_forcing_gT_offset_config
    C%constant_forcing_d18O      = constant_forcing_d18O_config     

    ! added BdB (10/2009) insolation forcing, 1 for varying, 2 for presentday insolation
    C%choice_insolation      = choice_insolation_config
    C%presentday_insolation  = 1
    C%varying_insolation     = 2
    
    ! Sliding choices:
    C%melt_range               = melt_range_config                 ! In Kelvin (e.g.: 1._dp)
    C%include_sliding_heatflux = include_sliding_heatflux_config
    C%always_sliding           = always_sliding_config
    
    C%m_enh_sia                = m_enh_sia_config
    C%m_enh_ssa                = m_enh_ssa_config
    
    C%pf1                      = pf1_config
    C%pf2                      = pf2_config
    C%p_min                    = p_min_config
    C%p_max                    = p_max_config

    C%wat_level_min             = wat_level_min_config
    C%wat_level_max             = wat_level_max_config

    C%max_iter_gauss_seidel    = max_iter_gauss_seidel_config
    C%gauss_seidel_relaxation  = gauss_seidel_relaxation_config
    C%residual_epsilon         = residual_epsilon_config

    C%d_uv_3d_cutoff           = d_uv_3d_cutoff_config

    C%use_grounding_line_param = use_grounding_line_param_config        ! Using the grounding line interpolation scheme, True or False
    C%interpol_grline_power    = interpol_grline_power_config           ! the power of the interpolation with the trapezoidal rule
    C%interpol_grline_nmax     = 2**(interpol_grline_power_config-1)    ! default is 2**(6-1) = 32
   
    ! The fixed i, j values for which two vertical temperature cross sections are made.
    C%x_fixed                   = x_fixed_config
    C%y_fixed                   = y_fixed_config
    C%glacier_altitude_shift    = glacier_altitude_shift_config   
    C%fake_value_for_bedrock    = fake_value_for_bedrock_config   
    C%fake_value_for_atmosphere = fake_value_for_atmosphere_config
    C%fake_value_for_ocean      = fake_value_for_ocean_config

    C%pi                  = 2._dp*ACOS(0._dp)                ! Just pi=3.14159... exactly
    C%deg2rad             = C%pi/180._dp                     ! Conversion factor between radians and degrees
    C%rad2deg             = 180._dp/C%pi                     ! Conversion factor between degrees and radians
    C%sec_per_year        = 31556943.36_dp                   ! = 365.2424 * 24 * 3600

    ! Testing variables. These variables should only be used for testing and debugging new fetaures of the anice program:
    C%testing_integer = testing_integer_config               ! For temporary testing with a integer, avoiding compiling between
    C%testing_real_dp = testing_real_dp_config               ! For temporary testing with a real(dp), avoiding compiling between

    ! adjusting the time step
    C%dynamic_time_step_adaption = dynamic_time_step_adaption_config
    C%dt_max                     = dt_max_config
    C%time_step_scaling          = time_step_scaling_config

    ! Name of output directory:
    C%output_dir = output_dir_config

    ! Name of selen directory:
    C%selen_dir = selen_dir_config
    
    ! Filename extension
    C%filename_extension = filename_extension_config
    
    ! Lenght of input cliamte fields, total time step (should be multiple of 12)
    C%climate_fields_length = climate_fields_length_config
    
    ! Check if the forcing file name is coherent with choice_forcing:
    IF(forcing_filename_config(1:4) == 'BW08' .AND. C%choice_forcing == 2) THEN
     WRITE(0,'(2A)') 'In configuration_main_module: choice_forcing does NOT agree with the forcing file: ', forcing_filename_config
     STOP
    ELSE IF(forcing_filename_config(1:4) == 'LR04' .AND. C%choice_forcing == 3) THEN
     WRITE(0,'(2A)') 'In configuration_main_module: choice_forcing does NOT agree with the forcing file: ', forcing_filename_config
     STOP
    END IF

    ! File names:
    C%forcing_filename          = TRIM(forcing_filename_config)
    C%insolation_filename       = TRIM(insolation_filename_config)
    
    ! File names of ice-sheet netcdf output:
    C%restart_ant_filename      = TRIM(C%output_dir)//'/restart_ant'//TRIM(C%filename_extension)//'.nc'
    C%restart_grl_filename      = TRIM(C%output_dir)//'/restart_grl'//TRIM(C%filename_extension)//'.nc'
    C%restart_eas_filename      = TRIM(C%output_dir)//'/restart_eas'//TRIM(C%filename_extension)//'.nc'
    C%restart_nam_filename      = TRIM(C%output_dir)//'/restart_nam'//TRIM(C%filename_extension)//'.nc'

    C%recording_ant_filename    = TRIM(C%output_dir)//'/recording_ant'//TRIM(C%filename_extension)//'.nc'
    C%recording_grl_filename    = TRIM(C%output_dir)//'/recording_grl'//TRIM(C%filename_extension)//'.nc'
    C%recording_eas_filename    = TRIM(C%output_dir)//'/recording_eas'//TRIM(C%filename_extension)//'.nc'
    C%recording_nam_filename    = TRIM(C%output_dir)//'/recording_nam'//TRIM(C%filename_extension)//'.nc'

    C%help_fields_ant_filename  = TRIM(C%output_dir)//'/help_fields_ant'//TRIM(C%filename_extension)//'.nc'
    C%help_fields_grl_filename  = TRIM(C%output_dir)//'/help_fields_grl'//TRIM(C%filename_extension)//'.nc'
    C%help_fields_eas_filename  = TRIM(C%output_dir)//'/help_fields_eas'//TRIM(C%filename_extension)//'.nc'
    C%help_fields_nam_filename  = TRIM(C%output_dir)//'/help_fields_nam'//TRIM(C%filename_extension)//'.nc'
    
    C%initial_ant_filename      = initial_ant_filename_config
    C%initial_grl_filename      = initial_grl_filename_config
    C%initial_eas_filename      = initial_eas_filename_config
    C%initial_nam_filename      = initial_nam_filename_config        

    C%monthly_ant_filename      = monthly_ant_filename_config
    C%monthly_grl_filename      = monthly_grl_filename_config
    C%monthly_eas_filename      = monthly_eas_filename_config
    C%monthly_nam_filename      = monthly_nam_filename_config        

    C%extra_fields_ant_filename = extra_fields_ant_filename_config
    C%extra_fields_grl_filename = extra_fields_grl_filename_config
    C%extra_fields_eas_filename = extra_fields_eas_filename_config
    C%extra_fields_nam_filename = extra_fields_nam_filename_config        

    C%wind_fields_nam_filename  = wind_fields_nam_filename_config        

    C%pixels_with_anice_filename  = TRIM(C%output_dir)//TRIM(pixels_with_anice_filename_config)//TRIM(C%filename_extension)
    C%topo_anice_res60_filename   = TRIM(C%output_dir)//TRIM(topo_anice_res60_filename_config)//TRIM(C%filename_extension)

    C%restart_selen_ice_filename  = TRIM(C%output_dir)//TRIM(restart_selen_ice_filename_config)//TRIM(C%filename_extension)
    C%restart_selen_mems_filename = TRIM(C%output_dir)//TRIM(restart_selen_mems_filename_config)//TRIM(C%filename_extension)

    C%initial_selen_ice_filename  = initial_selen_ice_filename_config
    C%initial_selen_mems_filename = initial_selen_mems_filename_config

    C%restart_selen_nam_filename  = TRIM(C%output_dir)//TRIM(restart_selen_nam_filename_config)//TRIM(C%filename_extension)
    C%restart_selen_eas_filename  = TRIM(C%output_dir)//TRIM(restart_selen_eas_filename_config)//TRIM(C%filename_extension)
    C%restart_selen_grl_filename  = TRIM(C%output_dir)//TRIM(restart_selen_grl_filename_config)//TRIM(C%filename_extension)
    C%restart_selen_ant_filename  = TRIM(C%output_dir)//TRIM(restart_selen_ant_filename_config)//TRIM(C%filename_extension)

    C%initial_selen_nam_filename  = initial_selen_nam_filename_config
    C%initial_selen_eas_filename  = initial_selen_eas_filename_config
    C%initial_selen_grl_filename  = initial_selen_grl_filename_config
    C%initial_selen_ant_filename  = initial_selen_ant_filename_config

    ! File names for climate model input
    C%climate_fields_ant_filename = climate_fields_ant_filename_config
    C%climate_fields_grl_filename = climate_fields_grl_filename_config
    C%climate_fields_eas_filename = climate_fields_eas_filename_config
    C%climate_fields_nam_filename = climate_fields_nam_filename_config        

    ! File names for ocean temperatures from a climate model
    C%ocean_temp_ant_filename     = ocean_temp_ant_filename_config
    
    ! files for the schematic ice sheet
    C%restart_sch_filename        = TRIM(C%output_dir)//'/restart_sch'//TRIM(C%filename_extension)//'.nc'
    C%restart_sch2_filename       = TRIM(C%output_dir)//'/restart_sch2'//TRIM(C%filename_extension)//'.nc'
    C%recording_sch_filename      = TRIM(C%output_dir)//'/recording_sch'//TRIM(C%filename_extension)//'.nc'
    C%recording_sch2_filename     = TRIM(C%output_dir)//'/recording_sch2'//TRIM(C%filename_extension)//'.nc'

    C%help_fields_sch_filename    = TRIM(C%output_dir)//'/help_fields_sch'//TRIM(C%filename_extension)//'.nc'

    C%initial_sch_filename        = initial_sch_filename_config
    C%initial_sch2_filename       = initial_sch2_filename_config

    C%extra_fields_sch_filename   = extra_fields_sch_filename_config
    C%extra_fields_sch2_filename  = extra_fields_sch2_filename_config


! added by DoE 25/04/2016
    C%viscosity_ant_filename   = viscosity_ant_filename_config
! added by DoE 22/06/2016
    C%geoid_ant_filename   = geoid_ant_filename_config
    C%pippa_rt_filename   = pippa_rt_filename_config
    C%ant_mask_filename =  ant_mask_filename_config


    ! File names of ascii standard output:
    ! Name of ascii files for time-depended output in main program, CONFIG variables
    C%main_standard_filename  = TRIM(C%output_dir)//'ANICE4_output_standard'//TRIM(C%filename_extension)
    C%main_isotope_filename   = TRIM(C%output_dir)//'ANICE4_output_isotopes'//TRIM(C%filename_extension)
    C%main_selen_filename     = TRIM(C%output_dir)//'SELEN_output_means'//TRIM(C%filename_extension)

    C%enable_restart_file     = enable_restart_file_config
    C%enable_recording_file   = enable_recording_file_config
    C%enable_help_fields_file = enable_help_fields_file_config

    ! This number decides which help_fields fields will be printed to the netcdf file help_fields.nc:
    C%which_help_fields      = which_help_fields_config
    C%which_recording_fields = which_recording_fields_config

! added DoE 09/10/2017
    C%use_geoid_forcing     = use_geoid_forcing_config
    C%use_pippa_model        = use_pippa_model_config

    ! Units used for errors and log messages:
    C%stderr = 666
    C%stdlog = 10925

    ! A lot of messages are only written to the screen if the variable below is TRUE:
    C%choice_write_message = choice_write_message_config
    
    ! The plotting units of some time recorded variables:
    C%plot_unit_total_ice_volume  = plot_unit_total_ice_volume_config
    C%plot_unit_total_ice_area    = plot_unit_total_ice_area_config
    C%plot_unit_total_MB_surface  = plot_unit_total_MB_surface_config

    ! Physical parameteters
    C%geothermal_heat_flux        = geothermal_heat_flux_config

    ! Schematic experiment parameters
    C%basal_shelf_melt            = basal_shelf_melt_config
    C%constant_SMB_schematic      = constant_SMB_schematic_config
    C%A_flow_schematic            = C%sec_per_year * A_flow_schematic_config
    C%max_ice_thickness_nh        = max_ice_thickness_nh_config

  END SUBROUTINE initialize_main_constants  

  SUBROUTINE finalize_constants()
    DEALLOCATE(C%zeta)
    DEALLOCATE(C%time_window_steps)
    DEALLOCATE(C%earth_viscosity_profile)
  END SUBROUTINE finalize_constants

END MODULE configuration_main_module
