#!/bin/sh -f

# for archive-imau-ice-selen or old version of model (e.g. on LISA in src_plismip2 dir)
if [ $# -le 2 ]; then
  echo "need three argument to run the model"
  echo "1) the name of the climate field, e.g.: era40"
  echo "2) the initial topograpy source, e.g.: srtm"
  echo "3) the grid distance in km, e.g.: 40"
else

# To get initial ice thickness, bedrock and surface topography, latitude and longitude, individually create the intial files for the ice sheets:
# SRTM-TOPO for Eurasia and North America. Only Hb, no initial ice sheet, these files need additional manipulation after Hb has been mapped

#echo "mapping climate fields for the 4 ice sheets of ANICE4"

# yearly mean fields
#echo ./src/oblimap_gcm_to_im_program config-files/oblimap/${1}-to-im/config_oblimap_${1}_to_im_${2}_${3}x${3}km_Ts_Prcp_Hs
#./src/oblimap_gcm_to_im_program config-files/oblimap/${1}-to-im/config_oblimap_${1}_to_im_${2}_${3}x${3}km_Ts_Prcp_Hs

# monthly fields
#echo ./src/oblimap_gcm_to_im_program config-files/oblimap/${1}-to-im/config_oblimap_${1}_to_im_${2}_${3}x${3}km_monthly_Ts_Prcp
#./src/oblimap_gcm_to_im_program config-files/oblimap/${1}-to-im/config_oblimap_${1}_to_im_${2}_${3}x${3}km_monthly_Ts_Prcp

# rename output names to standard in archive-imau-ice-selen
#ncrename -v ice_surface_temperature,T2m ../archive-imau-ice-selen/input_fields/${2}/${1}_monthly_T2m_Prcp_${2}_${3}x${3}km.nc
#ncrename -v smb,Precip ../archive-imau-ice-selen/input_fields/${2}/${1}_monthly_T2m_Prcp_${2}_${3}x${3}km.nc

echo "Creating new initial input fields"
echo "initial ice thickness and bedrock are from: srtm_Hi_Hb_Hs_antarctica_${2}x${2}km.nc"
echo "reference "
echo ./src_create_input_fields/create_input_fields_program_bas config_files/config_initialize_input_fields_antarctica_${1}_${3}x${3}km
./src_create_input_fields/create_input_fields_program_bas config_files/config_initialize_input_fields_antarctica_${1}_${3}x${3}km

echo "the create_input_fields_program_bas is used for a newer version of the model, hence we need to rename bottom_melt to dHi_dt and add dHb_dt (both initialised at zero)"
# rename dimensions to the ones used in the model

# DoE 11/04
#ncrename -d x,X input_fields/antarctica/initial_antarctica_${1}_with_${2}_${3}x${3}km.nc
#ncrename -v x,X input_fields/antarctica/initial_antarctica_${1}_with_${2}_${3}x${3}km.nc
#ncrename -d y,Y input_fields/antarctica/initial_antarctica_${1}_with_${2}_${3}x${3}km.nc
#ncrename -v y,Y input_fields/antarctica/initial_antarctica_${1}_with_${2}_${3}x${3}km.nc
#ncrename -d time,t input_fields/antarctica/initial_antarctica_${1}_with_${2}_${3}x${3}km.nc
#ncrename -v time,t input_fields/antarctica/initial_antarctica_${1}_with_${2}_${3}x${3}km.nc
#ncrename -v bottom_melt,dHi_dt input_fields/antarctica/initial_antarctica_${1}_with_${2}_${3}x${3}km.nc
#ncks -v dHi_dt input_fields/antarctica/initial_antarctica_${1}_with_${2}_${3}x${3}km.nc dhidt.nc
#ncrename -v dHi_dt,dHb_dt dhidt.nc
#ncks -A dhidt.nc input_fields/antarctica/initial_antarctica_${1}_with_${2}_${3}x${3}km.nc
#rm -rf dhidt.nc
echo "The new initial input file can be viewed with:          ncview input_fields/antarctica/initial_antarctica_${1}_${3}x${3}km.nc "

echo "Create a new reference file from the input fields of the initial program"
ncks -v "Ice Thickness","Bedrock Elevation" input_fields/antarctica/srtm_Hi_Hb_Hs_antarctica_40x40km.nc new_hi_and_hb.nc
#ncrename -v "Ice Thickness",Hi new_hi_and_hb.nc
#ncrename -v "Bedrock Elevation",Hb new_hi_and_hb.nc

# And get Hs, Ts and MB_surface from the reference climate 
ncks -v ice_surface_temperature,smb,Hs input_fields/antarctica/era40_T2m_Precip_Hs_antarctica_40x40km.nc input_fields/antarctica/reference_antarctica_${1}_${3}x${3}km.nc
ncrename -v ice_surface_temperature,Ts input_fields/antarctica/reference_antarctica_${1}_${3}x${3}km.nc
ncrename -v smb,MB_surface input_fields/antarctica/reference_antarctica_${1}_${3}x${3}km.nc
ncks -A new_hi_and_hb.nc input_fields/antarctica/reference_antarctica_${1}_${3}x${3}km.nc
rm -rf new_hi_and_hb.nc
echo "The new reference input file can be viewed with:          ncview input_fields/antarctica/reference_antarctica_${1}_${3}x${3}km.nc "


fi
