# Load packages
library(REAT)
library(tidyverse)

# Avoid using scientific notation
options(scipen = 99999)

# Load data
data_Gini <- read.csv("processed_data/Distribution_data.csv")

# Plot the Lorenz curve for income per capita
lorenz(data_Gini$Sum_income_per_capita, 
       lcx = "Cumulative share of the population", 
       lcy = "Cumulative share of wealth/income", 
       lctitle = "Lorenz Curves of wealth and income",
       le.col = "#a9a9a9", 
       lc.col = "#FFC20A",
       lsize = 3.5, 
       ltype = "solid", 
       bg.col = "gray95", 
       bgrid = TRUE, 
       bgrid.col = "white", 
       bgrid.size = 2, 
       bgrid.type = "solid",
       lcg = FALSE, 
       lcgn = FALSE, 
       lcg.caption = NULL, 
       lcg.lab.x = 0, 
       lcg.lab.y = 1, 
       add.lc = FALSE, 
       plot.lc = TRUE)

# Add the Lorenz curve for wealth per capita
lorenz(data_Gini$Sum_wealth_per_capita, 
       lc.col = "#0C7BDC",
       lsize = 3.5, 
       #ltype = "dashed",  # Different line type for differentiation
       add.lc = TRUE)  # Add to the existing plot

# Add the third Lorenz curve for real estate wealth
lorenz(data_Gini$Sum_real_estate_per_capita, 
       lc.col = "#63A1F4",  # Choose a new color
       lsize = 3.5, 
       # ltype = "dotted",  # Optionally, use a different line type
       add.lc = TRUE)  # Add to the existing plot

# Add the fourth Lorenz curve for financial wealth
lorenz(data_Gini$Sum_movable_wealth_per_capita, 
       lc.col = "#084C8D",  # Choose a new color
       lsize = 3.5, 
       # ltype = "dotted",  # Optionally, use a different line type
       add.lc = TRUE)  # Add to the existing plot

