##### Getting socio-demographic data of grid cells #####
# 01_load_and_process_data script
# 05/12/2024

#### Preparation ##### ----------------------------------------------------------

# load the required packages
library(haven)
library(ineq)
library(DescTools)
library(tidyverse)
library(OasisR)
library(seg)
library(sf)
library(sp)

# Do not use scientific notation
options(scipen = 9999999)

# load the general CBS databases
dem_data <- read_sav("G:/Bevolking/GBAPERSOONTAB/2022/GBAPERSOON2022TABV2.sav")
grid <- read_sav("G:/BouwenWonen/VSLVIERKANTTAB/VRLVSLVIERKANTTABV2024031.sav")
personal_income <- read_sav("G:/InkomenBestedingen/INPATAB/INPA2022TABV3.sav")
address <- read_sav("G:/Bevolking/GBAADRESOBJECTBUS/GBAADRESOBJECT2023BUSV1.sav")

# Load already-processed household income data
household_income <- read.csv("raw_data/database_2022.csv") # only if not already loaded

# make the address database more readable
address <- rename(address, move_in = GBADATUMAANVANGADRESHOUDING)
address <- rename(address, move_out = GBADATUMEINDEADRESHOUDING)

# Use mutate() to create a new column "Individual_ID" by combining the RINPERSOON and RINPERSOONS columns of the databases of interest
address <- mutate(address, Individual_ID = paste(address$RINPERSOONS, address$RINPERSOON))
dem_data <- mutate(dem_data, Individual_ID = paste(dem_data$RINPERSOONS, dem_data$RINPERSOON))
personal_income <- mutate(personal_income, Individual_ID = paste(personal_income$RINPERSOONS, personal_income$RINPERSOON))

# Use mutate() to create a new column "Household_ID" by combining the RINPERSOON and RINPERSOONS columns of the databases of interest
personal_income <- mutate(personal_income, Household_ID = paste(personal_income$RINPERSOONSHKW, personal_income$RINPERSOONHKW))

# Link individual data with household data
income <- merge(personal_income, household_income, by.x = "Household_ID", by.y = "ID", all.x = TRUE, all.y = FALSE)

# Add demographic data
income <- merge(income, dem_data, by = "Individual_ID", all.x = TRUE, all.y = FALSE)

# Add RINOBJECTNUMMER to the income database
income <- merge(income, address, by.x ="Household_ID", by.y = "Individual_ID", all.x = TRUE, all.y = FALSE)

# Add coordinates to the income database
income <- merge(income, grid, by ="RINOBJECTNUMMER", all.x = TRUE, all.y = FALSE)






