
#' this script contains some additional analysis:
#'  > which % of farmers applied more than x tons of manure?
#'  > what is the range in FUSo forward costs?
#'______________________________________________________________________________________________

# which % of farmers applied more than x tons of manure?

library(tidyr)
source("./data_analysis/scripts/5_figure_5.R")


#which percentage of the total banana share receives more than 2 tons/ha/year

man_p_two_tons <-  subset(table_manure_class,
                          table_manure_class$class == "2-5" |
                          table_manure_class$class == "5-10"|
                          table_manure_class$class ==  "10-20"|
                          table_manure_class$class == "20+")

aggregate(man_p_two_tons$percentage_area_coverage,
          by = list(sub_county = man_p_two_tons$sub_county),
          FUN = sum)
#' Birere:  26% of total area gets more than 2 tons/ha/yr
#' rugaaga: 43% of total area gets more than 2 tons/ha/yr
remove(man_p_two_tons)
#_________________________________________________________________________________

#' what is the median manure application of those who do apply manure?
aggregate(cow_dung_ha_DM_yr ~ sub_county, 
          data = selection_manure_input_field, summary)

#' Birere 3414
#' Rugaag 5871
#' 
#'_______________________________________________________________________________________________
#'
#'
#'What is the average manure application on a banana field? - including farmers who don't use any?
#'And how much N is in there?
#'
average_manure_application_field <- manure_input_field
average_manure_application_field<-
average_manure_application_field %>% drop_na(cow_dung_ha_DM_yr)

average_manure_application_field <-  subset(average_manure_application_field, cow_dung_ha_DM_yr < 50000)

mean_manure_application <-  mean(average_manure_application_field$cow_dung_ha_DM_yr)

#average N application
mean_manure_application * (0.82/100)
  

#'
#'   > what is the range in FUSo forward costs?

price_range_fuso <- read.csv(header = T, "./Data input use survey/B3_inputs_bought.csv")
price_range_fuso <- price_range_fuso[c(1,4,5)]
price_range_fuso <- subset(price_range_fuso, price_range_fuso$cow_dung_unit == "fuso forward")
x                <- summary(price_range_fuso$cow_dung_price)


#what are the exact values for quartiles of manure applications

birere <- subset(selection_manure_input_field,
                 selection_manure_input_field$sub_county == "Birere")

rugaaga <- subset(selection_manure_input_field,
                  sub_county == "Rugaaga")

#here it goes wrong, why?
q_birere  <-  summary(birere$cow_dung_ha_yr) 
q_rugaaga <-  summary(rugaaga$cow_dung_ha_yr)
#____________________________________________________

q_birere  <-  summary(birere$cow_dung_ha_ton_DM_yr*1000) 
q_rugaaga <-  summary(rugaaga$cow_dung_ha_ton_DM_yr*1000)





q_manure_use <-  as.data.frame(rbind(q_birere, q_rugaaga)) 
q_manure_use <- subset(q_manure_use, select = -c(1,2,4,6))


remove(q_birere, q_rugaaga, birere, rugaaga)

#' what are the TLU needed and rangeland cropland ratios for median and 
#' 3rd quartile manure applications

#' how much manure can be collected from 1 TLU, given a manure production factor
#'of 12.58 (Herrero et al. 2013), and time spend in the kraal == 13 hours?

#' calculate the collectable manure per TLU
tlu_manure_production  <- 250^0.75 * 12.58
tlu_collectable_manure <- tlu_manure_production * (13/24)

#' TLU needed for med and 3rd quartile application rates
q_manure_use$med_tlu   <- q_manure_use$Median    / tlu_collectable_manure 
q_manure_use$q_3_tlu <- q_manure_use$`3rd Qu.` / tlu_collectable_manure

#' rangeland cropland ratio for med and 3rd quartile application rates,
#' given a medianstocking density of 1.74 TLU (see "stocking density calculation")
q_manure_use$med_rcr  <- q_manure_use$med_tlu / 1.74
q_manure_use$q_3_rcr  <- q_manure_use$q_3_tlu / 1.74





