
#'     THIS script
#'     
#'     contains the code to make a figure showing the % of respondents using inputs 
#'
library(tidyr)
library(ggpubr)
require(ggplot2)

source("./data_analysis/scripts/my_figure_theme.R")


#import files

A1 <- read.csv(header = T, "./data_analysis/data/raw/A1_hh_characteristics_anom.csv")
B1 <- read.csv(header = T, "./data_analysis/data/raw/B1_inputs_per_field_anom.csv")
B9 <- read.csv(header = T, "./data_analysis/data/raw/B9_field_characteristics_anom.csv")
sub_county <- subset(A1, select = c("Name","Sub.county"))

#__________________________________________________________________________________________________________________________________
#how many farmers use (which) inputs on at least one of their fields?

#remove all non_banana fields
B1 <- subset(B1, B1$Field.ID != "No banana field")

#create dataframe with only the needed variables and change yes/no to 0/1
# aggregate per hh, 
inputs_per_field <- subset(B1, select = c(1,3:8,10,12))
new_data <- apply(inputs_per_field[,c(3:9)], 2, FUN = function(x) {ifelse(x == "YES",1,0) })
inputs_per_field<- subset(inputs_per_field, select = c(1,2))
inputs_per_field <- cbind(inputs_per_field, new_data)

aggregator <- function(data, VOIs, GOIs, FUNC='mean', PROB=""){
  VAR_list <- GRP_list <- list()
  for(i in 1:length(GOIs)){  GRP_list[[i]] <- data[[GOIs[i]]]}
  for(i in 1:length(VOIs)){  VAR_list[[i]] <- data[[VOIs[i]]]}
  if(PROB == ""){newdata <- aggregate(VAR_list, by=GRP_list, FUN=FUNC, na.rm=T)} else {newdata <- aggregate(VAR_list, by=GRP_list, FUN=FUNC, na.rm=T, probs=PROB)}
  newdata$FUNCTION <- paste(FUNC, PROB)
  newdata <- newdata[,c(which(colnames(newdata)=="FUNCTION"), which(colnames(newdata)!="FUNCTION"))]
  names(newdata) <- c("FUNCTION", GOIs, VOIs)
  return(newdata)}

a <- aggregator(inputs_per_field, c("cow.dung"), c("Name"), 'sum')
b <- aggregator(inputs_per_field, c("fine.grass"), c("Name"), 'sum')
c <- aggregator(inputs_per_field, c("swamp.grass"), c("Name"), 'sum')
d <- aggregator(inputs_per_field, c("kitchen.compost"), c("Name"), 'sum')
e <- aggregator(inputs_per_field, c("Other.animal.dung"), c("Name"), 'sum')
f <- aggregator(inputs_per_field, c("crop.residues"), c("Name"), 'sum')
g <- aggregator(inputs_per_field, c("fertilizer"), c("Name"), 'sum')

inputs_per_hh <- Reduce(merge, list(a,b,c,d,e,f,g))
remove(a,b,c,d,e,f,g)
inputs_per_hh <- merge(inputs_per_hh, sub_county, by = c("Name"))

# change numbers dataframe to yes/no
new_data <- apply(inputs_per_hh[,c(3:9)], 2, FUN = function(x) {ifelse(x == 0, "NO", "YES")})
inputs_per_hh <- inputs_per_hh[c(1,10)]
inputs_per_hh <- cbind(inputs_per_hh, new_data)

cow_dung <-table(inputs_per_hh$Sub.county, inputs_per_hh$cow.dung)
cow_dung <- spread(as.data.frame(cow_dung), key = "Var2", value = "Freq")
names(cow_dung)[1] <- "district"
names(cow_dung)[2] <- "no cow dung applied"
names(cow_dung)[3] <- "cow dung applied"
cow_dung$imported_cattle_manure <-  cow_dung$`cow dung applied` / (rowSums(cow_dung[,2:3]))
cow_dung <- cow_dung[-c(2,3)]

fine_grass <-table(inputs_per_hh$Sub.county, inputs_per_hh$fine.grass)
fine_grass <- spread(as.data.frame(fine_grass), key = "Var2", value = "Freq")
names(fine_grass)[1] <- "district"
names(fine_grass)[2] <- "no fine grass applied"
names(fine_grass)[3] <- "fine grass applied"
fine_grass$fine_grass <-  fine_grass$`fine grass applied` / (rowSums(fine_grass[,2:3]))
fine_grass <- fine_grass[-c(2,3)]

swamp_grass <-table(inputs_per_hh$Sub.county, inputs_per_hh$swamp.grass)
swamp_grass <- spread(as.data.frame(swamp_grass), key = "Var2", value = "Freq")
names(swamp_grass)[1] <- "district"
names(swamp_grass)[2] <- "no swamp grass applied"
names(swamp_grass)[3] <- "swamp grass applied"
swamp_grass$swamp_grass <-  swamp_grass$`swamp grass applied` / (rowSums(swamp_grass[,2:3]))
swamp_grass <- swamp_grass[-c(2,3)]

kitchen_compost <-table(inputs_per_hh$Sub.county, inputs_per_hh$kitchen.compost)
kitchen_compost <- spread(as.data.frame(kitchen_compost), key = "Var2", value = "Freq")
names(kitchen_compost)[1] <- "district"
names(kitchen_compost)[2] <- "no kitchen compost applied"
names(kitchen_compost)[3] <- "kitchen compost applied"
kitchen_compost$kitchen_compost <-  kitchen_compost$`kitchen compost applied` / (rowSums(kitchen_compost[,2:3]))
kitchen_compost <- kitchen_compost[-c(2,3)]

other_animal_dung <-table(inputs_per_hh$Sub.county, inputs_per_hh$Other.animal.dung)
other_animal_dung <- spread(as.data.frame(other_animal_dung), key = "Var2", value = "Freq")
names(other_animal_dung)[1] <- "district"
names(other_animal_dung)[2] <- "no other animal dung applied"
names(other_animal_dung)[3] <- "other animal dung applied"
other_animal_dung$other_animal_manure <-  other_animal_dung$`other animal dung applied` / (rowSums(other_animal_dung[,2:3]))
other_animal_dung <- other_animal_dung[-c(2,3)]

crop_residues <-table(inputs_per_hh$Sub.county, inputs_per_hh$crop.residues)
crop_residues <- spread(as.data.frame(crop_residues), key = "Var2", value = "Freq")
names(crop_residues)[1] <- "district"
names(crop_residues)[2] <- "no crop residues applied"
names(crop_residues)[3] <- "crop residues applied"
crop_residues$crop_residues <-  crop_residues$`crop residues applied` / (rowSums(crop_residues[,2:3]))
crop_residues <- crop_residues[-c(2,3)]

fertilizer <-table(inputs_per_hh$Sub.county, inputs_per_hh$fertilizer)
fertilizer <- spread(as.data.frame(fertilizer), key = "Var2", value = "Freq")
names(fertilizer)[1] <- "district"
names(fertilizer)[2] <- "no fertilizer applied"
names(fertilizer)[3] <- "fertilizer applied"
fertilizer$fertilizer <-  fertilizer$`fertilizer applied` / (rowSums(fertilizer[,2:3]))
fertilizer <- fertilizer[-c(2,3)]

inputs_per_hh <- Reduce(merge, list(cow_dung, fine_grass, swamp_grass, kitchen_compost, other_animal_dung, crop_residues, fertilizer))
remove(cow_dung, fine_grass, swamp_grass, kitchen_compost, other_animal_dung, crop_residues, fertilizer)


#create dataframes for making graph
temp <- reshape2::melt(inputs_per_hh)
temp$value <- temp$value*100

# Remove the "_" in factor levels and chagne the order of factor levels
temp$variable <- gsub("_", " ", temp$variable)
temp$variable <- as.factor(temp$variable)

levels(temp$variable)[levels(temp$variable) == "other animal manure"] <- "locally collected manure"


temp$variable <- factor(temp$variable, 
                        levels = c("imported cattle manure", "locally collected manure", "kitchen compost",
                                   "crop residues",  "fine grass", "swamp grass", "fertilizer"))

#make plot
input_use <- 
  ggplot(temp, aes(x=variable, y=value, fill=district))+
  geom_bar(stat="identity", position=position_dodge())+
  scale_fill_grey()+
  xlab("")+
  ylab("% of respondents using inputs")+
  my_figure_theme+
  theme(axis.text.x = element_text(angle = 45, hjust = 1))+
  theme(legend.position = c(0.8,0.8))    



# save graph 
png(filename = "./results/figure_4.png",
    width = 550)  

print(input_use)

dev.off()
  
#save as EPS

ggexport(input_use, filename = "./Output/Fig4.eps")






