#set working directory and import files


livestock <- read.csv(header = T, "./data_analysis/data/raw/A5_livestock_ownership_anom.csv")
hh_char <- read.csv(header = T, "./data_analysis/data/raw/A1_hh_characteristics_anom.csv")
sub_county <- subset(hh_char, select = c("Name","Sub.county"))
B3 <- read.csv(header = T, "./data_analysis/data/raw/B3_inputs_bought_anom.csv")
livestock<- merge(sub_county, livestock, by = c("Name"))

#convert into TLU
# https://cgspace.cgiar.org/bitstream/handle/10568/33974/Gender%20Livestock%20and%20Livelihood%20Indicators-Aug13.pdf?sequence=2&isAllowed=y
livestock <- livestock[c(1,2,12,11, 3:10,13:16)]

#convert to other animals TLU units using converion factors presented in Njuki et al., (2011). 
livestock$sheep <- livestock$sheep*0.2
livestock$goats <- livestock$goats*0.2
livestock$pigs <- livestock$pigs*0.3
livestock$donkey <- livestock$donkey*0.8
livestock$chicken <- livestock$chicken*0.04
livestock$Turkey <- livestock$Turkey*0.04
livestock$Duck <- livestock$Duck*0.04
livestock$Rabbit <- livestock$Rabbit*0.04

livestock$Calves <- livestock$Calves*0.5
livestock$Heifers <- livestock$Heifers*0.85
livestock$Mature.cow <- livestock$Mature.cow*1.15
livestock$Bull <- livestock$Bull*1.42

livestock$TLU <- rowSums(livestock[4:16])

#calculate mean TLU and stdev for those owning cattle for  birere and Rugaaga
livestock_birere <- subset(livestock, livestock$Sub.county == "Birere" & livestock$TLU >0)
livestock_rugaaga <- subset(livestock, livestock$Sub.county == "Rugaaga" & livestock$TLU >0)

#remove outlier with 80 cows in Rugaaga (163 TLU), but these cows are located on another farm  located in Endinzi.
#Thus, using this manure on his plantation still requires truck transport
livestock_rugaaga_1 <- subset(livestock_rugaaga, livestock_rugaaga$TLU <100)

mean(livestock_birere$TLU)
mean(livestock_rugaaga$TLU)
sd(livestock_birere$TLU)
sd(livestock_rugaaga$TLU)
mean(livestock_rugaaga_1$TLU)
sd(livestock_rugaaga_1$TLU)

#% of respondents owning less than 1 TLU
((length(which(livestock$Sub.county == "Birere" & livestock$TLU < 1))) / (length(which(livestock$Sub.county == "Birere"))) )*100
((length(which(livestock$Sub.county == "Rugaaga" & livestock$TLU < 1))) / (length(which(livestock$Sub.county == "Rugaaga"))) )*100


#write table to excell
write.csv(livestock, file = "./results/table_3_TLU_ownership.csv")
