

#' source script that adds lines indicating median, 3rd quartile, 
# ' 90th percentile and attainable yields
target_yields <- read.csv(header = T, file = "./model/data/target_yields.csv")
source("./data_analysis/scripts/my_figure_theme.R")
remove(input_yield_levels, mop_0_output_yield_levels, mop_25_output_yield_levels, 
       mop_50_output_yield_levels)

library(ggplot2)
#___________________________________________________________________________________


# make plot K offtake and K requirement

plot_K_req <-
   ggplot(data = K_nut_req, aes(x= yield/1000, y= total_K_requirement, fill= variable))+
  geom_line(aes(linetype = variable), size =1)+
  ylab("Potassium required (kg/ha/year)")+
  xlab("Yield (t FW/ha/year)")+
  xlim(25,70)+
  ylim(0,500)+
  annotate("text", x = target_yields$yield -1.3, y = 470, 
           label = target_yields$labels, size = 5)+
  geom_vline(xintercept = target_yields$yield, linetype = "dashed")+
  geom_hline(yintercept = 115)+
  theme(legend.position = "none")+
  geom_segment(aes(x = 60, y= 0, xend = 60, yend = 110), 
               arrow =  arrow(length = unit(0.03, "npc"), ends = "both"))+
  geom_text(aes( x = 62, y = 55), label = "IKS", size = 5)+
  geom_segment(aes(x = 60, y= 115, xend = 60, yend = 397), 
               arrow =  arrow(length = unit(0.03, "npc"), ends = "both"))+
  geom_text(aes( x = 62, y = 255), label = "K req", size = 5)+
  geom_ribbon(aes(ymin = IKS, ymax = total_K_requirement), fill = "grey", alpha =0.3)+
  my_figure_theme
#___________________________________________________________________________________

# make plot manure needed and TLU needed in 1 graph

plot_manure_tlu_needed <-
ggplot(data = manure_needed_yield, aes(x= yield/1000, y= value/1000))+
  scale_y_continuous(sec.axis = sec_axis(~./0.227, name = "TLU required/ ha banana"))+
  geom_line(aes(linetype = manure), size = 1)+
  scale_linetype_manual(name  ="% manure used",
                        breaks=c("100", "75", "50"),
                        labels=c("100%", "75%", "50%"), 
                        values = c("solid", "dashed", "dotted")) +
  ylab("Manure required (t DM/ha/year)")+
  xlab("Yield (t FW/ha/year)")+
  xlim(25,70)+
  annotate("text", x = target_yields$yield -1.3, y = 35, 
           label = target_yields$labels, size = 5)+
  geom_vline(xintercept = target_yields$yield, linetype = "dashed")+
  theme(legend.position = c(.85, .17))+
  my_figure_theme
#___________________________________________________________________________________

#' plot K_offtake, K requirement (A) and manure and TLU needed in 1 graph
#' save a copy
png(filename = "./results/figure_6.png",
    width = 1200,
    height = 495)

ggarrange(plot_K_req, plot_manure_tlu_needed,
          labels = c("A", "B"))

dev.off()

#save as EPS

cairo_ps(filename = "./results/figure_6.eps",
         fallback_resolution = 300)

ggarrange(plot_K_req, plot_manure_tlu_needed,
          labels = c("A", "B"))

dev.off()


#____________________________________________________________________________________


#Plot N balance
plot_n_balance <- 
  ggplot(data = n_bal_yield, aes(x= yield/1000, y= value))+
  geom_line(aes(linetype = manure), size = 1)+
  scale_linetype_manual(name  ="% manure used",
                        breaks=c("0","50", "75","100"),
                        labels=c("0","50", "75","100"),
                        values = c("dotdash", "solid", "dashed", "dotted"))+
  ylab("Partial N balance (kg/ha/year)")+
  xlab("Yield (t FW/ha/year)")+
  xlim(25,70)+
  scale_y_continuous(breaks=seq(0, 300, 50))+
  annotate("text", x = target_yields$yield -1.3, y = 270,
           label = target_yields$labels, size = 5)+
  geom_vline(xintercept = target_yields$yield, linetype = "dashed")+
  theme(legend.position = c(.9, .17))+
  my_figure_theme

#___________________________________________________________________________________

#Plot P balance
#plot P balance

plot_p_balance <- 
  ggplot(data = p_bal_yield, aes(x= yield/1000, y= value))+
  geom_line(aes(linetype = manure), size = 1)+
  scale_linetype_manual(name  ="% manure used",
                        breaks=c("0","50", "75","100"),
                        labels=c("0","50", "75","100"),
                        values = c("dotdash", "solid", "dashed", "dotted"))+
  ylab("Partial P balance (kg/ha/year)")+
  xlab("Yield (t FW/ha/year)")+
  scale_y_continuous(breaks=seq(0, 30, 5))+
  xlim(25,70)+
  annotate("text", x = target_yields$yield, y = 26, 
           label = target_yields$labels, size = 5)+
  geom_vline(xintercept = target_yields$yield, linetype = "dashed")+
  theme(legend.position = c(.9, .17))+
  my_figure_theme
#_________________________________________________________________________________

#plot 2 figures figures + legend
#' > N balance
#' > P balance
png(filename = "./results/figure_7.png",
    width = 1200,
    height = 495)

ggarrange(plot_n_balance, plot_p_balance,
          labels = c("A", "B"),
          common.legend = T)
dev.off()

#save as EPS
Fig_7 <- ggarrange(plot_n_balance, plot_p_balance,
                   labels = c("A", "B"),
                   common.legend = T)


ggexport(Fig_7,filename = "./results/figure_7.eps",
         width = 1200,
         height = 495)


#____________________________________________________________________________________________


#' create table with input costs at different yield levels
#'  30 - 35 - 40 - 45 - 65

table_input_costs <- subset(input_cost_yield, 
                            input_cost_yield$manure != "0")


table_input_costs  <-   subset(table_input_costs,               
                               table_input_costs$yield == 30000 |
                                 table_input_costs$yield == 35000 |
                                 table_input_costs$yield == 40000 |
                                 table_input_costs$yield == 45000 |
                                 table_input_costs$yield == 65000 )

table_input_costs$variable <- NULL

#' change table from long to wide and export
table_input_costs <-  tidyr::spread(table_input_costs, key = manure, value = value)

write.csv(table_input_costs, "./results/table_4.csv",
          row.names = F)
#____________________________________________________________________________________

