library(rlist)
library(ggplot2)
library(dplyr)


# Call input processor
input_yield_levels <- input_processor("./model/data/yield_levels.csv")


#'                      0% MOP
# Loop through input list and create output dataframe
mop_0_output_yield_levels <- lapply(input_yield_levels, model_core, K_by_mop = 0)
mop_0_output_yield_levels <- output_processor(mop_0_output_yield_levels)

#'                      25% MOP
# Loop through input list and create output dataframe
mop_25_output_yield_levels <- lapply(input_yield_levels, model_core, K_by_mop = 25)
mop_25_output_yield_levels <- output_processor(mop_25_output_yield_levels)

#'                      50% MOP
# Loop through input list and create output dataframe
mop_50_output_yield_levels <- lapply(input_yield_levels, model_core, K_by_mop = 50)
mop_50_output_yield_levels <- output_processor(mop_50_output_yield_levels)

#'                      100% MOP and Urea
# Loop through input list and create output dataframe
mop_100_output_yield_levels <- lapply(input_yield_levels, model_core, K_by_mop = 100)
mop_100_output_yield_levels <- output_processor(mop_100_output_yield_levels)



#___________________________________________________________________________________

#create an extra column with the yield level categories
yield_level <- subset(mop_0_output_yield_levels, 
                      mop_0_output_yield_levels$variable == "fw_yield")

yield_level <- yield_level %>% dplyr::rename(yield = value)
yield_level <- yield_level[c(1,6)]

# yield level column attach to dataframe 0 MOP
# remove unneeded columns
mop_0_output_yield_levels <- merge(mop_0_output_yield_levels, yield_level)

mop_0_output_yield_levels <- subset(mop_0_output_yield_levels, 
                              mop_0_output_yield_levels$variable != "fw_yield",
                              select = c("yield", "variable", "value"))
mop_0_output_yield_levels$manure <- 100

# yield level column attach to dataframe 25 MOP
# remove unneeded columns
mop_25_output_yield_levels <- merge(mop_25_output_yield_levels, yield_level)

mop_25_output_yield_levels <- subset(mop_25_output_yield_levels, 
                                    mop_25_output_yield_levels$variable != "fw_yield",
                                    select = c("yield", "variable", "value"))
mop_25_output_yield_levels$manure <- 75

# yield level column attach to dataframe 50 MOP
# remove unneeded columns
mop_50_output_yield_levels <- merge(mop_50_output_yield_levels, yield_level)

mop_50_output_yield_levels <- subset(mop_50_output_yield_levels, 
                                    mop_50_output_yield_levels$variable != "fw_yield",
                                    select = c("yield", "variable", "value"))
mop_50_output_yield_levels$manure <- 50


# yield level column attach to dataframe 100 MOP
# remove unneeded columns
mop_100_output_yield_levels <- merge(mop_100_output_yield_levels, yield_level)

mop_100_output_yield_levels <- subset(mop_100_output_yield_levels, 
                                     mop_100_output_yield_levels$variable != "fw_yield",
                                     select = c("yield", "variable", "value"))
mop_100_output_yield_levels$manure <- 0

remove(yield_level)




#'___________________________________________________________________________________
#' prepare dataframe for manure  needed 
#' 
manure_needed_0_mop <- subset(mop_0_output_yield_levels, 
                    mop_0_output_yield_levels$variable == "manure_needed")

manure_needed_25_mop <- subset(mop_25_output_yield_levels, 
                     mop_25_output_yield_levels$variable == "manure_needed")

manure_needed_50_mop <- subset(mop_50_output_yield_levels, 
                     mop_50_output_yield_levels$variable == "manure_needed")

manure_needed_yield     <- rbind(manure_needed_0_mop, manure_needed_25_mop, 
                                 manure_needed_50_mop)
manure_needed_yield$manure <- as.factor(manure_needed_yield$manure) 
remove(manure_needed_0_mop, manure_needed_25_mop, manure_needed_50_mop)
#___________________________________________________________________________________________

#' prepare dataframe for tlu
#' 
tlu_0_mop <- subset(mop_0_output_yield_levels, 
                    mop_0_output_yield_levels$variable == "tlu")

tlu_25_mop <- subset(mop_25_output_yield_levels, 
                    mop_25_output_yield_levels$variable == "tlu")

tlu_50_mop <- subset(mop_50_output_yield_levels, 
                    mop_50_output_yield_levels$variable == "tlu")

tlu_yield     <- rbind(tlu_0_mop, tlu_25_mop, tlu_50_mop)
tlu_yield$manure <- as.factor(tlu_yield$manure) 
remove(tlu_0_mop, tlu_25_mop, tlu_50_mop)

#___________________________________________________________________________________________

#' prepare dataframe for K_requirement
#' 
K_nut_req    <- subset(mop_0_output_yield_levels, 
                       mop_0_output_yield_levels$variable == "K_requirement")
K_nut_req$manure    <- NULL

#calculate total banana K requirement: including the 112 kg K soil supply.

K_nut_req$IKS <- 112

K_nut_req$total_K_requirement <- K_nut_req$value + K_nut_req$IKS


#____________________________________________________________________________________________
#' prepare dataframe for rangeland cropland ratio
#' 
range_crop_ratio_0_mop <- subset(mop_0_output_yield_levels, 
                                 mop_0_output_yield_levels$variable == "crop_range_ratio")

range_crop_ratio_25_mop <- subset(mop_25_output_yield_levels, 
                                  mop_25_output_yield_levels$variable == "crop_range_ratio")

range_crop_ratio_50_mop <- subset(mop_50_output_yield_levels, 
                                  mop_50_output_yield_levels$variable == "crop_range_ratio")

range_crop_ratio_yield     <- rbind(range_crop_ratio_0_mop, range_crop_ratio_25_mop,
                                    range_crop_ratio_50_mop)
range_crop_ratio_yield$manure <- as.factor(range_crop_ratio_yield$manure) 
remove(range_crop_ratio_0_mop, range_crop_ratio_25_mop, range_crop_ratio_50_mop)

#___________________________________________________________________________________________

#' prepare dataframe for N balance
#' 
n_bal_0_mop <- subset(mop_0_output_yield_levels, 
                    mop_0_output_yield_levels$variable == "N_balance")

n_bal_25_mop <- subset(mop_25_output_yield_levels, 
                     mop_25_output_yield_levels$variable == "N_balance")

n_bal_50_mop <- subset(mop_50_output_yield_levels, 
                     mop_50_output_yield_levels$variable == "N_balance")

n_bal_100_mop <- subset(mop_100_output_yield_levels, 
                       mop_100_output_yield_levels$variable == "N_balance")

n_bal_yield     <- rbind(n_bal_0_mop, n_bal_25_mop, n_bal_50_mop, n_bal_100_mop)
n_bal_yield$manure <- as.factor(n_bal_yield$manure) 
remove(n_bal_0_mop, n_bal_25_mop, n_bal_50_mop, n_bal_100_mop)
#'____________________________________________________________________________________________
#'

#' prepare dataframe for P balance
#' 
p_bal_0_mop <- subset(mop_0_output_yield_levels, 
                      mop_0_output_yield_levels$variable == "P_balance")

p_bal_25_mop <- subset(mop_25_output_yield_levels, 
                       mop_25_output_yield_levels$variable == "P_balance")

p_bal_50_mop <- subset(mop_50_output_yield_levels, 
                       mop_50_output_yield_levels$variable == "P_balance")

p_bal_100_mop <- subset(mop_100_output_yield_levels, 
                        mop_100_output_yield_levels$variable == "P_balance")

p_bal_yield     <- rbind(p_bal_0_mop, p_bal_25_mop, p_bal_50_mop, p_bal_100_mop)
p_bal_yield$manure <- as.factor(p_bal_yield$manure) 
remove(p_bal_0_mop, p_bal_25_mop, p_bal_50_mop, p_bal_100_mop)


#'____________________________________________________________________________________________
#'

#' prepare dataframe for input costs
#' 
input_cost_0_mop <- subset(mop_0_output_yield_levels, 
                      mop_0_output_yield_levels$variable == "manure_mop_cost")

input_cost_25_mop <- subset(mop_25_output_yield_levels, 
                       mop_25_output_yield_levels$variable == "manure_mop_cost")

input_cost_50_mop <- subset(mop_50_output_yield_levels, 
                       mop_50_output_yield_levels$variable == "manure_mop_cost")

input_cost_100_mop <- subset(mop_100_output_yield_levels, 
                            mop_100_output_yield_levels$variable == "manure_mop_cost")

input_cost_yield     <- rbind(input_cost_0_mop, input_cost_25_mop, input_cost_50_mop,
                              input_cost_100_mop)
input_cost_yield$manure <- as.factor(input_cost_yield$manure) 
remove(input_cost_0_mop, input_cost_25_mop, input_cost_50_mop, input_cost_100_mop)

