

#' What does it do?
#' 
#' This script converts the output generated by the model into a dataframe that can be used for analysis.
#' 
#' Process output list...
#'
#' @param output_list A list of depth 3 ...
#'

output_processor <- function(output_list){
  
  output_raw_df <- as.data.frame(t(unlist(output_list)))
  
  output <- tidyr::pivot_longer(data = output_raw_df, 
                                cols = tidyr::everything(),
                                names_to = c("run", "category", "variable"),
                                names_pattern = "([^\\.]+)\\.([^\\.]+)\\.([^\\.]+)")
  
  output <- tidyr::separate(data = output, 
                            col = "run",
                            into = c("parameter", "variation"),
                            sep = "__",
                            remove = FALSE)
  
  output$variation <- ifelse(grepl("^m", output$variation), 
                             gsub("m", "-", output$variation),
                             gsub("p", "", output$variation))
  
  output$variation <- as.numeric(output$variation)
  
  #addition harmen: in a later stage, it comes in handy to convert column 'variable'
  # to factor
  output$variable  <- as.factor(output$variable)
  #end addition harmen
  
  
  return(output)
  
}