


#' 3. MANURE AVAILABILITY
#'
#' WHAT DOES IT DO?
#' 
#' This module calculates the fraction of the total excreted manure that is available for collection,
#' and the fraction of collectable manure that is available for selling.   
#' 
#'___________________________________________________________________________________________________________ 
#' 
#' 
#' INPUT PARAMETERS 
#' 
#' Input parameters and the definitions are:											
#'   >  kraal_hours                 - Average number of hours cows are confined in the kraal 
#'   >  storage_efficiency          - The fraction of dry mass that is remaining after storage
#'   >  stocking_density            - Stocking density in TLU/ha
#'                                    
#'____________________________________________________________________________________________________________
#'  

#'
#'  OUTPUT VARIABLE
#'  
#'  > collection_efficiency    <- Fraction of total excreted manure that is excreted in kraal
#'  > storage_efficiency       <- fraction of manure that remains after storage
#'  >	partioning coefficient   <- Fraction of total excreted manure that is available for application		

#'____________________________________________________________________________________________________________

# FUNCTIONS

    fun_manure_availability <- function(kraal_hours,
                                        storage_efficiency,
                                        stocking_density) {
      
      collection_efficiency            <- kraal_hours / 24
      partitioning_coefficient         <- collection_efficiency * storage_efficiency
      
  
    return(list( collection_efficiency     = collection_efficiency,
                 storage_efficiency        = storage_efficiency,
                 partitioning_coefficient  = partitioning_coefficient
                 ))
     }      

#'
#'___________________________________________________________________________________________________________________

#'    REFERENCES
#' 