
#' WHAT DOES IT DO?
#' 
#' This module calculates the manure production of a 'standard cow'
#' in Isingiro and Kiruhura district. 
#'___________________________________________________________________________________________________________ 
#' 
#'  INPUT PARAMETERS
#' 
#' Input parameters and the definitions are:		
#' 
#'   >  body_weight_standard_cow  - The bodyweight (in kg) of a standard cow in the region. This value can be 
#'                                  calculated using //"Supplementary scripts/body_weight_standard_cow.R"
#'   >  manure_production_factor  - Value that indicates the manure production of an animal in 
#'                                  kg DM manure production / kg bodyweight^0.75/year. Values can be found in
#'                                  the annex of the paper by Herrero et al. (2013). 
#'                                  Recommended value is 12.58: grazing dairy cattle in tropical highlands or 
#'                                  temperate zones in Sub-Saharan Africa.
#'                                  
#'__________________________________________________________________________________________________________  

#'  OUTPUT VARIABLES
#'
#'  TLU_standard_cow          <- the TLU equivalent of a standard cow
#'  manure_production_cow     <- Manure production in kg DM / 'standard cow' / year      
#'  
#'___________________________________________________________________________________________________________
#'                               
#'  FUNCTIONS    
#'  
fun_manure_production <- function(body_weight_standard_cow,
                                  manure_production_factor){
  
  
  #' Bodyweight is converted to TLU using a method described by Njuki et al. (2011):
  #' TLU is metabolic body weight  / metabolic body weight for 250kg animal. 
  #' Metabolic bodyweight is body weight^0.75 
  #' 
  TLU_standard_cow                <- (body_weight_standard_cow ^0.75) / (250^0.75)
  
  #' calculate the manure production per standard cow
  manure_production_standard_cow  <- (body_weight_standard_cow^0.75) * manure_production_factor
  
  # 3 return outcome variables
  
  return(list( TLU_standard_cow = TLU_standard_cow,
               manure_production_standard_cow = manure_production_standard_cow  ))
}
