

#select the required variable: manure needed
# How does the manure needed change under -50 and + 50 % changes in soil K supply?
library(rlist)
library(ggplot2)
library(dplyr)
library(ggpubr)

# Call input processor

input_sens_K_supply <- input_processor("./model/data/soil_K_supply_range.csv")

#'                      0% MOP
# Loop through input list and create output dataframe
mop_0_output_sens_K_supply <- lapply(input_sens_K_supply, model_core, K_by_mop = 0)
mop_0_output_sens_K_supply <- output_processor(mop_0_output_sens_K_supply)

#'                      25% MOP
# Loop through input list and create output dataframe
mop_25_output_sens_K_supply <- lapply(input_sens_K_supply, model_core, K_by_mop = 25)
mop_25_output_sens_K_supply <- output_processor(mop_25_output_sens_K_supply)

#'                      50% MOP
# Loop through input list and create output dataframe
mop_50_output_sens_K_supply <- lapply(input_sens_K_supply, model_core, K_by_mop = 50)
mop_50_output_sens_K_supply <- output_processor(mop_50_output_sens_K_supply)

#select the required variable: manure needed
K_supply_manure_0_MOP <- subset(mop_0_output_sens_K_supply, mop_0_output_sens_K_supply$variable == "manure_needed")
K_supply_manure_25_MOP <- subset(mop_25_output_sens_K_supply, mop_25_output_sens_K_supply$variable == "manure_needed")
K_supply_manure_50_MOP <- subset(mop_50_output_sens_K_supply, mop_50_output_sens_K_supply$variable == "manure_needed")

#attach column indicating the manure supply
K_supply_manure_0_MOP$manure   <- 100
K_supply_manure_25_MOP$manure  <- 75
K_supply_manure_50_MOP$manure  <- 50

remove(mop_0_output_sens_K_supply, mop_25_output_sens_K_supply, mop_50_output_sens_K_supply)
K_supply_manure <- rbind(K_supply_manure_0_MOP, K_supply_manure_25_MOP, K_supply_manure_50_MOP)


K_supply_manure$manure <- as.factor(as.character(K_supply_manure$manure))
K_supply_manure$manure <- ordered(K_supply_manure$manure, level = c("100", "75", "50"))

#translate the change in % back to actual values.
K_supply_manure$variation <- K_supply_manure$variation / 100
K_supply_manure$K_supply  <- 112 + (K_supply_manure$variation*112)

#plot and save

sensitivity_K_supply <- 
  ggplot(data =K_supply_manure, aes(x=K_supply, y = value/1000, linetype = manure ))+
  geom_line(size = 1.1)+
  scale_y_continuous(sec.axis = sec_axis(~./0.227, name = "TLU required/ ha banana"))+
  xlab("Indigenous soil K supply (kg /ha/year)")+
  ylab("Manure required (t DM/ha/year)")+
  scale_shape_discrete(name  ="% manure used",
                       breaks=c("100", "75", "50"),
                       labels=c("100%", "75%", "50%"))+
  scale_linetype_manual(values=c("dotted", "dashed", "solid"))+
  geom_vline(xintercept = 112, linetype = "dashed")+
  geom_hline(yintercept = -1.2)+
  annotate("text", x= 0, y = -0.4, label = "-100%", size = 4, fontface = "bold" )+
  annotate("text", x= 200, y = -0.4, label = "+100%", size = 4, fontface = "bold" )+
  annotate("text", x= 114, y = -0.4, label = "base value", size = 4, fontface = "bold" )+
  theme(legend.position = c(0.8, 0.8))+
  my_figure_theme


#save a png copy

png(filename = "./results/figure_10.png")

print(sensitivity_K_supply)

dev.off()

#save a EPS copy
Fig_10 <- sensitivity_K_supply

ggexport(Fig_10, filename = "./results/figure_10.eps")


