
#'                               DESCRIPTION
#'-------------------------------------------------------------------------
#'
#' This script generates all the data needed for the sensitvity analysis.
#' 3 scenarios are run
#' 
#'                      
#'  1) 0  % of total K requirement supplied by mop 
#'  2) 25 % of total K requirement supplied by mop 
#'  3) 50 %  of total K requirement supplied by mop 
#'
#' In each scenario the model is run in the following way:
#' 
#' for performing a sensitivity analysis, 
#' 
#' > each input parameter is deviated 1 by 1, 
#' > from -20% to 20% from its base value
#' > in steps of 5%
#' > resulting in 9 runs per input parameter
#'
#' > There are 20 input parameters
#' 
#' > the total amount of runs per scenario is this 9*20 = 180 


library(rlist)
library(ggplot2)


#'_______________________________________________________________________________________


#'                          PREPARING INPUT FILES


#' Apply input processor function on all files in data/input_files directory,

all_input_lists <- list.files("./model/data/sensitivity_analysis", pattern = "*.csv", full.names = TRUE)
all_input_lists <-  lapply(all_input_lists, input_processor)


#' Define the names for the list elements and assign them

names_for_input_lists <- list.files("./model/data/sensitivity_analysis", pattern = "*.csv", full.names = F)
names_for_input_lists <- gsub(".csv", "", names_for_input_lists)
names(all_input_lists) <- names_for_input_lists
remove(names_for_input_lists)

#________________________________________________________________________________________________

#'
#'             
#'                                    RUNNING THE MODEL
#'
#'
#' define a function that takes an input list for 1 sensitivity parameter,
#' and loops the model over this input_list. Run this for 3 scenarios,  
#'  
#'  1) 0  % mop applied,
#'  2) 25 % mop applied,
#'  3) 50 % mop applied 
#' 
#'______________________________________________________________________________________
#'  
#'   
#'   
#'   
#'                      RUN WITH K_BY_MOP AT 0

model_process_input_lists_0 <- function(input_list, K_by_mop) {
  
  
  lapply(input_list, model_core, K_by_mop = 0)
}

#' apply this function to multiple input_list and create an output list

output_list_mop_0  <- lapply(all_input_lists, model_process_input_lists_0)
remove(model_process_input_lists_0)
#' 
#'______________________________________________________________________________________
#'  
#'   
#'   
#'   
#'                      RUN WITH K_BY_MOP AT 25

model_process_input_lists_25 <- function(input_list, K_by_mop) {
  
 
  lapply(input_list, model_core,  K_by_mop = 25)
}

#' apply this function to multiple input_list and create an output list

output_list_mop_25  <- lapply(all_input_lists, model_process_input_lists_25)
remove(model_process_input_lists_25)

#'______________________________________________________________________________________
#'  
#'   
#'   
#'   
#'                      RUN WITH K_BY_MOP AT 50

model_process_input_lists_50 <- function(input_list, K_by_mop) {
  

  lapply(input_list, model_core, K_by_mop = 50)
}

#' apply this function to multiple input_list and create an output list

output_list_mop_50  <- lapply(all_input_lists, model_process_input_lists_50)
remove(model_process_input_lists_50)
remove(all_input_lists)

#'______________________________________________________________________________________
#'  
#'   
#'   PREPARING OUTPUT LISTS FOR DATA ANALYSIS
#'   
#' loop the output processor through all input_lists. This produces a list of tibbles, 
#' with each tibble containing the output for 1 sensitivity parameter
#' this is done 3 times, 1 time for each mop-scenario
#' 

all_output_0_mop <- lapply(output_list_mop_0, output_processor)
all_output_25_mop <- lapply(output_list_mop_25, output_processor)
all_output_50_mop <- lapply(output_list_mop_50, output_processor)

remove(output_list_mop_0, output_list_mop_25, output_list_mop_50)

#'_____________________________________________________________________________________________
#'