
#' This script calculates the banana area in birere and Rugaaga, 
#' based on csv input files contataining the data from the banana area mapping
#' 


#import files

birere_files <- list.files("./model/data/banana_area_mapping",
                        pattern = "bir", full.names = T)
birere_files  <- lapply(birere_files, read.csv)

rugaaga_files <- list.files("./model/data/banana_area_mapping",
                           pattern = "rug", full.names = T)
rugaaga_files  <- lapply(rugaaga_files, read.csv)

#count nr of observations and store in dataframe
bir_nr_obs <- lapply(birere_files, nrow)
rug_nr_obs <- lapply(rugaaga_files, nrow)

class      <- c("0_10", "10_25", "25_50", "50-75", "75_100")
area       <- as.data.frame(cbind(class, bir_nr_obs, rug_nr_obs)) 

#unlist columns
area$class      <- unlist(area$class)
area$bir_nr_obs <- as.numeric(unlist(area$bir_nr_obs)) 
area$rug_nr_obs <- as.numeric(unlist(area$rug_nr_obs)) 


#' assign a value to each class. The class with 0-10 % banana coverage is regarded as 0% banana cover,
#' the other classes get the average between upper and lower boundary. For instance,
#'  class 10-25 <- (10+25)/2 = 17.5
#'  class 25_50 <- (25+50)/2 = 37.5   etc
#'  the area of each observation is 2.5 ha (1 gridcell) = (500*500 )/10000

area$value                  <- c(0, 0.175, 0.375, 0.625, 0.875)
area$cell_area_ha           <- (500*500)/10000
area$bir_tot_banana_area_ha <- area$bir_nr_obs * area$value * area$cell_area_ha
area$rug_tot_banana_area_ha <- area$rug_nr_obs * area$value * area$cell_area_ha


# BIRERE TOTAL BANANA AREA AND % COVERAGE

#the total area (ha and km2) in Birere is:
sum(area$bir_nr_obs) * 25
#7625  #NOTE, measuring the total area in Qgis, resulted in an area of 7378 ha
birere_total_area_km2 <- (sum(area$bir_nr_obs) * 25) * 0.01

#' banana area in ha
birere_banana_area <- sum(area$bir_tot_banana_area_ha)
#1849

#The share of area covered by banana in Birere is 0.24:
1849/7625


# RUGAAGA TOTAL BANANA AREA AND % COVERAGE
#the total area, and the total banana area (in ha) in rugaaga is:
sum(area$rug_nr_obs) * 25
# 21700  #NOTE, measuring the total area in Qgis, resulted in an area of 21466 ha
rugaaga_total_area_km2 <- (sum(area$rug_nr_obs) * 25) * 0.01

rugaaga_banana_area <- sum(area$rug_tot_banana_area_ha)
#4403

#The share of area covered by banana in Birere is 0.20
4403/21700






  
 



