
function img = getImgFromJson(filename)

jsonData = jsondecode(fileread('IMG_20191014_161409.json'));

im_v = matlab.net.base64decode(jsonData.imageData);

% decode image stream using Java
jImg = javax.imageio.ImageIO.read(java.io.ByteArrayInputStream(im_v));
h = jImg.getHeight;
w = jImg.getWidth;

% convert Java Image to MATLAB image
p = reshape(typecast(jImg.getData.getDataStorage, 'uint8'), [3,w,h]);
img = cat(3, ...
        transpose(reshape(p(3,:,:), [w,h])), ...
        transpose(reshape(p(2,:,:), [w,h])), ...
        transpose(reshape(p(1,:,:), [w,h])));

end