## Matlab files used to produce the figures in the publication: On the Derivation of Closed-Form Expressions for Displacements, Strains and Stresses Inside Poroelastic Reservoirs

Authors: P. Cornelissen, J.D. Jansen
TU Delft, Faculty of Civil Engineering and Geosciences, Department of Geoscience and Engineering 

Corresponding author: P. Cornelissen
Contact information: p.cornelissen@tudelft.nl


### Dataset description
This dataset contains the MATLAB scripts which computes the poroelastic strains and stresses based on inclusion theory. These scripts were used to produce figures 5, 6, and 9 of the following manuscript:

*Cornelissen, P., Meulenbroek, B.J., Jansen, J.D., (2023). On the Derivation of Closed-Form Expressions for Displacements, Strains and Stresses Inside Poroelastic Reservoirs. Submitted to JGR - Solid Earth.*

The files have been prepared for MATLAB R2021b. 

**verify_volumetric_strain.m**  
This script computes the scaled volumetric strain as defined in the associated manuscript for both a rectangular and a triangular inclusion undergoing a uniform unit change in pore pressure. The results are plotted in a surface plot. This produces Figure 5 in the associated manuscript.

**verify_strain_discontinuity.m**  
This script computes the strain tensor components at a point just inside the inclusion and just outside the inclusion (both at 1 micrometer distance from the inclusion boundary). Furthermore, the required jump in strains to maintain mechanical equilibrium is computed based on Equations 29-31 of the associated manuscript. This produces Figure 6 of the associated manuscript.
	
**strain_rectangle.m**  
This is a MATLAB function file which computes the strain tensor components for a rectangular inclusion using Equations 40-42 in the associated manuscript. This function is called from both `verify_volumetric_strain.m` and `verify_strain_discontinuity.m`. 

**strain_triangle.m**  
This is a MATLAB function file which computes the strain tensor components for a triangular inclusion using Equations 45-47 in the associated manuscript. This function is called from both `verify_volumetric_strain.m` and `verify_strain_discontinuity.m`. 

**TwoBlocksThreeFaults.m**  
Computes depletion-induced fault stresses in a two-block reservoir with one central and two bounding faults. Makes use of two rectangular and four triangular elements with four different orientations (see Figure 8). The corresponding modifications with respect to a “standard” triangular element, as displayed in Figure 4, have been given in Equations 56-59 of the associated manuscript. This script produces Figure 9.
