clear all
close all
clc

%% Plotting average bubble size for N2 experiments
load('N2_He\avg_bubble_size_N2_He.mat')
load('N2_He\pressure_N2_He.mat')
avg_He = avg_bubble_size(1:5:end);
pressure_He = pressure_cam;

load('N2_N2\avg_bubble_size_N2_N2_70')
load('N2_N2\pressure_N2_N2.mat')
avg_N2 = avg_bubble_size(1:5:end);
pressure_N2 = pressure_cam;

% Plotting data
pixel_size = 68.18;
dx = 40;
plot(pressure_He(1:dx:end),avg_He(1:dx:end)*pixel_size,'kx','MarkerSize',6,'LineWidth',2)
hold on
plot(pressure_N2(1:dx:end),avg_N2(1:dx:end)*pixel_size,'ko','MarkerSize',6,'LineWidth',2)

xlabel('Pressure [bar]')
ylabel('<D_{eq}> [\mum]')
set(gca, 'XDir','reverse')

legend('He','N2','Location','NorthWest')
axis([0 35 0 200]);
yticks([0:50:300]);
set(gca,'FontSize',14)

