clear all
close all
clc

%% Plotting average bubble size for N2 experiments
load('CO2_30bar\avg_bubble_size_CO2_30bar.mat')
load('CO2_30bar\pressure_CO2_30bar.mat')
avg_30 = avg_bubble_size(1:5:end);
pressure_30 = pressure_cam;

load('CO2_100bar\avg_bubble_size_CO2_100bar.mat')
load('CO2_100bar\avg_bubble_size_CO2_100bar.mat')
avg_100 = avg_bubble_size(1:5:end);
pressure_100 = pressure_cam;

% Plotting data
pixel_size = 68.18;
dx = 30;
plot(pressure_30(1:dx:end),avg_30(1:dx:end)*pixel_size,'kx','MarkerSize',6,'LineWidth',2)
hold on
plot(pressure_100(1:dx:end),avg_100(1:dx:end)*pixel_size,'ko','MarkerSize',6,'LineWidth',2)

xlabel('Pressure [bar]')
ylabel('<D_{eq}> [\mum]')
set(gca, 'XDir','reverse')

legend('30 bar','100 bar','Location','NorthWest')
axis([0 30 0 300]);
yticks([0:50:300]);
set(gca,'FontSize',14)

