clear all
close all
clc

% Load data on number of bubbles and pressure from respective files
load('CO2_100bar_40degC\nBubbles_CO2_100_40.mat')
load('CO2_100bar_40degC\pressure_CO2_100_40.mat')
nB_40 = nBubbles(1:5:end);
pressure_40 = pressure_cam;

load('CO2_100bar_40degC_lowerrate\nBubbles_CO2_100_40_lowerrate.mat')
load('CO2_100bar_40degC_lowerrate\pressure_CO2_100_40_lowerrate.mat')
nB_40_lr = nBubbles(1:5:end);
pressure_40_lr = pressure_cam;

load('CO2_100bar_60degC\nBubbles_CO2_100_60.mat')
load('CO2_100bar_60degC\pressure_CO2_100_60.mat')
nB_60 = nBubbles(1:5:end);
pressure_60 = pressure_cam;

load('CO2_100bar_60degC_lowerrate\nBubbles_CO2_100_60_lowerrate.mat')
load('CO2_100bar_60degC_lowerrate\pressure_CO2_100_60_lowerrate.mat')
nB_60_lr = nBubbles(1:5:end);
pressure_60_lr = pressure_cam;

load('CO2_100bar_100degC\nBubbles_CO2_100_100.mat')
load('CO2_100bar_100degC\pressure_CO2_100_100.mat')
nB_100 = nBubbles(1:5:end);
pressure_100 = pressure_cam;

load('CO2_100bar_100degC_lowerrate\nBubbles_CO2_100_100_lowerrate.mat')
load('CO2_100bar_100degC_lowerrate\pressure_CO2_100_100_lowerrate.mat')
nB_100_lr = nBubbles(1:5:end);
pressure_100_lr = pressure_cam;

% Set interval of number of points to be plotted to maintain clear graphs
dx = 30;

% Plot data
subplot(1,3,1)
plot(pressure_40(1:dx:end),nB_40(1:dx:end),'kx','MarkerSize',6,'LineWidth',2)
hold on
plot(pressure_40_lr(1:dx:end),nB_40_lr(1:dx:end),'ks','MarkerSize',6,'LineWidth',2)
xlabel('Pressure [bar]')
ylabel('No. of bubbles')
set(gca, 'XDir','reverse')
legend('high rate','low rate','Location','NorthWest')
axis([0 30 0 200]);
set(gca,'FontSize',14)
title('40 °C')

subplot(1,3,2)
plot(pressure_60(1:dx:end),nB_60(1:dx:end),'kx','MarkerSize',6,'LineWidth',2)
hold on
plot(pressure_60_lr(1:dx:end),nB_60_lr(1:dx:end),'ks','MarkerSize',6,'LineWidth',2)
xlabel('Pressure [bar]')
ylabel('No. of bubbles')
set(gca, 'XDir','reverse')
legend('high rate','low rate','Location','NorthWest')
axis([0 30 0 200]);
set(gca,'FontSize',14)
title('60 °C')

subplot(1,3,3)
plot(pressure_100(1:dx:end),nB_100(1:dx:end),'kx','MarkerSize',6,'LineWidth',2)
hold on
plot(pressure_100_lr(1:dx:end),nB_100_lr(1:dx:end),'ks','MarkerSize',6,'LineWidth',2)
xlabel('Pressure [bar]')
ylabel('No. of bubbles')
set(gca, 'XDir','reverse')
legend('high rate','low rate','Location','NorthWest')
axis([0 30 0 200]);
set(gca,'FontSize',14)
title('100 °C')