clear all
close all
clc

% Load data on number of bubbles and pressure from respective files

%% 40 °C data
load('CO2_30bar_40degC\nBubbles_CO2_30_40.mat')
load('CO2_30bar_40degC\pressure_CO2_30_40.mat')
nB_30_40 = nBubbles(1:5:end);
pressure_30_40 = pressure_cam;

load('CO2_30bar_40degC_new_cell\nBubbles_CO2_30_40.mat')
load('CO2_30bar_40degC_new_cell\pressure_CO2_30_40.mat')
nB_30_40_nc = nBubbles(1:5:end);
pressure_30_40_nc = pressure_cam;

load('CO2_100bar_40degC\nBubbles_CO2_100_40.mat')
load('CO2_100bar_40degC\pressure_CO2_100_40.mat')
nB_100_40 = nBubbles(1:5:end);
pressure_100_40 = pressure_cam;

load('CO2_100bar_40degC_new_cell\nBubbles_CO2_100_40.mat')
load('CO2_100bar_40degC_new_cell\pressure_CO2_100_40.mat')
nB_100_40_nc = nBubbles(1:5:end);
pressure_100_40_nc = pressure_cam;

%% 60 °C data
load('CO2_30bar_60degC\nBubbles_CO2_30_60.mat')
load('CO2_30bar_60degC\pressure_CO2_30_60.mat')
nB_30_60 = nBubbles(1:5:end);
pressure_30_60 = pressure_cam;

load('CO2_30bar_60degC_new_cell\nBubbles_CO2_30_60.mat')
load('CO2_30bar_60degC_new_cell\pressure_CO2_30_60.mat')
nB_30_60_nc = nBubbles(1:5:end);
pressure_30_60_nc = pressure_cam;

load('CO2_100bar_60degC\nBubbles_CO2_100_60.mat')
load('CO2_100bar_60degC\pressure_CO2_100_60.mat')
nB_100_60 = nBubbles(1:5:end);
pressure_100_60 = pressure_cam;

load('CO2_100bar_60degC_new_cell\nBubbles_CO2_100_60.mat')
load('CO2_100bar_60degC_new_cell\pressure_CO2_100_60.mat')
nB_100_60_nc = nBubbles(1:5:end);
pressure_100_60_nc = pressure_cam;

%% 100 °C data
load('CO2_30bar_100degC\nBubbles_CO2_30_100.mat')
load('CO2_30bar_100degC\pressure_CO2_30_100.mat')
nB_30_100 = nBubbles(1:5:end);
pressure_30_100 = pressure_cam;

load('CO2_30bar_100degC_new_cell\nBubbles_CO2_30_100.mat')
load('CO2_30bar_100degC_new_cell\pressure_CO2_30_100.mat')
nB_30_100_nc = nBubbles(1:5:end);
pressure_30_100_nc = pressure_cam;

load('CO2_100bar_100degC\nBubbles_CO2_100_100.mat')
load('CO2_100bar_100degC\pressure_CO2_100_100.mat')
nB_100_100 = nBubbles(1:5:end);
pressure_100_100 = pressure_cam;

load('CO2_100bar_100degC_new_cell\nBubbles_CO2_100_100.mat')
load('CO2_100bar_100degC_new_cell\pressure_CO2_100_100.mat')
nB_100_100_nc = nBubbles(1:5:end);
pressure_100_100_nc = pressure_cam;

% Set interval of number of points to be plotted to maintain clear graphs
dx = 30;

% Plot data
subplot(1,3,1)
plot(pressure_30_40(1:dx:end),nB_30_40(1:dx:end),'kx','MarkerSize',6,'LineWidth',2)
hold on
plot(pressure_30_40_nc(1:dx:end),nB_30_40_nc(1:dx:end),'ks','MarkerSize',6,'LineWidth',2)
plot(pressure_100_40(1:dx:end),nB_100_40(1:dx:end),'ko','MarkerSize',6,'LineWidth',2)
plot(pressure_100_40_nc(1:dx:end),nB_100_40_nc(1:dx:end),'kv','MarkerSize',6,'LineWidth',2)
xlabel('Pressure [bar]')
ylabel('No. of bubbles')
set(gca, 'XDir','reverse')
legend('Old cell - p_{ini} = 30 bar','New cell - p_{ini} = 30 bar','Old cell - p_{ini} = 100 bar','New cell - p_{ini} = 100 bar','Location','NorthWest')
axis([0 40 0 200]);
set(gca,'FontSize',14)
title('40 °C')

subplot(1,3,2)
plot(pressure_30_60(1:dx:end),nB_30_60(1:dx:end),'kx','MarkerSize',6,'LineWidth',2)
hold on
plot(pressure_30_60_nc(1:dx:end),nB_30_60_nc(1:dx:end),'ks','MarkerSize',6,'LineWidth',2)
plot(pressure_100_60(1:dx:end),nB_100_60(1:dx:end),'ko','MarkerSize',6,'LineWidth',2)
plot(pressure_100_60_nc(1:dx:end),nB_100_60_nc(1:dx:end),'kv','MarkerSize',6,'LineWidth',2)
xlabel('Pressure [bar]')
ylabel('No. of bubbles')
set(gca, 'XDir','reverse')
legend('Old cell - p_{ini} = 30 bar','New cell - p_{ini} = 30 bar','Old cell - p_{ini} = 100 bar','New cell - p_{ini} = 100 bar','Location','NorthWest')
axis([0 40 0 200]);
set(gca,'FontSize',14)
title('60 °C')

subplot(1,3,3)
plot(pressure_30_100(1:dx:end),nB_30_100(1:dx:end),'kx','MarkerSize',6,'LineWidth',2)
hold on
plot(pressure_30_100_nc(1:dx:end),nB_30_100_nc(1:dx:end),'ks','MarkerSize',6,'LineWidth',2)
plot(pressure_100_100(1:dx:end),nB_100_100(1:dx:end),'ko','MarkerSize',6,'LineWidth',2)
plot(pressure_100_100_nc(1:dx:end),nB_100_100_nc(1:dx:end),'kv','MarkerSize',6,'LineWidth',2)
xlabel('Pressure [bar]')
ylabel('No. of bubbles')
set(gca, 'XDir','reverse')
legend('Old cell - p_{ini} = 30 bar','New cell - p_{ini} = 30 bar','Old cell - p_{ini} = 100 bar','New cell - p_{ini} = 100 bar','Location','NorthWest')
axis([0 40 0 200]);
set(gca,'FontSize',14)
title('100 °C')