# BioBrAIn Database - an Open CFD Database of Bioreactors

## Overview

This repository contains a curated collection of CFD simulations for various bioreactor configurations. The simulations aim to support research and development in bioprocess engineering by providing detailed flow dynamics, and mixing characteristics under different operating conditions. This information is intended for aiding on the rapid development of surrogate models that enable close-to real-time simulation of fermentations.

## Disclaimer

The CFD simulation cases presented in this repository are purely academic and have been reproduced from publicly available studies. The authors of this repository are not liable for any misuse of the data presented herein. Users are responsible for ensuring that the data is used appropriately and in accordance with relevant regulations and guidelines.
The cases presented here are based on publicly available reactor designs, hence no patent or commercial rights can be derived from them. 

## Contents
```
📁 /case
    ├── 📁 /dp_0
        ├── case/
        ├── data/
        ├── geom/
        ├── mesh/
        ├── results/
        └── 📄 config.json
    ├── 📁 /dp_1
    ├── 📁 /...
    ├── 📄 op_conditions.csv
    ├── 📄 README.md
    └── ...
📁 /docs
    └── simulation_notes/
📄 metadata.csv
📄 LICENSE
📄 README.md
```

## Simulation Details

Each simulation folder includes:

- **Geometry**: CAD files of the bioreactor (i.e., `geom` folder)
- **Mesh**: Spatial discretization of the CAD model (i.e., `mesh` folder)
- **Solver Settings**: Turbulence models, multiphase models, boundary conditions (i.e., `case` folder)
- **Operating Conditions**: Agitation speed, gas flow rate, temperature, etc. (i.e., `config.json` file)
- **CFD-Derived data**: Velocity fields, pressure distribution, gas holdup (when applicable), and turbulence variables. (i.e., `data` folder)

## Metadata

The `config.json` files provide a summary of the model parameters used for each design point, including: 
- `Simulation_ID`
- `Simulation_type`
- `Global variables`
- `Mesh settings`
- `Turbulence model settings`
- `Multiphase model settings`
- `Species transport model settings`

The `op_conditions.csv` files provide a summary of all simulations, including:

- `Simulation_ID`
- `Liquid Height_m`
- `Agitation_RPM`
- `Gas_Flow_Rate_Nm^3/s` (when applicable)

## How to Use

### Requirements

- `ANSYS FLUENT 2024R1 or later`
- `Python 3.11 or later`
- `Paraview 5.12 or later` (for visualization)
- `numpy 2.1.2`
- `pandas 2.2.2`
- `openpyxl 3.1.5`
- `h5py 3.14.0`
- `scikit-learn 1.5.2`
- `scipy 1.14.1`

#### Load data 

CFD-derived data is shared via a `.csv` files that contain variables like: 
- `velocity`: phase-velocity coordinates 
- `gas_fraction`: volume of fraction of the dispersed phase (i.e., gas/air)
- `tubulent_kinetic_energy`
- `energy_dissipation_rate` (for selected cases)

Alternatively, `.dat` files are shared in case other variables to the ones provided via the `.csv` files are needed. These files can be accessed using Ansys Fluent&trade; if it is available. 

#### Visualization

Each `data` folder contains an `.encas` file that links all the `geom` and `scalars` files that allow for rendering the flow fields. Please refer to the appendix of the PDF Manual in this database that outlines the procedure to create renders from the data available. Further information can be found in the [documentation](https://docs.paraview.org/en/latest/index.html) from Paraview. 

## Acknowledgments

The simulations corresponding to the 700 L and Stavanger 22 m³ reactors used the Dutch national e-infrastructure with the support of the SURF Cooperative using grant no. EINF-11590 (Project: *CFD-derived data for surrogate models of bioreactors*). 

Publishing this work was made possible through the support of the FAIR Data Fund 2024 grant awarded by the 4TU.Research Data Repository. We gratefully acknowledge the technical and financial assistance that enables the scientific community to access CFD-derived bioreactor data.

## License 
BioBrAIn: A CFD-database of simulations of bioreactors © 2025 by H. Maldonado, V. Puig I Laborda, M. Naderibeni, & C. Haringa is licensed under CC BY-NC-SA 4.0. To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/

## Citation 

Cite the database as follows: 

Maldonado de Leon, H.<sup>1</sup>, Puig I Laborda, V.<sup>2</sup>, Naderibeni, M.<sup>3</sup>, and C. Haringa<sup>1</sup>. *"BioBrAIn: A CFD Database of Bioreactors"*, [1] Biotechnology department, Delft University of Technology; [2] The Novo Nordisk Foundation Center for Biosustainability, Tehcnical University of Denmark; [3] Pattern Recognition and Bio-informatics Group, Delft University of Technology, 2025, "BioBrAIn: An open CFD Database of Bioreactors". 4TU.Research Data Repository. DOI: [10.4121/b99ff905-7bfa-4d13-a429-e2daad2d7579](10.4121/b99ff905-7bfa-4d13-a429-e2daad2d7579)

## Publications 

List of publications related to this version of the Database

 - **Version 1.0**:
    - Maldonado de Leon, H., Musters, S., Puig I Laborda, V., & C. Haringa. (2026) The more, the merrier? Comparison of compartmentalization strategies. *In preparation*
    - Puig I Laborda, V. 2026. Supervised learning bioreactor regimes. *In preparation*
    - Maldonado de Leon, H., Puig I Laborda, V., Le Nepvou de Carfort, J., Murillo, J. & C. Haringa. 2026. Deep learning bioreactor gradients. *In prepration* 

## Contact

For questions or contributions, please contact: h.a.maldonadodeleon@tudelft.nl or c.haringa@tudelft.nl
