from utils import *

import platform
from datetime import datetime
import uuid

'''
This file contains the overall settings for this programme to run.

First, there is a list of possible actions to be performed, termed ACTIONS. The action space contains exactly maximum_variation elements, from 1 to maximum_variation. It can be conceptualised as the amount of possible "cultures" per position.
In this preliminary version, they are strings 'action1', 'action2', ... that are to be replaced later.

Secondly, a target sequence is generated by defining a target_length, and subsequently randomly choosing a number between 3 and maximum_variation+1 for each position in the sequence. This sequence is termed target. 

Thirdly, for population management, we define the population size and the amount of generations to be run. There's also the SELECTION_STRATEGY, which is a function that takes a list of candidates and returns a list of two candidates, which are the parents to be used for the next generation.
'''

SEPARATOR = ";"
MINIMISATION = True # Whether to minimise or maximise the fitness function
RECORDING = False # Whether to record the evolution process
VISUALISATION = False # Whether to visualise the evolution process (fitness over time)
CLEAN_UP = True # Whether or not to remove the _gen* files created and just save the final data frame

# Hyperparameters for the model and evolution
ACTIONS = [
    "update_status_product",
    "update_awareness_list",
    "update_complexity",
    "update_compatiblity",
    "update_relative_advantage",
    "update_households_with_without_product_encountered",
    "update_memory_minimum_time_between_2_decisions_ON",
    "setup_interactions_neighbors",
    "setup_interactions_random",
    "check_for_awareness_of_interactions",
    "receive_information_from_interactions",
    "make_final_judgment_enough_information",
    "evaluation_relative_advantage_product",
    "evaluation_complexity",
    "evaluation_compatibility",
    "evaluation_observability_triability",
    "final_judgement_evaluation",
    "for_monitoring", # automatically added at the end
    "neighborlinks_die",
    "randomlinks_die",
    # "tick" # automatically added at the end
    ]
ACTIONS_STANDARD_BEGIN = ["set temp_name13 new-seed", "random-seed temp_name13"]
ACTIONS_STANDARD_END = ["tick"]
ACTIONS_MANDATORY_BEGIN = []
ACTIONS_MANDATORY_END = []
ACTIONS_MANDATORY = []

# Quality and validity checks
lists = [ACTIONS, ACTIONS_MANDATORY_BEGIN, ACTIONS_MANDATORY_END, ACTIONS_MANDATORY]
assert all(len(lst) == len(set(lst)) for lst in lists), "Duplicates found in one of the lists"
assert not any(set(lst1) & set(lst2) for i, lst1 in enumerate(lists) for lst2 in lists[i+1:]), "Overlap found between lists"

MODEL_NAME = "Model_diffusion_innovations_v4"
MAXIMUM_LENGTH = len(ACTIONS) # Maximum length of a sequence
MINIMUM_LENGTH = MAXIMUM_LENGTH - 4
assert MINIMUM_LENGTH <= MAXIMUM_LENGTH - len(ACTIONS_MANDATORY), (
    f"MINIMUM_LENGTH must be less than or equal to MAXIMUM_LENGTH - len(ACTIONS_MANDATORY). "
    f"Got MINIMUM_LENGTH = {MINIMUM_LENGTH}, MAXIMUM_LENGTH = {MAXIMUM_LENGTH}, "
    f"len(ACTIONS_MANDATORY) = {len(ACTIONS_MANDATORY)}"
)

MAXIMUM_VARIATION = len(ACTIONS) # Amount of possible "cultures" per position
AMOUNT_OF_PARAMETERS = 1
SELECTION_OF_PARAMETERS = "random" # nothing else implemented yet
NUMBER_OF_RUNS = 2
ALL_PARAMETERS_DICT_LIST = import_parameters(MODEL_NAME)
if ALL_PARAMETERS_DICT_LIST == None:    
    print("Could parameters could be imported within time limit. Run create_parameters_file.py yourself...")
    exit()
RUN_PARAMETERS_DICT_LIST = select_run_parameters(ALL_PARAMETERS_DICT_LIST, AMOUNT_OF_PARAMETERS, SELECTION_OF_PARAMETERS)
NETLOGO_HOME = None if platform.system() != 'Linux' else get_netlogo_home()
JVMARGS = [
        '-Djava.awt.headless=true', # run Java in headless mode
        '-Xms128M', # set heap space to 2GB
        '-Xmx256M', # limit heap space to 4GB
        '-Dfile.encoding=UTF-8', # set character encoding
        # '-XX:+UseG1GC', # use G1 garbage collector
        ]

TIMESTAMP = datetime.now().strftime("%Y_%m_%d_%H_%M")
UUID = uuid.uuid4()
RUN_ID = f"{TIMESTAMP}_{UUID}"
SAVE_FORMAT = "CSV" # Choose between CSV and XLSX
# Target sequence # To be changed later to the data.
# target_length = 8 # Length of the target sequence
# target = random.choices(ACTIONS, k=target_length)  # Randomly generate a target sequence, allowing multiple occurrences of the same action
# TO BE REPLACED BY THIS:
TARGET = [0.5, 0,6, 0.43, 0.55, 0.65, 0.7, 0.8, 0.9, 0.95, 1.0]

TRAINING_COLUMNS = ["actions_before", "mutation_type", "action", "index", "second_index"]
REPORTER_LIST = ["number_of_households_owning_product_1"]
if len(REPORTER_LIST) > 1:
    print("WARNING: More than one reporter variable while code currently only supports only one. Selecting merely the first...")
    REPORTER_LIST = [REPORTER_LIST[0]]
    REPORTER = REPORTER_LIST[0]
elif len(REPORTER_LIST) == 1:
    REPORTER = "number_of_households_owning_product_1"
TICK_LIMIT = 30

# Population Management
POPULATION_SIZE = 2 # Number of candidates in the population
GENERATIONS = 3  # Number of generations to run

# Abstract Mutator
N_FEATURES_HASHING = 2**5  # Number of features to use in the hashing function

# Random Mutator
# Nothing to configure

# Forest Mutator
N_ESTIMATORS_FOREST = 2**8  # Number of trees in the forest
MIN_SAMPLES_SPLIT = 2  # Minimum number of samples required to split an internal node
WEIGHTED_FOREST = False  # Whether to use weighted samples in the forest

# Bayesian Mutator
KERNEL_LOWER, KERNEL_UPPER = 1e-1, 1e5  # Bounds for the length scale of the Matern kernel
N_RESTARTS_OPTIMIZER = 15  # Number of restarts for GP optimizer.
MATERN_NU = 1.5  # Smoothness parameter for Matern kernel.
ACQUISITION_FUNCTION = "EI"  # Expected Improvement. Alternatives: "PI", "UCB"
ACQUISITION_PARAMETER = 0.01  # Parameter for the acquisition function.
ALPHA = 1e-10  # Numerical stability in the GP model.
KAPPA = 1.96  # Controls the exploration-exploitation trade-off for UCB.
