import re
import os
os.chdir(os.path.dirname(os.path.realpath(__file__)))

#####################################################################

file_path = 'Model_diffusion_innovations_v4.nlogo'

#####################################################################

model_name = file_path.split('/')[-1].split('.')[0]

with open(file_path, 'r') as file:
    model_content = file.read()

# Use the content previously read from the .nlogo file to parse parameters
def parse_netlogo_parameters(model_content):
    variable_definitions = re.split(r"\n\n+", model_content)
    parameter_space = {}
    
    def parse_and_use_linspace(definition):
        lines = definition.strip().split("\n")
        if "SLIDER" in lines[0]:
            start = float(lines[7].strip())
            stop = float(lines[8].strip())
            step = float(lines[10].strip())
            num_points = int((stop - start) / step + 1)  # calculate number of points for linspace
            print(start, stop, step, num_points)
            linspace_expression = f"np.linspace({start}, {stop}, {num_points})"
            return linspace_expression
        return None

    for definition in variable_definitions:
        if "SLIDER" in definition:
            lines = definition.strip().split("\n")
            slider_name = lines[6].strip()
            slider_range = parse_and_use_linspace(definition)
            if slider_range:
                parameter_space[slider_name] = slider_range
        elif "SWITCH" in definition:
            lines = definition.strip().split("\n")
            switch_name = lines[5].strip()
            parameter_space[switch_name] = "[False, True]"

    return parameter_space

parameters = parse_netlogo_parameters(model_content)

# Generating Python code from the dictionary
parameters_py = "\n".join([f"\"{key}\" : {value}," for key, value in parameters.items()])

# Save to a Python file
model_name = os.path.splitext(os.path.basename(file_path))[0]
filename = f"{model_name}_parameters.py"
with open(filename, 'w') as file:
    file.write("import numpy as np\n")
    file.write("parameters_dict = {")
    file.write(parameters_py)
    file.write("\n}")