# Guessing-structures

This is the repository for the paper I presented at the Social Simulation Conference in Krakow 2024 and for the paper in the Journal of Artificial Societies and Social Simulation. I'm happy to share more information about the paper or code upon request via [l.m.schubotz@tudelft.nl](mailto:l.m.schubotz@tudelft.nl).

## Repository Structure
An effort has been made to use self-explanatory variable names and file names. If any questions or unclarities remain or errors are encountered, the author is grateful for a brief message.

Provided in this repository is the code for a Python wrapper for a Netlogo simulation (folder src), the documentation (folder docs) as .html, created using Sphinx, and the data analysis folder.

## How To Use

1. Clone the repository.
2. Install all necessary dependencies ...
 - creating an environment is recommended, e.g. as laid out [here](https://packaging.python.org/en/latest/guides/installing-using-pip-and-virtual-environments/)
 - using `pip`: (Ideally, create and activate an environment and) run `pip install -r requirements.txt`.  In case of problems, be sure to upgrade `pip` and `setuptools` and try again. 
 - using `poetry`:  run `poetry install` (check using `poetry check`). Enter the environment using `poetry shell`

    Python version 3.9 or higher is necessary to run the code.

3. Include a Netlogo model in the folder 'model' as a subfolder of 'src' or use the model that we utilised.
4. Put one .txt file of data in the folder 'model_target_data' as a subfolder of 'src'. Note that no target data is given per default. Note that the code does currently not handle multiple target data files.
5. Run main.py.

## Licensing Information
The repository's license is Apache 2.0. Please note the specifications in the following licensing information!
Licensed under the Apache License, Version 2.0 (the "License"), you may not use this file except in compliance with the License. You may obtain a copy of the License at: http://www.apache.org/licenses/LICENSE-2.0

In simple words, you have to:

- Include a copy of the Apache 2.0 license in any distribution of this project.
- Provide attribution by acknowledging the original authorship in your documentation and, if possible, in the source files. Include a link to the original GitLab repository: https://gitlab.tudelft.nl/lschubotz/structural-sculpting/.
- Indicate any changes made to the original files, noting the modifications and who made them.

Do not use the names of the original authors or contributors to endorse or promote your derived products without specific prior written permission!


## Data
The data used for this paper is licensed under the Creative Commons Attribution ShareAlike 4.0 License (CC BY-SA 4.0). It has been sourced from [...]. The script producing the data that eventually went into the model as well as the data itself is available in a 4TU repository via [...].

## How to Cite
The paper can be cited as follows:
Schubotz, L.,  Chappin, E., Scholz, G. (2024). Structural Sculpting: Making Inverse Modelling Generate and Deal with Flexible Structures. Journal of Artificial Societies and Social Simulation. URL: https://gitlab.tudelft.nl/lschubotz/structural-sculpting/ DOI:

## Known Errors
My personal motto is: "Code can never be perfect, it will always have the problem of being code."
In this spirit, a list of known errors is provided below. Users sharing problems they run into is greatly appreciated. Pkease make sure you've installed and updated Java and your package manager (`pip >= 21.0` is recommended). When reporting an error, please mention your machine, Python version, and give the full error message.

### Warning: Could not get charToByteConverterClass!
This seems to be a Java problem that does not impact performance except for sometimes restarting the population initialisation. Please be aware of this little "teething problem" when running the model.