;extensions [profiler]
Breed [households household]


Undirected-link-breed [neighborlinks neighborlink]
Undirected-link-breed [friendlinks friendlink]
Undirected-link-breed [randomlinks randomlink]


Globals [
  ; Globals constants
  number_of_households_not_participating


  ; product globals
  household_product_colors
  product_lifecycle
  product_initial_cost
  Not_smart_product_ initial_cost
  complexity
  number_of_product_switched_on
  product_list

  Current_relative_advantage_product_1
  Current_relative_advantage_product_2
  Current_relative_advantage_product_3
  Current_relative_advantage_product_4
  Current_complexity_product_1
  Current_complexity_product_2
  Current_complexity_product_3
  Current_complexity_product_4
  Current_compatibility_product_1
  Current_compatibility_product_2
  Current_compatibility_product_3
  Current_compatibility_product_4

  number_of_households_owning_product_1
  number_of_households_owning_product_2
  number_of_households_owning_product_3
  number_of_households_owning_product_4
  number_of_households_not_owning_product
  number_of_households_aware

  ; Adopter specific globals (A_ S_L_ stands for Adopter Specific Lists)
  A_S_L_Minimum_time_between_2_decision_making
  A_S_L_Unique_interaction
  A_S_L_Combined_interaction_short
  A_S_L_Combined_interaction_long
  A_S_L_Amount_neighbor_interactions
  A_S_L_Amount_friend_interactions
  A_S_L_Amount_random_interactions
  A_S_L_awareness_threshold
  Innovator_critical_information_list
  Early_adopter_critical_information_list
  Early_majority_critical_information_list
  Late_majority_critical_information_list
  Laggard_critical_information_list
  A_S_L_preferred_information_source_innovator
  A_S_L_preferred_information_source_early_adopter
  A_S_L_preferred_information_source_early_majority
  A_S_L_preferred_information_source_late_majority
  A_S_L_preferred_information_source_laggard
  A_S_L_Max_complexity_tolerated
  A_S_L_Max_compatibility_tolerated
  A_S_L_Max_relative_advantage_tolerated
  A_S_L_Max_observability_triability_tolerated

  A_S_L_preferred_information_source_innovator_1
  A_S_L_preferred_information_source_innovator_2
  A_S_L_preferred_information_source_innovator_3
  A_S_L_preferred_information_source_innovator_4
  A_S_L_preferred_information_source_innovator_5
  A_S_L_preferred_information_source_early_adopter_1
  A_S_L_preferred_information_source_early_adopter_2
  A_S_L_preferred_information_source_early_adopter_3
  A_S_L_preferred_information_source_early_adopter_4
  A_S_L_preferred_information_source_early_adopter_5
  A_S_L_preferred_information_source_early_majority_1
  A_S_L_preferred_information_source_early_majority_2
  A_S_L_preferred_information_source_early_majority_3
  A_S_L_preferred_information_source_early_majority_4
  A_S_L_preferred_information_source_early_majority_5
  A_S_L_preferred_information_source_late_majority_1
  A_S_L_preferred_information_source_late_majority_2
  A_S_L_preferred_information_source_late_majority_3
  A_S_L_preferred_information_source_late_majority_4
  A_S_L_preferred_information_source_late_majority_5
  A_S_L_preferred_information_source_laggard_1
  A_S_L_preferred_information_source_laggard_2
  A_S_L_preferred_information_source_laggard_3
  A_S_L_preferred_information_source_laggard_4
  A_S_L_preferred_information_source_laggard_5

  ;monitoring
  percentage_of_households_aware
  list_new_households_with_products
  list_new_households_aware
  list_new_households_with_enough_information
  list_new_households_with_evaluation_OK
  list_new_households_with_complexity_OK
  new_households_aware
  new_households_with_product
  new_households_with_enough_information
  new_households_with_evaluation_OK
  new_households_with_complexity_OK
  new_households_aware_stat
  new_households_with_enough_information_stat
  new_households_with_evaluation_OK_stat
  new_households_with_complexity_OK_stat
  new_households_with_product_stat
  percentage_of_innovators_with_products
  percentage_of_early_adopters_with_products
  percentage_of_early_majority_with_products
  percentage_of_late_majority_with_products
  percentage_of_laggards_with_products
  savings_made_by_last_adopters
  savings_made_by_last_adopters_list
  percentage_of_households_owning_product
  block_at_complexity_early_adopters_percentage
  early_adopters_just_accepted

  households_with_whom_interacted_c1
  households_with_whom_interacted_c2
  households_with_whom_interacted_c3
  households_with_whom_interacted_c4
  households_with_whom_interacted_c5
  threshold_to_reach_for_weights_information
  threshold_to_reach_for_weights_information_1
  threshold_to_reach_for_weights_information_2
  threshold_to_reach_for_weights_information_3
  threshold_to_reach_for_weights_information_4
  threshold_to_reach_for_weights_information_5

  ;temp
  filename_1
  data_1
  number-of-columns_1
  filename_2
  number-of-columns_2
  adopter_colours
  temp_for_creation_adopter_properties
  temp_for_creation_scenario_properties
  temp_for_creation_preferred_information_properties
  scenario_specific_list
  temp_name
  temp_name2
  temp_name3
  temp_name4
  temp_name5
  temp_name6
  temp_name7
  temp_name8
  temp_name9
  temp_name10
  temp_name11
  temp_name12
  temp_name13
  temp_name14
  temp_name15
  multiplication_SD

  products_switched_on
]


Households-own [
  Household_number
  Adopter_category
  Category_number
  is_aware_product_1
  is_aware_product_2
  is_aware_product_3
  is_aware_product_4
  Decision_making_status_list_product_1
  Decision_making_status_list_product_2
  Decision_making_status_list_product_3
  Decision_making_status_list_product_4
  Minimum_time_between_2_decision_making
  Amount_neighbor_interactions
  Amount_friend_interactions
  Amount_random_interactions
  product_awareness_process_product_1
  product_awareness_process_product_2
  product_awareness_process_product_3
  product_awareness_process_product_4
  My_product_awareness_threshold
  My_critical_information_list
  My_experience_information_list
  My_experience_information_list_product_1
  My_experience_information_list_product_2
  My_experience_information_list_product_3
  My_experience_information_list_product_4
  Preferred_information_source

  knowledge_of_complexity_product_1
  knowledge_of_complexity_product_2
  knowledge_of_complexity_product_3
  knowledge_of_complexity_product_4
  knowledge_of_compatibility_product_1
  knowledge_of_compatibility_product_2
  knowledge_of_compatibility_product_3
  knowledge_of_compatibility_product_4
  knowledge_of_relative_advantage_product_1
  knowledge_of_relative_advantage_product_2
  knowledge_of_relative_advantage_product_3
  knowledge_of_relative_advantage_product_4

  knowledge_complexity_list_product_1
  knowledge_complexity_list_product_2
  knowledge_complexity_list_product_3
  knowledge_complexity_list_product_4
  knowledge_compatibility_list_product_1
  knowledge_compatibility_list_product_2
  knowledge_compatibility_list_product_3
  knowledge_compatibility_list_product_4
  knowledge_relative_advantage_list_product_1
  knowledge_relative_advantage_list_product_2
  knowledge_relative_advantage_list_product_3
  knowledge_relative_advantage_list_product_4

  my_product

  ; temp
  my_list_of_neighbors
  my_list_of_friends
  my_list_of_random_interactions
  amount_of_friends_I_still_need
  amount_of_neighbor_interactions_I_still_need
  amount_of_random_interactions_I_still_need
  households_with_whom_interacted

  list_households_without_product_encountered_product_1
  list_households_without_product_encountered_product_2
  list_households_without_product_encountered_product_3
  list_households_without_product_encountered_product_4
  list_households_without_product_encountered_after_pruchase_product_1
  list_households_without_product_encountered_after_pruchase_product_2
  list_households_without_product_encountered_after_pruchase_product_3
  list_households_without_product_encountered_after_pruchase_product_4
  list_households_with_product_encountered_product_1
  list_households_with_product_encountered_product_2
  list_households_with_product_encountered_product_3
  list_households_with_product_encountered_product_4

  final_evaluation_product_1
  final_evaluation_product_2
  final_evaluation_product_3
  final_evaluation_product_4
  delay_before_new_decision_product_1
  delay_before_new_decision_product_2
  delay_before_new_decision_product_3
  delay_before_new_decision_product_4

  ;for monitoring
  awareness_step_done_product_1
  awareness_step_done_product_2
  awareness_step_done_product_3
  awareness_step_done_product_4
  information_step_done_product_1
  information_step_done_product_2
  information_step_done_product_3
  information_step_done_product_4
  evaluation_step_done_product_1
  evaluation_step_done_product_2
  evaluation_step_done_product_3
  evaluation_step_done_product_4
]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;       SETUP      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to setup
 ; profiler:start
  Clear-all
  Reset-ticks
  read-data                                              ; Firt, data of (500) households is imported, incl. their adopter categories
  setup_adopter_specific_data                            ; Here each adopters are given different properties (e.g. amount of interactions, specific requirement before a product can be adapted or color on the visualisation interface)
  setup_households_from_data                             ; Then each adopters properties are given to households according to the adopter category to which they belong
  setup_decision_making_list                             ; Each households is assigned a decision-making list that contains the decision making steps and the extent whether they are fulfilled satisfyingly. If each step is equal to one, the product is adopted.
  setup_relevant_data_and_lists_to_households            ; Others lists and setup data are given to each household
  setup_links                                            ; households setup their neighbors and friends                                        ; products are created from the data imported in "read_data"
  setup_initial_environment                              ; initial environment is created, incl. product development curves (based on their learning curves)
end

to read-data
  ;first data households
  set filename_1 "Dataset_of_agents.txt"
  set number-of-columns_1 5

  set data_1 []
  let line_1 []
  let input-item_1 0

  file-open filename_1
  repeat number-of-columns_1 [set input-item_1 file-read]

  while [not file-at-end?] [
    set line_1 []
    repeat number-of-columns_1 [
      if not file-at-end? [
        set input-item_1 file-read
        set line_1 lput input-item_1 line_1
      ]
    ]
    set data_1 lput line_1 data_1
  ]
  file-close

;  show (word length data_2 " products read in.")
end


to setup_adopter_specific_data

  ;minimum time between 2 decision makings process
  set A_S_L_Minimum_time_between_2_decision_making [[1 3] [2 5] [3 6] [4 8] [5 11]]

  ;adopter colours
  set adopter_colours [[1 65] [2 75] [3 85] [4 95] [5 105]]

  ;amount of interaction with other households
  set A_S_L_Unique_interaction [[1 9] [2 7] [3 6] [4 4] [5 3]]
  set A_S_L_Combined_interaction_short [[1 4] [2 3] [3 3] [4 2] [5 1]]
  set A_S_L_Combined_interaction_long [[1 4] [2 4] [3 3] [4 2] [5 2]]

  ;A_S_L_awareness_threshold
  set A_S_L_awareness_threshold [[1 1] [2 1] [3 1] [4 1] [5 1]]

  ;adopter's_critical_information_list
  set Innovator_critical_information_list [0 0 0]
  set Early_adopter_critical_information_list [1 0 1]
  set Early_majority_critical_information_list [1 1 1]
  set Late_majority_critical_information_list [1 1 1]
  set Laggard_critical_information_list [1 1 1]

  ;A_S_L_preferred_information_source
  set A_S_L_preferred_information_source_innovator [0.4 0 0 0 0]
  set A_S_L_preferred_information_source_early_adopter [0.4 0.3 0 0 0]
  set A_S_L_preferred_information_source_early_majority [0.1 0.5 0.2 0 0]
  ;set A_S_L_preferred_information_source_early_majority [0.1 0.8 0.2 0 0]
  set A_S_L_preferred_information_source_late_majority [0.05 0.5 0.2 0.2 0.2]
  set A_S_L_preferred_information_source_laggard [0 0.5 0.2 0.2 0.2]

  ;A_S_L_Max_relative_advantage_tolerated
  set A_S_L_Max_relative_advantage_tolerated [[1 3] [2 2] [3 1] [4 1] [5 1]]

  ;A_S_L_Max_complexity_tolerated
  set A_S_L_Max_complexity_tolerated [[1 3] [2 2] [3 1] [4 1] [5 1]]

  ;A_S_L_Max_compatibility_tolerated
  set A_S_L_Max_compatibility_tolerated [[1 3] [2 2] [3 1] [4 1] [5 1]]

  ;A_S_L_Max_compatibility_tolerated
  set A_S_L_Max_observability_triability_tolerated [[1 3] [2 2] [3 1] [4 1] [5 1]]

  ;threshold_to_reach_for_weights_information
  set threshold_to_reach_for_weights_information [[1 0.2] [2 0.5] [3 0.8] [4 0.8] [5 0.8]]

  ; create import files for that
  set A_S_L_preferred_information_source_innovator_1 0.4



  set A_S_L_preferred_information_source_innovator_2 0
  set A_S_L_preferred_information_source_innovator_3 0
  set A_S_L_preferred_information_source_innovator_4 0
  set A_S_L_preferred_information_source_innovator_5 0
  set A_S_L_preferred_information_source_early_adopter_1 0.4
  set A_S_L_preferred_information_source_early_adopter_2 0.3
  set A_S_L_preferred_information_source_early_adopter_3 0
  set A_S_L_preferred_information_source_early_adopter_4 0
  set A_S_L_preferred_information_source_early_adopter_5 0
  set A_S_L_preferred_information_source_early_majority_1 0.1
  set A_S_L_preferred_information_source_early_majority_2 0.5
  set A_S_L_preferred_information_source_early_majority_3 0.2
  set A_S_L_preferred_information_source_early_majority_4 0
  set A_S_L_preferred_information_source_early_majority_5 0
  set A_S_L_preferred_information_source_late_majority_1 0.05
  set A_S_L_preferred_information_source_late_majority_2 0.5
  set A_S_L_preferred_information_source_late_majority_3 0.2
  set A_S_L_preferred_information_source_late_majority_4 0.2
  set A_S_L_preferred_information_source_late_majority_5 0.2
  set A_S_L_preferred_information_source_laggard_1 0
  set A_S_L_preferred_information_source_laggard_2 0.5
  set A_S_L_preferred_information_source_laggard_3 0.2
  set A_S_L_preferred_information_source_laggard_4 0.2
  set A_S_L_preferred_information_source_laggard_5 0.2
end

to setup_households_from_data
  let number_households (length data_1)
  create-households number_households
  let f 0

  while [f < (length data_1)][
    ask household f [
      let g 0
      while [g < (length data_1)][
        if (f + 1) = (item 0 (item g data_1))
        [set Household_number ((item 0 (item g data_1)))
          ;print household_number
          Ifelse Switch_all_same_category = TRUE [set Category_number 3][set Category_number (item 1 (item g data_1))]
          set My_product (item 4 (item g data_1))
          ]
        set g g + 1
      ]
    ]set f f + 1]


  let aa 1
  while [aa <= 4] [
    ask households [
      if runresult (word "Switch_product_"aa) = False and My_product = aa [set My_product  0]]
  set aa aa + 1]

  set products_switched_on []
  let aba 1
  while [aba <= 4]
  [if runresult (word "Switch_product_"aba) = True [set products_switched_on lput aba products_switched_on]
    set aba aba + 1]


  ; here we set the location
  let a min-pxcor
  let b min-pycor
  let c 0
  ask households [
    set shape "house"
    set size 0.7
    set xcor a
    set ycor b
    setxy xcor ycor

    if a = max-pxcor [
      set a min-pxcor - 1
      set b b + 1]
    set a a + 1]

  ; here we set the colours depending on adopter category and availability of a product
  set household_product_colors [black red green blue yellow] ; black stands for having no product, yellow for product 1, green for product 2, blue for product 3, red for product for

  ask households [
    let d 0
    While [d < 5][
      if (Category_number = (item 0 (item d adopter_colours)))
        [ set pcolor (item 1 (item d adopter_colours))
          set color item My_product household_product_colors
          ]
      set d d + 1]]
end

to   setup_decision_making_list
  ; set-up the decision making list
  ; The structure of the list is the following:
  ; (1 (have_app just_have_considered awareness)) (2 (experience_info_OK)) (3 (expected_savings_OK risks_investment_OK Social_recognition_OK Risk_data_leak_OK reliability_OK)) (4 (complexity_OK))
  ; each variable is determined by 0 or 1. 1 means that the step/fact is accepted by the household.
  ; one list is created for each product

  ask households [

    set products_switched_on shuffle products_switched_on
    foreach products_switched_on [ ? ->
    run (word "set Decision_making_status_list_product_"?" [[1 [0 0]] [2 [0]] [3 [0 0 0 0]]]")
    run (word "set My_experience_information_list_product_"?" [0 0 0]")
    run (word "set is_aware_product_"?" 0")

    if My_product != 0
    [run (word "set Decision_making_status_list_product_"My_product" [[1 [1 1]] [2 [1]] [3 [1 1 1 1]]]")
      run (word "set My_experience_information_list_product_"My_product" [0 0 0]")
      run (word "set is_aware_product_"My_product" 1")
    ]]]
end

to setup_relevant_data_and_lists_to_households

  ;here wil will provide the thresholds to each individual household
  ask households [
    let h 0
    while [h < length A_S_L_awareness_threshold][
      if item 0 (item h A_S_L_awareness_threshold) = Category_number [
        set My_product_awareness_threshold (item 1 (item h A_S_L_awareness_threshold))]
      set h h + 1]]

  ask households [
    set product_awareness_process_product_1 []
    set product_awareness_process_product_2 []
    set product_awareness_process_product_3 []
    set product_awareness_process_product_4 []

    if Category_number = 1 [set My_critical_information_list Innovator_critical_information_list]
    if Category_number = 2 [set My_critical_information_list Early_adopter_critical_information_list]
    if Category_number = 3 [set My_critical_information_list Early_majority_critical_information_list]
    if Category_number = 4 [set My_critical_information_list Late_majority_critical_information_list]
    if Category_number = 5 [set My_critical_information_list Laggard_critical_information_list]

    set products_switched_on shuffle products_switched_on
    foreach products_switched_on [ ? ->
      run (word "set knowledge_complexity_list_product_"?" []")
        ifelse My_product != 0
        [ run (word "set knowledge_of_complexity_product_"?" []")
          run (word "set knowledge_of_complexity_product_"?" lput Complexity_product_"?" knowledge_of_complexity_product_"?)
          run (word "set knowledge_of_complexity_product_"?" lput Duration_information_validity knowledge_of_complexity_product_"?)]
      [run (word "set knowledge_of_complexity_product_"?" [0 0]")]]

    set products_switched_on shuffle products_switched_on
    foreach products_switched_on [ ? ->
   run (word "set knowledge_compatibility_list_product_"?" []")
      ifelse My_product != 0
      [run (word "set knowledge_of_compatibility_product_"?" []")
        run (word "set knowledge_of_compatibility_product_"?" lput Compatibility_product_"?" knowledge_of_compatibility_product_"?)
        run (word "set knowledge_of_compatibility_product_"?" lput Duration_information_validity knowledge_of_compatibility_product_"?)]
      [run (word "set knowledge_of_compatibility_product_"?" [0 0]")]]

    set products_switched_on shuffle products_switched_on
    foreach products_switched_on [ ? ->
      run (word "set knowledge_relative_advantage_list_product_"?" []")
      ifelse My_product != 0
      [run (word "set knowledge_of_relative_advantage_product_"?" []")
        run (word "set knowledge_of_relative_advantage_product_"?" lput Relative_advantage_product_"?" knowledge_of_relative_advantage_product_"?)
        run (word "set knowledge_of_relative_advantage_product_"?" lput Duration_information_validity knowledge_of_relative_advantage_product_"?)]
      [run (word "set knowledge_of_relative_advantage_product_"?" [0 0]")]]


    if category_number = 2 [
      set products_switched_on shuffle products_switched_on
      foreach products_switched_on [ ? ->
        run (word "set list_households_without_product_encountered_product_"?" []")
        run (word "set list_households_without_product_encountered_after_pruchase_product_"?" []")]]
    if category_number = 4 [
      set products_switched_on shuffle products_switched_on
      foreach products_switched_on [ ? ->
        run (word "set list_households_with_product_encountered_product_"?" []")]]

    set final_evaluation_product_1 0
    set final_evaluation_product_2 0
    set final_evaluation_product_3 0
    set final_evaluation_product_4 0
    set delay_before_new_decision_product_1 0
    set delay_before_new_decision_product_2 0
    set delay_before_new_decision_product_3 0
    set delay_before_new_decision_product_4 0

    set awareness_step_done_product_1 0
    set awareness_step_done_product_2 0
    set awareness_step_done_product_3 0
    set awareness_step_done_product_4 0
    set information_step_done_product_1 0
    set information_step_done_product_2 0
    set information_step_done_product_3 0
    set information_step_done_product_4 0
    set evaluation_step_done_product_1 0
    set evaluation_step_done_product_2 0
    set evaluation_step_done_product_3 0
    set evaluation_step_done_product_4 0
  ]

end


to setup_links

  ;set type of interactions
  let my_unique_interaction_links 0
  let my_combined_interaction_short_links 0
  let my_combined_interaction_long_links 0
  ask households [

    let a 0
    while [a < 5][
      if Category_number = (item 0 (item a A_S_L_Unique_interaction))
      [set my_unique_interaction_links int((item 1 (item a A_S_L_Unique_interaction)) + 0.5)]
      set a a + 1]

    let b 0
    while [b < 5][
      if Category_number = (item 0 (item b A_S_L_Combined_interaction_short))
      [set my_combined_interaction_short_links int((item 1 (item b A_S_L_Combined_interaction_short)) + 0.5)]
      set b b + 1]

    let c 0
    while [c < 5][
      if Category_number = (item 0 (item c A_S_L_Combined_interaction_long))
      [set my_combined_interaction_long_links int((item 1 (item c A_S_L_Combined_interaction_long)) + 0.5)]
      set c c + 1]

;      let t 10
;  ask household 50 [set my_unique_interaction_links my_unique_interaction_links * t set my_combined_interaction_short_links  my_combined_interaction_short_links * t  set my_combined_interaction_long_links my_combined_interaction_long_links * t ]

    ifelse (neighbor_interactions = TRUE and friend_interactions = TRUE and random_interactions = TRUE )[
      set Amount_neighbor_interactions my_combined_interaction_short_links
      set Amount_friend_interactions int (my_combined_interaction_long_links / 2 + 0.5)
      set Amount_random_interactions int (my_combined_interaction_long_links / 2 + 0.5)]

    [ifelse (neighbor_interactions = TRUE and friend_interactions = TRUE )[
      set Amount_neighbor_interactions my_combined_interaction_short_links
      set Amount_friend_interactions my_combined_interaction_long_links
      set Amount_random_interactions 0]

    [ifelse (neighbor_interactions = TRUE and random_interactions = TRUE )[
      set Amount_neighbor_interactions my_combined_interaction_short_links
      set Amount_friend_interactions 0
      set Amount_random_interactions my_combined_interaction_long_links]

    [ifelse (friend_interactions = TRUE and random_interactions = TRUE )[
      set Amount_neighbor_interactions 0
      set Amount_friend_interactions int (my_unique_interaction_links / 2 + 0.5)
      set Amount_random_interactions int (my_unique_interaction_links / 2 + 0.5)]

    [ifelse (neighbor_interactions = TRUE )[
      set Amount_neighbor_interactions my_unique_interaction_links
      set Amount_friend_interactions 0
      set Amount_random_interactions 0]

    [ifelse (friend_interactions = TRUE )[
      set Amount_neighbor_interactions 0
      set Amount_friend_interactions my_unique_interaction_links
      set Amount_random_interactions 0]

    [ifelse (random_interactions = TRUE )[
      set Amount_neighbor_interactions 0
      set Amount_friend_interactions 0
      set Amount_random_interactions my_unique_interaction_links]
    [print "Household says: Please give me some interactions!"
    ]]]]]]]
  ]

  If Normality_of_adopter_properties = true and friend_interactions = True[

    ask households [
      set temp_name ( word "Amount_friend_interactions")
      structure_uniformity_interactions]]

  If Normality_of_adopter_properties = true and neighbor_interactions = True[
    ask households [
      set temp_name ( word "Amount_neighbor_interactions")
      structure_uniformity_interactions]]

  If Normality_of_adopter_properties = true and random_interactions = True[
    ask households [
      set temp_name ( word "Amount_random_interactions")
      structure_uniformity_interactions]]

  If Normality_of_adopter_properties = true [
    ask households [
      set temp_name ( word "My_product_awareness_threshold")
      structure_uniformity_awareness]]

  ask households [
    set amount_of_friends_I_still_need Amount_friend_interactions]

  ask households [ set my_list_of_friends []]

  ;structure friend interactions

  ask households [
    if (Amount_friend_interactions > length my_list_of_friends)[
      let d (Amount_friend_interactions - length my_list_of_friends)
      while [d > 0][
        let a -1
        let c 0
        let g 0
        while [c <= 0 or friendlink-with household a = TRUE and g < length data_1 or a < 0]
        [set a ([who] of one-of households with [self != myself])
          ask household a [
            ask myself [ set c [amount_of_friends_I_still_need] of myself]]
          set g g + 1]
        if g < length data_1 [
          create-friendlink-with household a
          if Show_links = False [ask friendlinks [hide-link]]
          set my_list_of_friends lput a my_list_of_friends
          ask household a [
            set my_list_of_friends lput ([who] of myself) my_list_of_friends
            set amount_of_friends_I_still_need amount_of_friends_I_still_need - 1]
          set amount_of_friends_I_still_need amount_of_friends_I_still_need - 1]
        set d d - 1]
    ]]
end



to setup_initial_environment
  ;the development trend of the product is made here
  set scenario_specific_list []
  set scenario_specific_list lput (list 1 0) scenario_specific_list
  set scenario_specific_list lput (list 2 0) scenario_specific_list
  set scenario_specific_list lput (list 3 0) scenario_specific_list
  set scenario_specific_list lput (list 4 0) scenario_specific_list

  set list_new_households_with_products []
  set list_new_households_aware []
  set list_new_households_with_enough_information []
  set list_new_households_with_evaluation_OK []
  set list_new_households_with_complexity_OK []

  set product_list [1 2 3 4]

; set complexity 3
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;         GO         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to go
;  set temp_name13 new-seed
;  random-seed temp_name13
  update_status_product                                       ; status of products is updated (depending on the development cyclus and learning curve)
  update_awareness_list                                       ; each household updates their memory of product awareness
  update_complexity                                           ; each household updates their knowledge of product complexity
  update_compatiblity
  update_relative_advantage
  update_households_with_without_product_encountered          ;
  update_memory_minimum_time_between_2_decisions_ON           ; list of memory between 2 decisions is updated
  setup_interactions_neighbors                                ; update interactions with neighbors (assumed that households do not interaction with all of their neighbors at eachtick (only some of them)
  setup_interactions_random                                   ; update interactions with random other households
  check_for_awareness_of_interactions                         ; evaluate if their is enough interactions that are also aware to become themselves aware.
  receive_information_from_interactions                       ; evaluate whether enough information about complexity, amount of savings, etc. is received (for robustness of information) to be able to make a decision
  make_final_judgment_enough_information                      ; make a final jugement if there is enough information to be able to make a decision
  evaluation_relative_advantage_product                               ; now that households of enough information of each, they evaluate whether enough savings can be made
  evaluation_complexity                                       ; (only if prospect theory is switched on) now that households of enough information of each, they evaluate whether purchase risks are low enough
  evaluation_compatibility                                           ; now that households of enough information of each, they evaluate whether the product is reliable enough
  evaluation_observability_triability
  final_judgement_evaluation                                  ; final judgement is made whether to characteristics of the product are satisfying
  for_monitoring                                              ; variables are calculated for monitoring in the interface

  neighborlinks_die ; ask neighborlinks [ die]
  randomlinks_die ; ask randomlinks [ die]
;  ifelse ticks < 60[
    tick
 ;  ][ ;print "Simulation is finished"
  ;   stop]
;  ][profiler:stop          ;; stop profiling
;  print profiler:report  ;; view the results
;  profiler:reset         ;; clear the data
;  print "Simulation is finished" stop]
end

; These two functions here is what I changed from v2

to randomlinks_die
  ask randomlinks [ die ]
end

to neighborlinks_die
  ask neighborlinks [ die ]
end


to update_status_product
  ;first we find out in which product lifecycle we currently are in

  let ticks_now ticks

  ; Update of product's relative advantage
  let aa 1
  while [aa <= 4][
    if Switch_product_1 = True and aa = 1
    [set Current_relative_advantage_product_1 (Relative_advantage_product_1 *((ticks_now + 1) / (1))^(log (Learning_rate_product_1) 2)) + ((Relative_advantage_product_1 *((ticks_now + 1) / (1))^(log (Learning_rate_product_1) 2)) - Relative_advantage_product_1)
    ]

    if Switch_product_2 = True and aa = 2
    [set Current_relative_advantage_product_2 (Relative_advantage_product_2 *((ticks_now + 1) / (1))^(log (Learning_rate_product_2) 2)) + ((Relative_advantage_product_2 *((ticks_now + 1) / (1))^(log (Learning_rate_product_2) 2)) - Relative_advantage_product_2)
    ]

    if Switch_product_3 = True and aa = 3
    [set Current_relative_advantage_product_3 (Relative_advantage_product_3 *((ticks_now + 1) / (1))^(log (Learning_rate_product_3) 2)) + ((Relative_advantage_product_3 *((ticks_now + 1) / (1))^(log (Learning_rate_product_3) 2)) - Relative_advantage_product_3)
    ]

    if Switch_product_4 = True and aa = 4
    [set Current_relative_advantage_product_4 (Relative_advantage_product_4 *((ticks_now + 1) / (1))^(log (Learning_rate_product_4) 2)) + ((Relative_advantage_product_4 *((ticks_now + 1) / (1))^(log (Learning_rate_product_4) 2)) - Relative_advantage_product_4)
    ]
    set aa aa + 1]

  ; Update of product's compatibility
  let bb 1
  while [bb <= 4][
    if Switch_product_1 = True  and bb = 1
    [set Current_compatibility_product_1 (Compatibility_product_1 *((ticks_now + 1) / (1))^(log (Learning_rate_product_1) 2)) + ((Compatibility_product_1 *((ticks_now + 1) / (1))^(log (Learning_rate_product_1) 2)) - Compatibility_product_1)
    ]

    if Switch_product_2 = True  and bb = 2
    [set Current_compatibility_product_2 (Compatibility_product_2 *((ticks_now + 1) / (1))^(log (Learning_rate_product_2) 2)) + ((Compatibility_product_2 *((ticks_now + 1) / (1))^(log (Learning_rate_product_2) 2)) - Compatibility_product_2)
    ]

    if Switch_product_3 = True  and bb = 3
    [set Current_compatibility_product_3 (Compatibility_product_3 *((ticks_now + 1) / (1))^(log (Learning_rate_product_3) 2)) + ((Compatibility_product_3 *((ticks_now + 1) / (1))^(log (Learning_rate_product_3) 2)) - Compatibility_product_3)
    ]

    if Switch_product_4 = True  and bb = 4
    [set Current_compatibility_product_4 (Compatibility_product_4 *((ticks_now + 1) / (1))^(log (Learning_rate_product_4) 2)) + ((Compatibility_product_4 *((ticks_now + 1) / (1))^(log (Learning_rate_product_4) 2)) - Compatibility_product_4)
    ]
    set bb bb + 1]

  ; Update of product complexities
  let cc 1
  while [cc <= 4][
    if Switch_product_1 = True and cc = 1
    [set Current_complexity_product_1 (Complexity_product_1 *((ticks_now + 1) / (1))^(log (Learning_rate_product_1) 2)) + ((Complexity_product_1 *((ticks_now + 1) / (1))^(log (Learning_rate_product_1) 2)) - Complexity_product_1)
    ]

    if Switch_product_2 = True and cc = 2
    [set Current_complexity_product_2 (Complexity_product_2 *((ticks_now + 1) / (1))^(log (Learning_rate_product_2) 2)) + ((Complexity_product_2 *((ticks_now + 1) / (1))^(log (Learning_rate_product_2) 2)) - Complexity_product_2)
    ]

    if Switch_product_3 = True and cc = 3
    [set Current_complexity_product_3 (Complexity_product_3 *((ticks_now + 1) / (1))^(log (Learning_rate_product_3) 2)) + ((Complexity_product_3 *((ticks_now + 1) / (1))^(log (Learning_rate_product_3) 2)) - Complexity_product_3)
    ]

    if Switch_product_4 = True and cc = 4
    [set Current_complexity_product_4 (Complexity_product_4 *((ticks_now + 1) / (1))^(log (Learning_rate_product_4) 2)) + ((Complexity_product_4 *((ticks_now + 1) / (1))^(log (Learning_rate_product_4) 2)) - Complexity_product_4)
    ]
    set cc cc + 1]

end

to update_awareness_list
  ;we remove one month to the memory number
  ask households [
    set products_switched_on shuffle products_switched_on
    if member? 1 products_switched_on = true[
      set temp_name8 []
      let j 0
      while [j < length product_awareness_process_product_1][
        if item 1 (item j product_awareness_process_product_1) > 1 [
          set product_awareness_process_product_1 (replace-item j product_awareness_process_product_1 (replace-item 1 (item j product_awareness_process_product_1) (item 1 (item j product_awareness_process_product_1) - 1)))
          set temp_name8 lput item j product_awareness_process_product_1 temp_name8
        ]
        set j j + 1]
      set product_awareness_process_product_1 temp_name8]

    if member? 2 products_switched_on = true[
      set temp_name8 []
      let j 0
      while [j < length product_awareness_process_product_2][
        if item 1 (item j product_awareness_process_product_2) > 1 [
          set product_awareness_process_product_2 (replace-item j product_awareness_process_product_2 (replace-item 1 (item j product_awareness_process_product_2) (item 1 (item j product_awareness_process_product_2) - 1)))
          set temp_name8 lput item j product_awareness_process_product_2 temp_name8
        ]
        set j j + 1]
      set product_awareness_process_product_2 temp_name8]

    if member? 3 products_switched_on = true[
      set temp_name8 []
      let j 0
      while [j < length product_awareness_process_product_3][
        if item 1 (item j product_awareness_process_product_3) > 1 [
          set product_awareness_process_product_3 (replace-item j product_awareness_process_product_3 (replace-item 1 (item j product_awareness_process_product_3) (item 1 (item j product_awareness_process_product_3) - 1)))
          set temp_name8 lput item j product_awareness_process_product_3 temp_name8
        ]
        set j j + 1]
      set product_awareness_process_product_3 temp_name8]

    if member? 4 products_switched_on = true[
      set temp_name8 []
      let j 0
      while [j < length product_awareness_process_product_4][
        if item 1 (item j product_awareness_process_product_4) > 1 [
          set product_awareness_process_product_4 (replace-item j product_awareness_process_product_4 (replace-item 1 (item j product_awareness_process_product_4) (item 1 (item j product_awareness_process_product_4) - 1)))
          set temp_name8 lput item j product_awareness_process_product_4 temp_name8
        ]
        set j j + 1]
      set product_awareness_process_product_4 temp_name8]


  ]

end

to update_complexity
    set products_switched_on shuffle products_switched_on
  if member? 1 products_switched_on = true [

  ;  foreach products_switched_on [ ? ->
    ask households [
      if is_aware_product_1 = 1 and My_product = 0 [
        set temp_name knowledge_complexity_list_product_1
        set temp_name2 2 ;item in list that contains memory
        structure_update_memory_in_list
        set knowledge_complexity_list_product_1 temp_name]]

    ask households [
     if My_product = 1 [
      if item 1 knowledge_of_complexity_product_1 > 0 [
              set knowledge_of_complexity_product_1 replace-item 1 knowledge_of_complexity_product_1 (item 1 knowledge_of_complexity_product_1 - 1)
    ]]]

  ]

    if member? 2 products_switched_on = true [

  ;  foreach products_switched_on [ ? ->
    ask households [
      if is_aware_product_2 = 1 and My_product = 0 [
        set temp_name knowledge_complexity_list_product_2
        set temp_name2 2 ;item in list that contains memory
        structure_update_memory_in_list
        set knowledge_complexity_list_product_2 temp_name]]

    ask households [
     if My_product = 2 [
      if item 1 knowledge_of_complexity_product_2 > 0 [
              set knowledge_of_complexity_product_2 replace-item 1 knowledge_of_complexity_product_2 (item 1 knowledge_of_complexity_product_2 - 1)
    ]]]

  ]

    if member? 3 products_switched_on = true [

  ;  foreach products_switched_on [ ? ->
    ask households [
      if is_aware_product_3 = 1 and My_product = 0 [
        set temp_name knowledge_complexity_list_product_3
        set temp_name2 2 ;item in list that contains memory
        structure_update_memory_in_list
        set knowledge_complexity_list_product_3 temp_name]]

    ask households [
     if My_product = 3 [
      if item 1 knowledge_of_complexity_product_3 > 0 [
              set knowledge_of_complexity_product_3 replace-item 1 knowledge_of_complexity_product_3 (item 1 knowledge_of_complexity_product_3 - 1)
    ]]]

  ]

    if member? 4 products_switched_on = true [

  ;  foreach products_switched_on [ ? ->
    ask households [
      if is_aware_product_4 = 1 and My_product = 0 [
        set temp_name knowledge_complexity_list_product_4
        set temp_name2 2 ;item in list that contains memory
        structure_update_memory_in_list
        set knowledge_complexity_list_product_4 temp_name]]

    ask households [
     if My_product = 4 [
      if item 1 knowledge_of_complexity_product_4 > 0 [
              set knowledge_of_complexity_product_4 replace-item 1 knowledge_of_complexity_product_4 (item 1 knowledge_of_complexity_product_4 - 1)
    ]]]

  ]
end

to update_compatiblity
    set products_switched_on shuffle products_switched_on
    if member? 1 products_switched_on = true [
  ask households [
    if is_aware_product_1 = 1 and My_product = 0  [
      set temp_name knowledge_compatibility_list_product_1
      set temp_name2 2 ;item in list that contains memory
      structure_update_memory_in_list
      set knowledge_compatibility_list_product_1 temp_name]]

      ask households [
;      print who
      if My_product = 1 [
     if item 1 knowledge_of_compatibility_product_1 > 0 [
              set knowledge_of_compatibility_product_1 replace-item 1 knowledge_of_compatibility_product_1 (item 1 knowledge_of_compatibility_product_1 - 1)
  ]]]

  ]

      if member? 2 products_switched_on = true [
  ask households [
    if is_aware_product_2 = 1 and My_product = 0  [
      set temp_name knowledge_compatibility_list_product_2
      set temp_name2 2 ;item in list that contains memory
      structure_update_memory_in_list
      set knowledge_compatibility_list_product_2 temp_name]]

      ask households [
;      print who
      if My_product = 2 [
     if item 1 knowledge_of_compatibility_product_2 > 0 [
              set knowledge_of_compatibility_product_2 replace-item 1 knowledge_of_compatibility_product_2 (item 1 knowledge_of_compatibility_product_2 - 1)
  ]]]

  ]

      if member? 3 products_switched_on = true [
  ask households [
    if is_aware_product_3 = 1 and My_product = 0  [
      set temp_name knowledge_compatibility_list_product_3
      set temp_name2 2 ;item in list that contains memory
      structure_update_memory_in_list
      set knowledge_compatibility_list_product_3 temp_name]]

      ask households [
;      print who
      if My_product = 3 [
     if item 1 knowledge_of_compatibility_product_3 > 0 [
              set knowledge_of_compatibility_product_3 replace-item 1 knowledge_of_compatibility_product_3 (item 1 knowledge_of_compatibility_product_3 - 1)
  ]]]

  ]

      if member? 4 products_switched_on = true [
  ask households [
    if is_aware_product_4 = 1 and My_product = 0  [
      set temp_name knowledge_compatibility_list_product_4
      set temp_name2 2 ;item in list that contains memory
      structure_update_memory_in_list
      set knowledge_compatibility_list_product_4 temp_name]]

      ask households [
;      print who
      if My_product = 4 [
     if item 1 knowledge_of_compatibility_product_4 > 0 [
              set knowledge_of_compatibility_product_4 replace-item 1 knowledge_of_compatibility_product_4 (item 1 knowledge_of_compatibility_product_4 - 1)
  ]]]

  ]
end


to update_relative_advantage
    set products_switched_on shuffle products_switched_on
    if member? 1 products_switched_on = true [
    ask households [
      if is_aware_product_1 = 1 and My_product = 0 [
        set temp_name knowledge_relative_advantage_list_product_1
        set temp_name2 2 ;item in list that contains memory
        structure_update_memory_in_list
        set knowledge_relative_advantage_list_product_1 temp_name]]

        ask households [
     if My_product = 1 [
     if item 1 knowledge_of_relative_advantage_product_1 > 0 [
              set knowledge_of_relative_advantage_product_1 replace-item 1 knowledge_of_relative_advantage_product_1 (item 1 knowledge_of_relative_advantage_product_1 - 1)
    ]]]

  ]

      if member? 2 products_switched_on = true [
    ask households [
      if is_aware_product_2 = 1 and My_product = 0 [
        set temp_name knowledge_relative_advantage_list_product_2
        set temp_name2 2 ;item in list that contains memory
        structure_update_memory_in_list
        set knowledge_relative_advantage_list_product_2 temp_name]]

        ask households [
     if My_product = 2 [
     if item 1 knowledge_of_relative_advantage_product_2 > 0 [
              set knowledge_of_relative_advantage_product_2 replace-item 1 knowledge_of_relative_advantage_product_2 (item 1 knowledge_of_relative_advantage_product_2 - 1)
    ]]]

  ]

      if member? 3 products_switched_on = true [
    ask households [
      if is_aware_product_3 = 1 and My_product = 0 [
        set temp_name knowledge_relative_advantage_list_product_3
        set temp_name2 2 ;item in list that contains memory
        structure_update_memory_in_list
        set knowledge_relative_advantage_list_product_3 temp_name]]

        ask households [
     if My_product = 3 [
     if item 1 knowledge_of_relative_advantage_product_3 > 0 [
              set knowledge_of_relative_advantage_product_3 replace-item 1 knowledge_of_relative_advantage_product_3 (item 1 knowledge_of_relative_advantage_product_3 - 1)
    ]]]

  ]

      if member? 4 products_switched_on = true [
    ask households [
      if is_aware_product_4 = 1 and My_product = 0 [
        set temp_name knowledge_relative_advantage_list_product_4
        set temp_name2 2 ;item in list that contains memory
        structure_update_memory_in_list
        set knowledge_relative_advantage_list_product_4 temp_name]]

        ask households [
     if My_product = 4 [
     if item 1 knowledge_of_relative_advantage_product_4 > 0 [
              set knowledge_of_relative_advantage_product_4 replace-item 1 knowledge_of_relative_advantage_product_4 (item 1 knowledge_of_relative_advantage_product_4 - 1)
    ]]]

  ]
end

to update_households_with_without_product_encountered ;;;;;;; Is this step used somewhere in the decision making process? Does not seem so...

  let aa 1
  while [aa <= 4][
    if Switch_product_1 = True and aa = 1[
      ask households [

        ; here the list is updated
        if is_aware_product_1 = 1 and My_product = 0 and category_number = 2 [
          set temp_name list_households_without_product_encountered_product_1
          set temp_name2 1 ;item in list that contains memory
          structure_update_memory_in_list
          set list_households_without_product_encountered_product_1 temp_name]

        if (item 0 (item 1 (item 0 Decision_making_status_list_product_1))) = 1 and My_product != 0 and category_number = 2 [
          set temp_name list_households_without_product_encountered_after_pruchase_product_1
          set temp_name2 1 ;item in list that contains memory
          structure_update_memory_in_list
          set list_households_without_product_encountered_after_pruchase_product_1 temp_name
          let a 0
          let f 0
          while [a < length households_with_whom_interacted] [
            set temp_name14 []
            set f item a households_with_whom_interacted
            if [category_number] of household f > 2 [
              ask household f [
                ask myself [set temp_name14 [Decision_making_status_list_product_1] of myself]]
              set temp_name13 []
              set temp_name13 lput item a households_with_whom_interacted temp_name13
              set temp_name13 lput (memory * 2) temp_name13
              if item 0 (item 1 (item 0 temp_name14)) = 1 [set temp_name13 lput 1 temp_name13]
              if item 0 (item 1 (item 0 temp_name14)) = 0 [set temp_name13 lput 0 temp_name13]
              set list_households_without_product_encountered_after_pruchase_product_1 lput temp_name13 list_households_without_product_encountered_after_pruchase_product_1]
            set a a + 1]]

        if is_aware_product_1 = 1 and My_product = 0 and category_number = 4 [
          set temp_name list_households_with_product_encountered_product_1
          set temp_name2 1 ;item in list that contains memory
          structure_update_memory_in_list
          set list_households_with_product_encountered_product_1 temp_name]]]



    if Switch_product_2 = True and aa = 2[
      ask households [

        ; here the list is updated
        if is_aware_product_2 = 1 and My_product = 0 and category_number = 2 [
          set temp_name list_households_without_product_encountered_product_2
          set temp_name2 1 ;item in list that contains memory
          structure_update_memory_in_list
          set list_households_without_product_encountered_product_2 temp_name]

        if (item 0 (item 1 (item 0 Decision_making_status_list_product_2))) = 1 and My_product != 0 and category_number = 2 [
          set temp_name list_households_without_product_encountered_after_pruchase_product_2
          set temp_name2 1 ;item in list that contains memory
          structure_update_memory_in_list
          set list_households_without_product_encountered_after_pruchase_product_2 temp_name
          let a 0
          let f 0
          while [a < length households_with_whom_interacted] [
            set temp_name14 []
            set f item a households_with_whom_interacted
            if [category_number] of household f > 2 [
              ask household f [
                ask myself [set temp_name14 [Decision_making_status_list_product_2] of myself]]
              set temp_name13 []
              set temp_name13 lput item a households_with_whom_interacted temp_name13
              set temp_name13 lput (memory * 2) temp_name13
              if item 0 (item 1 (item 0 temp_name14)) = 1 [set temp_name13 lput 1 temp_name13]
              if item 0 (item 1 (item 0 temp_name14)) = 0 [set temp_name13 lput 0 temp_name13]
              set list_households_without_product_encountered_after_pruchase_product_2 lput temp_name13 list_households_without_product_encountered_after_pruchase_product_2]
            set a a + 1]]

        if is_aware_product_2 = 1 and My_product = 0 and category_number = 4 [
          set temp_name list_households_with_product_encountered_product_2
          set temp_name2 1 ;item in list that contains memory
          structure_update_memory_in_list
          set list_households_with_product_encountered_product_2 temp_name]]]



    if Switch_product_3 = True and aa = 3[
      ask households [

        ; here the list is updated
        if is_aware_product_3 = 1 and My_product = 0 and category_number = 2 [
          set temp_name list_households_without_product_encountered_product_3
          set temp_name2 1 ;item in list that contains memory
          structure_update_memory_in_list
          set list_households_without_product_encountered_product_3 temp_name]

        if (item 0 (item 1 (item 0 Decision_making_status_list_product_3))) = 1 and My_product != 0 and category_number = 2 [
          set temp_name list_households_without_product_encountered_after_pruchase_product_3
          set temp_name2 1 ;item in list that contains memory
          structure_update_memory_in_list
          set list_households_without_product_encountered_after_pruchase_product_3 temp_name
          let a 0
          let f 0
          while [a < length households_with_whom_interacted] [
            set temp_name14 []
            set f item a households_with_whom_interacted
            if [category_number] of household f > 2 [
              ask household f [
                ask myself [set temp_name14 [Decision_making_status_list_product_3] of myself]]
              set temp_name13 []
              set temp_name13 lput item a households_with_whom_interacted temp_name13
              set temp_name13 lput (memory * 2) temp_name13
              if item 0 (item 1 (item 0 temp_name14)) = 1 [set temp_name13 lput 1 temp_name13]
              if item 0 (item 1 (item 0 temp_name14)) = 0 [set temp_name13 lput 0 temp_name13]
              set list_households_without_product_encountered_after_pruchase_product_3 lput temp_name13 list_households_without_product_encountered_after_pruchase_product_3]
            set a a + 1]]

        if is_aware_product_3 = 1 and My_product = 0 and category_number = 4 [
          set temp_name list_households_with_product_encountered_product_3
          set temp_name2 1 ;item in list that contains memory
          structure_update_memory_in_list
          set list_households_with_product_encountered_product_3 temp_name]]]



    if Switch_product_4 = True and aa = 4[
      ask households [

        ; here the list is updated
        if is_aware_product_4 = 1 and My_product = 0 and category_number = 2 [
          set temp_name list_households_without_product_encountered_product_4
          set temp_name2 1 ;item in list that contains memory
          structure_update_memory_in_list
          set list_households_without_product_encountered_product_4 temp_name]

        if (item 0 (item 1 (item 0 Decision_making_status_list_product_4))) = 1 and My_product != 0 and category_number = 2 [
          set temp_name list_households_without_product_encountered_after_pruchase_product_4
          set temp_name2 1 ;item in list that contains memory
          structure_update_memory_in_list
          set list_households_without_product_encountered_after_pruchase_product_4 temp_name
          let a 0
          let f 0
          while [a < length households_with_whom_interacted] [
            set temp_name14 []
            set f item a households_with_whom_interacted
            if [category_number] of household f > 2 [
              ask household f [
                ask myself [set temp_name14 [Decision_making_status_list_product_4] of myself]]
              set temp_name13 []
              set temp_name13 lput item a households_with_whom_interacted temp_name13
              set temp_name13 lput (memory * 2) temp_name13
              if item 0 (item 1 (item 0 temp_name14)) = 1 [set temp_name13 lput 1 temp_name13]
              if item 0 (item 1 (item 0 temp_name14)) = 0 [set temp_name13 lput 0 temp_name13]
              set list_households_without_product_encountered_after_pruchase_product_4 lput temp_name13 list_households_without_product_encountered_after_pruchase_product_4]
            set a a + 1]]

        if is_aware_product_4 = 1 and My_product = 0 and category_number = 4 [
          set temp_name list_households_with_product_encountered_product_4
          set temp_name2 1 ;item in list that contains memory
          structure_update_memory_in_list
          set list_households_with_product_encountered_product_4 temp_name]]]

    set aa aa + 1]
end


to update_memory_minimum_time_between_2_decisions_ON
  ; check whether to implement this differently

  set products_switched_on shuffle products_switched_on
  foreach products_switched_on [ ? ->

    ask households [if runresult (word "(item 1 (item 1 (item 0 Decision_making_status_list_product_"?"))) = 1 and My_product = 0")
      [run (word "set delay_before_new_decision_product_"?" delay_before_new_decision_product_"?" - 1")
        if runresult (word "delay_before_new_decision_product_"?" <= 0") [
          run (word "set Decision_making_status_list_product_"?" (replace-item 0 Decision_making_status_list_product_"?" (replace-item 1 (item 0 Decision_making_status_list_product_"?" ) replace-item 1 (item 1 (item 0 Decision_making_status_list_product_"?")) 0))")]]]
  ]
end


to setup_interactions_neighbors

  ask households [set my_list_of_neighbors []
    set amount_of_neighbor_interactions_I_still_need Amount_neighbor_interactions]

  ask households [
    if (amount_of_neighbor_interactions_I_still_need > length my_list_of_neighbors)[
      let d (amount_of_neighbor_interactions_I_still_need - length my_list_of_neighbors)
      let c 0

      while [c < d][
        let f 3
        let b nobody
        while [b = nobody and f <= 5] [set b one-of households in-radius f with [SELF != myself and amount_of_neighbor_interactions_I_still_need > 0]
          set f f + 1]
        ifelse f <= 5 [
        let a [who] of b
          create-neighborlink-with household a [if Show_links = False [hide-link]]
          set my_list_of_neighbors lput a my_list_of_neighbors
          ask household a [
            set my_list_of_neighbors lput ([who] of myself) my_list_of_neighbors
            set amount_of_neighbor_interactions_I_still_need amount_of_neighbor_interactions_I_still_need - 1]
          set amount_of_neighbor_interactions_I_still_need amount_of_neighbor_interactions_I_still_need - 1][]
        set c c + 1]]]
end


to setup_interactions_random
  ;structure random interactions

    ask households [set my_list_of_random_interactions []
      set amount_of_random_interactions_I_still_need Amount_random_interactions]

  ask households [
    if (amount_of_random_interactions_I_still_need > length my_list_of_random_interactions)[
      let d (amount_of_random_interactions_I_still_need - length my_list_of_random_interactions)
      let c 0
      while [c < d][
        let b one-of households with [SELF != myself and amount_of_random_interactions_I_still_need > 0]
        if b != nobody [
        let a [who] of b
        create-randomlink-with household a [if Show_links = False [hide-link]]
        set my_list_of_random_interactions lput a my_list_of_random_interactions
        ask household a [
          set my_list_of_random_interactions lput ([who] of myself) my_list_of_random_interactions
          set amount_of_random_interactions_I_still_need amount_of_random_interactions_I_still_need - 1]
        set amount_of_random_interactions_I_still_need amount_of_random_interactions_I_still_need - 1]
        set c c + 1]]]
end


to check_for_awareness_of_interactions
 ; first we create a single list with all the households with whom an interaction was made
  ask households [
    set information_step_done_product_1 0
    set information_step_done_product_2 0
    set information_step_done_product_3 0
    set information_step_done_product_4 0
    set households_with_whom_interacted []
    let my_list_of_friends_temp my_list_of_friends
    let my_list_of_neighbors_temp my_list_of_neighbors
    let my_list_of_random_interactions_temp my_list_of_random_interactions

;    while [length my_list_of_friends_temp > 0]
    while [is-list? my_list_of_friends_temp and length my_list_of_friends_temp > 0]
      [set households_with_whom_interacted lput (item 0 my_list_of_friends_temp) households_with_whom_interacted
        set my_list_of_friends_temp remove-item 0 my_list_of_friends_temp]

;    while [length my_list_of_neighbors_temp > 0]
    while [is-list? my_list_of_neighbors_temp and length my_list_of_neighbors_temp > 0]
      [set households_with_whom_interacted lput (item 0 my_list_of_neighbors_temp) households_with_whom_interacted
        set my_list_of_neighbors_temp remove-item 0 my_list_of_neighbors_temp]

;    while [length my_list_of_random_interactions_temp > 0]
    while [is-list? my_list_of_random_interactions_temp and length my_list_of_random_interactions_temp > 0]
      [set households_with_whom_interacted lput (item 0 my_list_of_random_interactions_temp) households_with_whom_interacted
        set my_list_of_random_interactions_temp remove-item 0 my_list_of_random_interactions_temp]

  ]


  ask households [
    let z 0
    set z 1
    set products_switched_on shuffle products_switched_on

    if member? 1 products_switched_on = true [
      if item 0 (item 1 (item 0 Decision_making_status_list_product_1)) = 0 and My_product = 0 and z = 1[

        ; first each household ask to their interactions if they have a product. If it is the case, they add a sublist to their product_awareness_process.
        ; a sub_list is composed of two elements: the first is a 1 which corresponds to the fact that the household with whom contact was made had a product
        ; the second corresponds to the memory of the agent. At each tick, the memory number is diminished by 1 until the memory number is equal to 0.
        ; if this is the case, the household forget that the household with whom he communicated was aware.
        let a 0
        let sub_list_1 []
        while [a < length households_with_whom_interacted][
          set sub_list_1 []
          set temp_name14 0
;          print ""
;          print who
          ask household (item a households_with_whom_interacted)[
;            print who
;            print Decision_making_status_list_product_2
            ask myself [ set temp_name14 [(item 0 (item 1 (item 0 Decision_making_status_list_product_1)))] of myself]]
;          print temp_name14
          if temp_name14 = 1 [set sub_list_1 [1]
            set sub_list_1 lput memory sub_list_1
            set product_awareness_process_product_1 lput sub_list_1  product_awareness_process_product_1]
          set a a + 1]
        set temp_name14 0
        set temp_name13 0
        while [temp_name14 < length product_awareness_process_product_1][
          if (item 0 (item temp_name14 product_awareness_process_product_1)) > 0 [
            set temp_name13 temp_name13 + (item 0 (item temp_name14  product_awareness_process_product_1))]
          set temp_name14 temp_name14 + 1]
        ifelse temp_name13 >= (My_product_awareness_threshold * memory) [
          set new_households_aware new_households_aware + 1
          set awareness_step_done_product_1 1
          set is_aware_product_1 1]
        [set is_aware_product_1 0]]]

        if member? 2 products_switched_on = true [
      if item 0 (item 1 (item 0 Decision_making_status_list_product_2)) = 0 and My_product = 0 and z = 1[

        ; first each household ask to their interactions if they have a product. If it is the case, they add a sublist to their product_awareness_process.
        ; a sub_list is composed of two elements: the first is a 1 which corresponds to the fact that the household with whom contact was made had a product
        ; the second corresponds to the memory of the agent. At each tick, the memory number is diminished by 1 until the memory number is equal to 0.
        ; if this is the case, the household forget that the household with whom he communicated was aware.
        let a 0
        let sub_list_2 []
        while [a < length households_with_whom_interacted][
          set sub_list_2 []
          set temp_name14 0
;          print ""
;          print who
          ask household (item a households_with_whom_interacted)[
;            print who
;            print Decision_making_status_list_product_2
            ask myself [ set temp_name14 [(item 0 (item 1 (item 0 Decision_making_status_list_product_2)))] of myself]]
;          print temp_name14
          if temp_name14 = 1 [set sub_list_2 [1]
            set sub_list_2 lput memory sub_list_2
            set product_awareness_process_product_2 lput sub_list_2  product_awareness_process_product_2]
          set a a + 1]
        set temp_name14 0
        set temp_name13 0
        while [temp_name14 < length product_awareness_process_product_2][
          if (item 0 (item temp_name14 product_awareness_process_product_2)) > 0 [
            set temp_name13 temp_name13 + (item 0 (item temp_name14  product_awareness_process_product_2))]
          set temp_name14 temp_name14 + 1]
        ifelse temp_name13 >= (My_product_awareness_threshold * memory) [
          set new_households_aware new_households_aware + 1
          set awareness_step_done_product_2 1
          set is_aware_product_2 1]
        [set is_aware_product_2 0]]]

        if member? 3 products_switched_on = true [
      if item 0 (item 1 (item 0 Decision_making_status_list_product_3)) = 0 and My_product = 0 and z = 1[

        ; first each household ask to their interactions if they have a product. If it is the case, they add a sublist to their product_awareness_process.
        ; a sub_list is composed of two elements: the first is a 1 which corresponds to the fact that the household with whom contact was made had a product
        ; the second corresponds to the memory of the agent. At each tick, the memory number is diminished by 1 until the memory number is equal to 0.
        ; if this is the case, the household forget that the household with whom he communicated was aware.
        let a 0
        let sub_list_3 []
        while [a < length households_with_whom_interacted][
          set sub_list_3 []
          set temp_name14 0
;          print ""
;          print who
          ask household (item a households_with_whom_interacted)[
;            print who
;            print Decision_making_status_list_product_2
            ask myself [ set temp_name14 [(item 0 (item 1 (item 0 Decision_making_status_list_product_3)))] of myself]]
;          print temp_name14
          if temp_name14 = 1 [set sub_list_3 [1]
            set sub_list_3 lput memory sub_list_3
            set product_awareness_process_product_3 lput sub_list_3  product_awareness_process_product_3]
          set a a + 1]
        set temp_name14 0
        set temp_name13 0
        while [temp_name14 < length product_awareness_process_product_3][
          if (item 0 (item temp_name14 product_awareness_process_product_3)) > 0 [
            set temp_name13 temp_name13 + (item 0 (item temp_name14  product_awareness_process_product_3))]
          set temp_name14 temp_name14 + 1]
        ifelse temp_name13 >= (My_product_awareness_threshold * memory) [
          set new_households_aware new_households_aware + 1
          set awareness_step_done_product_3 1
          set is_aware_product_3 1]
        [set is_aware_product_3 0]]]

        if member? 4 products_switched_on = true [
      if item 0 (item 1 (item 0 Decision_making_status_list_product_4)) = 0 and My_product = 0 and z = 1[

        ; first each household ask to their interactions if they have a product. If it is the case, they add a sublist to their product_awareness_process.
        ; a sub_list is composed of two elements: the first is a 1 which corresponds to the fact that the household with whom contact was made had a product
        ; the second corresponds to the memory of the agent. At each tick, the memory number is diminished by 1 until the memory number is equal to 0.
        ; if this is the case, the household forget that the household with whom he communicated was aware.
        let a 0
        let sub_list_4 []
        while [a < length households_with_whom_interacted][
          set sub_list_4 []
          set temp_name14 0
;          print ""
;          print who
          ask household (item a households_with_whom_interacted)[
;            print who
;            print Decision_making_status_list_product_2
            ask myself [ set temp_name14 [(item 0 (item 1 (item 0 Decision_making_status_list_product_4)))] of myself]]
;          print temp_name14
          if temp_name14 = 1 [set sub_list_4 [1]
            set sub_list_4 lput memory sub_list_4
            set product_awareness_process_product_4 lput sub_list_4  product_awareness_process_product_4]
          set a a + 1]
        set temp_name14 0
        set temp_name13 0
        while [temp_name14 < length product_awareness_process_product_4][
          if (item 0 (item temp_name14 product_awareness_process_product_4)) > 0 [
            set temp_name13 temp_name13 + (item 0 (item temp_name14  product_awareness_process_product_4))]
          set temp_name14 temp_name14 + 1]
        ifelse temp_name13 >= (My_product_awareness_threshold * memory) [
          set new_households_aware new_households_aware + 1
          set awareness_step_done_product_4 1
          set is_aware_product_4 1]
        [set is_aware_product_4 0]]]

  ]

  ask households [
    if My_product = 0 [
    let bb 0
    set products_switched_on shuffle products_switched_on
    foreach products_switched_on [ ? ->
      if runresult (word "is_aware_product_"?" = 1") [
      set bb bb + 1]]
    ifelse bb > 0 [set color grey][set color black]]]
end



to receive_information_from_interactions
  get_information_complexity
  get_information_compability
  get_information_relative_advantage
end


  ; until here seems ok

to get_information_complexity

  ; Then households will exchange information about the complexity of products
  ask households [
    set products_switched_on shuffle products_switched_on

    if member? 1 products_switched_on = true [

      if (item 1 (item 1 (item 0 Decision_making_status_list_product_1))) = 0 and My_product = 0 and is_aware_product_1 = 1 [
        let d 0
        let f 0
        while [d < length households_with_whom_interacted][
          set f (item d households_with_whom_interacted)
          set temp_name14 []
          ask household f [
            ask myself [set temp_name14 [knowledge_of_complexity_product_1] of myself]]
          ;          print temp_name14
          if item 1 temp_name14 > 0 [
            set temp_name 0 ; s
            ask household f [
              ask myself [ set temp_name [Category_number] of myself]]
            set temp_name15 []
            set temp_name15 lput (item 0 temp_name14) temp_name15
            set temp_name2 0 ; m
            structure_preferred_information_source
            set temp_name15 lput temp_name2 temp_name15
            Ifelse category_number > 2 [set temp_name15 lput (memory) temp_name15]
            [set temp_name15 lput memory temp_name15]
            set temp_name15 lput 0 temp_name15
            set knowledge_complexity_list_product_1 lput temp_name15 knowledge_complexity_list_product_1]
          set d d + 1]
        if My_product = 0[
          let q 0
          set temp_name15 0
          while [q < length knowledge_complexity_list_product_1][
              set temp_name15 (temp_name15 + item 1 (item q knowledge_complexity_list_product_1))
            set q q + 1]
          let ee 0
          let ff 0
          while [ff < length threshold_to_reach_for_weights_information][
            if item 0 (item ff threshold_to_reach_for_weights_information) = Category_number [
              set ee item 1 (item ff threshold_to_reach_for_weights_information)
            ]
            set ff ff + 1]
          ifelse temp_name15 / memory * memory >= ee [ ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; here change memory back!!!!!!!!!!!!!!!!!!!!!!!
            set My_experience_information_list_product_1 replace-item 1 My_experience_information_list_product_1 1]
        [set My_experience_information_list_product_1 replace-item 1 My_experience_information_list_product_1 0]]]]


    if member? 2 products_switched_on = true [

      if (item 1 (item 1 (item 0 Decision_making_status_list_product_2))) = 0 and My_product = 0 and is_aware_product_2 = 1 [
        let d 0
        let f 0
        while [d < length households_with_whom_interacted][
          set f (item d households_with_whom_interacted)
          set temp_name14 []
          ask household f [
            ask myself [set temp_name14 [knowledge_of_complexity_product_2] of myself]]
          ;          print temp_name14
          if item 1 temp_name14 > 0 [
            set temp_name 0 ; s
            ask household f [
              ask myself [ set temp_name [Category_number] of myself]]
            set temp_name15 []
            set temp_name15 lput (item 0 temp_name14) temp_name15
            set temp_name2 0 ; m
            structure_preferred_information_source
            set temp_name15 lput temp_name2 temp_name15
            Ifelse category_number > 2 [set temp_name15 lput (memory) temp_name15]
            [set temp_name15 lput memory temp_name15]
            set temp_name15 lput 0 temp_name15
            set knowledge_complexity_list_product_2 lput temp_name15 knowledge_complexity_list_product_2]
          set d d + 1]
        if My_product = 0[
          let q 0
          set temp_name15 0
          while [q < length knowledge_complexity_list_product_2][
              set temp_name15 (temp_name15 + item 1 (item q knowledge_complexity_list_product_2))
            set q q + 1]
          let ee 0
          let ff 0
          while [ff < length threshold_to_reach_for_weights_information][
            if item 0 (item ff threshold_to_reach_for_weights_information) = Category_number [
              set ee item 1 (item ff threshold_to_reach_for_weights_information)
            ]
            set ff ff + 1]
          ifelse temp_name15 / memory * memory >= ee [ ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; here change memory back!!!!!!!!!!!!!!!!!!!!!!!
            set My_experience_information_list_product_2 replace-item 1 My_experience_information_list_product_2 1]
        [set My_experience_information_list_product_2 replace-item 1 My_experience_information_list_product_2 0]]]]


    if member? 3 products_switched_on = true [

      if (item 1 (item 1 (item 0 Decision_making_status_list_product_3))) = 0 and My_product = 0 and is_aware_product_3 = 1 [
        let d 0
        let f 0
        while [d < length households_with_whom_interacted][
          set f (item d households_with_whom_interacted)
          set temp_name14 []
          ask household f [
            ask myself [set temp_name14 [knowledge_of_complexity_product_3] of myself]]
          ;          print temp_name14
          if item 1 temp_name14 > 0 [
            set temp_name 0 ; s
            ask household f [
              ask myself [ set temp_name [Category_number] of myself]]
            set temp_name15 []
            set temp_name15 lput (item 0 temp_name14) temp_name15
            set temp_name2 0 ; m
            structure_preferred_information_source
            set temp_name15 lput temp_name2 temp_name15
            Ifelse category_number > 2 [set temp_name15 lput (memory) temp_name15]
            [set temp_name15 lput memory temp_name15]
            set temp_name15 lput 0 temp_name15
            set knowledge_complexity_list_product_3 lput temp_name15 knowledge_complexity_list_product_3]
          set d d + 1]
        if My_product = 0[
          let q 0
          set temp_name15 0
          while [q < length knowledge_complexity_list_product_3][
              set temp_name15 (temp_name15 + item 1 (item q knowledge_complexity_list_product_3))
            set q q + 1]
          let ee 0
          let ff 0
          while [ff < length threshold_to_reach_for_weights_information][
            if item 0 (item ff threshold_to_reach_for_weights_information) = Category_number [
              set ee item 1 (item ff threshold_to_reach_for_weights_information)
            ]
            set ff ff + 1]
          ifelse temp_name15 / memory * memory >= ee [ ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; here change memory back!!!!!!!!!!!!!!!!!!!!!!!
            set My_experience_information_list_product_3 replace-item 1 My_experience_information_list_product_3 1]
        [set My_experience_information_list_product_3 replace-item 1 My_experience_information_list_product_3 0]]]]


    if member? 4 products_switched_on = true [

      if (item 1 (item 1 (item 0 Decision_making_status_list_product_4))) = 0 and My_product = 0 and is_aware_product_4 = 1 [
        let d 0
        let f 0
        while [d < length households_with_whom_interacted][
          set f (item d households_with_whom_interacted)
          set temp_name14 []
          ask household f [
            ask myself [set temp_name14 [knowledge_of_complexity_product_4] of myself]]
          ;          print temp_name14
          if item 1 temp_name14 > 0 [
            set temp_name 0 ; s
            ask household f [
              ask myself [ set temp_name [Category_number] of myself]]
            set temp_name15 []
            set temp_name15 lput (item 0 temp_name14) temp_name15
            set temp_name2 0 ; m
            structure_preferred_information_source
            set temp_name15 lput temp_name2 temp_name15
            Ifelse category_number > 2 [set temp_name15 lput (memory) temp_name15]
            [set temp_name15 lput memory temp_name15]
            set temp_name15 lput 0 temp_name15
            set knowledge_complexity_list_product_4 lput temp_name15 knowledge_complexity_list_product_4]
          set d d + 1]
        if My_product = 0[
          let q 0
          set temp_name15 0
          while [q < length knowledge_complexity_list_product_4][
              set temp_name15 (temp_name15 + item 1 (item q knowledge_complexity_list_product_4))
            set q q + 1]
          let ee 0
          let ff 0
          while [ff < length threshold_to_reach_for_weights_information][
            if item 0 (item ff threshold_to_reach_for_weights_information) = Category_number [
              set ee item 1 (item ff threshold_to_reach_for_weights_information)
            ]
            set ff ff + 1]
          ifelse temp_name15 / memory * memory >= ee [ ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; here change memory back!!!!!!!!!!!!!!!!!!!!!!!
            set My_experience_information_list_product_4 replace-item 1 My_experience_information_list_product_4 1]
        [set My_experience_information_list_product_4 replace-item 1 My_experience_information_list_product_4 0]]]]


  ]
end

  to get_information_compability
; Then households will exchange information about the compatibility of the products

  ask households [
    set products_switched_on shuffle products_switched_on


    if member? 1 products_switched_on = true [
    if ((item 1 (item 1 (item 0 Decision_making_status_list_product_1))) = 0 and My_product = 0 and is_aware_product_1 = 1) [ ; chech here if remove the fact that households that have already adopted do not execute this step

      let d 0
      let f 0
      while [d < length households_with_whom_interacted][
        set f (item d households_with_whom_interacted)
        set temp_name14 []
        ask household f [
          ask myself [set temp_name14 [knowledge_of_compatibility_product_1] of myself]]

        if item 1 temp_name14 > 0 [
          set temp_name 0 ; s

          ;set temp_name [Category_number] of household f
          ask household f [
            ask myself [ set temp_name [Category_number] of myself]]
          set temp_name15 []
          set temp_name15 lput (item 0 temp_name14) temp_name15

          set temp_name2 0 ; m
          structure_preferred_information_source

          set temp_name15 lput temp_name2 temp_name15
          Ifelse category_number > 2 [set temp_name15 lput (memory) temp_name15]
          [set temp_name15 lput memory temp_name15]
          set temp_name15 lput 0 temp_name15
          set knowledge_compatibility_list_product_1 lput temp_name15 knowledge_compatibility_list_product_1]
        set d d + 1]
      if My_product = 0[
        let q 0
        set temp_name15 0
        while [q < length knowledge_compatibility_list_product_1][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_compatibility_list_product_1))
          set q q + 1]

        let ee 0
        let ff 0
        while [ff < length threshold_to_reach_for_weights_information][
          if item 0 (item ff threshold_to_reach_for_weights_information) = Category_number [
            set ee item 1 (item ff threshold_to_reach_for_weights_information)
            ]
          set ff ff + 1]

        ifelse temp_name15 / memory * memory >= ee [ ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; here change memory back!!!!!!!!!!!!!!!!!!!!!!!
          set My_experience_information_list_product_1 replace-item 0 My_experience_information_list_product_1 1]
        [set My_experience_information_list_product_1 replace-item 0 My_experience_information_list_product_1 0]]]]


        if member? 2 products_switched_on = true [
    if ((item 1 (item 1 (item 0 Decision_making_status_list_product_2))) = 0 and My_product = 0 and is_aware_product_2 = 1) [ ; chech here if remove the fact that households that have already adopted do not execute this step

      let d 0
      let f 0
      while [d < length households_with_whom_interacted][
        set f (item d households_with_whom_interacted)
        set temp_name14 []
        ask household f [
          ask myself [set temp_name14 [knowledge_of_compatibility_product_2] of myself]]

        if item 1 temp_name14 > 0 [
          set temp_name 0 ; s

          ;set temp_name [Category_number] of household f
          ask household f [
            ask myself [ set temp_name [Category_number] of myself]]
          set temp_name15 []
          set temp_name15 lput (item 0 temp_name14) temp_name15

          set temp_name2 0 ; m
          structure_preferred_information_source

          set temp_name15 lput temp_name2 temp_name15
          Ifelse category_number > 2 [set temp_name15 lput (memory) temp_name15]
          [set temp_name15 lput memory temp_name15]
          set temp_name15 lput 0 temp_name15
          set knowledge_compatibility_list_product_2 lput temp_name15 knowledge_compatibility_list_product_2]
        set d d + 1]
      if My_product = 0[
        let q 0
        set temp_name15 0
        while [q < length knowledge_compatibility_list_product_2][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_compatibility_list_product_2))
          set q q + 1]

        let ee 0
        let ff 0
        while [ff < length threshold_to_reach_for_weights_information][
          if item 0 (item ff threshold_to_reach_for_weights_information) = Category_number [
            set ee item 1 (item ff threshold_to_reach_for_weights_information)
            ]
          set ff ff + 1]

        ifelse temp_name15 / memory * memory >= ee [ ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; here change memory back!!!!!!!!!!!!!!!!!!!!!!!
          set My_experience_information_list_product_2 replace-item 0 My_experience_information_list_product_2 1]
        [set My_experience_information_list_product_2 replace-item 0 My_experience_information_list_product_2 0]]]]


        if member? 3 products_switched_on = true [
    if ((item 1 (item 1 (item 0 Decision_making_status_list_product_3))) = 0 and My_product = 0 and is_aware_product_3 = 1) [ ; chech here if remove the fact that households that have already adopted do not execute this step

      let d 0
      let f 0
      while [d < length households_with_whom_interacted][
        set f (item d households_with_whom_interacted)
        set temp_name14 []
        ask household f [
          ask myself [set temp_name14 [knowledge_of_compatibility_product_3] of myself]]

        if item 1 temp_name14 > 0 [
          set temp_name 0 ; s

          ;set temp_name [Category_number] of household f
          ask household f [
            ask myself [ set temp_name [Category_number] of myself]]
          set temp_name15 []
          set temp_name15 lput (item 0 temp_name14) temp_name15

          set temp_name2 0 ; m
          structure_preferred_information_source

          set temp_name15 lput temp_name2 temp_name15
          Ifelse category_number > 2 [set temp_name15 lput (memory) temp_name15]
          [set temp_name15 lput memory temp_name15]
          set temp_name15 lput 0 temp_name15
          set knowledge_compatibility_list_product_3 lput temp_name15 knowledge_compatibility_list_product_3]
        set d d + 1]
      if My_product = 0[
        let q 0
        set temp_name15 0
        while [q < length knowledge_compatibility_list_product_3][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_compatibility_list_product_3))
          set q q + 1]

        let ee 0
        let ff 0
        while [ff < length threshold_to_reach_for_weights_information][
          if item 0 (item ff threshold_to_reach_for_weights_information) = Category_number [
            set ee item 1 (item ff threshold_to_reach_for_weights_information)
            ]
          set ff ff + 1]

        ifelse temp_name15 / memory * memory >= ee [ ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; here change memory back!!!!!!!!!!!!!!!!!!!!!!!
          set My_experience_information_list_product_3 replace-item 0 My_experience_information_list_product_3 1]
        [set My_experience_information_list_product_3 replace-item 0 My_experience_information_list_product_3 0]]]]



        if member? 4 products_switched_on = true [
    if ((item 1 (item 1 (item 0 Decision_making_status_list_product_4))) = 0 and My_product = 0 and is_aware_product_4 = 1) [ ; chech here if remove the fact that households that have already adopted do not execute this step

      let d 0
      let f 0
      while [d < length households_with_whom_interacted][
        set f (item d households_with_whom_interacted)
        set temp_name14 []
        ask household f [
          ask myself [set temp_name14 [knowledge_of_compatibility_product_4] of myself]]

        if item 1 temp_name14 > 0 [
          set temp_name 0 ; s

          ;set temp_name [Category_number] of household f
          ask household f [
            ask myself [ set temp_name [Category_number] of myself]]
          set temp_name15 []
          set temp_name15 lput (item 0 temp_name14) temp_name15

          set temp_name2 0 ; m
          structure_preferred_information_source

          set temp_name15 lput temp_name2 temp_name15
          Ifelse category_number > 2 [set temp_name15 lput (memory) temp_name15]
          [set temp_name15 lput memory temp_name15]
          set temp_name15 lput 0 temp_name15
          set knowledge_compatibility_list_product_4 lput temp_name15 knowledge_compatibility_list_product_4]
        set d d + 1]
      if My_product = 0[
        let q 0
        set temp_name15 0
        while [q < length knowledge_compatibility_list_product_4][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_compatibility_list_product_4))
          set q q + 1]

        let ee 0
        let ff 0
        while [ff < length threshold_to_reach_for_weights_information][
          if item 0 (item ff threshold_to_reach_for_weights_information) = Category_number [
            set ee item 1 (item ff threshold_to_reach_for_weights_information)
            ]
          set ff ff + 1]

        ifelse temp_name15 / memory * memory >= ee [ ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; here change memory back!!!!!!!!!!!!!!!!!!!!!!!
          set My_experience_information_list_product_4 replace-item 0 My_experience_information_list_product_4 1]
        [set My_experience_information_list_product_4 replace-item 0 My_experience_information_list_product_4 0]]]]



  ]
  end

  to get_information_relative_advantage

  ; Then households will exchange information about the relative advantage of the products

  ask households [
    set products_switched_on shuffle products_switched_on
    if member? 1 products_switched_on = true [

    if (item 1 (item 1 (item 0 Decision_making_status_list_product_1))) = 0 and My_product = 0 and is_aware_product_1 = 1 [ ; chech here if remove the fact that households that have already adopted do not execute this step

      let d 0
      let f 0
      while [d < length households_with_whom_interacted][
        set f (item d households_with_whom_interacted)
        set temp_name14 []

        ;run (word "set temp_name14 [knowledge_of_relative_advantage_product_"cc"] of household "f)
        ask household f [
          ask myself [set temp_name14 [knowledge_of_relative_advantage_product_1] of myself]]

        if item 1 temp_name14 > 0 [
          set temp_name 0 ; s

          ;set temp_name [Category_number] of household f
          ask household f [
            ask myself [ set temp_name [Category_number] of myself]]
          set temp_name15 []
          set temp_name15 lput (item 0 temp_name14) temp_name15

          set temp_name2 0 ; m
          structure_preferred_information_source

          set temp_name15 lput temp_name2 temp_name15
          Ifelse category_number > 2 [set temp_name15 lput (memory) temp_name15]
          [set temp_name15 lput memory temp_name15]
          set temp_name15 lput 0 temp_name15
          set knowledge_relative_advantage_list_product_1 lput temp_name15 knowledge_relative_advantage_list_product_1]
        set d d + 1]


      if My_product = 0[
        let q 0
        set temp_name15 0
        while [ q < length knowledge_relative_advantage_list_product_1][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_relative_advantage_list_product_1))
          set q q + 1]


        let ee 0
        let ff 0
        while [ff < length threshold_to_reach_for_weights_information][
          if item 0 (item ff threshold_to_reach_for_weights_information) = Category_number [
            set ee item 1 (item ff threshold_to_reach_for_weights_information)
            ]
          set ff ff + 1]


        ifelse temp_name15 / memory * memory >= ee [ ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; here change memory back!!!!!!!!!!!!!!!!!!!!!!!
          set My_experience_information_list_product_1 replace-item 2 My_experience_information_list_product_1 1]
        [set My_experience_information_list_product_1 replace-item 2 My_experience_information_list_product_1 0]]]]



        if member? 2 products_switched_on = true [

    if (item 1 (item 1 (item 0 Decision_making_status_list_product_2))) = 0 and My_product = 0 and is_aware_product_2 = 1 [ ; chech here if remove the fact that households that have already adopted do not execute this step

      let d 0
      let f 0
      while [d < length households_with_whom_interacted][
        set f (item d households_with_whom_interacted)
        set temp_name14 []

        ;run (word "set temp_name14 [knowledge_of_relative_advantage_product_"cc"] of household "f)
        ask household f [
          ask myself [set temp_name14 [knowledge_of_relative_advantage_product_2] of myself]]

        if item 1 temp_name14 > 0 [
          set temp_name 0 ; s

          ;set temp_name [Category_number] of household f
          ask household f [
            ask myself [ set temp_name [Category_number] of myself]]
          set temp_name15 []
          set temp_name15 lput (item 0 temp_name14) temp_name15

          set temp_name2 0 ; m
          structure_preferred_information_source

          set temp_name15 lput temp_name2 temp_name15
          Ifelse category_number > 2 [set temp_name15 lput (memory) temp_name15]
          [set temp_name15 lput memory temp_name15]
          set temp_name15 lput 0 temp_name15
          set knowledge_relative_advantage_list_product_2 lput temp_name15 knowledge_relative_advantage_list_product_2]
        set d d + 1]


      if My_product = 0[
        let q 0
        set temp_name15 0
        while [ q < length knowledge_relative_advantage_list_product_2][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_relative_advantage_list_product_2))
          set q q + 1]


        let ee 0
        let ff 0
        while [ff < length threshold_to_reach_for_weights_information][
          if item 0 (item ff threshold_to_reach_for_weights_information) = Category_number [
            set ee item 1 (item ff threshold_to_reach_for_weights_information)
            ]
          set ff ff + 1]


        ifelse temp_name15 / memory * memory >= ee [ ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; here change memory back!!!!!!!!!!!!!!!!!!!!!!!
          set My_experience_information_list_product_2 replace-item 2 My_experience_information_list_product_2 1]
        [set My_experience_information_list_product_2 replace-item 2 My_experience_information_list_product_2 0]]]]



        if member? 3 products_switched_on = true [

    if (item 1 (item 1 (item 0 Decision_making_status_list_product_3))) = 0 and My_product = 0 and is_aware_product_3 = 1 [ ; chech here if remove the fact that households that have already adopted do not execute this step

      let d 0
      let f 0
      while [d < length households_with_whom_interacted][
        set f (item d households_with_whom_interacted)
        set temp_name14 []

        ;run (word "set temp_name14 [knowledge_of_relative_advantage_product_"cc"] of household "f)
        ask household f [
          ask myself [set temp_name14 [knowledge_of_relative_advantage_product_3] of myself]]

        if item 1 temp_name14 > 0 [
          set temp_name 0 ; s

          ;set temp_name [Category_number] of household f
          ask household f [
            ask myself [ set temp_name [Category_number] of myself]]
          set temp_name15 []
          set temp_name15 lput (item 0 temp_name14) temp_name15

          set temp_name2 0 ; m
          structure_preferred_information_source

          set temp_name15 lput temp_name2 temp_name15
          Ifelse category_number > 2 [set temp_name15 lput (memory) temp_name15]
          [set temp_name15 lput memory temp_name15]
          set temp_name15 lput 0 temp_name15
          set knowledge_relative_advantage_list_product_3 lput temp_name15 knowledge_relative_advantage_list_product_3]
        set d d + 1]


      if My_product = 0[
        let q 0
        set temp_name15 0
        while [ q < length knowledge_relative_advantage_list_product_3][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_relative_advantage_list_product_3))
          set q q + 1]


        let ee 0
        let ff 0
        while [ff < length threshold_to_reach_for_weights_information][
          if item 0 (item ff threshold_to_reach_for_weights_information) = Category_number [
            set ee item 1 (item ff threshold_to_reach_for_weights_information)
            ]
          set ff ff + 1]


        ifelse temp_name15 / memory * memory >= ee [ ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; here change memory back!!!!!!!!!!!!!!!!!!!!!!!
          set My_experience_information_list_product_3 replace-item 2 My_experience_information_list_product_3 1]
        [set My_experience_information_list_product_3 replace-item 2 My_experience_information_list_product_3 0]]]]



        if member? 4 products_switched_on = true [

    if (item 1 (item 1 (item 0 Decision_making_status_list_product_4))) = 0 and My_product = 0 and is_aware_product_4 = 1 [ ; chech here if remove the fact that households that have already adopted do not execute this step

      let d 0
      let f 0
      while [d < length households_with_whom_interacted][
        set f (item d households_with_whom_interacted)
        set temp_name14 []

        ;run (word "set temp_name14 [knowledge_of_relative_advantage_product_"cc"] of household "f)
        ask household f [
          ask myself [set temp_name14 [knowledge_of_relative_advantage_product_4] of myself]]

        if item 1 temp_name14 > 0 [
          set temp_name 0 ; s

          ;set temp_name [Category_number] of household f
          ask household f [
            ask myself [ set temp_name [Category_number] of myself]]
          set temp_name15 []
          set temp_name15 lput (item 0 temp_name14) temp_name15

          set temp_name2 0 ; m
          structure_preferred_information_source

          set temp_name15 lput temp_name2 temp_name15
          Ifelse category_number > 2 [set temp_name15 lput (memory) temp_name15]
          [set temp_name15 lput memory temp_name15]
          set temp_name15 lput 0 temp_name15
          set knowledge_relative_advantage_list_product_4 lput temp_name15 knowledge_relative_advantage_list_product_4]
        set d d + 1]


      if My_product = 0[
        let q 0
        set temp_name15 0
        while [ q < length knowledge_relative_advantage_list_product_4][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_relative_advantage_list_product_4))
          set q q + 1]


        let ee 0
        let ff 0
        while [ff < length threshold_to_reach_for_weights_information][
          if item 0 (item ff threshold_to_reach_for_weights_information) = Category_number [
            set ee item 1 (item ff threshold_to_reach_for_weights_information)
            ]
          set ff ff + 1]


        ifelse temp_name15 / memory * memory >= ee [ ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; here change memory back!!!!!!!!!!!!!!!!!!!!!!!
          set My_experience_information_list_product_4 replace-item 2 My_experience_information_list_product_4 1]
        [set My_experience_information_list_product_4 replace-item 2 My_experience_information_list_product_4 0]]]]



  ]
end

to make_final_judgment_enough_information
  ; In this step, for each product separatly, households controls if they have enough information to evaluate the product

  ask households [
    set products_switched_on shuffle products_switched_on

    if member? 1 products_switched_on = true[
      if is_aware_product_1 = 1 and My_product = 0 and (item 1 (item 1 (item 0 Decision_making_status_list_product_1)) = 0) [
        let f 0
        let x 0
        ; here, when a specific info is unnecessary for a specific adopter, the equivalent info is set to 'obtained' in the my_experience list
        while [x < (length My_experience_information_list_product_1 - 1)] [
          if item x My_critical_information_list = 0 [set My_experience_information_list_product_1 replace-item x My_experience_information_list_product_1 1]
          set x x + 1]


        let a 1
        let b 0
        while [a <= (length My_experience_information_list_product_1)] [
          if item (a - 1) My_experience_information_list_product_1 = 1
          [ set b b + 1]
          set a a + 1]
        ifelse b = length My_experience_information_list_product_1 [
          set Decision_making_status_list_product_1 (replace-item 1 Decision_making_status_list_product_1 (replace-item 1 (item 1 Decision_making_status_list_product_1 ) replace-item 0 (item 1 (item 1 Decision_making_status_list_product_1 )) 1))
          set new_households_with_enough_information new_households_with_enough_information + 1
          set information_step_done_product_1 1
        ][set f 1]]]

        if member? 2 products_switched_on = true[
      if is_aware_product_2 = 1 and My_product = 0 and (item 1 (item 1 (item 0 Decision_making_status_list_product_2)) = 0) [
        let f 0
        let x 0
        ; here, when a specific info is unnecessary for a specific adopter, the equivalent info is set to 'obtained' in the my_experience list
        while [x < (length My_experience_information_list_product_2 - 1)] [
          if item x My_critical_information_list = 0 [set My_experience_information_list_product_2 replace-item x My_experience_information_list_product_2 1]
          set x x + 1]


        let a 1
        let b 0
        while [a <= (length My_experience_information_list_product_2)] [
          if item (a - 1) My_experience_information_list_product_2 = 1
          [ set b b + 1]
          set a a + 1]
        ifelse b = length My_experience_information_list_product_2 [
          set Decision_making_status_list_product_2 (replace-item 1 Decision_making_status_list_product_2 (replace-item 1 (item 1 Decision_making_status_list_product_2 ) replace-item 0 (item 1 (item 1 Decision_making_status_list_product_2 )) 1))
          set new_households_with_enough_information new_households_with_enough_information + 1
          set information_step_done_product_2 1
        ][set f 1]]]

        if member? 3 products_switched_on = true[
      if is_aware_product_3 = 1 and My_product = 0 and (item 1 (item 1 (item 0 Decision_making_status_list_product_3)) = 0) [
        let f 0
        let x 0
        ; here, when a specific info is unnecessary for a specific adopter, the equivalent info is set to 'obtained' in the my_experience list
        while [x < (length My_experience_information_list_product_3 - 1)] [
          if item x My_critical_information_list = 0 [set My_experience_information_list_product_3 replace-item x My_experience_information_list_product_3 1]
          set x x + 1]


        let a 1
        let b 0
        while [a <= (length My_experience_information_list_product_3)] [
          if item (a - 1) My_experience_information_list_product_3 = 1
          [ set b b + 1]
          set a a + 1]
        ifelse b = length My_experience_information_list_product_3 [
          set Decision_making_status_list_product_3 (replace-item 1 Decision_making_status_list_product_3 (replace-item 1 (item 1 Decision_making_status_list_product_3 ) replace-item 0 (item 1 (item 1 Decision_making_status_list_product_3 )) 1))
          set new_households_with_enough_information new_households_with_enough_information + 1
          set information_step_done_product_3 1
        ][set f 1]]]

        if member? 4 products_switched_on = true[
      if is_aware_product_4 = 1 and My_product = 0 and (item 1 (item 1 (item 0 Decision_making_status_list_product_4)) = 0) [
        let f 0
        let x 0
        ; here, when a specific info is unnecessary for a specific adopter, the equivalent info is set to 'obtained' in the my_experience list
        while [x < (length My_experience_information_list_product_4 - 1)] [
          if item x My_critical_information_list = 0 [set My_experience_information_list_product_4 replace-item x My_experience_information_list_product_4 1]
          set x x + 1]


        let a 1
        let b 0
        while [a <= (length My_experience_information_list_product_4)] [
          if item (a - 1) My_experience_information_list_product_4 = 1
          [ set b b + 1]
          set a a + 1]
        ifelse b = length My_experience_information_list_product_4 [
          set Decision_making_status_list_product_4 (replace-item 1 Decision_making_status_list_product_4 (replace-item 1 (item 1 Decision_making_status_list_product_4 ) replace-item 0 (item 1 (item 1 Decision_making_status_list_product_4 )) 1))
          set new_households_with_enough_information new_households_with_enough_information + 1
          set information_step_done_product_4 1
        ][set f 1]]]



  ]
end

; here include two parts for complexity and compatibility (based on relative advantage), and one for observability/triability




to evaluation_relative_advantage_product
  ;first we make a evaluation of savings per product

  let tt shuffle product_list
  let bb 0
  while [bb < length tt][
    let aa item bb tt
    if Switch_product_1 = True and aa = 1 [
      ask households [
        if My_product = 0 and is_aware_product_1 = 1 and information_step_done_product_1 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_1)) = 0) [
          let q 0
          set temp_name15 0
          set temp_name14 0
          while [q < length knowledge_relative_advantage_list_product_1][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_relative_advantage_list_product_1))

            set q q + 1]
          set q 0
          while [q < length knowledge_relative_advantage_list_product_1][
            set temp_name14 temp_name14 + ((item 1 (item q knowledge_relative_advantage_list_product_1) / temp_name15)* item 0 (item q knowledge_relative_advantage_list_product_1))
            set q q + 1]

          let ee 0
          let ff 0
          while [ff < length A_S_L_Max_relative_advantage_tolerated][
            if item 0 (item ff A_S_L_Max_relative_advantage_tolerated) = Category_number [
              set ee item 1 (item ff A_S_L_Max_relative_advantage_tolerated)
            ]
            set ff ff + 1]


          ifelse temp_name14 <= ee [
            set Decision_making_status_list_product_1 (replace-item 2 Decision_making_status_list_product_1 (replace-item 1 (item 2 Decision_making_status_list_product_1 ) replace-item 2 (item 1 (item 2 Decision_making_status_list_product_1 )) 1))]
          [set Decision_making_status_list_product_1 (replace-item 2 Decision_making_status_list_product_1 (replace-item 1 (item 2 Decision_making_status_list_product_1 ) replace-item 2 (item 1 (item 2 Decision_making_status_list_product_1 )) 0))]]]
    ]

    if Switch_product_2 = True and aa = 2 [
      ask households [
        if My_product = 0 and is_aware_product_2 = 1 and information_step_done_product_2 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_2)) = 0) [
          let q 0
          set temp_name15 0
          set temp_name14 0
          while [q < length knowledge_relative_advantage_list_product_2][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_relative_advantage_list_product_2))

            set q q + 1]
          set q 0
          while [q < length knowledge_relative_advantage_list_product_2][
            set temp_name14 temp_name14 + ((item 1 (item q knowledge_relative_advantage_list_product_2) / temp_name15)* item 0 (item q knowledge_relative_advantage_list_product_2))
            set q q + 1]

          let ee 0
          let ff 0
          while [ff < length A_S_L_Max_relative_advantage_tolerated][
            if item 0 (item ff A_S_L_Max_relative_advantage_tolerated) = Category_number [
              set ee item 1 (item ff A_S_L_Max_relative_advantage_tolerated)
            ]
            set ff ff + 1]


          ifelse temp_name14 <= ee [
            set Decision_making_status_list_product_2 (replace-item 2 Decision_making_status_list_product_2 (replace-item 1 (item 2 Decision_making_status_list_product_2 ) replace-item 2 (item 1 (item 2 Decision_making_status_list_product_2 )) 1))]
          [set Decision_making_status_list_product_2 (replace-item 2 Decision_making_status_list_product_2 (replace-item 1 (item 2 Decision_making_status_list_product_2 ) replace-item 2 (item 1 (item 2 Decision_making_status_list_product_2 )) 0))]]]
    ]

    if Switch_product_3 = True and aa = 3 [
      ask households [
        if My_product = 0 and is_aware_product_3 = 1 and information_step_done_product_3 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_3)) = 0) [
          let q 0
          set temp_name15 0
          set temp_name14 0
          while [q < length knowledge_relative_advantage_list_product_3][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_relative_advantage_list_product_3))

            set q q + 1]
          set q 0
          while [q < length knowledge_relative_advantage_list_product_3][
            set temp_name14 temp_name14 + ((item 1 (item q knowledge_relative_advantage_list_product_3) / temp_name15)* item 0 (item q knowledge_relative_advantage_list_product_3))
            set q q + 1]

          let ee 0
          let ff 0
          while [ff < length A_S_L_Max_relative_advantage_tolerated][
            if item 0 (item ff A_S_L_Max_relative_advantage_tolerated) = Category_number [
              set ee item 1 (item ff A_S_L_Max_relative_advantage_tolerated)
            ]
            set ff ff + 1]


          ifelse temp_name14 <= ee [
            set Decision_making_status_list_product_3 (replace-item 2 Decision_making_status_list_product_3 (replace-item 1 (item 2 Decision_making_status_list_product_3 ) replace-item 2 (item 1 (item 2 Decision_making_status_list_product_3 )) 1))]
          [set Decision_making_status_list_product_3 (replace-item 2 Decision_making_status_list_product_3 (replace-item 1 (item 2 Decision_making_status_list_product_3 ) replace-item 2 (item 1 (item 2 Decision_making_status_list_product_3 )) 0))]]]
    ]

    if Switch_product_4 = True and aa = 4 [
      ask households [
        if My_product = 0 and is_aware_product_4 = 1 and information_step_done_product_4 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_4)) = 0) [
          let q 0
          set temp_name15 0
          set temp_name14 0
          while [q < length knowledge_relative_advantage_list_product_4][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_relative_advantage_list_product_4))

            set q q + 1]
          set q 0
          while [q < length knowledge_relative_advantage_list_product_4][
            set temp_name14 temp_name14 + ((item 1 (item q knowledge_relative_advantage_list_product_4) / temp_name15)* item 0 (item q knowledge_relative_advantage_list_product_4))
            set q q + 1]

          let ee 0
          let ff 0
          while [ff < length A_S_L_Max_relative_advantage_tolerated][
            if item 0 (item ff A_S_L_Max_relative_advantage_tolerated) = Category_number [
              set ee item 1 (item ff A_S_L_Max_relative_advantage_tolerated)
            ]
            set ff ff + 1]


          ifelse temp_name14 <= ee [
            set Decision_making_status_list_product_4 (replace-item 2 Decision_making_status_list_product_4 (replace-item 1 (item 2 Decision_making_status_list_product_4 ) replace-item 2 (item 1 (item 2 Decision_making_status_list_product_4 )) 1))]
          [set Decision_making_status_list_product_4 (replace-item 2 Decision_making_status_list_product_4 (replace-item 1 (item 2 Decision_making_status_list_product_4 ) replace-item 2 (item 1 (item 2 Decision_making_status_list_product_4 )) 0))]]]
    ]

    set bb bb + 1]
end



to evaluation_complexity
  ;first we make a evaluation of savings per product

  let tt shuffle product_list
  let bb 0
  while [bb < length tt][
    let aa item bb tt
    if Switch_product_1 = True and aa = 1[
        ask households [
          if My_product = 0 and is_aware_product_1 = 1 and information_step_done_product_1 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_1)) = 0) [
            let q 0
            set temp_name15 0
            set temp_name14 0
            while [q < length knowledge_complexity_list_product_1][
                set temp_name15 (temp_name15 + item 1 (item q knowledge_complexity_list_product_1))
              set q q + 1]
            set q 0
            while [q < length knowledge_complexity_list_product_1][
                set temp_name14 temp_name14 + ((item 1 (item q knowledge_complexity_list_product_1) / temp_name15)* item 0 (item q knowledge_complexity_list_product_1))
              set q q + 1]
            let ee 0
            let ff 0
            while [ff < length A_S_L_Max_complexity_tolerated][
              if item 0 (item ff A_S_L_Max_complexity_tolerated) = Category_number [
                set ee item 1 (item ff A_S_L_Max_complexity_tolerated)
              ]
              set ff ff + 1]
            ifelse temp_name14 <= ee [
             set Decision_making_status_list_product_1 (replace-item 2 Decision_making_status_list_product_1 (replace-item 1 (item 2 Decision_making_status_list_product_1 ) replace-item 0 (item 1 (item 2 Decision_making_status_list_product_1 )) 1))]
            [set Decision_making_status_list_product_1 (replace-item 2 Decision_making_status_list_product_1 (replace-item 1 (item 2 Decision_making_status_list_product_1 ) replace-item 0 (item 1 (item 2 Decision_making_status_list_product_1 )) 0))]]]
    ]


        if Switch_product_2 = True and aa = 2[
        ask households [
          if My_product = 0 and is_aware_product_2 = 1 and information_step_done_product_2 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_2)) = 0) [
            let q 0
            set temp_name15 0
            set temp_name14 0
            while [q < length knowledge_complexity_list_product_2][
                set temp_name15 (temp_name15 + item 1 (item q knowledge_complexity_list_product_2))
              set q q + 1]
            set q 0
            while [q < length knowledge_complexity_list_product_2][
                set temp_name14 temp_name14 + ((item 1 (item q knowledge_complexity_list_product_2) / temp_name15)* item 0 (item q knowledge_complexity_list_product_2))
              set q q + 1]
            let ee 0
            let ff 0
            while [ff < length A_S_L_Max_complexity_tolerated][
              if item 0 (item ff A_S_L_Max_complexity_tolerated) = Category_number [
                set ee item 1 (item ff A_S_L_Max_complexity_tolerated)
              ]
              set ff ff + 1]
            ifelse temp_name14 <= ee [
             set Decision_making_status_list_product_2 (replace-item 2 Decision_making_status_list_product_2 (replace-item 1 (item 2 Decision_making_status_list_product_2 ) replace-item 0 (item 1 (item 2 Decision_making_status_list_product_2 )) 1))]
            [set Decision_making_status_list_product_2 (replace-item 2 Decision_making_status_list_product_2 (replace-item 1 (item 2 Decision_making_status_list_product_2 ) replace-item 0 (item 1 (item 2 Decision_making_status_list_product_2 )) 0))]]]
    ]

        if Switch_product_3 = True and aa = 3[
        ask households [
          if My_product = 0 and is_aware_product_3 = 1 and information_step_done_product_3 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_3)) = 0) [
            let q 0
            set temp_name15 0
            set temp_name14 0
            while [q < length knowledge_complexity_list_product_3][
                set temp_name15 (temp_name15 + item 1 (item q knowledge_complexity_list_product_3))
              set q q + 1]
            set q 0
            while [q < length knowledge_complexity_list_product_3][
                set temp_name14 temp_name14 + ((item 1 (item q knowledge_complexity_list_product_3) / temp_name15)* item 0 (item q knowledge_complexity_list_product_3))
              set q q + 1]
            let ee 0
            let ff 0
            while [ff < length A_S_L_Max_complexity_tolerated][
              if item 0 (item ff A_S_L_Max_complexity_tolerated) = Category_number [
                set ee item 1 (item ff A_S_L_Max_complexity_tolerated)
              ]
              set ff ff + 1]
            ifelse temp_name14 <= ee [
             set Decision_making_status_list_product_3 (replace-item 2 Decision_making_status_list_product_3 (replace-item 1 (item 2 Decision_making_status_list_product_3 ) replace-item 0 (item 1 (item 2 Decision_making_status_list_product_3 )) 1))]
            [set Decision_making_status_list_product_3 (replace-item 2 Decision_making_status_list_product_3 (replace-item 1 (item 2 Decision_making_status_list_product_3 ) replace-item 0 (item 1 (item 2 Decision_making_status_list_product_3 )) 0))]]]
    ]

        if Switch_product_4 = True and aa = 4[
        ask households [
          if My_product = 0 and is_aware_product_4 = 1 and information_step_done_product_4 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_4)) = 0) [
            let q 0
            set temp_name15 0
            set temp_name14 0
            while [q < length knowledge_complexity_list_product_4][
                set temp_name15 (temp_name15 + item 1 (item q knowledge_complexity_list_product_4))
              set q q + 1]
            set q 0
            while [q < length knowledge_complexity_list_product_4][
                set temp_name14 temp_name14 + ((item 1 (item q knowledge_complexity_list_product_4) / temp_name15)* item 0 (item q knowledge_complexity_list_product_4))
              set q q + 1]
            let ee 0
            let ff 0
            while [ff < length A_S_L_Max_complexity_tolerated][
              if item 0 (item ff A_S_L_Max_complexity_tolerated) = Category_number [
                set ee item 1 (item ff A_S_L_Max_complexity_tolerated)
              ]
              set ff ff + 1]
            ifelse temp_name14 <= ee [
             set Decision_making_status_list_product_4 (replace-item 2 Decision_making_status_list_product_4 (replace-item 1 (item 2 Decision_making_status_list_product_4 ) replace-item 0 (item 1 (item 2 Decision_making_status_list_product_4 )) 1))]
            [set Decision_making_status_list_product_4 (replace-item 2 Decision_making_status_list_product_4 (replace-item 1 (item 2 Decision_making_status_list_product_4 ) replace-item 0 (item 1 (item 2 Decision_making_status_list_product_4 )) 0))]]]
    ]


      set bb bb + 1]
end

to evaluation_compatibility
  ;first we make a evaluation of savings per product

  let tt shuffle product_list
  let bb 0
  while [bb < length tt][
    let aa item bb tt

    if Switch_product_1 = True and aa = 1 [
    ask households [
      if My_product = 0 and is_aware_product_1 = 1 and information_step_done_product_1 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_1)) = 0) [
        let q 0
        set temp_name15 0
        set temp_name14 0
        while [q < length knowledge_compatibility_list_product_1][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_compatibility_list_product_1))
          set q q + 1]
        set q 0
        while [q < length knowledge_compatibility_list_product_1][
            set temp_name14 temp_name14 + ((item 1 (item q knowledge_compatibility_list_product_1) / temp_name15)* item 0 (item q knowledge_compatibility_list_product_1))
          set q q + 1]
        let ee 0
        let ff 0
        while [ff < length A_S_L_Max_compatibility_tolerated][
          if item 0 (item ff A_S_L_Max_compatibility_tolerated) = Category_number [
            set ee item 1 (item ff A_S_L_Max_compatibility_tolerated)
          ]
          set ff ff + 1]
        ifelse temp_name14 <= ee [
          set Decision_making_status_list_product_1 (replace-item 2 Decision_making_status_list_product_1 (replace-item 1 (item 2 Decision_making_status_list_product_1 ) replace-item 1 (item 1 (item 2 Decision_making_status_list_product_1 )) 1))]
            [set Decision_making_status_list_product_1 (replace-item 2 Decision_making_status_list_product_1 (replace-item 1 (item 2 Decision_making_status_list_product_1 ) replace-item 1 (item 1 (item 2 Decision_making_status_list_product_1 )) 0))]]]
    ]

        if Switch_product_2 = True and aa = 2 [
    ask households [
      if My_product = 0 and is_aware_product_2 = 1 and information_step_done_product_2 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_2)) = 0) [
        let q 0
        set temp_name15 0
        set temp_name14 0
        while [q < length knowledge_compatibility_list_product_2][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_compatibility_list_product_2))
          set q q + 1]
        set q 0
        while [q < length knowledge_compatibility_list_product_2][
            set temp_name14 temp_name14 + ((item 1 (item q knowledge_compatibility_list_product_2) / temp_name15)* item 0 (item q knowledge_compatibility_list_product_2))
          set q q + 1]
        let ee 0
        let ff 0
        while [ff < length A_S_L_Max_compatibility_tolerated][
          if item 0 (item ff A_S_L_Max_compatibility_tolerated) = Category_number [
            set ee item 1 (item ff A_S_L_Max_compatibility_tolerated)
          ]
          set ff ff + 1]
        ifelse temp_name14 <= ee [
          set Decision_making_status_list_product_2 (replace-item 2 Decision_making_status_list_product_2 (replace-item 1 (item 2 Decision_making_status_list_product_2 ) replace-item 1 (item 1 (item 2 Decision_making_status_list_product_2 )) 1))]
            [set Decision_making_status_list_product_2 (replace-item 2 Decision_making_status_list_product_2 (replace-item 1 (item 2 Decision_making_status_list_product_2 ) replace-item 1 (item 1 (item 2 Decision_making_status_list_product_2 )) 0))]]]
    ]

        if Switch_product_3 = True and aa = 3 [
    ask households [
      if My_product = 0 and is_aware_product_3 = 1 and information_step_done_product_3 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_3)) = 0) [
        let q 0
        set temp_name15 0
        set temp_name14 0
        while [q < length knowledge_compatibility_list_product_3][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_compatibility_list_product_3))
          set q q + 1]
        set q 0
        while [q < length knowledge_compatibility_list_product_3][
            set temp_name14 temp_name14 + ((item 1 (item q knowledge_compatibility_list_product_3) / temp_name15)* item 0 (item q knowledge_compatibility_list_product_3))
          set q q + 1]
        let ee 0
        let ff 0
        while [ff < length A_S_L_Max_compatibility_tolerated][
          if item 0 (item ff A_S_L_Max_compatibility_tolerated) = Category_number [
            set ee item 1 (item ff A_S_L_Max_compatibility_tolerated)
          ]
          set ff ff + 1]
        ifelse temp_name14 <= ee [
          set Decision_making_status_list_product_3 (replace-item 2 Decision_making_status_list_product_3 (replace-item 1 (item 2 Decision_making_status_list_product_3 ) replace-item 1 (item 1 (item 2 Decision_making_status_list_product_3 )) 1))]
            [set Decision_making_status_list_product_3 (replace-item 2 Decision_making_status_list_product_3 (replace-item 1 (item 2 Decision_making_status_list_product_3 ) replace-item 1 (item 1 (item 2 Decision_making_status_list_product_3 )) 0))]]]
    ]

        if Switch_product_4 = True and aa = 4 [
    ask households [
      if My_product = 0 and is_aware_product_4 = 1 and information_step_done_product_4 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_4)) = 0) [
        let q 0
        set temp_name15 0
        set temp_name14 0
        while [q < length knowledge_compatibility_list_product_4][
            set temp_name15 (temp_name15 + item 1 (item q knowledge_compatibility_list_product_4))
          set q q + 1]
        set q 0
        while [q < length knowledge_compatibility_list_product_4][
            set temp_name14 temp_name14 + ((item 1 (item q knowledge_compatibility_list_product_4) / temp_name15)* item 0 (item q knowledge_compatibility_list_product_4))
          set q q + 1]
        let ee 0
        let ff 0
        while [ff < length A_S_L_Max_compatibility_tolerated][
          if item 0 (item ff A_S_L_Max_compatibility_tolerated) = Category_number [
            set ee item 1 (item ff A_S_L_Max_compatibility_tolerated)
          ]
          set ff ff + 1]
        ifelse temp_name14 <= ee [
          set Decision_making_status_list_product_4 (replace-item 2 Decision_making_status_list_product_4 (replace-item 1 (item 2 Decision_making_status_list_product_4 ) replace-item 1 (item 1 (item 2 Decision_making_status_list_product_4 )) 1))]
            [set Decision_making_status_list_product_4 (replace-item 2 Decision_making_status_list_product_4 (replace-item 1 (item 2 Decision_making_status_list_product_4 ) replace-item 1 (item 1 (item 2 Decision_making_status_list_product_4 )) 0))]]]
    ]





      set bb bb + 1]
end

to evaluation_observability_triability

  let tt shuffle product_list
  let bb 0
  while [bb < length tt][
    let aa item bb tt
    if Switch_product_1 = True and aa = 1 [
    ask households [
      if My_product = 0 and is_aware_product_1 = 1 and information_step_done_product_1 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_1)) = 0) [

        let ee 0
        let ff 0
        while [ff < length A_S_L_Max_observability_triability_tolerated][
          if item 0 (item ff A_S_L_Max_observability_triability_tolerated) = Category_number [
            set ee item 1 (item ff A_S_L_Max_observability_triability_tolerated)
          ]
          set ff ff + 1]
        ifelse ee >= Triability_and_observability_product_1 [
          set Decision_making_status_list_product_1 (replace-item 2 Decision_making_status_list_product_1 (replace-item 1 (item 2 Decision_making_status_list_product_1 ) replace-item 3 (item 1 (item 2 Decision_making_status_list_product_1 )) 1))]
        [set Decision_making_status_list_product_1 (replace-item 2 Decision_making_status_list_product_1 (replace-item 1 (item 2 Decision_making_status_list_product_1 ) replace-item 3 (item 1 (item 2 Decision_making_status_list_product_1 )) 0))]]]
    ]


        if Switch_product_2 = True and aa = 2 [
    ask households [
      if My_product = 0 and is_aware_product_2 = 1 and information_step_done_product_2 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_2)) = 0) [

        let ee 0
        let ff 0
        while [ff < length A_S_L_Max_observability_triability_tolerated][
          if item 0 (item ff A_S_L_Max_observability_triability_tolerated) = Category_number [
            set ee item 1 (item ff A_S_L_Max_observability_triability_tolerated)
          ]
          set ff ff + 1]
        ifelse ee >= Triability_and_observability_product_2 [
          set Decision_making_status_list_product_2 (replace-item 2 Decision_making_status_list_product_2 (replace-item 1 (item 2 Decision_making_status_list_product_2 ) replace-item 3 (item 1 (item 2 Decision_making_status_list_product_2 )) 1))]
        [set Decision_making_status_list_product_2 (replace-item 2 Decision_making_status_list_product_2 (replace-item 1 (item 2 Decision_making_status_list_product_2 ) replace-item 3 (item 1 (item 2 Decision_making_status_list_product_2 )) 0))]]]
    ]

        if Switch_product_3 = True and aa = 3 [
    ask households [
      if My_product = 0 and is_aware_product_3 = 1 and information_step_done_product_3 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_3)) = 0) [

        let ee 0
        let ff 0
        while [ff < length A_S_L_Max_observability_triability_tolerated][
          if item 0 (item ff A_S_L_Max_observability_triability_tolerated) = Category_number [
            set ee item 1 (item ff A_S_L_Max_observability_triability_tolerated)
          ]
          set ff ff + 1]
        ifelse ee >= Triability_and_observability_product_3 [
          set Decision_making_status_list_product_3 (replace-item 2 Decision_making_status_list_product_3 (replace-item 1 (item 2 Decision_making_status_list_product_3 ) replace-item 3 (item 1 (item 2 Decision_making_status_list_product_3 )) 1))]
        [set Decision_making_status_list_product_3 (replace-item 2 Decision_making_status_list_product_3 (replace-item 1 (item 2 Decision_making_status_list_product_3 ) replace-item 3 (item 1 (item 2 Decision_making_status_list_product_3 )) 0))]]]
    ]

        if Switch_product_4 = True and aa = 4 [
    ask households [
      if My_product = 0 and is_aware_product_4 = 1 and information_step_done_product_4 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_4)) = 0) [

        let ee 0
        let ff 0
        while [ff < length A_S_L_Max_observability_triability_tolerated][
          if item 0 (item ff A_S_L_Max_observability_triability_tolerated) = Category_number [
            set ee item 1 (item ff A_S_L_Max_observability_triability_tolerated)
          ]
          set ff ff + 1]
        ifelse ee >= Triability_and_observability_product_4 [
          set Decision_making_status_list_product_4 (replace-item 2 Decision_making_status_list_product_4 (replace-item 1 (item 2 Decision_making_status_list_product_4 ) replace-item 3 (item 1 (item 2 Decision_making_status_list_product_4 )) 1))]
        [set Decision_making_status_list_product_4 (replace-item 2 Decision_making_status_list_product_4 (replace-item 1 (item 2 Decision_making_status_list_product_4 ) replace-item 3 (item 1 (item 2 Decision_making_status_list_product_4 )) 0))]]]
    ]
    set bb bb + 1]

end

to final_judgement_evaluation

  let tt shuffle product_list
  let bb 0
  while [bb < length tt][
    let aa item bb tt
    if Switch_product_1 = True and aa = 1 [
    ask households [
      if My_product = 0 and is_aware_product_1 = 1 and information_step_done_product_1 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_1)) = 0) [
        ifelse sum item 1 (item 2 Decision_making_status_list_product_1) = 4 [
          set Decision_making_status_list_product_1 replace-item 0 Decision_making_status_list_product_1 (replace-item 1 (item 0 Decision_making_status_list_product_1) (replace-item 0 (item 1 (item 0 Decision_making_status_list_product_1)) 1))
          set My_product aa
          set color item aa household_product_colors
          set knowledge_of_complexity_product_1 replace-item 0 knowledge_of_complexity_product_1 current_complexity_product_1
          set knowledge_of_complexity_product_1 replace-item 1 knowledge_of_complexity_product_1 Duration_information_validity

          set knowledge_of_compatibility_product_1 replace-item 0 knowledge_of_compatibility_product_1 current_compatibility_product_1
          set knowledge_of_compatibility_product_1 replace-item 1 knowledge_of_compatibility_product_1 Duration_information_validity

          set knowledge_of_relative_advantage_product_1 replace-item 0 knowledge_of_relative_advantage_product_1 current_relative_advantage_product_1
          set knowledge_of_relative_advantage_product_1 replace-item 1 knowledge_of_relative_advantage_product_1 Duration_information_validity

          set final_evaluation_product_1 1
          set new_households_with_evaluation_OK new_households_with_evaluation_OK + 1]
        [set Decision_making_status_list_product_1 replace-item 0 Decision_making_status_list_product_1 (replace-item 1 (item 0 Decision_making_status_list_product_1) (replace-item 0 (item 1 (item 0 Decision_making_status_list_product_1)) 0))
          set final_evaluation_product_1 0
          set My_product 0

          set is_aware_product_1 0

          set information_step_done_product_1 0
          set awareness_step_done_product_1 0
          set knowledge_complexity_list_product_1 []
          set knowledge_compatibility_list_product_1 []
          set knowledge_relative_advantage_list_product_1 []
          set product_awareness_process_product_1 []
          ]]]]


        if Switch_product_2 = True and aa = 2 [
    ask households [
      if My_product = 0 and is_aware_product_2 = 1 and information_step_done_product_2 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_2)) = 0) [
        ifelse sum item 1 (item 2 Decision_making_status_list_product_2) = 4 [
          set Decision_making_status_list_product_2 replace-item 0 Decision_making_status_list_product_2 (replace-item 1 (item 0 Decision_making_status_list_product_2) (replace-item 0 (item 1 (item 0 Decision_making_status_list_product_2)) 1))
          set My_product aa
          set color item aa household_product_colors
          set knowledge_of_complexity_product_2 replace-item 0 knowledge_of_complexity_product_2 current_complexity_product_2
          set knowledge_of_complexity_product_2 replace-item 1 knowledge_of_complexity_product_2 Duration_information_validity

          set knowledge_of_compatibility_product_2 replace-item 0 knowledge_of_compatibility_product_2 current_compatibility_product_2
          set knowledge_of_compatibility_product_2 replace-item 1 knowledge_of_compatibility_product_2 Duration_information_validity

          set knowledge_of_relative_advantage_product_2 replace-item 0 knowledge_of_relative_advantage_product_2 current_relative_advantage_product_2
          set knowledge_of_relative_advantage_product_2 replace-item 1 knowledge_of_relative_advantage_product_2 Duration_information_validity

          set final_evaluation_product_2 1
          set new_households_with_evaluation_OK new_households_with_evaluation_OK + 1]
        [set Decision_making_status_list_product_2 replace-item 0 Decision_making_status_list_product_2 (replace-item 1 (item 0 Decision_making_status_list_product_2) (replace-item 0 (item 1 (item 0 Decision_making_status_list_product_2)) 0))
          set final_evaluation_product_2 0
          set My_product 0

          set is_aware_product_2 0

          set information_step_done_product_2 0
          set awareness_step_done_product_2 0
          set knowledge_complexity_list_product_2 []
          set knowledge_compatibility_list_product_2 []
          set knowledge_relative_advantage_list_product_2 []
          set product_awareness_process_product_2 []
          ]]]]


        if Switch_product_3 = True and aa = 3 [
    ask households [
      if My_product = 0 and is_aware_product_3 = 1 and information_step_done_product_3 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_3)) = 0) [
        ifelse sum item 1 (item 2 Decision_making_status_list_product_3) = 4 [
          set Decision_making_status_list_product_3 replace-item 0 Decision_making_status_list_product_3 (replace-item 1 (item 0 Decision_making_status_list_product_3) (replace-item 0 (item 1 (item 0 Decision_making_status_list_product_3)) 1))
          set My_product aa
          set color item aa household_product_colors
          set knowledge_of_complexity_product_3 replace-item 0 knowledge_of_complexity_product_3 current_complexity_product_3
          set knowledge_of_complexity_product_3 replace-item 1 knowledge_of_complexity_product_3 Duration_information_validity

          set knowledge_of_compatibility_product_3 replace-item 0 knowledge_of_compatibility_product_3 current_compatibility_product_3
          set knowledge_of_compatibility_product_3 replace-item 1 knowledge_of_compatibility_product_3 Duration_information_validity

          set knowledge_of_relative_advantage_product_3 replace-item 0 knowledge_of_relative_advantage_product_3 current_relative_advantage_product_3
          set knowledge_of_relative_advantage_product_3 replace-item 1 knowledge_of_relative_advantage_product_3 Duration_information_validity

          set final_evaluation_product_3 1
          set new_households_with_evaluation_OK new_households_with_evaluation_OK + 1]
        [set Decision_making_status_list_product_3 replace-item 0 Decision_making_status_list_product_3 (replace-item 1 (item 0 Decision_making_status_list_product_3) (replace-item 0 (item 1 (item 0 Decision_making_status_list_product_3)) 0))
          set final_evaluation_product_3 0
          set My_product 0

          set is_aware_product_3 0

          set information_step_done_product_3 0
          set awareness_step_done_product_3 0
          set knowledge_complexity_list_product_3 []
          set knowledge_compatibility_list_product_3 []
          set knowledge_relative_advantage_list_product_3 []
          set product_awareness_process_product_3 []
          ]]]]


        if Switch_product_4 = True and aa = 4 [
    ask households [
      if My_product = 0 and is_aware_product_4 = 1 and information_step_done_product_4 = 1 and (item 1 (item 1 (item 0 Decision_making_status_list_product_4)) = 0) [
        ifelse sum item 1 (item 2 Decision_making_status_list_product_4) = 4 [
          set Decision_making_status_list_product_4 replace-item 0 Decision_making_status_list_product_4 (replace-item 1 (item 0 Decision_making_status_list_product_4) (replace-item 0 (item 1 (item 0 Decision_making_status_list_product_4)) 1))
          set My_product aa
          set color item aa household_product_colors
          set knowledge_of_complexity_product_4 replace-item 0 knowledge_of_complexity_product_4 current_complexity_product_4
          set knowledge_of_complexity_product_4 replace-item 1 knowledge_of_complexity_product_4 Duration_information_validity

          set knowledge_of_compatibility_product_4 replace-item 0 knowledge_of_compatibility_product_4 current_compatibility_product_4
          set knowledge_of_compatibility_product_4 replace-item 1 knowledge_of_compatibility_product_4 Duration_information_validity

          set knowledge_of_relative_advantage_product_4 replace-item 0 knowledge_of_relative_advantage_product_4 current_relative_advantage_product_4
          set knowledge_of_relative_advantage_product_4 replace-item 1 knowledge_of_relative_advantage_product_4 Duration_information_validity

          set final_evaluation_product_4 1
          set new_households_with_evaluation_OK new_households_with_evaluation_OK + 1]
        [set Decision_making_status_list_product_4 replace-item 0 Decision_making_status_list_product_4 (replace-item 1 (item 0 Decision_making_status_list_product_4) (replace-item 0 (item 1 (item 0 Decision_making_status_list_product_4)) 0))
          set final_evaluation_product_4 0
          set My_product 0

          set is_aware_product_4 0

          set information_step_done_product_4 0
          set awareness_step_done_product_4 0
          set knowledge_complexity_list_product_4 []
          set knowledge_compatibility_list_product_4 []
          set knowledge_relative_advantage_list_product_4 []
          set product_awareness_process_product_4 []
          ]]]]

    set bb bb + 1]
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;    this part is for monitoring     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to for_monitoring
;  print "Starting for_monitoring"
;
;  ;; Check if list_new_households_aware is a list
;  ifelse is-list? list_new_households_aware [
;    print "list_new_households_aware is a list"
;  ] [
;    print "Error: list_new_households_aware is not a list"
;  ]
;  ;; Print the contents of list_new_households_aware
;  print (word "list_new_households_aware: " list_new_households_aware)
;  ;; Print the length of list_new_households_aware
;  print (word "Length of list_new_households_aware: " length list_new_households_aware)
;  ;; Check the length condition and proceed
  if length list_new_households_aware > 12 [
    set list_new_households_aware remove-item 0 list_new_households_aware]
  set list_new_households_aware lput new_households_aware list_new_households_aware
  set new_households_aware_stat sum list_new_households_aware
  set new_households_aware 0

  if length list_new_households_with_enough_information > 12 [
    set list_new_households_with_enough_information remove-item 0 list_new_households_with_enough_information]
  set list_new_households_with_enough_information lput new_households_with_enough_information list_new_households_with_enough_information
  set new_households_with_enough_information_stat sum list_new_households_with_enough_information
  set new_households_with_enough_information 0

  if length list_new_households_with_evaluation_OK > 12 [
    set list_new_households_with_evaluation_OK remove-item 0 list_new_households_with_evaluation_OK]
  set list_new_households_with_evaluation_OK lput new_households_with_evaluation_OK list_new_households_with_evaluation_OK
  set new_households_with_evaluation_OK_stat sum list_new_households_with_evaluation_OK
  set new_households_with_evaluation_OK 0

  if length list_new_households_with_complexity_OK > 12 [
    set list_new_households_with_complexity_OK remove-item 0 list_new_households_with_complexity_OK]
  set list_new_households_with_complexity_OK lput new_households_with_complexity_OK list_new_households_with_complexity_OK
  set new_households_with_complexity_OK_stat sum list_new_households_with_complexity_OK
  set new_households_with_complexity_OK 0

  if length list_new_households_with_products > 12 [
    set list_new_households_with_products remove-item 0 list_new_households_with_products]
  set list_new_households_with_products lput new_households_with_product list_new_households_with_products
  set new_households_with_product_stat sum list_new_households_with_products
  set new_households_with_product 0

  set percentage_of_households_aware count households with [is_aware_product_1 = 1] / (count households + number_of_households_not_participating) * 100

  ifelse count households with [category_number = 1] = 0 [set percentage_of_innovators_with_products 0]
  [set percentage_of_innovators_with_products (count households with [category_number = 1 and my_product != 0]) / count households with [category_number = 1] * 100]
  ifelse count households with [category_number = 2] = 0 [set percentage_of_early_adopters_with_products 0]
  [set percentage_of_early_adopters_with_products (count households with [category_number = 2 and my_product != 0]) / count households with [category_number = 2] * 100]
  ifelse count households with [category_number = 3] = 0 [set percentage_of_early_majority_with_products 0]
  [set percentage_of_early_majority_with_products (count households with [category_number = 3 and my_product != 0]) / count households with [category_number = 3] * 100]
  ifelse count households with [category_number = 4] = 0 [set percentage_of_late_majority_with_products 0]
  [set percentage_of_late_majority_with_products (count households with [category_number = 4 and my_product != 0]) / count households with [category_number = 4] * 100]
  ifelse count households with [category_number = 5] = 0 [set percentage_of_laggards_with_products 0]
  [set percentage_of_laggards_with_products (count households with [category_number = 5 and my_product != 0]) / count households with [category_number = 5] * 100]

  let temp_complex_block 0
  let temp_complex_not_block 0


  set number_of_households_owning_product_1 (count households with [My_product = 1] / count households * 100)
  set number_of_households_owning_product_2 (count households with [My_product = 2] / count households * 100)
  set number_of_households_owning_product_3 (count households with [My_product = 3] / count households * 100)
  set number_of_households_owning_product_4 (count households with [My_product = 4] / count households * 100)
  set number_of_households_not_owning_product count households with [My_product = 0]
  set number_of_households_aware count households with [My_product = 0 and (is_aware_product_1 = 1 or is_aware_product_2 = 1 or is_aware_product_3 = 1 or is_aware_product_4 = 1)]



  ifelse early_adopters_just_accepted + temp_complex_block > 0 [set block_at_complexity_early_adopters_percentage temp_complex_block / (temp_complex_block + early_adopters_just_accepted)][set block_at_complexity_early_adopters_percentage 0]
;  print temp_complex_block
;  print temp_complex_not_block

 let c1 3
 let c2 29
 let c3 200
 let c4 300
 let c5 480

; This code produced the error "LENGTH expected input to be a string or list but got the number 0 instead." Changing it to the one below
; ask households [if who = c1 [if length households_with_whom_interacted > 0 [set households_with_whom_interacted_c1 length households_with_whom_interacted]]]
; ask households [if who = c2 [if length households_with_whom_interacted > 0 [set households_with_whom_interacted_c2 length households_with_whom_interacted]]]
; ask households [if who = c3 [if length households_with_whom_interacted > 0 [set households_with_whom_interacted_c3 length households_with_whom_interacted]]]
; ask households [if who = c4 [if length households_with_whom_interacted > 0 [set households_with_whom_interacted_c4 length households_with_whom_interacted]]]
; ask households [if who = c5 [if length households_with_whom_interacted > 0 [set households_with_whom_interacted_c5 length households_with_whom_interacted]]]

ask households [
  if who = c1 [
    if is-list? households_with_whom_interacted or is-string? households_with_whom_interacted [
      if length households_with_whom_interacted > 0 [
        set households_with_whom_interacted_c1 length households_with_whom_interacted
      ]
    ]
  ]
]

ask households [
  if who = c2 [
    if is-list? households_with_whom_interacted or is-string? households_with_whom_interacted [
      if length households_with_whom_interacted > 0 [
        set households_with_whom_interacted_c2 length households_with_whom_interacted
      ]
    ]
  ]
]

ask households [
  if who = c3 [
    if is-list? households_with_whom_interacted or is-string? households_with_whom_interacted [
      if length households_with_whom_interacted > 0 [
        set households_with_whom_interacted_c3 length households_with_whom_interacted
      ]
    ]
  ]
]

ask households [
  if who = c4 [
    if is-list? households_with_whom_interacted or is-string? households_with_whom_interacted [
      if length households_with_whom_interacted > 0 [
        set households_with_whom_interacted_c4 length households_with_whom_interacted
      ]
    ]
  ]
]

ask households [
  if who = c5 [
    if is-list? households_with_whom_interacted or is-string? households_with_whom_interacted [
      if length households_with_whom_interacted > 0 [
        set households_with_whom_interacted_c5 length households_with_whom_interacted
      ]
    ]
  ]
]


end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;    this part will group different structures that are used recurently accross the model     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to structure_creation_list_adopters
  let c 0
  let d 0
  while [c < length runresult (temp_for_creation_adopter_properties)][
    set d runresult (word temp_for_creation_adopter_properties"_"(c + 1))
    run (word "set "temp_for_creation_adopter_properties" replace-item c "temp_for_creation_adopter_properties" (replace-item 1 (item c "temp_for_creation_adopter_properties") d)")
    set c c + 1]
  let a runresult (temp_for_creation_adopter_properties)
end

to structure_creation_list_scenarios
  let c 0
  let d 0
  while [c < length runresult (temp_for_creation_scenario_properties)][
    set d runresult (word temp_for_creation_scenario_properties"_"(c + 1))
    run (word "set "temp_for_creation_scenario_properties" replace-item c "temp_for_creation_scenario_properties" (replace-item 1 (item c "temp_for_creation_scenario_properties") d)")
    set c c + 1]
end

to structure_creation_list_preferred_information
  let c 0
  let d 0
  repeat 5[
    set d runresult (word temp_for_creation_preferred_information_properties"_"(c + 1))
    run (word "set "temp_for_creation_preferred_information_properties" lput d "temp_for_creation_preferred_information_properties)
    set c c + 1]
end

to structure_uniformity_interactions
  let l 0
  let m 0
  set l runresult temp_name
  set m (1 * variation_of_SD_normal_distribution_properties_of_adopters)
  run (word "set "temp_name" int (random-normal (l + .5) m)")
  if (runresult temp_name) < 1 [
    run (word "set "temp_name" 1")]
end

to structure_uniformity_awareness
  let l 0
  let m 0
  set l runresult temp_name
  set m (1 * variation_of_SD_normal_distribution_properties_of_adopters)
  run (word "set "temp_name" int (random-normal (l + .5) m)")
  if (runresult temp_name) < 0 [
    run (word "set "temp_name" 0")]
end

to structure_preferred_information_source

  if Category_number = 1 [
    set temp_name2 item (temp_name - 1) A_S_L_preferred_information_source_innovator
          if Normality_of_adopter_properties = True [
    structure_uniformity_for_preferred_information_source]]

  if Category_number = 2 [
    set temp_name2 item (temp_name - 1) A_S_L_preferred_information_source_early_adopter
          if Normality_of_adopter_properties = True [
    structure_uniformity_for_preferred_information_source]]

  if Category_number = 3 [
    set temp_name2 item (temp_name - 1) A_S_L_preferred_information_source_early_majority
          if Normality_of_adopter_properties = True [
    structure_uniformity_for_preferred_information_source]]

  if Category_number = 4 [
    set temp_name2 item (temp_name - 1) A_S_L_preferred_information_source_late_majority
          if Normality_of_adopter_properties = True [
    structure_uniformity_for_preferred_information_source]]

  if Category_number = 5 [
    set temp_name2 item (temp_name - 1) A_S_L_preferred_information_source_laggard
          if Normality_of_adopter_properties = True [
    structure_uniformity_for_preferred_information_source]]
end

to structure_uniformity_for_preferred_information_source
      let l temp_name2
      let m (0.05 * variation_of_SD_normal_distribution_properties_of_adopters)
      set temp_name2 random-normal l m
      if temp_name2 < 0 [set temp_name2 0]
end

to structure_normality_each_run_int
  if length runresult temp_name7 < 1 [
    let l temp_name2
    let n (multiplication_SD * variation_of_SD_normal_distribution_properties_of_adopters)
    set temp_name2 int (random-normal (l + .5) n)
    if temp_name8 = 1 [if temp_name2 < 1 [set temp_name2 1]]
    if temp_name9 = 1 [if temp_name2 > 3 [set temp_name2 3]]
    run (word "set "temp_name7" lput temp_name2 "temp_name7)]
  set temp_name2 runresult (word "item 0 "temp_name7)
end

to structure_normality_each_run_no_int
  if length runresult temp_name7 < 1 [
    let l temp_name2
    let n (multiplication_SD * variation_of_SD_normal_distribution_properties_of_adopters)
    set temp_name2 random-normal l n
    if temp_name8 = 1 [if temp_name2 < 0 [set temp_name2 0]]
    if temp_name9 = 1 [if temp_name2 > 1 [set temp_name2 1]]
    run (word "set "temp_name7" lput temp_name2 "temp_name7)]
  set temp_name2 runresult (word "item 0 "temp_name7)
end


to structure_update_memory_in_list
  if length temp_name > 0 [
    let new_list []
    let a 0
    while [a < length temp_name] [
      if item temp_name2 (item a temp_name) > 1 [
        set temp_name replace-item a temp_name (replace-item temp_name2 (item a temp_name) (item temp_name2 (item a temp_name) - 1))
        set new_list lput item a temp_name new_list]
      set a a + 1]
    set temp_name new_list]
end
@#$#@#$#@
GRAPHICS-WINDOW
945
151
1466
571
-1
-1
20.55
1
10
1
1
1
0
0
0
1
0
24
0
19
0
0
1
ticks
30.0

BUTTON
1283
98
1399
134
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1558
99
1675
136
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
335
522
507
555
Random_interactions
Random_interactions
0
1
-1000

SWITCH
519
522
691
555
Friend_interactions
Friend_interactions
0
1
-1000

SWITCH
155
522
327
555
Neighbor_interactions
Neighbor_interactions
0
1
-1000

PLOT
1492
151
2110
573
Percentage of households that own a product
NIL
NIL
0.0
10.0
0.0
100.0
true
true
"" ""
PENS
"Product 1" 1.0 0 -2674135 true "" "plot number_of_households_owning_product_1"
"Product 2" 1.0 0 -10899396 true "" "plot number_of_households_owning_product_2"
"Product 3" 1.0 0 -13345367 true "" "plot number_of_households_owning_product_3"
"Product 4" 1.0 0 -1184463 true "" "plot number_of_households_owning_product_4"

SWITCH
14
978
186
1011
Show_links
Show_links
1
1
-1000

SWITCH
393
1014
625
1047
Normality_of_adopter_properties
Normality_of_adopter_properties
1
1
-1000

PLOT
1494
593
2323
822
Percentage of households of each category with products
NIL
NIL
0.0
10.0
0.0
100.0
true
true
"" ""
PENS
"% of innovators with products" 1.0 0 -13840069 true "" "plot percentage_of_innovators_with_products"
"% of early adopters with products" 1.0 0 -5509967 true "" "plot percentage_of_early_adopters_with_products"
"% of early majority with products" 1.0 0 -723837 true "" "plot percentage_of_early_majority_with_products"
"% of late majority with products" 1.0 0 -3757163 true "" "plot percentage_of_late_majority_with_products"
"% of laggards with products" 1.0 0 -2674135 true "" "plot percentage_of_laggards_with_products"

SWITCH
66
114
247
147
Switch_product_1
Switch_product_1
0
1
-1000

SWITCH
66
203
246
236
Switch_product_2
Switch_product_2
0
1
-1000

SWITCH
64
301
245
334
Switch_product_3
Switch_product_3
0
1
-1000

SWITCH
62
385
244
418
Switch_product_4
Switch_product_4
0
1
-1000

TEXTBOX
951
628
1465
707
The color of the patch stands for its adopter category: green for innovators, dark green for early adopters, light for early majority, normal blue for late majority and dark blue for laggards.\nThe color of the agent (house) stands may vary from black (not adopted), grey (aware) or any of the four products colors (corresponding to the specific product adopted). Households may only adopt 1 product.
12
0.0
1

TEXTBOX
17
777
317
807
Set learning rate of product (Learning_rate_product_1 stands for learning rate of product 1)
11
0.0
1

SLIDER
16
694
163
727
memory
memory
1
5
3.0
1
1
NIL
HORIZONTAL

SLIDER
14
812
219
845
Learning_rate_product_1
Learning_rate_product_1
0.8
1
0.88
0.01
1
NIL
HORIZONTAL

SLIDER
393
1055
716
1088
variation_of_SD_normal_distribution_properties_of_adopters
variation_of_SD_normal_distribution_properties_of_adopters
0.5
3
0.5
0.1
1
NIL
HORIZONTAL

SWITCH
13
1061
316
1094
Switch_all_same_category
Switch_all_same_category
1
1
-1000

SLIDER
13
851
218
884
Learning_rate_product_2
Learning_rate_product_2
0.8
1
0.96
0.01
1
NIL
HORIZONTAL

SLIDER
13
889
218
922
Learning_rate_product_3
Learning_rate_product_3
0.8
1
0.95
0.01
1
NIL
HORIZONTAL

SLIDER
13
925
218
958
Learning_rate_product_4
Learning_rate_product_4
0.8
1
0.93
0.01
1
NIL
HORIZONTAL

TEXTBOX
14
1039
307
1057
This switch makes all households into late majority population
11
0.0
1

TEXTBOX
396
956
696
988
Introduction of normality
20
0.0
1

TEXTBOX
395
992
616
1020
Uniformity of adopter variables (each run)
11
0.0
1

TEXTBOX
16
676
166
694
Memory
11
0.0
1

TEXTBOX
357
48
512
75
Product interface
20
0.0
1

SLIDER
64
151
246
184
Relative_advantage_product_1
Relative_advantage_product_1
1
3
1.6
0.1
1
NIL
HORIZONTAL

SLIDER
64
243
244
276
Relative_advantage_product_2
Relative_advantage_product_2
1
3
1.0
.1
1
NIL
HORIZONTAL

SLIDER
63
337
244
370
Relative_advantage_product_3
Relative_advantage_product_3
1
3
2.3
0.1
1
NIL
HORIZONTAL

SLIDER
62
423
244
456
Relative_advantage_product_4
Relative_advantage_product_4
1
3
1.0
0.1
1
NIL
HORIZONTAL

SLIDER
255
151
432
184
Compatibility_product_1
Compatibility_product_1
1
3
1.0
.1
1
NIL
HORIZONTAL

SLIDER
255
244
432
277
Compatibility_product_2
Compatibility_product_2
1
3
1.0
0.1
1
NIL
HORIZONTAL

SLIDER
250
337
434
370
Compatibility_product_3
Compatibility_product_3
1
3
2.4
0.1
1
NIL
HORIZONTAL

SLIDER
249
423
426
456
Compatibility_product_4
Compatibility_product_4
1
3
1.0
0.1
1
NIL
HORIZONTAL

SLIDER
435
151
609
184
Complexity_product_1
Complexity_product_1
1
3
1.0
0.1
1
NIL
HORIZONTAL

SLIDER
438
244
612
277
Complexity_product_2
Complexity_product_2
1
3
1.0
0.1
1
NIL
HORIZONTAL

SLIDER
439
337
613
370
Complexity_product_3
Complexity_product_3
1
3
1.7
0.1
1
NIL
HORIZONTAL

SLIDER
430
423
604
456
Complexity_product_4
Complexity_product_4
1
3
1.0
0.1
1
NIL
HORIZONTAL

SLIDER
612
151
863
184
Triability_and_observability_product_1
Triability_and_observability_product_1
1
3
1.0
0.1
1
NIL
HORIZONTAL

SLIDER
615
245
862
278
Triability_and_observability_product_2
Triability_and_observability_product_2
1
3
1.0
0.1
1
NIL
HORIZONTAL

SLIDER
617
337
863
370
Triability_and_observability_product_3
Triability_and_observability_product_3
1
3
1.0
0.1
1
NIL
HORIZONTAL

SLIDER
607
424
864
457
Triability_and_observability_product_4
Triability_and_observability_product_4
1
3
1.0
0.1
1
NIL
HORIZONTAL

TEXTBOX
260
120
410
145
Product 1
20
15.0
0

TEXTBOX
257
216
407
241
Product 2
20
55.0
0

TEXTBOX
259
307
409
332
Product 3
20
105.0
0

TEXTBOX
257
391
407
416
Product 4
20
45.0
0

PLOT
390
756
648
918
Product 1
NIL
NIL
0.0
10.0
0.0
3.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot Current_relative_advantage_product_1"
"pen-1" 1.0 0 -7500403 true "" "plot Current_complexity_product_1"
"pen-2" 1.0 0 -2674135 true "" "plot Current_compatibility_product_1"

PLOT
655
756
914
918
Product 2
NIL
NIL
0.0
10.0
0.0
3.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot Current_relative_advantage_product_2"
"pen-1" 1.0 0 -7500403 true "" "plot Current_complexity_product_2"
"pen-2" 1.0 0 -2674135 true "" "plot Current_compatibility_product_2"

SLIDER
15
731
218
764
duration_information_validity
duration_information_validity
0
100
30.0
1
1
NIL
HORIZONTAL

TEXTBOX
319
78
563
108
A rate of 1 is most advantageous for adoption. 3 is most disadvantageous.
11
0.0
1

PLOT
919
756
1177
918
Product 3
NIL
NIL
0.0
10.0
0.0
3.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot Current_relative_advantage_product_3"
"pen-1" 1.0 0 -7500403 true "" "plot Current_complexity_product_3"
"pen-2" 1.0 0 -2674135 true "" "plot Current_compatibility_product_3"

PLOT
1184
756
1442
918
Product 4
NIL
NIL
0.0
10.0
0.0
3.0
true
false
"" ""
PENS
"pen-0" 1.0 0 -7500403 true "" "plot Current_relative_advantage_product_4"
"pen-1" 1.0 0 -2674135 true "" "plot Current_complexity_product_4"
"pen-2" 1.0 0 -955883 true "" "plot Current_compatibility_product_4"

BUTTON
1417
100
1535
134
NIL
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
374
484
524
509
Interactions
20
0.0
1

TEXTBOX
1420
31
1539
56
Visualization
20
0.0
1

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Polygon -7500403 true true 150 15 15 120 285 120 150 15
Polygon -7500403 true true 45 120 45 285 255 285 255 120
Line -1 false 150 15 285 120
Rectangle -16777216 true false 120 210 180 285
Line -1 false 150 15 15 120
Line -1 false 15 120 285 120
Line -1 false 45 120 45 285
Line -1 false 45 285 255 285
Line -1 false 255 285 255 120

house colonial
false
0
Rectangle -7500403 true true 270 75 285 255
Rectangle -7500403 true true 45 135 270 255
Rectangle -16777216 true false 124 195 187 256
Rectangle -16777216 true false 60 195 105 240
Rectangle -16777216 true false 60 150 105 180
Rectangle -16777216 true false 210 150 255 180
Line -16777216 false 270 135 270 255
Polygon -7500403 true true 30 135 285 135 240 90 75 90
Line -16777216 false 30 135 285 135
Line -16777216 false 255 105 285 135
Line -7500403 true 154 195 154 255
Rectangle -16777216 true false 210 195 255 240
Rectangle -16777216 true false 135 150 180 180

house ranch
false
0
Rectangle -7500403 true true 270 120 285 255
Rectangle -7500403 true true 15 180 270 255
Polygon -7500403 true true 0 180 300 180 240 135 60 135 0 180
Rectangle -16777216 true false 120 195 180 255
Line -7500403 true 150 195 150 255
Rectangle -16777216 true false 45 195 105 240
Rectangle -16777216 true false 195 195 255 240
Line -7500403 true 75 195 75 240
Line -7500403 true 225 195 225 240
Line -16777216 false 270 180 270 255
Line -16777216 false 0 180 300 180

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person police
false
0
Polygon -1 true false 124 91 150 165 178 91
Polygon -13345367 true false 134 91 149 106 134 181 149 196 164 181 149 106 164 91
Polygon -13345367 true false 180 195 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285
Polygon -13345367 true false 120 90 105 90 60 195 90 210 116 158 120 195 180 195 184 158 210 210 240 195 195 90 180 90 165 105 150 165 135 105 120 90
Rectangle -7500403 true true 123 76 176 92
Circle -7500403 true true 110 5 80
Polygon -13345367 true false 150 26 110 41 97 29 137 -1 158 6 185 0 201 6 196 23 204 34 180 33
Line -13345367 false 121 90 194 90
Line -16777216 false 148 143 150 196
Rectangle -16777216 true false 116 186 182 198
Rectangle -16777216 true false 109 183 124 227
Rectangle -16777216 true false 176 183 195 205
Circle -1 true false 152 143 9
Circle -1 true false 152 166 9
Polygon -1184463 true false 172 112 191 112 185 133 179 133
Polygon -1184463 true false 175 6 194 6 189 21 180 21
Line -1184463 false 149 24 197 24
Rectangle -16777216 true false 101 177 122 187
Rectangle -16777216 true false 179 164 183 186

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="evalution_protection_data_obligatory">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_appliance_5">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_appliance_8">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_uniformity_awareness">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_uniformity_complexity_tolerated">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Prospect_theory">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_uniformity_percentage_information_needed">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Minimum_time_between_2_decisions_ON">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Valuation_recent_information">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Yearly_change_percentage_RE">
      <value value="1.7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="data_leak_event">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="introduction_phase">
      <value value="60"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth_phase">
      <value value="60"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_appliance_2">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="variation_of_SD_normal_distribution_properties_of_environment">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Moment_of_data_leak_event">
      <value value="47"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Minimum_savings_for_majority_of_population">
      <value value="1.3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Friend_interactions">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Failure_of_ISG_appliances_possible">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Neighbor_interactions">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_uniformity_month_needed_recover_trust">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="purchase_complexity_fix">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_appliance_7">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="electricity_price_night_fix">
      <value value="0.155"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Calculation_new_normality_properties_households">
      <value value="&quot;each run&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Start_year_introduction_smart_grid_Netherlands">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_uniformity_preferred_information_source">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="electricity_price_day_fix">
      <value value="0.295"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="evaluation_savings_obligatory">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Amount_of_month_before_purchase_enthousiasm_stops">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Learning_rate_appliances">
      <value value="0.95"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_appliance_1">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Normality_of_environment_properties">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Diffusion_information_number_links">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Normality_of_household_properties">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_uniformity_social_influence">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="variation_of_SD_normal_distribution_properties_of_adopters">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Fix_electricity_prices">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Normality_of_adopter_properties">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Calculation_new_normality_properties_adopters">
      <value value="&quot;each step&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Yearly_change_percentage_SH">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Minimum_time_between_2_decisions">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Multiply_media_interaction">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maturity_phase">
      <value value="3600"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Dont_show_links">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_uniformity_Information_search">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_uniformity_household_properties">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Duration_information_complexity_validity">
      <value value="48"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="run_length">
      <value value="80"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Random_interactions">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="variation_of_SD_normal_distribution_properties_of_households">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Equilibrium_percentage_SH_Netherlands">
      <value value="38"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="evaluation_purchase_risks_obligatory">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_appliance_4">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Fix_complexities">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Rationality">
      <value value="&quot;bounded_rationality&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="evaluation_social_recognition_obligatory">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Degree_of_correlation_with_previous_data">
      <value value="0.34"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="evalation_reliability_obligatory">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="memory">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_appliance_6">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Data_leak_event_category">
      <value value="&quot;Category_3_data_leak&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="installation_complexity_fix">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_appliance_3">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="behavior_change_complexity_fix">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_uniformity_interactions">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Switch_uniformity_valuation_of_savings">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
