%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   INPUT File                                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   Written by D.D.Dijkshoorn (DDD) on 17/04/2020                         %
%   Checked by ... on ././.                                               %
%   Last revision: 03/03/2022                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   Case: Continuous running windtunnel with variable nozzle
%   Type: Flat Plate flow (zero-PG Plate flow)
%   Source: ADA045367 (1977) case entry 7302
%   Original source: Winter, K.G. and Gaudet, L.; 1973. Turbulent
%   boundary-layer studies at high Reynolds numbers at Mach numbers between
%   0.2 and 2.8. ARC (London) R&M 3712
%   Validation of: turbulence model by comparing velocity profile and ...

Case_name = 'ADA045367_7302_Winter1973_P26'; % tag: document name, case entry, first author and year

%% OPTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Ideal Gas (IG); Nonideal Gas (NG), Real Gas (RG) (not applied here)

OPT.GASM = 1;                   % Gas model: 1=calorically perfect IG; 2=thermally perfect IG; 3=Nonideal Gas (NG);
%%% The following three options are only available with GASM=1, and in this
%%% order. Options are ignored when inappropriate, see manual. Note that
%%% constants for Sutherland's Law and the cp(T) polynomial are not
%%% available for all fluids
OPT.COMP = 1;                   % 0=incompressible flow; 1=compressible flow (standard); only available with GASM=1 and only valid for gases and incompressible input data; set FLD.C in fluid file
OPT.CPRN = 0;                   % 0=constant Pr-number (input) and k=f(Pr,mu,cp); 1=variable Pr-number: Pr=f(mu(Suth(T)),k(Suth(T)),cp=constant); only available with GASM=1
OPT.CCRP = 1;                   % 0=constant Chapman-Rubesin parameter, 1=general/variable Chapman-Rubesin parameter; only available with GASM=1
%%%
OPT.CPRT = 0;1;                   % 0=constant PrT; 1=variable turbulent Pr-number
OPT.BCIE = 2;                   % BC Input Edge (BL Edge input: 1=UE/uE; 2=MaE; 3=psE (ratio?))
OPT.BCEE = 0;                   % Wall BC of EE: 0=adiabatic wall; 1=enthalpy ratio [-]; 2=derivative of enthalpy ratio [-]; 3=Temperature ratio [-]; 4=heat flux [W/m2] (temperature or heat flux directly)
OPT.SMTH = 0;                   % Smoothing experimental data, entry is number of runs)
OPT.TRME = 1;                   % transition method: 0=no transition; 1=prescribed transition location NTR; 2=Wazzan correlation; 3=Michel's Method (Cebeci (2002)); 4=fully turbulent
OPT.RLAM = 0;                   % 1=Relaminarization check, 0=no check; simple engineering estimate based on exp. data for air
OPT.GRAD = 1;                   % 1=Lagrange; 2=Weighted-difference technique; 3=SPLINE
OPT.CHRT = 0;                   % Pv-diagram and Ts-diagram including range

%% PHYSICAL PART %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Fluid possibilities: AIR, CO2, MDM2, D6, ...
% cd('../Fluids')
% AIR
% cd('../INPUT')

% Molecular Fluid properties
FLD.R = 8.3145;                 % [J/mol/K], Universal gas constant
FLD.MW = 28.97;                 % [g/mol = kg/kmol], Molecular Weight of dry Air
FLD.Rsg = FLD.R/FLD.MW*1e3;     % [J/kg/K], Specific Gas constant Air

% Fluid Property data
FLD.gamma = 1.4;                % [-], Specific heat ratio (Cp/Cv)
FLD.SLV = 110.4;                % [K],  (Groot, 2018) Sutherland's constant (later ones: White (2006) and Cebeci (2002)!)
FLD.SLC = 194;                  % [K], (Groot, 2018; and White, 2006) Sutherland's constant for thermal conductivity
FLD.Tref_S = 273;               % [K], (Groot, 2018; and White, 2006) reference temperature Sutherland's Law
FLD.mu_ref = 1.716e-5;          % [Pas], (Groot, 2018; and White, 2006) reference viscosity Sutherland's Law
FLD.k_ref = 0.0241;             % [W/m/K], (Groot, 2018; and White, 2006) reference thermal conductivity Sutherland's Law
FLD.Pr = 0.72;                  % [-], (Cebeci, 2002) Prandlt-number
FLD.Cp = FLD.Rsg*FLD.gamma/(FLD.gamma - 1); % [J/kg/K]
% FLD.Cpcoeff = [1022.5294853 -0.1758625 4.020605e-4 -4.8640623e-8]; % a0, a1, a2, a3, a4, etc. -> Cp = a0 + a1*T + ... % Andrews (1981) IG relation; range: 100 - 590 K

%% Case Specific Input Data

% Geometry (scaled)
INP.L = 1;                      % [m], scale factor: chord length/plate length/nozzle throat half-width; equal to one for non-scaled geometry
INP.x = ...                     % [-], rounded first (negative) X-coordinate to zero
       [0.000	0.578	1.235	1.954	2.749	3.411	4.117	4.918	5.666...
        6.441	7.138	7.835	8.480	9.023	9.529	10.012	10.417	10.804...
        11.132	11.424	11.708	11.992	12.225	12.478	12.584	12.649...
        12.729	12.809	12.860	12.951	13.034	13.116	13.194	13.254	13.319...
        13.398	13.477	13.546	13.612	13.679	13.752	13.828	13.901	13.986...
        14.055	14.119	14.177	14.222	14.277	14.340	14.397	14.460	14.537...
        14.606	14.678	14.733	14.796	14.864	14.935	15.000	15.062	15.138...
        15.216	15.309	15.392	15.478	15.554	15.649	15.741	15.823	15.896...
        15.990	16.094	16.196	16.283	16.363	16.448	16.536	16.616	16.690...
        16.772	16.861	16.959	17.043	17.145	17.237	17.341	17.446	17.550...
        17.637	17.734	17.821	17.897	17.977	18.059	18.141	18.227	18.327...
        18.412	18.503	18.605	18.714	18.814	18.909	18.998	19.080	19.149...
        19.227	19.300	19.353	19.417	19.480	19.537	19.592	19.644	19.699...
        19.746	19.799	19.854	19.910	19.961	20.022	20.094	20.165	20.240...
        20.317	20.390	20.457	20.524	20.592	20.663	20.716	20.780	20.844...
        20.906	20.968	21.015	21.066	21.112	21.158	21.214	21.267	21.318...
        21.362	21.400	21.442	21.490	21.539	21.574	21.625	21.674	21.715...
        21.737	21.768	21.802	21.843	21.876	21.903	21.941	21.971	22.009...
        22.042	22.071	22.104	22.143	22.176	22.216	22.245	22.275	22.320...
        22.359	22.394	22.426	22.460	22.499	22.531	22.568	22.604	22.641...
        22.680	22.710	22.744	22.778	22.810	22.840	22.863	22.886	22.918...
        22.953	22.985	23.021	23.051	23.079	23.115	23.141	23.163	23.198...
        23.230	23.262	23.297	23.326	23.365	23.409	23.443	23.476	23.508...
        23.547	23.586	23.616	23.643	23.675	23.698	23.721	23.744	23.770...
        23.800	23.825	23.853	23.880	23.908	23.942	23.965	23.993	24.021...
        24.046	24.074	24.110	24.136	24.164	24.189	24.224	24.254	24.284...
        24.314	24.337	24.367	24.394	24.415	24.436	24.464	24.489	24.517...
        24.538	24.566	24.591	24.612	24.640	24.665	24.677	24.703	24.730...
        24.762	24.788	24.813	24.830	24.851	24.876	24.895	24.918	24.941...
        24.973	24.999	25.024	25.059	25.082	25.105	25.124	25.147	25.172...
        25.197	25.218	25.244	25.264	25.274	25.297	25.313	25.327	25.350...
        25.369	25.394	25.408	25.422	25.441	25.448	25.469	25.490	25.513...
        25.538	25.561	25.587	25.610	25.640	25.665	25.697	25.730	25.753...
        25.785	25.810	25.833	25.847	25.864	25.880	25.907	25.933	25.949...
        25.979	26.005	26.019	26.049	26.067	26.102	26.116	26.137	26.167...
        26.197	26.215	26.245	26.269	26.289	26.315	26.336	26.368	26.398...
        26.412	26.433	26.451	26.474	26.500	26.520	26.544	26.569	26.590...
        26.611	26.638	26.664	26.687	26.717	26.751	26.777	26.804	26.832...
        26.860	26.874	26.885	26.908	26.931	26.950	26.977	26.998	27.021...
        27.051	27.074	27.102	27.123	27.153	27.173	27.201	27.231	27.256...
        27.281	27.316	27.339	27.376	27.397	27.417	27.438	27.466	27.489...
        27.507	27.523	27.546	27.567	27.597	27.620	27.650	27.670	27.696...
        27.721	27.746	27.769	27.799	27.829	27.852	27.880	27.910	27.949...
        27.981	27.997	28.027	28.050	28.080	28.103	28.124	28.153	28.174...
        28.204	28.229	28.250	28.280	28.307	28.335	28.365	28.399	28.445...
        28.477	28.521	28.555	28.601	28.635	28.670	28.711	28.754	28.802...
        28.853	28.901	28.949	28.997	29.045	29.095	29.139	29.182	29.210...
        29.248	29.294	29.340	29.390	29.438	29.481	29.529	29.582	29.623...
        29.668	29.728	29.785	29.842	29.910	29.974	30.042	30.102	30.181...
        30.240	30.316	30.395	30.470	30.550	30.618	30.707	30.796	30.864...
        30.948	31.053	31.119	31.210	31.285	31.364	31.437	31.491	31.582...
        31.655	31.716	31.786	31.864	31.948	32.029	32.091	32.170	32.240...
        32.302	32.367	32.458	32.524	32.603	32.689	32.766	32.841	32.912...
        32.986	33.077	33.136	33.193];
    
INP.y = zeros(1,length(INP.x)); % [-]

%% Free-Stream and BL Edge conditions
INP.PtI = 0.76454e5;            % [Pa]
INP.TtI = 18.7 + 273.15;        % [K], 291.85
% INP.MaI = 0.0194;               % [-]
INP.MaE = ...                   % [-]
       2.8/2.792*[0.0194	0.0194	0.0194	0.020	0.020	0.020	0.020	0.021	0.021...
        0.021	0.022	0.023	0.023	0.024	0.024	0.025	0.025	0.026...
        0.027	0.028	0.029	0.030	0.031	0.033	0.035	0.035...
        0.036	0.037	0.037	0.038	0.039	0.040	0.040	0.041	0.041	0.042	0.043	0.043	0.044	0.045	0.046	0.046	0.048	0.048	0.049	0.050	0.050	0.051	0.052	0.053	0.053	0.054	0.055	0.056	0.057	0.058	0.059	0.060	0.061	0.062	0.062	0.064	0.065	0.066	0.068	0.069	0.070	0.072	0.074	0.075	0.076	0.078	0.080	0.082	0.084	0.086	0.088	0.090	0.092	0.093	0.095	0.098	0.100	0.102	0.105	0.108	0.111	0.114	0.117	0.119	0.122	0.123	0.126	0.129	0.131	0.134	0.137	0.140	0.142	0.146	0.149	0.154	0.158	0.163	0.167	0.172	0.176	0.180	0.184	0.187	0.191	0.195	0.199	0.202	0.205	0.209	0.212	0.215	0.219	0.224	0.227	0.232	0.237	0.242	0.247	0.253	0.258	0.263	0.268	0.274	0.280	0.285	0.291	0.296	0.302	0.308	0.314	0.318	0.323	0.329	0.335	0.341	0.346	0.351	0.356	0.362	0.367	0.372	0.378	0.384	0.391	0.395	0.400	0.404	0.410	0.415	0.420	0.425	0.429	0.435	0.441	0.446	0.450	0.456	0.462	0.467	0.473	0.478	0.484	0.491	0.498	0.504	0.510	0.516	0.523	0.530	0.537	0.545	0.552	0.559	0.566	0.573	0.580	0.587	0.593	0.599	0.604	0.610	0.617	0.624	0.631	0.638	0.646	0.652	0.658	0.664	0.671	0.678	0.685	0.694	0.702	0.711	0.721	0.730	0.739	0.747	0.757	0.766	0.774	0.782	0.790	0.797	0.802	0.810	0.817	0.825	0.834	0.842	0.851	0.859	0.867	0.875	0.883	0.892	0.901	0.911	0.920	0.930	0.940	0.951	0.961	0.971	0.980	0.991	1.001	1.012	1.022	1.031	1.040	1.049	1.059	1.070	1.079	1.091	1.101	1.112	1.123	1.134	1.144	1.153	1.162	1.171	1.182	1.192	1.201	1.209	1.218	1.228	1.238	1.248	1.259	1.270	1.280	1.290	1.299	1.309	1.318	1.328	1.337	1.347	1.357	1.364	1.371	1.379	1.386	1.393	1.400	1.409	1.418	1.428	1.436	1.444	1.452	1.461	1.469	1.477	1.485	1.493	1.503	1.512	1.520	1.531	1.540	1.549	1.558	1.567	1.577	1.586	1.594	1.600	1.608	1.616	1.625	1.635	1.645	1.656	1.665	1.674	1.684	1.692	1.703	1.712	1.721	1.732	1.742	1.751	1.762	1.773	1.782	1.790	1.798	1.808	1.817	1.825	1.834	1.842	1.850	1.859	1.868	1.876	1.884	1.893	1.902	1.911	1.920	1.929	1.939	1.948	1.959	1.969	1.977	1.986	1.992	1.998	2.006	2.013	2.021	2.028	2.035	2.043	2.052	2.060	2.069	2.078	2.086	2.094	2.103	2.109	2.116	2.124	2.133	2.142	2.153	2.160	2.166	2.172	2.178	2.186	2.192	2.197	2.203	2.210	2.218	2.224	2.231	2.238	2.247	2.254	2.262	2.269	2.276	2.283	2.291	2.299	2.306	2.315	2.322	2.330	2.338	2.345	2.352	2.359	2.366	2.373	2.380	2.388	2.394	2.401	2.407	2.414	2.422	2.430	2.438	2.447	2.455	2.463	2.472	2.482	2.490	2.497	2.505	2.513	2.521	2.529	2.537	2.546	2.555	2.562	2.570	2.578	2.584	2.590	2.596	2.602	2.608	2.615	2.622	2.627	2.633	2.639	2.645	2.651	2.657	2.663	2.670	2.676	2.684	2.690	2.696	2.702	2.707	2.714	2.720	2.725	2.730	2.735	2.740	2.745	2.749	2.754	2.759	2.763	2.767	2.771	2.774	2.776	2.778	2.780	2.782	2.784	2.786	2.787	2.789	2.789	2.789	2.790	2.790	2.790	2.790	2.790	2.790	2.790	2.790	2.790	2.791	2.791	2.791	2.792	2.792	2.792];
INP.MaI = INP.MaE(1);           % [-]

% Wall Boundary Condition (for specific wall enthalpy ratio, derivative of wall enthalpy ratio, wall
% temperature, or wall heat flux (other then adiabatic flow)
if OPT.BCEE > 0
%     INP.BCW = 1.05*ones(1,length(INP.x));
    INP.BCW = 0.958*ones(1,length(INP.x));   % [-], scaled h ratio or it's derivative
    % optional %%% Check!!! %%%
    INP.AWD = []; % only g_aw or T_aw ((static) ratio? -> see OUTPUT) should be given here, calculated after adiabatic simulation
%     INP.AWD = 272.25*ones(1,length(INP.x));
else
    INP.BCW = zeros(1,length(INP.x));   % [-], zero wall heat flux: derivative at wall of enthalpy ratio equal to zero
end

%% Experimental data %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% include in specific PLOT-file for generating thesis graphs!
% cd('./Data')
% Exp_Data_Profile26_Winter1973 % m-file, includes description of data
% cd('..')

%% TURBULENCE MODEL %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Closure coeficients, for the CS-model: EV (Cebeci, 2002), and PrT (Cebeci, 1974)

% Momentum Equation; and,
TCC.kappa = 0.40;           % [-], Von Karman constant
TCC.A_plus = 26.0;          % [-], Van Driest damping factor constant
TCC.alpha = 0.0168;         % [-], Clauser(s)/outer eddy viscosity constant
TCC.ints = 11.8;            % [-], Assumed intersection of viscous sublayer with (intermediate) log layer

% Energy Equation:
TCC.kappa_h = 0.44;         % [-], Heat transfer mixing-length constant
TCC.PrT = 0.9;              % [-], (Cebeci (2004)!) Constant Turbulent Prandtl-number (independent of fluid!) if PrT model is not used
TCC.Bcoeff = [34.96 28.79 33.95 6.33 -1.186]; % [-], (Cebeci (1974)!) Turbulent Prandtl-number coefficients

%% NUMERICAL PART %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Set size of vectors for initilization (vertical/eta-direction)
SET.NPT = 201;  % 600;           % preallocation (size is 201 in FORTRAN code)
SET.ITMAX = 6;                   % maximum number of iterations (6 in MAIN code, 8 for IVPL in FORTRAN code)
SET.ITMAX0 = 10;
SET.NTR = 256;                   % Force transition at station NTR

% Grid Parameters
GRD.etaE = 8.0;                  % non-dimensional BL edge location
GRD.VGP = 1.14; % 1;1.02; for smooth BL velocity thickness      % variable grid parameter (spacing ratio)
GRD.Deta = 0.0001; % original: 0.01;    % first grid spacing: h1

%% PLOT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Plot the following profiles (velocity, dimensionless velocity, enthalpy)
PLT.NSP = [length(INP.x)];               % Plot profiles at stations NS

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%