%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   INPUT File                                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   Written by D.D.Dijkshoorn (DDD) on 19/04/2018                         %
%   Checked by ... on ././.                                               %
%   Last revision: 26/11/2022                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   Case: NACA0012
%   Source: Convective Heat Transfer, Cebeci (2002)
%   Verification of: solver, BL variables/characteristics,
%   turbulence model

Case_name = 'NACA0012_Cebeci2002'; % tag

%% OPTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Ideal Gas (IG); Nonideal Gas (NG)

OPT.GASM = 1;                   % Gas model: 1=calorically perfect IG; 2=thermally perfect IG; 3=Nonideal Gas (NG);
%%% The following three options are only available with GASM=1, and in this
%%% order. Options are ignored when inappropriate, see manual. Note that
%%% constants for Sutherland's Law and the cp(T) polynomial are not
%%% available for all fluids
OPT.COMP = 1;                   % 0=incompressible flow; 1=compressible flow (standard); only available with GASM=1 and only valid for gases and incompressible input data; set FLD.C in fluid file
OPT.CPRN = 0;                   % 0=constant Pr-number (input) and k=f(Pr,mu,cp); 1=variable Pr-number: Pr=f(mu(Suth(T)),k(Suth(T)),cp=constant); only available with GASM=1
OPT.CCRP = 1;                   % 0=constant Chapman-Rubesin parameter, 1=general/variable Chapman-Rubesin parameter; only available with GASM=1
%%%
OPT.CPRT = 0;                   % 0=constant PrT; 1=variable turbulent Pr-number
OPT.BCIE = 1;                   % BC Input Edge [-] (BL Edge input: 1=uE (UE/UI); 2=MaE; 3=psE (PsE/PtI))
OPT.BCEE = 0;                   % Wall BC of EE: 0=adiabatic wall; 1=total enthalpy ratio [-]; 2=derivative of total enthalpy ratio [-]; 3=Temperature ratio Twall/TtI [-]; 4=heat flux [W/m2] (heat flux as input only is inaccurate, since unknown wall temperature needs to be estimated)
OPT.SMTH = 0;                   % Smoothing experimental data, entry is number of runs)
OPT.TRME = 1;                   % Transition method: 0=no transition; 1=prescribed transition location NTR; 2=Wazzan correlation; 3=Michel's Method (Cebeci (2002)); 4=fully turbulent (for air only!)
OPT.RLAM = 0;                   % Relaminarization method, 0=no relam.; 1=prescribed location NRL; 2=simple engineering estimate based on exp. data for air only!
OPT.GRAD = 1;                   % 1=Lagrange; 2=Weighted-difference technique; 3=SPLINE
OPT.CHRT = 0;                   % Pv-diagram and Ts-diagram including range (not available)

%% PHYSICAL PART %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Fluid possibilities: AIR, CO2, MDM2, D6, ...
cd('../Fluids')
% AIR
AIR_NACA0012_Cebeci2002         % specific conditions for this verification case
cd('../INPUT')

%% Case Specific Input Data

% Geometry (scaled)
INP.L = 1;                      % [m], scale factor, for example: chord length/plate length/nozzle throat half-width; equal to one for non-scaled geometry
INP.x = ...                     % [-]
       [0.00426        0.00421        0.00355        0.00294        0.00239...
        0.00190        0.00146        0.00108        0.00076        0.00050...
        0.00029        0.00014        0.00005        0.00001        0.00005...
        0.00014        0.00029        0.00050        0.00076        0.00108...
        0.00146        0.00190        0.00239        0.00294        0.00355...
        0.00421        0.00494        0.00571        0.00655        0.00744...
        0.00838        0.00938        0.01044        0.01155        0.01272...
        0.01394        0.01522        0.01656        0.01795        0.01939...
        0.02090        0.02245        0.02406        0.02573        0.02745...
        0.02922        0.03324        0.03977        0.04687        0.05452...
        0.06271        0.07143        0.08067        0.09043        0.10068...
        0.11142        0.12264        0.13431        0.14644        0.15899...
        0.17196        0.18532        0.19907        0.21319        0.22765...
        0.24245        0.25756        0.27296        0.28865        0.30459...
        0.32077        0.33717        0.35377        0.37054        0.38747...
        0.40454        0.42173        0.43901        0.45636        0.47377...
        0.49121        0.51563        0.54697        0.57812        0.60896...
        0.63937        0.66923        0.69843        0.72685        0.75436...
        0.78087        0.80627        0.83046        0.85335        0.87485...
        0.89487        0.91332        0.93015        0.94527        0.95864...
        0.97020        0.97991        0.98771        0.99360        0.99803];
INP.y = ...                     % [-]
       [-0.01129      -0.01123       -0.01033       -0.00943       -0.00852...
       -0.00761       -0.00669       -0.00577       -0.00484       -0.00391...
       -0.00297       -0.00203       -0.00110        0.00000        0.00110...
        0.00203        0.00297        0.00391        0.00484        0.00577...
        0.00669        0.00761        0.00852        0.00943        0.01033...
        0.01123        0.01212        0.01301        0.01390        0.01477...
        0.01565        0.01652        0.01738        0.01824        0.01909...
        0.01993        0.02077        0.02161        0.02244        0.02326...
        0.02408        0.02489        0.02569        0.02649        0.02728...
        0.02806        0.02970        0.03216        0.03455        0.03684...
        0.03905        0.04117        0.04318        0.04510        0.04692...
        0.04863        0.05022        0.05170        0.05306        0.05430...
        0.05542        0.05642        0.05730        0.05805        0.05868...
        0.05919        0.05957        0.05983        0.05997        0.06000...
        0.05991        0.05971        0.05940        0.05898        0.05846...
        0.05785        0.05714        0.05634        0.05546        0.05450...
        0.05347        0.05190        0.04972        0.04737        0.04487...
        0.04225        0.03955        0.03677        0.03392        0.03104...
        0.02813        0.02524        0.02239        0.01963        0.01695...
        0.01441        0.01201        0.00977        0.00773        0.00589...
        0.00427        0.00289        0.00178        0.00093        0.00028];

%% Free-Stream and BL Edge conditions
INP.PsI = 2.551812306113773e+06;% [Pa], calculated from different input
INP.TsI = 500;                  % [K]
INP.UI = 4.482186966202995;     % [m/s]
INP.uE = ...                    % [-]
        [0.00000       0.00415        0.06960        0.13799        0.21011...
        0.28468        0.36274        0.44245        0.52420        0.60629...
        0.68973        0.77129        0.85185        0.94135        1.03544...
        1.10515        1.17185        1.23469        1.29143        1.34353...
        1.38950        1.42989        1.46461        1.49442        1.51861...
        1.53724        1.55187        1.56499        1.57528        1.58365...
        1.58949        1.59318        1.59519        1.59566        1.59527...
        1.59377        1.59164        1.58863        1.58471        1.58124...
        1.57722        1.57250        1.56794        1.56323        1.55889...
        1.55669        1.53542        1.51936        1.50318        1.48762...
        1.47229        1.45747        1.44377        1.43087        1.41849...
        1.40624        1.39480        1.38360        1.37245        1.36166...
        1.35114        1.34130        1.33163        1.32185        1.31220...
        1.30296        1.29404        1.28501        1.27602        1.26714...
        1.25851        1.25018        1.24192        1.23364        1.22530...
        1.21713        1.20936        1.20175        1.19399        1.18642...
        1.17929        1.16853        1.15597        1.14342        1.13158...
        1.12001        1.10924        1.09786        1.08736        1.07586...
        1.06343        1.05140        1.03938        1.02673        1.01415...
        1.00092        0.98735        0.97253        0.95758        0.94042...
        0.92169        0.90074        0.87714        0.84611        0.79837];

% Wall Boundary Condition (for specific wall enthalpy ratio, derivative of wall enthalpy ratio, wall
% temperature, or wall heat flux (other then adiabatic flow)
if OPT.BCEE > 0
    INP.BCW = zeros(1,length(INP.x));   % [-], scaled h ratio or it's derivative
    % optional
    INP.AWD = []; % only g_aw (for OPT.BCEE = 1 or 2) or T_aw [K] (for OPT.BCEE = 3 or 4), which can be calculated with adiabatic simulation first
else
    INP.BCW = zeros(1,length(INP.x));   % [-], zero wall heat flux: derivative at wall of enthalpy ratio equal to zero
end

%% Experimental data %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% included in specific PLOT-file for generating thesis graphs
% cd('./Data')
% load('NACA0012_FORTRAN_SimResults_Cebeci2002')
% cd('..')

%% TURBULENCE MODEL %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Closure coeficients, for the CS-model: EV (Cebeci, 2002), and PrT (Cebeci, 1974)

% Momentum Equation; and,
TCC.kappa = 0.40;           % [-], Von Karman constant
TCC.A_plus = 26.0;          % [-], Van Driest damping factor constant
TCC.alpha = 0.0168;         % [-], Clauser(s)/outer eddy viscosity constant
TCC.ints = 11.8;            % [-], Assumed intersection of viscous sublayer with (intermediate) log layer

% Energy Equation:
TCC.kappa_h = 0.44;         % [-], Heat transfer mixing-length constant
TCC.PrT = 0.9;              % [-], (Cebeci (2004)!) Constant Turbulent Prandtl-number (independent of fluid!) if PrT model is not used
TCC.Bcoeff = [34.96 28.79 33.95 6.33 -1.186]; % [-], (Cebeci (1974)!) Turbulent Prandtl-number coefficients

%% NUMERICAL Settings %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Set size of vectors for initilization (vertical/eta-direction)
SET.NPT = 201;  % 600;           % preallocation (size is 201 in original FORTRAN code)
SET.ITMAX = 6;                   % maximum number of iterations (6 in MAIN code, 8 for IVPL in FORTRAN code)
SET.ITMAX0 = 8; % 20;10;8;       % max number of iterations for initial profile in IVPL (original = 8)
SET.ITMAX2 = 10;                 % maximum number of iterations in PRECAL-file gas model 2
SET.ITMAX3 = 10;                 % maximum number of iterations in PRECAL-file gas model 3
% SET.ITMAX4 = 10;                 % maximum number of iterations in FLDPRS-file (gas model 2)
SET.NTR = 53;                    % Force transition at station NTR
SET.NRL = [];                    % Force Re-Laminarization at station NRL

% Grid Parameters
GRD.etaE = 8.0;                  % non-dimensional BL edge location
GRD.VGP = 1.14; % 1;1.02; for smooth BL velocity thickness    % variable grid parameter (spacing ratio)
GRD.Deta = 0.01;     % 0.1;      % first grid spacing: h1

%% PLOT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Plot the following profiles (velocity, dimensionless velocity, enthalpy)
PLT.NSP = [23 55 73 87];               % Plot profiles at stations NS

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%