(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     32479,        818]
NotebookOptionsPosition[     30962,        782]
NotebookOutlinePosition[     31487,        801]
CellTagsIndexPosition[     31444,        798]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Figure S1(a) PL efficiency as a function of the electric field (simple \
cubic lattice)\n",
 StyleBox["Data for 0.01\[Times]nu_1,default , ..., 100\[Times]nu_1,default \
in tab001sc, tab01sc,  ..., tab100sc", "Subsubsection"]
}], "Section",
 CellChangeTimes->{{3.850406611010027*^9, 3.8504066341728697`*^9}, {
   3.850406682360574*^9, 3.850406733333763*^9}, {3.85040786742496*^9, 
   3.8504078713323936`*^9}, 3.850409855982238*^9, {3.850410655551868*^9, 
   3.8504106558150897`*^9}, {3.8504113623298287`*^9, 
   3.8504113952602673`*^9}, {3.8504114851514387`*^9, 
   3.8504114855517874`*^9}, {3.850453937352663*^9, 3.8504539507317057`*^9}, {
   3.8504571992229724`*^9, 3.8504572221249065`*^9}, {3.851536105747826*^9, 
   3.8515361326758037`*^9}, {3.8515749398002405`*^9, 
   3.8515749443883467`*^9}, {3.8515750996271687`*^9, 3.851575103773638*^9}, {
   3.851575299514915*^9, 3.8515753129461265`*^9}, {3.851581314275064*^9, 
   3.851581421390626*^9}, {3.851582629836712*^9, 3.85158263632047*^9}, {
   3.851621832464162*^9, 3.8516218393689976`*^9}, {3.8516227743109894`*^9, 
   3.8516227745584974`*^9}, {3.8518434127141323`*^9, 
   3.8518434213982773`*^9}, {3.851844733852085*^9, 3.851844734021181*^9}, {
   3.851845116043836*^9, 3.851845122404727*^9}, {3.851845182565321*^9, 
   3.851845182812565*^9}, {3.851845296255268*^9, 3.8518453123211827`*^9}, 
   3.851849954940507*^9, {3.8519659952359505`*^9, 3.8519660043988047`*^9}, {
   3.8519672144081964`*^9, 3.8519672497903028`*^9}, {3.851968178806324*^9, 
   3.8519681838658934`*^9}, {3.852005581312589*^9, 3.852005581660252*^9}, {
   3.8520166925971804`*^9, 3.852016716722085*^9}, {3.8521028148440485`*^9, 
   3.8521028152295227`*^9}, {3.85211769047598*^9, 3.8521177517106256`*^9}, {
   3.8521189838440857`*^9, 3.8521189842914906`*^9}, {3.852130069290101*^9, 
   3.8521300919026265`*^9}, {3.852130126633212*^9, 3.852130148049038*^9}, {
   3.852130285592149*^9, 3.852130297433449*^9}, {3.852131537395375*^9, 
   3.852131545879963*^9}, {3.85213269912004*^9, 3.8521327007593412`*^9}, {
   3.9669199454994164`*^9, 3.9669199459108624`*^9}, {3.966920347718565*^9, 
   3.9669203486208887`*^9}, {3.970294662000137*^9, 3.970294705717536*^9}, {
   3.9702947446347017`*^9, 3.9702947734082403`*^9}, {3.970294806253845*^9, 
   3.9702948482455244`*^9}, {3.970295215987361*^9, 3.970295226894409*^9}, {
   3.970295378787881*^9, 3.9702953790887623`*^9}, 
   3.970295483241914*^9},ExpressionUUID->"925ecdda-8055-4fd2-b229-\
797f650fa2d2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tab001sc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5.`*^8"}], ",", "0.435`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.5`*^8"}], ",", "0.53`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.`*^8"}], ",", "0.7`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.8`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.`*^8"}], ",", "0.9042857142857142`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.9585714285714285`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "200000000"}], ",", "0.98`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.995`"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab01sc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.5`*^8"}], ",", "0.2633`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.`*^8"}], ",", "0.43041666666666667`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.5873809523809523`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.`*^8"}], ",", "0.7792`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.8794000000000001`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.959`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.988`"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1sc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5.5`*^8"}], ",", "0.02`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "500000000"}], ",", "0.04`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.5`*^8"}], ",", "0.08`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "400000000"}], ",", "0.175`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.35`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "300000000"}], ",", "0.58`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.78`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.91`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.97`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`*^8"}], ",", "0.99`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5.`*^7"}], ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab10sc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.`*^8"}], ",", "0.04454545454545455`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.15454545454545454`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.`*^8"}], ",", "0.35545454545454547`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.5981818181818181`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.7972727272727272`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.9463636363636364`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`*^8"}], ",", "0.9863636363636363`"}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab100sc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.396`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.663`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.8789333333333333`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100000000"}], ",", "0.97`"}], "}"}]}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9702948818199396`*^9, 
  3.970294887852851*^9}},ExpressionUUID->"3648f837-d606-4b1b-8ee6-\
842014a30fea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Figure S1(a) PL efficiency as a function of the electric field (fcc \
lattice)\n",
 StyleBox["Data for 0.01\[Times]nu_1,default , ..., 100\[Times]nu_1,default  \
in tab001fcc, tab01fcc,  ..., tab100fcc", "Subsubsection"]
}], "Section",
 CellChangeTimes->{{3.850406611010027*^9, 3.8504066341728697`*^9}, {
   3.850406682360574*^9, 3.850406733333763*^9}, {3.85040786742496*^9, 
   3.8504078713323936`*^9}, 3.850409855982238*^9, {3.850410655551868*^9, 
   3.8504106558150897`*^9}, {3.8504113623298287`*^9, 
   3.8504113952602673`*^9}, {3.8504114851514387`*^9, 
   3.8504114855517874`*^9}, {3.850453937352663*^9, 3.8504539507317057`*^9}, {
   3.8504571992229724`*^9, 3.8504572221249065`*^9}, {3.851536105747826*^9, 
   3.8515361326758037`*^9}, {3.8515749398002405`*^9, 
   3.8515749443883467`*^9}, {3.8515750996271687`*^9, 3.851575103773638*^9}, {
   3.851575299514915*^9, 3.8515753129461265`*^9}, {3.851581314275064*^9, 
   3.851581421390626*^9}, {3.851582629836712*^9, 3.85158263632047*^9}, {
   3.851621832464162*^9, 3.8516218393689976`*^9}, {3.8516227743109894`*^9, 
   3.8516227745584974`*^9}, {3.8518434127141323`*^9, 
   3.8518434213982773`*^9}, {3.851844733852085*^9, 3.851844734021181*^9}, {
   3.851845116043836*^9, 3.851845122404727*^9}, {3.851845182565321*^9, 
   3.851845182812565*^9}, {3.851845296255268*^9, 3.8518453123211827`*^9}, 
   3.851849954940507*^9, {3.8519659952359505`*^9, 3.8519660043988047`*^9}, {
   3.8519672144081964`*^9, 3.8519672497903028`*^9}, {3.851968178806324*^9, 
   3.8519681838658934`*^9}, {3.852005581312589*^9, 3.852005581660252*^9}, {
   3.8520166925971804`*^9, 3.852016716722085*^9}, {3.8521028148440485`*^9, 
   3.8521028152295227`*^9}, {3.85211769047598*^9, 3.8521177517106256`*^9}, {
   3.8521189838440857`*^9, 3.8521189842914906`*^9}, {3.852130069290101*^9, 
   3.8521300919026265`*^9}, {3.852130126633212*^9, 3.852130148049038*^9}, {
   3.852130285592149*^9, 3.852130297433449*^9}, {3.852131537395375*^9, 
   3.852131545879963*^9}, {3.85213269912004*^9, 3.8521327007593412`*^9}, {
   3.9669199454994164`*^9, 3.9669199459108624`*^9}, {3.966920347718565*^9, 
   3.9669203486208887`*^9}, {3.970294662000137*^9, 3.9702947473012857`*^9}, {
   3.9702948656021285`*^9, 3.9702948766417627`*^9}, 3.970295237920847*^9, {
   3.9702953828991876`*^9, 3.9702953833590508`*^9}, 
   3.970295478654449*^9},ExpressionUUID->"46df6c86-5efc-4d5b-8d28-\
dfecf9251985"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tab001fcc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5.`*^8"}], ",", "0.42133333333333334`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.5`*^8"}], ",", "0.5286666666666666`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.`*^8"}], ",", "0.6966666666666667`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.826`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.`*^8"}], ",", "0.8953333333333333`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.956`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.9833333333333333`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.9966666666666667`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`*^8"}], ",", "1.`"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab01fcc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.5`*^8"}], ",", "0.212`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.25`*^8"}], ",", "0.3`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.`*^8"}], ",", "0.3753`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.5747`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.`*^8"}], ",", "0.766`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.876`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.954`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.986`"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1fcc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.5`*^8"}], ",", "0.045833`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.25`*^8"}], ",", "0.08`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.`*^8"}], ",", "0.14`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.3289473684210526`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.`*^8"}], ",", "0.5384473684210526`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.7342105263157894`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.8857894736842105`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.9575`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`*^8"}], ",", "0.985`"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab10fcc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.`*^8"}], ",", "0.051333333333333335`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.75`*^8"}], ",", "0.085`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.13333333333333336`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.`*^8"}], ",", "0.31266666666666665`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.5693333333333334`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.752`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.9093333333333333`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`*^8"}], ",", "0.9793333333333333`"}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tab100fcc", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4.`*^8"}], ",", "0.00875`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3.75`*^8"}], ",", "0.02`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3.5`*^8"}], ",", "0.042727272727272725`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3.25`*^8"}], ",", "0.07`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3.`*^8"}], ",", "0.13818181818181818`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.5`*^8"}], ",", "0.38`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.`*^8"}], ",", "0.6372727272727273`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.75`*^8"}], ",", "0.75`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5`*^8"}], ",", "0.8372727272727273`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.25`*^8"}], ",", "0.9`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.`*^8"}], ",", "0.9518181818181818`"}], "}"}]}], 
     "}"}]}], ";"}], " "}]}], "Input",ExpressionUUID->"4fabf1d3-6b8d-455f-\
990e-3c386a906110"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Figure S1(b) PL efficiency as a function of the electric field (sc lattice)\
\n",
 StyleBox["Data for ", "Subsection"],
 StyleBox[Cell[BoxData[
  FormBox[
   SubscriptBox["\[Nu]", 
    RowBox[{"1", ",", 
     SubscriptBox["sc", " "]}]], TraditionalForm]], "Subsection",
  ExpressionUUID->"f3316d5e-64d0-41c7-8dd6-ca957066b901"], "Subsection"],
 StyleBox["= 0.1\[Times]nu_1,default , ..., 10\[Times]nu_1,default  in \
tab01sc,   ..., tab10s", "Subsection"],
 StyleBox["c (taken  from Fig. S1(a))", "Subsubsection"]
}], "Section",
 CellChangeTimes->{{3.850406611010027*^9, 3.8504066341728697`*^9}, {
   3.850406682360574*^9, 3.850406733333763*^9}, {3.85040786742496*^9, 
   3.8504078713323936`*^9}, 3.850409855982238*^9, {3.850410655551868*^9, 
   3.8504106558150897`*^9}, {3.8504113623298287`*^9, 
   3.8504113952602673`*^9}, {3.8504114851514387`*^9, 
   3.8504114855517874`*^9}, {3.850453937352663*^9, 3.8504539507317057`*^9}, {
   3.8504571992229724`*^9, 3.8504572221249065`*^9}, {3.851536105747826*^9, 
   3.8515361326758037`*^9}, {3.8515749398002405`*^9, 
   3.8515749443883467`*^9}, {3.8515750996271687`*^9, 3.851575103773638*^9}, {
   3.851575299514915*^9, 3.8515753129461265`*^9}, {3.851581314275064*^9, 
   3.851581421390626*^9}, {3.851582629836712*^9, 3.85158263632047*^9}, {
   3.851621832464162*^9, 3.8516218393689976`*^9}, {3.8516227743109894`*^9, 
   3.8516227745584974`*^9}, {3.8518434127141323`*^9, 
   3.8518434213982773`*^9}, {3.851844733852085*^9, 3.851844734021181*^9}, {
   3.851845116043836*^9, 3.851845122404727*^9}, {3.851845182565321*^9, 
   3.851845182812565*^9}, {3.851845296255268*^9, 3.8518453123211827`*^9}, 
   3.851849954940507*^9, {3.8519659952359505`*^9, 3.8519660043988047`*^9}, {
   3.8519672144081964`*^9, 3.8519672497903028`*^9}, {3.851968178806324*^9, 
   3.8519681838658934`*^9}, {3.852005581312589*^9, 3.852005581660252*^9}, {
   3.8520166925971804`*^9, 3.852016716722085*^9}, {3.8521028148440485`*^9, 
   3.8521028152295227`*^9}, {3.85211769047598*^9, 3.8521177517106256`*^9}, {
   3.8521189838440857`*^9, 3.8521189842914906`*^9}, {3.852130069290101*^9, 
   3.8521300919026265`*^9}, {3.852130126633212*^9, 3.852130148049038*^9}, {
   3.852130285592149*^9, 3.852130297433449*^9}, {3.852131537395375*^9, 
   3.852131545879963*^9}, {3.85213269912004*^9, 3.8521327007593412`*^9}, {
   3.9669199454994164`*^9, 3.9669199459108624`*^9}, {3.966920347718565*^9, 
   3.9669203486208887`*^9}, {3.970294662000137*^9, 3.9702947473012857`*^9}, {
   3.9702948656021285`*^9, 3.9702948766417627`*^9}, {3.970295025870099*^9, 
   3.970295026521757*^9}, {3.970295061390211*^9, 3.9702950727105217`*^9}, {
   3.9702951253653345`*^9, 3.970295185643981*^9}, {3.970295244287204*^9, 
   3.970295260054081*^9}, {3.9702953491708665`*^9, 3.970295372287757*^9}, 
   3.9702954743879943`*^9, {3.9703022679795833`*^9, 
   3.970302307111631*^9}},ExpressionUUID->"80b29e71-140c-4a41-9696-\
a8b6cb83feed"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tab01sc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.5`*^8"}], ",", "0.2633`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.`*^8"}], ",", "0.43041666666666667`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.5873809523809523`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.`*^8"}], ",", "0.7792`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.8794000000000001`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.959`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.988`"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1sc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5.5`*^8"}], ",", "0.02`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "500000000"}], ",", "0.04`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.5`*^8"}], ",", "0.08`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "400000000"}], ",", "0.175`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.35`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "300000000"}], ",", "0.58`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.78`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.91`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.97`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`*^8"}], ",", "0.99`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5.`*^7"}], ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab10sc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.`*^8"}], ",", "0.04454545454545455`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.15454545454545454`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.`*^8"}], ",", "0.35545454545454547`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.5981818181818181`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.7972727272727272`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.9463636363636364`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`*^8"}], ",", "0.9863636363636363`"}], "}"}]}], 
    "}"}]}], ";"}]}], "Input",ExpressionUUID->"ff2dd9e5-d6a7-4a81-a73a-\
3848b1253a39"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Figure S1(c) PL efficiency as a function of the electric field (sc lattice)\
\n",
 StyleBox["Data for ", "Subsection"],
 StyleBox[Cell[BoxData[
  FormBox[
   SubscriptBox["\[Nu]", 
    RowBox[{"1", ",", 
     SubscriptBox["sc", " "]}]], TraditionalForm]], "Subsection",
  ExpressionUUID->"9f253de7-1e49-4887-bfdb-0e60d702e834"], "Subsection"],
 StyleBox["= 0.1\[Times]nu_1,default , ..., 10\[Times]nu_1,default  in \
tab01sc,   ..., tab10s", "Subsection"],
 StyleBox["c (taken  from Fig. S1(a))", "Subsubsection"]
}], "Section",
 CellChangeTimes->{{3.850406611010027*^9, 3.8504066341728697`*^9}, {
   3.850406682360574*^9, 3.850406733333763*^9}, {3.85040786742496*^9, 
   3.8504078713323936`*^9}, 3.850409855982238*^9, {3.850410655551868*^9, 
   3.8504106558150897`*^9}, {3.8504113623298287`*^9, 
   3.8504113952602673`*^9}, {3.8504114851514387`*^9, 
   3.8504114855517874`*^9}, {3.850453937352663*^9, 3.8504539507317057`*^9}, {
   3.8504571992229724`*^9, 3.8504572221249065`*^9}, {3.851536105747826*^9, 
   3.8515361326758037`*^9}, {3.8515749398002405`*^9, 
   3.8515749443883467`*^9}, {3.8515750996271687`*^9, 3.851575103773638*^9}, {
   3.851575299514915*^9, 3.8515753129461265`*^9}, {3.851581314275064*^9, 
   3.851581421390626*^9}, {3.851582629836712*^9, 3.85158263632047*^9}, {
   3.851621832464162*^9, 3.8516218393689976`*^9}, {3.8516227743109894`*^9, 
   3.8516227745584974`*^9}, {3.8518434127141323`*^9, 
   3.8518434213982773`*^9}, {3.851844733852085*^9, 3.851844734021181*^9}, {
   3.851845116043836*^9, 3.851845122404727*^9}, {3.851845182565321*^9, 
   3.851845182812565*^9}, {3.851845296255268*^9, 3.8518453123211827`*^9}, 
   3.851849954940507*^9, {3.8519659952359505`*^9, 3.8519660043988047`*^9}, {
   3.8519672144081964`*^9, 3.8519672497903028`*^9}, {3.851968178806324*^9, 
   3.8519681838658934`*^9}, {3.852005581312589*^9, 3.852005581660252*^9}, {
   3.8520166925971804`*^9, 3.852016716722085*^9}, {3.8521028148440485`*^9, 
   3.8521028152295227`*^9}, {3.85211769047598*^9, 3.8521177517106256`*^9}, {
   3.8521189838440857`*^9, 3.8521189842914906`*^9}, {3.852130069290101*^9, 
   3.8521300919026265`*^9}, {3.852130126633212*^9, 3.852130148049038*^9}, {
   3.852130285592149*^9, 3.852130297433449*^9}, {3.852131537395375*^9, 
   3.852131545879963*^9}, {3.85213269912004*^9, 3.8521327007593412`*^9}, {
   3.9669199454994164`*^9, 3.9669199459108624`*^9}, {3.966920347718565*^9, 
   3.9669203486208887`*^9}, {3.970294662000137*^9, 3.9702947473012857`*^9}, {
   3.9702948656021285`*^9, 3.9702948766417627`*^9}, {3.970295025870099*^9, 
   3.970295026521757*^9}, {3.970295061390211*^9, 3.9702950727105217`*^9}, {
   3.9702951253653345`*^9, 3.970295185643981*^9}, {3.970295244287204*^9, 
   3.970295260054081*^9}, {3.970295405510007*^9, 3.970295497687566*^9}, {
   3.9703023141484685`*^9, 3.970302342300668*^9}, 
   3.9703024236974287`*^9},ExpressionUUID->"01dfe162-586b-45dd-97a6-\
1437783d5b3d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tab01sc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.5`*^8"}], ",", "0.2633`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.`*^8"}], ",", "0.43041666666666667`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.5873809523809523`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.`*^8"}], ",", "0.7792`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.8794000000000001`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.959`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.988`"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab1sc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5.5`*^8"}], ",", "0.02`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "500000000"}], ",", "0.04`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.5`*^8"}], ",", "0.08`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "400000000"}], ",", "0.175`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.35`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "300000000"}], ",", "0.58`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.78`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.91`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.97`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`*^8"}], ",", "0.99`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5.`*^7"}], ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab10sc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.`*^8"}], ",", "0.04454545454545455`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5`*^8"}], ",", "0.15454545454545454`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.`*^8"}], ",", "0.35545454545454547`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5`*^8"}], ",", "0.5981818181818181`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.`*^8"}], ",", "0.7972727272727272`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5`*^8"}], ",", "0.9463636363636364`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`*^8"}], ",", "0.9863636363636363`"}], "}"}]}], 
    "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9702955062461653`*^9, 3.970295515778205*^9}, 
   3.970302437165871*^9},ExpressionUUID->"8835967a-515c-4349-9cb6-\
9f6e33c5ca94"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Figure S1(c) PL efficiency as a function of the electric field (sc lattice)\
\n",
 StyleBox["Data for a log-normal distribution of ", "Subsection"],
 StyleBox[Cell[BoxData[
  FormBox[
   SubscriptBox["\[Nu]", 
    RowBox[{"1", ",", 
     SubscriptBox["sc", " "]}]], TraditionalForm]], "Subsection",
  ExpressionUUID->"aa1bf95d-d60d-41f9-95aa-6c684d6d26e6"], "Subsection"]
}], "Section",
 CellChangeTimes->{{3.850406611010027*^9, 3.8504066341728697`*^9}, {
   3.850406682360574*^9, 3.850406733333763*^9}, {3.85040786742496*^9, 
   3.8504078713323936`*^9}, 3.850409855982238*^9, {3.850410655551868*^9, 
   3.8504106558150897`*^9}, {3.8504113623298287`*^9, 
   3.8504113952602673`*^9}, {3.8504114851514387`*^9, 
   3.8504114855517874`*^9}, {3.850453937352663*^9, 3.8504539507317057`*^9}, {
   3.8504571992229724`*^9, 3.8504572221249065`*^9}, {3.851536105747826*^9, 
   3.8515361326758037`*^9}, {3.8515749398002405`*^9, 
   3.8515749443883467`*^9}, {3.8515750996271687`*^9, 3.851575103773638*^9}, {
   3.851575299514915*^9, 3.8515753129461265`*^9}, {3.851581314275064*^9, 
   3.851581421390626*^9}, {3.851582629836712*^9, 3.85158263632047*^9}, {
   3.851621832464162*^9, 3.8516218393689976`*^9}, {3.8516227743109894`*^9, 
   3.8516227745584974`*^9}, {3.8518434127141323`*^9, 
   3.8518434213982773`*^9}, {3.851844733852085*^9, 3.851844734021181*^9}, {
   3.851845116043836*^9, 3.851845122404727*^9}, {3.851845182565321*^9, 
   3.851845182812565*^9}, {3.851845296255268*^9, 3.8518453123211827`*^9}, 
   3.851849954940507*^9, {3.8519659952359505`*^9, 3.8519660043988047`*^9}, {
   3.8519672144081964`*^9, 3.8519672497903028`*^9}, {3.851968178806324*^9, 
   3.8519681838658934`*^9}, {3.852005581312589*^9, 3.852005581660252*^9}, {
   3.8520166925971804`*^9, 3.852016716722085*^9}, {3.8521028148440485`*^9, 
   3.8521028152295227`*^9}, {3.85211769047598*^9, 3.8521177517106256`*^9}, {
   3.8521189838440857`*^9, 3.8521189842914906`*^9}, {3.852130069290101*^9, 
   3.8521300919026265`*^9}, {3.852130126633212*^9, 3.852130148049038*^9}, {
   3.852130285592149*^9, 3.852130297433449*^9}, {3.852131537395375*^9, 
   3.852131545879963*^9}, {3.85213269912004*^9, 3.8521327007593412`*^9}, {
   3.9669199454994164`*^9, 3.9669199459108624`*^9}, {3.966920347718565*^9, 
   3.9669203486208887`*^9}, {3.970294662000137*^9, 3.9702947473012857`*^9}, {
   3.9702948656021285`*^9, 3.9702948766417627`*^9}, {3.970295025870099*^9, 
   3.970295026521757*^9}, {3.970295061390211*^9, 3.9702950727105217`*^9}, {
   3.9702951253653345`*^9, 3.970295185643981*^9}, {3.970295244287204*^9, 
   3.970295260054081*^9}, {3.970295405510007*^9, 3.970295497687566*^9}, {
   3.9703023141484685`*^9, 3.970302342300668*^9}, 3.9703024236974287`*^9, {
   3.970302986597247*^9, 3.970302989013755*^9}, {3.9703030217305183`*^9, 
   3.9703030610304146`*^9}},ExpressionUUID->"cf88f391-2151-40ef-994c-\
b0ee0000934f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"tab10k10LN3", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.`*^8"}], ",", "0.9875`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5`*^8"}], ",", "0.9375`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.`*^8"}], ",", "0.8525`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.5`*^8"}], ",", "0.66`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3.`*^8"}], ",", "0.4425`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3.5`*^8"}], ",", "0.28`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4.`*^8"}], ",", "0.1475`"}], "}"}]}], "}"}]}], ";"}], 
  " "}]], "Input",
 CellChangeTimes->{{3.9703031583545847`*^9, 
  3.9703031661973963`*^9}},ExpressionUUID->"1862cf46-76fd-4a2d-b856-\
32cc80cd38f4"]
}, Open  ]]
},
WindowSize->{1440, 831.75},
WindowMargins->{{-6, Automatic}, {Automatic, -6}},
TaggingRules->{
 "WelcomeScreenSettings" -> {"FEStarting" -> False}, "TryRealOnly" -> False},
Magnification:>1. Inherited,
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"aabf856c-81b4-4a0f-a93f-5456fb550d79"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 2485, 37, 94, "Section",ExpressionUUID->"925ecdda-8055-4fd2-b229-797f650fa2d2"],
Cell[3068, 61, 4401, 139, 181, "Input",ExpressionUUID->"3648f837-d606-4b1b-8ee6-842014a30fea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7506, 205, 2408, 36, 94, "Section",ExpressionUUID->"46df6c86-5efc-4d5b-8d28-dfecf9251985"],
Cell[9917, 243, 5281, 162, 181, "Input",ExpressionUUID->"4fabf1d3-6b8d-455f-990e-3c386a906110"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15235, 410, 2927, 47, 95, "Section",ExpressionUUID->"80b29e71-140c-4a41-9696-a8b6cb83feed"],
Cell[18165, 459, 2920, 91, 124, "Input",ExpressionUUID->"ff2dd9e5-d6a7-4a81-a73a-3848b1253a39"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21122, 555, 2925, 47, 95, "Section",ExpressionUUID->"01dfe162-586b-45dd-97a6-1437783d5b3d"],
Cell[24050, 604, 3014, 93, 124, "Input",ExpressionUUID->"8835967a-515c-4349-9cb6-9f6e33c5ca94"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27101, 702, 2883, 45, 95, "Section",ExpressionUUID->"cf88f391-2151-40ef-994c-b0ee0000934f"],
Cell[29987, 749, 959, 30, 28, "Input",ExpressionUUID->"1862cf46-76fd-4a2d-b856-32cc80cd38f4"]
}, Open  ]]
}
]
*)

