(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     59056,       1697]
NotebookOptionsPosition[     56325,       1641]
NotebookOutlinePosition[     56726,       1657]
CellTagsIndexPosition[     56683,       1654]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Figure 5\nData format: {voltage (V), normalized PL efficiency}. \nThe \
maximum voltage of -100 V corresponds to a field of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "5"}], "\[Times]", 
    SuperscriptBox["10", "8"]}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "f4acfd95-29ea-4dda-8328-259b6676e498"],
 " V/m."
}], "Subsection",
 CellChangeTimes->{{3.9702859102005053`*^9, 3.970285912526856*^9}, {
  3.9702889655909643`*^9, 3.970288976454298*^9}, {3.9703873049061832`*^9, 
  3.9703873068063216`*^9}},ExpressionUUID->"406458db-1c31-4fcb-a211-\
b470125a2969"],

Cell[CellGroupData[{

Cell["\<\
Fig. 5(a). Simulation results with a varying exciton binding energy - model 2
lamba = 0.3 nm (full curves)\
\>", "Subsubsection",
 CellChangeTimes->{{3.8777005592101603`*^9, 3.8777005848151417`*^9}, {
   3.8777752169840927`*^9, 3.877775232120535*^9}, {3.878044116456142*^9, 
   3.8780441178279004`*^9}, {3.878048086683409*^9, 3.8780480881714582`*^9}, {
   3.8781016929294844`*^9, 3.878101698756857*^9}, {3.9668529123159704`*^9, 
   3.9668529371388164`*^9}, {3.9702861867427855`*^9, 
   3.9702861870737724`*^9}, {3.970286503907161*^9, 3.97028650509031*^9}, {
   3.970288325364212*^9, 3.9702883548475046`*^9}, {3.9703873496064124`*^9, 
   3.970387350124008*^9}, {3.970392424387398*^9, 3.9703924426123734`*^9}, 
   3.9703941718090487`*^9},ExpressionUUID->"766ae288-a83e-411e-9775-\
fe499cdd23e9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tab082", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.012`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.034`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.0996`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.201`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.38`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "0.714`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "0.978`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab102", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.029`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.149`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.289`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.491`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.69`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.862`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.964`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "0.991`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab122", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.312`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.489`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.7`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.851`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.93`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.984`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9702884393507013`*^9, 3.9702884616827826`*^9}, 
   3.9702886112434354`*^9, {3.97038438863218*^9, 3.970384391540628*^9}, {
   3.9703844285049105`*^9, 3.970384480545693*^9}, {3.9703924689722214`*^9, 
   3.9703924721014175`*^9}},ExpressionUUID->"1b17d1ce-ebe3-4348-8ef8-\
f3d246525433"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Fig. 5(a). Simulation results with a varying exciton binding energy - model 2
lamba = 0.1 nm (dashed curves)\
\>", "Subsubsection",
 CellChangeTimes->{{3.8777005592101603`*^9, 3.8777005848151417`*^9}, {
   3.8777752169840927`*^9, 3.877775232120535*^9}, {3.878044116456142*^9, 
   3.8780441178279004`*^9}, {3.878048086683409*^9, 3.8780480881714582`*^9}, {
   3.8781016929294844`*^9, 3.878101698756857*^9}, {3.9668529123159704`*^9, 
   3.9668529371388164`*^9}, {3.9702861867427855`*^9, 
   3.9702861870737724`*^9}, {3.970286503907161*^9, 3.97028650509031*^9}, {
   3.970288325364212*^9, 3.9702883548475046`*^9}, {3.9703873496064124`*^9, 
   3.970387350124008*^9}, {3.970392424387398*^9, 3.9703924645485907`*^9}, 
   3.9703941781805716`*^9},ExpressionUUID->"86733930-bbbc-4805-9f75-\
f0472fa6c7d6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tab082", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.015"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.032"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.068"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.140"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.261"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.475"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "0.820"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "0.982"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab102", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.07"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.141"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.251"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.393"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.570"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.754"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.899"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.974"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "0.985"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tab122", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.535"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.685"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.811"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.903"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.956"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.984`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9702884393507013`*^9, 3.9702884616827826`*^9}, 
   3.9702886112434354`*^9, {3.97038438863218*^9, 3.970384391540628*^9}, {
   3.9703844285049105`*^9, 3.970384480545693*^9}, {3.970392482896573*^9, 
   3.9703926163532486`*^9}, {3.9703926872873707`*^9, 3.970392756960849*^9}, {
   3.9703928139477434`*^9, 
   3.9703928146204534`*^9}},ExpressionUUID->"e29872e0-619d-4b03-9c67-\
368c3574fe33"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Fig. 5(b), Simulation results with a varying value of sigma_exc - model 2
Variation of sigma_exc: 0 eV (data tabPLexc0) to 0.15 eV (tabPLexc15). \
\>", "Subsubsection",
 CellChangeTimes->{{3.8777005592101603`*^9, 3.8777005848151417`*^9}, {
   3.8777752169840927`*^9, 3.877775232120535*^9}, {3.878044116456142*^9, 
   3.8780441178279004`*^9}, {3.878048086683409*^9, 3.8780480881714582`*^9}, {
   3.8781016929294844`*^9, 3.878101698756857*^9}, {3.9668529123159704`*^9, 
   3.9668529371388164`*^9}, {3.9702861867427855`*^9, 
   3.9702861870737724`*^9}, {3.970286503907161*^9, 3.97028650509031*^9}, {
   3.970388951962145*^9, 3.9703889928326397`*^9}, 
   3.970394165394252*^9},ExpressionUUID->"c83d8e50-76bf-499e-9663-\
f530cc3f4e99"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tabPLexc0", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.2687`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.4739`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.6886`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.8649`"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabPLexc5", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.0316`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.0702`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.1526`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.2958`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.4882`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.6885`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.8631`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.967`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "0.9967`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabPLexc10", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.3391`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.5043`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.6824`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.8423`"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabPLexc15", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.3784`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.5202`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.6715`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.8188`"}], "}"}]}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.877700588221428*^9, 3.8777012307540684`*^9}, {
   3.8777012785382566`*^9, 3.8777014134973526`*^9}, {3.877701545623494*^9, 
   3.8777015476749988`*^9}, {3.8777015802887087`*^9, 
   3.8777016895180497`*^9}, {3.877710923032373*^9, 3.8777110265599957`*^9}, {
   3.8777533203207226`*^9, 3.8777534395703597`*^9}, {3.8777539096386137`*^9, 
   3.877753970111817*^9}, {3.8777752395589557`*^9, 3.8777753649670134`*^9}, {
   3.8777792490733805`*^9, 3.877779340925251*^9}, {3.8777794347603626`*^9, 
   3.8777795206161275`*^9}, {3.877779560889449*^9, 3.877779570196376*^9}, {
   3.8777797929024982`*^9, 3.877779815320055*^9}, {3.8780432066862135`*^9, 
   3.878043326929247*^9}, {3.8780433764047813`*^9, 3.878043439676257*^9}, {
   3.878043598217081*^9, 3.8780436041661153`*^9}, 3.878043763829651*^9, {
   3.8780441331301146`*^9, 3.8780444441278224`*^9}, {3.878044480350766*^9, 
   3.878044578295151*^9}, {3.878044717992906*^9, 3.878044740288867*^9}, {
   3.878046946603644*^9, 3.8780469510165977`*^9}, {3.8780480974417653`*^9, 
   3.878048279258032*^9}, {3.878048645737275*^9, 3.878048688361969*^9}, {
   3.8780490911681323`*^9, 3.878049110400833*^9}, {3.8780491679385147`*^9, 
   3.8780492850807934`*^9}, {3.8780596054008083`*^9, 
   3.8780596272469616`*^9}, {3.878059953516764*^9, 3.8780600740890293`*^9}, {
   3.8781017127143517`*^9, 3.8781019058217645`*^9}, {3.8781047566009855`*^9, 
   3.878104813953412*^9}, {3.8781051359811563`*^9, 3.878105231266486*^9}, {
   3.8781053135679893`*^9, 3.878105317531249*^9}, {3.878109896702841*^9, 
   3.87810996762598*^9}, 3.8781182662725286`*^9, {3.878292378664981*^9, 
   3.8782924506298294`*^9}, {3.966852950031908*^9, 3.966852952250846*^9}, 
   3.966853017561038*^9, {3.9702865272864656`*^9, 3.9702865274955435`*^9}, {
   3.970286586573739*^9, 3.9702866307792325`*^9}, {3.9702866908099775`*^9, 
   3.9702866941071424`*^9}, 3.9702867533403254`*^9, {3.970388789393407*^9, 
   3.9703888052789917`*^9}, {3.9703889197034526`*^9, 
   3.9703889345691204`*^9}, {3.9703890061285753`*^9, 3.970389198336212*^9}, {
   3.9703892336773615`*^9, 3.970389290091077*^9}, {3.9703951192865477`*^9, 
   3.970395123365139*^9}},ExpressionUUID->"ee8ce780-2b9f-4044-8599-\
270e008bf9f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Fig. 5(b), Simulation results with a varying value of sigma- model 2
Variation of sigma: 0.05 eV (data tabPLsigma05) to 0.15 eV (tabPLsigma15). \
\>", "Subsubsection",
 CellChangeTimes->{{3.8777005592101603`*^9, 3.8777005848151417`*^9}, {
   3.8777752169840927`*^9, 3.877775232120535*^9}, {3.878044116456142*^9, 
   3.8780441178279004`*^9}, {3.878048086683409*^9, 3.8780480881714582`*^9}, {
   3.8781016929294844`*^9, 3.878101698756857*^9}, {3.9668529123159704`*^9, 
   3.9668529371388164`*^9}, {3.9702861867427855`*^9, 
   3.9702861870737724`*^9}, {3.970286503907161*^9, 3.97028650509031*^9}, {
   3.970388951962145*^9, 3.9703889928326397`*^9}, {3.9703940235825634`*^9, 
   3.970394077958434*^9}, 
   3.9703941604744167`*^9},ExpressionUUID->"5d24e4d3-e13d-484f-a513-\
56e40b71a1da"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tabsigma05", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.033"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.073"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.208"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.448"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.722"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.912"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.983"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.995"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabsigma10", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.0316`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.0702`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.1526`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.2958`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.4882`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.6885`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.8631`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.967`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "0.9967`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabsigma15", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.028"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.057"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.107"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.187"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.297"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.422"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.555"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.702"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "0.867"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "0.82"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", "0.989"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", "0.992"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0.996"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9703943892560854`*^9, 3.9703945051904974`*^9}, {
  3.9703950040143147`*^9, 3.970395100338961*^9}, {3.9703951977206907`*^9, 
  3.9703952105505447`*^9}},ExpressionUUID->"d114f66a-f2d8-4de3-9ee4-\
f07e2508a7c9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Fig. 5(b), Simulation results with 7 D dipole moments- model 2\
\>", "Subsubsection",
 CellChangeTimes->{{3.8777005592101603`*^9, 3.8777005848151417`*^9}, {
   3.8777752169840927`*^9, 3.877775232120535*^9}, {3.878044116456142*^9, 
   3.8780441178279004`*^9}, {3.878048086683409*^9, 3.8780480881714582`*^9}, {
   3.8781016929294844`*^9, 3.878101698756857*^9}, {3.9668529123159704`*^9, 
   3.9668529371388164`*^9}, {3.9702861867427855`*^9, 
   3.9702861870737724`*^9}, {3.970286503907161*^9, 3.97028650509031*^9}, {
   3.970388951962145*^9, 3.9703889928326397`*^9}, {3.9703940235825634`*^9, 
   3.970394107510244*^9}, 
   3.9703941566815486`*^9},ExpressionUUID->"e2f75e57-441a-4050-a51a-\
bf2f558c88dd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tabdip7D", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.029"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.055"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.098"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.178"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.285"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.418"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.559"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.696"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "0.831"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "0.950"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", "0.965"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", "0.974"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "0.983"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0.986"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.988"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9703941353888683`*^9, 3.9703941390139704`*^9}, {
  3.970394195240947*^9, 
  3.970394370310561*^9}},ExpressionUUID->"0c9d2603-cb45-438a-9573-\
02b70fc20e21"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Fig. 5(c). Simulation results for a varying value of taurad - model 2\n\
Variation of the radiative decay time: ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "bc90c6d7-12fb-49da-be50-cd8f445034e6"],
 " s (data tabPL6) to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "10"}]], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "6a9db3af-8c1b-4b48-ad2a-819bb9d91b38"],
 " s (tabPL10). "
}], "Subsubsection",
 CellChangeTimes->{{3.8777005592101603`*^9, 3.8777005848151417`*^9}, {
  3.8777752169840927`*^9, 3.877775232120535*^9}, {3.966852828319372*^9, 
  3.9668528339413147`*^9}, {3.970286174783353*^9, 3.970286175090372*^9}, {
  3.9703870204954453`*^9, 3.970387279304035*^9}, {3.9703877811006165`*^9, 
  3.9703877812985177`*^9}, {3.9703879939870496`*^9, 
  3.9703880091941276`*^9}},ExpressionUUID->"15a55447-23e0-40bd-990c-\
9249240b11fd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tabPL6", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "100"}], ",", "0.0005`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "90"}], ",", "0.0014`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "80"}], ",", "0.0068`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "70"}], ",", "0.0283`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "60"}], ",", "0.1025`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "50"}], ",", "0.25222`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "40"}], ",", "0.4675`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "30"}], ",", "0.7204`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "20"}], ",", "0.9425`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "0.9981`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tabPL7", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "100"}], ",", "0.004`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "90"}], ",", "0.0119`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "80"}], ",", "0.036`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "70"}], ",", "0.1075`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "60"}], ",", "0.2574`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "50"}], ",", "0.4692`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "40"}], ",", "0.6913`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "30"}], ",", "0.8921`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "20"}], ",", "0.9861`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "0.9996`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tabPL8", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "100"}], ",", "0.0316`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "90"}], ",", "0.0702`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "80"}], ",", "0.1526`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "70"}], ",", "0.2958`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "60"}], ",", "0.4882`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "50"}], ",", "0.6885`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "40"}], ",", "0.8631`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "30"}], ",", "0.967`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "20"}], ",", "0.9967`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tabPL9", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "100"}], ",", "0.1291`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "90"}], ",", "0.2294`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "80"}], ",", "0.3646`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "70"}], ",", "0.5331`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "60"}], ",", "0.7037`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "50"}], ",", "0.8536`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "40"}], ",", "0.9506`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "30"}], ",", "0.9908`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "20"}], ",", "0.9994`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabPL10", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.3704`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.4934`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.6268`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.7594`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.874`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.9504`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.9866`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.9984`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "0.9999`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.877700588221428*^9, 3.8777012307540684`*^9}, {
   3.8777012785382566`*^9, 3.8777014134973526`*^9}, {3.877701545623494*^9, 
   3.8777015476749988`*^9}, {3.8777015802887087`*^9, 
   3.8777016895180497`*^9}, {3.877710923032373*^9, 3.8777110265599957`*^9}, {
   3.8777533203207226`*^9, 3.8777534395703597`*^9}, {3.8777539096386137`*^9, 
   3.877753970111817*^9}, {3.8777752395589557`*^9, 3.8777753649670134`*^9}, {
   3.8777792490733805`*^9, 3.877779340925251*^9}, {3.8777794347603626`*^9, 
   3.8777795206161275`*^9}, {3.877779560889449*^9, 3.877779570196376*^9}, {
   3.8777797929024982`*^9, 3.877779815320055*^9}, {3.8780432066862135`*^9, 
   3.878043326929247*^9}, {3.8780433764047813`*^9, 3.878043439676257*^9}, {
   3.878043598217081*^9, 3.8780436041661153`*^9}, 3.878043763829651*^9, {
   3.9668526880483675`*^9, 3.96685269031115*^9}, {3.9668529695217724`*^9, 
   3.9668529734148417`*^9}, 3.9703878163542547`*^9, {3.9703878500424857`*^9, 
   3.9703879769030905`*^9}, {3.9703880227894077`*^9, 
   3.9703880235135098`*^9}},ExpressionUUID->"2b1daf67-9753-41e5-b3c3-\
3a727851eb30"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Fig. 5(d). Simulation results reference case with a varying value of epsr- \
model 2
Variation of epsr: 2.5 (data tabPL25) to 4.0 (tabPL40). \
\>", "Subsubsection",
 CellChangeTimes->{{3.8777005592101603`*^9, 3.8777005848151417`*^9}, {
  3.8777752169840927`*^9, 3.877775232120535*^9}, {3.878044116456142*^9, 
  3.8780441178279004`*^9}, {3.9668528488677344`*^9, 3.9668528541373453`*^9}, {
  3.9702861789465637`*^9, 3.9702861792321377`*^9}, {3.9703880316820097`*^9, 
  3.9703880971453424`*^9}, {3.9704115997423306`*^9, 
  3.9704116006115212`*^9}},ExpressionUUID->"2668bda3-6d25-420f-b5e0-\
5876f7370d00"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tabPL25", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "100"}], ",", "0.008`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "90"}], ",", "0.0185`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "80"}], ",", "0.0483`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "70"}], ",", "0.114`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "60"}], ",", "0.2355`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "50"}], ",", "0.4222`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "40"}], ",", "0.6653`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "30"}], ",", "0.8993`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "25"}], ",", "0.9651`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "20"}], ",", "0.9918`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tabPL30", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "100"}], ",", "0.0316`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "90"}], ",", "0.0702`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "80"}], ",", "0.1526`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "70"}], ",", "0.2958`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "60"}], ",", "0.4882`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "50"}], ",", "0.6885`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "40"}], ",", "0.8631`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "30"}], ",", "0.967`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "20"}], ",", "0.9967`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tabPL35", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "100"}], ",", "0.073`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "90"}], ",", "0.1506`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "80"}], ",", "0.2731`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "70"}], ",", "0.4605`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "60"}], ",", "0.6613`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "50"}], ",", "0.8284`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "40"}], ",", "0.9367`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "30"}], ",", "0.9863`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "20"}], ",", "0.9986`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabPL40", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.1244`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.2246`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.3798`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.5794`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.7684`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.8974`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.9665`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.9934`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "0.9994`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.877700588221428*^9, 3.8777012307540684`*^9}, {
   3.8777012785382566`*^9, 3.8777014134973526`*^9}, {3.877701545623494*^9, 
   3.8777015476749988`*^9}, {3.8777015802887087`*^9, 
   3.8777016895180497`*^9}, {3.877710923032373*^9, 3.8777110265599957`*^9}, {
   3.8777533203207226`*^9, 3.8777534395703597`*^9}, {3.8777539096386137`*^9, 
   3.877753970111817*^9}, {3.8777752395589557`*^9, 3.8777753649670134`*^9}, {
   3.8777792490733805`*^9, 3.877779340925251*^9}, {3.8777794347603626`*^9, 
   3.8777795206161275`*^9}, {3.877779560889449*^9, 3.877779570196376*^9}, {
   3.8777797929024982`*^9, 3.877779815320055*^9}, {3.8780432066862135`*^9, 
   3.878043326929247*^9}, {3.8780433764047813`*^9, 3.878043439676257*^9}, {
   3.878043598217081*^9, 3.8780436041661153`*^9}, 3.878043763829651*^9, {
   3.8780441331301146`*^9, 3.8780444441278224`*^9}, {3.878044480350766*^9, 
   3.878044578295151*^9}, {3.878044717992906*^9, 3.878044740288867*^9}, {
   3.878046946603644*^9, 3.8780469510165977`*^9}, {3.966852864719366*^9, 
   3.9668528653160496`*^9}, 3.9668529969535437`*^9, {3.970388110949748*^9, 
   3.9703882056792197`*^9}, {3.9703882501659813`*^9, 3.97038825067192*^9}, {
   3.9704115894619837`*^9, 
   3.9704115896510425`*^9}},ExpressionUUID->"4bc29311-b530-4cd0-995e-\
313c00542656"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Fig. 5(e). Simulation results reference case with a varying value of ",
 StyleBox["a",
  FontSlant->"Italic"],
 " - model 2\nVariation of ",
 StyleBox["a",
  FontSlant->"Italic"],
 ": 1.2 nm (data tabPL12) to 0.8 nm (tabPL08). "
}], "Subsubsection",
 CellChangeTimes->{{3.8777005592101603`*^9, 3.8777005848151417`*^9}, {
  3.8777752169840927`*^9, 3.877775232120535*^9}, {3.878044116456142*^9, 
  3.8780441178279004`*^9}, {3.878048086683409*^9, 3.8780480881714582`*^9}, {
  3.9668528803843565`*^9, 3.9668528872386446`*^9}, {3.970286182868575*^9, 
  3.970286183142308*^9}, {3.970388259315111*^9, 
  3.970388334165363*^9}},ExpressionUUID->"c7a717eb-b97d-46f9-90e9-\
7dcceccc4001"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Results", " ", "for", " ", "a"}], " ", "=", " ", 
     RowBox[{"1.2", " ", "nm"}]}], ",", " ", 
    RowBox[{
     RowBox[{"obtained", " ", "with", " ", "epsr"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"3.6", " ", "and", " ", "lambda"}], " ", "=", " ", 
      RowBox[{"0.25", " ", "nm"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{"for", " ", "V"}], " ", "=", " ", "12"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"24", " ", "..."}], ".", " ", "120"}], " ", "V"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tabPL12", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.0292`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.0774`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.1713`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.3249`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.5314`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.7318`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.8877`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.9727`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.9973`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"result", " ", "for", " ", "a"}], " ", "=", " ", 
     RowBox[{"1", " ", "nm"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPL10", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.0316`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.0702`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.1526`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.2958`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.4882`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.6885`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.8631`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.967`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.9967`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Results", " ", "for", " ", "a"}], " ", "=", " ", 
      RowBox[{"0.9", " ", "nm"}]}], ",", " ", 
     RowBox[{
      RowBox[{"obtained", " ", "with", " ", "epsr"}], " ", "=", " ", 
      RowBox[{
       RowBox[{"2.7", " ", "and", " ", "lambda"}], " ", "=", " ", 
       RowBox[{"0.3333", " ", "nm"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"for", " ", "V"}], " ", "=", " ", "9"}], ",", " ", "18", ",", 
     " ", 
     RowBox[{"...", " ", "90", " ", "V"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPL09", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.0279`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.0618`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.1339`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.2588`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.4324`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.6426`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.8333`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.9606`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.997`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Results", " ", "for", " ", "a"}], " ", "=", " ", 
      RowBox[{"0.8", " ", "nm"}]}], ",", " ", 
     RowBox[{
      RowBox[{"obtained", " ", "with", " ", "epsr"}], " ", "=", " ", 
      RowBox[{
       RowBox[{"2.4", " ", "and", " ", "lambda"}], " ", "=", " ", 
       RowBox[{"0.375", " ", "nm"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"for", " ", "V"}], " ", "=", " ", "8"}], ",", " ", "16", ",", 
     " ", 
     RowBox[{"...", " ", "80", " ", "V"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabPL08", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "100"}], ",", "0.0196`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "90"}], ",", "0.0485`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "80"}], ",", "0.1068`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "70"}], ",", "0.2079`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "60"}], ",", "0.3557`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "50"}], ",", "0.5566`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "40"}], ",", "0.7848`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "30"}], ",", "0.9507`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "0.9968`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.877700588221428*^9, 3.8777012307540684`*^9}, {
   3.8777012785382566`*^9, 3.8777014134973526`*^9}, {3.877701545623494*^9, 
   3.8777015476749988`*^9}, {3.8777015802887087`*^9, 
   3.8777016895180497`*^9}, {3.877710923032373*^9, 3.8777110265599957`*^9}, {
   3.8777533203207226`*^9, 3.8777534395703597`*^9}, {3.8777539096386137`*^9, 
   3.877753970111817*^9}, {3.8777752395589557`*^9, 3.8777753649670134`*^9}, {
   3.8777792490733805`*^9, 3.877779340925251*^9}, {3.8777794347603626`*^9, 
   3.8777795206161275`*^9}, {3.877779560889449*^9, 3.877779570196376*^9}, {
   3.8777797929024982`*^9, 3.877779815320055*^9}, {3.8780432066862135`*^9, 
   3.878043326929247*^9}, {3.8780433764047813`*^9, 3.878043439676257*^9}, {
   3.878043598217081*^9, 3.8780436041661153`*^9}, 3.878043763829651*^9, {
   3.8780441331301146`*^9, 3.8780444441278224`*^9}, {3.878044480350766*^9, 
   3.878044578295151*^9}, {3.878044717992906*^9, 3.878044740288867*^9}, {
   3.878046946603644*^9, 3.8780469510165977`*^9}, {3.8780480974417653`*^9, 
   3.878048279258032*^9}, {3.878048645737275*^9, 3.878048688361969*^9}, {
   3.8780490911681323`*^9, 3.878049110400833*^9}, {3.8780491679385147`*^9, 
   3.8780492850807934`*^9}, {3.8780596054008083`*^9, 
   3.8780596272469616`*^9}, {3.878059953516764*^9, 3.8780600740890293`*^9}, {
   3.9668528975893316`*^9, 3.966852898191541*^9}, 3.966853007766593*^9, {
   3.9703883386546383`*^9, 
   3.970388433168432*^9}},ExpressionUUID->"886af7e4-139a-4798-bad4-\
bda39a681e54"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Fig. 5(f). Simulation results reference case with a varying value of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", 
    StyleBox["F",
     FontSlant->"Plain"]], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "142f84ae-3430-4ca4-8cdd-46fb7dfe3160"],
 ": - model 2\nVariation of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", 
    StyleBox["F",
     FontSlant->"Plain"]], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "5413d6ca-acc7-4b25-8575-7e7e94ff878d"],
 ": 0 nm (data tabRF0m2), 1.5 nm (data tabRF15m2), and 3.5 nm (data \
tabRF35m2),"
}], "Subsubsection",
 CellChangeTimes->{{3.8777005592101603`*^9, 3.8777005848151417`*^9}, {
  3.8777752169840927`*^9, 3.877775232120535*^9}, {3.878044116456142*^9, 
  3.8780441178279004`*^9}, {3.878048086683409*^9, 3.8780480881714582`*^9}, {
  3.9668528803843565`*^9, 3.9668528872386446`*^9}, {3.970286182868575*^9, 
  3.970286183142308*^9}, {3.970388259315111*^9, 3.970388334165363*^9}, {
  3.9704101345493555`*^9, 3.9704102216202784`*^9}, {3.9704102772076893`*^9, 
  3.9704102910909758`*^9}, {3.970410828274435*^9, 
  3.9704108342885637`*^9}},ExpressionUUID->"3e31fa00-dbc6-4e32-bedb-\
89e08f9cce81"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tabRF0m2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.0316`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.0702`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.1526`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.2958`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.4882`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.6885`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.8631`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.967`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "0.9967`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabRF15m2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.016"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.029"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.056"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.130"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.269"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.533"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", 
       RowBox[{"0.840", "+", "0.01"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.975"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabRF25m2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.006"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.010"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.017"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.041"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.111"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.326"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.748"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.975"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.877700588221428*^9, 3.8777012307540684`*^9}, {
   3.8777012785382566`*^9, 3.8777014134973526`*^9}, {3.877701545623494*^9, 
   3.8777015476749988`*^9}, {3.8777015802887087`*^9, 
   3.8777016895180497`*^9}, {3.877710923032373*^9, 3.8777110265599957`*^9}, {
   3.8777533203207226`*^9, 3.8777534395703597`*^9}, {3.8777539096386137`*^9, 
   3.877753970111817*^9}, {3.877779656494593*^9, 3.877779771397706*^9}, {
   3.9668526061835566`*^9, 3.966852625285075*^9}, 3.970410242321553*^9, {
   3.9704102971286917`*^9, 3.970410531529563*^9}, {3.970410801719356*^9, 
   3.970410813989927*^9}, {3.9704114313935833`*^9, 3.970411432634761*^9}},
 CellLabel->
  "In[333]:=",ExpressionUUID->"589cc2fc-e56e-4a5e-8935-6fd20dd5dbdf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Fig. 5(f). Simulation results reference case with a varying value of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", 
    StyleBox["F",
     FontSlant->"Plain"]], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "8e6012d6-e146-48f2-beec-74e4651b07e6"],
 ": - model 3\nVariation of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", 
    StyleBox["F",
     FontSlant->"Plain"]], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "cf45097f-8813-4236-a7b4-80f8af57c3db"],
 ": 0 nm (data tabRF0m3), 1.5 nm (data tabRF15m3), and 3.5 nm (data \
tabRF35m3),"
}], "Subsubsection",
 CellChangeTimes->{{3.8777005592101603`*^9, 3.8777005848151417`*^9}, {
  3.8777752169840927`*^9, 3.877775232120535*^9}, {3.878044116456142*^9, 
  3.8780441178279004`*^9}, {3.878048086683409*^9, 3.8780480881714582`*^9}, {
  3.9668528803843565`*^9, 3.9668528872386446`*^9}, {3.970286182868575*^9, 
  3.970286183142308*^9}, {3.970388259315111*^9, 3.970388334165363*^9}, {
  3.9704101345493555`*^9, 3.9704102216202784`*^9}, {3.9704102818924556`*^9, 
  3.970410293905474*^9}, {3.9704108377682714`*^9, 
  3.9704108436820264`*^9}},ExpressionUUID->"834a84c2-0423-48e8-800b-\
b0cfe7864d64"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tabRF0m3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.011"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.030"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.088"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.236"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.491"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.759"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.928"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.989"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "0.9999`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabRF15m3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.007"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.012"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.026"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.064"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.169"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.441"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.816"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.963"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tabRF25m3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "0.004"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "90"}], ",", "0.007"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "80"}], ",", "0.011"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "70"}], ",", "0.019"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "0.041"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "55"}], ",", "0.084"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "50"}], ",", "0.170"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "45"}], ",", "0.350"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "40"}], ",", "0.621"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "35"}], ",", "0.860"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", "0.959"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.970410563864239*^9, 3.9704108228780684`*^9}},
 CellLabel->
  "In[272]:=",ExpressionUUID->"51752cd5-2bbc-4f28-afa7-20fdae95138c"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1141.2, 574.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"04514059-12d8-4827-a62e-c20fc4197297"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 617, 15, 108, "Subsection",ExpressionUUID->"406458db-1c31-4fcb-a211-b470125a2969"],
Cell[CellGroupData[{
Cell[1222, 41, 803, 13, 71, "Subsubsection",ExpressionUUID->"766ae288-a83e-411e-9775-fe499cdd23e9"],
Cell[2028, 56, 3602, 116, 105, "Input",ExpressionUUID->"1b17d1ce-ebe3-4348-8ef8-f3d246525433"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5667, 177, 805, 13, 71, "Subsubsection",ExpressionUUID->"86733930-bbbc-4805-9f75-f0472fa6c7d6"],
Cell[6475, 192, 3611, 115, 105, "Input",ExpressionUUID->"e29872e0-619d-4b03-9c67-368c3574fe33"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10123, 312, 740, 12, 71, "Subsubsection",ExpressionUUID->"c83d8e50-76bf-499e-9663-f530cc3f4e99"],
Cell[10866, 326, 4757, 118, 105, "Input",ExpressionUUID->"ee8ce780-2b9f-4044-8599-270e008bf9f5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15660, 449, 793, 13, 71, "Subsubsection",ExpressionUUID->"5d24e4d3-e13d-484f-a513-56e40b71a1da"],
Cell[16456, 464, 3838, 124, 124, "Input",ExpressionUUID->"d114f66a-f2d8-4de3-9ee4-f07e2508a7c9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20331, 593, 711, 12, 45, "Subsubsection",ExpressionUUID->"e2f75e57-441a-4050-a51a-bf2f558c88dd"],
Cell[21045, 607, 1620, 52, 48, "Input",ExpressionUUID->"0c9d2603-cb45-438a-9573-02b70fc20e21"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22702, 664, 999, 24, 71, "Subsubsection",ExpressionUUID->"15a55447-23e0-40bd-990c-9249240b11fd"],
Cell[23704, 690, 6879, 204, 276, "Input",ExpressionUUID->"2b1daf67-9753-41e5-b3c3-3a727851eb30"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30620, 899, 612, 11, 71, "Subsubsection",ExpressionUUID->"2668bda3-6d25-420f-b5e0-5876f7370d00"],
Cell[31235, 912, 6005, 172, 219, "Input",ExpressionUUID->"4bc29311-b530-4cd0-995e-313c00542656"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37277, 1089, 695, 15, 71, "Subsubsection",ExpressionUUID->"c7a717eb-b97d-46f9-90e9-7dcceccc4001"],
Cell[37975, 1106, 8173, 221, 295, "Input",ExpressionUUID->"886af7e4-139a-4798-bad4-bda39a681e54"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46185, 1332, 1210, 28, 71, "Subsubsection",ExpressionUUID->"3e31fa00-dbc6-4e32-bedb-89e08f9cce81"],
Cell[47398, 1362, 4006, 120, 124, "Input",ExpressionUUID->"589cc2fc-e56e-4a5e-8935-6fd20dd5dbdf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51441, 1487, 1210, 28, 71, "Subsubsection",ExpressionUUID->"834a84c2-0423-48e8-800b-b0cfe7864d64"],
Cell[52654, 1517, 3643, 120, 124, "Input",ExpressionUUID->"51752cd5-2bbc-4f28-afa7-20fdae95138c"]
}, Open  ]]
}, Open  ]]
}
]
*)

