(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    167070,       4471]
NotebookOptionsPosition[    163164,       4406]
NotebookOutlinePosition[    163503,       4421]
CellTagsIndexPosition[    163460,       4418]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "program", " ", "is", " ", "linked", " ", "to", " ", "the", 
    " ", "article", " ", 
    RowBox[{"V", ".", "E", ".", " ", "Colussi"}], " ", "et", " ", 
    RowBox[{
    "al", ".", " ", 
     "\"\<Cumulant theory of the unitary Bose gas: Prethermal and Efimovian \
dynamics\>\""}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "It", " ", "verifies", " ", "the", " ", "cumulant", " ", "equations", " ", 
    "of", " ", "motion", " ", 
    RowBox[{"Eqs", ".", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"46", "--"}], "50"}], ")"}]}], " ", "and", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"124", "--"}], "135"}], ")"}]}], "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{"(*", 
   RowBox[{
   "The", " ", "dummy", " ", "variable", " ", "\"\<q\>\"", " ", "in", " ", 
    RowBox[{"Eqs", ".", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"46", "--"}], "50"}], ")"}]}], " ", "and", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"124", "--"}], "135"}], ")"}], " ", "is", " ", "called", " ", 
    "\"\<k3\>\"", " ", "here"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Internal", " ", "references"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"[", "1", "]"}], " ", 
     RowBox[{"J", ".", " ", "van"}], " ", "de", " ", "Kraats"}], ",", " ", 
    "\"\<Cumulant expansion for an ultracold quantum gas\>\"", ",", " ", 
    RowBox[{"TUe", " ", "Bachelor", " ", "thesis", " ", "2019"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"[", "2", "]"}], " ", 
     RowBox[{"R", ".", "Zitko"}]}], ",", " ", 
    "\"\<SNEG \[Dash] Mathematica package for symbolic calculations with \
second-quantization-operator expressions\>\""}], "*)"}], 
  RowBox[{"(*", 
   RowBox[{
   "Computer", " ", "Physics", " ", "Communications", " ", "182", " ", "2259",
     " ", 
    RowBox[{"(", "2011", ")"}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.7997667555614977`*^9, 3.7997667562916927`*^9}, {
  3.799766877523426*^9, 3.7997668830225554`*^9}, {3.7997669157212152`*^9, 
  3.799766920903968*^9}, {3.8026835018122377`*^9, 3.80268350205385*^9}, {
  3.803017920813636*^9, 3.803017921074312*^9}, {3.8030341249911118`*^9, 
  3.8030341526294727`*^9}, {3.803831281116385*^9, 3.803831539769554*^9}, {
  3.8038336300493717`*^9, 3.803833664446795*^9}, {3.803878517292665*^9, 
  3.803878518228092*^9}, {3.80387857218543*^9, 3.803878588664937*^9}, {
  3.803878662905074*^9, 
  3.8038786876322327`*^9}},ExpressionUUID->"d77cfea8-b3f7-418d-b895-\
91be80cba1f3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Preamble", ":", " ", 
     RowBox[{
     "initialisation", " ", "of", " ", "the", " ", "sneg", " ", "package", 
      " ", 
      RowBox[{"(", 
       RowBox[{
       "used", " ", "for", " ", "basic", " ", "2", "nd", " ", 
        "quantification", " ", "operations"}], ")"}]}]}], ",", " ", 
    RowBox[{"see", " ", 
     RowBox[{"Ref", ".", " ", 
      RowBox[{"[", "2", "]"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"<<", "sneg`"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Off", "[", 
     RowBox[{"LessEqual", "::", "nord2"}], "]"}], ";", 
    RowBox[{"(*", 
     RowBox[{
     "Switch", " ", "off", " ", "LessEqual", " ", "error", " ", "messages"}], 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"snegbosonoperators", "[", "a", "]"}], ";", " ", 
    RowBox[{"(*", 
     RowBox[{"Define", " ", "Boson", " ", 
      RowBox[{"creation", "/", "annihilation"}], " ", "operators"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"sumwavevectors", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"k1", ",", "k2", ",", "k3", ",", "k4"}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Define", " ", "indices", " ", "to", " ", "be", " ", "used", " ", "for", 
     " ", "wavevectors", " ", "in", " ", "sums"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"opwavevectors", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"al", ",", "bet", ",", "gam", ",", "del"}], "}"}]}], ";", " ", 
    RowBox[{"(*", 
     RowBox[{
     "Define", " ", "wavevector", " ", "indices", " ", "not", " ", "to", " ", 
      "be", " ", "used", " ", "in", " ", "sums"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"Apply", "[", 
     RowBox[{"snegfreeindexes", ",", " ", 
      RowBox[{"Union", "[", 
       RowBox[{"sumwavevectors", ",", "opwavevectors"}], "]"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ordering", "[", "a", "]"}], " ", "=", " ", "Empty"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.803831400059567*^9, 3.80383140943048*^9}, {
  3.8038785943817863`*^9, 
  3.803878636305746*^9}},ExpressionUUID->"42da60e1-9ad7-4072-b42d-\
8c9ce46ad00d"],

Cell[BoxData["\<\"/Users/hkurkjian/Documents/articles/2020EINDHOVEN_KRCMWK/\
Manuscript/MathematicaCheckCumulantsEOMs\"\>"], "Output",
 CellChangeTimes->{{3.799766733024644*^9, 3.7997667579749413`*^9}, 
   3.79976692141341*^9, 3.799766995884054*^9, 3.7997672457270527`*^9, 
   3.7997677744695873`*^9, 3.802683502538451*^9, 3.803017618136282*^9, 
   3.8030176594758987`*^9, 3.803017706447146*^9, 3.80301776406389*^9, 
   3.80301792142375*^9, 3.803033927747615*^9, 3.8030350801392107`*^9, 
   3.803831394440036*^9, 3.803877619729298*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"54c5cbc5-5351-4c07-b82f-b1700018574c"],

Cell[BoxData["\<\"sneg 1.250 Copyright (C) 2016 Rok Zitko\"\>"], "Print",
 CellChangeTimes->{3.799766921437038*^9, 3.799766995910475*^9, 
  3.799767245795311*^9, 3.7997677744877443`*^9, 3.802683502564703*^9, 
  3.8030176181601048`*^9, 3.803017659498485*^9, 3.803017706474757*^9, 
  3.80301776408785*^9, 3.80301792145186*^9, 3.803033927773769*^9, 
  3.80303508016121*^9, 3.803831394460464*^9, 3.8038776197465878`*^9},
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"920dcb33-c1bd-4fe2-bbdd-212bebdec708"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Custom", " ", "functions"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"deltaSwap", ":", " ", 
     RowBox[{"in", " ", 
      RowBox[{"KroneckerDelta", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{"solves", " ", "x"}], "==", 
     RowBox[{
     "y", " ", "to", " ", "isolate", " ", "the", " ", "elements", " ", "of", 
      " ", "sumwavectors"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"See", " ", "section", " ", "3.3", " ", "in", " ", 
    RowBox[{"Ref", ".", " ", 
     RowBox[{"[", "1", "]"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"deltaSwap", "[", 
     RowBox[{
      RowBox[{"n_", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ",", " ", "z_"}], "]"}], " ", ":=", 
    " ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "A", ",", "B", ",", "C", ",", "F", ",", "G", ",", "R", ",", "Y", ",", 
        "U", ",", "O", ",", "P", ",", " ", "c", ",", " ", "v"}], "}"}], ",", 
      " ", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"G", " ", "=", " ", 
        RowBox[{"{", 
         RowBox[{
         "C", ",", "F", ",", "R", ",", "Y", ",", "U", ",", "O", ",", "P"}], 
         "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"c", " ", "=", " ", 
        RowBox[{"x", "/.", " ", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"z", "[", 
             RowBox[{"[", "i", "]"}], "]"}], " ", "\[Rule]", " ", 
            RowBox[{"G", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", " ", 
             RowBox[{"Length", "[", "z", "]"}]}], "}"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"v", "=", " ", 
        RowBox[{"y", "/.", " ", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"z", "[", 
             RowBox[{"[", "i", "]"}], "]"}], " ", "\[Rule]", " ", 
            RowBox[{"G", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", " ", 
             RowBox[{"Length", "[", "z", "]"}]}], "}"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"A", ",", "B"}], "}"}], "=", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{"c", "\[Equal]", "v"}], ",", " ", 
            RowBox[{"G", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", "1"}], "}"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"A", ",", "B"}], "}"}], " ", "=", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "A", "]"}], " ", "\[Equal]", " ", "0"}], 
          ",", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Solve", "[", 
             RowBox[{
              RowBox[{"c", "\[Equal]", "v"}], ",", " ", 
              RowBox[{"G", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", "2"}], "}"}], 
          ",", " ", 
          RowBox[{"{", 
           RowBox[{"A", ",", "B"}], "}"}]}], " ", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"A", ",", "B"}], "}"}], " ", "=", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "A", "]"}], " ", "\[Equal]", " ", "0"}], 
          ",", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Solve", "[", 
             RowBox[{
              RowBox[{"c", "\[Equal]", "v"}], ",", " ", 
              RowBox[{"G", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], "]"}], ",", "3"}], "}"}], 
          ",", " ", 
          RowBox[{"{", 
           RowBox[{"A", ",", "B"}], "}"}]}], " ", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"A", ",", "B"}], "}"}], " ", "=", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "A", "]"}], " ", "\[Equal]", " ", "0"}], 
          ",", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Solve", "[", 
             RowBox[{
              RowBox[{"c", "\[Equal]", "v"}], ",", " ", 
              RowBox[{"G", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}], "]"}], ",", "4"}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"A", ",", "B"}], "}"}]}], " ", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"n", "[", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "A", "]"}], " ", "\[NotEqual]", " ", 
             "0"}], ",", 
            RowBox[{
             RowBox[{"G", "[", 
              RowBox[{"[", "B", "]"}], "]"}], " ", "/.", " ", 
             RowBox[{"A", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", "x"}], "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "A", "]"}], " ", "\[NotEqual]", " ", 
             "0"}], ",", " ", 
            RowBox[{"G", "[", 
             RowBox[{"[", "B", "]"}], "]"}], ",", "y"}], "]"}]}], "]"}], " ", 
        "/.", " ", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"G", "[", 
            RowBox[{"[", "i", "]"}], "]"}], " ", "\[Rule]", 
           RowBox[{"z", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", " ", 
            RowBox[{"Length", "[", "z", "]"}]}], "}"}]}], "]"}]}]}]}], 
     "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"cuSimplify", ":", " ", 
     RowBox[{
     "Remove", " ", "as", " ", "many", " ", "summations", " ", "as", " ", 
      "possible", " ", "using", " ", "the", " ", "Kronecker", " ", 
      "deltas"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"See", " ", "section", " ", "3.3", " ", "in", " ", 
     RowBox[{"Ref", ".", " ", 
      RowBox[{"[", "1", "]"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cuSimplify", "[", 
     RowBox[{"n_", ",", " ", "Assump_"}], "]"}], ":=", "   ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "v", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"v", " ", "=", " ", 
        RowBox[{
         RowBox[{"n", " ", "/.", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"KroneckerDelta", "[", 
             RowBox[{"x_", ",", " ", "y_"}], "]"}], " ", "\[Rule]", " ", 
            RowBox[{"Hold", "[", 
             RowBox[{"KroneckerDelta", "[", 
              RowBox[{
               RowBox[{"First", "[", 
                RowBox[{"Simplify", "[", 
                 RowBox[{"x", "\[Equal]", "y"}], "]"}], "]"}], ",", " ", 
               RowBox[{"Last", "[", 
                RowBox[{"Simplify", "[", 
                 RowBox[{"x", "\[Equal]", "y"}], "]"}], "]"}]}], "]"}], 
             "]"}]}], "}"}]}], "//", " ", "ReleaseHold"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"v", " ", "=", " ", 
        RowBox[{"v", "/.", " ", "Assump"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"v", " ", "=", " ", 
        RowBox[{"Expand", "[", 
         RowBox[{"sumExpand", "[", "v", "]"}], "]"}]}], ";", "\n", 
       RowBox[{"v", " ", "=", 
        RowBox[{
         RowBox[{"v", " ", "/.", " ", 
          RowBox[{
           RowBox[{"KroneckerDelta", "[", 
            RowBox[{"x_", ",", "y_"}], "]"}], " ", "\[Rule]", " ", 
           RowBox[{"Hold", "[", 
            RowBox[{"deltaSwap", "[", 
             RowBox[{
              RowBox[{"KroneckerDelta", "[", 
               RowBox[{"x", ",", "y"}], "]"}], ",", " ", "sumwavevectors"}], 
             "]"}], "]"}]}]}], " ", "//", " ", "ReleaseHold"}]}], ";", "\n", 
       RowBox[{"v", " ", "=", " ", 
        RowBox[{"v", " ", "/.", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"KroneckerDelta", "[", 
            RowBox[{"x_", ",", "y_"}], "]"}], "^", "z_"}], " ", "\[Rule]", 
          " ", 
          RowBox[{"KroneckerDelta", "[", 
           RowBox[{"x", ",", "y"}], "]"}]}]}]}], ";", "\n", 
       RowBox[{"v", " ", "=", " ", 
        RowBox[{"v", " ", "/.", " ", "Assump"}]}], ";", "\n", 
       RowBox[{"v", " ", "=", " ", 
        RowBox[{"Map", "[", 
         RowBox[{"sumSimplifyKD", ",", " ", "v"}], "]"}]}], ";", "\n", 
       RowBox[{"v", " ", "=", " ", 
        RowBox[{"v", " ", "/.", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"KroneckerDelta", "[", 
            RowBox[{"x_", ",", "y_"}], "]"}], "^", "z_"}], " ", "\[Rule]", 
          " ", 
          RowBox[{"KroneckerDelta", "[", 
           RowBox[{"x", ",", "y"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Map", "[", 
        RowBox[{"sumSimplifyKD", ",", " ", "v"}], "]"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"cu", ":", " ", 
     RowBox[{
     "notation", " ", "of", " ", "the", " ", "cumulant", " ", "average", " ", 
      "values"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"cu", "[", "x_", "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{"AngleBracket", "[", "x", "]"}], "^", "c"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Boolean", " ", "functions", " ", "to", " ", "filter", " ", "the", " ", 
     "contractions"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"contientun", ":", " ", 
      RowBox[{
      "FALSE", " ", "if", " ", "the", " ", "integer", " ", "list", " ", 
       "contains", " ", "a", " ", "1"}]}], ",", " ", 
     RowBox[{
     "remove", " ", "the", " ", "contractions", " ", "containing", " ", "a", 
      " ", "singlet"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"contientun", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"a", ",", 
       RowBox[{"Not", "[", 
        RowBox[{"MemberQ", "[", 
         RowBox[{"a", ",", "1"}], "]"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"troncature", ":", " ", 
      RowBox[{
       RowBox[{
       "FALSE", " ", "if", " ", "the", " ", "integer", " ", "list", " ", 
        "contains", " ", "a", " ", "number"}], " ", ">", "4"}]}], ",", " ", 
     RowBox[{
     "removes", " ", "the", " ", "contractions", " ", "containing", " ", "a", 
      " ", "cumulant", " ", "of", " ", "order", " ", "5", " ", "or", " ", 
      "higher"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"troncature", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"a", ",", 
       RowBox[{"Not", "[", 
        RowBox[{"AnyTrue", "[", 
         RowBox[{"a", ",", 
          RowBox[{
           RowBox[{"#", ">", "4"}], "&"}]}], "]"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"toutes", ":", " ", 
      RowBox[{"always", " ", "TRUE"}]}], ",", " ", 
     RowBox[{"not", " ", "filtering", " ", "between", " ", "doublet"}], ",", 
     " ", 
     RowBox[{"triplets", " ", "and", " ", "quadruplets"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"toutes", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"a", ",", "True"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"doublet", ":", " ", 
        RowBox[{
        "TRUE", " ", "if", " ", "the", " ", "integer", " ", "list", " ", 
         "contains", " ", "only", " ", "2"}]}], "\[CloseCurlyQuote]"}], "s"}],
      ",", " ", 
     RowBox[{"filters", " ", "the", " ", "doublet", " ", "contractions"}]}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"doublets", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"a", ",", 
       RowBox[{"AllTrue", "[", 
        RowBox[{"a", ",", 
         RowBox[{
          RowBox[{"#", "\[Equal]", "2"}], "&"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"triplets", ":", " ", 
        RowBox[{
        "TRUE", " ", "if", " ", "the", " ", "integer", " ", "list", " ", 
         "contains", " ", "only", " ", "3"}]}], "\[CloseCurlyQuote]"}], "s"}],
      ",", " ", 
     RowBox[{"filters", " ", "the", " ", "triplets", " ", "contractions"}]}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"triplets", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"a", ",", 
       RowBox[{"AllTrue", "[", 
        RowBox[{"a", ",", 
         RowBox[{
          RowBox[{"#", "\[Equal]", "3"}], "&"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"quadruplets", ":", " ", 
      RowBox[{
      "FALSE", " ", "if", " ", "the", " ", "integer", " ", "list", " ", 
       "does", " ", "not", " ", "contain", " ", "a", " ", "4"}]}], ",", " ", 
     RowBox[{
     "filters", " ", "the", " ", "quadruplet", " ", "contractions"}]}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"quadruplets", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"a", ",", 
       RowBox[{"AnyTrue", "[", 
        RowBox[{"a", ",", 
         RowBox[{
          RowBox[{"#", "\[Equal]", "4"}], "&"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Contractions", ":", " ", 
     RowBox[{
     "contracts", " ", "an", " ", "operator", " ", "product", " ", "in", " ", 
      "cumulants"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Contraction", "=", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "selection"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", "Arguments", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"x", "=", 
         RowBox[{
          RowBox[{"creation", "/", "annihilation"}], " ", "operator", " ", 
          RowBox[{"product", ":", " ", 
           RowBox[{"nc", "[", 
            RowBox[{
             RowBox[{"a", "[", 
              RowBox[{
               RowBox[{"0", " ", "ou", " ", "1"}], ",", "x_"}], "]"}], ",", 
             RowBox[{"a", "[", 
              RowBox[{
               RowBox[{"0", " ", "ou", " ", "1"}], ",", "y_"}], "]"}], ",", 
             "..."}], "]"}]}]}]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{"selection", "=", " ", 
         RowBox[{
         "a", " ", "Boolean", " ", "function", " ", "to", " ", "filter", " ", 
          "the", " ", "contractions", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
            "to", " ", "be", " ", "chosen", " ", "among", " ", 
             "\"\<toutes\>\""}], ",", " ", 
            RowBox[{
            "\"\<doublets\>\"", " ", "\"\<triplets\>\"", " ", "or", " ", 
             "\"\<quadruplets\>\""}]}], ")"}]}]}], "*)"}], 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "A", ",", "B", ",", "partitionsentieres", ",", "partitionA", ",", 
           "partitionAtr", ",", "clusters"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "x", "]"}], " ", "\[Equal]", " ", "0"}], 
            ",", " ", 
            RowBox[{"B", " ", "=", " ", 
             RowBox[{"{", "x", "}"}]}], ",", " ", 
            RowBox[{"B", " ", "=", " ", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"x", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"i", ",", " ", 
                 RowBox[{"Length", "[", "x", "]"}]}], "}"}]}], "]"}]}]}], 
           "]"}], ";", 
          RowBox[{"(*", 
           RowBox[{
           "transforms", " ", "x", " ", "in", " ", "a", " ", "list", " ", 
            "B"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"A", "=", 
           RowBox[{"Permutations", "[", "B", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"partitionsentieres", "=", 
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{"Permutations", "/@", 
              RowBox[{"IntegerPartitions", "[", 
               RowBox[{"Length", "[", 
                RowBox[{"A", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}]}], ",", "1"}], 
            "]"}]}], ";", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{"\"\<partitionsentieres\>\"", ":", " ", 
              RowBox[{
              "All", " ", "the", " ", "way", " ", "to", " ", "contract", " ", 
               "the", " ", "operator", " ", "product", " ", 
               RowBox[{"(", 
                RowBox[{"of", " ", "length", " ", 
                 RowBox[{"Length", "[", 
                  RowBox[{"A", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}]}]}], "]"}], 
            ")"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"partitionsentieres", "=", 
           RowBox[{"Select", "[", 
            RowBox[{"partitionsentieres", ",", "contientun"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"<", "a", ">=", "<", 
            RowBox[{"a", "^", "+"}], ">=", "0"}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"partitionsentieres", "=", 
           RowBox[{"Select", "[", 
            RowBox[{"partitionsentieres", ",", "troncature"}], "]"}]}], ";", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"quintic", " ", "or"}], " ", ">", " ", 
            RowBox[{"average", " ", "values", " ", "neglected"}]}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"partitionsentieres", "=", 
           RowBox[{"Select", "[", 
            RowBox[{"partitionsentieres", ",", "selection"}], "]"}]}], ";", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"selection", "=", 
             RowBox[{"function", " ", "among", " ", "\"\<toutes\>\""}]}], ",",
             " ", 
            RowBox[{
            "\"\<doublets\>\"", " ", "\"\<triplets\>\"", " ", "or", " ", 
             "\"\<quadruplets\>\""}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"partitionA", "=", 
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{"Table", "[", " ", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"FoldPairList", "[", 
                  RowBox[{"TakeDrop", ",", 
                   RowBox[{"A", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", "#"}], "]"}], "&"}], 
                "/@", "partitionsentieres"}], ",", 
               RowBox[{"{", 
                RowBox[{"i", ",", 
                 RowBox[{"Length", "[", "A", "]"}]}], "}"}]}], "]"}], ",", 
             "1"}], "]"}]}], ";", 
          RowBox[{"(*", 
           RowBox[{
           "splits", " ", "each", " ", "element", " ", "of", " ", "A", " ", 
            "according", " ", "to", " ", "the", " ", "remaining", " ", 
            "partitions", " ", "of", " ", "\"\<partitionsentieres\>\""}], 
           "*)"}], "\[IndentingNewLine]", 
          RowBox[{"partitionA", "=", 
           RowBox[{
            RowBox[{"Map", "[", 
             RowBox[{"Sort", ",", "partitionA", ",", "2"}], "]"}], "//", " ", 
            "DeleteDuplicates"}]}], ";", 
          RowBox[{"(*", 
           RowBox[{"normal", " ", "ordering"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"clusters", " ", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Product", "[", 
              RowBox[{
               RowBox[{"cu", "[", 
                RowBox[{"Apply", "[", 
                 RowBox[{"nc", ",", 
                  RowBox[{"partitionA", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}], "]"}], 
               ",", " ", 
               RowBox[{"{", 
                RowBox[{"j", ",", " ", 
                 RowBox[{"Length", "[", 
                  RowBox[{"partitionA", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
             ",", "  ", 
             RowBox[{"{", 
              RowBox[{"i", ",", " ", 
               RowBox[{"Length", "[", "partitionA", "]"}]}], "}"}]}], "]"}]}],
           ";", "\[IndentingNewLine]", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{"clusters", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", " ", 
              RowBox[{"Length", "[", "clusters", "]"}]}], "}"}]}], "]"}]}]}], 
        "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      StyleBox["conversion",
       FontSize->14], ":", " ", 
      RowBox[{"list", " ", "of", " ", 
       RowBox[{"rules", ".", " ", "Writes"}], " ", "the", " ", "cumulants", 
       " ", "in", " ", "the", " ", "article", " ", "notations"}]}], ",", " ", 
     
     RowBox[{"see", " ", 
      RowBox[{"Eqs", ".", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"34", "--"}], "36"}], ")"}]}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["conversion",
      FontSize->14], "=", " ", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"cu", "[", 
         RowBox[{"nc", "[", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"CR", ",", "  ", "y_"}], "]"}], ",", " ", 
           RowBox[{"a", "[", 
            RowBox[{"AN", ",", "   ", "w_"}], "]"}]}], "]"}], "]"}], " ", 
        "\[Rule]", " ", 
        RowBox[{
         RowBox[{"nn", "[", "y", "]"}], "*", " ", 
         RowBox[{"KroneckerDelta", "[", 
          RowBox[{"y", ",", "w"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"cu", "[", 
         RowBox[{"nc", "[", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"AN", ",", "  ", "y_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"AN", ",", "   ", "w_"}], "]"}]}], "]"}], "]"}], " ", 
        "\[Rule]", " ", 
        RowBox[{
         RowBox[{"cc", "[", "y", "]"}], "*", " ", 
         RowBox[{"KroneckerDelta", "[", 
          RowBox[{"y", ",", " ", 
           RowBox[{"-", "w"}]}], "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"cu", "[", 
         RowBox[{"nc", "[", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"CR", ",", "  ", "y_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"CR", ",", "   ", "w_"}], "]"}]}], "]"}], "]"}], " ", 
        "\[Rule]", " ", 
        RowBox[{
         RowBox[{"Conjugate", "[", 
          RowBox[{"cc", "[", "y", "]"}], "]"}], "*", " ", 
         RowBox[{"KroneckerDelta", "[", 
          RowBox[{"y", ",", " ", 
           RowBox[{"-", "w"}]}], "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"cu", "[", 
         RowBox[{"nc", "[", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"AN", ",", "  ", "y_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"AN", ",", "   ", "w_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"AN", ",", "   ", "v_"}], "]"}]}], "]"}], "]"}], " ", 
        "\[Rule]", " ", 
        RowBox[{
         RowBox[{"R", "[", 
          RowBox[{"y", ",", 
           RowBox[{"-", "w"}]}], "]"}], "*", " ", 
         RowBox[{"KroneckerDelta", "[", 
          RowBox[{"v", ",", " ", 
           RowBox[{
            RowBox[{"-", "y"}], "-", "w"}]}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"cu", "[", 
         RowBox[{"nc", "[", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"CR", ",", "  ", "y_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"CR", ",", "   ", "w_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"CR", ",", "   ", "v_"}], "]"}]}], "]"}], "]"}], " ", 
        "\[Rule]", " ", 
        RowBox[{
         RowBox[{"Conjugate", "[", 
          RowBox[{"R", "[", 
           RowBox[{"y", ",", 
            RowBox[{"-", "w"}]}], "]"}], "]"}], "*", " ", 
         RowBox[{"KroneckerDelta", "[", 
          RowBox[{"v", ",", " ", 
           RowBox[{
            RowBox[{"-", "y"}], "-", "w"}]}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"cu", "[", 
         RowBox[{"nc", "[", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"CR", ",", "  ", "y_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"AN", ",", "   ", "v_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"AN", ",", "   ", "w_"}], "]"}]}], "]"}], "]"}], " ", 
        "\[Rule]", " ", 
        RowBox[{
         RowBox[{"Conjugate", "[", 
          RowBox[{"M", "[", 
           RowBox[{"y", ",", "v"}], "]"}], "]"}], "*", " ", 
         RowBox[{"KroneckerDelta", "[", 
          RowBox[{"y", ",", " ", 
           RowBox[{"v", "+", "w"}]}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"cu", "[", 
         RowBox[{"nc", "[", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"CR", ",", "  ", "v_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"CR", ",", "   ", "w_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"AN", ",", "   ", "y_"}], "]"}]}], "]"}], "]"}], " ", 
        "\[Rule]", " ", 
        RowBox[{
         RowBox[{"M", "[", 
          RowBox[{"y", ",", "v"}], "]"}], "*", " ", 
         RowBox[{"KroneckerDelta", "[", 
          RowBox[{"y", ",", " ", 
           RowBox[{"v", "+", "w"}]}], "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"cu", "[", 
         RowBox[{"nc", "[", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"AN", ",", "  ", "u_"}], "]"}], ",", 
           RowBox[{"a", "[", 
            RowBox[{"AN", ",", "  ", "v_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"AN", ",", "   ", "w_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"AN", ",", "   ", "y_"}], "]"}]}], "]"}], "]"}], " ", 
        "\[Rule]", " ", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"u", ",", "v", ",", "w"}], "]"}], "*", " ", 
         RowBox[{"KroneckerDelta", "[", 
          RowBox[{"y", ",", " ", 
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"u", "+", "v", "+", "w"}], ")"}]}]}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"cu", "[", 
         RowBox[{"nc", "[", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"CR", ",", "  ", "u_"}], "]"}], ",", 
           RowBox[{"a", "[", 
            RowBox[{"CR", ",", "  ", "v_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"CR", ",", "   ", "w_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"CR", ",", "   ", "y_"}], "]"}]}], "]"}], "]"}], " ", 
        "\[Rule]", " ", 
        RowBox[{
         RowBox[{"Conjugate", "[", 
          RowBox[{"T", "[", 
           RowBox[{"u", ",", "v", ",", "w"}], "]"}], "]"}], "*", " ", 
         RowBox[{"KroneckerDelta", "[", 
          RowBox[{"y", ",", " ", 
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"u", "+", "v", "+", "w"}], ")"}]}]}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"cu", "[", 
         RowBox[{"nc", "[", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"CR", ",", "  ", "y_"}], "]"}], ",", 
           RowBox[{"a", "[", 
            RowBox[{"AN", ",", "  ", "u_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"AN", ",", "   ", "v_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"AN", ",", "   ", "w_"}], "]"}]}], "]"}], "]"}], " ", 
        "\[Rule]", 
        RowBox[{
         RowBox[{"P", "[", 
          RowBox[{"u", ",", "v", ",", "w"}], "]"}], "*", " ", 
         RowBox[{"KroneckerDelta", "[", 
          RowBox[{"y", ",", " ", 
           RowBox[{"u", "+", "v", "+", "w"}]}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"cu", "[", 
         RowBox[{"nc", "[", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"CR", ",", "  ", "u_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"CR", ",", "   ", "v_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"CR", ",", "   ", "w_"}], "]"}], ",", 
           RowBox[{"a", "[", 
            RowBox[{"AN", ",", "  ", "y_"}], "]"}]}], "]"}], "]"}], " ", 
        "\[Rule]", 
        RowBox[{
         RowBox[{"Conjugate", "[", 
          RowBox[{"P", "[", 
           RowBox[{"u", ",", "v", ",", "w"}], "]"}], "]"}], "*", " ", 
         RowBox[{"KroneckerDelta", "[", 
          RowBox[{"y", ",", " ", 
           RowBox[{"u", "+", "v", "+", "w"}]}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"cu", "[", 
         RowBox[{"nc", "[", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"CR", ",", "  ", "y_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"CR", ",", "   ", "u_"}], "]"}], ",", 
           RowBox[{"a", "[", " ", 
            RowBox[{"AN", ",", "   ", "v_"}], "]"}], ",", 
           RowBox[{"a", "[", 
            RowBox[{"AN", ",", "  ", "w_"}], "]"}]}], "]"}], "]"}], " ", 
        "\[Rule]", 
        RowBox[{
         RowBox[{"Q", "[", 
          RowBox[{"v", ",", "w", ",", "u"}], "]"}], "*", " ", 
         RowBox[{"KroneckerDelta", "[", 
          RowBox[{"y", ",", " ", 
           RowBox[{"v", "+", "w", "-", "u"}]}], "]"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"ContractionListe", ":", " ", 
     RowBox[{
     "same", " ", "as", " ", "\"\<Contraction\>\"", " ", "but", " ", "for", 
      " ", "a", " ", "list", " ", 
      RowBox[{"(", 
       RowBox[{"or", " ", "a", " ", "sum"}], ")"}], " ", "of", " ", 
      "operator", " ", "products"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Writes", " ", "the", " ", "output", " ", "in", " ", "article", " ", 
     "notations", " ", "using", " ", "\"\<conversion\>\""}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ContractionListe", "=", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"listop", ",", "selection", ",", "consimpulsion"}], "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"(*", "Arguments", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"listop", "=", 
         RowBox[{"list", " ", 
          RowBox[{"(", 
           RowBox[{"or", " ", "sum"}], ")"}], " ", "of", " ", "operator", " ",
           "products"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"selection", "=", 
         RowBox[{
         "Boolean", " ", "function", " ", "to", " ", "filter", " ", "the", 
          " ", "contractions", " ", "passed", " ", "on", " ", "to", " ", 
          "\"\<Contraction\>\""}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"consimpulsion", "=", " ", 
          RowBox[{
          "momentum", " ", "conservation", " ", "rule", " ", "to", " ", 
           "eliminate", " ", "one", " ", "of", " ", "the", " ", 
           RowBox[{"opwavevectors", ".", " ", 
            RowBox[{"Examples", ":", " ", "\"\<gam->al+bet\>\""}]}]}]}], ",", 
         " ", "\"\<del->al+bet+gam\>\""}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "listopnue", ",", "contr", ",", "contrsimpl", ",", "Remplacements", 
           ",", "resultat"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
           "Extract", " ", "the", " ", "operator", " ", "products", " ", 
            "appearing", " ", "in", " ", "listop"}], ",", " ", 
           RowBox[{
           "without", " ", "the", " ", "sums", " ", "or", " ", "numerical", 
            " ", "prefactors"}]}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"listopnue", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"sumExpand", "[", 
               RowBox[{"listop", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "]"}], " ", "/.", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"sum", "[", 
                   RowBox[{"x_", ",", " ", "y_"}], "]"}]}], " ", "\[Rule]", 
                 " ", "x"}], ",", 
                RowBox[{
                 RowBox[{"sum", "[", 
                  RowBox[{"x_", ",", " ", "y_"}], "]"}], " ", "\[Rule]", " ", 
                 "x"}], ",", "  ", 
                RowBox[{"_Rational", "\[Rule]", " ", "1"}]}], "}"}]}], ",", 
             " ", 
             RowBox[{"{", 
              RowBox[{"i", ",", " ", "1", ",", " ", 
               RowBox[{"Length", "[", "listop", "]"}]}], "}"}]}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"listopnue", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"listopnue", "/.", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "x_"}], "*", 
                 RowBox[{"V", "[", "y_", "]"}]}], "\[Rule]", 
                RowBox[{"x", "*", 
                 RowBox[{"V", "[", "y", "]"}]}]}], "}"}]}], "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"V", "[", "l_", "]"}], "\[Rule]", "1"}], "}"}]}], "/.", 
            RowBox[{"{", " ", 
             RowBox[{
              RowBox[{"_Integer", " ", ">", "1"}], "\[Rule]", " ", "1"}], 
             "}"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"contr", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Contraction", "[", 
              RowBox[{
               RowBox[{"listopnue", "[", 
                RowBox[{"[", "i", "]"}], "]"}], ",", "selection"}], "]"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", 
               RowBox[{"Length", "[", "listopnue", "]"}]}], "}"}]}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"contr", "=", 
           RowBox[{
            RowBox[{"contr", "/.", "conversion"}], "/.", 
            RowBox[{"{", "consimpulsion", "}"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"contr", "=", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"cuSimplify", "[", 
               RowBox[{"#", ",", 
                RowBox[{"{", "}"}]}], "]"}], "&"}], ",", "contr"}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"contr", "=", 
           RowBox[{"contr", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"KroneckerDelta", "[", 
               RowBox[{"0", ",", "x_"}], "]"}], "\[Rule]", "0"}], "}"}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"Remplacements", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"listopnue", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "->", 
              RowBox[{"contr", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", 
               RowBox[{"Length", "[", "listopnue", "]"}]}], "}"}]}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"listop", "/.", "Remplacements"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"sumExpand", "[", "resultat", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"sumSimplifyKD", "[", "resultat", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"cuSimplify", "[", 
               RowBox[{"#", ",", 
                RowBox[{"{", "}"}]}], "]"}], "&"}], ",", "resultat"}], 
            "]"}]}]}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Definition", " ", "of", " ", "V"}], ",", " ", 
     RowBox[{"the", " ", "local", " ", "potential"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetAttributes", "[", 
     RowBox[{"V", ",", "NumericFunction"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Conjugate", "[", 
      RowBox[{"V", "[", "k_", "]"}], "]"}], "^=", " ", 
     RowBox[{"V", "[", "k", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Definition", " ", "of", " ", "the", " ", "terms", " ", "of", " ", 
      "H3"}], ",", " ", 
     RowBox[{"the", " ", "cubic", " ", "hamiltonian"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"termeH30", "=", 
     RowBox[{"nc", "[", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"0", ",", 
         RowBox[{"k1", "+", "k2"}]}], "]"}], ",", " ", 
       RowBox[{"a", "[", 
        RowBox[{"1", ",", "  ", "k1"}], "]"}], ",", " ", 
       RowBox[{"a", "[", 
        RowBox[{"1", ",", "k2"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"termeH3", "=", 
     RowBox[{"(", 
      RowBox[{"termeH30", "+", 
       RowBox[{"conj", "[", "termeH30", "]"}]}], ")"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"commH3", ":", " ", 
     RowBox[{
     "takes", " ", "the", " ", "commutator", " ", "of", " ", "\"\<op\>\"", 
      " ", "with", " ", "H3"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"commH3", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"op", ",", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "resultat", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"resultat", "=", 
           RowBox[{"sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"V", "[", "k1", "]"}], "*", 
              RowBox[{"komutator", "[", 
               RowBox[{"op", ",", "termeH3"}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"k1", ",", "k2"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"cuSimplify", "[", 
               RowBox[{"#", ",", " ", 
                RowBox[{"{", "}"}]}], "]"}], " ", "&"}], ",", " ", 
             "resultat"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"sumExpand", "[", "resultat", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"sumSimplifyKD", "[", "resultat", "]"}]}]}]}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Definition", " ", "of", " ", "the", " ", "terms", " ", "of", " ", 
     RowBox[{"H4", ".", " ", "The"}], " ", "factor", " ", 
     RowBox[{"1", "/", "2"}], " ", "is", " ", "omitted", " ", "to", " ", 
     "facilitate", " ", "the", " ", 
     RowBox[{"manipulations", ".", " ", "It"}], " ", "is", " ", "restored", 
     " ", "manually", " ", "at", " ", "the", " ", "end", " ", "of", " ", 
     "the", " ", "calculations"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"termeH4", "=", 
     RowBox[{"nc", "[", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"0", ",", 
         RowBox[{"k1", "+", "k3"}]}], "]"}], ",", " ", 
       RowBox[{"a", "[", 
        RowBox[{"0", ",", "  ", 
         RowBox[{"k2", "-", "k3"}]}], "]"}], ",", " ", 
       RowBox[{"a", "[", 
        RowBox[{"1", ",", "k2"}], "]"}], ",", " ", 
       RowBox[{"a", "[", 
        RowBox[{"1", ",", "k1"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"commH3", ":", " ", 
     RowBox[{
     "takes", " ", "the", " ", "commutator", " ", "of", " ", "\"\<op\>\"", 
      " ", "with", " ", "H3"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"commH4", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"op", ",", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "resultat", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"resultat", "=", 
           RowBox[{"sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"V", "[", "k3", "]"}], "*", 
              RowBox[{"komutator", "[", 
               RowBox[{"op", ",", "termeH4"}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"k1", ",", "k2", ",", "k3"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"cuSimplify", "[", 
               RowBox[{"#", ",", " ", 
                RowBox[{"{", "}"}]}], "]"}], " ", "&"}], ",", " ", 
             "resultat"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"sumExpand", "[", "resultat", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"sumSimplifyKD", "[", "resultat", "]"}]}]}]}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Total", " ", "symmetrizers", " ", "of", " ", "the", " ", "analytic", " ",
      "expressions"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"SM", ":", " ", 
     RowBox[{"symmetrizer", " ", "of", " ", "M"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SM", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"resultat", ",", "bet2"}], "}"}], ",", 
         RowBox[{
          RowBox[{"resultat", "=", 
           RowBox[{"x", "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"x", "/.", 
                RowBox[{"{", 
                 RowBox[{"al", "->", "bet2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"bet", "\[Rule]", "al"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"bet2", "\[Rule]", "bet"}], "}"}]}], ")"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"resultat", "/.", 
            RowBox[{"{", 
             RowBox[{"gam", "\[Rule]", 
              RowBox[{"al", "+", "bet"}]}], "}"}]}]}]}]}], "]"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"SR", ":", " ", 
     RowBox[{"symmetrizer", " ", "of", " ", "R"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SR", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"resultat", ",", "bet2", ",", "gam2"}], "}"}], ",", 
         RowBox[{
          RowBox[{"resultat", "=", 
           RowBox[{"x", "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"x", "/.", 
                RowBox[{"{", 
                 RowBox[{"al", "->", "bet2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"bet", "\[Rule]", "al"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"bet2", "\[Rule]", "bet"}], "}"}]}], ")"}], "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"x", "/.", 
                RowBox[{"{", 
                 RowBox[{"al", "\[Rule]", "gam2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"gam", "\[Rule]", "al"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"gam2", "\[Rule]", "gam"}], "}"}]}], ")"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"resultat", "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"resultat", "/.", 
                RowBox[{"{", 
                 RowBox[{"bet", "\[Rule]", "gam2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"gam", "\[Rule]", "bet"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"gam2", "\[Rule]", "gam"}], "}"}]}], ")"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"resultat", "/.", 
            RowBox[{"{", 
             RowBox[{"gam", "\[Rule]", 
              RowBox[{
               RowBox[{"-", "al"}], "-", "bet"}]}], "}"}]}]}]}]}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"ST", ":", " ", 
     RowBox[{"symmetrizer", " ", "of", " ", "T"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ST", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"resultat", ",", "bet2", ",", "gam2", ",", "del2"}], "}"}], 
         ",", 
         RowBox[{
          RowBox[{"resultat", "=", 
           RowBox[{"x", "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"x", "/.", 
                RowBox[{"{", 
                 RowBox[{"al", "->", "bet2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"bet", "\[Rule]", "al"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"bet2", "\[Rule]", "bet"}], "}"}]}], ")"}], "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"x", "/.", 
                RowBox[{"{", 
                 RowBox[{"al", "\[Rule]", "gam2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"gam", "\[Rule]", "al"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"gam2", "\[Rule]", "gam"}], "}"}]}], ")"}], "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"x", "/.", 
                RowBox[{"{", 
                 RowBox[{"al", "\[Rule]", "del2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"del", "\[Rule]", "al"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"del2", "\[Rule]", "del"}], "}"}]}], ")"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"resultat", "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"resultat", "/.", 
                RowBox[{"{", 
                 RowBox[{"bet", "\[Rule]", "gam2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"gam", "\[Rule]", "bet"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"gam2", "\[Rule]", "gam"}], "}"}]}], ")"}], "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"resultat", "/.", 
                RowBox[{"{", 
                 RowBox[{"bet", "\[Rule]", "del2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"del", "\[Rule]", "bet"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"del2", "\[Rule]", "del"}], "}"}]}], ")"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"resultat", "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"resultat", "/.", 
                RowBox[{"{", 
                 RowBox[{"gam", "\[Rule]", "del2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"del", "\[Rule]", "gam"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"del2", "\[Rule]", "del"}], "}"}]}], ")"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"resultat", "/.", 
            RowBox[{"{", 
             RowBox[{"del", "\[Rule]", 
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"al", "+", "bet", "+", "gam"}], ")"}]}]}], 
             "}"}]}]}]}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"SP", ":", " ", 
     RowBox[{"symmetrizer", " ", "of", " ", "P"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SP", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"resultat", ",", "bet2", ",", "gam2", ",", "del2"}], "}"}], 
         ",", 
         RowBox[{
          RowBox[{"resultat", "=", 
           RowBox[{"x", "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"x", "/.", 
                RowBox[{"{", 
                 RowBox[{"al", "->", "bet2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"bet", "\[Rule]", "al"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"bet2", "\[Rule]", "bet"}], "}"}]}], ")"}], "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"x", "/.", 
                RowBox[{"{", 
                 RowBox[{"al", "\[Rule]", "gam2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"gam", "\[Rule]", "al"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"gam2", "\[Rule]", "gam"}], "}"}]}], ")"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"resultat", "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"resultat", "/.", 
                RowBox[{"{", 
                 RowBox[{"bet", "\[Rule]", "gam2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"gam", "\[Rule]", "bet"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"gam2", "\[Rule]", "gam"}], "}"}]}], ")"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"resultat", "/.", 
            RowBox[{"{", 
             RowBox[{"del", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{"al", "+", "bet", "+", "gam"}], ")"}]}], "}"}]}]}]}]}],
         "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"ASQ", ":", " ", 
     RowBox[{
      RowBox[{"symmetrizer", "--"}], "antisymmetrizer", " ", "of", " ", 
      "Q"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ASQ", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"resultat", ",", "bet2", ",", "gam2", ",", "del2"}], "}"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"resultat", "=", 
           RowBox[{"x", "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"x", "/.", 
                RowBox[{"{", 
                 RowBox[{"al", "->", "bet2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"bet", "\[Rule]", "al"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"bet2", "\[Rule]", "bet"}], "}"}]}], ")"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"resultat", "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"resultat", "/.", 
                RowBox[{"{", 
                 RowBox[{"gam", "\[Rule]", "del2"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"del", "\[Rule]", "gam"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{"del2", "\[Rule]", "del"}], "}"}]}], ")"}]}]}], ";", 
          RowBox[{"resultat", "=", 
           RowBox[{"resultat", "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"resultat", "/.", 
                    RowBox[{"{", 
                    RowBox[{"al", "\[Rule]", "gam2"}], "}"}]}], "/.", 
                   RowBox[{"{", 
                    RowBox[{"gam", "\[Rule]", "al"}], "}"}]}], "/.", 
                  RowBox[{"{", 
                   RowBox[{"gam2", "\[Rule]", "gam"}], "}"}]}], "/.", 
                 RowBox[{"{", 
                  RowBox[{"bet", "\[Rule]", "del2"}], "}"}]}], "/.", 
                RowBox[{"{", 
                 RowBox[{"del", "\[Rule]", "bet"}], "}"}]}], "/.", 
               RowBox[{"{", 
                RowBox[{"del2", "\[Rule]", "del"}], "}"}]}], "/.", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"cc", "[", "x_", "]"}], "\[Rule]", 
                 RowBox[{"Conjugate", "[", 
                  RowBox[{"cc", "[", "x", "]"}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"M", "[", 
                  RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", 
                 RowBox[{"Conjugate", "[", 
                  RowBox[{"M", "[", 
                   RowBox[{"x", ",", "y"}], "]"}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"R", "[", 
                  RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", 
                 RowBox[{"Conjugate", "[", 
                  RowBox[{"R", "[", 
                   RowBox[{"x", ",", "y"}], "]"}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"Q", "[", 
                  RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "\[Rule]", 
                 RowBox[{"Conjugate", "[", 
                  RowBox[{"Q", "[", 
                   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"P", "[", 
                  RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "\[Rule]", 
                 RowBox[{"Conjugate", "[", 
                  RowBox[{"P", "[", 
                   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}]}]}], 
               "}"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"resultat", "=", 
           RowBox[{"resultat", "/.", 
            RowBox[{"{", 
             RowBox[{"del", "\[Rule]", 
              RowBox[{"al", "+", "bet", "-", "gam"}]}], "}"}]}]}]}]}], 
        "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"symetrized", " ", "expressions", " ", "used", " ", "in", " ", 
     RowBox[{"\"\<symcuml\>\"", ".", " ", "Symmetry"}], " ", "properties", 
     " ", "follow", " ", "from", " ", "the", " ", "definitions", " ", 
     RowBox[{"Eqs", ".", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"34", "--"}], "36"}], ")"}], "."}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"for", " ", "the", " ", "triplets"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"M", "[", 
         RowBox[{"x", ",", "y"}], "]"}], "+", 
        RowBox[{"M", "[", 
         RowBox[{"x", ",", 
          RowBox[{"x", "-", "y"}]}], "]"}]}], ")"}], "/", "2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R6", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"R", "[", 
         RowBox[{"x", ",", "y"}], "]"}], "+", 
        RowBox[{"R", "[", 
         RowBox[{
          RowBox[{"-", "y"}], ",", 
          RowBox[{"-", "x"}]}], "]"}], "+", 
        RowBox[{"R", "[", 
         RowBox[{"x", ",", 
          RowBox[{"x", "-", "y"}]}], "]"}], "+", 
        RowBox[{"R", "[", 
         RowBox[{
          RowBox[{"y", "-", "x"}], ",", 
          RowBox[{"-", "x"}]}], "]"}], "+", 
        RowBox[{"R", "[", 
         RowBox[{
          RowBox[{"-", "y"}], ",", 
          RowBox[{"x", "-", "y"}]}], "]"}], "+", 
        RowBox[{"R", "[", 
         RowBox[{
          RowBox[{"y", "-", "x"}], ",", "y"}], "]"}]}], ")"}], "/", "6"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"for", " ", "the", " ", "quadruplets"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q4", "=", 
     RowBox[{
      RowBox[{"Q", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], "+", 
      RowBox[{"Q", "[", 
       RowBox[{"y", ",", "x", ",", "z"}], "]"}], "+", 
      RowBox[{"Q", "[", 
       RowBox[{"x", ",", "y", ",", 
        RowBox[{"x", "+", "y", "-", "z"}]}], "]"}], "+", 
      RowBox[{"Q", "[", 
       RowBox[{"y", ",", "x", ",", 
        RowBox[{"x", "+", "y", "-", "z"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"perm6", "=", 
     RowBox[{"Permutations", "[", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"perm24", "=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{"#", ",", "3"}], "]"}], "&"}], ",", 
       RowBox[{"Permutations", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z", ",", 
          RowBox[{
           RowBox[{"-", "x"}], "-", "y", "-", "z"}]}], "}"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"P6", "=", 
     RowBox[{
      RowBox[{"Total", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Apply", "[", 
          RowBox[{"P", ",", 
           RowBox[{"perm6", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "perm6", "]"}]}], "}"}]}], "]"}], "]"}], 
      "/", "6"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T24", "=", 
     RowBox[{
      RowBox[{"Total", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Apply", "[", 
          RowBox[{"T", ",", 
           RowBox[{"perm24", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Length", "[", "perm24", "]"}]}], "}"}]}], "]"}], "]"}], 
      "/", "24"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"symcuml", ":", " ", 
     RowBox[{
     "a", " ", "list", " ", "of", " ", "rules", " ", "to", " ", "symetrize", 
      " ", "the", " ", "writing", " ", "of", " ", "the", " ", "cumulants", 
      " ", "and", " ", "allow", " ", "for", " ", "identification", " ", 
      "with", " ", "the", " ", "analytic", " ", "expressions"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"symcuml", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"V", "[", "x_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"V", "[", "x", "]"}], "+", 
           RowBox[{"V", "[", 
            RowBox[{"-", "x"}], "]"}]}], ")"}], "/", "2"}]}], ",", 
       RowBox[{
        RowBox[{"cc", "[", "x_", "]"}], "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"cc", "[", "x", "]"}], "+", 
           RowBox[{"cc", "[", 
            RowBox[{"-", "x"}], "]"}]}], ")"}], "/", "2"}]}], ",", 
       RowBox[{
        RowBox[{"M", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "M2"}], ",", 
       RowBox[{
        RowBox[{"R", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "R6"}], ",", 
       RowBox[{
        RowBox[{"Q", "[", 
         RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "\[Rule]", "Q4"}], ",", 
       
       RowBox[{
        RowBox[{"P", "[", 
         RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "\[Rule]", "P6"}], ",", 
       
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "\[Rule]", "T24"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"AvecVk", ":", " ", 
      RowBox[{"in", " ", "a", " ", "sum"}]}], ",", " ", 
     RowBox[{
     "select", " ", "the", " ", "terms", " ", "containing", " ", "a", " ", 
      "factor", " ", 
      RowBox[{"V", "[", "k3", "]"}], " ", "or", " ", 
      RowBox[{
       RowBox[{"V", "[", 
        RowBox[{"-", "k3"}], "]"}], ".", " ", "Useful"}], " ", "to", " ", 
      "check", " ", "F6Qq"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"AvecVk", "=", 
     RowBox[{"Function", "[", 
      RowBox[{"somme", ",", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ListeAvecVk", ",", "liste"}], "}"}], ",", 
         RowBox[{
          RowBox[{"liste", "=", 
           RowBox[{"List", "@@", "somme"}]}], ";", 
          RowBox[{"ListeAvecVk", "=", 
           RowBox[{"Union", "[", 
            RowBox[{
             RowBox[{"Select", "[", 
              RowBox[{"liste", ",", 
               RowBox[{
                RowBox[{"MatchQ", "[", 
                 RowBox[{"#", ",", 
                  RowBox[{"x___", "*", 
                   RowBox[{"V", "[", "k3", "]"}], "*", "y___"}]}], "]"}], 
                "&"}]}], "]"}], ",", 
             RowBox[{"Select", "[", 
              RowBox[{"liste", ",", 
               RowBox[{
                RowBox[{"MatchQ", "[", 
                 RowBox[{"#", ",", 
                  RowBox[{"x___", "*", " ", 
                   RowBox[{"V", "[", 
                    RowBox[{"-", "k3"}], "]"}], "*", "y___"}]}], "]"}], 
                "&"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Total", "[", "ListeAvecVk", "]"}]}]}], "]"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.787898709261639*^9, 3.787898709525296*^9}, {
   3.7879015101375*^9, 3.7879015104753647`*^9}, {3.787917032660205*^9, 
   3.787917039185116*^9}, {3.788000227287147*^9, 3.788000307085848*^9}, {
   3.788000345948456*^9, 3.788000389299831*^9}, {3.788000430496389*^9, 
   3.788000688249632*^9}, {3.788000741455085*^9, 3.788000844467821*^9}, {
   3.788000882323617*^9, 3.788001168457505*^9}, {3.7880012113079157`*^9, 
   3.788001350300448*^9}, {3.788001445920702*^9, 3.7880017158008003`*^9}, {
   3.788001824980088*^9, 3.7880018337556*^9}, {3.788001972294703*^9, 
   3.788001972693306*^9}, {3.788002458909724*^9, 3.7880024601078243`*^9}, 
   3.788002626866983*^9, {3.7880026810083933`*^9, 3.788002770616284*^9}, {
   3.7880035293205147`*^9, 3.788003740347001*^9}, {3.7880037946475763`*^9, 
   3.788003887168364*^9}, {3.788004144797419*^9, 3.788004212346525*^9}, {
   3.7880043215339537`*^9, 3.788004661706567*^9}, {3.7880047852577267`*^9, 
   3.788004969655696*^9}, {3.788005010155974*^9, 3.7880050177074747`*^9}, {
   3.788009613615065*^9, 3.788009738518977*^9}, {3.788009831234091*^9, 
   3.788009862255926*^9}, {3.7880099190739326`*^9, 3.788009942610574*^9}, {
   3.7880102292217712`*^9, 3.7880103775270243`*^9}, {3.7880194900354633`*^9, 
   3.788019505933926*^9}, {3.788019727275038*^9, 3.788019733369969*^9}, {
   3.7880197727544613`*^9, 3.7880197746804953`*^9}, {3.788019857014124*^9, 
   3.788019861595377*^9}, 3.78802030901795*^9, {3.7880204915848293`*^9, 
   3.788020507759829*^9}, {3.788020814090489*^9, 3.788020819457255*^9}, {
   3.788021069946314*^9, 3.788021075576432*^9}, {3.78802121233057*^9, 
   3.788021381615285*^9}, {3.7880214322491627`*^9, 3.7880214562452173`*^9}, {
   3.78802153644685*^9, 3.7880215423877983`*^9}, {3.788072915479047*^9, 
   3.788072917853209*^9}, {3.7880732095964813`*^9, 3.7880733970413637`*^9}, {
   3.7880735625862083`*^9, 3.788073582481392*^9}, {3.7880741550656977`*^9, 
   3.7880741802806787`*^9}, {3.788074521846854*^9, 3.788074522093272*^9}, {
   3.78807463623199*^9, 3.7880746488320827`*^9}, {3.7880747594164743`*^9, 
   3.788074790375979*^9}, {3.7880749010181847`*^9, 3.7880749306989717`*^9}, {
   3.788080770220997*^9, 3.7880808690273457`*^9}, {3.788091645825059*^9, 
   3.788091697166396*^9}, {3.788091928013599*^9, 3.7880922576020107`*^9}, {
   3.788092297193487*^9, 3.78809230988446*^9}, {3.788092459464239*^9, 
   3.788092469307002*^9}, {3.788092766179875*^9, 3.7880927686215277`*^9}, {
   3.78809281863833*^9, 3.78809284110984*^9}, {3.788093037807428*^9, 
   3.7880930767232323`*^9}, {3.788093460905321*^9, 3.788093461684373*^9}, {
   3.7880937457153883`*^9, 3.788093771961583*^9}, {3.788093839843809*^9, 
   3.788093842514187*^9}, {3.788093932713278*^9, 3.788093940538534*^9}, {
   3.788094056624226*^9, 3.788094138033321*^9}, {3.788169714938859*^9, 
   3.788169732272923*^9}, {3.788169771991185*^9, 3.788169792395895*^9}, {
   3.7881698644482803`*^9, 3.788169926665801*^9}, {3.788170348695496*^9, 
   3.788170425580867*^9}, {3.788170512529634*^9, 3.7881705594523973`*^9}, {
   3.788170598363275*^9, 3.78817060689501*^9}, {3.788171006035623*^9, 
   3.788171006463504*^9}, {3.7881787049228697`*^9, 3.78817874734181*^9}, {
   3.788179266264574*^9, 3.788179329821402*^9}, {3.788179370063479*^9, 
   3.788179403234064*^9}, {3.788179831028871*^9, 3.78817994696358*^9}, {
   3.788180012168991*^9, 3.7881800611571293`*^9}, {3.788180259705619*^9, 
   3.788180289203113*^9}, {3.788180546264776*^9, 3.7881806205854397`*^9}, {
   3.788180894828566*^9, 3.788180895981031*^9}, {3.788183338822546*^9, 
   3.788183361045223*^9}, {3.788694665997158*^9, 3.78869466743927*^9}, {
   3.788773701656323*^9, 3.788773705023617*^9}, 3.799766541261242*^9, {
   3.799766574593824*^9, 3.799766626623551*^9}, 3.799767022135421*^9, 
   3.802683690788785*^9, {3.802684587653693*^9, 3.802684631809371*^9}, {
   3.803026255152534*^9, 3.803026328017227*^9}, {3.803027576011608*^9, 
   3.803027582460965*^9}, {3.803027790233398*^9, 3.8030277981295767`*^9}, {
   3.803027854931498*^9, 3.803027966208683*^9}, {3.80303436893594*^9, 
   3.803034369408967*^9}, {3.803034545774438*^9, 3.8030345782784643`*^9}, {
   3.803805547864091*^9, 3.8038055706558332`*^9}, {3.803805602446329*^9, 
   3.803805619485161*^9}, {3.803805659777508*^9, 3.8038058155332747`*^9}, {
   3.8038315512590103`*^9, 3.803832091169407*^9}, {3.8038321451316347`*^9, 
   3.803832293728548*^9}, {3.803832345447916*^9, 3.803832387978359*^9}, {
   3.8038324218379498`*^9, 3.803832523624304*^9}, {3.803832606096936*^9, 
   3.803832727161386*^9}, {3.8038327605480003`*^9, 3.80383329235911*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"260f6019-eef6-4af8-a44b-8bcd440b9d3d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Verification", " ", "of", " ", "the", " ", "triplet", " ", "equations", 
    " ", "of", " ", "motion", " ", 
    RowBox[{"Eqs", ".", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"46", "--"}], "50"}], ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Definition", " ", "of", " ", "the", " ", "triplet", " ", "operators"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"opM", "=", 
     RowBox[{"nc", "[", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"CR", ",", "al"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"CR", ",", "bet"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"AN", ",", "gam"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"opR", "=", 
     RowBox[{"nc", "[", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"AN", ",", "gam"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"AN", ",", "bet"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"AN", ",", "al"}], "]"}]}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7881794240769367`*^9, 3.7881794826921167`*^9}, {
  3.799767430903161*^9, 3.799767457345849*^9}, {3.803018225355616*^9, 
  3.803018234438871*^9}, {3.8038333144113092`*^9, 3.8038333804929533`*^9}, {
  3.803876463017846*^9, 3.803876466697913*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"4b8d994c-7c6f-49ec-b6ea-172c18562180"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"MH3", " ", 
    RowBox[{"(", 
     RowBox[{"Eq", ".", " ", 
      RowBox[{"(", "46", ")"}]}], ")"}], " ", "and", " ", "RH3", " ", 
    RowBox[{"(", 
     RowBox[{"Eq", ".", " ", 
      RowBox[{"(", "47", ")"}]}], ")"}], " ", "doublet", " ", "part"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MH3", "=", 
     RowBox[{"commH3", "[", "opM", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RH3", "=", 
     RowBox[{"commH3", "[", "opR", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Md", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"MH3", ",", "doublets", ",", 
       RowBox[{"gam", "->", 
        RowBox[{"al", "+", "bet"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Rd", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"RH3", ",", "doublets", ",", 
       RowBox[{"gam", "\[Rule]", 
        RowBox[{
         RowBox[{"-", "al"}], "-", "bet"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Analytical", " ", "formulas", " ", "from", " ", 
     RowBox[{"Eqs", ".", " ", 
      RowBox[{"(", 
       RowBox[{"46", "-", "47"}], ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Mdanaly", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"V", "[", "al", "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"nn", "[", "al", "]"}], 
          RowBox[{"nn", "[", "bet", "]"}]}], "-", 
         RowBox[{
          RowBox[{"nn", "[", "gam", "]"}], 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"nn", "[", "al", "]"}], "+", 
            RowBox[{"nn", "[", "bet", "]"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"V", "[", "bet", "]"}], "+", 
         RowBox[{"V", "[", "gam", "]"}]}], ")"}], 
       RowBox[{"cc", "[", "gam", "]"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"cc", "[", "al", "]"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"V", "[", "gam", "]"}], "+", 
         RowBox[{"V", "[", "al", "]"}]}], ")"}], 
       RowBox[{"nn", "[", "gam", "]"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"cc", "[", "al", "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"V", "[", "bet", "]"}], "+", 
         RowBox[{"V", "[", "gam", "]"}]}], ")"}], 
       RowBox[{"nn", "[", "al", "]"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"cc", "[", "bet", "]"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Rdanaly", "=", 
     RowBox[{
      RowBox[{"V", "[", "bet", "]"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"cc", "[", "bet", "]"}], 
         RowBox[{"cc", "[", "gam", "]"}]}], "+", 
        RowBox[{
         RowBox[{"cc", "[", "al", "]"}], 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"nn", "[", "bet", "]"}], "+", 
           RowBox[{"nn", "[", "gam", "]"}]}], ")"}]}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Symmtrize", " ", "the", " ", "analytic", " ", "formulas"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Mdanaly", "=", 
     RowBox[{"SM", "[", "F4Mdanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Rdanaly", "=", 
     RowBox[{"SR", "[", "F4Rdanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"difference", "=", 
     RowBox[{"zero", "?"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"zero", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Expand", "[", "F4Rdanaly", "]"}], "-", 
         RowBox[{"Expand", "[", "F4Rd", "]"}]}], ")"}], "/.", 
       RowBox[{"{", 
        RowBox[{"gam", "\[Rule]", 
         RowBox[{
          RowBox[{"-", "al"}], "-", "bet"}]}], "}"}]}], "/.", "symcuml"}], "//",
      "Simplify"}]}], "\[IndentingNewLine]", 
   RowBox[{"zero", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Expand", "[", "F4Mdanaly", "]"}], "-", 
         RowBox[{"Expand", "[", "F4Md", "]"}]}], ")"}], "/.", 
       RowBox[{"{", 
        RowBox[{"gam", "\[Rule]", 
         RowBox[{"al", "+", "bet"}]}], "}"}]}], "/.", "symcuml"}], "//", 
     "Simplify"}]}]}]}]], "Input",
 CellChangeTimes->{{3.788179497139592*^9, 3.788179521635064*^9}, {
   3.7881795636986637`*^9, 3.788179568124401*^9}, {3.788180451249769*^9, 
   3.788180453743709*^9}, {3.788180642749053*^9, 3.788180658620812*^9}, {
   3.788180735952525*^9, 3.788180743133404*^9}, {3.788180925880394*^9, 
   3.788180980345792*^9}, {3.7881810523375263`*^9, 3.788181055897591*^9}, {
   3.788181125563596*^9, 3.78818113719995*^9}, {3.7881815952243767`*^9, 
   3.788181595763754*^9}, {3.8030261398596163`*^9, 3.803026140088192*^9}, 
   3.803805573507214*^9, {3.8038323896872997`*^9, 3.803832391190987*^9}, {
   3.8038324231008463`*^9, 3.803832424171342*^9}, {3.8038333859619217`*^9, 
   3.803833476036233*^9}, {3.8038765834863853`*^9, 3.803876601877993*^9}, {
   3.8038768724867067`*^9, 3.803876873978692*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"b313dde3-be78-4212-b692-cedcfb24ea8b"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.803026141123283*^9, {3.803033933281274*^9, 3.8030339587593184`*^9}, 
   3.803035090216411*^9, 3.80387762829226*^9},
 CellLabel->"Out[92]=",ExpressionUUID->"53cabef2-758e-4f61-91bf-562c267f7a5f"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.803026141123283*^9, {3.803033933281274*^9, 3.8030339587593184`*^9}, 
   3.803035090216411*^9, 3.8038776283760023`*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"b4a9ed7e-a05b-48f3-9371-070de6e69be6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"MH3", " ", 
    RowBox[{"(", 
     RowBox[{"Eq", ".", " ", 
      RowBox[{"(", "46", ")"}]}], ")"}], " ", "and", " ", "RH3", " ", 
    RowBox[{"(", 
     RowBox[{"Eq", ".", " ", 
      RowBox[{"(", "47", ")"}]}], ")"}], " ", "quadruplet", " ", "part"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"F4Mq", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"MH3", ",", "quadruplets", ",", 
       RowBox[{"gam", "->", 
        RowBox[{"al", "+", "bet"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Rq", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"RH3", ",", "quadruplets", ",", 
       RowBox[{"gam", "\[Rule]", 
        RowBox[{
         RowBox[{"-", "al"}], "-", "bet"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Mq", "=", 
     RowBox[{
      RowBox[{"F4Mq", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k2", "\[Rule]", "k3"}], ",", 
         RowBox[{"k1", "\[Rule]", "k3"}]}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sum", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "x"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Rq", "=", 
     RowBox[{
      RowBox[{"F4Rq", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k2", "\[Rule]", "k3"}], ",", 
         RowBox[{"k1", "\[Rule]", "k3"}]}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sum", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "x"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Symmtrize", " ", "the", " ", "dummy", " ", "variable", " ", "k3"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Mq", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F4Mq", "+", 
        RowBox[{"(", 
         RowBox[{"F4Mq", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Rq", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F4Rq", "+", 
        RowBox[{"(", 
         RowBox[{"F4Rq", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Analytical", " ", "formulas", " ", "from", " ", 
      RowBox[{"Eqs", ".", " ", 
       RowBox[{"(", 
        RowBox[{"46", "-", "47"}], ")"}]}]}], ",", " ", 
     RowBox[{
     "after", " ", "a", " ", "few", " ", "well", " ", "chosen", " ", 
      "changes", " ", "of", " ", "variable", " ", "on", " ", "k3", " ", 
      RowBox[{"(", 
       RowBox[{"\"\<q\>\"", " ", "in", " ", 
        RowBox[{"(", 
         RowBox[{"46", "-", "47"}], ")"}]}], ")"}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Mqanaly", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"V", "[", "bet", "]"}], "+", 
          RowBox[{"V", "[", "k3", "]"}]}], ")"}]}], 
       RowBox[{"Q", "[", 
        RowBox[{"gam", ",", "k3", ",", "al"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"V", "[", "gam", "]"}], "+", 
         RowBox[{"V", "[", "k3", "]"}]}], ")"}], 
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"P", "[", 
          RowBox[{"al", ",", "bet", ",", "k3"}], "]"}], "]"}], "/", "2"}]}], 
      "-", 
      RowBox[{
       RowBox[{"V", "[", 
        RowBox[{"k3", "+", "bet"}], "]"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"P", "[", 
         RowBox[{"al", ",", 
          RowBox[{"k3", "+", "bet"}], ",", 
          RowBox[{"-", "k3"}]}], "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"V", "[", 
        RowBox[{"k3", "+", "al", "+", "bet"}], "]"}], 
       RowBox[{
        RowBox[{"Q", "[", 
         RowBox[{
          RowBox[{"-", "k3"}], ",", 
          RowBox[{"k3", "+", "al", "+", "bet"}], ",", "al"}], "]"}], "/", 
        "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Rqanaly", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"V", "[", "al", "]"}], "+", 
         RowBox[{"V", "[", "k3", "]"}]}], ")"}], 
       RowBox[{
        RowBox[{"P", "[", 
         RowBox[{
          RowBox[{"al", "+", "k3"}], ",", "bet", ",", "gam"}], "]"}], "/", 
        "2"}]}], "+", 
      RowBox[{
       RowBox[{"V", "[", 
        RowBox[{"k3", "+", "al"}], "]"}], 
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"bet", ",", "gam", ",", 
          RowBox[{"k3", "+", "al"}]}], "]"}], "/", "2"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Symmtrize", " ", "the", " ", "analytic", " ", "formulas"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Mqanaly", "=", 
     RowBox[{"SM", "[", "F4Mqanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Rqanaly", "=", 
     RowBox[{"SR", "[", "F4Rqanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Symmtrize", " ", "the", " ", "dummy", " ", "variable", " ", "k3"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Mqanaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F4Mqanaly", "+", 
        RowBox[{"(", 
         RowBox[{"F4Mqanaly", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F4Rqanaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F4Rqanaly", "+", 
        RowBox[{"(", 
         RowBox[{"F4Rqanaly", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"difference", "=", 
     RowBox[{"zero", "?"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"zero", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"F4Rqanaly", "-", "F4Rq"}], ")"}], "/.", 
       RowBox[{"{", 
        RowBox[{"gam", "\[Rule]", 
         RowBox[{
          RowBox[{"-", "al"}], "-", "bet"}]}], "}"}]}], "/.", "symcuml"}], "//",
      "Simplify"}]}], "\[IndentingNewLine]", 
   RowBox[{"zero", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"F4Mqanaly", "-", "F4Mq"}], ")"}], "/.", 
       RowBox[{"{", 
        RowBox[{"gam", "\[Rule]", 
         RowBox[{"al", "+", "bet"}]}], "}"}]}], "/.", "symcuml"}], "//", 
     "Simplify"}]}]}]}]], "Input",
 CellChangeTimes->{{3.803026129198687*^9, 3.803026129438265*^9}, 
   3.8038055743274612`*^9, {3.803833485987945*^9, 3.80383360298286*^9}, {
   3.8038336827872047`*^9, 3.8038337266465693`*^9}, 3.803876270893537*^9, {
   3.803876581046461*^9, 3.803876599481081*^9}, {3.8038768617068644`*^9, 
   3.8038768665313873`*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"fce26a9b-e0f5-44fd-9606-6a58b25e7c4f"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.803026129840307*^9, {3.80303395094494*^9, 3.803033961024314*^9}, 
   3.803035091865802*^9, 3.803877630469626*^9},
 CellLabel->
  "Out[106]=",ExpressionUUID->"4614b1fc-7055-43a6-a8d1-2bc1bdfea56d"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.803026129840307*^9, {3.80303395094494*^9, 3.803033961024314*^9}, 
   3.803035091865802*^9, 3.803877630490568*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"fe97ec51-7e78-4473-acb1-68ee2e377e36"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"MH4", " ", 
    RowBox[{"(", 
     RowBox[{"Eq", ".", " ", 
      RowBox[{"(", "48", ")"}]}], ")"}], " ", "and", " ", "RH4", " ", 
    RowBox[{"(", 
     RowBox[{"Eq", ".", " ", 
      RowBox[{"(", "49", ")"}]}], ")"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MH4", "=", 
     RowBox[{"commH4", "[", "opM", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RH4", "=", 
     RowBox[{"commH4", "[", "opR", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5M", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"MH4", ",", "toutes", ",", 
       RowBox[{"gam", "->", 
        RowBox[{"al", "+", "bet"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5R", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"RH4", ",", "toutes", ",", 
       RowBox[{"gam", "\[Rule]", 
        RowBox[{
         RowBox[{"-", "al"}], "-", "bet"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5M", "=", 
     RowBox[{
      RowBox[{"F5M", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k2", "\[Rule]", "k3"}], ",", 
         RowBox[{"k1", "\[Rule]", "k3"}]}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sum", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "x"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5R", "=", 
     RowBox[{
      RowBox[{"F5R", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k2", "\[Rule]", "k3"}], ",", 
         RowBox[{"k1", "\[Rule]", "k3"}]}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sum", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "x"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5M", "=", 
     RowBox[{"F5M", "/", "2"}]}], ";"}], 
   RowBox[{"(*", 
    RowBox[{"put", " ", "back", " ", "the", " ", "factor", " ", 
     RowBox[{"1", "/", "2"}], " ", "of", " ", "H4"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5R", "=", 
     RowBox[{"F5R", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Remove", " ", "the", " ", "reducible", " ", "part", " ", "from", " ", 
     "the", " ", "commutator", " ", "with", " ", "H_", 
     RowBox[{"2", "^", "HFB"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5M", "=", 
     RowBox[{"F5M", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"nn", "[", 
          RowBox[{"x_", "+", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"nn", "[", 
          RowBox[{"x_", "-", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"cc", "[", 
          RowBox[{"x_", "+", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"cc", "[", 
          RowBox[{"x_", "-", "k3"}], "]"}], "\[Rule]", "0"}]}], "}"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5R", "=", 
     RowBox[{"F5R", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"nn", "[", 
          RowBox[{"x_", "+", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"nn", "[", 
          RowBox[{"x_", "-", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"cc", "[", 
          RowBox[{"x_", "+", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"cc", "[", 
          RowBox[{"x_", "-", "k3"}], "]"}], "\[Rule]", "0"}]}], "}"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5M", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F5M", "+", 
        RowBox[{"(", 
         RowBox[{"F5M", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5R", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F5R", "+", 
        RowBox[{"(", 
         RowBox[{"F5R", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Analytical", " ", "formulas", " ", "from", " ", 
      RowBox[{"Eqs", ".", " ", 
       RowBox[{"(", 
        RowBox[{"48", "-", "49"}], ")"}]}]}], ",", " ", 
     RowBox[{
     "after", " ", "a", " ", "few", " ", "well", " ", "chosen", " ", 
      "changes", " ", "of", " ", "variable", " ", "on", " ", "k3", " ", 
      RowBox[{"(", 
       RowBox[{"\"\<q\>\"", " ", "in", " ", 
        RowBox[{"(", 
         RowBox[{"48", "-", "49"}], ")"}]}], ")"}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Manaly", "=", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"nn", "[", "al", "]"}], "+", 
           RowBox[{"nn", "[", "bet", "]"}]}], ")"}], 
         RowBox[{
          RowBox[{"M", "[", 
           RowBox[{"gam", ",", 
            RowBox[{"al", "-", "k3"}]}], "]"}], "/", "2"}]}], "+", 
        RowBox[{
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"nn", "[", "gam", "]"}], "-", 
           RowBox[{"nn", "[", "bet", "]"}]}], ")"}], 
         RowBox[{"M", "[", 
          RowBox[{
           RowBox[{"gam", "-", "k3"}], ",", "al"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"V", "[", "al", "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"nn", "[", "gam", "]"}], "-", 
           RowBox[{"nn", "[", "bet", "]"}]}], ")"}], 
         RowBox[{"M", "[", 
          RowBox[{"k3", ",", "al"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"V", "[", "gam", "]"}], 
         RowBox[{"Conjugate", "[", 
          RowBox[{"cc", "[", "bet", "]"}], "]"}], 
         RowBox[{"Conjugate", "[", 
          RowBox[{"M", "[", 
           RowBox[{
            RowBox[{"gam", "+", "k3"}], ",", "gam"}], "]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"Conjugate", "[", 
          RowBox[{"cc", "[", "bet", "]"}], "]"}], 
         RowBox[{"Conjugate", "[", 
          RowBox[{"M", "[", 
           RowBox[{
            RowBox[{"al", "+", "k3"}], ",", "gam"}], "]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"cc", "[", "gam", "]"}], 
         RowBox[{"Conjugate", "[", 
          RowBox[{"R", "[", 
           RowBox[{"bet", ",", 
            RowBox[{"k3", "-", "al"}]}], "]"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"Conjugate", "[", 
          RowBox[{"cc", "[", "bet", "]"}], "]"}], 
         RowBox[{"Conjugate", "[", 
          RowBox[{"M", "[", 
           RowBox[{"al", ",", 
            RowBox[{"k3", "-", "bet"}]}], "]"}], "]"}]}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Ranaly", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"V", "[", "k3", "]"}], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"nn", "[", "al", "]"}], "+", 
         RowBox[{"nn", "[", "bet", "]"}]}], ")"}], 
       RowBox[{
        RowBox[{"R", "[", 
         RowBox[{
          RowBox[{"al", "-", "k3"}], ",", 
          RowBox[{"-", "gam"}]}], "]"}], "/", "2"}]}], "+", 
      RowBox[{
       RowBox[{"V", "[", "al", "]"}], 
       RowBox[{"cc", "[", "bet", "]"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{
          RowBox[{"al", "+", "k3"}], ",", "al"}], "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"V", "[", "k3", "]"}], 
       RowBox[{"cc", "[", "bet", "]"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{
          RowBox[{"gam", "+", "al", "+", "k3"}], ",", "al"}], "]"}], 
        "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Symmtrize", " ", "the", " ", "analytic", " ", "formulas"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Manaly", "=", 
     RowBox[{"SM", "[", "F5Manaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Ranaly", "=", 
     RowBox[{"SR", "[", "F5Ranaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Symmtrize", " ", "the", " ", "dummy", " ", "variable", " ", "k3"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Manaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F5Manaly", "+", 
        RowBox[{"(", 
         RowBox[{"F5Manaly", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Ranaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F5Ranaly", "+", 
        RowBox[{"(", 
         RowBox[{"F5Ranaly", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"difference", "=", 
     RowBox[{"zero", "?"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"zero", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"F5Manaly", "-", "F5M"}], ")"}], "/.", 
       RowBox[{"{", 
        RowBox[{"gam", "\[Rule]", 
         RowBox[{"al", "+", "bet"}]}], "}"}]}], "/.", "symcuml"}], "//", 
     "FullSimplify"}]}], "\[IndentingNewLine]", 
   RowBox[{"zero", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"F5Ranaly", "-", "F5R"}], ")"}], "/.", 
       RowBox[{"{", 
        RowBox[{"gam", "\[Rule]", 
         RowBox[{
          RowBox[{"-", "al"}], "-", "bet"}]}], "}"}]}], "/.", "symcuml"}], "//",
      "FullSimplify"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7881825251053743`*^9, 3.788182561526648*^9}, {
   3.788182643771339*^9, 3.788182654317081*^9}, {3.7881826844085827`*^9, 
   3.788182739017131*^9}, {3.788183454838481*^9, 3.7881834633868723`*^9}, {
   3.8030261669459057`*^9, 3.803026172898591*^9}, {3.803026350039167*^9, 
   3.803026432845689*^9}, {3.803026483936602*^9, 3.8030264851499653`*^9}, {
   3.8030270835719*^9, 3.803027134432374*^9}, {3.8030272476014633`*^9, 
   3.803027329985607*^9}, {3.803027373751989*^9, 3.803027438974945*^9}, {
   3.803028731970024*^9, 3.803028736978264*^9}, 3.80302958960568*^9, {
   3.803029646836122*^9, 3.803029647736561*^9}, {3.803029765981246*^9, 
   3.8030297842264957`*^9}, {3.803029853060508*^9, 3.803029857229752*^9}, {
   3.803029895989225*^9, 3.803029904001813*^9}, {3.803029957347208*^9, 
   3.8030299850094423`*^9}, {3.80303067906717*^9, 3.8030306912618237`*^9}, {
   3.8030339712759733`*^9, 3.8030339715989723`*^9}, 3.8038055749593678`*^9, {
   3.8038323913669987`*^9, 3.803832393472983*^9}, {3.803832424358333*^9, 
   3.803832425947462*^9}, {3.803833787462801*^9, 3.803833843683107*^9}, {
   3.803876241816842*^9, 3.8038762833592443`*^9}, {3.803876566300893*^9, 
   3.80387659684485*^9}, {3.803876855386162*^9, 3.80387685738234*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"c023a308-9d79-4f41-beb7-9b88a04105e4"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.8030339728862743`*^9, 3.803035094377948*^9, 
  3.803877633415039*^9},
 CellLabel->
  "Out[126]=",ExpressionUUID->"656515d8-cd6b-4f09-b276-ced1bd2acbd4"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.8030339728862743`*^9, 3.803035094377948*^9, 
  3.803877633503323*^9},
 CellLabel->
  "Out[127]=",ExpressionUUID->"2355083f-1569-480e-b64e-a125f32c6d75"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Verification", " ", "of", " ", "the", " ", "quadruplets", " ", 
    "equations", " ", "of", " ", "motion", " ", 
    RowBox[{"Eqs", ".", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"124", "--"}], "135"}], ")"}]}], " ", "in", " ", "Appendix", 
    " ", "C", ".1"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Definition", " ", "of", " ", "the", " ", "quadruplet", " ", "operators"}],
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"opP", "=", 
     RowBox[{"nc", "[", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"0", ",", "del"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"1", ",", "gam"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"1", ",", "bet"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"1", ",", "al"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"opQ", "=", 
     RowBox[{"nc", "[", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"0", ",", "del"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"0", ",", "gam"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"1", ",", "bet"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"1", ",", "al"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"opT", "=", 
     RowBox[{"nc", "[", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"1", ",", "del"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"1", ",", "gam"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"1", ",", "bet"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"1", ",", "al"}], "]"}]}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.788178788181437*^9, 3.788178794611004*^9}, {
  3.803876337539349*^9, 3.803876382598425*^9}, {3.8038764527352247`*^9, 
  3.803876470405925*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"56325dfd-cd22-4600-824e-bdf483b76439"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"PH3", ",", " ", 
    RowBox[{"QH3", " ", "and", " ", "TH3"}]}], "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{"PH3", "=", 
     RowBox[{"commH3", "[", "opP", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QH3", "=", 
     RowBox[{"commH3", "[", "opQ", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TH3", "=", 
     RowBox[{"commH3", "[", "opT", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5P", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"PH3", ",", "toutes", ",", 
       RowBox[{"del", "->", 
        RowBox[{"al", "+", "bet", "+", "gam"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Q", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"QH3", ",", "toutes", ",", 
       RowBox[{"del", "->", 
        RowBox[{"al", "+", "bet", "-", "gam"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5T", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"TH3", ",", "toutes", ",", 
       RowBox[{"del", "->", 
        RowBox[{
         RowBox[{"-", "al"}], "-", "bet", "-", "gam"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Q", "=", 
     RowBox[{"F5Q", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"KroneckerDelta", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "0"}], "}"}]}]}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
    "Removing", " ", "the", " ", "connected", " ", "part", " ", "of", " ", 
     "Q"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Analytic", " ", "formula", " ", "from", " ", 
     RowBox[{"Eqs", ".", " ", 
      RowBox[{"(", 
       RowBox[{"124", "-", "125", "-", "126"}], ")"}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Panaly", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"V", "[", "bet", "]"}], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"nn", "[", "bet", "]"}], "+", 
         RowBox[{"nn", "[", "gam", "]"}]}], ")"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{"del", ",", "al"}], "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"V", "[", "al", "]"}], "+", 
         RowBox[{"V", "[", 
          RowBox[{"al", "-", "del"}], "]"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"nn", "[", "del", "]"}], "-", 
         RowBox[{"nn", "[", "al", "]"}]}], ")"}], 
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"M", "[", 
          RowBox[{
           RowBox[{"bet", "+", "gam"}], ",", "bet"}], "]"}], "]"}], "/", 
        "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"V", "[", "del", "]"}], "+", 
         RowBox[{"V", "[", 
          RowBox[{"al", "-", "del"}], "]"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"nn", "[", "del", "]"}], "-", 
         RowBox[{"nn", "[", "al", "]"}]}], ")"}], 
       RowBox[{
        RowBox[{"R", "[", 
         RowBox[{"bet", ",", 
          RowBox[{"-", "gam"}]}], "]"}], "/", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"V", "[", "del", "]"}], "+", 
         RowBox[{"V", "[", "al", "]"}]}], ")"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Conjugate", "[", 
            RowBox[{"cc", "[", "del", "]"}], "]"}], 
           RowBox[{"R", "[", 
            RowBox[{"bet", ",", 
             RowBox[{"-", "gam"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"cc", "[", "al", "]"}], 
           RowBox[{"Conjugate", "[", 
            RowBox[{"M", "[", 
             RowBox[{
              RowBox[{"bet", "+", "gam"}], ",", "bet"}], "]"}], "]"}]}]}], 
         ")"}], "/", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"V", "[", "al", "]"}], "+", 
         RowBox[{"V", "[", 
          RowBox[{"al", "+", "bet"}], "]"}]}], ")"}], 
       RowBox[{"cc", "[", "al", "]"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{"del", ",", "gam"}], "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"V", "[", "bet", "]"}], "+", 
         RowBox[{"V", "[", 
          RowBox[{"al", "+", "bet"}], "]"}]}], ")"}], 
       RowBox[{"cc", "[", "al", "]"}], 
       RowBox[{"M", "[", 
        RowBox[{"gam", ",", "del"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Qanaly", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"V", "[", "al", "]"}], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"nn", "[", "al", "]"}], "+", 
         RowBox[{"nn", "[", "bet", "]"}]}], ")"}], 
       RowBox[{
        RowBox[{"M", "[", 
         RowBox[{
          RowBox[{"gam", "+", "del"}], ",", "gam"}], "]"}], "/", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"V", "[", "al", "]"}], "+", 
         RowBox[{"V", "[", 
          RowBox[{"al", "+", "bet"}], "]"}]}], ")"}], 
       RowBox[{"cc", "[", "al", "]"}], 
       RowBox[{
        RowBox[{"M", "[", 
         RowBox[{
          RowBox[{"gam", "+", "del"}], ",", "gam"}], "]"}], "/", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"V", "[", "bet", "]"}], "+", 
         RowBox[{"V", "[", 
          RowBox[{"al", "+", "bet"}], "]"}]}], ")"}], 
       RowBox[{"cc", "[", "al", "]"}], 
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"R", "[", 
          RowBox[{"gam", ",", 
           RowBox[{"-", "del"}]}], "]"}], "]"}], "/", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"V", "[", "gam", "]"}], "+", 
            RowBox[{"V", "[", 
             RowBox[{"al", "-", "gam"}], "]"}]}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"nn", "[", "gam", "]"}], "-", 
            RowBox[{"nn", "[", "al", "]"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"V", "[", "al", "]"}], "+", 
            RowBox[{"V", "[", "gam", "]"}]}], ")"}], 
          RowBox[{"Conjugate", "[", 
           RowBox[{"cc", "[", "gam", "]"}], "]"}]}]}], ")"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{"del", ",", "bet"}], "]"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Tanaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"V", "[", "al", "]"}], "+", 
           RowBox[{"V", "[", 
            RowBox[{"al", "+", "bet"}], "]"}]}], ")"}], 
         RowBox[{"cc", "[", "al", "]"}], 
         RowBox[{"R", "[", 
          RowBox[{"gam", ",", 
           RowBox[{"-", "del"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"V", "[", "al", "]"}], "+", 
           RowBox[{"V", "[", "bet", "]"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"1", "/", "2"}], "+", 
           RowBox[{"nn", "[", "al", "]"}]}], ")"}], 
         RowBox[{"R", "[", 
          RowBox[{"gam", ",", 
           RowBox[{"-", "del"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"V", "[", "bet", "]"}], "+", 
           RowBox[{"V", "[", 
            RowBox[{"al", "+", "bet"}], "]"}]}], ")"}], 
         RowBox[{"cc", "[", "al", "]"}], 
         RowBox[{"Conjugate", "[", 
          RowBox[{"M", "[", 
           RowBox[{
            RowBox[{"gam", "+", "del"}], ",", "gam"}], "]"}], "]"}]}]}], 
       ")"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Symmtrize", " ", "the", " ", "analytic", " ", "formulas"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Panaly", "=", 
     RowBox[{"SP", "[", "F5Panaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Qanaly", "=", 
     RowBox[{"ASQ", "[", "F5Qanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F5Tanaly", "=", 
     RowBox[{"ST", "[", "F5Tanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"difference", "=", 
     RowBox[{"zero", "?"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Expand", "[", "F5Panaly", "]"}], "-", 
         RowBox[{"Expand", "[", "F5P", "]"}]}], ")"}], "/.", "symcuml"}], "//",
       "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"zero", "/.", 
    RowBox[{"{", 
     RowBox[{"del", "\[Rule]", 
      RowBox[{"al", "+", "bet", "+", "gam"}]}], "}"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Expand", "[", "F5Qanaly", "]"}], "-", 
         RowBox[{"Expand", "[", "F5Q", "]"}]}], ")"}], "/.", "symcuml"}], "//",
       "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"zero", "/.", 
    RowBox[{"{", 
     RowBox[{"del", "\[Rule]", 
      RowBox[{"al", "+", "bet", "-", "gam"}]}], "}"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Expand", "[", "F5Tanaly", "]"}], "-", 
        RowBox[{"Expand", "[", "F5T", "]"}]}], ")"}], "/.", "symcuml"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "/.", 
     RowBox[{"{", 
      RowBox[{"del", "\[Rule]", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"al", "+", "bet", "+", "gam"}], ")"}]}]}], "}"}]}], "//", 
    "Simplify"}]}]}]], "Input",
 CellChangeTimes->{{3.7878984612650433`*^9, 3.787898531969404*^9}, {
   3.787898574936152*^9, 3.787898592558877*^9}, 3.787898634496376*^9, {
   3.787898763610671*^9, 3.787898764298214*^9}, {3.787898816081521*^9, 
   3.787898827547285*^9}, {3.787899599151444*^9, 3.787899600716601*^9}, 
   3.787899747307858*^9, {3.787932453714219*^9, 3.787932455544606*^9}, {
   3.7879325706858664`*^9, 3.787932594143203*^9}, {3.78793263582132*^9, 
   3.7879326415325527`*^9}, {3.788003453098415*^9, 3.7880035246030188`*^9}, {
   3.788003764220436*^9, 3.788003788261466*^9}, {3.788004043505393*^9, 
   3.788004068054435*^9}, {3.788004680238842*^9, 3.788004743400034*^9}, {
   3.7880107925285597`*^9, 3.788010808703012*^9}, {3.788020354921818*^9, 
   3.7880204566195717`*^9}, {3.7880746758681707`*^9, 
   3.7880746847308826`*^9}, {3.7880748082188597`*^9, 3.788074808864428*^9}, {
   3.7880923208643503`*^9, 3.788092331941722*^9}, {3.7881787848449707`*^9, 
   3.788178800352375*^9}, {3.788180675793103*^9, 3.788180700025003*^9}, {
   3.8026844567823668`*^9, 3.80268446695649*^9}, {3.8030310608221703`*^9, 
   3.803031096027699*^9}, {3.803031132691853*^9, 3.803031177012835*^9}, {
   3.803031401148221*^9, 3.803031505456153*^9}, {3.803031545193121*^9, 
   3.803031634163533*^9}, {3.803031858838059*^9, 3.803031905630095*^9}, {
   3.803805575780222*^9, 3.803805576927245*^9}, {3.8038323936717587`*^9, 
   3.803832395614121*^9}, {3.80383242613338*^9, 3.803832427664082*^9}, 
   3.8038762861575327`*^9, {3.803876410605701*^9, 3.8038764410696287`*^9}, {
   3.8038765113913116`*^9, 3.803876549530163*^9}, {3.803876591008235*^9, 
   3.80387662234059*^9}, {3.803876845867343*^9, 3.803876849657216*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"10065307-4251-4ff5-9870-ad37251ed88e"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.803031908474321*^9, 3.803033983806417*^9, 
  3.803035100653049*^9, 3.8038776399902678`*^9},
 CellLabel->
  "Out[145]=",ExpressionUUID->"a377176c-f1e5-4cf1-bd7c-c21ea3710158"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.803031908474321*^9, 3.803033983806417*^9, 
  3.803035100653049*^9, 3.8038776401071987`*^9},
 CellLabel->
  "Out[147]=",ExpressionUUID->"f989cfd5-7df5-4ccf-948e-2f691b403dd8"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.803031908474321*^9, 3.803033983806417*^9, 
  3.803035100653049*^9, 3.803877640125416*^9},
 CellLabel->
  "Out[149]=",ExpressionUUID->"932bb5d3-e0ff-4e8a-bcbd-8e4925b685a2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"PH4", ",", " ", 
    RowBox[{"QH4", " ", "and", " ", "TH4"}]}], "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{"PH4", "=", 
     RowBox[{"commH4", "[", "opP", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QH4", "=", 
     RowBox[{"commH4", "[", "opQ", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TH4", "=", 
     RowBox[{"commH4", "[", "opT", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.788073463483097*^9, 3.78807350272654*^9}, {
  3.788073596527546*^9, 3.788073604093856*^9}, {3.788073645913471*^9, 
  3.7880738288562813`*^9}, {3.788074206404566*^9, 3.788074219932143*^9}, {
  3.7880744154568377`*^9, 3.7880744181423473`*^9}, {3.788074709701747*^9, 
  3.788074709858038*^9}, {3.788075006241562*^9, 3.788075178448018*^9}, {
  3.788075221017914*^9, 3.78807522132026*^9}, {3.788075447594542*^9, 
  3.7880754679045*^9}, {3.788080443333317*^9, 3.788080545767879*^9}, {
  3.788080880135112*^9, 3.788080890349753*^9}, {3.788092345059722*^9, 
  3.7880923877909*^9}, {3.7881788760749807`*^9, 3.788178900696002*^9}, {
  3.803876635979267*^9, 3.80387664148624*^9}},
 CellLabel->
  "In[150]:=",ExpressionUUID->"cb6ccdb8-4f3d-45d1-8e80-c3025c5647f4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"doublet", " ", "part", " ", "of", " ", "PH4"}], ",", " ", 
    RowBox[{"QH4", " ", "and", " ", "TH4", " ", 
     RowBox[{"(", 
      RowBox[{"Eqs", ".", " ", 
       RowBox[{"(", 
        RowBox[{"127", "-", "128", "-", "129"}], ")"}]}], ")"}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"F6Pd", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"PH4", ",", "doublets", ",", 
       RowBox[{"del", "->", 
        RowBox[{"al", "+", "bet", "+", "gam"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qd", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"QH4", ",", "doublets", ",", 
       RowBox[{"del", "->", 
        RowBox[{"al", "+", "bet", "-", "gam"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Td", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"TH4", ",", "doublets", ",", 
       RowBox[{"del", "->", 
        RowBox[{
         RowBox[{"-", "al"}], "-", "bet", "-", "gam"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Pd", "=", 
     RowBox[{"F6Pd", "/", "2"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{"facteur", " ", 
      RowBox[{"1", "/", "2"}], " ", "de", " ", "H4"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"F6Qd", "=", 
     RowBox[{"F6Qd", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Td", "=", 
     RowBox[{"F6Td", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Analytic", " ", "formulas", " ", "from", " ", 
     RowBox[{"Eqs", ".", " ", 
      RowBox[{"(", 
       RowBox[{"127", "-", "128", "-", "129"}]}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Pdanaly", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"V", "[", 
        RowBox[{"al", "+", "gam"}], "]"}], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"nn", "[", "al", "]"}], "+", 
         RowBox[{"nn", "[", "bet", "]"}]}], ")"}], 
       RowBox[{"cc", "[", "gam", "]"}], 
       RowBox[{"nn", "[", "del", "]"}]}], "+", 
      RowBox[{
       RowBox[{"V", "[", 
        RowBox[{"al", "+", "bet"}], "]"}], 
       RowBox[{"cc", "[", "al", "]"}], 
       RowBox[{"cc", "[", "gam", "]"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"cc", "[", "del", "]"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"V", "[", 
        RowBox[{"al", "+", "bet"}], "]"}], 
       RowBox[{"cc", "[", "al", "]"}], 
       RowBox[{"nn", "[", "bet", "]"}], 
       RowBox[{"nn", "[", "gam", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qdanaly", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"V", "[", 
        RowBox[{"gam", "-", "al"}], "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", "2"}], "+", 
         RowBox[{"nn", "[", "bet", "]"}]}], ")"}], 
       RowBox[{"nn", "[", "gam", "]"}], 
       RowBox[{"nn", "[", "del", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"V", "[", 
          RowBox[{"al", "+", "bet"}], "]"}], "+", 
         RowBox[{"V", "[", 
          RowBox[{"al", "-", "del"}], "]"}]}], ")"}], 
       RowBox[{"cc", "[", "al", "]"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"cc", "[", "del", "]"}], "]"}], 
       RowBox[{"nn", "[", "gam", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tdanaly", "=", 
     RowBox[{
      RowBox[{"V", "[", 
       RowBox[{"al", "+", "del"}], "]"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1", "/", "2"}], "+", 
        RowBox[{"nn", "[", "bet", "]"}]}], ")"}], 
      RowBox[{"cc", "[", "gam", "]"}], 
      RowBox[{"cc", "[", "del", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Symmtrize", " ", "the", " ", "analytic", " ", "formulas"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Pdanaly", "=", 
     RowBox[{"SP", "[", "F6Pdanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qdanaly", "=", 
     RowBox[{"ASQ", "[", "F6Qdanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tdanaly", "=", 
     RowBox[{"ST", "[", "F6Tdanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"difference", "=", 
     RowBox[{"zero", "?"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Expand", "[", "F6Pdanaly", "]"}], "-", 
        RowBox[{"Expand", "[", "F6Pd", "]"}]}], ")"}], "/.", "symcuml"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "/.", 
     RowBox[{"{", 
      RowBox[{"del", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"al", "+", "bet", "+", "gam"}], ")"}]}], "}"}]}], "//", 
    "Simplify"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Expand", "[", "F6Qdanaly", "]"}], "-", 
         RowBox[{"Expand", "[", "F6Qd", "]"}]}], ")"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"KroneckerDelta", "[", 
          RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "0"}], "}"}]}], "/.", 
      "symcuml"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "/.", 
     RowBox[{"{", 
      RowBox[{"del", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"al", "+", "bet", "-", "gam"}], ")"}]}], "}"}]}], "//", 
    "Simplify"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Expand", "[", "F6Tdanaly", "]"}], "-", 
        RowBox[{"Expand", "[", "F6Td", "]"}]}], ")"}], "/.", "symcuml"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "/.", 
     RowBox[{"{", 
      RowBox[{"del", "\[Rule]", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"al", "+", "bet", "-", "gam"}], ")"}]}]}], "}"}]}], "//", 
    "Simplify"}]}]}]], "Input",
 CellChangeTimes->{{3.788178904033482*^9, 3.788178950237526*^9}, {
   3.802684665250392*^9, 3.802684667004109*^9}, {3.8030324288534327`*^9, 
   3.8030324336687803`*^9}, {3.8038055775580587`*^9, 3.803805578520513*^9}, {
   3.803832395806979*^9, 3.803832397848219*^9}, {3.8038324278542624`*^9, 
   3.8038324293527822`*^9}, 3.803876290654909*^9, {3.803876670811751*^9, 
   3.8038766930808496`*^9}, {3.8038767479965143`*^9, 3.803876772738715*^9}, {
   3.8038768378620863`*^9, 3.803876840056188*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"17ad3477-01e8-4655-b27f-eb8a8d8753f8"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.80303244152393*^9, 3.80303400097897*^9, 
  3.803035108407443*^9, 3.803877647923236*^9},
 CellLabel->
  "Out[165]=",ExpressionUUID->"d40864ed-3e87-4ff2-8b5d-85c6a8ff35e2"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.80303244152393*^9, 3.80303400097897*^9, 
  3.803035108407443*^9, 3.8038776479889183`*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"17d9ac46-ec24-4f7d-a76a-cb2d5cea0cbd"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.80303244152393*^9, 3.80303400097897*^9, 
  3.803035108407443*^9, 3.803877648010833*^9},
 CellLabel->
  "Out[169]=",ExpressionUUID->"7ca61497-9693-4bdb-922e-68e269efd247"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"triplet", " ", "part", " ", "of", " ", "PH4"}], ",", " ", 
    RowBox[{"QH4", " ", "and", " ", "TH4", " ", 
     RowBox[{"(", 
      RowBox[{"Eqs", ".", " ", 
       RowBox[{"(", 
        RowBox[{"130", "-", "131", "-", "132"}], ")"}]}], ")"}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"F6Pt", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"PH4", ",", "triplets", ",", 
       RowBox[{"del", "->", 
        RowBox[{"al", "+", "bet", "+", "gam"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qt", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"QH4", ",", "triplets", ",", 
       RowBox[{"del", "->", 
        RowBox[{"al", "+", "bet", "-", "gam"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tt", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"TH4", ",", "triplets", ",", 
       RowBox[{"del", "->", 
        RowBox[{
         RowBox[{"-", "al"}], "-", "bet", "-", "gam"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Pt", "=", 
     RowBox[{"F6Pt", "/", "2"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{"factor", " ", 
      RowBox[{"1", "/", "2"}], " ", "of", " ", "H4"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"F6Qt", "=", 
     RowBox[{"F6Qt", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tt", "=", 
     RowBox[{"F6Tt", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Pt", "=", 
     RowBox[{
      RowBox[{"F6Pt", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k2", "\[Rule]", "k3"}], ",", 
         RowBox[{"k1", "\[Rule]", "k3"}]}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sum", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "x"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qt", "=", 
     RowBox[{
      RowBox[{"F6Qt", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k2", "\[Rule]", "k3"}], ",", 
         RowBox[{"k1", "\[Rule]", "k3"}]}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sum", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "x"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tt", "=", 
     RowBox[{
      RowBox[{"F6Tt", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k2", "\[Rule]", "k3"}], ",", 
         RowBox[{"k1", "\[Rule]", "k3"}]}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sum", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "x"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Symmtrize", " ", "the", " ", "dummy", " ", "variable", " ", "k3"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Pt", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F6Pt", "+", 
        RowBox[{"(", 
         RowBox[{"F6Pt", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qt", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F6Qt", "+", 
        RowBox[{"(", 
         RowBox[{"F6Qt", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tt", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F6Tt", "+", 
        RowBox[{"(", 
         RowBox[{"F6Tt", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Analytic", " ", "formulas", " ", "from", " ", 
     RowBox[{"Eqs", ".", " ", 
      RowBox[{"(", 
       RowBox[{"130", "-", "131", "-", "132"}]}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Ptanaly", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"bet", ",", 
         RowBox[{"-", "gam"}]}], "]"}], 
       RowBox[{"V", "[", "del", "]"}], 
       RowBox[{
        RowBox[{"M", "[", 
         RowBox[{"k3", ",", "del"}], "]"}], "/", "2"}]}], "+", 
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"bet", ",", 
         RowBox[{"-", "gam"}]}], "]"}], 
       RowBox[{"V", "[", "k3", "]"}], 
       RowBox[{
        RowBox[{"M", "[", 
         RowBox[{
          RowBox[{"al", "+", "k3"}], ",", "del"}], "]"}], "/", "2"}]}], "+", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{"del", ",", "bet"}], "]"}], "]"}], 
       RowBox[{"V", "[", "al", "]"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{
          RowBox[{"al", "+", "k3"}], ",", "al"}], "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{"del", ",", "bet"}], "]"}], "]"}], 
       RowBox[{"V", "[", "k3", "]"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{
          RowBox[{"k3", "+", "al", "+", "gam"}], ",", "al"}], "]"}], "]"}]}], 
      "+", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{
          RowBox[{"bet", "+", "gam"}], ",", "bet"}], "]"}], "]"}], 
       RowBox[{"V", "[", "k3", "]"}], 
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"M", "[", 
          RowBox[{"del", ",", 
           RowBox[{"al", "-", "k3"}]}], "]"}], "]"}], "/", "2"}]}], "+", 
      RowBox[{
       RowBox[{"M", "[", 
        RowBox[{"bet", ",", "del"}], "]"}], 
       RowBox[{"V", "[", "k3", "]"}], 
       RowBox[{"R", "[", 
        RowBox[{"al", ",", 
         RowBox[{
          RowBox[{"-", "k3"}], "-", "gam"}]}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"bet", ",", 
         RowBox[{"-", "gam"}]}], "]"}], 
       RowBox[{"V", "[", "k3", "]"}], 
       RowBox[{
        RowBox[{"M", "[", 
         RowBox[{"al", ",", 
          RowBox[{"del", "-", "k3"}]}], "]"}], "/", "2"}]}], "-", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{
          RowBox[{"bet", "+", "gam"}], ",", "bet"}], "]"}], "]"}], 
       RowBox[{"V", "[", "al", "]"}], 
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"M", "[", 
          RowBox[{
           RowBox[{"al", "+", "k3"}], ",", "al"}], "]"}], "]"}], "/", "2"}]}],
       "-", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{
          RowBox[{"bet", "+", "gam"}], ",", "bet"}], "]"}], "]"}], 
       RowBox[{"V", "[", "k3", "]"}], 
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"M", "[", 
          RowBox[{
           RowBox[{"del", "+", "k3"}], ",", "al"}], "]"}], "]"}], "/", 
        "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qtanaly", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"R", "[", 
         RowBox[{"gam", ",", 
          RowBox[{"-", "del"}]}], "]"}], "]"}], 
       RowBox[{"V", "[", "k3", "]"}], 
       RowBox[{
        RowBox[{"R", "[", 
         RowBox[{
          RowBox[{"al", "+", "k3"}], ",", 
          RowBox[{"-", "bet"}]}], "]"}], "/", "2"}]}], "+", 
      RowBox[{
       RowBox[{"M", "[", 
        RowBox[{
         RowBox[{"gam", "+", "del"}], ",", "gam"}], "]"}], 
       RowBox[{"V", "[", "bet", "]"}], 
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"M", "[", 
          RowBox[{
           RowBox[{"k3", "+", "bet"}], ",", "bet"}], "]"}], "]"}], "/", 
        "2"}]}], "+", 
      RowBox[{
       RowBox[{"M", "[", 
        RowBox[{
         RowBox[{"gam", "+", "del"}], ",", "gam"}], "]"}], 
       RowBox[{"V", "[", "k3", "]"}], 
       RowBox[{
        RowBox[{"Conjugate", "[", 
         RowBox[{"M", "[", 
          RowBox[{
           RowBox[{"al", "+", "bet", "+", "k3"}], ",", "bet"}], "]"}], "]"}], 
        "/", "2"}]}], "+", 
      RowBox[{
       RowBox[{"M", "[", 
        RowBox[{"bet", ",", "gam"}], "]"}], 
       RowBox[{"V", "[", "k3", "]"}], 
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{"del", ",", 
          RowBox[{"al", "+", "k3"}]}], "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{"gam", ",", "bet"}], "]"}], "]"}], 
       RowBox[{"V", "[", "del", "]"}], 
       RowBox[{"M", "[", 
        RowBox[{
         RowBox[{"del", "+", "k3"}], ",", "del"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"M", "[", 
         RowBox[{"gam", ",", "bet"}], "]"}], "]"}], 
       RowBox[{"V", "[", "k3", "]"}], 
       RowBox[{"M", "[", 
        RowBox[{
         RowBox[{"al", "+", "k3"}], ",", "del"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Ttanaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Conjugate", "[", 
          RowBox[{"M", "[", 
           RowBox[{
            RowBox[{"gam", "+", "del"}], ",", "gam"}], "]"}], "]"}], 
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"R", "[", 
          RowBox[{
           RowBox[{"al", "+", "k3"}], ",", 
           RowBox[{"-", "bet"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"R", "[", 
          RowBox[{"gam", ",", 
           RowBox[{"-", "del"}]}], "]"}], 
         RowBox[{"V", "[", "bet", "]"}], 
         RowBox[{"Conjugate", "[", 
          RowBox[{"M", "[", 
           RowBox[{
            RowBox[{"bet", "+", "k3"}], ",", "bet"}], "]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"R", "[", 
          RowBox[{"gam", ",", 
           RowBox[{"-", "del"}]}], "]"}], 
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"Conjugate", "[", 
          RowBox[{"M", "[", 
           RowBox[{
            RowBox[{"al", "+", "bet", "+", "k3"}], ",", "bet"}], "]"}], 
          "]"}]}]}], ")"}], "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Symmtrize", " ", "the", " ", "analytic", " ", "formulas"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Ptanaly", "=", 
     RowBox[{"SP", "[", "F6Ptanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qtanaly", "=", 
     RowBox[{"ASQ", "[", "F6Qtanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Ttanaly", "=", 
     RowBox[{"ST", "[", "F6Ttanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Symmtrize", " ", "the", " ", "dummy", " ", "variable", " ", "k3"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Ptanaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F6Ptanaly", "+", 
        RowBox[{"(", 
         RowBox[{"F6Ptanaly", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qtanaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F6Qtanaly", "+", 
        RowBox[{"(", 
         RowBox[{"F6Qtanaly", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Ttanaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F6Ttanaly", "+", 
        RowBox[{"(", 
         RowBox[{"F6Ttanaly", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"difference", "=", 
     RowBox[{"zero", "?"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "T", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Expand", "[", "F6Ttanaly", "]"}], "-", 
        RowBox[{"Expand", "[", "F6Tt", "]"}]}], ")"}], "/.", "symcuml"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "/.", 
     RowBox[{"{", 
      RowBox[{"del", "\[Rule]", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"al", "+", "bet", "+", "gam"}], ")"}]}]}], "}"}]}], "//", 
    "Simplify"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "Q", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Expand", "[", "F6Qtanaly", "]"}], "-", 
         RowBox[{"Expand", "[", "F6Qt", "]"}]}], ")"}], "/.", "symcuml"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"KroneckerDelta", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "0"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"zero", "/.", 
      RowBox[{"{", 
       RowBox[{"del", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"al", "+", "bet", "-", "gam"}], ")"}]}], "}"}]}], "//", 
     "Simplify"}], ";", 
    RowBox[{"(*", 
     RowBox[{
     "Checked", " ", "that", " ", "the", " ", "variable", " ", "changes", " ",
       "below", " ", "are", " ", "allowed", " ", 
      RowBox[{"(", 
       RowBox[{
       "k3", " ", "appears", " ", "only", " ", "in", " ", "one", " ", 
        "factor", " ", "of", " ", "each", " ", "term", " ", "of", " ", "this",
         " ", "expression", " ", "of", " ", "Q"}], ")"}]}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"zero", "/.", 
       RowBox[{"{", 
        RowBox[{"del", "\[Rule]", 
         RowBox[{"(", 
          RowBox[{"al", "+", "bet", "-", "gam"}], ")"}]}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"x_", "-", "k3"}], "\[Rule]", "k3"}], ",", 
        RowBox[{
         RowBox[{"x_", "+", "k3"}], "\[Rule]", "k3"}], ",", 
        RowBox[{
         RowBox[{"-", "k3"}], "\[Rule]", "k3"}]}], "}"}]}], "//", 
     "Simplify"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", "P", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Expand", "[", "F6Ptanaly", "]"}], "-", 
        RowBox[{"Expand", "[", "F6Pt", "]"}]}], ")"}], "/.", "symcuml"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "/.", 
     RowBox[{"{", 
      RowBox[{"del", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"al", "+", "bet", "+", "gam"}], ")"}]}], "}"}]}], "//", 
    "Simplify"}]}]}]], "Input",
 CellChangeTimes->{{3.8030324545430403`*^9, 3.803033231432575*^9}, 
   3.803033337986809*^9, {3.803033379807654*^9, 3.803033395680035*^9}, {
   3.803033439651004*^9, 3.803033442691484*^9}, 3.8030335223337927`*^9, {
   3.8038055792005863`*^9, 3.803805580124477*^9}, 3.803876297062463*^9, {
   3.803876699122332*^9, 3.8038767159541197`*^9}, {3.803876785020729*^9, 
   3.8038768310108643`*^9}, {3.803876900914275*^9, 3.803876967634486*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"b2a14102-6bd8-49a0-aebb-9a4b8d8fb589"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.803033525110276*^9, 3.803034005426553*^9, 
  3.803035110610874*^9, 3.803877651645439*^9},
 CellLabel->
  "Out[191]=",ExpressionUUID->"8e12f56b-fb7d-477a-8ead-2cd776bd8dfe"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.803033525110276*^9, 3.803034005426553*^9, 
  3.803035110610874*^9, 3.803877651723782*^9},
 CellLabel->
  "Out[193]=",ExpressionUUID->"196ef543-4b7a-403e-9775-1852ecf833b7"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.803033525110276*^9, 3.803034005426553*^9, 
  3.803035110610874*^9, 3.803877651736582*^9},
 CellLabel->
  "Out[195]=",ExpressionUUID->"b644e373-a55c-4cb8-894f-7078d5628dc1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"quadruplet", " ", "part", " ", "of", " ", "PH4"}], ",", " ", 
    RowBox[{"QH4", " ", "and", " ", "TH4", " ", 
     RowBox[{"(", 
      RowBox[{"Eqs", ".", " ", 
       RowBox[{"(", 
        RowBox[{"133", "-", "134", "-", "135"}], ")"}]}], ")"}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"F6Pq", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"PH4", ",", "quadruplets", ",", 
       RowBox[{"del", "->", 
        RowBox[{"al", "+", "bet", "+", "gam"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qq", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"QH4", ",", "quadruplets", ",", 
       RowBox[{"del", "->", 
        RowBox[{"al", "+", "bet", "-", "gam"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tq", "=", 
     RowBox[{"ContractionListe", "[", 
      RowBox[{"TH4", ",", "quadruplets", ",", 
       RowBox[{"del", "->", 
        RowBox[{
         RowBox[{"-", "al"}], "-", "bet", "-", "gam"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Pq", "=", 
     RowBox[{"F6Pq", "/", "2"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{"factor", " ", 
      RowBox[{"1", "/", "2"}], " ", "of", " ", "H4"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"F6Qq", "=", 
     RowBox[{"F6Qq", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tq", "=", 
     RowBox[{"F6Tq", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Pq", "=", 
     RowBox[{
      RowBox[{"F6Pq", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k2", "\[Rule]", "k3"}], ",", 
         RowBox[{"k1", "\[Rule]", "k3"}]}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sum", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "x"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qq", "=", 
     RowBox[{
      RowBox[{"F6Qq", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k2", "\[Rule]", "k3"}], ",", 
         RowBox[{"k1", "\[Rule]", "k3"}]}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sum", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "x"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tq", "=", 
     RowBox[{
      RowBox[{"F6Tq", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k2", "\[Rule]", "k3"}], ",", 
         RowBox[{"k1", "\[Rule]", "k3"}]}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sum", "[", 
         RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "x"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "remove", " ", "the", " ", "reducible", " ", "part", " ", "from", " ", 
     "the", " ", "commutator", " ", "with", " ", "H_", 
     RowBox[{"2", "^", "HFB"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Pq", "=", 
     RowBox[{"F6Pq", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"nn", "[", 
          RowBox[{"x_", "+", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"nn", "[", 
          RowBox[{"x_", "-", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"cc", "[", 
          RowBox[{"x_", "+", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"cc", "[", 
          RowBox[{"x_", "-", "k3"}], "]"}], "\[Rule]", "0"}]}], "}"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qq", "=", 
     RowBox[{"F6Qq", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"nn", "[", 
          RowBox[{"x_", "+", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"nn", "[", 
          RowBox[{"x_", "-", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"cc", "[", 
          RowBox[{"x_", "+", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"cc", "[", 
          RowBox[{"x_", "-", "k3"}], "]"}], "\[Rule]", "0"}]}], "}"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tq", "=", 
     RowBox[{"F6Tq", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"nn", "[", 
          RowBox[{"x_", "+", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"nn", "[", 
          RowBox[{"x_", "-", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"cc", "[", 
          RowBox[{"x_", "+", "k3"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"cc", "[", 
          RowBox[{"x_", "-", "k3"}], "]"}], "\[Rule]", "0"}]}], "}"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Symmtrize", " ", "the", " ", "dummy", " ", "variable", " ", "k3"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Pq", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F6Pq", "+", 
        RowBox[{"(", 
         RowBox[{"F6Pq", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qq", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F6Qq", "+", 
        RowBox[{"(", 
         RowBox[{"F6Qq", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tq", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F6Tq", "+", 
        RowBox[{"(", 
         RowBox[{"F6Tq", "/.", 
          RowBox[{"{", 
           RowBox[{"k3", "\[Rule]", 
            RowBox[{"-", "k3"}]}], "}"}]}], ")"}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Analytic", " ", "formulas", " ", "from", " ", 
     RowBox[{"Eqs", ".", " ", 
      RowBox[{"(", 
       RowBox[{"133", "-", "134", "-", "135"}]}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Pqanaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"nn", "[", "al", "]"}], "+", 
           RowBox[{"nn", "[", "bet", "]"}]}], ")"}], 
         RowBox[{"P", "[", 
          RowBox[{
           RowBox[{"al", "+", "k3"}], ",", 
           RowBox[{"bet", "-", "k3"}], ",", "gam"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"V", "[", 
          RowBox[{"al", "-", "del"}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"nn", "[", "del", "]"}], "-", 
           RowBox[{"nn", "[", "al", "]"}]}], ")"}], 
         RowBox[{"P", "[", 
          RowBox[{"bet", ",", "gam", ",", "k3"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"nn", "[", "del", "]"}], "-", 
           RowBox[{"nn", "[", "al", "]"}]}], ")"}], 
         RowBox[{"P", "[", 
          RowBox[{"bet", ",", "gam", ",", 
           RowBox[{"al", "-", "k3"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"Conjugate", "[", 
          RowBox[{"cc", "[", "del", "]"}], "]"}], 
         RowBox[{"T", "[", 
          RowBox[{
           RowBox[{"al", "+", "k3"}], ",", "bet", ",", "gam"}], "]"}]}], "+", 
        
        RowBox[{"2", 
         RowBox[{"V", "[", 
          RowBox[{"al", "+", "bet"}], "]"}], 
         RowBox[{"cc", "[", "al", "]"}], 
         RowBox[{"Q", "[", 
          RowBox[{"gam", ",", "k3", ",", "del"}], "]"}]}], "+", 
        RowBox[{"2", 
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"cc", "[", "al", "]"}], 
         RowBox[{"Q", "[", 
          RowBox[{"gam", ",", 
           RowBox[{"k3", "+", "bet"}], ",", "del"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"cc", "[", "al", "]"}], 
         RowBox[{"Q", "[", 
          RowBox[{"bet", ",", "gam", ",", 
           RowBox[{"del", "-", "k3"}]}], "]"}]}]}], ")"}], "/", "2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qqanaly", "=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"V", "[", "k3", "]"}], 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"nn", "[", "al", "]"}], "+", 
          RowBox[{"nn", "[", "bet", "]"}]}], ")"}], 
        RowBox[{
         RowBox[{"Q", "[", 
          RowBox[{
           RowBox[{"al", "+", "k3"}], ",", 
           RowBox[{"bet", "-", "k3"}], ",", "gam"}], "]"}], "/", "4"}]}], "+", 
       RowBox[{
        RowBox[{"V", "[", 
         RowBox[{"al", "-", "gam"}], "]"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"nn", "[", "gam", "]"}], "-", 
          RowBox[{"nn", "[", "al", "]"}]}], ")"}], 
        RowBox[{
         RowBox[{"Q", "[", 
          RowBox[{"bet", ",", "k3", ",", "del"}], "]"}], "/", "2"}]}], "+", 
       RowBox[{
        RowBox[{"V", "[", "k3", "]"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"nn", "[", "gam", "]"}], "-", 
          RowBox[{"nn", "[", "al", "]"}]}], ")"}], 
        RowBox[{
         RowBox[{"Q", "[", 
          RowBox[{"bet", ",", 
           RowBox[{"al", "-", "k3"}], ",", "del"}], "]"}], "/", "2"}]}], "+", 
       
       RowBox[{
        RowBox[{"V", "[", "k3", "]"}], 
        RowBox[{"Conjugate", "[", 
         RowBox[{"cc", "[", "gam", "]"}], "]"}], 
        RowBox[{"P", "[", 
         RowBox[{
          RowBox[{"al", "+", "k3"}], ",", "bet", ",", 
          RowBox[{
           RowBox[{"-", "gam"}], "-", "k3"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"V", "[", 
         RowBox[{"al", "+", "bet"}], "]"}], 
        RowBox[{"cc", "[", "bet", "]"}], 
        RowBox[{
         RowBox[{"Conjugate", "[", 
          RowBox[{"P", "[", 
           RowBox[{"gam", ",", "del", ",", "k3"}], "]"}], "]"}], "/", "2"}]}],
        "+", 
       RowBox[{
        RowBox[{"V", "[", "k3", "]"}], 
        RowBox[{"cc", "[", "bet", "]"}], 
        RowBox[{
         RowBox[{"Conjugate", "[", 
          RowBox[{"P", "[", 
           RowBox[{"gam", ",", "del", ",", 
            RowBox[{"k3", "-", "bet"}]}], "]"}], "]"}], "/", "2"}]}]}], 
      ")"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tqanaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"1", "/", "2"}], "+", 
           RowBox[{"nn", "[", "bet", "]"}]}], ")"}], 
         RowBox[{"T", "[", 
          RowBox[{
           RowBox[{"al", "+", "k3"}], ",", "gam", ",", "del"}], "]"}]}], "+", 
        
        RowBox[{
         RowBox[{"V", "[", 
          RowBox[{"gam", "+", "del"}], "]"}], 
         RowBox[{"cc", "[", "bet", "]"}], 
         RowBox[{"P", "[", 
          RowBox[{"gam", ",", "del", ",", "k3"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"V", "[", "k3", "]"}], 
         RowBox[{"cc", "[", "bet", "]"}], 
         RowBox[{"P", "[", 
          RowBox[{"gam", ",", "del", ",", 
           RowBox[{"al", "-", "k3"}]}], "]"}]}]}], ")"}], "/", "2"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Symmtrize", " ", "the", " ", "analytic", " ", "formulas"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Pqanaly", "=", 
     RowBox[{"SP", "[", "F6Pqanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qqanaly", "=", 
     RowBox[{"ASQ", "[", "F6Qqanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tqanaly", "=", 
     RowBox[{"ST", "[", "F6Tqanaly", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Symmtrize", " ", "the", " ", "dummy", " ", "variable", " ", "k3"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Pqanaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F6Pqanaly", "+", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"F6Pqanaly", "/.", 
           RowBox[{"{", 
            RowBox[{"k3", "\[Rule]", 
             RowBox[{"-", "k3"}]}], "}"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"V", "[", 
             RowBox[{"-", "k3"}], "]"}], "\[Rule]", 
            RowBox[{"V", "[", "k3", "]"}]}], "}"}]}], ")"}]}], ")"}], "/", 
      "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qqanaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F6Qqanaly", "+", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"F6Qqanaly", "/.", 
           RowBox[{"{", 
            RowBox[{"k3", "\[Rule]", 
             RowBox[{"-", "k3"}]}], "}"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"V", "[", 
             RowBox[{"-", "k3"}], "]"}], "\[Rule]", 
            RowBox[{"V", "[", "k3", "]"}]}], "}"}]}], ")"}]}], ")"}], "/", 
      "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Tqanaly", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"F6Tqanaly", "+", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"F6Tqanaly", "/.", 
           RowBox[{"{", 
            RowBox[{"k3", "\[Rule]", 
             RowBox[{"-", "k3"}]}], "}"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"V", "[", 
             RowBox[{"-", "k3"}], "]"}], "\[Rule]", 
            RowBox[{"V", "[", "k3", "]"}]}], "}"}]}], ")"}]}], ")"}], "/", 
      "2"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"difference", "=", 
     RowBox[{"zero", "?"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "P", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "=", 
     RowBox[{"(", 
      RowBox[{"F6Pqanaly", "-", "F6Pq"}], ")"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"zero", "/.", 
      RowBox[{"{", 
       RowBox[{"del", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"al", "+", "bet", "+", "gam"}], ")"}]}], "}"}]}], "/.", 
     "symcuml"}], "//", "Simplify"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "T", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "=", 
     RowBox[{"(", 
      RowBox[{"F6Tqanaly", "-", "F6Tq"}], ")"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"zero", "/.", 
      RowBox[{"{", 
       RowBox[{"del", "\[Rule]", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"al", "+", "bet", "+", "gam"}], ")"}]}]}], "}"}]}], "/.", 
     "symcuml"}], "//", "Simplify"}]}]}]], "Input",
 CellChangeTimes->{{3.7880926996946*^9, 3.788092734279125*^9}, {
   3.7881571754184847`*^9, 3.788157235820034*^9}, {3.788166317707646*^9, 
   3.7881663283453817`*^9}, {3.788168438990346*^9, 3.788168444715559*^9}, {
   3.7881791021957283`*^9, 3.788179115084445*^9}, {3.802684713554152*^9, 
   3.802684715509017*^9}, {3.8030336776099377`*^9, 3.8030336924349813`*^9}, {
   3.80303373272231*^9, 3.803033733027522*^9}, {3.803805580795395*^9, 
   3.803805581631237*^9}, {3.803832398078261*^9, 3.803832433237475*^9}, 
   3.803876303349292*^9, {3.803876722496323*^9, 3.8038767322696943`*^9}, {
   3.803876993254442*^9, 3.8038770837359056`*^9}},
 CellLabel->
  "In[196]:=",ExpressionUUID->"eeb698a9-06be-4d3d-8d44-1c32e66abb60"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.803033697415493*^9, 3.8030340109735117`*^9, 
  3.803035116865026*^9, 3.803877657336793*^9},
 CellLabel->
  "Out[220]=",ExpressionUUID->"91c0ae82-8000-41ad-8f4b-f07a59b6e910"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.803033697415493*^9, 3.8030340109735117`*^9, 
  3.803035116865026*^9, 3.803877661574298*^9},
 CellLabel->
  "Out[222]=",ExpressionUUID->"4ea67bbc-22fd-403e-a2a4-55e932dfeb45"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Q", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"For", " ", 
     RowBox[{"QH4", "^", "quadruplet"}], " ", 
     RowBox[{"(", 
      RowBox[{"here", " ", "\"\<F6Qq\>\""}], ")"}]}], ",", " ", 
    RowBox[{
    "one", " ", "must", " ", "do", " ", "some", " ", "changes", " ", "of", 
     " ", "variable", " ", "on", " ", "k3"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Remove", " ", "the", " ", "factor", " ", 
    RowBox[{"1", "/", "4"}], " ", "to", " ", "speed", " ", "up", " ", 
    RowBox[{"calculations", ":"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"F6Qqs", "=", 
     RowBox[{"Expand", "[", 
      RowBox[{"4", "*", "F6Qq"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6Qqanalys", "=", 
     RowBox[{"Expand", "[", 
      RowBox[{"4", "*", "F6Qqanaly"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{"(*", 
    RowBox[{
    "Then", " ", "separate", " ", "the", " ", "terms", " ", "where", " ", 
     "the", " ", "potential", " ", "V", " ", "depends", " ", "on", " ", "k3", 
     " ", "from", " ", "the", " ", 
     RowBox[{"others", ":"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6QqAVk", "=", 
     RowBox[{"AvecVk", "[", "F6Qqs", "]"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{"Part", " ", "with", " ", 
      RowBox[{"V", "[", "k3", "]"}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"F6QqanalyAVk", "=", 
     RowBox[{"AvecVk", "[", "F6Qqanalys", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F6QqSVk", "=", 
     RowBox[{
      RowBox[{"F6Qqs", "-", 
       RowBox[{"AvecVk", "[", "F6Qqs", "]"}]}], "//", "Simplify"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{
     "Part", " ", "without", " ", "V", " ", "independent", " ", "of", " ", 
      "k3"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"F6QqanalySVk", "=", 
     RowBox[{
      RowBox[{"F6Qqanalys", "-", 
       RowBox[{"AvecVk", "[", "F6Qqanalys", "]"}]}], "//", "Simplify"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "In", " ", "the", " ", "terms", " ", "where", " ", "V", " ", "is", " ", 
      "independent", " ", "of", " ", "k3"}], ",", " ", 
     RowBox[{
     "the", " ", "variable", " ", "changes", " ", "below", " ", "are", " ", 
      "allowed", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
        "k3", " ", "appears", " ", "only", " ", "in", " ", "one", " ", 
         "factor", " ", "of", " ", "each", " ", "term"}], ")"}], "."}]}]}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zero", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"F6QqanalySVk", "-", "F6QqSVk"}], ")"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"x_", "+", "k3"}], "\[Rule]", "k3"}], ",", 
         RowBox[{
          RowBox[{"x_", "-", "k3"}], "\[Rule]", "k3"}], ",", 
         RowBox[{
          RowBox[{"-", "k3"}], "\[Rule]", "k3"}]}], "}"}]}], "//", 
      "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"The", " ", "conjugate", " ", "of", " ", 
     RowBox[{"Conjugate", "[", "Q", "]"}], " ", "is", " ", "elimated", " ", 
     "in", " ", "favor", " ", "of", " ", "Q", " ", "using", " ", "the", " ", 
     "antisymmetry"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"zero", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Conjugate", "[", 
           RowBox[{"Q", "[", 
            RowBox[{"x_", ",", "k3", ",", "z_"}], "]"}], "]"}], "->", 
          RowBox[{"Q", "[", 
           RowBox[{"z", ",", "k3", ",", "x"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"Conjugate", "[", 
           RowBox[{"Q", "[", 
            RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "]"}], "->", 
          RowBox[{"Q", "[", 
           RowBox[{"z", ",", 
            RowBox[{"x", "+", "y", "-", "z"}], ",", "x"}], "]"}]}]}], "}"}]}],
       "/.", 
      RowBox[{"{", 
       RowBox[{"del", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"al", "+", "bet", "-", "gam"}], ")"}]}], "}"}]}], "/.", 
     "symcuml"}], "//", "Simplify"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"In", " ", "the", " ", "terms", " ", "with", " ", 
      RowBox[{"V", "[", "k3", "]"}]}], ",", " ", 
     RowBox[{
     "first", " ", "remove", " ", "the", " ", "terms", " ", "coming", " ", 
      "from", " ", "the", " ", "factorized", " ", "part", " ", "of", " ", 
      "Q"}], ",", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "instance", " ", "those", " ", "containing", " ", "a", " ", 
       
       RowBox[{"KroneckerDelta", "[", 
        RowBox[{"al", ",", "gam"}], "]"}]}], ")"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"F6QqanalyAVk", "-", "F6QqAVk"}], ")"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"KroneckerDelta", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}], "\[Rule]", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Then", " ", "eliminate", " ", "the", " ", "conjugate", " ", "of", " ", 
     RowBox[{"Conjugate", "[", "Q", "]"}], " ", "in", " ", "favor", " ", "of",
      " ", "Q", " ", "using", " ", "the", " ", "antisymmetry"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"%", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Conjugate", "[", 
          RowBox[{"Q", "[", 
           RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "]"}], "->", 
         RowBox[{"Q", "[", 
          RowBox[{"z", ",", 
           RowBox[{"x", "+", "y", "-", "z"}], ",", "x"}], "]"}]}], ",", 
        RowBox[{"del", "\[Rule]", 
         RowBox[{"(", 
          RowBox[{"al", "+", "bet", "-", "gam"}], ")"}]}]}], "}"}]}], "/.", 
     "symcuml"}], "//", "Simplify"}]}]}]], "Input",
 CellChangeTimes->{{3.788177233317292*^9, 3.78817731405829*^9}, {
   3.788177347229457*^9, 3.788177367532709*^9}, 3.788177463391962*^9, {
   3.788177564468897*^9, 3.788177603438673*^9}, {3.7881781401948*^9, 
   3.7881781467499104`*^9}, {3.7881783103144693`*^9, 3.788178441333085*^9}, {
   3.788178683540002*^9, 3.788178685953444*^9}, {3.7881791866614227`*^9, 
   3.788179211909137*^9}, {3.803033716050337*^9, 3.803033736175438*^9}, 
   3.803876310066125*^9, {3.803877092019915*^9, 3.803877286273546*^9}, {
   3.80387732968048*^9, 3.803877549972192*^9}, {3.803877585227888*^9, 
   3.803877590000032*^9}},
 CellLabel->
  "In[223]:=",ExpressionUUID->"13f282e3-1601-4bc6-b714-e737d77c5174"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.803033717245653*^9, 3.803034016140708*^9, 
  3.803035121893393*^9, 3.803877663941177*^9},
 CellLabel->
  "Out[228]=",ExpressionUUID->"85d3c550-5f62-4582-9567-e0661c496c92"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.803033717245653*^9, 3.803034016140708*^9, 
  3.803035121893393*^9, 3.803877663962467*^9},
 CellLabel->
  "Out[230]=",ExpressionUUID->"b870ad59-cfd1-4ba7-8dab-b40e02ee829f"]
}, Open  ]]
},
WindowSize->{1127, 845},
WindowMargins->{{209, Automatic}, {26, Automatic}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 2651, 65, 178, "Input",ExpressionUUID->"d77cfea8-b3f7-418d-b895-91be80cba1f3"],
Cell[CellGroupData[{
Cell[3234, 89, 2444, 63, 241, "Input",ExpressionUUID->"42da60e1-9ad7-4072-b42d-8c9ce46ad00d"],
Cell[5681, 154, 614, 8, 34, "Output",ExpressionUUID->"54c5cbc5-5351-4c07-b82f-b1700018574c"],
Cell[6298, 164, 521, 8, 24, "Print",ExpressionUUID->"920dcb33-c1bd-4fe2-bbdd-212bebdec708"]
}, Open  ]],
Cell[6834, 175, 67153, 1690, 3811, "Input",ExpressionUUID->"260f6019-eef6-4af8-a44b-8bcd440b9d3d"],
Cell[73990, 1867, 1475, 40, 94, "Input",ExpressionUUID->"4b8d994c-7c6f-49ec-b6ea-172c18562180"],
Cell[CellGroupData[{
Cell[75490, 1911, 5373, 143, 367, "Input",ExpressionUUID->"b313dde3-be78-4212-b692-cedcfb24ea8b"],
Cell[80866, 2056, 247, 4, 34, "Output",ExpressionUUID->"53cabef2-758e-4f61-91bf-562c267f7a5f"],
Cell[81116, 2062, 250, 4, 34, "Output",ExpressionUUID->"b4a9ed7e-a05b-48f3-9371-070de6e69be6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81403, 2071, 7259, 215, 493, "Input",ExpressionUUID->"fce26a9b-e0f5-44fd-9606-6a58b25e7c4f"],
Cell[88665, 2288, 249, 5, 34, "Output",ExpressionUUID->"4614b1fc-7055-43a6-a8d1-2bc1bdfea56d"],
Cell[88917, 2295, 249, 5, 34, "Output",ExpressionUUID->"fe97ec51-7e78-4473-acb1-68ee2e377e36"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89203, 2305, 11375, 315, 682, "Input",ExpressionUUID->"c023a308-9d79-4f41-beb7-9b88a04105e4"],
Cell[100581, 2622, 202, 4, 34, "Output",ExpressionUUID->"656515d8-cd6b-4f09-b276-ced1bd2acbd4"],
Cell[100786, 2628, 202, 4, 34, "Output",ExpressionUUID->"2355083f-1569-480e-b64e-a125f32c6d75"]
}, Open  ]],
Cell[101003, 2635, 1990, 58, 115, "Input",ExpressionUUID->"56325dfd-cd22-4600-824e-bdf483b76439"],
Cell[CellGroupData[{
Cell[103018, 2697, 11672, 321, 682, "Input",ExpressionUUID->"10065307-4251-4ff5-9870-ad37251ed88e"],
Cell[114693, 3020, 224, 4, 34, "Output",ExpressionUUID->"a377176c-f1e5-4cf1-bd7c-c21ea3710158"],
Cell[114920, 3026, 224, 4, 34, "Output",ExpressionUUID->"f989cfd5-7df5-4ccf-948e-2f691b403dd8"],
Cell[115147, 3032, 222, 4, 34, "Output",ExpressionUUID->"932bb5d3-e0ff-4e8a-bcbd-8e4925b685a2"]
}, Open  ]],
Cell[115384, 3039, 1263, 27, 94, "Input",ExpressionUUID->"cb6ccdb8-4f3d-45d1-8e80-c3025c5647f4"],
Cell[CellGroupData[{
Cell[116672, 3070, 6655, 187, 535, "Input",ExpressionUUID->"17ad3477-01e8-4655-b27f-eb8a8d8753f8"],
Cell[123330, 3259, 220, 4, 34, "Output",ExpressionUUID->"d40864ed-3e87-4ff2-8b5d-85c6a8ff35e2"],
Cell[123553, 3265, 222, 4, 34, "Output",ExpressionUUID->"17d9ac46-ec24-4f7d-a76a-cb2d5cea0cbd"],
Cell[123778, 3271, 220, 4, 34, "Output",ExpressionUUID->"7ca61497-9693-4bdb-922e-68e269efd247"]
}, Open  ]],
Cell[CellGroupData[{
Cell[124035, 3280, 15344, 454, 1018, "Input",ExpressionUUID->"b2a14102-6bd8-49a0-aebb-9a4b8d8fb589"],
Cell[139382, 3736, 222, 4, 34, "Output",ExpressionUUID->"8e12f56b-fb7d-477a-8ead-2cd776bd8dfe"],
Cell[139607, 3742, 222, 4, 34, "Output",ExpressionUUID->"196ef543-4b7a-403e-9775-1852ecf833b7"],
Cell[139832, 3748, 222, 4, 34, "Output",ExpressionUUID->"b644e373-a55c-4cb8-894f-7078d5628dc1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[140091, 3757, 15458, 447, 934, "Input",ExpressionUUID->"eeb698a9-06be-4d3d-8d44-1c32e66abb60"],
Cell[155552, 4206, 224, 4, 34, "Output",ExpressionUUID->"91c0ae82-8000-41ad-8f4b-f07a59b6e910"],
Cell[155779, 4212, 224, 4, 34, "Output",ExpressionUUID->"4ea67bbc-22fd-403e-a2a4-55e932dfeb45"]
}, Open  ]],
Cell[CellGroupData[{
Cell[156040, 4221, 6658, 170, 451, "Input",ExpressionUUID->"13f282e3-1601-4bc6-b714-e737d77c5174"],
Cell[162701, 4393, 222, 4, 34, "Output",ExpressionUUID->"85d3c550-5f62-4582-9567-e0661c496c92"],
Cell[162926, 4399, 222, 4, 34, "Output",ExpressionUUID->"b870ad59-cfd1-4ba7-8dab-b40e02ee829f"]
}, Open  ]]
}
]
*)

