#ifndef MLUTILS_CPP
#define MLUTILS_CPP

#include <gecode/brancher/ml-utils.hh>

long MLUtils::computeDomainSize(ViewArray<Int::IntView> var_array) {
    long dom_size = 1;
    for(int i = 0; i < var_array.size(); ++i){
        // Compute combination size of domains
        // cout << "arr size: " << var_array[i].size() << endl;
        dom_size += (long)var_array[i].size();
        // cout << "Curr dom_size: " << dom_size << endl;
    }
    //cout << "My long values: " << dom_size << endl;
    
    return dom_size;
}

float MLUtils::computeImpact(int previous_dom_size, int cur_dom_size) {
    float impact = 1.0 - ((float)cur_dom_size / (float)previous_dom_size);
    // Return impact rounded to 4 decimals
    return round(impact * 10000.0) / 10000.0;
}

#endif