#ifndef MLNODE_CPP
#define MLNODE_CPP

#include <gecode/brancher/ml-node.hh>

MLNode::MLNode() {
    parent = nullptr;
    node_score = 0.0;
}

MLNode::MLNode(vector<int> assgnd, int dom_size, long deg, int val_order, int pos, int val, 
               int val_pos, int min_val_dom, int max_val_dom, int rgrt_min, int rgrt_max) {
    assigned = assgnd;
    domain_size = dom_size;
    degree = deg;
    val_order = val_order;
    position = pos;
    value = val;
    value_position = val_pos;
    min_value_domain = min_val_dom;
    max_value_domain = max_val_dom;
    regret_min = rgrt_min;
    regret_max = rgrt_max;
    parent = nullptr;
    is_leaf = true;
    node_score = 0.0;
}

MLNode* MLNode::getParent() {
    return parent;
}

bool MLNode::hasParent() {
    return parent != NULL;
}

bool MLNode::isLeaf() {
    return is_leaf;
}

int MLNode::getPositionInTree() {
    return position_in_tree;
}

void MLNode::setPositionInTree(int tree_pos) {
    position_in_tree = tree_pos;
}

vector<MLNode*> MLNode::getChildren() {
    return children;
}

void MLNode::setParent(MLNode* new_parent) {
    parent = new_parent;
}

void MLNode::pushChild(MLNode* child) {
    is_leaf = false;
    children.push_back(child);
}

void MLNode::linkChildToParent(MLNode* parent) {
    parent->pushChild(this);
    setParent(parent);
}

MLNode* MLNode::getChildByValue(int val) {
    for(int i = 0; i < children.size(); ++i) {
        if(children.at(i)->getValue() == val){
            return children.at(i);
        }  
    }
    return nullptr;
}

vector<int> MLNode::getAssigned() {
    return assigned;
}


// ----------------------
// Features
// ----------------------
int MLNode::getDomainSize() {
    return domain_size;
}

long MLNode::getDegree() {
    return degree;
}

int MLNode::getVarOrder() {
    return var_order;
}

int MLNode::getPosition() {
    return position;
}

int MLNode::getValue() {
    return value;
}

int MLNode::getValuePosition() {
    return value_position;
}

int MLNode::getMinValDom() {
    return min_value_domain;
}

int MLNode::getMaxValDom() {
    return max_value_domain;
}

int MLNode::getRegretMin(){
    return regret_min;
}

int MLNode::getRegretMax(){
    return regret_max;
}

double MLNode::getNodeScore(){
    return node_score;
}

void MLNode::setNodeScore(double score) {
    node_score = score;
}

#endif