% 
 V1 = 0.8;
 V2 = 0.2;

% E_FE = Tensor(237,141,116);
% S_FE = Reverse(pinv(Transform9(E_FE)));
% E_CE = [393 153 160 0 0 0 0 0 0;
%         153 347 161 0 0 0 0 0 0;
%         160 161 325 0 0 0 0 0 0;
%         0 0 0 24 0 0 24 0 0;
%         0 0 0 0 133 0 0 133 0;
%         0 0 0 0 0 131 0 0 131;
%         0 0 0 24 0 0 24 0 0;
%         0 0 0 0 133 0 0 133 0;
%         0 0 0 0 0 131 0 0 131];
% S_CE = Reverse(pinv(E_CE));

%%%%%%%%%%%%%%% 0K, 1E-6%%%%%%%%%%%%%%%%%
E_FE = Tensor(213,143,119);
S_FE = Reverse(pinv(Transform9(E_FE)));
E_CE = [326 163 119 0 0 0 0 0 0;
        163 303 135 0 0 0 0 0 0;
        119 135 249 0 0 0 0 0 0;
        0 0 0 72 0 0 72 0 0;
        0 0 0 0 27 0 0 27 0;
        0 0 0 0 0 98 0 0 98;
        0 0 0 72 0 0 72 0 0;
        0 0 0 0 27 0 0 27 0;
        0 0 0 0 0 98 0 0 98];
S_CE = Reverse(pinv(E_CE));

%%%%%%%%%%%%%%%%% 300K, 5e-2 %%%%%%%%%%%%%%%
% E_FE = Tensor(231,151,130);
% S_FE = Reverse(pinv(Transform9(E_FE)));
% E_CE = [309 169 128 0 0 0 0 0 0;
%         169 279 157 0 0 0 0 0 0;
%         128 157 261 0 0 0 0 0 0;
%         0 0 0 62 0 0 62 0 0;
%         0 0 0 0 30 0 0 30 0;
%         0 0 0 0 0 98 0 0 98;
%         0 0 0 62 0 0 62 0 0;
%         0 0 0 0 30 0 0 30 0;
%         0 0 0 0 0 98 0 0 98];
% S_CE = Reverse(pinv(E_CE));


%$$$$$$$$$$$$$$$$$$$$$$$$$$$ I-OR
% V1_3 = [0 1 -1];
% V1_1 = [1 1 1];
% V1_2 = [2 -1 -1];
% V1_1 = V1_1/norm(V1_1);
% V1_2 = V1_2/norm(V1_2);
% V1_3 = V1_3/norm(V1_3);
% Ori_FE = [V1_1;V1_2;V1_3]; % Here is the miller indices, the global X,Y,Z in local CS.
% % The local X,Y,Z in global CS is Ori_FE'.
% 
% V2_3 = [1 0 1];
% V2_1 = [0 1 0];
% V2_2 = [-1 0 1];
% V2_1 = V2_1/norm(V2_1);
% V2_2 = V2_2/norm(V2_2);
% V2_3 = V2_3/norm(V2_3);
% Ori_CE = [V2_1;V2_2;V2_3];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% B-OR

V1_3 = [1 -1 0];
V1_1 = [1 1 1];
V1_2 = [-1 -1 2];
V1_1 = V1_1/norm(V1_1);
V1_2 = V1_2/norm(V1_2);
V1_3 = V1_3/norm(V1_3);
Ori_FE = [V1_1;V1_2;V1_3]; % Here is the miller indices, the global X,Y,Z in local CS.
% The local X,Y,Z in global CS is Ori_FE'.

V2_3 = [1 0 0];
V2_1 = [0 1 0];
V2_2 = [0 0 1];
V2_1 = V2_1/norm(V2_1);
V2_2 = V2_2/norm(V2_2);
V2_3 = V2_3/norm(V2_3);
Ori_CE = [V2_1;V2_2;V2_3];

S_FE_rot = F_rotate_compliance_by_matrix(S_FE,Ori_FE);
S_CE_rot = F_rotate_compliance_by_matrix(S_CE,Ori_CE);
for i = 1:6
    Sigma = [0 0 0 0 0 0]';
    Sigma(i) = 1;
    [Stress1,Stress2,Strain1,Strain2] = F_IncStressStrain_Volume(Sigma,S_FE_rot,S_CE_rot,V1,V2);
    %[Stress1,Stress2,Strain1,Strain2] = F_IncStressStrain_Volume(Sigma,S_test,S_test,V1,V2);
    StrainAll(i,:) = Strain1 .* V1 + Strain2 .* V2;
end
% S = StrainAll;

S = StrainAll;
S_full = S;
S_full(4:6,:) = S_full(4:6,:)./2;
S_full(:,4:6) = S_full(:,4:6)./2;
S_full(:,7:9) = S_full(:,4:6);
S_full(7:9,:) = S_full(4:6,:);
S_full_tensor = Reverse(S_full);

theta=90+atand(2*80.6431/163.025);

R_around_Y = [cosd(theta) 0 sind(theta);0 1 0;-sind(theta) 0 cosd(theta)];

S_full_rot = F_rotate_compliance_by_matrix(S_full_tensor,R_around_Y);

%%%%%%%%%% This is for Young's modulus calculation.
% % theta=180-atand(80.6431/163.025);
% theta = 116;
% L1 = cosd(theta);
% L2 = 0;
% L3 = sind(theta);
% ReciE = S(1,1)*L1^4+S(2,2)*L2^4+S(3,3)*L3^4 + ...
%     (S(4,4)+2*S(2,3))*(L2^2*L3^2)+(S(5,5)+2*S(1,3))*(L1^2*L3^2)+(S(6,6)+2*S(1,2))*(L1^2*L2^2)+ ...
%     2*((S(1,4)+S(5,6))*L1^2+S(2,4)*L2^2+S(3,4)*L3^2)*L2*L3+ ...
%     2*((S(2,5)+S(4,6))*L2^2+S(1,5)*L1^2+S(3,5)*L3^2)*L1*L3+ ...
%     2*((S(3,6)+S(4,5))*L3^2+S(1,6)*L1^2+S(2,6)*L2^2)*L1*L2;
% 1/ReciE