% This script is to calculate the shear stress on each slip system under
% complex external stress.
 V1 = 0.8;
 V2 = 0.2;
E_FE = Tensor(213,143,119);
S_FE = Reverse(pinv(Transform9(E_FE)));
E_CE = [326 163 119 0 0 0 0 0 0;
        163 303 135 0 0 0 0 0 0;
        119 135 249 0 0 0 0 0 0;
        0 0 0 72 0 0 72 0 0;
        0 0 0 0 27 0 0 27 0;
        0 0 0 0 0 98 0 0 98;
        0 0 0 72 0 0 72 0 0;
        0 0 0 0 27 0 0 27 0;
        0 0 0 0 0 98 0 0 98];
S_CE = Reverse(pinv(E_CE));


%$$$$$$$$$$$$$$$$$$$$$$$$$$$ I-OR
% V1_3 = [0 1 -1];
% V1_1 = [1 1 1];
% V1_2 = [2 -1 -1];
% V1_1 = V1_1/norm(V1_1);
% V1_2 = V1_2/norm(V1_2);
% V1_3 = V1_3/norm(V1_3);
% Ori_FE = [V1_1;V1_2;V1_3]; % Here is the miller indices, the global X,Y,Z in local CS.
% % The local X,Y,Z in global CS is Ori_FE'.
% 
% V2_3 = [1 0 1];
% V2_1 = [0 1 0];
% V2_2 = [-1 0 1];
% V2_1 = V2_1/norm(V2_1);
% V2_2 = V2_2/norm(V2_2);
% V2_3 = V2_3/norm(V2_3);
% Ori_CE = [V2_1;V2_2;V2_3];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% B-OR

V1_3 = [1 -1 0];
V1_1 = [1 1 1];
V1_2 = [-1 -1 2];
V1_1 = V1_1/norm(V1_1);
V1_2 = V1_2/norm(V1_2);
V1_3 = V1_3/norm(V1_3);
Ori_FE = [V1_1;V1_2;V1_3]; % Here is the miller indices, the global X,Y,Z in local CS.
% The local X,Y,Z in global CS is Ori_FE'.

V2_3 = [1 0 0];
V2_1 = [0 1 0];
V2_2 = [0 0 1];
V2_1 = V2_1/norm(V2_1);
V2_2 = V2_2/norm(V2_2);
V2_3 = V2_3/norm(V2_3);
Ori_CE = [V2_1;V2_2;V2_3];

S_FE_rot = F_rotate_compliance_by_matrix(S_FE,Ori_FE);
S_CE_rot = F_rotate_compliance_by_matrix(S_CE,Ori_CE);
for i = 1:6
    Sigma = [0 0 0 0 0 0]';
    Sigma(i) = 1;
    [Stress1,Stress2,Strain1,Strain2] = F_IncStressStrain_Volume(Sigma,S_FE_rot,S_CE_rot,V1,V2);
    %[Stress1,Stress2,Strain1,Strain2] = F_IncStressStrain_Volume(Sigma,S_test,S_test,V1,V2);
    StrainAll(i,:) = Strain1 .* V1 + Strain2 .* V2;
end
% S = StrainAll;

S = StrainAll;
S_full = S;
S_full(4:6,:) = S_full(4:6,:)./2;
S_full(:,4:6) = S_full(:,4:6)./2;
S_full(:,7:9) = S_full(:,4:6);
S_full(7:9,:) = S_full(4:6,:);
S_full_tensor = Reverse(S_full);

t1 = 0;
Pole_plot = [];
Extreme = [];
RSS_list = [];
FullStress_list = [];
Stress_Fe_Analysis = [];
for t2 = 26

R_around_Y = [cosd(t2) 0 sind(t2);0 1 0;-sind(t2) 0 cosd(t2)];

S_full_rot = F_rotate_compliance_by_matrix(S_full_tensor,R_around_Y);

% Define compliance tensor S (6x6 matrix)
% format long g
% S = S_full_rot; % Replace with your actual compliance tensor values
% syms Sigma4 Sigma5 Sigma6 epsilon1 epsilon2 epsilon3 
% % Known stress and strain components
% 
% 
% sigma = [0 0 1 Sigma4 Sigma5 Sigma6]';
% epsilon = [epsilon1 epsilon2 epsilon3 0 0 0]';
% % Define the system using compliance tensor S
% equations = epsilon == S * sigma;
% 
% % Solve for unknown sigma and epsilon components
% solutions = solve(equations, [Sigma4 Sigma5 Sigma6 epsilon1 epsilon2 epsilon3]);
% 
% % Display results
% sigma4 = round(vpa(solutions.Sigma4)*100000)*0.00001;
% sigma5 = round(vpa(solutions.Sigma5)*100000)*0.00001;
% sigma6 = round(vpa(solutions.Sigma6)*100000)*0.00001;
% epsilon1 = round(vpa(solutions.epsilon1)*100000)*0.00001;
% epsilon2 = round(vpa(solutions.epsilon2)*100000)*0.00001;
% epsilon3 = round(vpa(solutions.epsilon3)*100000)*0.00001;
format long g
S = S_full_rot; % Replace with your actual compliance tensor values
syms Sigma3 Sigma4 Sigma5 Sigma6 epsilon1 epsilon2
% Known stress and strain components


sigma = [0 0 Sigma3 Sigma4 Sigma5 Sigma6]';
epsilon = [epsilon1 epsilon2 0.01 0 0 0]';
% Define the system using compliance tensor S
equations = epsilon == S * sigma;

% Solve for unknown sigma and epsilon components
solutions = solve(equations, [Sigma3 Sigma4 Sigma5 Sigma6 epsilon1 epsilon2]);

% Display results
sigma3 = round(vpa(solutions.Sigma3)*100000)*0.00001;
sigma4 = round(vpa(solutions.Sigma4)*100000)*0.00001;
sigma5 = round(vpa(solutions.Sigma5)*100000)*0.00001;
sigma6 = round(vpa(solutions.Sigma6)*100000)*0.00001;
epsilon1 = round(vpa(solutions.epsilon1)*100000)*0.00001;
epsilon2 = round(vpa(solutions.epsilon2)*100000)*0.00001;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55

Sigma = [0 sigma6 sigma5; sigma6 0 sigma4;sigma5 sigma4 sigma3]';
% Sigma = [0 sigma6 sigma5; sigma6 0 sigma4;sigma5 sigma4 1]';
v_origin = [0;1;0];
% Define the rotation matrix for rotation around Z-axis by angle phi
Rz = [cosd(t1), -sind(t1), 0;
      sind(t1),  cosd(t1), 0;
      0,        0,        1];

% Define the rotation matrix for rotation around Y-axis by angle theta
Ry = [cosd(-t2),  0, sind(-t2);
      0,          1, 0;
     -sind(-t2), 0, cosd(-t2)];

% Combined rotation matrix: first rotate by phi around Z, then by theta around Y
R = Ry * Rz;

% Rotate the stress tensor

Sigma_local = R * Sigma *R';

Sigma_local_voigt = [Sigma_local(1,1),Sigma_local(2,2),Sigma_local(3,3),Sigma_local(2,3),Sigma_local(1,3),Sigma_local(1,2)];

[Stress1,Stress2,Strain1,Strain2] = F_IncStressStrain_Volume(Sigma_local_voigt,S_FE_rot,S_CE_rot,V1,V2);

Stress_Fe = [Stress1(1),Stress1(6),Stress1(5);Stress1(6),Stress1(2),Stress1(4);Stress1(5),Stress1(4),Stress1(3)];
Stress_Ce = [Stress2(1),Stress2(6),Stress2(5);Stress2(6),Stress2(2),Stress2(4);Stress2(5),Stress2(4),Stress2(3)];

Rz = [1, -sind(t1), 0;
      sind(t1),  1, 0;
      0,        0,        1];

% Define the rotation matrix for rotation around Y-axis by angle theta
Ry = [cosd(t2),  0, sind(t2);
      0,          1, 0;
     -sind(t2), 0, cosd(t2)];
R = Ry * Rz;

% Rotate the stress tensor

Sigma_Fe = R * Stress_Fe *R';
Sigma_Ce = R * Stress_Ce *R';
end