% Define compliance tensor S (6x6 matrix)
format long g
S = S_full_rot; % Replace with your actual compliance tensor values
syms Sigma4 Sigma5 Sigma6 epsilon1 epsilon2 epsilon3 
% Known stress and strain components


sigma = [1 0 0 Sigma4 Sigma5 Sigma6]';
epsilon = [epsilon1 epsilon2 epsilon3 0 0 0]';
% Define the system using compliance tensor S
equations = epsilon == S * sigma;

% Solve for unknown sigma and epsilon components
solutions = solve(equations, [Sigma4 Sigma5 Sigma6 epsilon1 epsilon2 epsilon3]);

% Display results
sigma4 = round(vpa(solutions.Sigma4)*100000)*0.00001;
sigma5 = round(vpa(solutions.Sigma5)*100000)*0.00001;
sigma6 = round(vpa(solutions.Sigma6)*100000)*0.00001;
epsilon1 = round(vpa(solutions.epsilon1)*100000)*0.00001;
epsilon2 = round(vpa(solutions.epsilon2)*100000)*0.00001;
epsilon3 = round(vpa(solutions.epsilon3)*100000)*0.00001;
disp([sigma4 sigma5 sigma6 epsilon1 epsilon2 epsilon3])