V1 = 0.888;  % 1 is FE
V2 = 0.112;  % 2 is CE
%V1 = 0.5;
%V2 = 0.5;

E_FE = Tensor(237,141,116);
S_FE = Reverse(pinv(Transform9(E_FE)));
E_CE = [393 153 160 0 0 0 0 0 0;
        153 347 161 0 0 0 0 0 0;
        160 161 325 0 0 0 0 0 0;
        0 0 0 24 0 0 24 0 0;
        0 0 0 0 133 0 0 133 0;
        0 0 0 0 0 131 0 0 131;
        0 0 0 24 0 0 24 0 0;
        0 0 0 0 133 0 0 133 0;
        0 0 0 0 0 131 0 0 131];
S_CE = Reverse(pinv(E_CE));

% V1_1 = [0 -1 1];
% V1_2 = [-1 1 1];
% V1_3 = [-2 -1 -1];
V1_1 = [0 -1 1];
V1_2 = [-2 -1 -1];
V1_3 = [1 -1 -1];
V1_1 = V1_1/norm(V1_1);
V1_2 = V1_2/norm(V1_2);
V1_3 = V1_3/norm(V1_3);
Ori_FE = [V1_1;V1_2;V1_3];

%Ori_CE = [1 0 0;0 1 0;0 0 1];
Ori_CE = [1 0 0;0 0 1;0 -1 0];

S_FE_rot = F_rotate_compliance_by_matrix(S_FE,Ori_FE);
S_CE_rot = F_rotate_compliance_by_matrix(S_CE,Ori_CE);
for i = 90
    for j = 43
        Angle1 = i - 1;
        Angle2 = j - 1;
        % Angle1 is the angle between norm of GB and direction of external stress (Y).
        % Angle2 is the angle between the projection of the vector on XZ plane and
        % direction of external stress (Y).
        V_G1 = [sind(Angle1)*cosd(Angle2) cosd(Angle1) -sind(Angle1)*sind(Angle2)];
        % V_G1 is the norm of the GB plane.
        if abs(V_G1(2)) ~= 1
            V_G2 = cross(V_G1,[0 1 0]);
        else
            V_G2 = generater();
        end
        % V_G2 = [-0.7071 0.7071 0];
        V_G1 = V_G1/norm(V_G1);
        V_G2 = V_G2 - dot(V_G1,V_G2)*V_G1;
        V_G2 = V_G2/norm(V_G2);
        V_G3 = cross(V_G2,V_G1);

        Q = [V_G2;V_G1;V_G3];
        Sigma_matrix = [0 0 0;0 -1 0;0 0 0];
        Sigma_local = Q' * Sigma_matrix * Q;
        Sigma_Voigt = [Sigma_local(1,1),Sigma_local(2,2),Sigma_local(3,3),Sigma_local(3,2),Sigma_local(3,1),Sigma_local(2,1)]';
        [Stress1,Stress2,Strain1,Strain2] = F_IncStressStrain_Volume(Sigma_Voigt,S_FE_rot,S_CE_rot,V1,V2);
        Mises1 = Voigt2Mises(Stress1);
        Mises2 = Voigt2Mises(Stress2);
        Delta_Mises = Mises2 - Mises1;
        hydrostatic1 = (Stress1(1)+Stress1(2)+Stress1(3))/3;
        hydrostatic2 = (Stress2(1)+Stress2(2)+Stress2(3))/3;
        Delta_H = hydrostatic2 - hydrostatic1;
        strain1_M = [Strain1(1),Strain1(6),Strain1(5);Strain1(6),Strain1(2),Strain1(4);Strain1(5),Strain1(4),Strain1(3)];
        strain2_M = [Strain2(1),Strain2(6),Strain2(5);Strain2(6),Strain2(2),Strain2(4);Strain2(5),Strain2(4),Strain2(3)];
        eig1 = sort(eig(strain1_M));
        eig2 = sort(eig(strain2_M));
        Shear_1 = eig1(3) - eig1(1);
        Shear_2 = eig2(3) - eig2(1);
        %Output(i,j,:) = [i,j,Mises1,Mises2,Delta_Mises,hydrostatic1,hydrostatic2,Delta_H,eig1(3),eig2(3),Shear_1,Shear_2];
    end
end