function rss = F_RSS_Cementite(stress)
%F_RSS is to calculate resolved shear stress for FCC crystal with given
%stress state.
%   Input: stress, a 2nd order tensor.
%   Output: rss, a 12*1 vector.
% slip_planes = [2 0 -1;  2 0 -1];
% slip_directions = [0 1 0;0 -1 0];
% slip_planes = [0 1 0;  0 1 0; 0 1 0;0 1 0;1 0 0;1 0 0;0 0 1;0 0 1;0 0 1;0 0 1;0 0 1;0 0 1;
%     1 0 3;1 0 3;1 0 -3;1 0 -3;-1 0 3;-1 0 3;-1 0 -3;-1 0 -3];
% slip_directions = [0 0 1;0 0 -1;1 0 0;-1 0 0;0 1 0;0 -1 0;0 1 0;0 -1 0;1 0 0;-1 0 0;1 1 0; -1 -1 0;
%     0 1 0;0 -1 0;0 1 0;0 -1 0;0 1 0;0 -1 0;0 1 0;0 -1 0];
% slip_planes = [0 1 0;  0 1 0; 
%     0 1 0;0 1 0;
%     1 0 0;1 0 0];
% slip_directions = [0 0 1;0 0 -1;
%     1 0 0;-1 0 0;
%     0 0 1;0 0 1;];
% 
slip_planes =     [0 1 0;0 1 0;1 0 0;1 0 0;0 0 1;0 0 1;0 0 1;
    0 1 0;0 1 0;1 0 0;1 0 0;0 0 1;0 0 1;0 0 1;
    0 0 1;0 0 1;1 1 0;0 1 1;1 1 0;0 1 1;1 0 1;1 0 1];
slip_directions = [0 0 1;1 0 0;0 0 1;0 1 0;0 1 0;1 0 0;1 1 0;
    0 0 -1;-1 0 0;0 0 -1;0 -1 0;0 -1 0;-1 0 0;-1 1 0;
    1 -1 0;-1 -1 0;0 0 1;1 0 0;0 0 -1;-1 0 0;0 1 0;0 -1 0];

norms_slipdirection = vecnorm(slip_directions, 2, 2);
norms_slipplanes = vecnorm(slip_planes, 2, 2);

normalized_slip_directions = slip_directions ./ norms_slipdirection;
normalized_slip_planes = slip_planes ./ norms_slipplanes;

Num = size(slip_planes,1);
rss = zeros(1,Num);
for i = 1:Num
    m_cross_n = normalized_slip_planes(i,:)' * normalized_slip_directions(i,:);
    rss(i) = sum(sum(stress .* m_cross_n));
end

end

