% 
 V1 = 0.888;
 V2 = 0.112;

% E_FE = Tensor(237,141,116);
% S_FE = Reverse(pinv(Transform9(E_FE)));
% E_CE = [393 153 160 0 0 0 0 0 0;
%         153 347 161 0 0 0 0 0 0;
%         160 161 325 0 0 0 0 0 0;
%         0 0 0 24 0 0 24 0 0;
%         0 0 0 0 133 0 0 133 0;
%         0 0 0 0 0 131 0 0 131;
%         0 0 0 24 0 0 24 0 0;
%         0 0 0 0 133 0 0 133 0;
%         0 0 0 0 0 131 0 0 131];
% S_CE = Reverse(pinv(E_CE));

E_FE = Tensor(213,143,119);
S_FE = Reverse(pinv(Transform9(E_FE)));
E_CE = [326 163 119 0 0 0 0 0 0;
        163 303 135 0 0 0 0 0 0;
        119 135 249 0 0 0 0 0 0;
        0 0 0 72 0 0 72 0 0;
        0 0 0 0 27 0 0 27 0;
        0 0 0 0 0 98 0 0 98;
        0 0 0 72 0 0 72 0 0;
        0 0 0 0 27 0 0 27 0;
        0 0 0 0 0 98 0 0 98];
S_CE = Reverse(pinv(E_CE));

V1_3 = [1 -1 0];
V1_1 = [1 1 1];
V1_2 = [-1 -1 2];
V1_1 = V1_1/norm(V1_1);
V1_2 = V1_2/norm(V1_2);
V1_3 = V1_3/norm(V1_3);
Ori_FE = [V1_1;V1_2;V1_3]; % Here is the miller indices, the global X,Y,Z in local CS.
% The local X,Y,Z in global CS is Ori_FE'.

V2_3 = [1 0 0];
V2_1 = [0 1 0];
V2_2 = [0 0 1];
V2_1 = V2_1/norm(V2_1);
V2_2 = V2_2/norm(V2_2);
V2_3 = V2_3/norm(V2_3);
Ori_CE = [V2_1;V2_2;V2_3];

S_FE_rot = F_rotate_compliance_by_matrix(S_FE,Ori_FE);
S_CE_rot = F_rotate_compliance_by_matrix(S_CE,Ori_CE);
Sigma = [0 0 0; 0 1 0;0 0 0]';
%RSS_max = zeros(91);
Pole_plot = [];
for i = 1:1:91
    for j = 1:1:361
        t1 = i-1;
        t2 = j-1;

v_origin = [0;1;0];
% Define the rotation matrix for rotation around Z-axis by angle phi
Rz = [cosd(t1), -sind(t1), 0;
      sind(t1),  cosd(t1), 0;
      0,        0,        1];

% Define the rotation matrix for rotation around Y-axis by angle theta
Ry = [cosd(t2),  0, sind(t2);
      0,          1, 0;
     -sind(t2), 0, cosd(t2)];

% Combined rotation matrix: first rotate by phi around Z, then by theta around Y
R = Ry * Rz;

% Rotate the stress tensor
v_final = R * v_origin;

loc = F_vector2pole_XOZ(v_final);
Sigma_local = R * Sigma *R';

Sigma_local_voigt = [Sigma_local(1,1),Sigma_local(2,2),Sigma_local(3,3),Sigma_local(2,3),Sigma_local(1,3),Sigma_local(1,2)];

[Stress1,Stress2,Strain1,Strain2] = F_IncStressStrain_Volume(Sigma_local_voigt,S_FE_rot,S_CE_rot,V1,V2);

Stress_Fe = [Stress1(1),Stress1(6),Stress1(5);Stress1(6),Stress1(2),Stress1(4);Stress1(5),Stress1(4),Stress1(3)];
Stress_Ce = [Stress2(1),Stress2(6),Stress2(5);Stress2(6),Stress2(2),Stress2(4);Stress2(5),Stress2(4),Stress2(3)];
Stress_Fe_local = Ori_FE' * Stress_Fe * Ori_FE;
Stress_Ce_local = Ori_CE' * Stress_Ce * Ori_CE;
% Transform stress tensor in global CS into local CS.
RSS_fe = F_RSS_Ferrite(Stress_Fe_local);
RSS_fe_abs = abs(RSS_fe);
RSS_ce = F_RSS_Cementite(Stress_Ce_local);
RSS_ce_abs = abs(RSS_ce);
% RSS_max(i,j) = max(RSS_abs);
Pole_plot = [Pole_plot;loc(1),loc(2),max(RSS_fe_abs),max(RSS_ce_abs)];

    end
end
