% This code is to plot the pole figure for given grains.

Quaternions = importdata('/home/kailiu/Documents//Molecular Dynamics/scripts/Orientation/ori.txt'); 
%Here is the path of ori.txt file. 

Num = size(Quaternions,1);
PoleFigureType = [0 1 1];
PoleFigureType = PoleFigureType/norm(PoleFigureType);
parfor i = 1:Num
    RotationMatrix = F_PTMorientation( Quaternions(i,:) );
    Output = PoleFigureType * pinv(RotationMatrix);
    if Output(3) < 0
        Output = Output * -1; %Here is to prevent the projection point from running outside the circle
    end
    Outputall(i,:) = F_vector2pole(Output); %the orientation is norm to (001) plane. 
end
hold on


x_edge = linspace(-1,1,101);
y_edge = linspace(-1,1,101);
ctrs{1}=x_edge;
ctrs{2}=y_edge;
hist_mat = hist3(Outputall,'ctrs',ctrs);
zzz = hist_mat';
zzz = log(zzz); %%%% logarithm of counts at each orientation.
%zi = imagesc(zzz);

for k = 1:101
    for l = 1: 101
        if zzz(k,l) == -Inf || zzz(k,l) == Inf || isnan(zzz(k,l))
               zzz(k,l) = 0;
        end
    end
end
K = (1/4)*ones(2);
zi = conv2(zzz,K,'same'); % Here is to make the point larger, for better visual effect.
contourf(x_edge,y_edge,zi,'LineStyle','none')

%%%%%%%%%%%%%%%%%%%%%Draw the boundary of the pole figure.

