% This code is to plot the Inverse pole figure for given grains.
%Quaternions = [0.0139161 0.0320049 0.366278 0.929851
%-0.0194835 0.00104267 -0.36629 0.930296
%];
Quaternions = importdata('/home/kailiu/Documents//Molecular Dynamics/scripts/Orientation/ori.txt');
Curve = [];
Num = size(Quaternions,1);
parfor i = 1:Num
    RotationMatrix = F_PTMorientation( Quaternions(i,:) );
    Output = F_OrientaionToPole([1 0 0],RotationMatrix)
    Outputall(i,:) = Output(1,:);
end
hold on
for j = 1 : 451
    vector = [(j-1)/450, 1, 1];
    vector = vector./norm(vector);
    Curve(j,:) = F_vector2pole(vector);
end
LargeCurve = Curve.* 1000;
Curve = [[0,0];Curve;[0,0]];

x_edge = linspace(0,0.45,451);
y_edge = linspace(0,0.45,451);
ctrs{1}=x_edge;
ctrs{2}=y_edge;
hist_mat = hist3(Outputall,'ctrs',ctrs);
zzz = hist_mat';
zz = log(zzz); %%%% logarithm of counts at each orientation.
%contourf(x_edge,y_edge,zz)
[xi,yi] = meshgrid(0:0.001:0.45, 0:0.001:0.45);
zi = griddata(x_edge,y_edge,zz,xi,yi);

%%%%%%%%%%%%%%%%%%%%%Draw the boundary of the pole figure.
xx = 1:1:366;
yy = spline(LargeCurve(:,1),LargeCurve(:,2),xx);

for k = 1:451
    for l = 1:366
        if k >= l && k < yy(l)
           if zi(k,l) == -Inf || zi(k,l) == Inf || isnan(zi(k,l))
               zi(k,l) = 0;
           end
        end
    end
end
[C,h] = contourf(xi,yi,zi,10);
h.EdgeColor = 'None'
hold on
plot(Curve(:,1),Curve(:,2))