function [Output,LocalCSYS] = F_OrientaionToPole(Vector,RM)
% This function is to yield 24 positions for one rotation matrix.
% Firstly focus on global 100 direction.
CSYS = RM';
a = CSYS(1,:);
b = CSYS(2,:);
c = CSYS(3,:);
LocalCSYS = [a,b,c;-1*a,-1*b,c;-1*a,b,-1*c;a,-1*b,-1*c;
            a,c,-1*b;a,-1*c,b;-1*a,c,b;-1*a,-1*c,-1*b;
            b,a,-1*c;b,-1*a,c;-1*b,a,c;-1*b,-1*a,-1*c;
            c,a,b;c,-1*a,-1*b;-1*c,a,-1*b;-1*c,-1*a,b;
            b,c,a;b,-1*c,-1*a;-1*b,c,-1*a;-1*b,-1*c,a;
            c,b,-1*a;c,-1*b,a;-1*c,b,a;-1*c,-1*b,-1*a;];
%VectorList = [1 0 0;0 1 0;0 0 1;-1 0 0;0 -1 0;0 0 -1];
VectorList = [1 0 0;-1 0 0]; % Corresponding to 100 direction.
% SignList = [1 1 1
%             1 1 -1
%             1 -1 1
%             1 -1 -1
%             -1 1 1
%             -1 1 -1
%             -1 -1 1
%             -1 -1 -1];
Output=[];


for k = 1:size(VectorList,1)
    VectorTemp = VectorList(k,:);
    for l = 1:size(LocalCSYS,1)
        Temp = VectorTemp * inv([LocalCSYS(l,1:3);LocalCSYS(l,4:6);LocalCSYS(l,7:9)]);
    if Temp(3)>=0 && Temp(2)<= Temp(3) && Temp(1)<= Temp(2) && Temp(1)>=0 && Temp(2)>=0
        result = F_vector2pole(Temp);
        Output = [Output;result];
    end
end
end

