function Angle = F_matrix2Euler(R)
% input:rotation matrix. output:the Euler angle.
% For the same rotation result, the value of Euler angles depends on the 
% sequence of the rotation axis. In this code the sequence is Z-Y-Z,
% according to the https://www.continuummechanics.org/rotationmatrix.html.
% the order of the angles is psi-theta-phi
theta = acos(R(3,3));
psi = atan(R(2,3) / R(1,3));
phi = atan(-1 * R(3,2) / R(3,1));
Angle=[psi,theta,phi];
for i=1:3
    if Angle(1) < 0
        Angle(1) = Angle(1) +  pi;
    end
    if Angle(2) < 0
        Angle(2) = Angle(2) + 2 * pi;
    end
    if Angle(3) < 0
        Angle(3) = Angle(3) +  pi;
    end
end
adder=[0,0,0;1,2,1;1,2,2;2,2,1;2,2,2]*pi;
for i =1:5
    Temp = Angle + adder(i,:);
    [A,B,C] = deal(Temp(1),Temp(2),Temp(3)); 
    RM = [cos(A)*cos(B)*cos(C)-sin(A)*sin(C),-1*cos(A)*cos(B)*sin(C)-sin(A)*cos(C),cos(A)*sin(B); ...
          sin(A)*cos(B)*cos(C)+cos(A)*sin(C),-1*sin(A)*cos(B)*sin(C)+cos(A)*cos(C),sin(A)*sin(B); ...
          -1*sin(B)*cos(C),sin(B)*sin(C),cos(B)];
    error=max(max(RM - R));
    if error < 0.05
        break;
    end
end
Angle = [A,B,C] / pi * 180;