function Youngs = F_YoungsComplianceTensor(S,TheAxis)
% This function is to calculate the Young's modulus along the given
% direction by compliance tensor and a vector.
L1 = TheAxis(1)/norm(TheAxis);
L2 = TheAxis(2)/norm(TheAxis);
L3 = TheAxis(3)/norm(TheAxis);
ReciE = S(1,1)*L1^4+S(2,2)*L2^4+S(3,3)*L3^4 + ...
    (S(4,4)+2*S(2,3))*(L2^2*L3^2)+(S(5,5)+2*S(1,3))*(L1^2*L3^2)+(S(6,6)+2*S(1,2))*(L1^2*L2^2)+ ...
    2*((S(1,4)+S(5,6))*L1^2+S(2,4)*L2^2+S(3,4)*L3^2)*L2*L3+ ...
    2*((S(2,5)+S(4,6))*L2^2+S(1,5)*L1^2+S(3,5)*L3^2)*L1*L3+ ...
    2*((S(3,6)+S(4,5))*L3^2+S(1,6)*L1^2+S(2,6)*L2^2)*L1*L2;
Youngs = 1/ReciE;