function [S,Mises1,Mises2,Hydrostatic1,Hydrostatic2]=F_Stress_IncToMises(RM1,RM2,C11,C12,C44)
% This function is to divide the incompatibility stress into two parts.

%======================Richeton's method start==========================
% S_external = [0 -100 0 0 0 0]';
% [Sigma_inc,~,~] = F_mismatch_stress(S_external,C11,C12,C44,RM2,RM1);
% S = zeros(24,1);
% S(13:18) = 0.5*Sigma_inc + S_external;
% S(19:24) = -0.5*Sigma_inc + S_external;
% 

%======================Direct solve method A start======================
MP_division2=load('/home/kailiu/Documents/Incompatibility stress/FromIncompatibilityStressToStrain.mat');
MP_division2=MP_division2.MP;
Cons_division2=load('/home/kailiu/Documents/Incompatibility stress/Constant.mat');
Cons_division2=Cons_division2.Constant;
[C_iron_tensor,~,~] = Tensor(C11,C12,C44);
S_tensor = Reverse(pinv(Transform9(C_iron_tensor)));

VT = RM1;
VB = RM2;
[VTS,~] = F_rotate_compliance_by_matrix(S_tensor,VT);
VTC = pinv(VTS);
[VBS,~] = F_rotate_compliance_by_matrix(S_tensor,VB);
VBC = pinv(VBS);


Elastic1=VBC;
Elastic2=VTC;
Sigma_Ext = -100;
MP_division2(16:24,:)=zeros(9,24);
MP_division2(1:6,1:6) = Elastic1;
MP_division2(7:12,7:12) = Elastic2;
MP_division2(16,14)=-1;MP_division2(16,20)=1;
MP_division2(17,16)=-1;MP_division2(17,22)=1;
MP_division2(18,18)=-1;MP_division2(18,24)=1;
MP_division2(19,14)=1;
MP_division2(20,16)=1;
MP_division2(21,18)=1;
MP_division2(22,13)=1;MP_division2(22,19)=1;
MP_division2(23,15)=1;MP_division2(23,21)=1;
MP_division2(24,17)=1;MP_division2(24,23)=1;
Cons_division2(16,1) = 0;
Cons_division2(17,1) = 0;
Cons_division2(18,1) = 0;
Cons_division2(19,1) = Sigma_Ext;
Cons_division2(20,1) = 0;
Cons_division2(21,1) = 0;

S = pinv(MP_division2) * Cons_division2;

Mises1 = (0.5 * ((S(13)-S(14))^2+(S(14)-S(15))^2+(S(15)-S(13))^2+6*(S(16)^2+S(17)^2+S(18)^2)))^0.5;
Mises2 = (0.5 * ((S(19)-S(20))^2+(S(20)-S(21))^2+(S(21)-S(19))^2+6*(S(22)^2+S(23)^2+S(24)^2)))^0.5;
Hydrostatic1 = (S(13)+S(14)+S(15))/3;
Hydrostatic2 = (S(19)+S(20)+S(21))/3;

